
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// necessite : personnage.inc, grille.inc, sol.inc, boule.inc ou Planeur.inc, fog.inc
// image map et material map : barriere.gif, bulle.gif et yy.gif
// Date:02/98
// Auth:Denis
// meme scene pour planeur ou boules, l'un ou l'autre sur les interrupteurs

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "Glass.inc"
//*********interrupteur on/off = 1 / 0
#declare Personnage = 1
#declare bouleR     = 0
#declare Sol        = 1
#declare Grille     = 1
#declare Ciel       = 1
#declare Fog        = 1
#declare Plane      = 1


#declare r1 = seed ( 230 )

//****************light
 //create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color Gray80
  translate <-20, 4000, -300>
}
light_source
{
  0*x // light's position (translated below)
  color <1, 0.3, 0.3>
  translate <0, 4, 500>
}

// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color Light_Purple
  translate <1000, 800, 1500>
}

light_source
{
  0*x // light's position (translated below)
  color Gold
  area_light
  <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
  6, 6                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 1          // 0,1,2,3...
  jitter              // adds random softening of light
  translate <400, 8000, 10000>   // <x y z> position of light
}

//*******************camera
#declare C1 = camera
{
  location  <.0 , 2 ,-10.0>
  look_at   <0.0 , 1 , 0.0>
  angle 40
}

#declare C1b = camera
{
  location  <0, 2 , -10.0>
  look_at   <0, 1.0 , 0.0>
  angle 35
}
#declare C1h = camera
{
  location  <0 , 2.0 ,-10.0>
  look_at   <0 , 1.0 , 0.0>
  angle 35
  aperture 0.07
  focal_point <0.0 , 1.0 , -1>
  blur_samples 100

}

camera { C1b }
//******************sol
#if ( Sol = 1 )
#include "sol.inc"
#end
//*************************************************grille

#if ( Grille = 1 )
#include "grille.inc"
#end
//**************************************************Ciel
#if ( Ciel = 1 )
#include "Skies.inc"
sky_sphere { S_Cloud2 }
#end
//***************************************************Brume
#if ( Fog = 1 )
#include "fog.inc"
#end
//***************************************************boule
#if (bouleR = 1)
#include "boule.inc"
#end
//**************************************************personnage
 #if ( Personnage = 1 )
      #include "personnage.inc"
      #end
//*************************************************planeur
#if (Plane = 1)
#include "Planeur.inc"
#end

