
//hale.pov          21/1/98                  1/2/98
              
#include "colors.inc"   
#include "finish.inc"   

camera {
        location < 4, -4.9, -15 > 
        look_at  < 0, 3, 0 > 
        angle 87
        }
// LIGHTS
light_source { < -7, -3, 0 > color rgb < 0.3, 0.3, 0.6 > }      // blue
light_source { < -4, -8, -10 > color Gray20           // left low
                fade_distance 6
                fade_power 2
                shadowless
              }    
light_source { < 15, 3, -8 > color Gray20          // far right
                fade_distance 8
                fade_power 3
                shadowless
              }
light_source { < -6, 12, -15 > color Orange      // for diffusion of red
               spotlight
               point_at < -8, 18.25, -6 >
               falloff 80
               radius 50 
               tightness 10 
               }             
light_source { < 10, 17, -5 > color Gray50      // for  cage
               spotlight
               point_at < 0, 12, 0 >
               falloff 80
               radius 50 
               tightness 10 
               }             

light_source { < 0, 18.5, 0 > color Gray25 }         // top
light_source { < -8, 18, -4 > color Red 
               looks_like {
                          sphere { < 0, 0, 0 >,0.3
                                   pigment { color Orange }
                                   finish { ambient 1
                                            diffuse 0
                                          }
                                 }
                           }
            }
light_source { < 10, -4, -14 > color rgb < 0.5, 0.5, 0.4 > 
                fade_distance 8
                fade_power 3  
             }                                          // right of camera
light_source { < -10, -3, -14 > color Gray35 
                fade_distance 5
                fade_power 3  
             }                                          // left of camera

light_source { < 0, 0, 12 > color Gray40 shadowless }   // beyond scope 

// THE DOME
#declare Top =                             // to cut hole in top of dome
       difference {
                    box { < -25, -20, -25 >,< 25, 21, 25 > }
                 union {
                    box { < -25, 17, -4 >,< 25, 21, 4 > }
                    box { < -25, 17, -4 >,< 25, 21, 4 > 
                            rotate 60*z }
                        } 
                    }
#declare Rail =                             // handrails
             union {
                   cylinder { < 0, 0, 0 >,< 0, 1, 0 >,0.03 }
                   cylinder { < 0, 0.5, 0 >,< 2, 0.5, 0 >,0.03 }
                   cylinder { < 0, 1, 0 >,< 2, 1, 0 >,0.03 }
                      pigment { color Yellow }
                   }
difference {                                           // "skylight" frame
            box { < -13, 17.25, -4 >,< 13, 19.5, 4 > }
            box { < -13.1, 16, -3.3 >,< 12, 20, 3.3 > }
               pigment { color Gray75 }
               finish { ambient 0.2 }
             
                }
cylinder { < -16, 17, -3.6 >,< 14, 17, -3.6 >,0.15  
               pigment { color White }
         }
box { < -3, 16.7, -4 >,< -1.8, 17.5, -3.2 >
         pigment { color rgb < 0.76, 0.5, 0.5 > }
         finish { ambient 0.2 }
    }
box { < -13, 18.5, 4 >,< 13, 19, 3 >
         pigment { color rgb < 0.76, 0.5, 0.5 > }
         finish { ambient 0.2 }
    }


object { Rail translate < 0, 19.5, 3.3 > }
object { Rail translate < 2, 19.5, 3.3 > }  
object { Rail translate < 4, 19.5, 3.3 > }  
object { Rail translate < 6, 19.5, 3.3 > }
object { Rail translate < 8, 19.5, 3.3 > }  
object { Rail translate < 10, 19.5, 3.3 > }  

object { Rail translate < -2, 19.5, 3.3 > }  
object { Rail translate < -4, 19.5, 3.3 > }  
object { Rail translate < -6, 19.5, 3.3 > }
object { Rail translate < -8, 19.5, 3.3 > }  
object { Rail translate < -10, 19.5, 3.3 > }  

#declare Fram =
               union { 
                     box { < 12.3, 14.9, 3.6 >,< 13.5, 15.6, 2.4 > }
                     box { < 12.3, 14.9, 2.1 >,< 13.5, 15.6, 0.9 > } 
                     box { < 12.3, 14.9, 0.6 >,< 13.5, 15.6, -0.6 > } 
                     box { < 12.3, 14.9, -0.9 >,< 13.5, 15.6, -2.1 > } 
                     box { < 12.3, 14.9, -2.4 >,< 13.5, 15.6, -3.6 > } 
                       pigment { color Gray75 }
                       finish { ambient 0.2 }
                     }
difference {
        box { < 12, 15, -5 >,< 20, 19, 5 > }               // motor housing ?
        object { Fram }
              pigment { color rgb < 0.6, 0.5, 0.5 > }
           }

#declare Guide =                                // rib down side of dome
difference {
           cylinder { < 0, 0, -0.35 >,< 0, 0, 0.35 >,21 }
           cylinder { < 0, 0, -1 >,< 0, 0, 1 >,19.75 }
             clipped_by {
                         box { < 9, 0, -2 >,< 25, 25, 2 > }
                        }
                  pigment { color Gray75 }
                  finish { ambient 0.2 }
          }
object { Guide translate 3.65*z }
object { Guide translate -3.65*z }
object { Guide rotate 180*y translate 3.65*z }
object { Guide rotate 180*y translate -3.65*z }

box { < 7, 19.6, -8 >,< 14, 20, 8 >         // walkway ?
       pigment { checker color Gray80 color Gray85  scale 1.5 }
    }
#declare Door =                              // dome shutters
             difference {
                   cylinder { < 0, 0, 0 >,< 0, 0, 3 >,25 }
                   cylinder { < 0, 0, -1 >,< 0, 0, 6 >,23.5 }
                     pigment { checker color Gray65 
                                       color rgb < 0.63, 0.63, 0.64 > 
                                scale < 0.75, 1, 4 > }
                        }
union {
box { < -20, 19, 4.3 >,< 20, 26, 4.8 >  }               // shutter wall
box { < -20, 19, 4.3 >,< 20, 26, 4.8 >  rotate 60*z }
        pigment { checker color Gray90 color Gray95 scale < 1, 5, 1 > }
        finish { ambient 0.3 }
      }
object { Door translate 0.1*z }
object { Door translate -3.1*z }
#declare Dome =
            
sphere { < 0, 0, 0 >,1    
          pigment {
                  image_map {
                              gif "mod03.gif"
                              map_type 1
                             }
                  }
          finish { ambient 0.2 
                   diffuse 0.2
                   reflection 0.2 }
          scale 21
          clipped_by {
                      object { Top rotate -5*z }
                     }
       }
object { Dome }

// FLOOR
plane { y, -8.5                                       // floor
        pigment { color rgb < 1, 0.9, 0.5 > }
      }
// TEXTURE
#declare Tel =
             texture {
                      pigment { color rgb < 1, 0.85, 0.56 > }
                      finish { phong 1   
                               phong_size 60
                               ambient 0.15 }
                      }
// HOLES
#declare Ball =
              sphere { < 0, 0, 0 >,0.3
                      translate < 5.6, 0, 0.5 >
                      pigment { color Gray10 }
                     }
#declare Fall =
              sphere { < 0, 0, 0 >,0.15
                      translate < 3.17, -5.1, 0 >
                      pigment { color Gray10 }
                     }
#declare Zall =
              sphere { < 0, 0, 0 >,0.08
                     pigment { color Gray10 }
                     }


// THE TELESCOPE TUBE

#declare Ring =
               difference {  
                          cylinder { < 0, 0.6, 0 >,< 0, -0.8, 0 >,3.35 }
                          cylinder { < 0, 0.7, 0 >,< 0, -1, 0 >,2.6 }
                          texture { Tel }
                          }
                            
#declare Wgt =                      
              union {
                    box { < 0.05, -0.1, -0.12 >,< 0.2, 5, 0.12 > }
                    box { < -0.05, -0.1, -0.12 >,< -0.2, 5, 0.12 > }  
                    texture { Tel }
                    }
#declare Gird =
             difference {
                box { < 0.18, 0, 0.18 >,< -0.18, 4.7, -0.18 > 
                      texture { Tel }
                    }
                object { Wgt }
                        }
#declare Brak =
            box { < -0.5, 0, -0.1 >,< 0, 0.55, 0.1 >
                    rotate -31*z
                    translate < 2.8, -6, 0 >
                     texture { Tel } 
                }     
#declare Fold =
               union {
                      cone { < 0, -5, 0 >,3,< 0, -6, 0 >,2.8 }
                      object { Brak }
                      object { Brak rotate 45*y }
                      object { Brak rotate 90*y }
                      object { Brak rotate 135*y }
                      object { Brak rotate 180*y }
                      difference {
                      cone { < 0, -4.8, 0 >,3.35,< 0, -5.5, 0 >,3.1 }
                      cylinder { < 0, -4.7, 0 >,< 0, -5.6, 0 >,2.9 } 
                                 }
                      texture { Tel }
                      }
#declare Holdr =
               difference {
                    object { Fold }
                    union {
                          object { Fall }
                          object { Fall rotate 30*y } 
                          object { Fall rotate 60*y }
                          object { Fall rotate 90*y }
                          object { Fall rotate 120*y }
                          object { Fall rotate 150*y }
                          object { Fall rotate 180*y }
                          }
                          }
#declare Ping =
           difference {
                      cylinder { < 0, -4.9, 0 >,< 0, -5.5, 0 >,3.4 }
                      cylinder { < 0, -4.7, 0 >,< 0, -5.6, 0 >,2.9 } 
                                 texture { Tel }
                      }

#declare Vee =
               union {
                      object { Gird rotate < 9, -25, -25 >
                               translate < 0.25, -5, -3.2 >
                             }
                      object { Gird rotate < 9, 25, 25 >
                               translate < -0.25, -5, -3.2 >
                             }  
             difference {
                   box { < -0.5, 0, -0.18 >,< 0.5, 0.5, 0.18 >
                          translate < 0, -4.9, -3.12 >
                          texture { Tel }
                       }
                   object { Zall translate < 0, -4.65, -3.3 >  }
                        }
                     }
#declare Unit_A =
                union {
                       object { Ring }
                       object { Holdr }
                       object { Vee }
                       object { Vee rotate 90*y }
                       object { Vee rotate -90*y } 
                       object { Vee rotate 180*y } 
                       cylinder { < 0, 0, 0 >,< 0, -6, 0 >,0.4 
                             texture { Tel }
                                }
                       }
#declare Unit_B =
                union {
                       object { Ring }
                       object { Ping }
                       object { Vee }
                       object { Vee rotate 90*y }
                       object { Vee rotate -90*y } 
                       object { Vee rotate 180*y } 
                       }
#declare Zing =
           difference {
                      cylinder { < 0, 0, 0 >,< 0, 0.43, 0 >,3.4 }
                      cylinder { < 0, -0.1, 0 >,< 0, 0.5, 0 >,2.9 } 
                                 texture { Tel }
                      }
#declare Long =
               box { < 0.15, 0, 0.15 >,< -0.15, 3.5, -0.15 >
                     translate < 0, 0, -3.2 >
                     texture { Tel } 
                   }  
#declare Cross =                   
               union { 
                     box { < 0.1, -2, 0.1 >,< -0.1, 2, -0.1 > 
                          rotate 33*z
                          texture { Tel } 
                         } 
                     box { < 0.1, -2, 0.1 >,< -0.1, 2, -0.1 > 
                          rotate -33*z
                          texture { Tel } 
                         } 
                         translate < 0, 1.95, -3 >
                     }
#declare Focus =
             difference {
                      cylinder { < 0, 1, 0 >,< 0, 5.7, 0 >,0.71 
                                   texture { Tel }
                               }
                      cylinder { < 0, -0.1, 0 >,< 0, 5.8, 0 >,0.61 }
                                  pigment { color Gray40 } 
                        }
#declare Struts =
               union {
                     cylinder { < 0, 4.5, -0.7 >,< 0, 3.75, -2.9 >,0.01 }
                     cylinder { < 0, 3.75, -2.9 >,< 0, 3, -0.7 >,0.01 } 
                     cylinder { < 0, 3, -0.7 >,< 0, 2.25, -2.9 >,0.01 } 
                     cylinder { < 0, 2.25, -2.9 >,< 0, 1.5, -0.7 >,0.01 } 
                      texture { Tel }  
                     }
#declare Cage =                   
              union { 
                     object { Zing }
                     object { Zing translate 3.5*y }
                     object { Focus }
                     object { Struts }
                     object { Struts rotate 90*y } 
                     object { Struts rotate 180*y } 
                     object { Struts rotate -90*y } 
                     object { Long }
                     object { Long rotate 45*y }
                     object { Long rotate 90*y }  
                     object { Long rotate 135*y }  
                     object { Long rotate 180*y }  
                     object { Long rotate -45*y }  
                     object { Long rotate -90*y }  
                     object { Long rotate -135*y }  
                     object { Cross rotate -22.5*y }
                     object { Cross rotate -67.5*y } 
                     object { Cross rotate -112.5*y } 
                     object { Cross rotate -157.5*y } 
                     object { Cross rotate -202.5*y } 
                     object { Cross rotate -247.5*y } 
                     object { Cross rotate -292.5*y } 
                     object { Cross rotate -337.5*y } 
                     }
#declare Tube =
           union {
object { Unit_A }
object { Unit_B scale < 1, 1.1, 1 > rotate 180*z translate 1*y }
object { Cage translate 7.08*y } 
                 }

object { Tube rotate  -10*z  }                  

// THE TELESCOPE MOUNTINGS
#declare Trak =
       difference { 
                 union {
                        box { < -5.5, -9.25, -0.65 >,< 5.5, -6.6, 0.65 > }
                        box { < -1, -1, -0.65 >,< 1, 1, 0.65 >
                              rotate 50*z
                              translate < -4.1, -6.4, 0 >
                            }
                        box { < -1, -1, -0.65 >,< 1, 1, 0.65 >
                              rotate -50*z
                              translate < 4.1, -6.4, 0 >
                            }
                              pigment { color rgb < 0.5, 0.5, 0.55 > } 
                              finish { ambient 0.1
                                       phong 1
                                       phong_size 20
                                     }  
                        }
                   cylinder { < 0, 0, 1 >,< 0, 0, -1 >,7.1
                            texture { Tel } 
                            }
                    }
#declare Xgt =                      
              union {
                    box { < 0.05, -0.1, -0.12 >,< 0.2, 5, 0.12 > }
                    box { < -0.05, -0.1, -0.12 >,< -0.2, 5, 0.12 > }  
                              pigment { color rgb < 0.5, 0.5, 0.55 > } 
                              finish { ambient 0.1
                                       phong 1
                                       phong_size 20
                                     }  
                     
                    }
#declare Fird =
             difference {
                box { < 0.18, 0, 0.18 >,< -0.18, 4.7, -0.18 > 
                              pigment { color rgb < 0.5, 0.5, 0.55 > } 
                              finish { ambient 0.1
                                       phong 1
                                       phong_size 20
                                     }  
                      
                    }
                object { Xgt }
                        }

#declare Brace =
              object { Fird rotate < 180, 90, 0 > scale < 1.6, 3, 1.6 >  }
                       
object { Brace rotate 60*x translate < -11, -3.6, 5 > }                    

#declare Leg =
             cone { < 0, 0.2, 0 >,0.7,< 0, -11, 0 >,2.1
                     scale < 0.3, 1, 1 >
                     rotate -40*x
                     pigment { color rgb < 0.5, 0.5, 0.55 > } 
                     finish { ambient 0.1
                              phong 1
                              phong_size 20
                            } 
                  }
#declare Outa =                                    // holes in the "shoe"
            union {
                   object { Ball rotate -20*z }
                   object { Ball rotate -40*z } 
                   object { Ball rotate -70*z }
                   object { Ball rotate -110*z }
                   object { Ball rotate -140*z }
                   object { Ball rotate -160*z }

                   cylinder { < 0, 0, 1 >,< 0, 0, -1 >,4 }
                   box { < -4, 0, 1 >,< 4, 8, -1 > }
                     texture { Tel }
                  }
#declare Seam =
               cylinder { < 4, 0, 0.5 >,< 7, 0, 0.5 >,0.04
                              pigment { color rgb < 0.5, 0.5, 0.55 > } 
                              finish { ambient 0.1
                                       phong 1
                                       phong_size 20
                                     }
                         }
#declare Shoe =
        union {
            difference { 
                   union {
                   cylinder { < 0, 0, 0.5 >,< 0, 0, -0.5 >,7.1 
                              pigment { color rgb < 0.5, 0.5, 0.55 > } 
                              finish { ambient 0.1
                                       phong 1
                                       phong_size 20
                                     }
                            }
                   cylinder { < 0, 0, 0.4 >,< 0, 0, -0.4 >,7.15 
                              pigment { color rgb < 0.4, 0.4, 0.5 > } 
                              finish { phong 1 }
                            }  
                         }   
                   object { Outa }
                        }
               object { Trak }
               object { Leg translate < -5.26, -8.25, 0.25 > }
               object { Leg translate < 5.26, -8.25, 0.25 > }
               object { Seam rotate -30*z }
               object { Seam rotate -150*z } 
                }
#declare Cradle =
                union {
object { Shoe rotate 90*y translate -8*x }
cylinder { < 0, 0, -6 >,< 0, 0, -7 >,0.3 
             pigment { color Gray35 }                // bearing
         }               
cylinder { < -8, 0, 5.55 >,< 8, 0, 5.55 >,1.43  }       // main tube
cylinder { < -8, 0, -5.55 >,< 8, 0, -5.55 >,1.43 }      // main tube
cylinder { < 0, 0, -4 >,< 0,0, -4.12 >,2 }
torus { 1.413, 0.04 scale < 1, 2, 1 >
        rotate 90*z translate < 1.5, 0, -5.55 > }     // weld
torus { 1.413, 0.04  scale < 1, 2, 1 >
        rotate 90*z translate < -1.5, 0, -5.55 > }    // weld 
torus { 1.413, 0.045 scale < 1, 2, 1 > 
        rotate 90*z translate < 7.6, 0, -5.55 > }      // weld 
difference {
         cylinder { < 7.6, 0, 5.55 >,< 8.6, 0, 5.55 >,1.43 }       // end cap
         box { < -0.5, -2, -2 >,< 0.5, 2, 2 >
               rotate -45*y  translate < 8.6, -0.1, 7.1 >  }
           }
difference {
         cylinder { < 7.6, 0, -5.55 >,< 8.6, 0, -5.55 >,1.43 }     // end cap
         box { < -0.5, -2, -2 >,< 0.5, 2, 2 >
               rotate 45*y  translate < 8.6, -0.1, -7.1 >  }
           }                                                 
cylinder { < 10, 0, 0 >,< 10.7, 0, 0 >,2.43  }            // end wheel
cylinder { < 8.6, 0, 0 >,< 9, 0, 0 >,1.5  }               //  wheel  
cylinder { < 9, 0, 0 >,< 10.6, 0, 0 >,1   }    //  S bearing    
box { < 9, 0, 3 >,< 10, -9, 2.5 >   
     }                                                        // S pier  
box { < 9, 0, -3 >,< 10, -9, -2.5 >   
     }                                                        // S pier  
box { < 9, 0.25, -3 >,< 10, -0.25, 3 >     
        rotate 40*x
        translate -3*y
    }
box { < 9, 0.25, -3 >,< 10, -0.25, 3 >                  // S pier X
        rotate -40*x
        translate -3*y
    }
     

box { < 9, 1, 3 >,< 10, -6, -3 > 
       rotate 50*z  translate < 4.5, -8, 0 > }                 // S pier   
triangle { < 9.5, 0, -3 >,< 9.5, -7, -3 >,< 18, -7, -3 > }       
cylinder { < 7.4, 0, 0 >,< 8.6, 0, 0 >,1.5    scale < 1, 1.2, 4 >  }
cylinder { < -8, 4.25, -5 >,< 8.6, 1, -5 >,0.225  }       // brace
cylinder { < -8, -4.25, -5 >,< 8.6, -1, -5 >,0.225  }     // brace
cylinder { < -8, 4.25, 5 >,< 8.6, 1, 5 >,0.225   }        // brace
cylinder { < -8, -4.25, 5 >,< 8.6, -1, 5 >,0.225  }       // brace
cylinder { < 0, 0, -5.55 >,< 0, -2.5, -5 >,0.13   }        // short brace
cylinder { < 0, 0, -5.55 >,< 0, 2.5, -5 >,0.13  }           // short brace
             texture { Tel } 
                     }
object { Cradle rotate -33*z }

// ITEMS INSIDE THE DOME
#declare Drum =
             superellipsoid { < 1, 0.6 >  rotate 90*x
                             scale < 0.5, 1, 0.5 >
                             pigment { color Gray60 }
                             finish { ambient 0.2 }
                             }
union {
cylinder { < -7, -4.5, -7 >,< -7, -12, -7 >,3  }       // tank ?
torus { 3, 0.03  translate < -7, -5, -7 > }
cylinder { < -7, -5.5, -7 >,< -3.95, -5.5, -7 >,0.25 }
           texture { Tel }  
           }
union {
       box { < -0.5, 0, -0.5 >,< 0.5, 1.85, 0.5 >     // locker
                     translate < -4.3, -7, -9.2 >
                     pigment { color Gray45 }
                     finish { ambient 0.2 
                              reflection 0.25 }
           }
       box { < 0.5, 0, 0.5 >,< 0.52, 2, 0.52 >     
                     translate < -4.3, -7, -9.2 >
                     pigment { color White }
                     finish { ambient 0.2  }
          }  
      }
#declare Gas =
           union {
                 cylinder { < 0, 0, 0 >,< 0, 1.5, 0 >,0.1 }
                 sphere { < 0, 1.5, 0 >,0.1 }
                 cylinder { < 0, 1.5, 0 >,< 0, 1.7, 0 >,0.025 }
                      pigment { color Gray80 }
                      finish { ambient 0.2 }
                 }
object { Gas translate < -3.9, -7, -8 > }
object { Gas translate < -3.9, -7, -8.25 > }       
object { Rail rotate 90*y translate < -3.76, -7, -7.8 > } 
object { Rail rotate 180*y translate < -2, -7, -4 > }
object { Rail rotate 180*y translate < -4, -7, -4 > }      
object { Rail rotate -90*y translate < -2, -7, -6 > }  
object { Rail rotate -90*y translate < -2, -7, -8 > }  
object { Rail rotate -90*y translate < -2, -7, -10 > }    
difference {
           cylinder { < 0, -5.5, 0 >,< 0, -12, 0 >,21 }
           cylinder { < 0, -4, 0 >,< 0, -13, 0 >,12 }     // ring walk
           texture { Tel } 
           }
#declare Sectn =
object { Rail rotate 5*y translate < 0, -5.5, 12 > }

object { Sectn }
object { Sectn rotate 9*y }
object { Sectn rotate 18*y }
object { Sectn rotate 27*y }
object { Sectn rotate -9*y }
object { Sectn rotate -18*y }
object { Sectn rotate -27*y }
object { Sectn rotate 36*y }
object { Sectn rotate 45*y }
object { Sectn rotate 54*y }
object { Sectn rotate 63*y }
object { Sectn rotate 72*y }
object { Sectn rotate 81*y } 
object { Sectn rotate -36*y }
object { Sectn rotate -45*y }
object { Sectn rotate -54*y }   
object { Sectn rotate -63*y } 
                             
difference {
           cylinder { < 0, -5.75, 0 >,< 0, -6.3, 0 >,12 }
           cylinder { < 0, -4, 0 >,< 0, -7, 0 >,11.9 }     // ring band
           pigment { color rgb < 0.6, 0.6, 0.66 > } 
           }

box { < -11, -6, -7 >,< -12, -3, 7 >
        pigment { color Gray25 }            // room (?) behind shoe track
    }
#declare Hose =
              torus { 0.5, 0.018  rotate 90*x
                     clipped_by {
                              box { < -1, 0, -1 >,< 1, -1, 1 > }
                                }
                     scale < 0.8, 3.3, 0.8 >
                     pigment { color Gray45 }
                     }

#declare Stand =
             union {
                   object { Drum scale < 0.5, 0.2, 0.5 >
                                   translate < -0.3, 2.3, 0.1 > }
                   object { Drum scale 0.4 translate < 0, 0.4, -0.5 > }
                   object { Hose translate < 0.25, 2, -0.75 > }
                   object { Hose scale < 0.8, 1.25, 0.8 >
                              translate < -0.1, 2, -0.75 > } 
                   object { Hose scale < 0.8, 1.25, 0.8 >
                              rotate 90*y
                              translate < 0.75, 2, -0.25 > } 

                   box { < -0.75, 2, -0.75 >,< 0.75, 2.1, 0.75 >     // top
                            pigment { color rgb < 0.5, 0.45, 0.4 > }
                         }
                   cylinder { < -0.75, 0, -0.75 >,< -0.75, 2, -0.75 >,0.04
                                 pigment { color Yellow }
                              }
                   cylinder { < -0.75, 0, 0.75 >,< -0.75, 2, 0.75 >,0.04
                                 pigment { color Yellow }
                              }
                   cylinder { < 0.75, 0, -0.75 >,< 0.75, 2, -0.75 >,0.04
                                 pigment { color Yellow }
                              }
                   cylinder { < 0.75, 0, 0.75 >,< 0.75, 2, 0.75 >,0.04
                                 pigment { color Yellow }
                              }
                   cylinder { < -0.35, 0, -0.75 >,< -0.35, 2, -0.75 >,0.04
                                 pigment { color Yellow }
                              }
                cylinder { < -0.75, 0.33, -0.75 >,< -0.35, 0.33, -0.75 >,0.03
                                 pigment { color Yellow }
                              }
                cylinder { < -0.75, 0.66, -0.75 >,< -0.35, 0.66, -0.75 >,0.03
                                 pigment { color Yellow }
                              }
                cylinder { < -0.75, 0.99, -0.75 >,< -0.35, 0.99, -0.75 >,0.03
                                 pigment { color Yellow }
                              }
                cylinder { < -0.75, 1.33, -0.75 >,< -0.35, 1.33, -0.75 >,0.03
                                 pigment { color Yellow }
                              }
                cylinder { < -0.75, 1.66, -0.75 >,< -0.35, 1.66, -0.75 >,0.03
                                 pigment { color Yellow }
                              }
                        }
object { Stand rotate -15*y translate < -6.75, -4.5, -6.75 > }
#declare Boks =                                          // box?
box { < -1, 0, -1 >,< 1, 2.8, 1 >
      pigment { color rgb < 0.9, 0.8, 0.6 > }
      finish { ambient 0.3 }
    }
object { Boks rotate 15*y translate < -5.6, -8.5, -2.8 > }
object { Boks  scale < 1.5, 1, 1 > translate < 2, -8.5, 11 > } 
object { Boks  scale 0.25 translate < -6, -5.72, -3 > }    
object { Boks  scale < 1.2, 0.6, 0.3 > translate < 0, -8.5, 11.3 > 
                          rotate -45*y } 
object { Boks  scale < 1.5, 1, 1 > translate < 5, -9.2, 10.45 > } 
box { < -2, 0, -0.45 >,< 2, 0.2, 0 >   rotate 30*z       // stairs
             translate < 2, -7.7, 10 >
        pigment { color rgb < 0.4, 0.4, 0.3 > }
    }
object { Drum scale 0.65 translate < 3,  -7.95, 9.75 > }
#declare Hoist =
               union {
                     cylinder { < 0, 0, 0 >,< 0, 2, 0 >,0.1 }
                     cylinder { < 0, 2, 0 >,< 1, 2, 0 >,0.04 }
                     cylinder { < 0, 0.6, 0 >,< 1, 2, 0 >,0.04 }
                     cylinder { < -0.6, 0, 1 >,< 0, 2, 0 >,0.04 } 
                     cylinder { < 1, 0, 0 >,< 0, 2, 0 >,0.04 } 
                     cylinder { < 1, 1.76, -0.01 >,< 1, 1.76, 0.01 >,0.1 
                                 pigment { color Gray10 }
                              }
                     cylinder { < 1, 0.66, -0.01 >,< 1, 0.66, 0.01 >,0.1 
                                 pigment { color Gray10 }
                              }
                     cylinder { < 0.9, 1.96, 0 >,< 0.9 0.66, 0 >,0.01 }
                     cylinder { < 1.1, 1.96, 0 >,< 1.1, 0.66, 0 >,0.01 }
                       pigment { color Yellow }
                       }
object { Hoist translate < -6, -4.5, -5 > }
#declare Ladder =
           union {
                cylinder { < -0.75, 0.33, -0.75 >,< -0.35, 0.33, -0.75 >,0.03
                                 pigment { color Yellow }
                              }
                cylinder { < -0.75, 0.66, -0.75 >,< -0.35, 0.66, -0.75 >,0.03
                                 pigment { color Yellow }
                              }
                cylinder { < -0.75, 0.99, -0.75 >,< -0.35, 0.99, -0.75 >,0.03
                                 pigment { color Yellow }
                              }
                cylinder { < -0.75, 1.33, -0.75 >,< -0.35, 1.33, -0.75 >,0.03
                                 pigment { color Yellow }
                              }
                cylinder { < -0.75, 1.66, -0.75 >,< -0.35, 1.66, -0.75 >,0.03
                                 pigment { color Yellow }
                              }
                cylinder { < -0.75, 2, -0.7 >,< -0.35, 2, -0.7 >,0.06
                                 pigment { color Yellow }
                              }

                cylinder { < -0.75, 0, -0.75 >,< -0.75, 2, -0.75 >,0.04
                                 pigment { color Yellow }
                              }
                cylinder { < -0.35, 0, -0.75 >,< -0.35, 2, -0.75 >,0.04
                                 pigment { color Yellow }
                              }
                 }
object { Ladder translate < 9, -7.5, -2.5 > }
box { < 8.9, -5.75, -3.55 >,< 15, -5.5, -3 >         // right of S Pier
       texture { Tel }
    }
object { Rail translate < 9, -5.5, -3.55 > }
#declare StRail =                             // stair handrails
             union {
                   cylinder { < 0, 0, 0 >,< 2, 0, 0 >,0.03 
                               rotate 30*z 
                               translate 1*y }
                   cylinder { < 0, 0, 0 >,< 2, 0, 0 >,0.03 
                               rotate 30*z 
                               translate 0.5*y }
                   cylinder { < 0, 0, 0 >,< 0, 1, 0 >,0.03 }
                      pigment { color Yellow }
                   }
object { StRail translate < 0, -8.5, 9.55 > }
object { StRail translate < 1.154, -7.84, 9.55 > } 
object { StRail translate < 2.308, -7.18, 9.55 > }  
object { Rail translate < 4.06, -6.22, 9.55 > }   
object { Rail translate < 5.06, -6.22, 9.55 > } 

#declare Man =
         union {
              sphere { < 0, 0, 0 >,0.22 scale < 0.6, 0.9, 0.6 >    // head
                      translate < 0.15, 1.74, 0 >
                      pigment { color Gray70 }
                     }
              sphere { < 0, 0, 0 >,0.21 scale < 0.6, 0.9, 0.6 >    // face
                      rotate 15*z
                      translate < 0.15, 1.72, 0 >
                      pigment { color rgb < 0.9, 0.8, 0.7 > }
                      finish { ambient 0.25 }
                     }
              sphere { < 0, 0, 0 >,0.065 scale < 1, 0.9, 0.16 >    // hand 
                      translate < 0.45, 0.85, -0.25 >
                      pigment { color rgb < 0.9, 0.8, 0.7 > }
                      finish { ambient 0.25 }
                     }
              box { < -0.15, 0, -0.01 >,< 0.15, -0.2, 0.01 >     // papers
                     rotate 40*z
                     translate < 0.45, 0.85, -0.23 >
                     pigment { color White }
                  }

              sphere { < 0, 0, 0 >,0.39 scale < 0.5, 1, 0.75 >    // trunk         
                      rotate -15*z
                      translate < -0.05, 1.25, 0 >
                      pigment { color Gray95 }
                      finish { ambient 0.2 }
                     }
              sphere { < 0, 0, 0 >,0.1 translate < 0, 1.4, -0.2 >
                      pigment { color Gray95 }
                      finish { ambient 0.2 }                    // shoulder
                   }
              sphere { < 0, 0, 0 >,0.1 translate < 0, 1.4, 0.2 >
                      pigment { color Gray95 }
                      finish { ambient 0.2 }                    // shoulder
                   }


              cone { < 0, 1.4, -0.2 >,0.1,< 0.15, 1.1, -0.25 >,0.05 
                      pigment { color Gray95 }
                      finish { ambient 0.2 }                    // upper arm
                   }
              cone { < 0.15, 1.1, -0.25 >,0.05,< 0.4, 0.85, -0.25 >,0.025 
                      pigment { color Gray95 }
                      finish { ambient 0.2 }                    // forearm
                   }
              cone { < 0, 1.4, 0.2 >,0.1,< -0.06, 0.85, 0.35 >,0.025 
                      pigment { color Gray95 }
                      finish { ambient 0.2 }                    // left arm
                   }

              sphere { < 0, 0, 0 >,0.19  scale < 1, 1, 1.45 >     // hips
                       translate < -0.1, 0.95, 0 >
                     }
              // legs  
              sphere { < 0, 0, 0 >,0.045 scale < 3, 1, 1 >      // foot
                       translate < 0, 0.05, 0.13 >
                       pigment { color Gray85 }
                     }
              sphere { < 0, 0, 0 >,0.045 scale < 3, 1, 1 >      // foot
                       rotate -20*z
                       translate < -0.2, 0.05, -0.13 >
                       pigment { color Gray85 }
                     }

              sphere { < 0, 0, 0 >,0.08 translate < 0.1, 0.5, -0.13 > }
              cone { < -0.1, 1, -0.13 >,0.12,< 0.1, 0.49, -0.13 >,0.08 }
              cone { < 0.1, 0.5, -0.13 >,0.08,< -0.28, 0.1, -0.13 >,0.05 }
              cone { < -0.1, 1, 0.13 >,0.12,< -0.05, 0, 0.13 >,0.05  } // left
                      pigment { color rgb < 0.6, 0.6, 0.8 > }
                      finish { ambient 0.2 }
                }
              


object { Man rotate 8*z translate < 0, -5.5, 12.5 > rotate -55*y }

