// Persistence Of Vision Raytracer version 3.0 file.

#include "colors.inc"
#include "textures.inc"
#include "earth3.inc"
#include "hst.inc"

camera {
        location <25, 0, 0>
        direction <-2, 0,  0>
        look_at <0, 0, 0>
}

light_source {<-1600, -200, 1800> color rgb <.75, .85, 1>
             spotlight
             point_at <-6, 1, 1>
             radius 1
             falloff 1
             tightness 10
             area_light <1000, 0, -1000>, <0, 1000, 0>, 2, 2
             adaptive 1
}

light_source {<20000000, 10000000, -40000000> color red 2 blue 2 green 2
             area_light <150000, 0, 75000>, <-40000, 150000, 80000>, 2, 2
             adaptive 1
             jitter
}

plane { -z, 0 hollow texture {
        pigment {
                image_map {gif "stars3.gif"
                        map_type 0
                        interpolate 2
                        //once
                }
        translate <-.5, -.5, 0>
        scale <13500, 10000, 1>
        }
}
rotate <0, -90, 0>
translate <-20000, 0, 0>
finish {ambient .75 diffuse 0}
}

plane { -z, 0 hollow texture {
        pigment {
                image_map {gif "block.gif"
                        map_type 0
                        interpolate 2
                        once
                        filter all 1
                }
        translate <-.5, -.5, 0>
        scale <13500, 10000, 1>
        }
}
rotate <0, -90, 0>
translate <-19999, 0, 0>
}

object {earth
    scale 3
        translate <-10000, -3500, 11000>
}

object {hst
       scale 1
       rotate <-60, 120, -20>
       translate <-6, 1, 1>
}
