// Persistence of Vision Ray Tracer Scene Description File
// File: main.pov
// Vers: 3
// Desc: Mile-high "Illinois" tower
// Date: Jan 03 1998
// Auth: Lance Purple

#include "colors.inc"	// Standard Color definitions

#declare INCHES = (1/12)
#declare FEET   = 1
#declare METERS = 3.3
#declare KILOMETERS = 3300
#declare MILES      = 5280

#include "ch_textures.inc"

camera
{
    location <-350, 800,  450 >*METERS
    look_at  <   0, 250, -100 >*METERS
    fisheye
    angle 140
}

// sun -- don't need
/*light_source
{
  <0, 0, -1000>*MILES
  color White
  rotate  -4*x
  rotate -47*y
}*/

sky_sphere
{
    pigment
    {
        gradient z
        pigment_map
        {
            [ 0.33 SkySunsetAdjacent ]
            [ 0.66 SkySunsetOpposite ]
        }
        scale 2.01 translate -1.005
        rotate  -4*x
        rotate -47*y
    }
    pigment { ChicagoClouds rotate 55*y }
}

#include "tower.pov"

#include "bldngs01.pov"
#include "bldngs02.pov"
#include "bldngs03.pov"
#include "bldngs04.pov"
#include "bldngs05.pov"
#include "bldngs06.pov"
#include "bldngs07.pov"
#include "bldngs08.pov"

#include "waterway.pov"

#include "terrain.pov"

object { BaseTerrain pigment { Black } }

height_field
{
    tga "gclutter.tga"
    translate <-0.5, 0, -0.5>
    water_level 0.01
    scale < 10000, 50, 10000>*METERS
    translate < 0, 0, -3000 >*METERS
    texture { InteriorLights }
    texture
    {
        pigment
        {
            wood
            color_map
            {
              [ 0.0 Clear ]
              [ 0.8 Black ]
            }
            rotate 90*x
            scale < 6000*METERS, 50, 25000*METERS >
        }
    }
    clipped_by { object { BaseTerrain scale <1,-20,1> } }
}

#include "road03.pov"
#include "road04.pov"
#include "road11.pov"
#include "road12.pov"
