// Persistence of Vision Ray Tracer Scene Description File
// File: milehigh.pov
// Vers: 3
// Desc: Mile-high "Illinois" tower
// Date: Feb 27 1998
// Auth: Lance Purple

#include "colors.inc"

camera
{
    orthographic
    location <   0,   0, 1000 >
    right    <-800,   0,    0 >
    up       <   0, 600,    0 >
    look_at  <   0,   0,    0 >
}

#declare Parchment = pigment
{
   bozo
   color_map
   {
       [ 0.0 color White*0.8 + Yellow*0.1 + Brown*0.1 ]
       [ 1.0 color White*0.6 + Yellow*0.1 + Brown*0.2 ]
   }
   scale < 80, 60, 1 >
}

// background
plane
{
    z, -1
   pigment { Parchment }
   finish  { ambient 1 }
}

// main panorama
cylinder
{
    < 100, 0, 0 > < 100, 0, 0.5 > 300
    pigment { color Black }
}

cylinder
{
    < 0, 0, 0 > < 0, 0, 1 > 0.5
    pigment {
        image_map
        {
            tga "main.tga"
            map_type 0
            interpolate 0
        }
        translate < -0.5, -0.5, -0.5 >
    }
    finish  { ambient 1 }
    scale     590
    translate < 100, 0, -100 >
}

// plaque4
box
{
    < 0, 0, 0 > < 1, 1, 1 >
    pigment { color Black }
    rotate -12*z
    scale     < 310,  210, 700 >
    translate <-105, -255,   0 >
}
box
{
    < 0, 0, 0 > < 1, 1, 1 >
    pigment { Parchment }
    finish  { ambient 1 }
    rotate -12*z
    scale     < 300,  200, 800 >
    translate <-100, -250,   0 >
}

box
{
    < 0, 0, 0 > < 1, 1, 1 >
    pigment {
        image_map
        {
            gif "plaq4txt.gif"
            filter 255  1.0
            map_type 0
            interpolate  2
        }
    }
    finish  { ambient 1 }
    rotate -12*z
    scale     < 300,  200, 900 >
    translate <-100, -250,  0 >
}

// plaque1
box
{
    < -0.5, -0.5, -0.5 > < 0.5, 0.5, 0.5 >
    pigment {
        image_map
        {
            gif "plaq1txt.gif"
            map_type 0
            filter   255 1.0
            interpolate  2
        }
        translate < -0.5, -0.5, 0 >
    }
    finish  { ambient 1 }
    scale     200
    translate < -300,  200,   0 >
}

// plaque2
box
{
    < -0.5, -0.5, -0.5 > < 0.5, 0.5, 0.5 >
    pigment {
        image_map
        {
            gif "plaq2txt.gif"
            map_type 0
            filter   255 1.0
            interpolate  2
        }
        translate < -0.5, -0.5, 0 >
    }
    finish  { ambient 1 }
    scale     200
    translate < -300,  0,   0 >
}

// plaque3
box
{
    < -0.5, -0.5, -0.5 > < 0.5, 0.5, 0.5 >
    pigment {
        image_map
        {
            gif "plaq3txt.gif"
            map_type 0
            filter   255 1.0
            interpolate  2
        }
        translate < -0.5, -0.5, 0 >
    }
    finish  { ambient 1 }
    scale     200
    translate < -300, -200,   0 >
}
