// Persistence of Vision Ray Tracer Scene Description File
// File: tower.pov
// Vers: 3
// Desc: Mile-high "Illinois" tower
// Date: Jan 03 1998
// Auth: Lance Purple

#declare T_pinnacle = <   0, 5280, 0 >*FEET

#declare N_base_corner = <    0,  0,  200 >*FEET
#declare S_base_corner = <    0,  0, -200 >*FEET
#declare E_base_corner = <  200,  0,    0 >*FEET
#declare W_base_corner = < -200,  0,    0 >*FEET


#declare N_terrace_base    = <   0,  528, 180 >*FEET
#declare N_terrace_plat_N  = <   0, 3168, 180 >*FEET
#declare N_terrace_plat_E  = <  70, 3168,  10 >*FEET
#declare N_terrace_plat_W  = < -70, 3168,  10 >*FEET

#declare N_terrace_cap_top    = <   0, 3696,  60 >*FEET
#declare N_terrace_cap_base_E = <  50, 3168,  30 >*FEET
#declare N_terrace_cap_base_N = <   0, 3168, 130 >*FEET
#declare N_terrace_cap_base_W = < -50, 3168,  30 >*FEET


#declare SW_terrace1_base     = < -127.3,  528, -127.3 >*FEET
#declare SW_terrace1_plat_xSW = <  -84.9, 2112,  -84.9 >*FEET
#declare SW_terrace1_plat_SW  = < -127.3, 2112, -127.3 >*FEET
#declare SW_terrace1_plat_xS  = <      0, 2112, -120.0 >*FEET
#declare SW_terrace1_plat_xW  = < -120.0, 2112,      0 >*FEET
#declare SW_terrace1_plat_S   = (SW_terrace1_plat_xS + SW_terrace1_plat_xSW)/2
#declare SW_terrace1_plat_W   = (SW_terrace1_plat_xW + SW_terrace1_plat_xSW)/2

#declare SW_terrace2_base1    = (SW_terrace1_plat_xSW)
#declare SW_terrace2_base2    = (SW_terrace1_plat_xSW*0.75 + SW_terrace1_plat_SW*0.25)
#declare SW_terrace2_plat_xSW = < -63.6, 2904, -63.6 >*FEET
#declare SW_terrace2_plat_SW  = SW_terrace2_base2 + 792*FEET*y
#declare SW_terrace2_plat_xS  = <     0, 2904,   -90 >*FEET
#declare SW_terrace2_plat_xW  = <   -90, 2904,     0 >*FEET
#declare SW_terrace2_plat_S   = (SW_terrace2_plat_xS + SW_terrace2_plat_xSW)/2
#declare SW_terrace2_plat_W   = (SW_terrace2_plat_xW + SW_terrace2_plat_xSW)/2

#declare SW_terrace3_base1    = (SW_terrace2_plat_xSW)
#declare SW_terrace3_base2    = (SW_terrace2_plat_xSW*0.75 + SW_terrace2_plat_SW*0.25)
#declare SW_terrace3_plat_xSW = < -63.6, 3696, -63.6 >*FEET
#declare SW_terrace3_plat_SW  = SW_terrace3_base2 + 792*FEET*y
#declare SW_terrace3_plat_xS  = <     0, 3696,   -60 >*FEET
#declare SW_terrace3_plat_xW  = <   -60, 3696,     0 >*FEET
#declare SW_terrace3_plat_S   = (SW_terrace3_plat_xS + SW_terrace3_plat_xSW)/2
#declare SW_terrace3_plat_W   = (SW_terrace3_plat_xW + SW_terrace3_plat_xSW)/2

#declare SW_terrace4_base1    = (SW_terrace3_plat_xSW)
#declare SW_terrace4_base2    = (SW_terrace3_plat_xSW*0.75 + SW_terrace3_plat_SW*0.25)
#declare SW_terrace4_plat_xSW = < -28.3, 4224, -28.3 >*FEET
#declare SW_terrace4_plat_SW  = SW_terrace4_base2 + 528*FEET*y
#declare SW_terrace4_plat_xS  = <     0, 4224,   -40 >*FEET
#declare SW_terrace4_plat_xW  = <   -40, 4224,     0 >*FEET
#declare SW_terrace4_plat_S   = (SW_terrace4_plat_xS + SW_terrace4_plat_xSW)/2
#declare SW_terrace4_plat_W   = (SW_terrace4_plat_xW + SW_terrace4_plat_xSW)/2

#declare SW_terrace5_base1    = (SW_terrace4_plat_xSW)
#declare SW_terrace5_base2    = (SW_terrace4_plat_xSW*0.75 + SW_terrace4_plat_SW*0.25)
#declare SW_terrace5_plat_xSW = < -21.2, 4488, -21.2 >*FEET
#declare SW_terrace5_plat_SW  = SW_terrace5_base2 + 264*FEET*y
#declare SW_terrace5_plat_xS  = <     0, 4488,   -30 >*FEET
#declare SW_terrace5_plat_xW  = <   -30, 4488,     0 >*FEET
#declare SW_terrace5_plat_S   = (SW_terrace5_plat_xS + SW_terrace5_plat_xSW)/2
#declare SW_terrace5_plat_W   = (SW_terrace5_plat_xW + SW_terrace5_plat_xSW)/2

#declare ElevatorThingy = union
{
    prism
    {
        linear_sweep linear_spline
        0*FEET 132*FEET 7
        <-15, 0>*FEET <-10,  10>*FEET < 10,  10>*FEET
        < 15, 0>*FEET < 10, -10>*FEET <-10, -10>*FEET < -15,0>*FEET
        texture { InteriorLights }
    }
    cylinder { <-10, 0, -10 >*FEET <-10, 132, -10 >*FEET 4*FEET texture { BlueLamp } }
    cylinder { <-15, 0,   0 >*FEET <-15, 132,   0 >*FEET 4*FEET texture { BlueLamp } }
    cylinder { <-10, 0,  10 >*FEET <-10, 132,  10 >*FEET 4*FEET texture { BlueLamp } }

    translate  20*FEET*x
    rotate    -45*y
}

union
{
     // ------------
     // Main pyramid
     // ------------
    triangle { N_base_corner, T_pinnacle, W_base_corner texture { BandedGlassBox } }
    triangle { W_base_corner, T_pinnacle, S_base_corner texture { BandedGlassBox } }
    triangle { S_base_corner, T_pinnacle, E_base_corner texture { BandedGlassBox } }
    triangle { E_base_corner, T_pinnacle, N_base_corner texture { BandedGlassBox } }

    cylinder { N_base_corner, T_pinnacle 4*FEET pigment { color Black } }
    cylinder { W_base_corner, T_pinnacle 4*FEET pigment { color Black } }
    cylinder { S_base_corner, T_pinnacle 4*FEET pigment { color Black } }
    cylinder { E_base_corner, T_pinnacle 4*FEET pigment { color Black } }

    // -------------
    // North terrace
    // -------------
    triangle { N_terrace_base, N_terrace_plat_N, N_terrace_plat_E
               texture { BandedGlassBox } }
    triangle { N_terrace_base, N_terrace_plat_N, N_terrace_plat_W
               texture { BandedGlassBox } }

    cylinder { N_terrace_base,  N_terrace_plat_E 4*FEET texture { MercuryLamp } }
    cylinder { N_terrace_base,  N_terrace_plat_W 4*FEET texture { MercuryLamp } }
    cylinder { N_terrace_base   N_terrace_plat_N 4*FEET texture { MercuryLamp } }
    cylinder { N_terrace_plat_E N_terrace_plat_N 4*FEET texture { MercuryLamp } }
    cylinder { N_terrace_plat_W N_terrace_plat_N 4*FEET texture { MercuryLamp } }

    sphere { (N_terrace_base*0/6) + (N_terrace_plat_N*6/6) 10*FEET texture { RedLamp } }
    sphere { (N_terrace_base*1/6) + (N_terrace_plat_N*5/6) 10*FEET texture { RedLamp } }
    sphere { (N_terrace_base*2/6) + (N_terrace_plat_N*4/6) 10*FEET texture { RedLamp } }
    sphere { (N_terrace_base*3/6) + (N_terrace_plat_N*3/6) 10*FEET texture { RedLamp } }
    sphere { (N_terrace_base*4/6) + (N_terrace_plat_N*2/6) 10*FEET texture { RedLamp } }
    sphere { (N_terrace_base*5/6) + (N_terrace_plat_N*1/6) 10*FEET texture { RedLamp } }

    sphere { N_terrace_plat_E 10*FEET texture { RedLamp } }
    sphere { N_terrace_plat_W 10*FEET texture { RedLamp } }

    // -----------------
    // North terrace cap
    // -----------------
    triangle { N_terrace_cap_top, N_terrace_cap_base_N, N_terrace_cap_base_E
               texture { BandedGlassBox } }
    triangle { N_terrace_cap_top, N_terrace_cap_base_N, N_terrace_cap_base_W
               texture { BandedGlassBox } }

    sphere   { N_terrace_cap_top 10*FEET texture { RedLamp } }
    cylinder { N_terrace_cap_base_E N_terrace_cap_top 4*FEET texture { MercuryLamp } }
    cylinder { N_terrace_cap_base_W N_terrace_cap_top 4*FEET texture { MercuryLamp } }
    cylinder { N_terrace_cap_base_N N_terrace_cap_top 4*FEET texture { MercuryLamp } }


    // -----------------------------
    // SW "Coignet & Moiner" terrace
    // -----------------------------
    triangle { SW_terrace1_base, SW_terrace1_plat_SW, SW_terrace1_plat_S
               texture { BandedGlassBox } }
    triangle { SW_terrace1_base, SW_terrace1_plat_SW, SW_terrace1_plat_W
               texture { BandedGlassBox } }
    object { ElevatorThingy translate SW_terrace1_plat_SW }

    cylinder { SW_terrace1_base,     SW_terrace1_plat_S  4*FEET texture { MercuryLamp } }
    cylinder { SW_terrace1_base,     SW_terrace1_plat_W  4*FEET texture { MercuryLamp } }
    cylinder { SW_terrace1_base,     SW_terrace1_plat_SW 4*FEET texture { MercuryLamp } }
    cylinder { SW_terrace1_plat_SW,  SW_terrace1_plat_S  4*FEET texture { MercuryLamp } }
    cylinder { SW_terrace1_plat_SW, SW_terrace1_plat_W  4*FEET texture { MercuryLamp } }
    sphere { (SW_terrace1_base*0/3) + (SW_terrace1_plat_SW*3/3) 10*FEET texture { RedLamp } }
    sphere { (SW_terrace1_base*1/3) + (SW_terrace1_plat_SW*2/3) 10*FEET texture { RedLamp } }
    sphere { (SW_terrace1_base*2/3) + (SW_terrace1_plat_SW*1/3) 10*FEET texture { RedLamp } }

    // -----------------------------
    // SW "Lidgerwood" terrace
    // -----------------------------
    triangle { SW_terrace2_base1, SW_terrace2_base2,   SW_terrace2_plat_S
               texture { BandedGlassBox } }
    triangle { SW_terrace2_base2, SW_terrace2_plat_SW, SW_terrace2_plat_S
               texture { BandedGlassBox } }
    triangle { SW_terrace2_base1, SW_terrace2_base2,   SW_terrace2_plat_W
               texture { BandedGlassBox } }
    triangle { SW_terrace2_base2, SW_terrace2_plat_SW, SW_terrace2_plat_W
               texture { BandedGlassBox } }
    object { ElevatorThingy translate SW_terrace2_plat_SW }

    cylinder { SW_terrace2_base2,   SW_terrace2_plat_SW 4*FEET texture { MercuryLamp } }
    cylinder { SW_terrace2_base1,   SW_terrace2_plat_S  4*FEET pigment { color Black } }
    cylinder { SW_terrace2_base1,   SW_terrace2_plat_W  4*FEET pigment { color Black } }

    cylinder { SW_terrace2_plat_SW, SW_terrace2_plat_S  4*FEET texture { MercuryLamp } }
    cylinder { SW_terrace2_plat_SW, SW_terrace2_plat_W  4*FEET texture { MercuryLamp } }

    sphere   { (SW_terrace2_base2 + SW_terrace2_plat_SW)/2 10*FEET texture { RedLamp } }
    sphere   { SW_terrace2_plat_SW 10*FEET texture { RedLamp } }

    // -----------------------------
    // SW "Roebling" terrace
    // -----------------------------
    triangle { SW_terrace3_base1, SW_terrace3_base2,   SW_terrace3_plat_S
               texture { BandedGlassBox } }
    triangle { SW_terrace3_base2, SW_terrace3_plat_SW, SW_terrace3_plat_S
               texture { BandedGlassBox } }
    triangle { SW_terrace3_base1, SW_terrace3_base2,   SW_terrace3_plat_W
               texture { BandedGlassBox } }
    triangle { SW_terrace3_base2, SW_terrace3_plat_SW, SW_terrace3_plat_W
               texture { BandedGlassBox } }
    object { ElevatorThingy translate SW_terrace3_plat_SW }

    cylinder { SW_terrace3_base2,   SW_terrace3_plat_SW 4*FEET texture { MercuryLamp } }
    cylinder { SW_terrace3_base1,   SW_terrace3_plat_S  4*FEET pigment { color Black } }
    cylinder { SW_terrace3_base1,   SW_terrace3_plat_W  4*FEET pigment { color Black } }

    cylinder { SW_terrace3_base2,   SW_terrace3_plat_SW 4*FEET texture { MercuryLamp } }
    cylinder { SW_terrace3_plat_SW, SW_terrace3_plat_S  4*FEET texture { MercuryLamp } }
    cylinder { SW_terrace3_plat_SW, SW_terrace3_plat_W  4*FEET texture { MercuryLamp } }
    
    sphere   { SW_terrace3_plat_SW 10*FEET texture { RedLamp } }


    // -----------------------------
    // SW "Otis" terrace
    // -----------------------------
    triangle { SW_terrace4_base1, SW_terrace4_base2,   SW_terrace4_plat_S
               texture { BandedGlassBox } }
    triangle { SW_terrace4_base2, SW_terrace4_plat_SW, SW_terrace4_plat_S
               texture { BandedGlassBox } }
    triangle { SW_terrace4_base1, SW_terrace4_base2,   SW_terrace4_plat_W
               texture { BandedGlassBox } }
    triangle { SW_terrace4_base2, SW_terrace4_plat_SW, SW_terrace4_plat_W
               texture { BandedGlassBox } }
    object { ElevatorThingy translate SW_terrace4_plat_SW }

    cylinder { SW_terrace4_base2,   SW_terrace4_plat_SW 4*FEET texture { MercuryLamp } }
    cylinder { SW_terrace4_base1,   SW_terrace4_plat_S  4*FEET pigment { color Black } }
    cylinder { SW_terrace4_base1,   SW_terrace4_plat_W  4*FEET pigment { color Black } }

    cylinder { SW_terrace4_base2,   SW_terrace4_plat_SW 4*FEET texture { MercuryLamp } }
    cylinder { SW_terrace4_plat_SW, SW_terrace4_plat_S  4*FEET texture { MercuryLamp } }
    cylinder { SW_terrace4_plat_SW, SW_terrace4_plat_W  4*FEET texture { MercuryLamp } }

    sphere   { SW_terrace4_plat_SW 10*FEET texture { RedLamp } }


    // -----------------------------
    // SW "Sullivan" terrace
    // -----------------------------
    triangle { SW_terrace5_base1, SW_terrace5_base2,   SW_terrace5_plat_S
               texture { BandedGlassBox } }
    triangle { SW_terrace5_base2, SW_terrace5_plat_SW, SW_terrace5_plat_S
               texture { BandedGlassBox } }
    triangle { SW_terrace5_base1, SW_terrace5_base2,   SW_terrace5_plat_W
               texture { BandedGlassBox } }
    triangle { SW_terrace5_base2, SW_terrace5_plat_SW, SW_terrace5_plat_W
               texture { BandedGlassBox } }
    object { ElevatorThingy translate SW_terrace5_plat_SW }

    cylinder { SW_terrace5_base2,   SW_terrace5_plat_SW 4*FEET texture { MercuryLamp } }
    cylinder { SW_terrace5_base1,   SW_terrace5_plat_S  4*FEET pigment { color Black } }
    cylinder { SW_terrace5_base1,   SW_terrace5_plat_W  4*FEET pigment { color Black } }

    cylinder { SW_terrace5_base2,   SW_terrace5_plat_SW 4*FEET texture { MercuryLamp } }
    cylinder { SW_terrace5_plat_SW, SW_terrace5_plat_S  4*FEET texture { MercuryLamp } }
    cylinder { SW_terrace5_plat_SW, SW_terrace5_plat_W  4*FEET texture { MercuryLamp } }

    sphere   { SW_terrace5_plat_SW 10*FEET texture { RedLamp } }

    rotate    45*y
    translate < -16, 0, -106 >*METERS
}

// ------------
// Tower Plaza
// ------------

box
{
    < -240, 0, -240 >*FEET < 240, 20, 240 >*FEET
    texture { pigment { color Brown } finish { ambient 0.5 } }
    translate < -16, 0, -106 >*METERS
}
box
{
    < -230, 20, -230 >*FEET < 230, 40, 230 >*FEET
    texture { BlueLamp }
    translate < -16, 0, -106 >*METERS
}
box
{
    < -220, 40, -220 >*FEET < 220, 60, 220 >*FEET
    texture { pigment { color Brown } finish { ambient 0.5 } }
    translate < -16, 0, -106 >*METERS
}
box
{
    < -210, 60, -210 >*FEET < 210, 80, 210 >*FEET
    texture { BlueLamp }
    translate < -16, 0, -106 >*METERS
}
box
{
    < -200, 80, -200 >*FEET < 200, 100, 200 >*FEET
    texture { pigment { color Brown } finish { ambient 0.5 } }
    translate < -16, 0, -106 >*METERS
}
