#declare RiverWater = texture
{
    pigment { color (Cyan*0.1 + Brown*0.1) }
    finish
    {
        reflection 0.7
    }
    normal
    {
        bumps 0.1
        scale <1, 1, 1>*METERS
    }
}

#declare LakeWater = texture
{
    pigment
    {
         bozo
         color_map
         {
             [ 0 (Cyan*0.1 + Brown*0.2) ]
             [ 1 (Cyan*0.2 + Brown*0.1) ]
         }
         scale 3500*METERS
    }
    finish
    {
        reflection 0.7
    }
    normal
    {
        wrinkles 2
        scale <4, 1, 20>*METERS
        rotate 43*y
    }

}

#declare Breakwater = texture
{
    pigment { color Gray }
}

#declare HarborLight = texture
{
    pigment { color Blue }
    finish  { ambient 1 }
}

// Lake Michigan
cylinder
{   < 0, -4, 0 >*METERS
    < 0, -2, 0 >*METERS 15000*METERS
    texture { LakeWater }
}

// Chicago River and Canals
prism
{
    linear_spline linear_sweep
    -2*METERS, -1*METERS
    14,
    <-15000,  15000>*METERS
    <1641.3, -294.8>*METERS,
    <1786.2, -294.8>*METERS,
    <1786.2, -379.0>*METERS,
    <1789.6, -379.0>*METERS,
    <1789.6, -412.7>*METERS,
    <1802.3, -412.7>*METERS,
    <1607.6, -429.6>*METERS,
    <1580.6, -857.6>*METERS,
    <1354.8, -854.2>*METERS,
    <     0, -854.2>*METERS,
    <     0, -15000>*METERS,
    <-15000, -15000>*METERS,
    <-15000,  15000>*METERS

    texture { RiverWater }

    clipped_by
    {
        cylinder {  < 0, -5, 0 >*METERS < 0, 0, 0 >*METERS 15000*METERS }
    }

}

// Lake Michigan breakwaters

// NW Outer Breakwater
cylinder
{
    <1000, -2, 1000>*METERS,
    <1605, -2, 1176>*METERS, 5*METERS
    texture { Breakwater }
}

// NE Outer Breakwater
cylinder
{
    <2047, -2, 1176>*METERS,
    <3670, -2,  329>*METERS, 5*METERS
    texture { Breakwater }
}

sphere
{
    <2047, 0, 1176>*METERS, 10*METERS
    texture { HarborLight }
}

// N half of E Outer Breakwater
cylinder
{
    <3670, -2,  329>*METERS
    <3670, -2, -329>*METERS, 5*METERS
    texture { Breakwater }
}

sphere
{
    <3670, 0, -329>*METERS, 10*METERS
    texture { HarborLight }
}

// S half of E Outer Breakwater
sphere
{
    <3670, 0, -518>*METERS, 10*METERS
    texture { HarborLight }
}

cylinder
{
    <3670, -2,  -518>*METERS
    <3670, -2, -1553>*METERS, 5*METERS
    texture { Breakwater }
}

sphere
{
    <3670, 0, -1553>*METERS, 10*METERS
    texture { HarborLight }
}

// Jetty S. of Navy pier
cylinder
{
    <1976, -2, -259>*METERS,
    <2658, -2, -259>*METERS, 5*METERS
    texture { Breakwater }
}

sphere
{
    <2658, 0, -259>*METERS, 10*METERS
    texture { HarborLight }
}


// Jetty connecting North Pier to N half of lock
cylinder
{
    <1882, -2, -329>*METERS,
    <2011, -2, -329>*METERS, 5*METERS
    texture { Breakwater }
}

cylinder
{
    <2011, -2, -329>*METERS,
    <2011, -2, -388>*METERS, 5*METERS
    texture { Breakwater }
}

// N half of lock
cylinder
{
    <2011, -2, -388>*METERS,
    <2246, -2, -388>*METERS, 5*METERS
    texture { Breakwater }
}

// S half of lock
cylinder
{
    <2012, -2, -423>*METERS,
    <2447, -2, -423>*METERS, 5*METERS
    texture { Breakwater }
}

sphere
{
    <2447, 0, -423>*METERS, 10*METERS
    texture { HarborLight }
}

// N half of Easterly Breakwater from S half of lock to Armory jetty
cylinder
{
    <1600, -2, -470>*METERS,
    <2012, -2, -423>*METERS, 5*METERS
    texture { Breakwater }
}

cylinder
{
    <1600, -2, -470>*METERS,
    <1600, -2, -894>*METERS, 5*METERS
    texture { Breakwater }
}

// jetty from Armory to N half of Easterly Breakwater
cylinder
{
    <1083, -2, -894>*METERS,
    <1600, -2, -894>*METERS, 5*METERS
    texture { Breakwater }
}

// N half of Easterly Breakwater S of Armory jetty
cylinder
{
    <1600, -2,  -894>*METERS,
    <1600, -2, -1918>*METERS, 5*METERS
    texture { Breakwater }
}

sphere
{
    <1600, 0, -1918>*METERS, 10*METERS
    texture { HarborLight }
}

// S half of Easterly Breakwater
cylinder
{
    <1547, -2, -1963>*METERS,
    <1149, -2, -2532>*METERS, 5*METERS
    texture { Breakwater }
}
