#declare Control_Rod_Brace =
union {
	cylinder { <0,0,0><0,45,0> 0.65 }
	torus { 1.3 0.65 rotate <90,90,0> translate 46.7*y }
	// arms to handle
	cylinder { <0,0,0><5.0,0,0> 0.40 translate 38.5*y }
	cylinder { <0,0,0><3.9,0,0> 0.20 translate 39.8*y }
	texture { T_Chrome_1A }
}

#declare Lever_1 =
union {
	prism {
  	linear_sweep
  	linear_spline
  	-2, 2,
  	9,
		<0,0>,<29.3,0>,<30.5,0.7>,<30.8,1.8>,<28.5,8>,<26,8>,<26,4>,<0,4>,<0,0>
		rotate -90*x
	}
	#if (d_Controls > 1)
	box { <-1.9,0,-2.9><1.9,1.2,2.9> translate <27.25,7.5,0> }
	sphere { <0,0,0> 0.6 scale <1,1,0.5> translate <27.5,6.8,-2> pigment {Black} }
	#end
	// handle
	union {
		cone { <0,0,0> 1.0 <0,23,0> 0.6 }
		sphere { <0,23.3,0> 1.15 }
		texture { T_Wood6 scale 20 }
		rotate -6*z
		translate <27.5,8,0>
	}
	texture { T_Chrome_1A }
	translate <-17,13,0>
}

#declare Lever_2 =
union {
	union {
		difference {
			box { <-1.5,0,-1.5><1.5,-9,1.2> }
			box { <-0.9,-2,-1.6><-0.2,-7,-0.8> }
			box { <0.2,-2,-1.6><0.9,-7,-0.8> }
		}
		box { <-20,-0.9,-1.5><0,0.9,1.5>
			rotate 24*z
			rotate 40*y
			translate <0.5,-7.5,0>
		}
		#if (d_Controls > 1)
		sphere { <0,0,0> 0.6 scale <1,1,0.5> translate <0,-1,-1.5> pigment {Black} }
		sphere { <0,0,0> 0.6 scale <1,1,0.5> translate <0,-8,-1.5> pigment {Black} }
		#end
		texture { T_Chrome_1A }
	}
	// handle
	union {
		union {
			cylinder { <0,0,0><0,10,0> 0.9 }
			intersection {
				torus { 2.0, 0.7 }
				box { <0,-10,-10><10,10,10> }
				rotate 90*x
				translate <-0.7,11.45,0>
			}
			cone { <-0.20,13.2,0> 0.7 <-0.20,20,0> 0.6 }
			scale <1,1.25,1>
		}
		sphere { <-0.20,25.3,0> 1.15 }
		cylinder { <0,0,0><0,1.5,0> 1.6 translate 1.3*y texture { T_Chrome_1D } }
		texture { T_Wood6 scale 16 }
		rotate -3*z
	}
	texture { T_Chrome_1A }
	translate <6,19.5,0>
}

#declare Gauge_Assembly =
union {
	// gauge
	union {
		cylinder { <-0.4,0,0><0.4,0,0> 3.9 }
		cylinder { <0,0,0><2.9,0,0> 3 }
	  cone { <2.4,0,0> 2.8 <3.6,0,0> 3.5 }
		cylinder { <0,0,0><0,-30,0> 0.95 translate 0.8*x }
		cylinder { <0,-0.5,0><0,0.5,0> 1.9
			texture { T_Chrome_2A }
			translate <0.8,-7.0,0>
		}
		texture { T_Copper_4C }
	}
	// valve
	union {
		torus { 1.5 0.7 scale <1,0.9,1> texture { T_Copper_4C } }
		cylinder { <0,0,0><0,-8,0> 0.2 texture { T_Copper_4C } }
		cone { <0,-1.8,0> 0.5 <0,-10,0> 2.2 }
		texture { T_Chrome_1B }
		translate <-7,-6,0>
	}
	// small post
	cylinder { <0,0,0><0,-10,0> 0.9
		texture { T_Chrome_1B }
		translate <-3.0,-8,0>
	}
	// connecting rod
	union {
		cylinder { <0,0,0><14,0,0> 0.4 }
		difference {
			cylinder { <0,0,-0.2><0,0,0.2> 3 }
			cylinder { <0,0,-0.3><0,0,0.3> 2.0 }
			scale <0.65,1,1>
			translate <15.4,0,0>
		}
		texture { T_Chrome_1A }
		translate <-7,-9.5,0>
	}
	scale 1.2
}

#declare Bell_Cord =
object {
	#declare rd = 300
	#declare an = 6
	#declare wd = 0.3
	torus { rd wd
		clipped_by { plane {-x,0} }
		clipped_by { plane {x,0} rotate 2*an*y }
		rotate 90*x
		texture {
			pigment { Tan }
			finish { Dull }
		}
		translate rd*y
		scale <1.15,1,1>
		rotate -2*y
	 	translate <-90.0,42,-6>
	}
}

#declare Cord_Holder =
cone { <0,-2,0> 1.3 <0,5,0> 0.7
	texture { T_Copper_2C }
}

#declare Long_Cord =
object {
	#declare rd = 700
	#declare an = 6
	#declare wd = 0.5
	torus { rd wd
		clipped_by { plane {-x,0} }
		clipped_by { plane {x,0} rotate 2*an*y }
		rotate 90*x
		texture {
			pigment { VeryDarkBrown }
			finish { Dull }
		}
		translate rd*y
		scale <0.93,1,1>
	}
}

#declare Lever_Rod =
union {
	#declare LR_d = 0.6
	#declare curve = 5
	#declare ln = 47
	cylinder { <-ln,0,0><0,0,0> LR_d }
	torus { curve LR_d
		rotate 90*x
		clipped_by { plane {x,0} }
		clipped_by { plane {y,0} }
		translate <-ln,curve,0>
	}
	torus { curve LR_d
		rotate 90*x
		clipped_by { plane {-x,0} }
		clipped_by { plane {-y,0} }
		translate <-ln-(2*curve),curve,0>
	}
	cylinder { <-ln-(2*curve)-95,2*curve,0><-ln-(2*curve),2*curve,0> LR_d }
	texture {
		pigment { VeryDarkBrown }
		finish { Dull }
	}
	rotate <90,0.8,8.9>
	translate <5,22,-30>
}

#declare Short_Cord =
object {
	#declare rd = 40
	#declare an = 14
	#declare wd = 0.5
	torus { rd wd
		clipped_by { plane {-x,0} }
		clipped_by { plane {x,0} rotate 2*an*y }
		rotate 90*x
		texture {
			pigment { VeryDarkBrown }
			finish { Dull }
		}
		translate rd*y
		scale <1,1,1>
	}
	rotate 180*y
}

#declare Boiler_Pipe =
union {
	#declare B_rd = 0.6
	#declare B_curve = 27
	torus { B_curve B_rd
		rotate 90*x
		clipped_by { plane {-y,0} }
		clipped_by { plane {-x,0} }
		scale <1,0.6,1>
	}
	cylinder { <B_curve,0,0><B_curve,-11,0> B_rd }
	// valve
	union {
		cylinder {<-10,0,0><2,0,0> 0.4 }
		torus { 1.3 0.5 rotate <90,90,0> translate 2*x }
		cylinder {<-10,0,0><2,0,0> 0.5 translate -2*y}
		cylinder {<-10,0,0><2,0,0> 0.5 translate -4*y}
 		rotate -45*y
		translate <B_curve,-7,0>
	}
	texture { T_Copper_3C }
	rotate 43*y
	translate <-25,30.5,0>
}

#declare Control_Pipe =
union {
	#declare C_rd = 0.5
	cylinder { <0,0,0><0,-18,0> C_rd }
	torus { 6 C_rd
		rotate 90*x
		clipped_by { plane {y,0} }
		clipped_by { plane {x,0} }
		scale <1,1.6,1>
		translate <6,-18,0>
	}
	union {
		torus { 6 C_rd
			rotate 90*x
			clipped_by { plane {-y,0} }
	  	clipped_by { plane {-y,0} rotate  -105*z }
		}
		cylinder { <6,0,0><6,-9,0> C_rd }
		union {
			cone { <0,0,0> 0.48 <1,0,0> 1 }
			cylinder { <1,0,0><12,0,0> 1 }
			cone { <12,0,0> 1 <13,0,0> 0.48 }
			rotate -90*z
			translate <6,-2,0>
		}
		rotate 105*z
		rotate -5*y
		translate <6,0,1>
	}
	rotate <3,0,18>
	translate <-20,2,-28>
	texture {T_Copper_3C }
}

#declare Controls =
union {
  object { Control_Rod_Brace translate <0,0,-7> }
  object { Lever_1 translate <0,0,-2> }
 	object { Lever_2 translate <-2,0,-30> }
	object { Gauge_Assembly translate <-18,60,0> }
	// connectors
	object { Bell_Cord }
	object { Cord_Holder translate <-19,46,-3.6> }
	object { Long_Cord rotate <0,-2.5,2.4> translate <-153,28.5,-10> }
	object { Cord_Holder translate <-19,46,3.6> }
	object { Long_Cord rotate <0,2.5,2.4> translate <-153,28.5,10> }
	object { Lever_Rod }
	object { Short_Cord rotate <0,15,20> translate <0,45,-7> }
	object { Short_Cord rotate <0,15,15> translate <0,43,-7> }
	object { Boiler_Pipe }
	object { Control_Pipe }
	translate <191.5,0,0>
}
