#declare Spike =
union {
	box { <-0.3,-15,-0.5><0.3,0,0.5> }
	sphere { <0,0,0> 1.2 scale <0.8,0.4,1> translate <0.47,0,0> }
	pigment {Black}
}

#declare Track_Ties =
union {
	// ties
	#declare R3 = seed(361)
	#declare Tie_Spacing = 34
	#declare Tie_x = -170
	#declare Tie_Num = 1
	#declare Tie_x_End = -1 * Tie_x
	#while (Tie_x < Tie_x_End)
		intersection {
			// add some nicks
			#switch (Tie_Num)
				#case (7)
					difference
					{
						box { <-30,-6,-6><30,6,6> }
						box { < 40,-3,3><0,3,-3> rotate 45*x scale <1,1.2,.3> translate <0,6,-2> }
					}
				#break
				#case (8)
					difference
					{
						box { <-30,-6,-6><30,6,6> }
						box { <-3,-3,-3><3,3,3> rotate <45,45,0> scale <5,0.7,1> translate <30,4.6,7> }
					}
				#break
				#case (4)
					difference
					{
						box { <-30,-6,-6><30,6,6> }
				  	cylinder { <40,0,0><10,0,0> 1.7 scale <1,0.8,1> rotate -35*x translate <0,5,-1.5> }
					}
				#break
				#case (1)
					difference
					{
						box { <-30,-6,-6><30,6,6> }
						box { < 40,-10,3><0,10,6> rotate -30*x translate <0,-1,4> }
					}
				#break
				#else
					box { <-30,-6,-6><30,6,6> }
			#end
			cylinder { <-50,0,0><50,0,0> 7.70 }
			rotate 90*y
			#declare Grain_x = (rand(R3)*20)+10
			#declare Grain_y = (rand(R3)*20)+10
			#declare Grain_z = (rand(R3)*20)+10
			#declare Grain_Rotate_x = (rand(R3)*6)-3
			#declare Grain_Rotate_y = (rand(R3)*6)-3
			#declare Grain_Rotate_z = (rand(R3)*6)-3
			#declare Grain_Scale = (rand(R3)*5)+4
			#declare Tie_Spacing_x = (rand(R3)*6)-3
			#declare Tie_Spacing_z = (rand(R3)*3)-1.5
			#declare Tie_Angle = (rand(R3)*4)-2
			#if (d_Ground > 1)
			texture {
				T_Wood14
				rotate <Grain_Rotate_x,Grain_Rotate_y,Grain_Rotate_z>
				translate <Grain_x,Grain_y,Grain_z>
				scale Grain_Scale
			}
			#else
			pigment { Brown }
			#end
			scale <1,1,1.25>
			rotate Tie_Angle*y
			translate <Tie_x+Tie_Spacing_x,0,Tie_Spacing_z>
		}
	#if (d_Ground > 1)
	// spikes
	#declare Spike_x = (rand(R3)*0.5) - 0.25 + 3
	#declare Spike_x_1_Front = Tie_x + Tie_Spacing_x - Spike_x - (Tie_Angle*0.10)
	#declare Spike_x_2_Front = Tie_x + Tie_Spacing_x + Spike_x - (Tie_Angle*0.10)
	#declare Spike_x_1_Back = Tie_x + Tie_Spacing_x - Spike_x + (Tie_Angle*0.10)
	#declare Spike_x_2_Back = Tie_x + Tie_Spacing_x + Spike_x + (Tie_Angle*0.10)
	object { Spike rotate -90*y translate <Spike_x_1_Front,7.0,-27.9> }
	object { Spike rotate -90*y translate <Spike_x_2_Front,7.0,-27.9> }
	object { Spike rotate 90*y translate <Spike_x_1_Back,7.0,27.9> }
	object { Spike rotate 90*y translate <Spike_x_2_Back,7.0,27.9> }
	object { Spike rotate 90*y translate <Spike_x_1_Front,7.0,-22.7> }
	object { Spike rotate 90*y translate <Spike_x_2_Front,7.0,-22.7> }
	object { Spike rotate -90*y translate <Spike_x_1_Back,7.0,22.7> }
	object { Spike rotate -90*y translate <Spike_x_2_Back,7.0,22.7> }
	#end
	#declare Tie_Num = Tie_Num + 1
	#declare Tie_x = Tie_x + Tie_Spacing + Tie_Spacing_x
	#end
}

#declare Track_Rail =
union {
	// rail top
	union {
		intersection {
			cylinder { <-300,0,0><300,0,0> 2 }
			box { <-300,-5,-500><300,1.7,500> }
		}
		// worn part of rail
		box { <-300,0,-1.2><300,1.70,1.2>
			texture {
				T_Chrome_3C
				normal { dents 1.0 scale 0.4 }
			}
		}
	  scale <1,0.5,1.2>
		translate 4*y
	}
	// base
	box { <-300,0,-2.5><300,0.5,2.5> }
	// vertical
	box { <-300,0,-0.5><300,4,0.5> }
	// fillet at base
	box { <-300,-1.5,-1.5><300,1.5,1.5> rotate 45*x scale <1,1.1,1> translate -0.1*y }
	texture {
		T_Chrome_1A
		normal { bumps 0.4 scale 0.4 }
	}
}

#declare Track =
union {
	object { Track_Ties rotate < 0,0,0> translate <0,0,0> }
	object { Track_Rail translate <0,6,-25.5> }
	object { Track_Rail translate <0,6,25.5> }
	translate -1.5*y
}

#declare T_Grass =
texture {
  pigment {
    granite
    turbulence 0.6
    color_map {
			[ 0.3 rgb <0.000,0.850,0.000> ]
			[ 0.5 rgb <0.020,0.350,0.720> ]
			[ 0.7 rgb <0.250,0.600,0.150> ]
			[ 0.9 rgb <0.100,0.800,0.500> ]
		}
	}
	scale 1
}

#declare T_Rock =
texture {
  pigment { rgb <0.70,0.70,0.20> }
  normal {
    crackle 3
    turbulence 0.2
		scale 2
  }
}

#declare Ballast =
intersection {
	prism {
  	linear_sweep
  	linear_spline
		-250, 250,
		5,
		<-78,0>,<78,0>,<48,20>,<-48,20>,<-78,0>
		rotate <0,90,90>
	}
  cylinder { <-300,0,0><300,0,0> 80 scale <1,0.26,1> }
	#if (d_Ground > 1)
	texture {
		T_Stone38
		normal { bumps 4  }
		scale .8
	}
	#else
	pigment { Brown }
	#end
	scale <1,1,1.4>
}

#declare Barrel =
union {
	#declare R7 = seed(981)
	#declare ang = 0
	#while (ang < 360)
		sphere { <0,0,0> 5
			clipped_by { plane {x,0} }
			clipped_by { plane {x,0} rotate 161.8*y }
			texture {	T_Wood2
				scale 2
				rotate <  0, 91,92>
				#declare bq = rand(R7)*3
				translate <bq,bq,bq>
			}
			rotate ang * y
		}
		#declare ang = ang + 20
	#end
	// bands
	sphere { <0,0,0> 5.1
		clipped_by { plane {y,3.5} }
		clipped_by { plane {-y,-2.9} }
		texture { Rusty_Iron }
	}
	sphere { <0,0,0> 5.1
		clipped_by { plane {y,0.35} }
		clipped_by { plane {-y,0.35} }
		texture { Rusty_Iron }
	}
	sphere { <0,0,0> 5.1
		clipped_by { plane {y,-2.9} }
		clipped_by { plane {-y,3.5} }
		texture { Rusty_Iron }
	}
	clipped_by { plane {y,3.5} }
	clipped_by { plane {-y,3.5} }
	translate 3.5*y
	rotate 6*y
	scale <1.8,3.4,1.8>
}

#declare FireWood_1 =
cylinder { <0,0,-10><0,0,10> 3
	texture { T_Wood1 rotate <1,0,0> scale 2 }
	clipped_by { plane {-y,-0.6} }
	translate -3.6*y
}

#declare FireWood_2 =
cylinder { <0,0,-12><0,0,12> 3.5
	texture { T_Wood13 rotate <2,0,0> scale 1.5 }
	clipped_by { plane {-y,-0.8} }
	translate -4.3*y
}

#declare FireWood_3 =
cylinder { <0,0,-9><0,0,9> 4.5
	texture { T_Wood29 rotate <2,0,0> scale 2.5 }
	clipped_by { plane {-y,-1.8} }
	translate -6.3*y
}

#declare FireWood_4 =
intersection {
	cylinder { <0,0,-9><0,0,9> 4.5
		texture { T_Wood12 rotate <1,0,0> scale 2.5 }
	}
	box { <0,0,-20><20,20,20> rotate 45*z texture { T_Wood12 } }
	scale <1,0.8,1>
	translate -3.6*y
}

#declare FireWood_5 =
intersection {
	cylinder { <0,0,-10><0,0,10> 3.5
		texture { T_Wood13 rotate <1,0,0> scale 2.5 }
	}
	box { <0,0,-20><20,20,20> rotate 45*z texture { T_Wood13 } }
	scale <1,1.1,1>
	translate -3.85*y
}

#declare FireWood_6 =
intersection {
	cylinder { <0,0,-9><0,0,9> 5.5
		texture { T_Wood8 rotate <1,0,0> scale 2.5 }
	}
	box { <0,0,-20><20,20,20> rotate 45*z texture { T_Wood8 } }
	scale <1,0.6,1>
	translate -3.3*y
}

#declare WoodPile =
union {
	union {
		object { FireWood_1 rotate 0*y translate <-5,0,0> }
		object { FireWood_2 rotate 2*y translate <5,0,0> }
		object { FireWood_5 rotate -45*z rotate 90*y translate <0,2.3,-6> }
		object { FireWood_4 rotate 45*z rotate 91*y translate <0,2.3,5> }
		object { FireWood_2 rotate -1*y translate <-5,6.9,0> }
		object { FireWood_3 rotate 2*y translate <5,7.6,0> }
		rotate 90*y
	}
	union {
		object { FireWood_1 rotate 0*y translate <-5,0,0> }
		object { FireWood_2 rotate 2*y translate <5,0,0> }
		object { FireWood_5 rotate -45*z rotate 90*y translate <0,2.3,-6> }
		object { FireWood_4 rotate 45*z rotate 91*y translate <0,2.3,5> }
		object { FireWood_2 rotate -1*y translate <-5,6.9,0> }
		object { FireWood_3 rotate 2*y translate <5,7.6,0> }
		translate 9.8*y
	}
	union {
		object { FireWood_6 rotate -35*z rotate 90*y translate <0,0,-6> }
		object { FireWood_5 rotate 45*z rotate 90*y translate <0,0,4> }
		translate 18.5*y
	}
}

#declare BarrelStand =
union {
	box { <-41,-10,-10><41,5,10> texture { T_Wood15 rotate 90*y scale <8,2,2>  } }
	box { <-41,5.4,-10><41,10,10> texture { T_Wood15 rotate 90*y scale <8,2,2> translate 10*x } }
	box { <-41,10.4,-10><41,15,10> texture { T_Wood15 rotate 90*y scale <8,2,2> translate 20*x } }
	box { <-41,15.4,-10><41,20,10> texture { T_Wood15 rotate 90*y scale <8,2,2> translate 70*x } }
	box { <-41,20.4,-10><41,25,10> texture { T_Wood15 rotate 90*y scale <8,2,2> translate 90*x } }
	// ramp
	union {
		box { <0,-10,-10><25,0,10> texture { T_Wood15 rotate 90*y scale <8,2,2> translate 30*x } }
		box { <0,0,-6><25,25,6>
			clipped_by { plane {y,0} rotate 45*z }
			texture {
				T_Wood15
				rotate 90*y
				scale <10,2,2>
				translate 120*x
			}
		}
		box { <3,0,-9><25,3,9>
			texture {
				T_Wood2
				rotate 90*y
				scale <8,2,2>
				translate 120*x
			}
		}
		box { <23,0,-9><25,21,9>
			texture {
				T_Wood2
				rotate  0*y
				scale <8,2,2>
				translate 20*x
			}
		}
		box { <0,0,-9><32,3,9>
			texture {
				T_Wood2
				rotate 90*y
				scale <8,2,2>
				translate 50*x
			}
			rotate 45*z
			translate <4,0,0>
		}
		translate -25*x
		scale <1.7,1,1>
		translate -41*x
	}
	object { Barrel scale 1.4 translate <-29,25,0> }
	object { Barrel scale 1.4 rotate 39*y translate <0,25,0> }
	object { Barrel scale 1.4 rotate 142*y translate <29,25,0> }
}

#declare Wrench =
union {
	box { <-10,-1,-0.8><10,1,0.8> }
	difference {
		cylinder { <0,0,-0.8><0,0,0.> 3 }
		box { <-1,-1,-0.9><1,1,0.9> scale <2.2,1.5,1> rotate 45*z translate <-1,-0.95,0>}
		translate <-13,0,0>
	}
	difference {
		cylinder { <0,0,-0.8><0,0,0.8> 3 }
		box { <-1,-1,-0.9><1,1,0.9> scale <2.2,1.5,1> rotate 45*z translate <-1,-0.95,0>}
		rotate 180*z
		translate <13,0,0>
	}
	texture {
    pigment {
      granite
      color_map {
        [0.0, 0.5 color rgb <0.06, 0.06, 0.06> * 1.5
                  color rgb <0.02, 0.02, 0.02> * 1.5]
        [0.5, 0.6 color rgb <0.54, 0.04, 0.04> * 1.5
                  color rgb <0.54, 0.01, 0.01> * 1.5]
        [0.6, 1.0 color rgb <0.54, 0.12, 0.12> * 1.5
                  color rgb <0.50, 0.10, 0.10> * 1.5]
      }
    }
    finish { ambient 0.2 diffuse 0.6 }
    normal { wrinkles 1 scale 0.1 }
	}
}

#declare CurvedBar =
union {
	cylinder { <-10,0,0><10,0,0> 0.6 }
	cone { <-3,0,0> 0.2 <0,0,0> 0.6 translate -10*x }
	union {
		torus { 5 0.6
			rotate 90*x
			clipped_by { plane {y,0} }
			clipped_by { plane {-y,0} rotate 45*z }
		}
		cone { <0,0,0> 0.6 <0,3,0> 0.2 translate -5*x }
		rotate 225*z
		translate <10,-5,0>
	}
	texture {
		pigment { Gray10 }
		normal { dents 2 scale 0.2 }
		finish { Dull }
	}
}

#declare Pliers =
union {
	union {
		union {
			cylinder { <-4,0,0><0,0,0> 0.5 }
			torus { 2 0.5
				rotate 90*x
				clipped_by { plane {-x,0} }
				clipped_by { plane {-y,0} }
				translate -2*y
			}
			torus { 2 0.5
				rotate 90*x
				clipped_by { plane {x,0} }
				clipped_by { plane {y,0} }
				translate <4,-2,0>
			}
			cylinder { <-2,0,0><0,0,0> 0.5 translate <6,-4,0> }
			box { <-1,-0.7,-0.5><3,0.7,0.5> translate <6,-4,0> pigment { Gray05 } }
		}
		union {
			cylinder { <-4,0,0><0,0,0> 0.5 }
			torus { 2 0.5
				rotate 90*x
				clipped_by { plane {-x,0} }
				clipped_by { plane {-y,0} }
				translate -2*y
			}
			torus { 2 0.5
				rotate 90*x
				clipped_by { plane {x,0} }
				clipped_by { plane {y,0} }
				translate <4,-2,0>
			}
			cylinder { <-2,0,0><0,0,0> 0.5 translate <6,-4,0> }
			box { <-1,-0.7,-0.5><3,0.7,0.5> translate <6,-4,0> pigment { Gray05 } }
			rotate 180*x
			translate -5*y
		}
		scale <2.3,1,1>
	}
	sphere { <0,0,0> 0.6
		texture {
			pigment { Gray15 }
			finish { Dull }
		}
		scale <1,1,0.5>
		translate <4.8,-2.5,-0.5>
	}
	translate 2.5*y
	texture {
		pigment { Gray15 }
		normal { dents 0.5 }
	}
}

#declare P_Cloud4_Modified =
pigment {
    wrinkles
    turbulence 0.1
    lambda 2.2
    omega 0.707
    color_map {
        [0.20 SkyBlue * 0.85]
        [0.70 White]
        [1.00 Gray70]
    }
    scale <0.5, 0.15, 1>
}

#declare Sky =
sky_sphere {
	pigment {
  	gradient y
    pigment_map {
			[0.00 SkyBlue]
			[0.10 P_Cloud4_Modified]
    }
  }
}

#declare Ground =
union {
	#if (d_Ground >1)
	object { BarrelStand translate <-137,3,70> }
	object { WoodPile scale 1.2 rotate 40*y translate <92,5,-120> }
	object { Track translate <-16,0,0> }
	object { Wrench rotate <90,-50,0> translate <-20,0,-140> }
	object { Pliers rotate <90,-90,-6> rotate 5*y translate <-93,-1,-115> }
	object { CurvedBar rotate <-150,-5,0> translate <40,8,-112> }
	#end
	object { Ballast translate <0,-19,-2> }
 	#declare R4 = seed(3875)
	union {
		box{ <-1000,-20,-1000><1000,-3,1000> }
		#declare ct = 0
		#while (ct < 10)
			#declare sz = (rand(R4)*60)+70
			#declare sc = (rand(R4)*1.5)+1
			#declare in = (rand(R4)*6)
			#declare ht = in/sz
			#declare an = (rand(R4)*360)
			#declare xx = (rand(R4)*500)-250
			#declare zz = (rand(R4)*600)-300
			sphere {<0,0,0> sz scale <sc,ht,1> rotate an*y translate <xx,-4,zz> }
			#declare ct = ct + 1
		#end
		// big hills in back
		sphere { <0,0,0> 1000 scale <1,0.20,1.5> rotate 0*y translate <-1200,-70,1500> }
		sphere { <0,0,0> 600 scale <1,0.20,1.5> rotate 30*y translate <270,-90,800> }
		sphere { <0,0,0> 2000 scale <1,0.13,0.5> rotate 0*y translate <100,-5,4000> }
		#if (d_Ground > 1)
		texture {
			bozo
   		texture_map {
				[0.10 T_Rock]
				[0.20 T_Grass]
			}
			scale 1.5
		}
		#else
		pigment { Green }
		#end
	}
}


