//  R O C O F A I T . POV
// Author:  Robert J Becraft
// Date:  February, 1998
// "Rock of Faith", an image for the ITRC Competition titled "Great Engineering Feats"
//

#include "colors.inc"    // The include files contain
#include "textures.inc"
#include "glass.inc"
#include "finish.inc"
#include "stones1.inc"

// Switches for development
//#declare noground=yes  // turn off ground render
//#declare nobase=yes  // turn off base render
//#declare notower=yes  // turn off tower render
//#declare nomain=yes  // turn off main aisle and nave render
//#declare noaisle=yes  // turn off side aisle renders
//#declare notrees=yes // turn off trees
//#declare nogarden=yes //turn off corn-stalk garden
#declare skytext=1        //1=clouds for blue sky, white clouds; 2=fog for foggy conditions
#declare Treedet=1     // 1=cones, 2=custom

camera {
    location <190,195,-205> look_at <50,195,70> 
//   location <260, 350, -175>   look_at   <0, 135, 70>  //aerial view from se   (yaz3b)
//     location <200, 300, -155>   look_at  <30,165,50> // closer 3b
//   location <160,180,-175>          look_at  <60,115,0>  // view from south-side
//   location <260,90,-200>          look_at  <60,145,0>  // view from south-side
//   location <-360,150,550>          look_at  <60,145,0>  // view from south-side  far off (yaz3d)
//   location <-135,60,-160>          look_at  <60,185,0>  // view from south-side  far off (yaz3c)
}

light_source{<1500,10000,-10000> color White}
light_source{<-1500,10000,10000> color White shadowless}
//light_source{<145,130,15> color Orange}
//------------------------------------------------------------------------
// BACKGROUND
#if (skytext=1)
   sky_sphere {pigment {wrinkles
      color_map {[.4 rgb <0, .4, .8>] [.9 rgb <.8, .8, .8>]}
      scale <.13, .1, .13>
      translate x * 45}}

#else
#if (skytext=2)
//------------------------------------------------------------
fog {
  color rgb< 0.52, 0.62, 0.72 >
  distance 2400
}
#end
#end

#declare GroundC =
  texture {
  pigment { granite
  color_map {
    [0.5 color Clear]
    [0.6 color MediumForestGreen]
    [0.9 color DarkGreen]
    [1.0 color Green]  } }
  normal { bumps 0.5 }
  scale <.01,.01,.01>
  }
#declare GroundC2 =
  texture {
  pigment { granite
  color_map {
    [0.3 color Clear]
    [0.6 color MediumForestGreen]
    [0.9 color DarkGreen]
    [1.0 color Green]  } }
  normal { bumps 0.5 }
  scale <.03,.01,.03>
  }
#declare White_Brick=texture{
               pigment{brick Grey, White brick_size <1,.5,.5>    mortar 0.075}
}
#declare Red_Brick=texture{
               pigment{brick Grey, Tan brick_size <1,.5,.5>    mortar 0.075}
}
#declare White_Block=texture{
               pigment{brick Grey, White brick_size <2,1,1>    mortar 0.1}
}
#declare Trim_Stone=texture{T_Stone5}
#declare Roof_Text=texture{pigment{color OrangeRed}}   //MediumSlateBlue}}
#declare Deck_Tile=texture{checker texture{pigment{color Wheat}}
                                   texture{pigment{color White}}
                                   scale 2 rotate <0,45,0>
                         }
#declare Glass_Text=texture{checker texture{T_Ruby_Glass}
                                    texture{T_Green_Glass}
                                    scale 1 rotate <45,45,45>
                           }

#declare Evergreen =  // For connifers, pines and the like.
  texture {
  pigment { granite
  color_map {
    [0.4 color Clear]
    [0.5 color Green]
    [0.6 color MediumForestGreen]
    [0.9 color DarkGreen]
    [1.0 color Clear] } }
  finish {
    ambient   0.30
    diffuse   0.50
    brilliance   1.00
    phong   0.1
    phong_size  10.00
  }
  normal { bumps 0.2 }
  scale <.2,.2,.2> }

#declare TreeTrunkTexture = texture {
  pigment { granite
 color_map {
      [0.1 color White]
      [0.2 color Grey]
      [0.8 color Brown]
      [0.9 color DarkGreen]
      [1.0 color Black]}
 }
}
#declare Pine=union{
      cone{<0,6,0>,2 <0,12,0>,.15 texture{Evergreen}}
      cone{<0,0,0>,.15 <0,6,0>,.10 texture{TreeTrunkTexture}}
}


#ifndef(noground)   // if noground variable doesn't exist, add ground
// Ground, water and mound levels
union {
//**************************
// The main ground level
  object {
                height_field { gif  "rocoabby.ghf" }
                texture { pigment { color Grey }  }
                rotate<0,0,0> scale < 750, 127, 750 >   translate < -350, -5, -350 >
  }
  object {
                height_field { gif  "rocoabby.ghf" }
                texture { GroundC  }
                rotate<0,0,0> scale < 750, 127, 750 >   translate < -350, -4.5, -350 >
  }
  object {
                height_field { gif  "rocoabby.ghf" }
                texture { pigment { color Grey }  }
                 scale < 750, 127, 750 >   translate < -400, -5, -400 >
  }
  object {
                height_field { gif  "rocoabby.ghf" }
                texture { GroundC  }
                 scale < 750, 127, 750 >   translate < -400, -4.5, -400 >
  }
  object {
                height_field { gif  "rocgroun.ghf" }
                texture { pigment { color Khaki }  }
                 scale < 2000, 50, 2000 >   translate < -2000, -21, 0 >
  }
  object {
                height_field { gif  "rocgroun.ghf" }
                texture { GroundC2  }
                 scale < 2000, 50, 2000 >   translate < -2000, -19.5, 0 >
  }
  object {
                height_field { gif  "rocgroun.ghf" }
                texture { pigment { color Khaki } }
                 scale < 2000, 50, 2000 >   translate < 0, -5,0 >
  }
  object {
                height_field { gif  "rocgroun.ghf" }
                texture { GroundC2 }
                 scale < 2000, 50, 2000 >   translate < 0, -4.5,0 >
  }
  object {
                height_field { gif  "rocgroun.ghf" }
                texture { pigment { color Khaki }  }
                 scale < 2000, 50, 2000 >   translate < -1997, -21, -2000 >
  }
  object {
                height_field { gif  "rocgroun.ghf" }
                texture { GroundC2  }
                 scale < 2000, 50, 2000 >   translate < -1997, -19.5, -2000 >
  }
  object {
                height_field { gif  "rocgroun.ghf" }
                texture { pigment { color Khaki }  }
                 scale < 2000, 50, 2000 >   translate < 0, -5, -2000 >
  }
  object {
                height_field { gif  "rocgroun.ghf" }
                texture { GroundC2  }
                 scale < 2000, 50, 2000 >   translate < 0, -4.5, -2000 >
  }
//**************************
// Now for a watery plain
  plane {
               < 0,.8,0 >, 0
                texture {
                  pigment { color rgb< 0.0, 0.1, 0.2 > }
                  normal { bumps 0.2  scale < 1, 0.5, 0.5 > }
                  finish { phong 1  reflection 0.5  ambient 0.1  diffuse 0.2 }
                 }
               translate < 0, 0.2 , 0 >
  }
 }
#end // end of noground if

#declare Butt1C=union{
    cylinder{<0,0,0><0,1,0>,1.5 texture{White_Brick}}
    box{<-1,1,-1><1,3,1> texture{White_Brick}}
    cylinder{<0,3,0><0,5,0>,.9 texture{White_Brick}}
    cone{<0,5,0>,1.2<0,17,0>,0 texture{pigment{color Brass}}}
    cylinder{<0,13,0><0,13.2,0>,.75 texture{pigment{color Brass}}}
    cylinder{<0,13.5,0><0,13.7,0>,.5 texture{pigment{color Brass}}}
    sphere{<0,17,0>,.5 texture{pigment{color Blue}}}
  }
#declare Butt2C=union{
    cylinder{<0,0,0><0,.5,0>,1.5 texture{White_Brick}}
    cylinder{<0,.5,0><0,3,0>,.9 texture{White_Brick}}
    cone{<0,3,0>,1.2<0,10,0>,0 texture{pigment{color Brass}}}
    cylinder{<0,8,0><0,8.2,0>,1 texture{pigment{color Brass}}}
    sphere{<0,11,0>,.5 texture{pigment{color Blue}}}
}
#declare Butt1= difference{
    union{
      box{<-1,0,-2><1,190,25> texture{White_Brick}}
      box{<-1.3,0,-2.3><1.3,125,2> texture{White_Brick}}
      box{<-1.5,0,-2.5><1.5,185,2.5> texture{White_Block}}
      box{<-1.5,190,-2.5><1.5,190.5,25> texture{Trim_Stone}}
      object{Butt1C translate<0,191,0>}
    }
    box{<-1.1,-.1,1><1.1,177.5,23>}
    cylinder{<-1.1,177.5,12.5><1.1,177.5,12.5>,10.5}
  }
#declare Butt2= difference{
    union{
       box{<-.8,190,2><.8,217,25> texture{White_Brick}}
       box{<-1,190,1.5><1,210,4> texture{White_Block}}
       box{<-1.3,217,1.5><1.3,218,25> texture{Trim_Stone}}
       object{Butt2C translate<0,218,4>}
    }
    box{<-.9,189.,6><.9,207.5,23>}
    cylinder{<-.9,207.5,13><.9,207.5,13>,8}
  }
#declare Butt3= difference{
    union{
      box{<-.5,217,6><.5,230,25> texture{White_Brick}}
      box{<-1,230,5.5><1,231,25> texture{Trim_Stone}}
      cone{<0,231,6.5>,.95 <0,239,6.5>,0 texture{pigment{color Brass}}}
    }
    box{<-.6,216,10><.6,221,23>}
    cylinder{<-.6,221,16.5><.6,221,16.5>,7}
  }
#declare Buttress=union{
    object{Butt1 texture{White_Brick}}
    object{Butt2 texture{White_Brick}}
    object{Butt3 texture{White_Brick}}
   }

#declare Main1a= union{
             box{<0,115,-15><140,232,35> texture{White_Brick}}
             box{<-.5,187,-15.5><140.5,188,35.5> texture{Trim_Stone}}
             box{<-.5,215,-15.5><140.5,216,35.5> texture{Trim_Stone}}
             #declare Count=0
             #while (Count<8)
               object{Buttress translate<Count*20-1,0,-40>}
               object{Buttress rotate<0,180,0> translate<Count*20-1,0,60>}
               box{<Count*20-1.3,0,-16><Count*20+1.3,234,-15> texture{Trim_Stone}} // near side
               box{<Count*20-1.3,0,35><Count*20+1.3,234,36> texture{Trim_Stone}}   // far side
               #if (Count <7)
                   box{<Count*20+8.7,0,-16><Count*20+10.3,234,-15> texture{Trim_Stone}}
                   box{<Count*20+8.7,0,35><Count*20+10.3,234,36> texture{Trim_Stone}}
               #end
               #declare Count=Count+1
             #end
          }
#declare Win1=union{
             box{<-2,0,-25.6><2,20,25.6>}
             cylinder{<0,20,-25.6><0,20,25.6>,2}
}
#declare Win2=union{
             box{<-1,0,-25.6><1,8,25.6>}
             cylinder{<0,8,-25.6><0,8,25.6>,1}
}
#declare Win3=union{                           // shallow window to make arches in wall
             box{<-3,0,-25.6><3,20,-24.5>}
             cylinder{<0,20,-25.6><0,20,-24.5>,3}
}
#declare Column1=union{
     cylinder{<0,0,0><0,28,0>,.75 texture{Trim_Stone}}       //column
     cylinder{<-.5,30,-.5><-.5,28,.5>,.75 texture{Trim_Stone}}
     cylinder{<.5,30,-.5><.5,28,.5>,.75 texture{Trim_Stone}}
     cylinder{<0,0,0><0,.5,0>,1.1 texture{Trim_Stone}}       //base
  }
#declare Clover=union{
      cylinder{<-.5,0,0><-.5,0,.5>,.65}
      cylinder{<.5,0,0><.5,0,.5>,.65}
      cylinder{<0,.5,0><0,.5,.5>,.65}
      cylinder{<0,-.5,0><0,-.5,.5>,.65}
  }
#declare ButtS=difference{
         box{<-1,0,-3><1,25,3> texture{White_Block}}
         box{<-1.2,20,-8><1.2,28,8>       rotate<-45,0,0> translate<0,5,10> }
//                texture{pigment{color Red}}}
}
#declare Nave=difference{
         union{
             cylinder{<0,115,0><0,116,0>,26.5 texture{White_Block}}
             cylinder{<0,115,0><0,230,0>,25 texture{White_Brick}}
             cylinder{<0,115,0><0,150,0>,26 texture{White_Block}}
             cylinder{<0,230,0><0,230.5,0>,26 texture{Trim_Stone}}
             cylinder{<0,216,0><0,216.5,0>,26 texture{Trim_Stone}}
             cylinder{<0,188,0><0,188.5,0>,26 texture{Trim_Stone}}
             cylinder{<0,158,0><0,158.5,0>,26.5 texture{Trim_Stone}}
             cylinder{<0,155,0><0,158,0>,26 texture{Trim_Stone}}
             cylinder{<0,150,0><0,150.5,0>,26.5 texture{Trim_Stone}}
             cylinder{<0,150,0><0,150.5,0>,26.5 texture{Trim_Stone}}

             cone{<0,230,0>,25 <0,244.5,0>,0  texture{Roof_Text}}
             #declare Count=-15
             #while (Count>-170)
                      triangle{<0,230.5,0><0,245.5,0><0,230.5,-25> rotate<0,Count,0> texture{Roof_Text}}
                      object{Column1 translate<0,158.5,-25.5> rotate<0,Count-10,0>}
                      object{ButtS translate<0,115,-25> rotate<0,Count-10,0> texture{White_Block}}
                      #declare Count=Count-20
             #end
         }
         box{<-30,-1,-30><-1,245,30>}
         cylinder{<0,115,0><0,230,0>,23}  // carve out middle of nave
         #declare Count=-15
         #while (Count>-170)
              object{Win1 rotate<0,Count,0> translate<0,190,0>}
              object{Win2 rotate<0,Count+2.5,0> translate<0,217,0>}
              object{Win2 rotate<0,Count-5,0> translate<0,217,0>}
              object{Win3 rotate<0,Count,0> translate<0,160,0>}
              object{Clover translate<0,156.5,-26.1> rotate<0,Count,0>}
              object{Clover translate<0,156.5,-26.1> rotate<0,Count-10,0>}
              #declare Count=Count-20
         #end
}
#declare Main1= difference{
         object{Main1a}
         box{<2,0,-13><138,225,33>}
         #declare Count=0
         #while (Count<14)
             // 1st Clerestory
               box{<Count*10+2,190,-15.1><Count*10+8,210,35.1>}
               cylinder{<Count*10+5,210,-15.1><Count*10+5,210,35.1>,3}
             //upper clerestory
               box{<Count*10+2,217,-15.1><Count*10+4,225,35.1>}
               box{<Count*10+6,217,-15.1><Count*10+8,225,35.1>}
               cylinder{<Count*10+3,225,-15.1><Count*10+3,225,35.1>,1}
               cylinder{<Count*10+7,225,-15.1><Count*10+7,225,35.1>,1}
             #declare Count=Count+1
         #end
  }
#declare Aisle=difference{
          union{
                     box{<0,115,0><140,165,25> texture{White_Block}}
                     box{<-.5,115,-1><140.5,116,25> texture{White_Block}}
                     box{<-.5,124,-0.5><140.5,125,25.5> texture{Trim_Stone}}
                     box{<-.5,130,-0.5><140.5,131,25.5> texture{Trim_Stone}}
                     box{<-.2,160,-0.2><140.2,162,25.2> texture{Trim_Stone}}
           }
         box{<4,115,2><138,165,23>}   // carve inside
         #declare Count=0
         #while (Count<14)
               object{Win1 translate<Count*10+5,135,0>}
               object{Win1 translate<Count*10+11,135,0>}
             #declare Count=Count+2
         #end
   }
#declare RoofOrnament=union{
     cylinder{<0,-1,0><0,0,0>,.4 texture{pigment{color Brass}}}
     cylinder{<0,-1,0><0,1,0>,.3 texture{pigment{color Brass}}}
     cone{<0,1,0>,.5 <0,4,0>,0 texture{pigment{color Brass}}}
}
#declare RoofOrnament2=union{
     cylinder{<0,-1,0><0,0,0>,.45 texture{pigment{color Brass}}}
     cylinder{<0,-1,0><0,2,0>,.35 texture{pigment{color Brass}}}
     cone{<0,2,0>,.6 <0,7,0>,0 texture{pigment{color Brass}}}
     sphere{<0,5,0>,1 texture{pigment{color Brass}}}
}
#declare Roof=union{
  triangle{<0,165,-40><140,165,-40><140,180,-15> texture{Roof_Text}}
  triangle{<0,165,-40><140,180,-15><0,180,-15> texture{Roof_Text}}

  triangle{<0,232,-15><140,232,-15><140,247,10> texture{Roof_Text}}
  triangle{<0,232,-15><140,247,10><0,247,10> texture{Roof_Text}}

  triangle{<0,165,60><140,165,60><140,180,35> texture{Roof_Text}}
  triangle{<0,165,60><140,180,35><0,180,35> texture{Roof_Text}}

 triangle{<0,232,35><140,232,35><140,247,10> texture{Roof_Text}}
  triangle{<0,232,35><140,247,10><0,247,10> texture{Roof_Text}}

// Add roof seams
 #declare Count=4
 #while (Count<140)
      triangle{<Count,165.5,-40><Count,165.5,-15><Count,180.5,-15> texture{Roof_Text}}
      triangle{<Count,165.5,60><Count,165.5,35><Count,180.5,35> texture{Roof_Text}}
      triangle{<Count,232.5,-15><Count,247.5,10><Count,232.5,10> texture{Roof_Text}}
      triangle{<Count,232.5,35><Count,247.5,10><Count,232.5,10> texture{Roof_Text}}
      object{RoofOrnament translate<Count,247,10>}
     #declare Count=Count+4
#end
  object{RoofOrnament2 translate<139.5,247,10>}
  cylinder{<4,248,10><139.5,248,10>,.3 texture{pigment{color Brass}}}    // support rod

// End blocks
  triangle{<0,165,-40><0,180,-15><0,165,-15> texture{White_Brick}}
  triangle{<140,165,-40><140,180,-15><140,165,-15> texture{White_Brick}}

  triangle{<0,165,60><0,180,35><0,165,35> texture{White_Brick}}
  triangle{<140,165,60><140,180,35><140,165,35> texture{White_Brick}}

  triangle{<0,232,-15><0,247,10><0,232,35> texture{White_Brick}}
  triangle{<140,232,-15><140,247,10><140,232,35> texture{White_Brick}}

  box{<0,165,-41><140,165.5,-40> texture{Trim_Stone}}
  box{<0,165,60><140,165.5,61> texture{Trim_Stone}}

  box{<0,232,-16><140,232.5,-15> texture{Trim_Stone}}
  box{<0,232,35><140,232.5,36> texture{Trim_Stone}}
}
#declare Nglass=difference{
                   cylinder{<0,115,0><0,227,0>,24.5 texture{Glass_Text}}
                   cylinder{<0,114,0><0,227.1,0>,24.499}
                   box{<-30,-1,-30><-1,230,30>}
}
#declare Tower1=union{
    box{<-10,0,-10><10,160,10> texture{White_Block}}
    box{<-9,160,-9><10,220,9> texture{White_Block}}
    box{<-8,220,-8><10,260,8> texture{White_Brick}}
    box{<-9,260,-9><10,260.6,9> texture{Trim_Stone}}
    box{<-9.2,260.6,-9.2><10,261,9.2> texture{Trim_Stone}}

   triangle{<-8,260,-8><10,260,-8><1,316,0> texture{Roof_Text}}
   triangle{<-8,260,-8><-8,260,8><1,316,0> texture{Roof_Text}}
   triangle{<-8,260,8><10,260,8><1,316,0> texture{Roof_Text}}
   triangle{<10,260,8><10,260,-8><1,316,0> texture{Roof_Text}}
   box{<-6,275,-6><7,275.5,7> texture{pigment{color Brass}}}

    box{<-11,0,-11><-9,142,-9> texture{Trim_Stone}}
    box{<-11,0,11><-9,142,9> texture{Trim_Stone}}
    box{<-10,142,-10><-8,222,-8> texture{Trim_Stone}}
    box{<-10,142,10><-8,222,8> texture{Trim_Stone}}
    box{<-9,220,-9><-7,260,-7> texture{Trim_Stone}}
    box{<-9,220,9><-7,260,7> texture{Trim_Stone}}
    box{<8,220,-9><10,260,-7> texture{Trim_Stone}}
    box{<8,220,7><10,260,9> texture{Trim_Stone}}

    cone{<1,313,0>,.5 <1,324,0>,.1 texture{pigment{color Brass}}}
    sphere{<1,319,0>,1 texture{pigment{color Brass}}}
 }
#declare Tower=difference{
    object{Tower1}
    box{<-7,200,-7><9,240,7>}   // hollow top part
    object{Win1 scale .8 translate<-3,240,0>}
    object{Win1 scale .8 translate<4,240,0>}
    object{Win1 scale .8 rotate<0,90,0> translate<0,240,-3>}
    object{Win1 scale .8 rotate<0,90,0> translate<0,240,4>}
}
#declare DoorS1=difference{
     union{
        box{<-3,0,-3><3,130,3> texture{White_Brick}}
        triangle{<-3,136,-3><-3,136,3><3,130,3> texture{Roof_Text}}
        triangle{<3,130,3><-3,136,-3><3,130,-3> texture{Roof_Text}}
        triangle{<-3,136,-3><3,130,-3><-3,130,-3> texture{White_Brick}}
       }
       box{<-2,0,-3.1><2,126,-1>}   // carve doorway
}
#declare DoorS=union{
       object{DoorS1 texture{White_Brick}}
       box{<-3,115,-9><3,115.5,-1> texture{Trim_Stone}}
       box{<-3,115.5,-8><3,116,-1> texture{Trim_Stone}}
       box{<-3,116,-7><3,116.5,-1> texture{Trim_Stone}}
       box{<-3,116.5,-6><3,117,-1> texture{Trim_Stone}}
       box{<-2,117,-1.1><2,126,-1> texture{pigment{color Brown}}}
}


// Define some trees for scale...
#declare TR=seed(99)
#declare Trees=union{
// cones for trees
#if (Treedet=1)
   #declare MaxC=int(rand(TR)*20+10)    // how many (at least 10)
   #declare Count=1                                        // start at 1
   #while (Count <=MaxC)
//     #debug "xxxx"
       #declare xx=int(rand(TR)*40)              // x coord offset
       #declare yy=int(rand(TR)*40)             // y coord offset
       #declare Tscale=int(rand(TR)*2)+1.3
       object{Pine scale<1+Tscale,1+Tscale,1+Tscale> translate<xx,0,yy>}
       #declare Count=Count+1
    #end

#else
// detail trees
  #declare TR=seed(448)
  #declare X=1
  #declare MaxC=int(rand(TR)*20+15)    // how many (at least 15)
  #while (X<MaxC)
      #declare TR=seed(X*10+5)
      #declare xx=int(rand(TR)*40)       // x-coord
      #declare zz=int(rand(TR)*40)       // z-coord
      #include "tree2a.inc"
      object{A_Tree   translate<xx,8,zz>}
      #declare X=X+1
  #end //while
#end //if
}
//-------STAIRS ------------------------------------------------------
#declare Stair20=union{
     #declare Count = -10                                // Cut out stairs
     #while (Count < 11)
         box{<Count-1,Count-1,-2.5><10,Count,2.5> texture{Red_Brick}}
         box{<Count-1,Count,-2.6><Count,Count+.01,2.6> texture{pigment{color Wheat}}} //tread
         #declare Count = (Count + 1)
     #end
     box{<10,-10,-2.5><15,10,2.5> texture{Red_Brick}}
     box{<10,10,-2.6><15,10.01,2.6> texture{pigment{color Wheat}}}
}
#declare TheBase=union{
  box{<-40,0,-60><180,114.9,80> texture{Red_Brick}}
  box{<-40,114.9,-60><180,115,80> texture{Deck_Tile}}
     #declare Count = -40
     #while (Count < 85)
          box{<Count-1,0,-61><Count+1,119,-59> texture{Red_Brick}}
          box{<Count-1,0,79><Count+1,119,81> texture{Red_Brick}}                 // far side
          box{<-41,0,Count-21><-39,119,Count-19> texture{Red_Brick}}
          #declare Count = Count + 15
     #end //while

     cylinder{<-40,118,-60><-40,118,-60+14>,.15 texture{pigment{color Brass}}}
     cylinder{<-40,116,-60><-40,116,-60+14>,.15 texture{pigment{color Brass}}}
     cylinder{<-40,118,-60><-40+14,118,-60>,.15 texture{pigment{color Brass}}}
     cylinder{<-40,116,-60><-40+14,116,-60>,.15 texture{pigment{color Brass}}}

     cylinder{<-40,118,-30><-40,118,80>,.15 texture{pigment{color Brass}}}
     cylinder{<-40,116,-30><-40,116,80>,.15 texture{pigment{color Brass}}}
     cylinder{<-10,118,-60><80,118,-60>,.15 texture{pigment{color Brass}}}
     cylinder{<-10,116,-60><80,116,-60>,.15 texture{pigment{color Brass}}}

  box{<-60,0,-66><80,93.9,105> texture{Red_Brick}}
  box{<-60,93.9,-66><80,94,105> texture{Deck_Tile}}
     #declare Count = -61
     #while (Count < 80)
          box{<Count-1,0,-67><Count+1,98,-65> texture{Red_Brick}}
          box{<-61,0,Count-6><-61,98,Count-4> texture{Red_Brick}}
         #declare Count = Count + 15
    #end

     cylinder{<-60,98,-66><-60,98,80>,.15 texture{pigment{color Brass}}}
     cylinder{<-60,96,-66><-60,96,80>,.15 texture{pigment{color Brass}}}
     cylinder{<-45,98,-66><80,98,-66>,.15 texture{pigment{color Brass}}}
     cylinder{<-45,96,-66><80,96,-66>,.15 texture{pigment{color Brass}}}

  box{<-68,0,-72><80,73.9,150> texture{Red_Brick}}
  box{<-68,73.9,-72><80,74,150> texture{Deck_Tile}}
     #declare Count = -69
     #while (Count < 80)
          box{<Count-1,0,-73><Count+1,79,-71> texture{Red_Brick}}
         #declare Count = (Count + 15)
    #end

     cylinder{<-68,78,-72><-70+45,78,-72>,.15 texture{pigment{color Brass}}}
     cylinder{<-68,76,-72><-70+45,76,-72>,.15 texture{pigment{color Brass}}}

     cylinder{<-68,78,-72><-40,78,80>,.15 texture{pigment{color Brass}}}
     cylinder{<-68,76,-72><-40,76,80>,.15 texture{pigment{color Brass}}}
     cylinder{<-10,78,-72><80,78,-72>,.15 texture{pigment{color Brass}}}
     cylinder{<-10,76,-72><80,76,-72>,.15 texture{pigment{color Brass}}}

  box{<-73,0,-78><80,53.9,150> texture{White_Block}}
  box{<-73,53.9,-78><80,54,150> texture{Deck_Tile}}
  object{Stair20 rotate<0,-90,0> translate<-42.5,104,-50>}
  object{Stair20 rotate<0,0,0> translate<-30,104,-62.5>}
  object{Stair20 rotate<0,180,0> translate<-40,84,-67.5>}
  object{Stair20 rotate<0,0,0> translate<-30,64,-73.5>}
}
//---------defs for garden -------------
#declare S1=seed(12345)
#declare Garden1=union{
     box{<-50,0,-3><50,.1,3> texture{pigment{color Tan}}finish{crand .05}}
     #declare County=-2.5
     #while (County<=2.5)
       #declare Countx=-50
       #while (Countx<50)
           cone{<Countx,0,County>,.02<Countx,3,County>,.01  texture{pigment {color Green}}}
           #declare LC=rand(S1)*8+4
           #declare LCount=1
           #while (LCount <=LC)
               #declare BH=rand(S1)*1.5
               #declare BW=rand(S1)*.9
               #declare BO=rand(S1)*3
               #declare BR=rand(S1)*360
               triangle{<0,BO,0>
                               <0+(BW/2),BH+BO,BW/2><BW/2+.1,BH+BO,(BW/2)> 
                         rotate<0,BR,0> translate<Countx,0,County>
                         texture{pigment{color Green}}}
               triangle{<(BW/2),BH+BO,(BW/2)><(BW/2)+.1,BH+BO,(BW/2)> 
                               <BW,BO+(BH/2),BW> 
                          rotate<0,BR,0> translate<Countx,0,County>
                          texture{pigment{color Green}}}
               #declare LCount=LCount+1
           #end  // while
           #declare Countx=Countx+(rand(S1)*.8)
        #end // while
       #declare County=County+1.25
     #end //while
}


//---------------------------------------OBJECTS
#ifndef(notrees)
 object{Trees translate<100,115,-110>}
 object{Trees translate<185,115,-40>}
 object{Trees translate<-100,65,-65>}
#end
#ifndef(nogarden)
  object{Garden1 translate<55,115,-50>}
  object{Garden1 rotate<0,90,0> translate<176,115,15>}
#end
#ifndef(nobase)
  object{TheBase}
#end

// front towers
#ifndef(notower)
object{Tower translate<-12,0,-15> texture{White_Brick}}
object{Tower translate<-12,0,25> texture{White_Brick}}
#end

#ifndef(nomain)
object{Main1 texture{pigment{color Wheat}}}
    object{Nave texture{White_Brick} translate<140,0,10>}
    object{Nglass translate<140,0,10> texture{Glass_Text}}
    object{Roof}
    box{<0,190,-14.5><140,230,-14.499> texture{Glass_Text}} //windows near side
    box{<0,190,34.499><140,230,34.5> texture{Glass_Text}}   //windows far side
    object{DoorS translate<143,0,-18>}
    object{DoorS translate<-3,0,-18>}
#end

#ifndef(noaisle)
// side aisles
object{Aisle translate<0,0,-40> texture{White_Block}}
object{Aisle translate<0,0,35> texture{White_Block}}
    box{<0,163,-39.499><140,140,-39.5> texture{Glass_Text}} //aisle windows near side
    box{<0,163,59.499><140,140,59.5> texture{Glass_Text}}   //aisle windows far side
#end

//*END
