// the_stand.inc
// Robert Fremin 1998
// objects:
//		the_stand
//		(pod)
//		pods

#include "tex.inc"


#declare Ibalk =
union
{
	box { <-.2,  .1, -.2>  <8.2,  .15, .2>  }
	box { <-.2, -.1, -.05> <8.2,   .1, .05> }
	box { <-.2, -.1, -.2>  <8.2, -.15, .2>  }

	#if (final)
		box { <-.025, -.1, -.2> <.025, .1, .2> }

		box { <4-.15, -.1, -.2> <4-.1, .1, .2> }
		box { <4-.025, -.1, -.2> <4.025, .1, .2> }
		box { <4.1, -.1, -.2> <4.15, .1, .2> }

		box { <8-.025, -.1, -.2> <8.025, .1, .2> }
	#end
}

#declare Pod =
union
{
	union
	{
		cone { y*2.5 .25 y*2.75 .15 }
		cylinder { y*2.4 y*2.5 .4 }

		// bolts
		#if (final)
			#declare c = 0
			#while (c < 10)
				cylinder { <.3,2.5,0> <.3,2.55,0> .05 rotate y*c*36 }
				#declare c = c + 1
			#end
		#end

		texture { WhitePaint }
	}

	#declare vA = <-.7, -5, -.7>
	#declare vB = < .7, -5, -.7>
	#declare vC = < .7, -5,  .7>
	#declare vD = <-.7, -5,  .7>
	#declare va = <-.5, 2.4, -.5>
	#declare vb = < .5, 2.4, -.5>
	#declare vc = < .5, 2.4,  .5>
	#declare vd = <-.5, 2.4,  .5>

	// front
	triangle { vA vB va }
	triangle { va vb vB }

	// right
	triangle { vB vC vb }
	triangle { vb vc vC }

	// back
	triangle { vC vD vc }
	triangle { vc vd vD }

	// left
	triangle { vD vA vd }
	triangle { vd va vA }

	// top
	triangle { va vb vc }
	triangle { vc vd va }
}

#declare part1 =
prism
{
	linear_sweep
	linear_spline
	0 .1
	5, <0,0> <.3, 0> <.1, 1.5> <0, 1.5> <0, 0>

	rotate x*-90
}

#declare part2 =
prism
{
	linear_sweep
	linear_spline
	0 .1
	5, <0,0> <.2, 0> <.1, 1.5> <0, 1.5> <0, 0>

	rotate x*-90
}

#declare Support_pipe =
union
{
	cylinder { y*0   y*4.4 .15  }

	#if (final)
		cylinder { y*3.7 y*3.8 .24 }
		cylinder { y*.9  y*1  .24 }
	#end
}

#declare Support_pipe2 =
union
{
	cylinder { y*0   y*3.8 .15  }

	#if (final)
		cylinder { y*3.2 y*3.3 .24 }
		cylinder { y*.9  y*1  .24 }
	#end
}

#declare Support_pipe3 =
union
{
	cylinder { y*0   y*5.4 .1  }

	#if (final)
		cylinder { y*2.9 y*2.95 .15 }
		cylinder { y*.9  y*.95  .15 }
	#end
}

#declare Support_pipes =
union
{
	object { Support_pipe  rotate <18, 0, 38> translate <4, 2.9, -2.3> }
	object { Support_pipe2 rotate <20, 0, -25> translate <.1, 2.9, -2.3> }
	object { Support_pipe2 rotate <20, 0, -25> translate <.1, 2.9, -2.3> scale <-1,1,1> }
	object { Support_pipe3 rotate <9, 0, 0> translate <0, 2.9, -2.3> }
}

#declare pods =
union
{
	object { Pod translate vrotate(<-4, 0, -2.3>,y*30) }
	object { Pod translate vrotate(< 4, 0, -2.3>,y*30) }
	object { Pod translate vrotate(< 0, 0,  4.7>,y*30) }
/*
	pigment { Gray50 }
	#if (final)
		normal { bumps scale <.5,1.5,.5> }
	#end
*/
}

#declare the_stand =
union
{
	// the body
	cylinder { y*7.8 y*8 1.4 }
	cylinder { y*7.7 y*7.8 1.8 }
	cylinder { y*6.2 y*7.7 1.7 }
	cylinder { y*6.1 y*6.2 2 }

	#if (final)
		#declare c = 0
		#while (c < 6)
			object { part1 translate <1.7, 6.2, 0> rotate y*(c*60+30) }
			object { part2 translate <1.7, 6.2, 0> rotate y*(c*60) }
			#declare c = c + 1
		#end
	#end

	intersection
	{
		plane { y, 6.1 }
		#declare c = 0
		#while (c < 6)
			plane { x, 1.45 rotate y*(c*60+30) }
			#declare c = c + 1
		#end
		plane { -y, -2.8 }
	}

	box { <-1,-1,-1> <1,1,1> scale .5 translate <1.2,3.9,0> rotate y*30 }

	// the balks
	union
	{
		object { Ibalk translate <-4, 2.9, -2.3> }
		object { Ibalk rotate y*-120 translate <4, 2.9, -2.3> }
		object { Ibalk rotate y*-60 translate <-4, 2.9, -2.3> }
		clipped_by { plane { -z, 2.3+.2+.001 } }
		rotate y*30
	}

	// concrete base
//	object { pods }

	// the pipes
	union
	{
		object { Support_pipes }
		object { Support_pipes rotate y*120 }
		object { Support_pipes rotate y*240 }
		clipped_by { plane { y, 6.05 } }
		clipped_by { plane { -y, -3 } }
		rotate y*30
	}

	// cable post
	union
	{
		cylinder { y*1.1 y*3 .1 }
		cone { y*1 .15 y*1.1 .1 }
		cylinder { y*-5 y*1 .15 }
		translate x*.5
	}

	box { <-.03,-.05,0> <.03,.05,4> rotate x*60 translate <-1,3,-1> }
	box { <-.03,-.05,0> <.03,.05,4> rotate x*60 translate <0,3,-1> }
	#declare c = 0
	#while (c < 10)
		box { <0,0,0> <1,.05,.15> translate vrotate(z*c*.4,x*60)+<-1,3,-1> }
		#declare c = c + 1
	#end

	texture { WhitePaint }
}
