#include "colors.inc"
#include "yerketex.inc"

global_settings { max_trace_level 7}

background {color 1*White}

//#declare the_camera =

//camera {location <0, 15, -100> look_at <0, 30, 0>
camera {location <60, 15, -80> look_at <-20, 30, 0> angle 60
//camera {location <-80, 15, -100> look_at <-80, 15, 0> angle 30
//look_at <0, 40, -13> angle 30
}


light_source {<9000, 8000, -4000> color 2.5*White}
light_source {<-80, 50, -100> color rgb <0.3, 0.3, 0.31> shadowless}
 

#declare dfault = texture {base_texture}

//base of dome
union {
superellipsoid {<1, .2> scale <12.25, 12.25, 2> rotate 90*x translate 48*y}
cone {<0, 46.5, 0>, 12.5, <0, 47, 0>, 12.75}
texture {dome_texture}
}

#declare change = 0
#while (change < 180)
box {<-.2, 46.5, -12.75>, <.2, 46.75, 12.75> texture {dfault} rotate change*y}
box {<-.2, 46, -12.25>, <.2, 46.5, 12.25> texture {dfault} rotate change*y}
cylinder {<-.2, 46.5, -12.25>, <.2, 46.5, -12.25>, .25 texture {dfault} rotate change*y}
cylinder {<-.2, 46.5, 12.25>, <.2, 46.5, 12.25>, .25 texture {dfault} rotate change*y}
#declare change = change + 10
#end

//first section
union {
cylinder {<0, 44, 0>, <0, 45, 0>, 12.1 texture {light_band}} //light band
cylinder {<0, 44.6, 0>, <0, 44.8, 0>, 12.3 texture {frilly}} //frilly band
difference {
cylinder {<0, 37, 0>, <0, 47, 0>, 12
pigment {
image_map {
tga "brick2.tga"
map_type 2
interpolate 2
}
scale <10, 25, 10>
}
finish {ambient .1 diffuse .7}
}

cylinder {<0, 37, 0>, <0, 46, 0>, -10.5 texture {window_frame}} //makes place for windows
#declare change1 = 0
#while (change1 < 360)
union {
box {<-1.5, 37, -13>, <1.5, 44, -11> } //shallow cut
box {<-1, 37, -14>, <1, 39.5, -10>}
box {<-1, 40, -14>, <1, 43.5, -10>}
texture {window_frame}
rotate change1*y
}
#declare change1 = change1 + 45
#end
}
//the window glass
cylinder {<0, 37, 0>, <0, 46, 0>, -10.505 texture {window_glass}}
}
//walkway

cylinder {<0, 36.5, 0>, <0, 37, 0>, 15.5 texture {light_band}}//part of rail
cone {<0, 34, 0>, 13.5, <0, 37, 0>, 15.5 texture {column_cap}}
cylinder {<0, 32, 0>, <0, 34, 0>, 14 texture {light_band2}} //next section up
cone {<0, 35, 0>, 14.5, <0, 37, 0>, 15.25 texture {dfault}}//next one down
cone {<0, 31.5, 0>, 13, <0, 32, 0>, 13.5 texture {light_band}} //part just above column

//the railing and circles
#declare part1 =
difference { //the railing
cylinder {<0, 37.2, 0>, <0, 40, 0>, 15.3 }
cylinder {<0, 37, 0>, <0, 41, 0>, 15.2 }
}

#declare part2 =
union {
#declare make_circles = 0
#while (make_circles < 360)
union {
difference { //the circles
cylinder {<0, 38.6, -16>, <0, 38.6, -13>, 1.2}
cylinder {<0, 38.6, -17>, <0, 38.6, -12>, 1}
}
difference { //small circles
cylinder {<0, 38.6, -16>, <0, 38.6, -13>, .8}
cylinder {<0, 38.6, -17>, <0, 38.6, -12>, .6}
rotate 5.625*y
}
box {<-.8, 38.5, -16>, <.8, 38.7, -13>}
rotate make_circles*y
}
#declare make_circles = make_circles + 11.25
#end
}

intersection {
object {part1}
object {part2}
texture {rail_texture}
}

//top of rail
torus {15.3, .2 translate 39.85*y
texture {rail_texture}
}

//bottom of rail
torus {15.3, .175 translate 37.35*y
texture {rail_texture}
}

//make support for railing
#declare make_rail = 0
#while (make_rail < 360)
cylinder {<0, 37, -15.3>, <0, 39.8, -15.3>, .2
//box {<-.2, 37, -15.4>, <.2, 39.8, -15.2>
texture {rail_texture} rotate 11.25*y rotate make_rail*y}
#declare make_rail = make_rail + 22.5
#end

//details below walkway
#declare change2 = 0
#while (change2 < 360)
union {
box {<-.3, 34.5, -14.75>, <.3, 35, 14.75>}
cylinder {<-.3, 34.5, -14>, <.3, 34.5, -14>, .5}
texture {dfault}
rotate change2*y
}
#declare change2 = change2 + 10
#end

//rail

//second section
//creates middle section and parts to subtract from it

#declare middle =
union {
cylinder {<0, 12, 0>, <0, 24, 0>, 13 texture {dfault}}
cylinder {<0, 24.5, 0>, <0, 32, 0>, 12.5 texture {dfault}}
cylinder {<0, 29, 0>, <0, 32, 0>, 13 texture {dfault}}
cone {<0, 24, 0>, 13, <0, 24.5, 0>, 12.5 texture {dfault}}
cylinder {<0, 23, 0>, <0, 24, 0>, 13.1 texture {light_band}} //lighter band
cylinder {<0, 23.6, 0>, <0, 24, 0>, 13.3 texture {frilly}} //frilly band
}

#declare window1 = union {  //top windows
cylinder {<0, 29, -15>, <0, 29, -11>, .6} //window frame
box {<-.6, 25, -15>, <.6, 29, -11>}

cylinder {<0, 29, -15>, <0, 29, -9>, .35} //windows
box {<-.35, 25.5, -15>, <.35, 26.75, -9>}
box {<-.35, 27, -15>, <.35, 28.75, -9>}
texture {window_frame}
}

#declare window2 = union { //bottom windows
cylinder {<0, 21, -14>, <0, 21, -12.5>, .75} //window framing
box {<-.75, 12, -14>, <.75, 21, -12.5>}

cylinder {<0, 21, -14>, <0, 21, -11>, .5} //the window holes
box {<-.5, 17, -14>, <.5, 21, -9>}
box {<-.5, 12.25, -14>, <.5, 16.75, -9>}
texture {window_frame}
}

#declare arch1 = //union {
cylinder {<0, 30, -14>, <0, 30, -12.5>, 1.5}
//box {<-1.8, 29, -14>, <1.8, 30, -12.25>}
//}

#declare arch2 = union {  //deeper arch
cylinder {<0, 30, -14>, <0, 30, -12>, 1.25}
box {<-2, 27, -14>, <2, 30, -12>}
box {<-3, 24.5, -14>, <3, 27, -12>}
}


#declare together = union {
object {window1}
object {window2}
object {arch1}
object {arch2}
}

union {
cylinder {<0, 12, 0>, <0, 24, 0>, 12.05 texture {window_glass}}//makes window glass on bottom
cylinder {<0, 25, 0>, <0, 32, 0>, 11.05 texture {window_glass}}//makes window glass on top
difference {
object {middle}
cylinder {<0, 12, 0>, <0, 24, 0>, 12} //cuts center out bottom of middle section
cylinder {<0, 25, 0>, <0, 32, 0>, 11} //cuts center out of top of middle section
#declare change3 = 0
#while (change3 < 360)
object {together rotate change3*y}
#declare change3 = change3 + 22.5
#end
texture {dfault}
}
}

//columns on middle section
#declare columns = union {
cylinder {<0, 24, -12.5>, <0, 30, -12.5>, .3}
torus {.35, .1 translate <0, 25.4, -12.5>}
box {<-.4, 24, -12.9>, <.4, 25, -12.1>}
sphere {<0, 25, -12.5>, .3}
//cap for columns
prism {
conic_sweep
linear_spline
.6,
1,
5,
<-.6, .6>, <.6, .6>, <.6, -.6>, <-.6, -.6>, <-.6, .6>
scale <1, 3, 1>
translate <0, 27, -12.5>
}
texture {dfault}
}

#declare two_columns = union {
object {columns rotate 8*y}
object {columns rotate 14.25*y}
}

//make the small columns circle building
#declare make_all = 0
#while (make_all < 360)
object {two_columns rotate make_all*y}
#declare make_all = make_all + 22.5
#end

//temporary column
#declare column = union {
cylinder {<0, 11, -13>, <0, 32, -13>, .5}
cone {<0, 30, -13>, .5, <0, 32, -13>, .75 texture {column_cap}}
//tops
cylinder {<.4, 31.75, -13.5>, <.4, 31.75, -14>, .4}
cylinder {<-.4, 31.75, -13.5>, <-.4, 31.75, -14>, .4}

//base of column
torus {.55, .1 translate <0, 12.7, -13>}
#declare base_section = union {
sphere {<0, 11.5, -13>, 1}
box {<-.6, 11.5, -13.6>, <.6, 12.1, -12.4>}
}
intersection {
object {base_section}
box {<-.6, 11, -13.6>, <.6, 13, -12.4>}
}
texture {dfault}
rotate 11.25*y
}

#declare change4 = 0
#while (change4 < 360)
object {column rotate change4*y}
#declare change4 = change4 + 22.5
#end

//bottom section
#declare bottom =
union {
cylinder {<0, 0, 0>, <0, 11.5, 0>, 14 texture {bottom_texture}}
cylinder {<0, 11, 0>, <0, 11.5, 0>, 14.1 texture {light_band}} //light band
cone {<0, 11.5, 0>, 14.2, <0, 12, 0>, 13}
texture {dfault}
}

union {
difference {
object {bottom}
#declare change5 = 0
#while (change5 < 360)
union {
box {<-2,  4, -15>, <2, 9, -12>} //makes window frame
box {<-1.5, 4.5, -15>, <1.5, 6.25, -10>} //window holes
box {<-1.5, 6.75, -15>, <1.5, 8.5, -10>}
texture {window_frame}
rotate change5*y
}
#declare change5 = change5 + 90
#end
cylinder {<0, 0, 0>, <0, 12, 0>, 11 texture {window_frame}} //cuts middle out of bottom
}
cylinder {<0, 0, 0>, <0, 12, 0>, 11.05 texture {window_glass}}//makes window glass for bottom
}

//______________________________________________________________________________________________________________
//________________________________++______________________________++__________________________++________________

//mid part of complex
//box {<-7, 0, 7>, <7, 27, 25> texture {dfault}}//behind dome

#declare main_building = union { //groups whole thing for difference later

//main building
#declare solid_section =
union {
difference {
box {<-160, 0, 25>, <0, 27, 40> }
box {<-155, .1, 27>, <-.5, 26.5, 35> pigment {color rgb <0.1, 0.1, 0.1>}}
texture {dfault}
}//main block

//first group of lines
box {<-160, 27, 23>, <0, 27.5, 25> texture {dfault}}
difference {
cylinder {<-160, 27, 25>, <0, 27, 25>, 1.4 texture {dfault}}
box {<-160, 27, 23>, <0, 29, 25> texture {dfault}}
}
//squares here
#declare squares = 0
#while (squares < 160)
box {<-.2, 26.5, 24>, <.2, 27.5, 25> texture {dfault} translate -squares*x}
#declare squares = squares + 1
#end

//second group
box {<-160, 21, 24.5>, <0, 22, 25> texture {dfault}}
box {<-160, 21.6, 24>, <0, 22, 25> texture {frillyx}}

//third group
difference {
box {<-160, -.75, -.75>, <0, .75, .75> rotate 45*x translate <0, 9, 25>}
box {<-160, 7, 23>, <0, 9.3, 25>}
texture {dfault}
}

//top
box {<-160, 27, 27>, <0, 30, 40> texture {dfault}}
cylinder {<-160, 29.5, 27>, <0, 29.5, 27>, .25 texture {frillyx}}

#declare start_window =
union {
cylinder {<0, 16.5, 24>, <0, 16.5, 25>, 3}
cylinder {<-4, 16.5, 24>, <-4, 16.5, 25>, 3}
cylinder {<4, 16.5, 24>, <4, 16.5, 25>, 3}
}

#declare window_tops =
difference {
object {start_window}
cylinder {<0, 16.5, 23>, <0, 16.5, 24.75>, 2.6}
cylinder {<-4, 16.5, 23>, <-4, 16.5, 24.75>, 2.6}
cylinder {<4, 16.5, 23>, <4, 16.5, 24.75>, 2.6}
box {<-8, 10, 22>, <8, 15.5, 25>}
texture {light_stone}
}

//circles
#declare circles = 8
#while (circles < 160)
cylinder {<0, 23.5, 24.5>, <0, 23.5, 25>, 1.5 translate -circles*x texture {dfault}}
object {window_tops translate -circles*x}
#declare circles = circles + 16
#end
}

#declare group =  //center window on top
union {
cylinder {<0, 16.5, 24>, <0, 16.5, 28>, 1.5}//top part
box {<-1.5, 9.5, 24>, <1.5, 16.5, 28>}

box {<-1.5, 0, 24>, <1.5, 6, 28>}//bottom window
}

#declare window_group =
union {
object {group}
object {group translate -4*x}
object {group translate 4*x}
texture {light_stone}
}

difference {
object {solid_section}
//holes in circles
#declare circles2 = 8
#while (circles2 < 160)
cylinder {<0, 23.5, 24>, <0, 23.5, 27>, 1.25 translate -circles2*x texture {dfault}}
object {window_group translate -circles2*x texture {dfault}}
#declare circles2 = circles2 + 16
#end
}

//glass for windows
#declare top_glass1 =
union {
cylinder {<0, 16.5, 26.5>, <0, 16.5, 27>, 1.5}//top part
box {<-1.5, 9.5, 26.5>, <1.5, 16.5, 27>}
box {<-1.5, 0, 26.5>, <1.5, 6, 27>}//bottom window
}

#declare top_glass2 =
union {
object {top_glass1}
object {top_glass1 translate -4*x}
object {top_glass1 translate 4*x}
texture {window_glass}
}

#declare final_glass = 8
#while (final_glass < 160)
object {top_glass2 translate -final_glass*x}
#declare final_glass = final_glass + 16
#end

}//end of union.  Isn't visible yet.

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

//entrance

//big block
#declare main_part =
union {
box {<-95, 0, 18>, <-65, 25, 25>}
//four square columns
box {<-96, 0, 17>, <-94, 25, 19>}
box {<-88, 0, 17>, <-86, 25, 19>}
box {<-74, 0, 17>, <-72, 25, 19>}
box {<-66, 0, 17>, <-64, 25, 19>}


//top
box {<-95, 27, 19>, <-65, 30, 25>}
//two columns
box {<-95.5, 27, 18.75>, <-94, 30, 20>}
box {<-66, 27, 18.75>, <-64.5, 30, 20>}
//trim
cylinder {<-95.5, 30, 19>, <-64.5, 30, 19>, .25 texture {frillyx}}//front
cylinder {<-95.5, 30, 19>, <-95.5, 30, 25>, .25 texture {frillyz}}//left
cylinder {<-64.5, 30, 19>, <-64.5, 30, 25>, .25 texture {frillyz}}//right

//square and sphere on top
box {<-87, 27, 18.5>, <-73, 32, 28>}
//two columns
box {<-87.5, 27, 18.25>, <-86, 32, 19.5>}
box {<-74, 27, 18.25>, <-72.5, 32, 19.5>}
//trim
cylinder {<-87.5, 32, 18.25>, <-72.5, 32, 18.25>, .25 texture {frillyx}}//front
cylinder {<-87.5, 32, 18.25>, <-87.5, 32, 28>, .25 texture {frillyz}}//left
cylinder {<-72.5, 32, 18.25>, <-72.5, 32, 28>, .25 texture {frillyz}}//right
//thing on top
box {<-81.5, 32, 21>, <-78.5, 33, 23>}
cylinder {<-80, 32, 22>, <-80, 35.5, 22>, .5}
torus {1, .2 translate <-80, 33.5, 22>}
torus {.75, .1 translate <-80, 34, 22>}
sphere {<-80, 35.5, 22>, 1.5}

//first lines
box {<-97, 27, 15>, <-63, 27.5, 17>}//front
box {<-97, 27, 15>, <-95, 27.5, 25>}//left
box {<-65, 27, 15>, <-63, 27.5, 25>}//right
difference { //front
cylinder {<-97, 27, 17>, <-63, 27, 17>, 1.4}
box {<-97, 27, 15>, <-63, 29, 17>}
}
difference {//left
cylinder {<-95.6, 27, 17>, <-95.6, 27, 25>, 1.4}
box {<-98, 27, 15>, <-93, 29, 25>}
}
difference {//right
cylinder {<-64.4, 27, 17>, <-64.4, 27, 25>, 1.4}
box {<-67, 27, 15>, <-60, 29, 25>}
}

//second lines
     //front
difference {
box {<-95, 21, 17.75>, <-65, 22, 18>}
box {<-86, 20, 17>, <-74, 23, 19>}
}
difference {
box {<-95, 21.5, 17.25>, <-65, 22, 18>}
box {<-86, 20, 17>, <-74, 23, 19>}
texture {frillyx}
}
    //left
box {<-95.3, 21, 17.75>, <-95, 22, 25>}
box {<-96, 21.5, 17.75>, <-95, 22, 25> texture {frillyz}}
    //right
box {<-64.7, 21, 17.75>, <-65, 22, 25>}
box {<-64, 21.5, 17.75>, <-65, 22, 25> texture {frillyz}}

//third group
difference {
box {<-95, -.75, -.75>, <-65, .75, .75> rotate 45*x translate <0, 9, 18>}
box {<-160, 7, 15>, <0, 9.3, 25>}
}

//left arch
difference {
cylinder {<-91, 18, 17>, <-91, 18, 18>, 3}
cylinder {<-91, 18, 16>, <-91, 18, 18>, 2.75}
box {<-94, 12, 16>, <-88, 18, 19>}
}

//right arch
difference {
cylinder {<-69, 18, 17>, <-69, 18, 18>, 3}
cylinder {<-69, 18, 16>, <-69, 18, 18>, 2.75}
box {<-72, 12, 16>, <-66, 18, 19>}
}

//middle arch
difference {
cylinder {<-80, 18, 17>, <-80, 18, 18>, 6}
cylinder {<-80, 18, 16>, <-80, 18, 17.75>, 5.75}
cylinder {<-80, 18, 16>, <-80, 18, 17.9>, 4.75}
cylinder {<-80, 18, 16>, <-80, 18, 17.95>, 4.25}
box {<-86, 10, 15>, <-74, 16, 19>}
}

//area around holes
cylinder {<-91, 24, 17.5>, <-91, 24, 18>, 1.5}
cylinder {<-69, 24, 17.5>, <-69, 24, 18>, 1.5}
cylinder {<-95.5, 24, 22>, <-95, 24, 22>, 1.5}
cylinder {<-65, 24, 22>, <-64.5, 24, 22>, 1.5}

texture {dfault}
}

#declare left_opening =
union {
cylinder {<-91, 18, 13>, <-91, 18, 30>, 2}
box {<-93, 15, 13>, <-89, 17, 30>}
box {<-94, 9, 12>, <-88, 16, 31>}
}

#declare right_opening =
union {
cylinder {<-69, 18, 13>, <-69, 18, 30>, 2}
box {<-71, 15, 13>, <-67, 17, 30>}
box {<-72, 9, 12>, <-66, 16, 31>}
}

#declare middle_opening =
union {
cylinder {<-80, 18, 13>, <-80, 18, 30>, 4}
box {<-84, 7, 13>, <-76, 16, 50>}
box {<-86, 8, 13>, <-74, 16, 30>}
}

#declare need_this =
union {
object {main_building} //from previous section
object {main_part} //of entrance
}

//TAKE WHOLE MESS AND MAKE ONE FOR COPY

#declare big_mess = union {

difference {
object {need_this}
object {left_opening}
object {right_opening}
object {middle_opening}
//holes front and center
cylinder {<-91, 24, 16>, <-91, 24, 20>, 1}
cylinder {<-69, 24, 16>, <-69, 24, 20>, 1}
cylinder {<-97, 24, 22>, <-94, 24, 22>, 1}
cylinder {<-66, 24, 22>, <-63, 24, 22>, 1}
texture {dfault}
}

//stairs
#declare stair =
box {<-93.5, 6.5, 15>, <-66.5, 7, 17> texture {light_band3}}

#declare make_stairs = 0
#while (make_stairs < 8)
object {stair translate <0, -make_stairs, -make_stairs*1.25>}
#declare make_stairs = make_stairs + .5
#end

//sides of stairs
union {
//left bunch
box {<-96, 0, 7.5>, <-93.5, 4, 17>}
box {<-96, 4.25, 12>, <-93.5, 6.75, 17>}
box {<-96.25, 3.75, 7.25>, <-93.25, 4.25, 17> texture {light_band4}}
box {<-96.25, 6.5, 12.25>, <-93.5, 7, 17> texture {light_band4}}

//right bunch
box {<-66.5, 0, 7.5>, <-64, 4, 17>}
box {<-66.5, 4.25, 12>, <-64, 6.75, 17>}
box {<-66.75, 3.75, 7.25>, <-63.75, 4.25, 17> texture {light_band4}}
box {<-66.75, 6.5, 12.25>, <-63.75, 7, 17> texture {light_band4}}

//columns
#declare yerke_column = union {
cone {<0, 9, 0>, .4, <0, 16, 0>, .39}
cone {<0, 14.5, 0>, .39, <0, 16, 0>, .45 texture {column_cap}}
texture {dfault}
}

object {yerke_column translate <-93.5, 0, 18.5>}
object {yerke_column translate <-88.5, 0, 18.5>}
object {yerke_column translate <-71.5, 0, 18.5>}
object {yerke_column translate <-66.5, 0, 18.5>}

#declare yerke_column2 =
union {
object {yerke_column}
box {<-.5, 8, -.5>, <.5, 9, .5>}
texture {dfault}
}

//center columns
object {yerke_column2 translate <-84.5, 0, 18.5>}
object {yerke_column2 translate <-85.75, 0, 18.5>}
object {yerke_column2 translate <-74.25, 0, 18.5>}
object {yerke_column2 translate <-75.5, 0, 18.5>}


texture {dfault}
}

}//end of union for big mess
object {big_mess}
difference {
object {big_mess translate <0, 0, -25> rotate -90*y translate <7, 0, 153>}
box {<-50, -1, -10>, <-7, 50, 200> texture {dfault}}
}

//the dome
#include "dome2.inc"
object {dome scale .38 rotate -90*x translate <0, 55, 0> texture {dome_texture2}}

#include "YERKES.INC"
object {dome2}

//********************************************************************************************************
//*******************************************************************************************************

//background and forground stuff
/*
plane {y, 0
pigment {
crackle
color_map {
[0 color rgb <0.3, 0.43, 0.28>]
[.4 color rgb <0.3, 0.43, 0.28>]
[.6 color rgb <0.6, 0.61, 0.53>]
[.9 color rgb <0.6, 0.61, 0.53>]
[1 color rgb <0.3, 0.43, 0.28>]
}
}
finish {ambient .1 diffuse .6 crand 0.1}
normal {crackle 1}
}
*/

/*
plane {y, 0
texture {
pigment {
image_map {
png "yerkgrnd.png"
interpolate 4
}
rotate 90*x
scale <400, 10, 400> translate <-330, -5, -180>
}
finish {diffuse .5 phong .1 phong_size 10 crand 0.05}
normal {
bump_map {
tga "yerkgrnd2.tga"
//interpolate 2
bump_size 1
}
rotate 90*x
scale <400, 10, 400> translate <-330, -5, -180>
}

}
}
*/

//sky

//cloud layer 1

plane {-y,-900
  texture {
    pigment {bozo
      turbulence .4
      omega .7
      color_map {
        [0 color rgbt <.4,.4,.4,1>]
        [.5 color rgbt <.4,.4,.4,.6>]
        [1 color rgbt <.4,.4,.4,.2>]}}
    finish {ambient .5 diffuse .5}
    scale 3000
    translate <-500,900,-10000>}
}

//cloud layer 2

plane {-y,-1200
  texture {
    pigment {bozo
      turbulence .4
      omega .7
      color_map {
        [0 color rgbt <.6,.6,.6,1>]
        [.5 color rgbt <.6,.6,.6,.6>]
        [1 color rgbt <.6,.6,.6,.2>]}}
    finish {ambient 1 diffuse .3}
    scale 3000
    translate <1500,900,-2000>}
}

sky_sphere {
  pigment {
  gradient y
  color_map {
  [0 color rgb <.65,.7,.8>]
  [1 color rgb <0.2, 0.2, 1>]
  }
  }
  }

/*
  fog {
    distance 2000
    color rgbt <.65,.7,.8, .5>
    fog_type 2
    fog_offset 25
    fog_alt 1
    turbulence 0.1
    turb_depth 0.2
  }

  fog {
    distance 2000
    colour rgbt<0.6, 0.65, .75, .5>
    fog_type 2
    fog_offset 15
    fog_alt 4
    turbulence 0.2
    turb_depth 0.2
  }

  fog {
    distance 2000
    colour rgbt<0.5, 0.55, .65, .5>
    fog_type 2
    fog_offset 10
    fog_alt 2
  }
*/

//some trees



#declare bark =
texture {
pigment {color rgb <.22, .2, .18>}
finish {ambient 0.05 diffuse .4 phong .2 phong_size 24 crand 0.05}
normal {crackle .1 scale 3}
}

#declare leaves =
texture {
pigment {color rgbf <.704, .846, .8, .1>}
finish {ambient .05 diffuse .4 phong .3 phong_size 30}
normal {crackle .05}
}

#include "tree1.inc"
#declare first_tree =
union {
object {tree scale .4 }
object {tree scale .4 rotate 90*y}
}

object {first_tree translate <30, 15, 7>}

object {first_tree translate <20, 10, 7>}

#declare leaves =
texture {
pigment {color rgbf <.22, .4, .25, .1>}
finish {ambient .05 diffuse .4 phong .3 phong_size 30}
normal {crackle .05}
}

#include "tree3.inc"
union {
object {tree3 scale .04 translate 10*y rotate <-30, -45, 0>}
object {tree3 scale .03 translate 10*y rotate 20*x}
translate <20, 0, -5>}

/*
#include "tree4.inc"
#declare straight_tree =
union  {
object {tree4 scale .02 }
}

object {straight_tree translate <12, 10, -20>}
*/


#include "tree7.inc"
#declare shrub = union {
object {tree7 translate 433*y scale .015 rotate 20*z}
object {tree7 translate 433*y scale .015 rotate <-20, 90, -30> }
}

object {shrub translate <-20, -1, -25>}
object {shrub scale <1, .75, .75> translate <10, -1, -30>}



#include "tree8.inc"
union {
object {tree8 scale .075 translate <-10, 20, -70>}
object {tree8 scale .075  rotate 90*y translate <-10, 20, -70>}
}

/*

#include "tree6.inc"
union {
object {tree6 scale .075 translate <0, 32.5, -60>}
object {tree6 scale .075  rotate 90*y translate <0, 32.5, -60>}
}


*/

#include "grass.inc"
#declare new_grass = union {
object {grass}
object {grass rotate 180*y}
translate 25*y
scale <.1, .05, .1>
translate 30*z
}

#declare yard = union {
#declare make_grass = 0
#while (make_grass < 200)
object {new_grass rotate make_grass*y translate -make_grass*z}
#declare make_grass = make_grass + 5
#end
}

#declare make_yard = 0
#while (make_yard < 600)
object {yard translate -400*x translate make_yard*x}
#declare make_yard = make_yard + 10
#end



height_field {
tga "land.tga"
smooth
texture {
pigment {
color rgb <.275, .383, .245>
}
finish {
ambient 0.05 diffuse .6 phong .1 phong_size 30 crand .05
}
normal {crackle .5}
}
scale <1000, 150, 1000>
translate <-2000, 0, 100>
}

plane {y, 0
texture {
pigment {
color rgb <.275, .383, .245>
}
finish {
ambient 0.05 diffuse .5 phong .3 phong_size 30
}
}
}



#declare star_type = 2
#include "galaxy.sf"
