
// Persistence of Vision Ray Tracer Scene Description File
// File: 13night.pov
// Vers: 3
// Desc: First Kiss
// Date: March 98
// Auth: Nathan O'Brien
// Mail: no13@ozemail.com.au
// Webp: http://www.ozemail.com.au/~no13

#include "colors.inc"

#declare Sky_switch = on
#declare Fire_switch = on
#declare Opera_switch = on
#declare Bridge_switch = on
#declare Bridge_lights = on
#declare Boat_switch = on
#declare Land_switch = on
#declare Lovers_switch = on

camera {
	location <0,2,-120>
	look_at  <0,20,0>
}

// light_source {<100,100,-300> color White}

plane {y,0 pigment{Black} finish{reflection 1} normal {agate .3 scale 7}}

#include "burst.inc"

#if (Sky_switch = on)
#declare galaxy_seed = 99912113
#declare star_count = 5000
#declare galaxy_rotate = <-20,0,0>
#include "galaxy.inc"
#end

#if (Bridge_switch = on)
#include "bridge.inc"
object {Harbour_bridge}
#end

#if (Land_switch = on)
#include "ground2.inc"
object {Ground2 translate <0,0,100>}
#end

#if (Opera_switch = on)
#include "opera.inc"
object {Opera_house scale <2.8,3.2,2.8> rotate <0,170,0> translate <-10,0,-70>}
#end

#if (Boat_switch = on)
#include "boat.inc"
object {The_boat rotate <0,50,0> translate <4,.75,-109>}
#end

#if (Fire_switch = on)
#include "firework.inc"
object {Fireworks scale 10 translate <0,30,-70>}
#end
