#declare T_Hair = texture
{
  pigment
  {
    gradient x
    turbulence 0.8  octaves 8  omega 0.12  lambda 4.4
    color_map
    {
      [0.00 color rgb<0.259, 0.153, 0.047>]
      [0.06 color rgb<0.380, 0.231, 0.086>]
      [0.09 color rgb<0.529, 0.294, 0.059>]
      [0.16 color rgb<0.263, 0.165, 0.067>]
      [0.22 color rgb<0.463, 0.290, 0.118>]
      [0.30 color rgb<0.463, 0.243, 0.027>]
      [0.41 color rgb<0.098, 0.051, 0.004>]
      [0.50 color rgb<0.357, 0.196, 0.039>]
      [0.54 color rgb<0.420, 0.247, 0.078>]
      [0.58 color rgb<0.251, 0.133, 0.020>]
      [0.70 color rgb<0.451, 0.231, 0.016>]
      [0.75 color rgb<0.361, 0.208, 0.059>]
      [0.78 color rgb<0.133, 0.071, 0.008>]
      [0.84 color rgb<0.380, 0.220, 0.063>]
      [0.90 color rgb<0.408, 0.216, 0.024>]
      [1.00 color rgb<0.173, 0.090, 0.008>]
    }
	scale .01
  }
  finish {phong .75}
  normal {gradient x .1 scale .01}
}

#declare T_Hair2 = texture
{
  pigment
  {
    gradient x
    turbulence 0.8  octaves 8  omega 0.12  lambda 4.4
    color_map
    {
      [0.00 color rgb<0.690, 0.408, 0.125>]
      [0.06 color rgb<0.835, 0.616, 0.424>]
      [0.09 color rgb<0.875, 0.643, 0.412>]
      [0.16 color rgb<0.855, 0.706, 0.557>]
      [0.22 color rgb<0.745, 0.655, 0.569>]
      [0.30 color rgb<0.820, 0.596, 0.388>]
      [0.41 color rgb<0.635, 0.455, 0.275>]
      [0.50 color rgb<0.565, 0.392, 0.235>]
      [0.54 color rgb<0.835, 0.651, 0.482>]
      [0.58 color rgb<0.655, 0.420, 0.200>]
      [0.70 color rgb<0.690, 0.447, 0.224>]
      [0.75 color rgb<0.820, 0.624, 0.443>]
      [0.78 color rgb<0.710, 0.463, 0.220>]
      [0.84 color rgb<0.655, 0.549, 0.451>]
      [0.90 color rgb<0.800, 0.545, 0.290>]
      [1.00 color rgb<0.655, 0.510, 0.369>]
	}
	scale .01
  }
  finish {phong .75}
  normal {gradient x .1 scale .01}
}

#declare P1 = <0.0177,0.0470,0.0148>
#declare P2 = <0.0242,0.0446,-0.0131>
#declare V2 = vcross(P1,P2)					// mesh normal
#declare V1 = <0,0,-1>						// map normal

#declare VX1=vnormalize(V1)
#declare VX2=vnormalize(V2)
#declare VY=vnormalize(vcross(VX2,VX1))
#declare VZ1=vnormalize(vcross(VY,VX1))
#declare VZ2=vnormalize(vcross(VY,VX2))

#declare Object8Texture =
texture{pigment{
	image_map {tga "face2.tga"}
	translate <-0.5,-0.5,0>
	scale <0.46875,1,1>
	scale .15
	rotate <0,0,-22.5>
	matrix < VX1.x, VY.x, VZ1.x,
           VX1.y, VY.y, VZ1.y,
           VX1.z, VY.z, VZ1.z,
               0     0      0 >

	matrix < VX2.x, VX2.y, VX2.z,
            VY.x,  VY.y,  VY.z,
           VZ2.x, VZ2.y, VZ2.z,
               0,     0,     0 >

	translate <0.1153,0.4481,0.1092>
}
finish {phong .5}
}

#declare T_Hor = texture
{
  pigment
  {
    gradient x
    color_map
    {
      [0.00 color rgb<1.000, 1.000, 1.000>]
      [0.25 color rgb<1.000, 1.000, 1.000>]
      [0.27 color rgb<0.275, 0.404, 0.541>]
      [0.61 color rgb<0.514, 0.533, 0.753>]
      [0.64 color rgb<0.8, 0.8, 0.9>]
      [0.86 color rgb<0.8, 0.8, 0.9>]
      [0.89 color rgb<1.000, 1.000, 1.000>]
      [1.00 color rgb<1.000, 1.000, 1.000>]
    }
	scale .1
  }
}

#declare T_Ver1 = texture{pigment{color rgb<0.275, 0.404, 0.541>}}
#declare T_Ver2 = texture{pigment{color rgb<1,1,1>}} 

#declare T_Ver = texture
{
  gradient y
  texture_map {
      [0.00 T_Hor]
      [0.25 T_Hor]
      [0.27 T_Ver1]
      [0.61 T_Ver1]
      [0.64 T_Ver2]
      [0.86 T_Ver2]
      [0.89 T_Hor]
      [1.00 T_Hor]
  }
  scale .1
}

#declare T_Pants = texture
{
  pigment
  {
    granite
    color_map
    {
      [0.00 color rgb<0.310, 0.310, 0.510>]
      [0.28 color rgb<0.525, 0.525, 0.725>]
      [0.53 color rgb<0.325, 0.325, 0.525>]
      [0.75 color rgb<0.435, 0.435, 0.635>]
      [1.00 color rgb<1.000, 1.000, 1.000>]
    }
	scale .1
  }
  finish {phong .25}
}

