
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: INC file for "First Kiss"
// Date: Apr 98
// Auth: Nathan O'Brien
// Mail: no13@ozemail.com.au
// Webp: http://www.ozemail.com.au/~no13

#declare Truss1 =
union {
	box {<0,-.2,0><.2,1,.2>}
	cylinder {<0,-.2,0.1><1,1,.01>,.1}
	cylinder {<0,1,.1><1,-.2,.1>,.1}
}

#declare Truss2 =
union {
	box {<-100,-.2,0><100,0,.2>}
	box {<-100,1,0><100,1.2,.2>}

	#declare Count = 0
	#while (Count < 200)
		object {Truss1 translate <(-100 + Count),.2,0>}
		#declare Count = (Count + 1)
	#end
}

#declare Rail1 =
union {
	cylinder {<-100,15,-1.25><100,15,-1.25>,.1}
	#declare Count = 0
	#while (Count < 200)
		cylinder {<(-100 + Count),14.75,-1.25><(-100 + Count),15,-1.25>,.1}
		#declare Count = (Count + 1)
	#end
}

#declare Truss3 =
union {
	box {<0,.5,0><.5,3.5,.5>}
	box {<3.5,.5,0><4,3.5,.5>}
	cylinder {<.5,.5,.25><3.5,3.5,.25>,.2}
	cylinder {<4,3.5,.25><7,.5,.25>,.2}
}

#declare Truss4 =
union {
	box {<0,0,0><30,.5,.5>}
	box {<0,3.5,0><30,4,.5>}
	object {Truss3 translate <0,.5,0>}
	object {Truss3 translate <7,.5,0>}
	object {Truss3 translate <14,.5,0>}
	object {Truss3 translate <21,.5,0>}
}

#declare Bridge_road =
union {
	object {Truss2 translate <0,13,-1>}
	object {Truss2 translate <0,13,0>}
	object {Truss2 translate <0,13,11>}
	object {Truss2 translate <0,13,12>}
	object {Rail1}
	box {<-100,14.2,-1><100,14.4,12>}
	box {<-100,14.4,-1.5><100,14.75,12.5>}
	object {Truss4 translate <62,10,0>}
	object {Truss4 translate <62,10,11>}
}

