/*
    eclipse.pov -- used to generate eclipse scene in POVray
    Copyright (C) 1998 Aaron Gage

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "colors.inc"
//#include "skies.inc"
#include "finish.inc"

#include "solar.inc"
#include "sky.inc"

camera { location <0, 42, -99> look_at <0, 30, -50> } // main
//camera { location <260, 50, 400> look_at <0, 0, 400> }
//camera { location <0, 6000, 400> look_at <0, 0, 400> }

background { color White*0.5 }

//light_source { <0, 100, 0> color White }
light_source { <-1000, 1000, -1000> color White*0.15  /* had been 0.75 */
	shadowless
	fade_distance 10000
	fade_power 1
	}

#include "grass.inc"

#declare S1 = seed(5)
#declare S2 = seed(7)
#declare S3 = seed(13)

#include "pinetex.inc"

sky_sphere { Star_Sphere }

union {

	height_field
	{
		gif "night.ghf"
		smooth
		water_level 2/127
		pigment { color Brown }
		finish { diffuse 0.4 }
		//finish { ambient 0.75 }
	}

	#include "hfgrass.inc" 


	translate -0.5
	scale <10, 1, 10> 
	translate <0, 40, -100>
}

union {
	height_field
	{
		gif "night1.ghf"
		smooth
		translate -0.5
		scale <500, 50, 500>
		translate z*150
		//texture { pigment { color Brown*0.5 + Green*0.5 } }
		texture { pigment { color Brown*0.45 + Green*0.25 }
			finish { Dull }}
		normal { granite }
	}
	plane { y*1, -5
		pigment { color rgbf <0.2, 0.2, 1, 0.9> }
		finish { reflection 0.25 refraction 1.0 ior 1.33 }
		//normal { ripples }
		normal { bozo scale <4, 1, 4> }
		}
	#include "pinetree.inc"
	#include "hfthin.inc"
	object { MidTrees translate -0.5 scale <500, 50, 500> translate z*150 }
	}

union {
	height_field
	{
		gif "night2.ghf"
		smooth
		water_level 1/255
		//texture { pigment { color Brown*0.5 + Green*0.5 } }
		texture { pigment { color Brown*0.45 + Green*0.25 }
			finish { Dull }}
		normal { granite }
	}
	#include "hftrees.inc"
	object { BackTrees }

	translate -0.5
	scale <4500, 500, 4500>
	translate z*(2650-115)
	translate y*(240-30)
}

/*
object { EclipseProto
                scale 1000
                translate <4500, 3700, 20000>
                }
*/

object { Eclipse
	rotate x*-12.61993         //12.61993  // atan(4500/20099)
	rotate y*9.6235791         //10.31488   // atan(3658/20099)
                scale 1250
                translate <4500, 3450, 20000> }
	//scale 1000 translate <4500, 3700, 20000> }
