//------------------------------------------------------------------------
//
//  A S T M I N E R .  P O V
//   Created: March, 1998
//------------------------------------------------------------------------
//   EMAIL: castlewrks@aol.com
//   NAME:  Robert J Becraft
//   TOPIC: NIGHT
//   COPYRIGHT: I SUBMIT TO THE STANDARD RAYTRACING COMPETITION COPYRIGHT.
//   TITLE: "Asteroid Miner"
//   COUNTRY: USA
//   WEBPAGE: http://www.geocities.com/SiliconValley/Lab/6080
//            http://user.aol.com/castlewrks/metaphaze/frisco/frisco.htm
//   RENDERER USED: POVRAY 3.02 for DOS running under OS/2 Warp
//   TOOLS USED: POVRAY for render, sPatch for asteroid, Paint Shop Pro for copyright and title
//   RENDER TIME: Just under 18 hours
//   HARDWARE USED: 233mmx
//   IMAGE DESCRIPTION: 
//_________________________________________
// An Introduction
//_________________________________________
//  "Date: October 9, 2160, 0200 hours GMT --  Location: Asteroid Sector 0298 -- Ship's Log:  Delta-T 09-84E
//
//    Scooter patrol Zebra reports a slow-rotation boogie (asteroid) on approach to the mothership's
//    warning zone and is dispatched to investigate.  The crew is on night shift and unaware of the
//    immenent danger they may be called on to deal with.  Scooter patrol Alpha-1 is on approach for
//    docking maneuvers and turns up the comm-tower spots to aid in navigation.  All in all it is a quiet
//    night on board."
//
//________________________________________
//
//  ASTMINER is a ray-trace of a ship designed from modules associated with a Space game
//  I designed many years ago called "SYSTEM".  The basis for the game is the "gold-rush" to the asteroid belt.
//  The concept is that man has yet to accomplish inter-stellar travel, but has mastered inter-system
//  travel.  The Asteroid Miner rendered in this picture is on night watch... off in the distance is a small scooter
//  craft that is taking a look at a potentially dangerous asteroid near the main ship.
//
//  The bridge of the ship is deserted, but contains seats, consoles and even a "Star Trekkie" captain's
//  chair, as well as a couple of silvery equipment boxes.
//
//  Spotlights located on the 4 sides of the communications tower light up various sections of the ship.
//  They contain fully functional light sources.  However, to get the full effect of the light graduations on the
//  ship itself, these light sources were toned back to just glow levels and spotlight sources were added to
//  create the correct level of lighting on the ship.  (An interesting side-note, trying to add these same types of
//   lights to each module pushed the memory requirements of the render off the scale and became
//  unrenderable... hence the use of high-ambient spheres instead).
//
//   One of the scooters mentioned in the intro is off to the right of the rendered frame.  It's spotlights caste a light
//   green glow on the front command module and docking tube.  The second scooter is off to the right of the
//   asteroid in the background.  It's spotlights are what light up that object.
//
//   The science lab is located immediately adjacent to the command module.  Storage pods are placed
//   across the back of the miner, while habitate modules are placed under the storage pods.
//
//   The massive engines of the ship flank the ship's crane that can be used to tether potentially valuable
//   ore bearing asteroids to the ship and dragged enmasse back to the smelter.  The engines get
//   fuel from the 6 fuel pods located below and just in front of them.
//
//   Each module included in this render is from a standard set of "plug-n-go" modules.  There
//   are engines, fuel-pods, habitate, storage, command, communication, docking and facility
//   modules.  Using the "SYSTEM" game rules, it is possible to build the entire of standard ships
//   concieved of for the game in POV.  Watch for these at "http://www.geocities.com/SiliconValley/Lab/6080".
//
//   Each of the modules are based on a 10 meter radius, giving modules that are a total of 20
//   meters in diameter.  Each module is designed to connect it in each of 6 directions, with the
//   exception of the engine modules.
//
//   Frames are connector tubes that are used to connect modules together, they provide redundant
//   paths between modules.  The tube seams even have rivets and indicator panels rendered on them.
//_______________________________
//   How this image was created:
//_______________________________
//  Asteroid Miner was created using the concept of the "SYSTEM" game and creating unique modules
//  for each of the components of the ship.  Each component was created using the same dimensions
//  for each object with the exceptions of the docking tube, communications array and the engines.
//  
//  Every object was created with a minimal amount of detail, and then over and over and over 
//  objects were added and improved until the render reflected the level of detail submitted for
//  the competition.  
//
//  Especially important was the concept of light for this render.  There is one light that originates
//  from outside the render and that comes off of a scooter that is positioned off the lower right
//  corner of the frame.  In another view, this scooter was visible.  All the other lights were 
//  designed so that they originate from objects in the render.  The spotlights on the communications
//  tower contain actual light objects.  The red lights on the crane object originate from lights
//  that are attached around the outside of the top of the crane.
//  
//  Since the light levels are so low, the asteroid field generated in this module was not visible
//  and removed from the final picture.  However, if a "sun" is added to the render, the asteroids
//  can be reinserted into the render and form a field off in the distance behind the ship.
//
//  Switches were used to turn on and off features that were placed into the picture over time
//  and allow for faster renders of specific parts of the picture by commenting or uncommenting 
//  the switches at the top of the deck.  Once an object was placed in it's final position, or
//  obtained its final colors and textures, there was no need to render it along with another
//  object that had not yet gotten such treatments.
//
   global_settings {
                                    max_trace_level 8          // default POV setting is 5
                                    max_intersections 256    // default POV setting is 64... istack_overflows not= 0 increase
                                  }
//
// Standard POV Include files
//
#include "colors.inc"
#include "stones1.inc"
#include "glass.inc"
#include "finish.inc"
#include "light.inc"
//
// Textures for modules in this render
//
#include "shiptext.inc"
//
// Variables to aid in turning on and off features while creating the image
//
//#declare nosky=yes               // uncomment to turn off stars
#declare night=yes                    // uncomment to turn off sun-light
#declare noatmos=yes            // feature never used, was thought to try and high-light light beams
#declare NoAsteroids=yes    // uncomment to turn off asteroid generation loop (use with sun-light to see them)
//#declare NoShip=yes       // uncomment to turn off ship objects

// Camera... action
//
camera {
//   location <-40, 45, -100>   look_at   <0, 5, 0>  // the whole ship (ship1)
   location <-64, 60, -64>   look_at   <0, 7, 10>        // ASTMINER.JPG... IRTC submission
}

#ifndef(night)
light_source { <-10000,10000,-10000 >  color White*2 }                 // main light

#else
// lights from COMM tower
// West side
//light_source{<-7,33,-40> color White*2  spotlight radius 15 falloff 50 tightness 20 point_at <-20,10,-20>}
light_source{<-7,33,-40> color Tan*2  spotlight radius 15 falloff 50 tightness 20 point_at <-47,20,0>}
light_source{<-7,33,-40> color Orange*2 spotlight radius 15 falloff 50 tightness 20 point_at <-15,0,-40>}

//East side
//light_source{<7,33,-40>  color White*2  spotlight radius 15 falloff 50 tightness 20 point_at <20,10,20>}
//light_source{<7,33,-40>  color White*2  spotlight radius 15 falloff 50 tightness 20 point_at <47,-20,0>}
light_source{<7,33,-40> color Orange*2 spotlight radius 15 falloff 50 tightness 20 point_at <10,0,-40>}

//North side
light_source{<0,33,-34> color Wheat spotlight radius 5 falloff 60 tightness 10 point_at <0,28,40>}

//South Side
light_source{<0,33,-46> color Blue*2 spotlight radius 15 falloff 50 tightness 20 point_at <0,0,-46>}

// Crane Lite
light_source{<0,35,40> color Tan*2 spotlight radius 15 falloff 30 tightness 20 point_at <-40,10,40>}
#end

// add atmosphere to see light beams.
#ifndef (noatmos)
  atmosphere {
    type 1
    samples 50
    distance 20
    scattering 0.2
//    aa_level 4
//    aa_threshold 0.1
//    jitter 0.2
  }
#end

// starry sky
#ifndef (nosky)
sky_sphere {pigment {granite color_map{
                     [.8 rgb 0] [1 rgb 1] }
                     turbulence 2 scale .08}}
#end

// Defines ---------------
#include "parts.inc"
#include "crane.inc"
#include "habitat.inc"
#include "store.inc"
#include "engine.inc"
#include "command.inc"
#include "science.inc"
#include "fuel.inc"
#include "frame.inc"

#include "spacemen.inc"
#include "scooter.inc"

//  #include "aster1.pov"  // not included
//  #include "aster2.pov"  // not included
  #include "aster3.pov"

#ifndef(NoAsteroids)

#declare S1=seed(1239)
#declare MaxCount=50
#declare Count=1
#while (Count<MaxCount)
   #declare SC=int(rand(S1)*15+1)                 // scale of rock (1-15)
   #declare RX=int(rand(S1)*360)                   // x-rotation
   #declare RY=int(rand(S1)*360)                  // y-rotation
   #declare RZ=int(rand(S1)*360)                  // z-rotation
   #declare  PX=int(rand(S1)*2000)-1000    // x position
   #declare PY=int(rand(S1)*-750)                 // y position
   #declare PZ=int(rand(S1)*750)+1500        // z position
//   #declare Rock=0                                         // testing
   #declare Rock=int(rand(S1)*3)        // which rock
   #switch (Rock)
     #case(0)
        union{
           sphere{<0,0,0>,1 scale SC texture{GroundC} translate<PX,PY,PZ>}
           sphere{<0,.5,.5>,1.2 scale SC texture{GroundC} translate<PX,PY,PZ>}
           sphere{<0,-.5,-.5>,1 scale SC texture{GroundC} translate<PX,PY,PZ>}
         }
     #break
     #case(1)
        union{
           sphere{<0,0,0>,1 scale SC texture{GroundC2} translate<PX,PY,PZ>}
           sphere{<0,.5,.5>,1.2 scale SC texture{GroundC2} translate<PX,PY,PZ>}
           sphere{<0,-.5,-.5>,1 scale SC texture{GroundC2} translate<PX,PY,PZ>}
         }
     #break
     #case(2)
        union{
           sphere{<0,0,0>,1 scale SC texture{GroundC3} translate<PX,PY,PZ>}
           sphere{<0,.5,.5>,1.2 scale SC texture{GroundC3} translate<PX,PY,PZ>}
           sphere{<0,-.5,-.5>,1 scale SC texture{GroundC3} translate<PX,PY,PZ>}
         }
     #break
     #case (3)
       object{A1 scale SC texture{GroundC}  rotate<RX,RY,RZ>   translate<PX,PY,PZ> }
     #break
     #case (4)
       object{A1 scale SC texture{GroundC2} rotate<RX,RY,RZ> translate<PX,PY,PZ>}
     #break
     #case (5)
       object{A1 scale SC texture{GroundC3} rotate<RX,RY,RZ> translate<PX,PY,PZ>}
     #break
     #case (6)
       object{A2 scale SC texture{GroundC}  rotate<RX,RY,RZ>   translate<PX,PY,PZ> }
     #break
     #case (7)
       object{A2 scale SC texture{GroundC2} rotate<RX,RY,RZ> translate<PX,PY,PZ>}
     #break
     #case (8)
       object{A2 scale SC texture{GroundC3} rotate<RX,RY,RZ> translate<PX,PY,PZ>}
     #break
     #case (9)
       object{A3 scale SC texture{GroundC}  rotate<RX,RY,RZ>   translate<PX,PY,PZ> }
     #break
     #case (10)
       object{A3 scale SC texture{GroundC2} rotate<RX,RY,RZ> translate<PX,PY,PZ>}
     #break
     #case (11)
       object{A3 scale SC texture{GroundC3} rotate<RX,RY,RZ> translate<PX,PY,PZ>}
     #break
   #end
   #declare Count=Count+1
#end

//object{A1 scale 8 texture{GroundC4} rotate<0,130,0> translate<88,35,50>}
object{A3 scale 6 texture{GroundC5} rotate<0,180,0> translate<-67,-20,-20>}
object{A2 scale 5 texture{GroundC6} rotate<0,0,90> translate<30,35,-50>}
#end


// Two objects in the background... scooter and asteroid.

object{A1 scale 8 texture{GroundC4} rotate<0,130,0> translate<98,25,50>}
object{Scooter_Pod_Pilot rotate<0,45,0> translate<100,30,32>}

// Objects -------------------------------------------

#ifndef(NoShip)

    object{ShipStoreFrame}
    object{ShipFrame rotate<0,90,0>}
    object{ShipFrame rotate<0,0,0> translate<0,0,40>}
    object{Science_Pod rotate<90,0,0> translate<0,17,-20>}
    object{Command_Pod translate<0,17,-40>}
    object{Comm_Pod translate<0,33,-40>}
    object{Docking_Pod translate<-20,17,-40>}

    object{Fuel_Pod translate<-20,-17,40>}
    object{Fuel_Pod translate<-40,-17,40>}
    object{Fuel_Pod translate< 20,-17,40>}
    object{Fuel_Pod translate< 40,-17,40>}
    object{Fuel_Pod translate<-40,17,20>}
    object{Fuel_Pod translate< 40,17,20>}

    object{Crane_Pod rotate<0,90,0> translate<0,17,40>}
    object{Engine_Pod rotate<0,180,0> translate<-20,17,40>}
    object{Engine_Pod rotate<0,180,0> translate<20,17,40>}
    object{Engine_Pod rotate<0,180,0> rotate<0,0,180>  translate<-40,17,40>}
    object{Engine_Pod rotate<0,180,0> rotate<0,0,180>  translate<40,17,40>}

    object{Scooter_Pod_Pilot rotate<0,130,0> translate<-40,35,-90>}
#end


// End of ASTMINER.POV
