
// Persistence of Vision Ray Tracer Scene Description File
// File: bbportal.pov
// Vers: 3
// Desc: "Portal to the Nightlands" -- March/April 1998 IRTC
// Date: 10 April 1998
// Auth: William Bobzien


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

camera
{
	location  <10.0 , 10.5 ,-40.0>
	look_at   <-10.0 , 5 , 40.0>
}
/*
camera
{
	location  <0.0 , 10 ,-200.0>
	look_at   <0.0 , 6 , -2500.0>
}
*/
light_source
{
	0*x
	color red 1.0  green 1.0  blue 1.0
	translate <4000, 4000, -10>
}

light_source
{
	0*x // light's position (translated below)
	color red 0.5  green 0.5  blue 0.5  // light's color
	translate <4000, 4000, -1000>
	fade_distance 4000
	fade_power 2
	shadowless
}

#include "stones.inc"

#include "ground.inc"

#include "sky.inc"

#include "doorway.inc"

#include "beach.inc"

#include "ocean.inc"

#include "stars.inc"

#include "moon.inc"

#include "platform.inc"

#include "steps.inc"

#include "hills.inc"

