#include "colors.inc"
#include "woods.inc"
#include "shapes2.inc"
#include "metals.inc"
#include "gravestones.inc"
#include "bones_main.inc"

#declare TreeTrunk=texture {
 pigment {
  granite
  color_map {
   [0.0 rgb <0.0,0.0,0.0>]
   [0.4 rgb <0.18,0.10,0.05>]
   [0.8 rgb <0.32,0.25,0.2>]
   [0.95 rgb <1.0,1.0,1.0>]
  }
  scale 0.5
 }
 finish { ambient 0.3
          diffuse 0.5
          specular 0.0
          roughness 0.9
          reflection 0
        }
 normal { crackle 0.5
          turbulence 1.5
          scale 2
        }
}

// Southern Gray granite - polished surface
#declare SGrayPol =
texture {
  pigment
  {
    granite
    turbulence 0.9
    color_map
    {
      [0.00 color rgb<0.741, 0.741, 0.741>]
      [0.30 color rgb<0.684, 0.684, 0.684>]
      [0.70 color rgb<0.664, 0.664, 0.664>]
      [1.00 color rgb<0.471, 0.471, 0.471>]
    }
  }
  finish {
    ambient 0.5
    brilliance 1.5
    phong 0.9    phong_size 80
  }
}
texture {
  pigment
  {
    granite
    turbulence 0.8
    color_map
    {
      [0.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.70 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.70 color rgbf<0.200, 0.157, 0.157, 0.498>]
      [1.00 color rgb<0.000, 0.000, 0.000>]
    }
    translate <33.0, 20.0, 0.0>
    rotate <0.3, 0.2, 0.3>
    scale <0.2, 0.2, 0.2>
  }
  finish {
    ambient 0.5
    brilliance 1.5
    phong 0.9    phong_size 80
  }
}


light_source{
 <1000,1000,-500> White*0.6
 atmosphere off
}

light_source {
 <-1000,1000,-500> White*0.05
 atmosphere off
 shadowless
}

camera {
 location <0,1.3,-4.1>
 look_at <0,0.8,0>
}

height_field {
 gif "height.gif"
 smooth
 translate <-.5, 0, -.5>
 scale <50, 4, 50>
 texture { pigment {DarkBrown}
           finish {ambient 0.1
                   crand 0.2
                   brilliance 0.5
                   reflection 0.1}
           normal { bumps 2
                    turbulence 1
                    scale 0.2
                  }
           scale <3,1.5,3>
          }
}

#declare FencePole=
 union {
  box { <-0.1,0,-0.05>,<0.1,2,0.05> }
  object { Pyramid2
           scale <0.078,0.15,0.04>
           translate y*2.15
         }
  texture {T_Wood8
           scale 0.1
           rotate x*90}
 }

#declare Fence=
 union {
  #declare Along=0
  #while (Along<21)
   object { FencePole
            translate <-15+1.5*Along,3.75,20>
          }
   #declare Along=Along+1
  #end
  cylinder {
    <-17,4.3,20>,<17,4.3,20>,0.03
    texture {T_Chrome_2A}
   }
   cylinder {
    <-17,4.85,20>,<17,4.85,20>,0.03
    texture {T_Chrome_2A}
   }
   cylinder {
    <-17,5.4,20>,<17,5.4,20>,0.03
    texture {T_Chrome_2A}
   }
 }

object {Fence}

//Tombstones
object {
 Crypt
 rotate y*72
 scale 0.75
 translate z*-1
}

light_source {
 <-0.2,0.25,-0.4> color Yellow*3
 atmospheric_attenuation on
}
light_source {
 <0.2,0.25,-1.6> color Yellow*3
 atmospheric_attenuation on
}

union {
 object {
  Tombstone1
  texture {T_Grnt1 scale 0.2}
 }
 text { ttf "old_gond.ttf" "Copyright" 0.5, 0
        pigment {BakersChoc}
        scale 0.1
        translate <-0.19,0.7,-0.1>
      }
 text { ttf "old_gond.ttf" "G. Shaw" 0.5, 0
        pigment {BakersChoc}
        scale 0.13
        translate <-0.25,0.55,-0.1>
      }
 text { ttf "old_gond.ttf" "1998" 0.5, 0
        pigment {BakersChoc}
        scale 0.11
        translate <-0.1,0.4,-0.1>
      }
 text { ttf "old_gond.ttf" "gail@rucus.ru.ac.za" 0.5, 0
        pigment {BakersChoc}
        scale 0.073
        translate <-0.28,0.2,-0.1>
      }
 scale 0.7
 rotate <60,40,0>
 translate <1.05,-0.05,-2.3>
}

object {
 cross1
 texture {SGrayPol scale 0.5}
 scale 0.85
 translate <2,0,0>
}

object {
 cross1
 texture {SGrayPol scale 0.5}
 scale 0.75
 rotate y*-20
 translate <2.5,0,0.5>
}

object {
 cross1
 texture {SGrayPol scale 0.5}
 scale 0.75
 rotate y*20
 translate <1.7,0,0.5>
}

union {
 object { Tombstone3 }
 text {ttf "drgnwck.ttf" "Elric Melrin" 0.5, 0
       pigment {Black}
       scale 0.06
       translate <-0.23,0.38,-0.09>
      }
 text {ttf "drgnwck.ttf" "1573-1660" 0.5, 0
       pigment {Black}
       scale 0.04
       translate <-0.17,0.3,-0.09>
      }
 text {ttf "drgnwck.ttf" "I hear a voice" 0.5, 0
       pigment {Black}
       scale 0.06
       translate <-0.18,0.22,-0.09>
      }
 text {ttf "drgnwck.ttf" "from heaven..." 0.5, 0
       pigment {Black}
       scale 0.06
       translate <-0.2,0.15,-0.09>
      }
 translate <-1.2,-0.02,-2.1>
}

union {
 object {Tombstone2
         texture {IndiaBPol scale 0.3}
        }
 text {ttf "goudhndn.ttf" "If I take the wings of the morning and" 0.5,0
       texture {T_Gold_3A}
       scale 0.065
       rotate z*-90
       translate <0.03,1.47,-0.11>
      }
 text {ttf "goudhndn.ttf" "dwell in the uttermost parts of the sea" 0.5,0
       texture {T_Gold_3A}
       scale 0.065
       rotate z*-90
       translate <-0.06,1.47,-0.11>
      }
 scale 0.75
 rotate y*-20
 translate <-2,0,0>
}

object {
 cross3
 texture {T_Grnt9}
 translate <0.6,0.1,3>
}

union {
 object {Tombstone5
         texture {T_Stone12
                  scale 0.2}
        }
 text {ttf "chancery.ttf" "Angels come" 0.5, 0
       texture {T_Chrome_3E}
       scale 0.09
       translate <-0.21,0.6,-0.11>
      }
 text {ttf "chancery.ttf" "Trumpet calls" 0.5, 0
       texture {T_Chrome_3E}
       scale 0.09
       translate <-0.23,0.45,-0.11>
      }
 text {ttf "chancery.ttf" "I go" 0.5, 0
       texture {T_Chrome_3E}
       scale 0.09
       translate <-0.08,0.3,-0.11>
      }
 rotate <10,0,-10>
 translate <2,0,3>
}

union {
 object {Tombstone4 scale <1.1,1,1>}
 text {ttf "artistik.ttf" "Sleep after toil",0.5,0
       scale 0.05
       translate <-0.13,0.65,-0.11>
       texture {BrightWhite}
      }
 text {ttf "artistik.ttf" "Port after stormy seas",0.5,0
       scale 0.05
       translate <-0.2,0.58,-0.11>
       texture {BrightWhite}
      }
 text {ttf "artistik.ttf" "Ease after war",0.5,0
       scale 0.05
       translate <-0.12,0.51,-0.11>
       texture {BrightWhite}
      }
 text {ttf "artistik.ttf" "Death after life",0.5,0
       scale 0.05
       translate <-0.13,0.44,-0.11>
       texture {BrightWhite}
      }
 text {ttf "artistik.ttf" "So things must be",0.5,0
       scale 0.05
       translate <-0.15,0.37,-0.11>
       texture {BrightWhite}
      }
 text {ttf "artistik.ttf" "Lord Byran Keynes",0.5,0
       scale 0.07
       translate <-0.25,0.05,-0.16>
       texture {T_Gold_3C}
      }
 translate <4.5,0,6>
}

union {
 object {Tombstone8}
  text {ttf "tengwar.ttf" "All must pass through" 0.5,0
       scale 0.15
       texture {T_Gold_4E}
       translate <-0.38,1.27,-0.16>
      }
 text {ttf "tengwar.ttf" "E" 0.5,0
       scale 0.2
       texture {T_Gold_4E}
       translate <-0.31,1,-0.11>
      }
 text {ttf "tengwar.ttf" "l" 0.5,0
       scale 0.2
       texture {T_Gold_4E}
       translate <-0.32,0.85,-0.11>
      }
 text {ttf "tengwar.ttf" "w" 0.5,0
       scale 0.2
       texture {T_Gold_4E}
       translate <-0.31,0.7,-0.11>
      }
 text {ttf "tengwar.ttf" "a" 0.5,0
       scale 0.2
       texture {T_Gold_4E}
       translate <-0.31,0.55,-0.11>
      }
 text {ttf "tengwar.ttf" "r" 0.5,0
       scale 0.2
       texture {T_Gold_4E}
       translate <-0.31,0.4,-0.11>
      }
  text {ttf "tengwar.ttf" "1" 0.5,0
       scale 0.2
       texture {T_Gold_4E}
       translate <0.29,1,-0.11>
      }
 text {ttf "tengwar.ttf" "4" 0.5,0
       scale 0.2
       texture {T_Gold_4E}
       translate <0.29,0.85,-0.11>
      }
 text {ttf "tengwar.ttf" "9" 0.5,0
       scale 0.2
       texture {T_Gold_4E}
       translate <0.29,0.7,-0.11>
      }
 text {ttf "tengwar.ttf" "3" 0.5,0
       scale 0.2
       texture {T_Gold_4E}
       translate <0.29,0.55,-0.11>
      }
 translate <4.3,0,2.5>
}

object {Tombstone6
 scale 0.5
 rotate <-10,0,15>
 translate <2,0,-1>
}

// A dead and distorted tree

object {bones
        texture {TreeTrunk}
        scale 0.15
        rotate <-90,30,0>
        translate <-2,0,2.3>
       }

// Sky


fog {
 fog_type 2
 distance 3
 color rgb <0.45,0.45,0.45>
 fog_offset 0.25
 fog_alt 0.3
 turbulence 10
 turb_depth 1
}

atmosphere {
 type 2
 samples 35
 distance 50
 scattering 0.28
 jitter 0.6
 aa_level 8
 aa_threshold 0.1
}



// Stars

#declare S0=seed(0)
#declare Count=0
#while (Count < 15000)
  sphere { z*50,0.03
           no_shadow
           pigment { White*3 }
           finish { ambient 1 diffuse 0 specular 0 phong 0
                    reflection 0 }
           rotate < 360*rand(S0),360*rand(S0),360*rand(S0) >
           translate <0,1.3,-4.1>
          }
  #declare Count=Count+1
#end
