// Assorted gravestones with inscriptions. For irtc entry "Beware the night"

#include "colors.inc"
#include "stones.inc"
#include "metals.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "woods.inc"

// India Black granite - polished surface
#declare IndiaBPol =
texture {
  pigment
  {
    granite
    turbulence 0.7
    color_map
    {
      [0.00 color rgb<0.000, 0.000, 0.000>]
      [0.45 color rgb<0.008, 0.020, 0.008>]
      [0.90 color rgb<0.008, 0.020, 0.008>]
      [1.00 color rgb<0.100, 0.100, 0.100>]
    }
    scale <1.2, 1.2, 1.2>
  }
  finish {
    ambient 0.5
    brilliance 1.5
    phong 0.9    phong_size 80
  }
}
texture {
  pigment
  {
    granite
    turbulence 0.2
    color_map
    {
      [0.00 color rgbf<0.200, 0.200, 0.200, 0.149>]
      [0.25 color rgbf<0.200, 0.200, 0.200, 0.949>]
      [0.25 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [1.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
    }
  }
  finish {
    ambient 0.5
    brilliance 1.5
    phong 0.9    phong_size 80
  }
}

#declare BrightWhite =
texture {
  pigment
  {
    colour rgbf<1,1,1,0.1>
  }
  finish {
    phong 0.3
    phong_size 80
    reflection 0.2
  }
}

// Gray granite with white patches.
#declare Stone8 =
texture {
  pigment
  {
    colour rgb<1.000,1.000,1.000>
  }
  finish {
    ambient 0.4
    diffuse 0.7
    crand 0.06
  }
}
texture {
  pigment
  {
    granite
    turbulence 0.6
    color_map
    {
      [0.00 color rgbf<0.729, 0.498, 0.447, 0.306>]
      [0.15 color rgbf<0.769, 0.682, 0.588, 0.788>]
      [0.40 color rgbf<0.839, 0.753, 0.718, 0.392>]
      [0.56 color rgbf<0.776, 0.667, 0.561, 0.973>]
      [0.73 color rgbf<0.737, 0.659, 0.573, 0.820>]
      [1.00 color rgbf<0.725, 0.502, 0.451, 0.306>]
    }
  }
  rotate <0.0, 0.0, -30.0>
  scale <2.0, 3.0, 2.0>
}
texture {
  pigment
  {
    granite
    turbulence 0.6
    color_map
    {
      [0.00 color rgbf<0.808, 0.812, 0.812, 0.831>]
      [0.22 color rgbf<0.741, 0.839, 0.831, 0.843>]
      [0.24 color rgbf<0.404, 0.333, 0.333, 0.463>]
      [0.62 color rgbf<0.584, 0.588, 0.631, 0.651>]
      [0.76 color rgbf<0.914, 0.839, 0.722, 0.620>]
      [0.78 color rgbf<0.153, 0.129, 0.208, 0.435>]
      [0.81 color rgbf<0.812, 0.812, 0.812, 0.831>]
      [1.00 color rgbf<0.812, 0.812, 0.812, 0.831>]
    }
  }
  finish {
    ambient 0.2
    diffuse 0.5
    phong 1.0    phong_size 90
  }
  rotate <0.0, 0.0, 40.0>
  scale <5.0, 3.0, 4.0>
}


// Simple cross

#declare cross1=
 union {
  box {<-0.1,0,-0.1>,<0.1,1,0.1>}
  box {<-0.3,0.6,-0.1>,<0.3,0.8,0.1>}
  pigment {White}
 }

// cross with decoration

#declare cross2=
 union {
  box {<-0.1,0,-0.1>,<0.1,1,0.1>}
  box {<-0.3,0.6,-0.1>,<0.3,0.8,0.1>}
  pigment {White}
 }

#declare ring=
 difference {
  cylinder {<-0,0.7,-0.08>,<0,0.7,0.08>,0.3 }
  cylinder {<-0,0.7,-0.15>,<0,0.7,0.15>,0.25}
 }

#declare Starbump=
 box { <0,0,-0.1>,<0.2,0.2,0>
         pigment {White}
         normal { bump_map {gif "starnew.gif"
                            bump_size 1
                           }
                  scale <0.2,0.2,1>
                }
      }

#declare cross3=
  union {
   object {cross1}
   object {ring}
   object { Starbump
            translate <-0.1,0.8,-0.0001>
          }
   object { Starbump
            translate <-0.3,0.6,-0.0001>
          }
   object { Starbump
            translate <0.1,0.6,-0.0001>
          }
   object { Starbump
            translate <-0.1,0,-0.0001>
          }
   text { ttf "tengwar.ttf" "RIP" 0.5,0
          pigment {White}
          scale 0.25
          translate <-0.07,0.7,-0.11>
        }
   pigment {White}
   finish {phong 0.9
           phong_size 80
          }
  }

#declare Tombstone1=
 union {
  box { <-0.3,0,-0.1>,<0.3,0.6,0.1> }
  cylinder { <0,0.6,-0.1>,<0,0.6,0.1>,0.3 }
  pigment {White}
 }

#declare Tombstone2=
 union {
  box { <-0.1,0,-0.1>,<0.1,1.8,0.1> }
  object { Pyramid2
           scale 0.08
           translate <0,1.88,0>
         }
  box { <0,0,-0.1>,<0.14,0.28,0>
        pigment { image_map { gif "stave.gif"
                              transmit 164, 1
                            }
                  scale <0.14,0.28,1>
                }
        translate <-0.07,1.5,0>
      }
  box { <0,0,-0.11>,<0.07,0.105,0>
        pigment { image_map { gif "note1.gif"
                              transmit 164, 1
                            }
                  scale <0.07,0.105,1>
                }
        translate <0,0.17,0>
       }
  box { <0,0,-0.11>,<0.045,0.105,0>
        pigment { image_map { gif "note2.gif"
                              transmit 164, 1
                            }
                  scale <-0.045,0.105,1>
                }
        translate <-0.055,0.3,0>
       }
  pigment {Black}
 }

#declare Tombstone3=
 difference {
  box {
   <0,0,-0.1>,<0.6,0.5,0.1>
   texture {Stone8 scale 0.8}
   normal { bump_map { gif "back15.gif"
                       bump_size 2
                     }
            scale <0.6,0.5,1>
          }
   translate x*-0.3
  }
  box {
   <-0.25,0.05,-1.5>,<0.25,0.45,-0.08>
   texture {T_Brass_3C}
   normal {dents 0.5
           scale 0.01}
  }
 }

#declare Tombstone4=
 union  {
  superellipsoid {
   <2.0, 1.0>
   rotate z*45 rotate x*90
   scale <0.277,0.3,0.145>
   translate <0,0.68,0>
  }
 box { <-0.2,0.1,-0.1>,<0.2,0.7,0.1>}
 box { <-0.25,0,-0.15>,<0.25,0.1,0.15>}
 texture {T_Stone18 scale 0.2}
}

#declare Tombstone5=
 union {
  difference {
   box { <-0.3,0,-0.1>,<0.3,1,0.1> }
   union {
    cylinder {<-0.3,1,-0.15>,<-0.3,1,0.15>,0.3 }
    cylinder {<0.3,1,-0.15>,<0.3,1,0.15>,0.3 }
   }
  }
  object {cross1
          scale <0.5,0.5,0.6>
          translate <0,0.75,0>
          texture {T_Stone12 scale 0.2}
         }

  pigment {White}
 }

#declare Tombstone6=
  union {
   box { <-0.25,0,-0.1>,<0.25,1,0.1>
         texture {IndiaBPol}
       }
   box { <0,0,-0.01>,<0.4,0.075,0.01>
         pigment { image_map { gif "duskybar.gif"
                               transmit 145, 1
                             }
                   scale <0.4,0.075,1>
                 }
         translate <-0.2,0.85,-0.1>
       }
   box { <0,0,-0.01>,<0.4,0.075,0.01>
         pigment { image_map { gif "duskybar.gif"
                               transmit 145, 1
                             }
                   scale <0.4,-0.075,1>
                 }
         translate <-0.2,0.15,-0.1>
       }
 }

#declare Tombstone7=
 union {
  box { <-0.4,0,-0.1>,<0.4,0.8,0.1> }
  box { <0,0,-0.1><0.4,0.4,-0.1>
        pigment {White}
        normal {bump_map { gif "hdev1.gif"
                           bump_size 1
                         }
                scale 0.4
               }
        translate <-0.4,0.75,0>
      }
  pigment {White}
 }

#declare Tombstone8=
 union {
  box { <-0.4,0,-0.1>,<-0.2,1.2,0.1>}
  box { <0.2,0,-0.1>,<0.4,1.2,0.1>}
  box { <-0.5,1.2,-0.13>,<0.5,1.4,0.13>}
  texture {T_Stone44}
  normal {granite 2}

 }

#declare PatternFrame=
 union {
  box { <-1.35,0,-0.015>,<1.35,0.15,0.015> }
  box { <-1.35,0.55,-0.015>,<1.35,0.7,0.015> }
  box { <-1.35,0,-0.015>,<-1.15,0.7,0.015> }
  box { <1.35,0,-0.015>,<1.15,0.7,0.015> }
 }

#declare CryptLid=
 union {
  union {
   box { <-1.17,0.7,-0.62>,<1.17,0.8,0.62> }
   box { <-1.1,0.8,-0.55>,<1.1,0.83,0.55> }
   texture {T_Stone13 scale 0.5}
  }
  box { <-0.9,0.83,-0.4>,<0,0.831,0.4>
        texture {T_Gold_3A}
        normal {dents 0.8
                turbulence 1
                scale 0.025}
      }
  text {ttf "chancery.ttf" "Mikael Rasenov" 0.5, 0
        pigment { Black }
        scale 0.1
        rotate z*90
        rotate x*90
        translate <-0.7,0.832,-0.32>
       }
  text {ttf "chancery.ttf" "1543-1620" 0.5, 0
        pigment { Black }
        scale 0.11
        rotate z*90
        rotate x*90
        translate <-0.5,0.832,-0.2>
       }
  text {ttf "chancery.ttf" "May he rest in peace" 0.5, 0
        pigment { Black }
        scale 0.09
        rotate z*90
        rotate x*90
        translate <-0.3,0.832,-0.36>
       }
   blob {
    threshold .65
    cylinder { <-.3,-.28,0>, <-.3,.44,-.05>, .26, 1 }      //lower ring
    cylinder { <-.3,.44,-.05>, <-.3, .55,-.4>, .26, 1 }     //upper ring
    cylinder { <.05,-.28,0>, <.05, .49,-.05>, .26, 1 }     //lower middle
    cylinder { <.05,.49,-.05>, <.05, .55,-.4>, .26, 1 }    //upper middle
    cylinder { <.4,-.4,0>, <.4, .512, -.05>, .26, 1 }      //lower index
    cylinder { <.4,.512,-.05>, <.4, .55, -.4>, .26, 1 }    //upper index
    sphere { <-.3,.44,-.05>, .26, -1 }  //counteract ring knuckle bulge
    sphere { <-.3,-.28,0>, .26, -1 }    //counteract ring palm bulge
    sphere { <.05,.49,-.05>, .26, -1 }  //counteract middle knuckle bulge
    sphere { <.05,-.28,0>, .26, -1 }    //counteract middle palm bulge
    sphere { <.4,.512,-.05>, .26, -1 }  //counteract index knuckle bulge
    sphere { <.4,-.4,0>, .26, -1 }      //counteract index palm bulge
    pigment { Flesh }
    scale 0.17
    rotate <90,180,0>
    translate <0.7,0.68,-0.58>
  }
 }

#declare CryptEdge=
 union {
  box { <0,0,-0.03>,<1.5,0.25,0.03>
         texture {T_Stone13 scale 0.5}
      }
  box { <0,0,-0.031>,<1.5,0.25,0.03>
        texture {material_map { gif "scroll_sm.gif"
                                texture {pigment {Clear}}
                                texture {T_Gold_3B}
                              }
                 scale <1.5,0.25,1>
                }
       }
       translate <-0.75,-0.01,0>
      }

#declare CryptBasic=
 union {
  difference {
   box { <-1.35,0,-0.75>,<1.35,0.7,0.75> }
   box { <-1.1,0.05,-0.55>,<1.1,1.5,0.55> pigment {Yellow} finish {ambient 1}}
  }
 box { <-1.43,-0.05,-0.83>,<-1.15,0.03,-0.65> }
 box { <1.43,-0.05,-0.83>,<1.15,0.03,-0.65> }
 box { <-1.43,-0.05,0.83>,<-1.15,0.03,0.65> }
 box { <1.43,-0.05,0.83>,<1.15,0.03,0.65> }
 object {
  PatternFrame
  translate z*-0.755
 }
 object {
  PatternFrame
  translate z*0.755
 }
 object {
  CryptEdge
  rotate y*-90
  translate <1.27,0.7,0>
 }
 object {
  CryptEdge
  rotate y*90
  translate <-1.27,0.7,0>
 }
 texture {T_Stone13 scale 0.5}
}

#declare CryptComplex=
union {
  box { <-1.37,0.15,-0.57>,<-1.34,0.55,0.57>
        texture {T_Gold_3A}
        normal {dents 0.8
                turbulence 1
                scale 0.025}
      }
 box { <1.37,0.15,-0.57>,<1.34,0.55,0.57>
        texture {T_Gold_3A}
        normal {dents 0.8
                turbulence 1
                scale 0.025} }
  text { ttf "chancery.ttf" "Pause my friend as you pass by" 0.5, 0
    pigment { Black }
    scale 0.09
    rotate <0,-90,0>
    translate <1.372,0.47,-0.55>
 }
  text { ttf "chancery.ttf" "As you are, so once was I" 0.5, 0
    pigment { Black }
    scale 0.09
    rotate <0,-90,0>
    translate <1.372,0.38,-0.47>
 }
 text { ttf "chancery.ttf" "As I am, so shall you be" 0.5, 0
    pigment { Black }
    scale 0.09
    rotate <0,-90,0>
    translate <1.372,0.29,-0.4>
 }
 text { ttf "chancery.ttf" "Prepare you, then, to follow me" 0.5, 0
    pigment { Black }
    scale 0.09
    rotate <0,-90,0>
    translate <1.372,0.2,-0.55>
 }
}

#declare Crypt =
 union {
  object {CryptBasic}
  object {CryptComplex}
  object {
   CryptLid
   translate <0,-0.7655,-0.62>
   rotate x*10
   translate <0,0.7655,0.62>
  }
 }
/*
camera {
 location <0,1.5,-3.5>
 look_at <0,0.7,0>
}

light_source {
 <1,2,-2> color White
}
/*
light_source {
 <0,0.3,0> color Yellow*3
}
*/
background {Grey}

object {Crypt
        rotate y*70
       }
*/
