/* =======================================================================
digit.inc
makes a digital LED (Light Emitting Diode)-type digit

input: 'digit' is set to the wanted digit (0...9)
       'led_col' is set to the preferred color of an element;
                 (Red, Cyan, Green, ...)
		'led_lean' true if slanted digits

objects:
	led_dots_unlit
	led_dots_lit

an example:

#declare digit = 6
#declare led_col = color Cyan
#declare led_lean = 1
#declare number6 =
#include "digit.inc"

object { number6 scale <...> translate <...> }
...


======================================================================= */

// slanted digits
#ifndef (led_lean)
#declare led_lean = 0
#end

// ambience level for lit and unlit LED's.
#declare LED_Hi = 1
#declare LED_Lo = .09

// slanted
#declare slant = .2*(led_lean>0)

// Need only to be defined once per scene.
#ifndef (LEDs)
	#declare LEDs = 1

	//   x-a-       x = origo (0,0,0) in figure
	//  |     |
	//  f     b     (xy-axis)
	//  |     |
	//    -g-
	//  |     |
	//  e     c
	//  |     |
	//    -d-

	#declare led_element =
	polygon { 7, <0,0>, <1,1>, <7,1>, <8,0>, <7,-1>, <1,-1>, <0,0> }

	#declare led_a = object { led_element }
	#declare led_b = object { led_element rotate z*-90 translate <8,-1,0> }
	#declare led_c = object { led_element rotate z*-90 translate <8,-11,0> }
	#declare led_d = object { led_element translate <0,-20,0> }
	#declare led_e = object { led_element rotate z*-90 translate <0,-11,0> }
	#declare led_f = object { led_element rotate z*-90 translate <0,-1,0> }
	#declare led_g = object { led_element translate <0,-10,0> }

#end

// --------------------------------------------------------------------------

#declare led_dots_lit =
union
{
	disc { y*-5,-z,1 }
	disc { y*-15,-z,1 }
	matrix < 1, 0, 0,
			 slant, 1, 0,
			 0, 0, 1,
			 0, 0, 0 >
	pigment { color led_col } finish { ambient LED_Hi }
}

#declare led_dots_unlit =
union
{
	disc { y*-5,-z,1 }
	disc { y*-15,-z,1 }
	matrix < 1, 0, 0,
			 slant, 1, 0,
			 0, 0, 1,
			 0, 0, 0 >
	pigment { color led_col } finish { ambient LED_Lo }
}

// --------------------------------------------------------------------------

#ifdef (digit)
union
{
	#declare lit_a = #if ( !(digit=1 | digit=4) ) LED_Hi #else LED_Lo #end
	#declare lit_b = #if ( !(digit=5 | digit=6) ) LED_Hi #else LED_Lo #end
	#declare lit_c = #if ( digit!=2 ) LED_Hi #else LED_Lo #end
	#declare lit_d = #if ( !(digit=1 | digit=4 | digit=7) ) LED_Hi #else LED_Lo #end
	#declare lit_e = #if ( digit=0 | digit=2 | digit=6 | digit=8 ) LED_Hi #else LED_Lo #end
	#declare lit_f = #if ( !((digit>=1 & digit<=3) | digit=7) ) LED_Hi #else LED_Lo #end
	#declare lit_g = #if ( digit>1 & digit!=7 ) LED_Hi #else LED_Lo #end

	object { led_a pigment { color led_col } finish { ambient lit_a } }
	object { led_b pigment { color led_col } finish { ambient lit_b } }
	object { led_c pigment { color led_col } finish { ambient lit_c } }
	object { led_d pigment { color led_col } finish { ambient lit_d } }
	object { led_e pigment { color led_col } finish { ambient lit_e } }
	object { led_f pigment { color led_col } finish { ambient lit_f } }
	object { led_g pigment { color led_col } finish { ambient lit_g } }
	matrix < 1, 0, 0,
			 slant, 1, 0,
			 0, 0, 1,
			 0, 0, 0 >
}
#end

// end of digit.inc
