#version 3.0
#include "shapes.inc"

///////////////////////////////////////////////////////
// Parameter declarations

// Image parameters
#declare Isometric_Ratio    = 1   // W/H of image as rendered

// Stadium
#declare Stadium_Radius     = 100

// Cylinders (stadium pillars)
#declare Cylinder_Radius    = 20
#declare N_Cylinders        = 12
#declare Cylinder_dTheta    = (360/N_Cylinders)
#declare Cylinder_Theta0    = -0.8*Cylinder_dTheta
#declare Cylinder_Position  = <Stadium_Radius, 0, 0>
#declare Seed               = 3419
#declare RS                 = seed(Seed)

////////////////////////////////////////////////////////
// Render settings and cameras

global_settings {
   hf_gray_16
   ambient_light 1
   number_of_waves 3      // number of point sources for each wave function
}


// define the camera
camera {
  location <0, 200, 0>   // top view
  look_at  <0, 0, 0>
  orthographic
  up     <0,0,2 * Stadium_Radius>
  right  <2 * Isometric_Ratio * Stadium_Radius,0,0>
}


///////////////////////////////////////////////////
// Water


#declare F0_Multiplier   = 2
#declare Wave_f0 = 2*F0_Multiplier/(2*Stadium_Radius/Cylinder_Radius - 1)
#declare Weight_H1  = 1
#declare Weight_H2  = 1
#declare Weight_H3  = 2/3
#declare Weight_H4  = 1/2
#declare Weight_H6  = 1/3
#declare Weight_H8  = 1/4
#declare Weight_H10 = 1/5
#declare Weight_H12 = 1/6
#declare Weight_H16 = 1/8
#declare Weight_H20 = 1/10
#declare Weight_H24 = 1/12
#declare Weight_H32 = 1/16


#declare Wave_Pigment_Unit =
  pigment {
    average
    pigment_map {
     [ Weight_H1          
        ripples
        frequency Wave_f0
        rotate <90, 0, 0>
        translate <-0.5, 0, -0.5>
        scale Cylinder_Radius
      ]
      [ Weight_H2          
        ripples
        frequency Wave_f0
        rotate <90, 0, 0>
        translate <-0.5, 0, -0.5>
        scale Cylinder_Radius/2
      ]
      [ Weight_H3          
        ripples
        frequency Wave_f0
        rotate <90, 0, 0>
        translate <-0.5, 0, -0.5>
        scale Cylinder_Radius/3
      ]
      [ Weight_H4          
        ripples
        frequency Wave_f0
        rotate <90, 0, 0>
        translate <-0.5, 0, -0.5>
        scale Cylinder_Radius/4
      ]
      [ Weight_H6          
        ripples
        frequency Wave_f0
        rotate <90, 0, 0>
        translate <-0.5, 0, -0.5>
        scale Cylinder_Radius/6
      ]
      [ Weight_H8          
        ripples
        frequency Wave_f0
        rotate <90, 0, 0>
        translate <-0.5, 0, -0.5>
        scale Cylinder_Radius/8
      ]
      [ Weight_H10          
        ripples
        frequency Wave_f0
        rotate <90, 0, 0>
        translate <-0.5, 0, -0.5>
        scale Cylinder_Radius/10
      ]
      [ Weight_H12          
        ripples
        frequency Wave_f0
        rotate <90, 0, 0>
        translate <-0.5, 0, -0.5>
        scale Cylinder_Radius/12
      ]
      [ Weight_H16          
        ripples
        frequency Wave_f0
        rotate <90, 0, 0>
        translate <-0.5, 0, -0.5>
        scale Cylinder_Radius/16
      ]
      [ Weight_H20          
        ripples
        frequency Wave_f0
        rotate <90, 0, 0>
        translate <-0.5, 0, -0.5>
        scale Cylinder_Radius/20
      ]
      [ Weight_H24          
        ripples
        frequency Wave_f0
        rotate <90, 0, 0>
        translate <-0.5, 0, -0.5>
        scale Cylinder_Radius/24
      ]
      [ Weight_H32          
        ripples
        frequency Wave_f0
        rotate <90, 0, 0>
        translate <-0.5, 0, -0.5>
        scale Cylinder_Radius/32
      ]
    }
    translate Cylinder_Position
  }

 plane {
  <0, 1, 0>     // surface normal
  0             // distance from origin
  texture {
    pigment {
      average
      pigment_map {
        [ 1
          Wave_Pigment_Unit
          rotate <0, Cylinder_Theta0 + 0*Cylinder_dTheta, 0>
        ]
        [ 1
          Wave_Pigment_Unit
          rotate <0, Cylinder_Theta0 + 1*Cylinder_dTheta, 0>
        ]
        [ 1
          Wave_Pigment_Unit
          rotate <0, Cylinder_Theta0 + 2*Cylinder_dTheta, 0>
        ]
        [ 1
          Wave_Pigment_Unit
          rotate <0, Cylinder_Theta0 + 3*Cylinder_dTheta, 0>
        ]
        [ 1
          Wave_Pigment_Unit
          rotate <0, Cylinder_Theta0 + 4*Cylinder_dTheta, 0>
        ]
        [ 1
          Wave_Pigment_Unit
          rotate <0, Cylinder_Theta0 + 5*Cylinder_dTheta, 0>
        ]
        [ 1
          Wave_Pigment_Unit
          rotate <0, Cylinder_Theta0 + 6*Cylinder_dTheta, 0>
        ]
        [ 1
          Wave_Pigment_Unit
          rotate <0, Cylinder_Theta0 + 7*Cylinder_dTheta, 0>
        ]
        [ 1
          Wave_Pigment_Unit
          rotate <0, Cylinder_Theta0 + 8*Cylinder_dTheta, 0>
        ]
        [ 1
          Wave_Pigment_Unit
          rotate <0, Cylinder_Theta0 + 9*Cylinder_dTheta, 0>
        ]
        [ 1
          Wave_Pigment_Unit
          rotate <0, Cylinder_Theta0 + 10*Cylinder_dTheta, 0>
        ]
        [ 1
          Wave_Pigment_Unit
          rotate <0, Cylinder_Theta0 + 11*Cylinder_dTheta, 0>
        ]
      }
    }
    finish {
      ambient 1
    }
  }
}
