/* "The Altar of Cho" - this part was assembled piece by piece in MORAY
   so you'll find the altar and all its offerings unioned at the end to
   facility on big RHC->LHC conversion at the end. 
*/

#declare Altarstone =
   texture  // Altarstone
   {
      pigment
      {
         granite
         color_map
         {
            [ 0.0     rgbft <0.55, 0.55, 0.55, 0.0, 0.0> ]
            [ 1.0     rgbft <0.65, 0.65, 0.65, 0.0, 0.0> ]
         }
         frequency 50.0
      }
      normal
      {
         crackle , 0.25
         turbulence 0.52
         frequency 0.0
      }
      finish
      {
         ambient 0.2
         diffuse 0.65
         brilliance 1.2
         phong_size 0.66
         roughness 0.0
         crand 0.03
      }
      scale  0.25
      rotate    <-31.0, -12.0, -25.0>
      translate    <31.0, 25.0, 10.0>
   }


#declare LunarSilver =
   texture  // LunarSilver
   {
      pigment
      {
         color rgb <0.9, 0.9, 0.935>
      }
      finish
      {
         ambient 0.2
         diffuse 0.65
         brilliance 2.0
         metallic 1.0
         reflection 0.025
      }
   }

#declare RedClay =
   texture  // RedClay
   {
      pigment
      {
         color rgb <0.6979, 0.367993, 0.26957>
      }
      finish
      {
         ambient 0.2
         diffuse 0.55
         brilliance 1.2
         specular 0.05
         roughness 1.0
         crand 0.01
      }
   }

#declare SilverMetal =
   texture  // SilverMetal
   {
      pigment
      {
         color rgb <0.844858, 0.844858, 0.869475>
      }
      finish
      {
         ambient 0.21
         diffuse 0.7
         brilliance 3.0
         specular 0.4
         roughness 0.02
         metallic 1.0
         reflection 0.025
      }
   }

#declare Grapefruit =
   texture  // Grapefruit
   {
      pigment
      {
         color rgb <0.875, 0.739567, 0.1354>
      }
      normal
      {
         bumps , 0.1

         scale  0.05
      }
      finish
      {
         ambient 0.1
         diffuse 0.7
         brilliance 0.902
         specular 0.071933
         roughness 0.203
      }
   }

#declare AppleRed =
   texture  // AppleRed
   {
      pigment
      {
         color rgb <1.0, 0.177067, 0.177067>
      }
      finish
      {
         ambient 0.1
         specular 0.5
         roughness 0.025
      }
   }

#declare PearGreen =
   texture  // PearGreen
   {
      pigment
      {
         color rgb <0.614567, 0.718733, 0.114567>
      }
      normal
      {
         bumps , 0.05

         scale  0.05
      }
   }

#declare Painted_Clay =
   texture  // RedClay_1
   {
      pigment
      {
         color rgb <0.6979, 0.367993, 0.26957>
      }
      finish
      {
         ambient 0.2
         diffuse 0.55
         brilliance 1.2
         specular 0.05
         roughness 1.0
         crand 0.01
      }
   }
   texture  // Grainsigns
   {
      pigment
      {
         image_map
         {
            gif   "grainsig.gif"
            map_type 2
            once
            transmit 0, 1.0
         }
         scale  <-1,1,1>
         rotate 90*x
         rotate -90.0 * z
      }
      finish
      {
         ambient 0.2
         diffuse 0.55
         specular 0.007167
         roughness 0.25
      }
   }


#declare jugbody = lathe {
  cubic_spline
  10  // control points
  <-0.37198, 0.085725>,
  <0.000002, 0.000001>,
  <0.18978, 0.042263>,
  <0.225676, 0.240188>,
  <0.147731, 0.424193>,
  <0.195057, 0.535787>,
  <0.180961, 0.574351>,
  <0.139751, 0.515043>,
  <0.115573, 0.409064>,
  <0.04367, 0.328271>
  rotate <90,0,90>
  texture {
    Painted_Clay
    scale <1.0, 1.0, 0.4>
    translate <0.000000, 0.000000, 0.075000>
  }
  scale <9.0, 9.0, 11.0>
}
#declare clayjug = union {
  object { jugbody }
  sphere { // lid
    <0,0,0>,1
    scale <1.7, 1.7, 0.5>
    translate  6.050156*z
  }
  sphere { // knob
    <0,0,0>,1
    texture {
      RedClay
    }
    scale <0.2, 0.2, 0.27>
    translate  6.75*z
  }
  cone { // knobmount
    <0,0,0>, 0.2, <0,0,1>, 0.1
    scale <1.0, 1.0, 0.3>
    translate  6.3*z
  }
  texture {
    RedClay
  }
  rotate 5.0*z
  translate  <-22.549377, 7.279092, 5.009855>
}

#declare Traybody = lathe {
  quadratic_spline
  8  // control points
  <-1.220035, 0.237604>,
  <0.000513, 0.000505>,
  <1.28619, 0.017419>,
  <2.58478, 0.394506>,
  <3.131014, 0.911329>,
  <2.678871, 0.850132>,
  <1.321852, 0.429203>,
  <0.002962, 0.244947>
  rotate <90,0,90>
}
#declare rhandle = difference {
  torus { // rhandleshape
    1.5, 0.2  rotate -x*90
    scale <1.0, 1.0, 0.5>
    rotate -52.684715*y
    translate  <0.518263, 0.0, 0.322031>
  }
  box { // rhandlecut
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 0.75>
    rotate 39.186607*y
    translate  <-1.0, 0.0, 0.3>
  }
  scale <1.0, 0.65, 0.2>
  rotate -15.0*y
  translate  <2.4, 0.0, 0.619738>
}
#declare lhandle = difference {
  torus { // lhandleshape
    1.5, 0.2  rotate -x*90
    scale <1.0, 1.0, 0.5>
    rotate -52.684715*y
    translate  <0.518263, 0.0, 0.322031>
  }
  box { // lhandlecut
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 0.75>
    rotate 39.186607*y
    translate  <-1.0, 0.0, 0.3>
  }
  scale <1.0, 0.65, 0.2>
  rotate <0.0, -15.0, 180.0>
  translate  <-2.4, 0.0, 0.619738>
}
#declare Silvertray = union {
  object { Traybody }
  object { rhandle }
  object { lhandle }
  texture {
    SilverMetal
  }
  scale <1.5, 1.0, 1.0>
  translate  -0.5*z
}
#declare Pear = lathe {
  cubic_spline
  9  // control points
  <-1.050178, 0.188182>,
  <0.000063, 0.000023>,
  <0.834741, 0.127175>,
  <1.000387, 0.596736>,
  <0.720411, 0.987258>,
  <0.458521, 1.194352>,
  <0.330574, 1.942635>,
  <0.000954, 2.053886>,
  <0.221273, 2.2508>
  rotate <90,0,90>
  texture {
    PearGreen
  }
  scale <1.0, 1.0, 1.25>
  rotate <20.0, 5.0, 0.0>
  translate  <-1.720336, 1.471615, 0.0>
}
#declare Pear1 = lathe {
  cubic_spline
  9  // control points
  <-1.050178, 0.188182>,
  <0.000063, 0.000023>,
  <0.834741, 0.127175>,
  <1.000387, 0.596736>,
  <0.720411, 0.987258>,
  <0.458521, 1.194352>,
  <0.330574, 1.942635>,
  <0.000954, 2.053886>,
  <0.221273, 2.2508>
  rotate <90,0,90>
  texture {
    PearGreen
  }
  scale <1.0, 1.0, 1.25>
  rotate <10.0, 5.0, 0.0>
  translate  <0.769953, 2.097425, 0.0>
}
#declare Pear2 = lathe {
  cubic_spline
  9  // control points
  <-1.050178, 0.188182>,
  <0.000063, 0.000023>,
  <0.834741, 0.127175>,
  <1.000387, 0.596736>,
  <0.720411, 0.987258>,
  <0.458521, 1.194352>,
  <0.330574, 1.942635>,
  <0.000954, 2.053886>,
  <0.221273, 2.2508>
  rotate <90,0,90>
  texture {
    PearGreen
  }
  scale <1.0, 1.0, 1.25>
  rotate <-10.0, -5.0, 0.0>
  translate  <0.965608, -2.074637, 0.0>
}
#declare Pear3 = lathe {
  cubic_spline
  9  // control points
  <-1.050178, 0.188182>,
  <0.000063, 0.000023>,
  <0.834741, 0.127175>,
  <1.000387, 0.596736>,
  <0.720411, 0.987258>,
  <0.458521, 1.194352>,
  <0.330574, 1.942635>,
  <0.000954, 2.053886>,
  <0.221273, 2.2508>
  rotate <90,0,90>
  texture {
    PearGreen
  }
  scale <0.9, 0.9, 1.1>
  rotate <-7.0, -8.0, 0.0>
  translate  <1.901831, 0.488661, 0.992645>
}
#declare OfferingTray = union {
  object { Silvertray }
  sphere { // Grapefruit2
    <0,0,0>,1
    texture {
      Grapefruit
    }
    scale 0.9
    translate  <2.042515, -1.186581, 1.992645>
  }
  torus { // Apple5
    0.5, 0.5  rotate -x*90
    texture {
      AppleRed
    }
    scale <0.9, 0.9, 1.1>
    rotate <-5.0, 5.0, 0.0>
    translate  <-1.565239, -0.676792, 1.65>
  }
  torus { // Apple4
    0.5, 0.5  rotate -x*90
    texture {
      AppleRed
    }
    translate  <-0.965351, -1.582484, 0.75>
  }
  torus { // Apple1
    0.5, 0.5  rotate -x*90
    texture {
      AppleRed
    }
    rotate <-5.0, -10.0, 0.0>
    translate  <2.795598, -1.496834, 0.75>
  }
  sphere { // Grapefruit6
    <0,0,0>,1
    texture {
      Grapefruit
    }
    translate  <-2.67184, -0.322889, 1.0>
  }
  sphere { // Grapefruit1
    <0,0,0>,1
    texture {
      Grapefruit
    }
    translate  <0.046474, 0.30292, 1.0>
  }
  sphere { // Grapefruit3
    <0,0,0>,1
    texture {
      Grapefruit
    }
    translate  <2.046474, 0.511523, 1.0>
  }
  sphere { // Grapefruit
    <0,0,0>,1
    texture {
      Grapefruit
    }
    scale 0.9
    translate  <0.181842, -0.53083, 1.992645>
  }
  object { Pear }
  torus { // Apple
    0.5, 0.5  rotate -x*90
    texture {
      AppleRed
    }
    translate  <-0.003542, 1.530095, 1.910081>
  }
  object { Pear1 }
  object { Pear2 }
  object { Pear3 }
  scale <1.0, -1.0, 1.0>
  translate  <-0.297256, 7.134152, 5.494679>
}
#declare Urnbody = lathe {
  cubic_spline
  10  // control points
  <-0.37198, 0.085725>,
  <0.000002, 0.000001>,
  <0.18978, 0.042263>,
  <0.225676, 0.240188>,
  <0.147731, 0.424193>,
  <0.195057, 0.535787>,
  <0.180961, 0.574351>,
  <0.139751, 0.515043>,
  <0.115573, 0.409064>,
  <0.04367, 0.328271>
  rotate <90,0,90>
  scale <9.0, 9.0, 11.0>
}
#declare Righthandle = difference {
  torus { // Rhandleshape
    1.5, 0.251  rotate -x*90
    scale <0.75, 1.0, 0.75>
    rotate -90.0*x
    translate  <1.507129, 0.0, 3.969998>
  }
  box { // Rhandlecut
    <-1, -1, -1>, <1, 1, 1>
    scale <1.110278, 1.0, 1.845462>
    translate  <0.367592, 0.0, 3.969998>
  }
  translate  <-0.110278, 0.0, -0.147037>
}
#declare LeftHandle = difference {
  torus { // LHandleshape
    1.5, 0.251  rotate -x*90
    scale <0.75, 1.0, 0.75>
    rotate -90.0*x
    translate  <1.507129, 0.0, 3.969998>
  }
  box { // Lhandlecut
    <-1, -1, -1>, <1, 1, 1>
    scale <1.110278, 1.0, 1.845462>
    translate  <0.367592, 0.0, 3.969998>
  }
  scale -1.0
  rotate -180.0*x
  translate  <0.110278, 0.0, -0.220555>
}
#declare SilverUrn = union {
  object { Urnbody }
  object { Righthandle }
  object { LeftHandle }
  texture {
    LunarSilver
  }
  scale <0.727273, 0.8, 0.8>
  translate  <-32.81513, 2.217544, 15.073401>
}
#declare Urnbody1 = lathe {
  cubic_spline
  10  // control points
  <-0.37198, 0.085725>,
  <0.000002, 0.000001>,
  <0.18978, 0.042263>,
  <0.225676, 0.240188>,
  <0.147731, 0.424193>,
  <0.195057, 0.535787>,
  <0.180961, 0.574351>,
  <0.139751, 0.515043>,
  <0.115573, 0.409064>,
  <0.04367, 0.328271>
  rotate <90,0,90>
  scale <9.0, 9.0, 11.0>
}
#declare Righthandle1 = difference {
  torus { // Rhandleshape1
    1.5, 0.251  rotate -x*90
    scale <0.75, 1.0, 0.75>
    rotate -90.0*x
    translate  <1.507129, 0.0, 3.969998>
  }
  box { // Rhandlecut1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.110278, 1.0, 1.845462>
    translate  <0.367592, 0.0, 3.969998>
  }
  translate  <-0.110278, 0.0, -0.147037>
}
#declare LeftHandle1 = difference {
  torus { // LHandleshape1
    1.5, 0.251  rotate -x*90
    scale <0.75, 1.0, 0.75>
    rotate -90.0*x
    translate  <1.507129, 0.0, 3.969998>
  }
  box { // Lhandlecut1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.110278, 1.0, 1.845462>
    translate  <0.367592, 0.0, 3.969998>
  }
  scale -1.0
  rotate -180.0*x
  translate  <0.110278, 0.0, -0.220555>
}
#declare SilverUrn1 = union {
  object { Urnbody1 }
  object { Righthandle1 }
  object { LeftHandle1 }
  texture {
    LunarSilver
  }
  scale <0.727273, 0.8, 0.8>
  translate  <32.815127, 2.217544, 15.073401>
}
#declare Traybody2 = lathe {
  quadratic_spline
  8  // control points
  <-1.220035, 0.237604>,
  <0.000513, 0.000505>,
  <1.28619, 0.017419>,
  <2.58478, 0.394506>,
  <3.131014, 0.911329>,
  <2.678871, 0.850132>,
  <1.321852, 0.429203>,
  <0.002962, 0.244947>
  rotate <90,0,90>
}
#declare rhandle2 = difference {
  torus { // rhandleshape2
    1.5, 0.2  rotate -x*90
    scale <1.0, 1.0, 0.5>
    rotate -52.684715*y
    translate  <0.518263, 0.0, 0.322031>
  }
  box { // rhandlecut2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 0.75>
    rotate 39.186607*y
    translate  <-1.0, 0.0, 0.3>
  }
  scale <1.0, 0.65, 0.2>
  rotate -15.0*y
  translate  <2.4, 0.0, 0.619738>
}
#declare lhandle2 = difference {
  torus { // lhandleshape2
    1.5, 0.2  rotate -x*90
    scale <1.0, 1.0, 0.5>
    rotate -52.684715*y
    translate  <0.518263, 0.0, 0.322031>
  }
  box { // lhandlecut2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 0.75>
    rotate 39.186607*y
    translate  <-1.0, 0.0, 0.3>
  }
  scale <1.0, 0.65, 0.2>
  rotate <0.0, -15.0, 180.0>
  translate  <-2.4, 0.0, 0.619738>
}
#declare Silvertray2 = union {
  object { Traybody2 }
  object { rhandle2 }
  object { lhandle2 }
  texture {
    SilverMetal
  }
  scale <1.5, 1.0, 1.0>
  translate  -0.5*z
}
#declare Pear8 = lathe {
  cubic_spline
  9  // control points
  <-1.050178, 0.188182>,
  <0.000063, 0.000023>,
  <0.834741, 0.127175>,
  <1.000387, 0.596736>,
  <0.720411, 0.987258>,
  <0.458521, 1.194352>,
  <0.330574, 1.942635>,
  <0.000954, 2.053886>,
  <0.221273, 2.2508>
  rotate <90,0,90>
  texture {
    PearGreen
  }
  scale <1.0, 1.0, 1.25>
  rotate <20.0, 5.0, 0.0>
  translate  <-1.720336, 1.471615, 0.0>
}
#declare Pear9 = lathe {
  cubic_spline
  9  // control points
  <-1.050178, 0.188182>,
  <0.000063, 0.000023>,
  <0.834741, 0.127175>,
  <1.000387, 0.596736>,
  <0.720411, 0.987258>,
  <0.458521, 1.194352>,
  <0.330574, 1.942635>,
  <0.000954, 2.053886>,
  <0.221273, 2.2508>
  rotate <90,0,90>
  texture {
    PearGreen
  }
  scale <1.0, 1.0, 1.25>
  rotate <10.0, 5.0, 0.0>
  translate  <0.769953, 2.097425, 0.0>
}
#declare Pear10 = lathe {
  cubic_spline
  9  // control points
  <-1.050178, 0.188182>,
  <0.000063, 0.000023>,
  <0.834741, 0.127175>,
  <1.000387, 0.596736>,
  <0.720411, 0.987258>,
  <0.458521, 1.194352>,
  <0.330574, 1.942635>,
  <0.000954, 2.053886>,
  <0.221273, 2.2508>
  rotate <90,0,90>
  texture {
    PearGreen
  }
  scale <1.0, 1.0, 1.25>
  rotate <-10.0, -5.0, 0.0>
  translate  <0.965608, -2.074637, 0.0>
}
#declare Pear11 = lathe {
  cubic_spline
  9  // control points
  <-1.050178, 0.188182>,
  <0.000063, 0.000023>,
  <0.834741, 0.127175>,
  <1.000387, 0.596736>,
  <0.720411, 0.987258>,
  <0.458521, 1.194352>,
  <0.330574, 1.942635>,
  <0.000954, 2.053886>,
  <0.221273, 2.2508>
  rotate <90,0,90>
  texture {
    PearGreen
  }
  scale <0.9, 0.9, 1.1>
  rotate <-7.0, -8.0, 0.0>
  translate  <1.901831, 0.488661, 0.992645>
}
#declare OfferingTray3 = union {
  object { Silvertray2 }
  sphere { // Grapefruit10
    <0,0,0>,1
    texture {
      Grapefruit
    }
    scale 0.9
    translate  <2.042515, -1.186581, 1.992645>
  }
  torus { // Apple8
    0.5, 0.5  rotate -x*90
    texture {
      AppleRed
    }
    scale <0.9, 0.9, 1.1>
    rotate <-5.0, 5.0, 0.0>
    translate  <-1.565239, -0.676792, 1.65>
  }
  torus { // Apple9
    0.5, 0.5  rotate -x*90
    texture {
      AppleRed
    }
    translate  <-0.965351, -1.582484, 0.75>
  }
  torus { // Apple10
    0.5, 0.5  rotate -x*90
    texture {
      AppleRed
    }
    rotate <-5.0, -10.0, 0.0>
    translate  <2.795598, -1.496834, 0.75>
  }
  sphere { // Grapefruit11
    <0,0,0>,1
    texture {
      Grapefruit
    }
    translate  <-2.67184, -0.322889, 1.0>
  }
  sphere { // Grapefruit12
    <0,0,0>,1
    texture {
      Grapefruit
    }
    translate  <0.046474, 0.30292, 1.0>
  }
  sphere { // Grapefruit13
    <0,0,0>,1
    texture {
      Grapefruit
    }
    translate  <2.046474, 0.511523, 1.0>
  }
  sphere { // Grapefruit14
    <0,0,0>,1
    texture {
      Grapefruit
    }
    scale 0.9
    translate  <0.181842, -0.53083, 1.992645>
  }
  object { Pear8 }
  torus { // Apple11
    0.5, 0.5  rotate -x*90
    texture {
      AppleRed
    }
    translate  <-0.003542, 1.530095, 1.910081>
  }
  object { Pear9 }
  object { Pear10 }
  object { Pear11 }
  rotate 18.0*z
  translate  <-14.349097, 5.945126, 5.494679>
}
#declare Traybody1 = lathe {
  quadratic_spline
  8  // control points
  <-1.220035, 0.237604>,
  <0.000513, 0.000505>,
  <1.28619, 0.017419>,
  <2.58478, 0.394506>,
  <3.131014, 0.911329>,
  <2.678871, 0.850132>,
  <1.321852, 0.429203>,
  <0.002962, 0.244947>
  rotate <90,0,90>
}
#declare rhandle1 = difference {
  torus { // rhandleshape1
    1.5, 0.2  rotate -x*90
    scale <1.0, 1.0, 0.5>
    rotate -52.684715*y
    translate  <0.518263, 0.0, 0.322031>
  }
  box { // rhandlecut1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 0.75>
    rotate 39.186607*y
    translate  <-1.0, 0.0, 0.3>
  }
  scale <1.0, 0.65, 0.2>
  rotate -15.0*y
  translate  <2.4, 0.0, 0.619738>
}
#declare lhandle1 = difference {
  torus { // lhandleshape1
    1.5, 0.2  rotate -x*90
    scale <1.0, 1.0, 0.5>
    rotate -52.684715*y
    translate  <0.518263, 0.0, 0.322031>
  }
  box { // lhandlecut1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 0.75>
    rotate 39.186607*y
    translate  <-1.0, 0.0, 0.3>
  }
  scale <1.0, 0.65, 0.2>
  rotate <0.0, -15.0, 180.0>
  translate  <-2.4, 0.0, 0.619738>
}
#declare Silvertray1 = union {
  object { Traybody1 }
  object { rhandle1 }
  object { lhandle1 }
  texture {
    SilverMetal
  }
  scale <1.5, 1.0, 1.0>
  translate  -0.5*z
}
#declare Pear4 = lathe {
  cubic_spline
  9  // control points
  <-1.050178, 0.188182>,
  <0.000063, 0.000023>,
  <0.834741, 0.127175>,
  <1.000387, 0.596736>,
  <0.720411, 0.987258>,
  <0.458521, 1.194352>,
  <0.330574, 1.942635>,
  <0.000954, 2.053886>,
  <0.221273, 2.2508>
  rotate <90,0,90>
  texture {
    PearGreen
  }
  scale <1.0, 1.0, 1.25>
  rotate <20.0, 5.0, 0.0>
  translate  <-1.720336, 1.471615, 0.0>
}
#declare Pear5 = lathe {
  cubic_spline
  9  // control points
  <-1.050178, 0.188182>,
  <0.000063, 0.000023>,
  <0.834741, 0.127175>,
  <1.000387, 0.596736>,
  <0.720411, 0.987258>,
  <0.458521, 1.194352>,
  <0.330574, 1.942635>,
  <0.000954, 2.053886>,
  <0.221273, 2.2508>
  rotate <90,0,90>
  texture {
    PearGreen
  }
  scale <1.0, 1.0, 1.25>
  rotate <10.0, 5.0, 0.0>
  translate  <0.769953, 2.097425, 0.0>
}
#declare Pear6 = lathe {
  cubic_spline
  9  // control points
  <-1.050178, 0.188182>,
  <0.000063, 0.000023>,
  <0.834741, 0.127175>,
  <1.000387, 0.596736>,
  <0.720411, 0.987258>,
  <0.458521, 1.194352>,
  <0.330574, 1.942635>,
  <0.000954, 2.053886>,
  <0.221273, 2.2508>
  rotate <90,0,90>
  texture {
    PearGreen
  }
  scale <1.0, 1.0, 1.25>
  rotate <-10.0, -5.0, 0.0>
  translate  <0.965608, -2.074637, 0.0>
}
#declare Pear7 = lathe {
  cubic_spline
  9  // control points
  <-1.050178, 0.188182>,
  <0.000063, 0.000023>,
  <0.834741, 0.127175>,
  <1.000387, 0.596736>,
  <0.720411, 0.987258>,
  <0.458521, 1.194352>,
  <0.330574, 1.942635>,
  <0.000954, 2.053886>,
  <0.221273, 2.2508>
  rotate <90,0,90>
  texture {
    PearGreen
  }
  scale <0.9, 0.9, 1.1>
  rotate <-7.0, -8.0, 0.0>
  translate  <1.901831, 0.488661, 0.992645>
}
#declare OfferingTray2 = union {
  object { Silvertray1 }
  sphere { // Grapefruit4
    <0,0,0>,1
    texture {
      Grapefruit
    }
    scale 0.9
    translate  <2.042515, -1.186581, 1.992645>
  }
  torus { // Apple6
    0.5, 0.5  rotate -x*90
    texture {
      AppleRed
    }
    scale <0.9, 0.9, 1.1>
    rotate <-5.0, 5.0, 0.0>
    translate  <-1.565239, -0.676792, 1.65>
  }
  torus { // Apple7
    0.5, 0.5  rotate -x*90
    texture {
      AppleRed
    }
    translate  <-0.965351, -1.582484, 0.75>
  }
  torus { // Apple2
    0.5, 0.5  rotate -x*90
    texture {
      AppleRed
    }
    rotate <-5.0, -10.0, 0.0>
    translate  <2.795598, -1.496834, 0.75>
  }
  sphere { // Grapefruit7
    <0,0,0>,1
    texture {
      Grapefruit
    }
    translate  <-2.67184, -0.322889, 1.0>
  }
  sphere { // Grapefruit5
    <0,0,0>,1
    texture {
      Grapefruit
    }
    translate  <0.046474, 0.30292, 1.0>
  }
  sphere { // Grapefruit8
    <0,0,0>,1
    texture {
      Grapefruit
    }
    translate  <2.046474, 0.511523, 1.0>
  }
  sphere { // Grapefruit9
    <0,0,0>,1
    texture {
      Grapefruit
    }
    scale 0.9
    translate  <0.181842, -0.53083, 1.992645>
  }
  object { Pear4 }
  torus { // Apple3
    0.5, 0.5  rotate -x*90
    texture {
      AppleRed
    }
    translate  <-0.003542, 1.530095, 1.910081>
  }
  object { Pear5 }
  object { Pear6 }
  object { Pear7 }
  scale <-1.0, 1.0, 1.0>
  rotate -17.0*z
  translate  <14.971047, 6.836895, 5.494679>
}
#declare AltarBaseShape = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <35.017644, 0.004056>,
  <-35.997735, 0.002436>,
  <-24.999967, 19.000167>,
  <25.009652, 19.035509>,
  <35.017644, 0.004056>
  rotate -x*90
  texture {
    Altarstone
  }
  scale <1.0, 1.0, 75.0>
  translate  -60.0*z
}
#declare AltarCutShape = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <35.017644, 0.004056>,
  <-35.997735, 0.002436>,
  <-24.999967, 19.000167>,
  <25.009652, 19.035509>,
  <35.017644, 0.004056>
  rotate -x*90
  texture {
    Altarstone
  }
  scale <0.9, 0.9, 10.0>
  translate  <0.0, -0.001, 5.001>
}
#declare Altarbody = difference {
  object { AltarBaseShape }
  object { AltarCutShape }
  texture {
    Altarstone
  }
}
#declare Altarbackshape = union {
  box { // AltarBack1
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 5.0, 37.5>
    translate  <0.0, 22.1, -7.5>
  }
  box { // AltarBack2
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 5.0, 37.5>
    translate  <0.0, 22.1, -11.0>
  }
  box { // AltarBack3
    <-1, -1, -1>, <1, 1, 1>
    scale <22.0, 5.0, 37.5>
    translate  <0.0, 22.1, -15.0>
  }
  texture {
    Altarstone
  }
  scale <1.1, 1.0, 1.0>
}
#declare Carvings = object {
  height_field {
    tga "runecarv.tga"
    water_level 0.01
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    Altarstone
  }
  scale <24.256182, 7.506869, 1.0>
  rotate -90.0*x
  translate  <-0.167306, 17.327839, 22.56182>
}
#declare Altarback = difference {
  object { Altarbackshape }
  object { Carvings }
  scale <0.909091, 1.0, 1.0>
}


/********* Final assembly of altar ***********/
union { // CompleteAltar
  object { clayjug }
  object { OfferingTray }
  object { SilverUrn }
  object { SilverUrn1 }
  sphere { // FullMoon
    <0,0,0>,1
    texture {
      LunarSilver
    }
    scale <4.545455, 5.0, 5.0>
    translate  <0.0, 22.062717, 34.65>
  }
  sphere { // FirstHalf
    <0,0,0>,1
    texture {
      LunarSilver
    }
    scale <2.727273, 3.0, 3.0>
    translate  <-9.545454, 22.062717, 29.25>
  }
  sphere { // LastHalf
    <0,0,0>,1
    texture {
      LunarSilver
    }
    scale <2.727273, 3.0, 3.0>
    translate  <9.545454, 22.062717, 29.25>
  }
  sphere { // FirstCresent
    <0,0,0>,1
    texture {
      LunarSilver
    }
    scale <1.818182, 2.0, 2.0>
    translate  <-18.2, 22.1, 24.5>
  }
  sphere { // LastCresent
    <0,0,0>,1
    texture {
      LunarSilver
    }
    scale <1.818182, 2.0, 2.0>
    translate  <18.2, 22.1, 24.5>
  }
  object { OfferingTray3 }
  object { OfferingTray2 }
  object { Altarbody }
  object { Altarback }
  object { // clayjug1->clayjug
    clayjug
    scale <0.909816, 0.999203, 1.0>
    rotate 5.497076*z
    translate  <8.309906, 7.801692, 0.0>
  }
  object { // clayjug2->clayjug
    clayjug
    scale <0.909091, 1.0, 1.0>
    translate  <20.166035, 6.444876, 0.0>
  }
  object { // clayjug3->clayjug
    clayjug
    scale <0.90912, 0.999968, 1.0>
    rotate -1.099977*z
    translate  <32.064602, 5.499359, 0.0>
  }
  object { // clayjug4->clayjug
    clayjug
    scale <0.909816, 0.999203, 1.0>
    rotate -5.497076*z
    translate  <42.432377, 0.317425, 0.0>
  }
  scale <1.1, 1.0, 1.0>
	/*RHC -> LHC conversion*/ rotate -90*x  scale <1,1,-1>
	translate <0,0,Z2>
}






