/* Master scene file for
	"Cold Hearted Orb That Rules The Night"
                         --Copyright April 1998 by Charles Fusner--
*/

global_settings {  //with skies so deep, better crank up maxtrace.
				   //ADC bailout should kill any excess.
	max_trace_level 15
}

//Declare these values, because the parallax computations will need
// them later on.

#declare XCamLoc = -750
#declare YCamLoc = 170
#declare YCamLook = 20
#declare Zback = 1700

/*Final main view*/
camera {
	location <XCamLoc,YCamLoc,-Zback>
	look_at<0,YCamLook,0>
	angle 6
}

/*Centralized light sources*/

light_source { //Overhead (starlight/reflected moonlight, etc)
	 <0,700,-300> color rgb .875
 }

light_source { //reflected light, fill light
	<1000,-20,-1000> color rgb<.2,.2,.22> shadowless
}

light_source { //reflected light, fill light
	<-1000,-20,-1000> color rgb<.2,.2,.22> shadowless
}

//note: there are also light sources assigned in torch.ini to each of
//the torchfires, and a separate light found inside each of the
//tower stacks with windows, so there are a total all told of 11 lights
//in this scene.


/* PARALLAX COMPUTATIONS -- the base rotation of the sky elements is
   <-2.826,0,0>, due to the fact that several scene elements were
   initially designed flush with the "horizon" and had to be rotated up
   to where they could be scene over the ground elements. From there,
   the movement of the camera will further modify them as shown below
   in order that the camera can be freely moved about to try different
   shots without "losing" the sky elements. */

#declare Yrot = atan2(XCamLoc,Zback)
	#declare Yrot= degrees(Yrot)
#declare Xrot = atan2(YCamLoc-YCamLook, Zback)
	#declare Xrot = degrees(Xrot)
#declare Skyrotate = <-2.826+Xrot, -Yrot, 0>

//and output it to debug so I can make sure it's working right...
#debug "Skyrotate is <"
#debug str(-2.826+Xrot,10,10) #debug ","
#debug str(-Yrot,10,10) #debug ",0>\n"


/* AND THEN CALL SUB-SCENE ELEMENTS */

#include "choskies.inc" //the multilayer sky

#include "building.inc" //the dais, altar, and all the ceremonial trappings
	//this file in turn calls
	//altar.inc, stack.inc, steps.inc, torch.inc, and urn.inc

//#include "inccho.inc" //the priest of CHO
	//assembles the various triangle meshes of the priest as well as the
	//CSG staff in his hand. Note I've commented it out: see the warning
	// in "inccho.inc" first. You can, of course, render w/o the priest
	//just the same.

