// create a crescent moon
// part of "Night Vision" by Darren Izzard

// object is CrescentMoon
// size is approx. <4,4,4> centred on origin
// best side faces towards negative Z

#include "colors.inc"

// for testing
//camera { location <0,0,-7> look_at <0,0,0>}
//light_source { <0,10,-15> color White }

#declare CrescentMoon=object {
         difference {
                    object {
                           sphere{<0,0,0>,2}
                           }
                    object {
                           sphere{<-0.5,0.5,0>,2}
                           scale <1,1,1.25>
                           pigment {color Black}    //the inside of the crescent is invisible
                           }
                    }
         bounded_by{ sphere{<0,0,0>,2.1} }
         texture {
                 pigment { bozo
                           color_map {
                                     [0.0 color White]
                                     [0.5 color Gray70]
                                     [1.0 color White]
                                     }
                         }
                 normal {
                        dents       //makes pretty good craters!
                        scale 0.125
                        }
                 finish {
                        ambient 0.3
                        }
                 }
         }

// for testing
//object {
//       CrescentMoon
//       }
