// create the town
// part of "Night Vision" by Darren Izzard

// object is Town

#include "colors.inc"
#include "textures.inc"

#ifndef (Tree)
        #include "daztree3.inc"
#end

// for testing
//camera { location <3,5,-20> look_at <0,0,0>}
//light_source { <0,10,-15> color White }

#declare TownSeed=seed(123062)  //for positioning the random houses

#declare TownSize=16    // approx. radius of town (in house-length units)

#declare BTexture=texture { //building texture
         pigment { color rgb <0.1,0,0.8> }
         }

#declare LTexture=texture { //light texture
         pigment { color rgb <0.8,0.8,0> }
         finish { ambient 1.0 }
         }

//all of these are designed for a basic 10x10 grid

#declare HouseA=object {    // a standard house
         union {
               union {
                     box { <0.5,0,0.5>,<9.5,5,4.5> }
                     polygon { 5,<0,5,0>,<3,8,2.5>,<7,8,2.5>,<10,5,0>,<0,5,0> }
                     polygon { 5,<0,5,5>,<3,8,2.5>,<7,8,2.5>,<10,5,5>,<0,5,5> }
                     polygon { 5,<0,5,0>,<0,5,5>,<10,5,5>,<10,5,0>,<0,5,0> }
                     texture {BTexture}
                     }
               union {
                     box { <2,3,0.4>,<3,4,4.6> }
                     box { <7,3,0.4>,<8,4,4.6> }
                     texture {LTexture}
                     }
               }
         }

#declare HouseB=object {    //standard house with extension
         union {
               object{HouseA}
               box {<6,0,4.5>,<9.5,5,9.5> texture {BTexture}}
               box {<5.9,3,8>,<9.6,4,9> texture {LTexture}}
               }
         }

#declare HouseC=object {    //block-type building
         union {
               box {<3,0,3>,<7,15,7> texture {BTexture}}
               union {
                     box {<5.5,7,2.9>,<6.5,8,7.1>}
                     box {<3.5,13,2.9>,<4.5,14,7.1>}
                     box {<2.9,5,5.5>,<7.1,5,6.5>}
                     box {<2.9,12,3.5>,<7.1,13,4.5>}
                     texture {LTexture}
                     }
               }
         }

#declare HouseD=object {    //building with porch and tower
         union {
               union {
                     box {<0,0,3>,<10,5,10>}
                     box {<5,0,0>,<7,3,3>}
                     box {<1,5,3>,<4,10,6>}
                     texture {BTexture}
                     }
               union {
                     box {<-0.1,3,4>,<10.1,4,5>}
                     box {<1,3,2.9>,<2,4,10.1>}
                     texture {LTexture}
                     }
               }
         }

#declare HouseE=object {    //a fractal tree
         Tree
         scale 10
         }

#declare HouseF=object {    // a taller towerblock
         union {
               object { HouseC }
               object { HouseC rotate y*90 translate <0,15,10> }
               }
         }

#declare Town=object {
    union {
         #declare TX=-TownSize
         #while (TX<=TownSize)
                #declare TZ=-TownSize
                #while (TZ<=TownSize)
                       #if (sqrt((TX*TX)+(TZ*TZ))<(3*rand(TownSeed)*TownSize))
                                object {
                                       #declare HNum=rand(TownSeed)*6
                                       #switch (floor(HNum))
                                       #case (0)
                                             HouseA
                                       #break
                                       #case (1)
                                             HouseB
                                       #break
                                       #case (2)
                                             HouseC
                                       #break
                                       #case (3)
                                             HouseD
                                       #break
                                       #case (4)
                                             HouseE
                                       #break
                                       #case (5)
                                             HouseF
                                       #break
                                       #else
                                             HouseA
                                       #end
                                       translate <TX*10,0,TZ*10>
                                       rotate y*rand(TownSeed)*360
                                       #declare Scl=1+rand(TownSeed)*0.1
                                       scale Scl
                                       translate <rand(TownSeed)*5-5,0,rand(TownSeed)*5-5>
                                       }
                       #end
                       #declare TZ=TZ+2
                #end
                #declare TX=TX+2
         #end
         }
    }

// for testing
//plane { y,0 pigment {color Blue}}
//object {
//       Town
//       scale 0.1
//       }

