// "Night Vision"
// main POV-Ray file
//   by Darren Izzard

#include "colors.inc"
#include "textures.inc"

//#declare USE_BOX_TREE=1     //if declared, drawhill.inc won't use the expensive fractal tree

#include "drawmoon.inc"
#include "drawstar.inc"
#include "drawast.inc"
#include "drawfenc.inc"
#include "drawhill.inc"
#include "drawmtns.inc"
#include "drawtown.inc"
#include "drawcase.inc"

#declare Starfield2=pigment {       //this is modified from the Jeff Burton Starfield
                                    //supplied in the standard POV-Ray "textures.inc"
        granite
        color_map {
            [ 0.00  0.7 color Black  color Black ]  // No Stars in this area
            [ 0.7  0.75 color Gray20 color Gray40 ] // Very Very Faint Stars
            [ 0.75  0.75 color Gray40 color White ] // Very Faint Stars
            [ 0.75  0.93 color White  color Black ] // White Stars
            [ 0.93  1.0 color Black  color Black ]  // No Stars in this area
        }
    scale .015
    }

sky_sphere {
           pigment { gradient y
                     pigment_map {
                                 [0.0 color rgb <0,0.25,0>]
                                 [0.35 Starfield2]
                                 [1.0 Starfield2]
                                 }
                     }
           }

plane { y,-12
         texture {
                 pigment { granite
                           color_map {
                                     [0.0 color rgb <0,0.5,0>]
                                     [0.25 color rgb <0.1,0.6,0>]
                                     [0.5 color rgb <0,0.4,0.2>]
                                     [0.75 color rgb <0,0.7,0>]
                                     [1.0 color rgb <0,0.3,0>]
                                     }
                           scale 0.1
                           }
                 normal { granite
                          scale 0.1
                          }
                 }
       }

camera {
       location <0,0,-20>
       look_at <0,0,0>
       }

#ifdef (HappyStar)
// main star
object {
       HappyStar
       scale 1.25
       rotate <-15,45,0>
       translate <8.5,6,2>
       }

// and all its friends
object { DarkStar scale 0.5 rotate <-15,-45,0> translate <-5,15,15> }

object { DarkStar scale 0.5 rotate <0,-16,5> translate <-8,11,25> }
object { DarkStar rotate <-2,5,15> translate <-22,20,30> }

object { DarkStar scale 0.5 rotate <5,190,12> translate <-15,6,25> }
object { DarkStar scale 0.5 rotate <5,190,12> translate <10,12,25> }
object { DarkStar scale 0.25 rotate <-12.3,170,5> translate <5,10,25> }
object { DarkStar scale 0.25 rotate <-12.3,170,5> translate <-18,15,25> }

//now some more small ones to break up the starfield more
#declare StarSeed=seed(8724242)
#declare SNum=0
#while (SNum<5)
       object { DarkStar scale 0.25+(0.25*rand(StarSeed))
                         rotate <(20*rand(StarSeed))-10,170+(20*rand(StarSeed)),360*rand(StarSeed)>
                         translate <(40*rand(StarSeed))-20,10+(25*rand(StarSeed)),35+(25*rand(StarSeed))>
                         }
       #declare SNum=SNum+1
#end

#end

#ifdef (CrescentMoon)
object {
       CrescentMoon
       rotate x*-25
       translate <4,15,25>
       }
#end

#ifdef (HillSide)
object {
       HillSide
       scale 4
       rotate y*12.5
       translate <-20,-12,21>
       }
#end

#ifdef (Mountains)
object {
       Mountains
       rotate -x*5
       scale 30
       translate <-90,-12,0>
       }
#end

#ifdef (Town)
object {
       Town
       scale 0.2
       rotate y*35
       rotate -x*5
       translate <22.5,-5,45>
       }
#end

#ifdef (Astronomer)
object {
       Astronomer
       scale 1.5
       rotate <0,-50,10>
       translate <-5,0,-7>
       }
#end

#ifdef (Briefcase)
object {
       Briefcase
       scale 0.6
       rotate y*30
       translate <2,-10,-0.4>
       }
#end

#ifdef (Fence)
object {
       union {
             object { Fence }
             object { Fence translate -x }
             object { Fence translate -x*2 }
             object { Fence translate -x*3 }
             object { Fence translate -x*4 }
             object { Fence translate x }
             object { Fence translate x*2 }
             object { Fence translate x*3 }
             object { Fence translate x*4 }
             box { <-5,0,.3>,<5,-1,-2>
                   texture {
                           hexagon texture { pigment{color Red}
                                             normal { gradient x
                                                      slope_map {
                                                                [0.0 <0.0,0.25>]
                                                                [1.0 <0.25,0.25>]
                                                                }
                                                      }
                                             },
                                   texture { pigment{color Brown}
                                             normal { gradient z
                                                      slope_map {
                                                                [0.0 <0.5,-0.3>]
                                                                [1.0 <0.2,-0.3>]
                                                                }
                                                      }
                                             },
                                   texture { pigment{color Orange}
                                             normal { gradient x
                                                      slope_map {
                                                                [0.0 <0.7,-0.1>]
                                                                [1.0 <0.6,-0.1>]
                                                                }
                                                      }
                                             }
                           scale 0.1
                           }
                   }
             }
       scale 8
       rotate y*15
       translate <0,-10,2>
       }
#end

// main light
light_source { <0,-3,-20>
               color White
               fade_distance 30
               fade_power 2
               }

// star's light on astronomer
light_source { <8.5,10,0>
               color Red
               fade_distance 15
               fade_power 2
               }

// mountain light
light_source { <50,50,100>
               color White
               fade_distance 75
               fade_power 1
               }

// general town/etc. light
light_source { <0,12,15>
               color Blue
               shadowless
               }

// ground fog
fog {
    distance 75
    colour rgbft <0.4,0.1,0.2,0,0.35>
    fog_type 2
    fog_offset -1
    fog_alt 1
    turbulence 0.5
    }

fog {
    distance 75
    colour rgbft <0.1,0.15,0.5,0,0.45>
    fog_type 2
    fog_offset -1
    fog_alt 5
    turbulence 0.75
    }
