
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"

#declare retro = 1

camera
{
  perspective
  #if (retro = 1)
    location <1.0, 0.001, -1.0>
    look_at <0.0, 5.0, 1.0>
  #else
    location <0.0, 2.0, -5.0>
    look_at <0.0, 2.0, 0.0>
  #end
  aperture 0.05 //0.03
  blur_samples 100 //100
  focal_point <1.4, 3.7, 0.0> //<1.3, 0.5, -0.1>
}

/*plane
{
  y, 0.0
  pigment { rgb <0.6, 0.6, 0.6> }
}*/

sky_sphere
{
    pigment
    {
      gradient y
      color_map { [0.0 color rgb <0.0, 0.0, 0.3> ] [1.0 color rgb <0.0, 0.0, 0.0> ] }
    }
    pigment
    {
      agate
      turbulence 0.1
      lambda 2.1
      color_map
      {
        [0.0 color rgbf <1.0, 1.0, 1.0, 1.0>]
        [0.5 color rgbf <1.0, 1.0, 1.0, 0.91>]
        [1.0 color rgbf <1.0, 1.0, 1.0, 1.0>]
      }
    }
}


/*******************************************************************************************************/

#declare H_Lampadaire = 4.0
#declare R_Lampadaire = 0.08
#declare R_Coude_Lampadaire = 0.7
#declare R_B_Lampadaire = 0.05
#declare R_Sphere_Lampadaire = 0.3

#declare Pied = difference
{
  box
  {
    <-R_Lampadaire, -0.1, -R_Lampadaire>
    <R_Lampadaire, H_Lampadaire, R_Lampadaire>
  }
  box
  {
    <-10.0, -0.2, -R_Lampadaire>
    <10.0, H_Lampadaire+0.1, -R_Lampadaire-1.0>
    rotate -45.0*y
  }
  box
  {
    <-10.0, -0.2, -R_Lampadaire>
    <10.0, H_Lampadaire+0.1, -R_Lampadaire-1.0>
    rotate 45.0*y
  }
  box
  {
    <-10.0, -0.2, -R_Lampadaire>
    <10.0, H_Lampadaire+0.1, -R_Lampadaire-1.0>
    rotate -135.0*y
  }
  box
  {
    <-10.0, -0.2, -R_Lampadaire>
    <10.0, H_Lampadaire+0.1, -R_Lampadaire-1.0>
    rotate 135.0*y
  }
}

#declare Coude = union
{
  difference
  {
    torus
    {
      R_Coude_Lampadaire
      R_Lampadaire
    }
    box
    {
      <-10.0, -10.0, 0.0>
      <10.0, 10.0, -10.0>
      rotate 180.0*y
    }
  }
  torus
  {
    R_Lampadaire
    R_B_Lampadaire
    rotate 90.0*x
    translate -R_Coude_Lampadaire*x
  }
  torus
  {
    R_Lampadaire
    R_B_Lampadaire
    rotate 90.0*x
    translate R_Coude_Lampadaire*x
  }
  torus
  {
    R_Lampadaire
    R_B_Lampadaire
    rotate 90.0*x
    translate -R_Coude_Lampadaire*x
    rotate -45.0*y
  }
  torus
  {
    R_Lampadaire
    R_B_Lampadaire
    rotate 90.0*x
    translate -R_Coude_Lampadaire*x
    rotate -90.0*y
  }
  torus
  {
    R_Lampadaire
    R_B_Lampadaire
    rotate 90.0*x
    translate -R_Coude_Lampadaire*x
    rotate -135.0*y
  }
  rotate 90.0*x
  translate <R_Coude_Lampadaire, H_Lampadaire, 0.0>
}

#declare Sphere = light_source
{
  <0.0, 0.0, 0.0>
  color rgb <2.0, 2.0, 2.0>
  area_light
  <-0.5, 0, -0.5> <0.5, 0, 0.5>
  4, 4
  adaptive 0
  jitter
  looks_like
  {
    sphere
    {
      <0.0, 0.0, 0.0>
      R_Sphere_Lampadaire
      texture
      {
        pigment { rgb <30.0, 30.0, 30.0> }
        finish { reflection 0.0001 diffuse 0.6 phong 0.75 phong_size 25.0 }
      }
    }
  }
}

#declare Cache = difference
{
  sphere
  {
    <0.0, 0.0, 0.0>
    R_Sphere_Lampadaire+0.001
  }
  sphere
  {
    <0.0, 0.0, 0.0>
    R_Sphere_Lampadaire-0.001
  }
  box
  {
    <-10.0, -0.1, -10.0>
    <10.0, -10.0, 10.0>
  }
  pigment { Black }
}

#declare Lumiere = union
{
  object { Sphere }
  object { Cache }
  translate <2.0*R_Coude_Lampadaire, H_Lampadaire-R_Sphere_Lampadaire>
}

#declare Lampadaire = union
{
  object { Pied texture { T_Chrome_2B normal { dents 4.0 scale 0.4 } } }
  object { Coude texture { T_Chrome_2B normal { dents 5.0 scale 0.4 } } }
  object { Lumiere }
}

/*******************************************************************************************************/

#declare R_Goutte = 0.005
#declare N_Goutte = 10000.0 //10000.0
#declare Etendue = 7.0

#declare S1 = seed(1)
#declare S2 = seed(2)
#declare S3 = seed(11)

#declare Goutte = merge
{
  sphere
  {
    <0.0, 0.0, 0.0>
    R_Goutte
  }
  cone
  {
    <0.0, 0.0, 0.0>, R_Goutte
    <0.0, 30.0*R_Goutte, 0.0>, 0
  }
  texture
  {
    pigment { rgbf <0.5, 0.5, 0.5, 1.0> }
    finish
    {
      ambient 0.0
      diffuse 0.0
      reflection 0.2
      refraction 1.0
      ior 1.33
      specular 1.0
      roughness 0.001
      fade_distance 5.0
      fade_power 1.0
      caustics 1.0
      irid
      { 0.35 thickness 0.5 turbulence 0.5 }
    }
  }
}

#declare Pluie = union
{
  #declare Count = 1
  #while (Count <= N_Goutte)
    #declare R1 = (rand(S1)-0.5)*Etendue
    #declare R2 = rand(S2)*10.0
    #declare R3 = (rand(S3)-0.5)*Etendue
    #if (R2 > H_Lampadaire-R_Sphere_Lampadaire)
      object { Goutte translate <2.0*R_Coude_Lampadaire+R1, R2, R3> }
    #else
      #if (sqrt(R1*R1+R3*R3) > 2.1*R_Sphere_Lampadaire)
        object { Goutte translate <2.0*R_Coude_Lampadaire+R1, R2, R3> }
      #end
    #end
    #declare Count = Count+1.0
  #end
}

/*******************************************************************************************************/

#declare NB_Spheres = 2.0 //50.0
#declare S1 = seed(1)
#declare S2 = seed(2)
#declare S3 = seed(10)
#declare S4 = seed(11)
#declare Count = 1

#declare MegaGoutte = blob
{
  threshold 0.9
  #while (Count <= NB_Spheres)
    #declare R1 = 1.3+0.1*(rand(S1)-0.5)
    #declare R2 = 1.0+2.0*(pow(rand(S2), 2.0)-0.3)
    #declare R3 = -0.1+0.1*(rand(S3)-0.5)
    #declare R4 = 0.2+0.1*rand(S4)*(2.4-R2)
    sphere { <R1, R2, R3>, R4, 1.0 }
    #declare Count = Count+1.0
  #end
  texture
  {
    pigment { rgbf <0.5, 0.5, 0.5, 1.0> }
    finish
    {
      ambient 0.0
      diffuse 0.0
      reflection 0.2
      refraction 1.0
      ior 1.33
      specular 1.0
      roughness 0.001
      fade_distance 5.0
      fade_power 1.0
      caustics 1.0
      irid
      { 0.35 thickness 0.5 turbulence 0.5 }
    }
  }
}

/*******************************************************************************************************/

#declare Batiment = difference
{
  union
  {
    box
    {
      <-20.0, 0.0, -10.0>
      <-40.0, 40.0, 30.0>
    }
    box
    {
      <-19.5, 39.0, -10.5>
      <-40.5, 41.0, 30.5>
    }
  }
  box
  {
    <-50.0, 25.0, 7.0>
    <-10.0, 30.0, 13.0>
  }
  box
  {
    <-50.0, 25.0, 7.0>
    <-10.0, 30.0, 13.0>
    translate 10.0*z
  }
  box
  {
    <-50.0, 25.0, 7.0>
    <-10.0, 30.0, 13.0>
    translate -10.0*z
  }
  box
  {
    <-50.0, 25.0, 7.0>
    <-10.0, 30.0, 13.0>
    translate -8.0*y
  }
  box
  {
    <-50.0, 25.0, 7.0>
    <-10.0, 30.0, 13.0>
    translate 10.0*z
    translate -8.0*y
  }
  box
  {
    <-50.0, 25.0, 7.0>
    <-10.0, 30.0, 13.0>
    translate -10.0*z
    translate -8.0*y
  }
  pigment { rgb <0.15, 0.1, 0.15> }
}

#declare Vitres = union
{
  box
  {
    <-21.0, 25.0, 7.0>
    <-21.02, 30.0, 13.0>
  }
  box
  {
    <-21.0, 25.0, 7.0>
    <-21.02, 30.0, 13.0>
    translate 10.0*z
  }
  box
  {
    <-21.0, 25.0, 7.0>
    <-21.02, 30.0, 13.0>
    translate -10.0*z
  }
  box
  {
    <-21.0, 25.0, 7.0>
    <-21.02, 30.0, 13.0>
    translate -8.0*y
  }
  box
  {
    <-21.0, 25.0, 7.0>
    <-21.02, 30.0, 13.0>
    translate 10.0*z
    translate -8.0*y
  }
  box
  {
    <-21.0, 25.0, 7.0>
    <-21.02, 30.0, 13.0>
    translate -10.0*z
    translate -8.0*y
  }
  texture
  {
    pigment { rgbt <1.0, 1.0, 1.0, 1.0> }
    finish { reflection 0.2 }
  }
}

#declare Lumiere = light_source
{
  <-25.0, 27.5, 10.0>
  color rgb <3.0, 0.5, 1.5>
}

/*******************************************************************************************************/

object { Lampadaire }
object { Pluie }
//object { MegaGoutte }
object { Batiment }
object { Vitres }
object { Lumiere }

//AREA LIGHTS
