// Persistence of Vision Raytracer
// Theme "Night" 07-08/97: L'Enfant et les sortilges
// Sizes in cm

global_settings {
   max_trace_level 6
   adc_bailout 1/255
   assumed_gamma 1.9
   }

/******************************************************************************

        Gnralits

******************************************************************************/

#declare MAIN_POV=1
#include "common.inc"
#include "decor.inc"

#declare WideLight = 1

#declare Vue_1= camera {
   perspective
   location  <200, 120, 30>
   up        y
   right     -4/3 * x
   look_at   <-200, 120, 300>
   //angle 25 //Attention: angle  la base et non sur la diagonale!
   angle 35 //57mm
}

#declare Vue_2= camera {
   perspective
   location  <200, 120, 30>
   up        y
   right     -4/3 * x
   look_at   <-200, 100, 350>
   angle 30
}

#declare Vue_3= camera {
   perspective
   location  <200, 120, 30>
   up        y
   right     -4/3 * x
   look_at   <-250, 70, 350>
   angle 24
}

#declare Lampes=union{
   object {
      light_source {
         <0, 250, 0>
         color rgb <1, 1, 1>*1
         }
      }
   object {
      light_source {
         <150, 150, -140>
         color rgb <1, .9, .8>*.6
         }
      }
   object {//Montagnes
      light_source {
         <-5000, 1000, 3000>
         color rgb <.7, .6, 1>*.7
         fade_distance 3000
         fade_power 10
         }
      }
   }

#declare C_Lampes_E=color rgb <1, .9, .8>*.4
#declare Lampes_E=union{
   object {//Montagnes
      light_source {
         <-5000, 1000, 3000>
         color rgb <.7, .6, 1>*.7
         fade_distance 3000
         fade_power 10
         }
      }
   object {//Entre
      light_source {
         <0, 250, 600>
         color C_Lampes_E
         fade_distance 300
         fade_power 2
         }
      }
   object {//Couloir
      light_source {
         <-600, 250, 0>
         color C_Lampes_E
         fade_distance 300
         fade_power 2
         }
      }
   object {//Face entre
      light_source {
         <0, 250, -600>
         color C_Lampes_E
         fade_distance 300
         fade_power 2
         area_light
         <5, 3, 0> <0, 3, 5>
         4, 4
         adaptive 0 jitter
         }
      }

   object {// Face couloir
      light_source {
         <600, 250, 0>
         color C_Lampes_E
         fade_distance 300
         fade_power 2
         area_light
         <5, 3, 0> <0, 3, 5>
         4, 4
         adaptive 0 jitter
         }
      }
   object {//Petite lampe
      light_source {
         <-450, 7, 450>
         color rgb <1, .85, .7>*.7
         fade_distance 100 //ne pas toucher...150 trop grand
         fade_power 2
         area_light
         <3, 5, 0> <0, 5, 3>
         4, 4
         adaptive 0 jitter
         //shadowless
         //looks_like {sphere {<-450, 7, 450>, 1 pigment {Yellow}}}
         }
      }
   object {//Fill-in Shahriar
      light_source {
         //<-450, 7, 450>
         <-450, 14, 450> // Slightly cheated ;-)
         color rgb <1, .85, .7>*.6
         //color White*5
         spotlight
         radius 20
         falloff 20
         tightness 1
         point_at <-310, 130, 567>
         area_light
         <3, 5, 0> <0, 5, 3>
         4, 4
         adaptive 0 jitter
         }
      }
   object {//Fill-in Doniazad
      light_source {
         <-350, 35, 300>
         //color rgb <1, .85, .7>*.7
         color rgb <1, .85, .7>*.9
         spotlight
         radius  20
         falloff 20
         tightness 1
         point_at <-210, 20, 340>
         //area_light
         //<3, 5, 0> <0, 5, 3>
         //4, 4
         //adaptive 0 jitter
         }
      }
   }

/******************************************************************************

        Scne complte

******************************************************************************/

union{
   object {Decor}
   object {#include "lampe.inc" scale 5 translate <-444, .2, 450>}
   union  {#include "sheherazad.inc" scale <-1, 1, 1>*20 rotate -70*y translate <-535, 76, 450>}
   union  {#include "doniazad.inc" scale <-1, 1, 1>*15 rotate -160*y translate <-210, -3, 340>}
   union  {#include "roi.inc" scale <-1, 1, 1>*30 rotate 40*y translate <-345, 82, 567>}

#ifdef (WideLight)
   object {Lampes_E}
   #debug "Lumieres etendues\n"
#else
   object {Lampes}
   #debug "Lumieres ponctuelles\n"
#end
rotate 0*y
}

camera {Vue_3}
