#ifndef(MAIN_POV)
#include "common.inc"
camera {
	location <1.74, 1.25, -3.60>
	look_at <-0.03, -0.29, -0.06>
}

light_source { < 0, 100, -200 > color rgb <1, 1, 1> }
light_source { < 200, 10, 0 > color rgb <0.4, 0.5, 0.4> }
light_source { < -50, 10, 200 > color rgb <0.4, 0.25, 0.25> }
#end

#declare donia_CheveuxT=texture{
      pigment {
         image_map {
            png "dchev.png"
            map_type 2 interpolate 2 once
            transmit 189 1.0
            }
         }
         normal {ripples 1 scale <.1, 5, .1> turbulence 5}
         finish {Dull}
   }


object{
//////////////////////
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7357, 1.7715, 4.0705> <-0.6017, 1.7232, 4.1902> <-0.4441, 1.6841, 4.3974> <-0.2892, 1.6106, 4.4697>
		<-0.7258, 1.7254, 4.1382> <-0.5918, 1.6771, 4.2579> <-0.4824, 1.6390, 4.3944> <-0.3275, 1.5655, 4.4667>
		<-0.5533, 1.7085, 4.2001> <-0.5006, 1.6544, 4.2416> <-0.4223, 1.5592, 4.3627> <-0.3582, 1.5111, 4.3943>
		<-0.5701, 1.6449, 4.2499> <-0.5174, 1.5909, 4.2914> <-0.4586, 1.5128, 4.3566> <-0.3945, 1.4647, 4.3883>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7357, 1.7715, 4.0705> <-0.7411, 1.7967, 4.0334> <-0.6439, 1.7953, 4.0242> <-0.6058, 1.8112, 4.0058>
		<-0.6017, 1.7232, 4.1902> <-0.6072, 1.7484, 4.1532> <-0.5028, 1.7828, 4.1450> <-0.4648, 1.7987, 4.1266>
		<-0.4441, 1.6841, 4.3974> <-0.3996, 1.7365, 4.4009> <-0.3284, 1.7819, 4.3465> <-0.2872, 1.8293, 4.3185>
		<-0.2892, 1.6106, 4.4697> <-0.2447, 1.6630, 4.4732> <-0.1768, 1.7221, 4.4365> <-0.1355, 1.7696, 4.4085>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5701, 1.6449, 4.2499> <-0.5174, 1.5909, 4.2914> <-0.4586, 1.5128, 4.3566> <-0.3945, 1.4647, 4.3883>
		<-0.5846, 1.5899, 4.2931> <-0.5320, 1.5358, 4.3346> <-0.4821, 1.4827, 4.3527> <-0.4180, 1.4346, 4.3843>
		<-0.7384, 1.5904, 4.2727> <-0.6425, 1.5355, 4.3333> <-0.5562, 1.4703, 4.4159> <-0.4521, 1.4077, 4.4495>
		<-0.7919, 1.5593, 4.2369> <-0.6959, 1.5045, 4.2975> <-0.5762, 1.4392, 4.4055> <-0.4721, 1.3765, 4.4391>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.7919, 1.5593, 4.2369> <-0.6959, 1.5045, 4.2975> <-0.5762, 1.4392, 4.4055> <-0.4721, 1.3765, 4.4391>
		<-0.8212, 1.5423, 4.2173> <-0.7252, 1.4874, 4.2779> <-0.5922, 1.4142, 4.3972> <-0.4881, 1.3515, 4.4308>
		<-0.7810, 1.5354, 4.1494> <-0.6913, 1.4784, 4.2193> <-0.5742, 1.4129, 4.3398> <-0.4735, 1.3433, 4.3745>
		<-0.7763, 1.5251, 4.1118> <-0.6866, 1.4681, 4.1818> <-0.5780, 1.4047, 4.3102> <-0.4774, 1.3351, 4.3450>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3365, 1.9421, 3.6249> <-0.2122, 1.9080, 3.6455> <-0.0472, 1.8655, 3.6990> <0.0779, 1.8287, 3.6935>
		<-0.3541, 1.9588, 3.6573> <-0.2298, 1.9248, 3.6779> <-0.1196, 1.8913, 3.7305> <0.0055, 1.8544, 3.7250>
		<-0.3848, 1.9891, 3.6946> <-0.3484, 2.0551, 3.6816> <-0.2139, 1.9308, 3.7086> <-0.1434, 1.9030, 3.7188>
		<-0.3951, 1.9979, 3.7327> <-0.3587, 2.0638, 3.7197> <-0.2339, 1.9424, 3.7884> <-0.1634, 1.9146, 3.7986>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3951, 1.9979, 3.7327> <-0.3587, 2.0638, 3.7197> <-0.2339, 1.9424, 3.7884> <-0.1634, 1.9146, 3.7986>
		<-0.4066, 2.0076, 3.7751> <-0.3701, 2.0736, 3.7621> <-0.2650, 1.9603, 3.9121> <-0.1946, 1.9325, 3.9223>
		<-0.3964, 2.0218, 3.8434> <-0.2905, 1.9926, 3.9428> <-0.1910, 1.9790, 4.0216> <-0.0721, 1.9197, 4.0871>
		<-0.4060, 2.0011, 3.8821> <-0.3000, 1.9720, 3.9815> <-0.1717, 1.9634, 4.1480> <-0.0528, 1.9040, 4.2135>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.4060, 2.0011, 3.8821> <-0.3000, 1.9720, 3.9815> <-0.1717, 1.9634, 4.1480> <-0.0528, 1.9040, 4.2135>
		<-0.4139, 1.9841, 3.9141> <-0.3079, 1.9549, 4.0135> <-0.1658, 1.9586, 4.1867> <-0.0468, 1.8992, 4.2522>
		<-0.4191, 1.9165, 3.9139> <-0.3107, 1.9031, 4.0339> <-0.1995, 1.9304, 4.2230> <-0.0693, 1.8699, 4.2985>
		<-0.4436, 1.8932, 3.9291> <-0.3352, 1.8798, 4.0491> <-0.2125, 1.9093, 4.2536> <-0.0823, 1.8487, 4.3291>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.4436, 1.8932, 3.9291> <-0.3352, 1.8798, 4.0491> <-0.2125, 1.9093, 4.2536> <-0.0823, 1.8487, 4.3291>
		<-0.4827, 1.8560, 3.9533> <-0.3744, 1.8426, 4.0733> <-0.2248, 1.8893, 4.2826> <-0.0946, 1.8288, 4.3581>
		<-0.5559, 1.8319, 3.9817> <-0.4149, 1.8195, 4.1025> <-0.2649, 1.8550, 4.3033> <-0.1132, 1.7953, 4.3933>
		<-0.6058, 1.8112, 4.0058> <-0.4648, 1.7987, 4.1266> <-0.2872, 1.8293, 4.3185> <-0.1355, 1.7696, 4.4085>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2892, 1.6106, 4.4697> <-0.2016, 1.5691, 4.5106> <-0.0806, 1.4837, 4.4388> <0.0009, 1.4221, 4.4143>
		<-0.3275, 1.5655, 4.4667> <-0.2399, 1.5240, 4.5076> <-0.1106, 1.4356, 4.4516> <-0.0291, 1.3739, 4.4271>
		<-0.3582, 1.5111, 4.3943> <-0.2661, 1.4422, 4.4397> <-0.1342, 1.3715, 4.5206> <-0.0292, 1.3108, 4.4967>
		<-0.3945, 1.4647, 4.3883> <-0.3024, 1.3957, 4.4337> <-0.1611, 1.3203, 4.5274> <-0.0561, 1.2596, 4.5036>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2892, 1.6106, 4.4697> <-0.2447, 1.6630, 4.4732> <-0.1768, 1.7221, 4.4365> <-0.1355, 1.7696, 4.4085>
		<-0.2016, 1.5691, 4.5106> <-0.1571, 1.6215, 4.5141> <-0.0922, 1.6888, 4.4867> <-0.0510, 1.7363, 4.4587>
		<-0.0806, 1.4837, 4.4388> <-0.0566, 1.5221, 4.4286> <0.0053, 1.5599, 4.4777> <0.0322, 1.5909, 4.4559>
		<0.0009, 1.4221, 4.4143> <0.0249, 1.4604, 4.4040> <0.0848, 1.4976, 4.4537> <0.1117, 1.5286, 4.4319>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3945, 1.4647, 4.3883> <-0.3024, 1.3957, 4.4337> <-0.1611, 1.3203, 4.5274> <-0.0561, 1.2596, 4.5036>
		<-0.4180, 1.4346, 4.3843> <-0.3260, 1.3656, 4.4297> <-0.1799, 1.2845, 4.5322> <-0.0749, 1.2238, 4.5084>
		<-0.4521, 1.4077, 4.4495> <-0.3533, 1.3481, 4.4814> <-0.2044, 1.2368, 4.5168> <-0.1087, 1.1768, 4.4772>
		<-0.4721, 1.3765, 4.4391> <-0.3733, 1.3170, 4.4710> <-0.2306, 1.2236, 4.4886> <-0.1348, 1.1636, 4.4490>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.4721, 1.3765, 4.4391> <-0.3733, 1.3170, 4.4710> <-0.2306, 1.2236, 4.4886> <-0.1348, 1.1636, 4.4490>
		<-0.4881, 1.3515, 4.4308> <-0.3893, 1.2920, 4.4627> <-0.2678, 1.2047, 4.4483> <-0.1721, 1.1447, 4.4087>
		<-0.4735, 1.3433, 4.3745> <-0.4045, 1.2956, 4.3984> <-0.2867, 1.2239, 4.3568> <-0.2193, 1.1707, 4.3419>
		<-0.4774, 1.3351, 4.3450> <-0.4084, 1.2874, 4.3688> <-0.3176, 1.2147, 4.3085> <-0.2502, 1.1614, 4.2937>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.4774, 1.3351, 4.3450> <-0.4084, 1.2874, 4.3688> <-0.3176, 1.2147, 4.3085> <-0.2502, 1.1614, 4.2937>
		<-0.4935, 1.3010, 4.2221> <-0.4245, 1.2533, 4.2459> <-0.3315, 1.2105, 4.2867> <-0.2641, 1.1572, 4.2718>
		<-0.5202, 1.2657, 4.0562> <-0.5063, 1.1602, 4.1151> <-0.3608, 1.2102, 4.2176> <-0.2709, 1.1326, 4.2437>
		<-0.5386, 1.2360, 3.9325> <-0.5247, 1.1305, 3.9913> <-0.3697, 1.1979, 4.1962> <-0.2798, 1.1202, 4.2223>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3875, 1.4371, 2.9418> <-0.3958, 1.4250, 2.9449> <-0.3948, 1.3995, 2.9681> <-0.3881, 1.3899, 2.9586>
		<-0.3759, 1.4974, 2.8813> <-0.3842, 1.4853, 2.8844> <-0.3428, 1.4692, 2.9520> <-0.3361, 1.4596, 2.9425>
		<-0.1948, 1.4887, 2.9828> <-0.1942, 1.4857, 2.9735> <-0.1994, 1.4699, 2.9625> <-0.1958, 1.4760, 2.9557>
		<-0.1242, 1.5234, 3.0180> <-0.1236, 1.5205, 3.0087> <-0.1258, 1.5075, 2.9937> <-0.1222, 1.5136, 2.9870>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1242, 1.5234, 3.0180> <-0.1236, 1.5205, 3.0087> <-0.1258, 1.5075, 2.9937> <-0.1222, 1.5136, 2.9870>
		<-0.0679, 1.5511, 3.0461> <-0.0673, 1.5482, 3.0368> <-0.0563, 1.5429, 3.0232> <-0.0527, 1.5490, 3.0165>
		<-0.0133, 1.6174, 3.0948> <0.0006, 1.6126, 3.0966> <0.0352, 1.5954, 3.0671> <0.0386, 1.5978, 3.0813>
		<0.0247, 1.6400, 3.1474> <0.0386, 1.6352, 3.1492> <0.0677, 1.6218, 3.1393> <0.0711, 1.6242, 3.1535>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0779, 1.8287, 3.6935> <0.1240, 1.8151, 3.6915> <0.1610, 1.7965, 3.6244> <0.2014, 1.7837, 3.6015>
		<0.0055, 1.8544, 3.7250> <0.0516, 1.8409, 3.7230> <0.1261, 1.8040, 3.6846> <0.1664, 1.7912, 3.6617>
		<-0.1434, 1.9030, 3.7188> <-0.0687, 1.8736, 3.7296> <0.0140, 1.8472, 3.7142> <0.0870, 1.8174, 3.7328>
		<-0.1634, 1.9146, 3.7986> <-0.0888, 1.8851, 3.8094> <0.0118, 1.8385, 3.7837> <0.0848, 1.8087, 3.8023>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1634, 1.9146, 3.7986> <-0.0888, 1.8851, 3.8094> <0.0118, 1.8385, 3.7837> <0.0848, 1.8087, 3.8023>
		<-0.1946, 1.9325, 3.9223> <-0.1199, 1.9031, 3.9332> <0.0078, 1.8224, 3.9109> <0.0808, 1.7926, 3.9295>
		<-0.0721, 1.9197, 4.0871> <0.0017, 1.8829, 4.1277> <0.0888, 1.7976, 4.1242> <0.1629, 1.7560, 4.0890>
		<-0.0528, 1.9040, 4.2135> <0.0210, 1.8672, 4.2542> <0.1083, 1.7491, 4.2414> <0.1824, 1.7075, 4.2062>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0528, 1.9040, 4.2135> <0.0210, 1.8672, 4.2542> <0.1083, 1.7491, 4.2414> <0.1824, 1.7075, 4.2062>
		<-0.0468, 1.8992, 4.2522> <0.0270, 1.8624, 4.2929> <0.1140, 1.7351, 4.2754> <0.1880, 1.6934, 4.2402>
		<-0.0693, 1.8699, 4.2985> <0.0142, 1.8311, 4.3468> <0.0992, 1.6816, 4.3072> <0.1735, 1.6329, 4.2532>
		<-0.0823, 1.8487, 4.3291> <0.0011, 1.8100, 4.3775> <0.0904, 1.6592, 4.3355> <0.1646, 1.6104, 4.2816>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0823, 1.8487, 4.3291> <0.0011, 1.8100, 4.3775> <0.0904, 1.6592, 4.3355> <0.1646, 1.6104, 4.2816>
		<-0.0946, 1.8288, 4.3581> <-0.0111, 1.7900, 4.4064> <0.0775, 1.6267, 4.3764> <0.1518, 1.5780, 4.3225>
		<-0.1132, 1.7953, 4.3933> <-0.0287, 1.7620, 4.4435> <0.0633, 1.6267, 4.4307> <0.1428, 1.5644, 4.4066>
		<-0.1355, 1.7696, 4.4085> <-0.0510, 1.7363, 4.4587> <0.0322, 1.5909, 4.4559> <0.1117, 1.5286, 4.4319>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2004, 1.2401, 4.3225> <0.1736, 1.2168, 4.3240> <0.1493, 1.1879, 4.2824> <0.1257, 1.1641, 4.2703>
		<0.1504, 1.2834, 4.3767> <0.1235, 1.2601, 4.3782> <0.1103, 1.2273, 4.3574> <0.0867, 1.2035, 4.3453>
		<0.0673, 1.3719, 4.3943> <0.0373, 1.3237, 4.4072> <0.0500, 1.2650, 4.4788> <0.0232, 1.2138, 4.4856>
		<0.0009, 1.4221, 4.4143> <-0.0291, 1.3739, 4.4271> <-0.0292, 1.3108, 4.4967> <-0.0561, 1.2596, 4.5036>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2004, 1.2401, 4.3225> <0.1504, 1.2834, 4.3767> <0.0673, 1.3719, 4.3943> <0.0009, 1.4221, 4.4143>
		<0.2514, 1.2844, 4.3195> <0.2014, 1.3277, 4.3737> <0.0912, 1.4102, 4.3841> <0.0249, 1.4604, 4.4040>
		<0.3508, 1.3246, 4.2980> <0.2994, 1.3686, 4.3770> <0.1645, 1.4352, 4.4296> <0.0848, 1.4976, 4.4537>
		<0.3684, 1.3748, 4.2562> <0.3169, 1.4188, 4.3353> <0.1914, 1.4661, 4.4078> <0.1117, 1.5286, 4.4319>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2004, 1.2401, 4.3225> <0.2514, 1.2844, 4.3195> <0.3508, 1.3246, 4.2980> <0.3684, 1.3748, 4.2562>
		<0.2573, 1.1908, 4.2608> <0.3083, 1.2351, 4.2578> <0.4014, 1.2814, 4.2203> <0.4190, 1.3316, 4.1785>
		<0.3266, 1.1500, 4.1443> <0.3617, 1.1942, 4.1380> <0.4116, 1.2440, 4.0792> <0.4345, 1.2803, 4.0419>
		<0.3375, 1.1307, 4.0496> <0.3726, 1.1749, 4.0432> <0.4075, 1.2201, 3.9798> <0.4304, 1.2563, 3.9425>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2004, 1.2401, 4.3225> <0.2573, 1.1908, 4.2608> <0.3266, 1.1500, 4.1443> <0.3375, 1.1307, 4.0496>
		<0.1736, 1.2168, 4.3240> <0.2305, 1.1675, 4.2624> <0.2893, 1.1029, 4.1511> <0.3001, 1.0836, 4.0564>
		<0.1493, 1.1879, 4.2824> <0.1934, 1.1434, 4.1977> <0.2486, 1.0604, 4.1109> <0.2471, 1.0280, 4.0106>
		<0.1257, 1.1641, 4.2703> <0.1698, 1.1196, 4.1856> <0.2170, 1.0179, 4.0818> <0.2155, 0.9855, 3.9815>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1257, 1.1641, 4.2703> <0.0967, 1.1350, 4.2555> <0.0594, 1.0926, 4.2362> <0.0260, 1.0645, 4.2331>
		<0.0867, 1.2035, 4.3453> <0.0577, 1.1743, 4.3305> <0.0187, 1.1235, 4.3055> <-0.0146, 1.0953, 4.3024>
		<0.0232, 1.2138, 4.4856> <0.0044, 1.1781, 4.4905> <-0.0399, 1.1337, 4.4488> <-0.0660, 1.1205, 4.4205>
		<-0.0561, 1.2596, 4.5036> <-0.0749, 1.2238, 4.5084> <-0.1087, 1.1768, 4.4772> <-0.1348, 1.1636, 4.4490>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1257, 1.1641, 4.2703> <0.1698, 1.1196, 4.1856> <0.2170, 1.0179, 4.0818> <0.2155, 0.9855, 3.9815>
		<0.0967, 1.1350, 4.2555> <0.1408, 1.0905, 4.1707> <0.2010, 0.9963, 4.0670> <0.1995, 0.9638, 3.9667>
		<0.0594, 1.0926, 4.2362> <0.1144, 1.0509, 4.1423> <0.2068, 0.9623, 4.0362> <0.2052, 0.9379, 3.9222>
		<0.0260, 1.0645, 4.2331> <0.0811, 1.0227, 4.1392> <0.1846, 0.9471, 4.0212> <0.1830, 0.9226, 3.9073>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0260, 1.0645, 4.2331> <0.0016, 1.0439, 4.2308> <-0.0414, 1.0218, 4.2729> <-0.0612, 1.0063, 4.2530>
		<-0.0146, 1.0953, 4.3024> <-0.0390, 1.0747, 4.3001> <-0.0769, 1.0589, 4.3266> <-0.0967, 1.0434, 4.3068>
		<-0.0660, 1.1205, 4.4205> <-0.1033, 1.1016, 4.3802> <-0.1618, 1.1252, 4.3292> <-0.1927, 1.1160, 4.2809>
		<-0.1348, 1.1636, 4.4490> <-0.1721, 1.1447, 4.4087> <-0.2193, 1.1707, 4.3419> <-0.2502, 1.1614, 4.2937>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0260, 1.0645, 4.2331> <0.0811, 1.0227, 4.1392> <0.1846, 0.9471, 4.0212> <0.1830, 0.9226, 3.9073>
		<0.0016, 1.0439, 4.2308> <0.0567, 1.0021, 4.1370> <0.1488, 0.9225, 3.9971> <0.1472, 0.8981, 3.8832>
		<-0.0414, 1.0218, 4.2729> <0.0202, 0.9574, 4.1798> <0.0724, 0.8907, 4.0146> <0.0770, 0.8711, 3.8874>
		<-0.0612, 1.0063, 4.2530> <0.0003, 0.9420, 4.1599> <0.0316, 0.8817, 3.9877> <0.0362, 0.8621, 3.8605>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0612, 1.0063, 4.2530> <0.0003, 0.9420, 4.1599> <0.0316, 0.8817, 3.9877> <0.0362, 0.8621, 3.8605>
		<-0.1084, 0.9695, 4.2058> <-0.0469, 0.9051, 4.1127> <0.0003, 0.8748, 3.9671> <0.0048, 0.8552, 3.8398>
		<-0.1336, 0.9337, 4.1068> <-0.0950, 0.8938, 4.0321> <-0.0375, 0.8879, 3.8771> <-0.0150, 0.8801, 3.7870>
		<-0.1663, 0.9144, 4.0407> <-0.1277, 0.8745, 3.9660> <-0.0634, 0.8810, 3.8498> <-0.0409, 0.8733, 3.7598>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0612, 1.0063, 4.2530> <-0.1084, 0.9695, 4.2058> <-0.1336, 0.9337, 4.1068> <-0.1663, 0.9144, 4.0407>
		<-0.0967, 1.0434, 4.3068> <-0.1439, 1.0066, 4.2596> <-0.1706, 0.9719, 4.1784> <-0.2033, 0.9526, 4.1123>
		<-0.1927, 1.1160, 4.2809> <-0.2067, 1.1118, 4.2591> <-0.2051, 1.0757, 4.2629> <-0.2140, 1.0633, 4.2415>
		<-0.2502, 1.1614, 4.2937> <-0.2641, 1.1572, 4.2718> <-0.2709, 1.1326, 4.2437> <-0.2798, 1.1202, 4.2223>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1663, 0.9144, 4.0407> <-0.1277, 0.8745, 3.9660> <-0.0634, 0.8810, 3.8498> <-0.0409, 0.8733, 3.7598>
		<-0.1825, 0.9048, 4.0080> <-0.1439, 0.8649, 3.9332> <-0.0845, 0.8755, 3.8276> <-0.0620, 0.8677, 3.7376>
		<-0.2053, 0.9122, 3.9617> <-0.1725, 0.8857, 3.8946> <-0.1068, 0.8081, 3.8023> <-0.0915, 0.8123, 3.7246>
		<-0.2220, 0.9112, 3.9279> <-0.1892, 0.8847, 3.8607> <-0.1278, 0.8187, 3.7818> <-0.1125, 0.8229, 3.7041>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3399, 1.2349, 3.0331> <-0.3394, 1.2335, 3.0458> <-0.3494, 1.2131, 3.0510> <-0.3535, 1.2037, 3.0587>
		<-0.3458, 1.2836, 2.9938> <-0.3453, 1.2822, 3.0065> <-0.3685, 1.2744, 3.0510> <-0.3725, 1.2651, 3.0586>
		<-0.3963, 1.3468, 2.9100> <-0.4067, 1.3563, 2.9230> <-0.4174, 1.3271, 2.9583> <-0.4259, 1.3393, 2.9704>
		<-0.3595, 1.3970, 2.9021> <-0.3698, 1.4066, 2.9151> <-0.3796, 1.3777, 2.9466> <-0.3881, 1.3899, 2.9586>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3399, 1.2349, 3.0331> <-0.3458, 1.2836, 2.9938> <-0.3963, 1.3468, 2.9100> <-0.3595, 1.3970, 2.9021>
		<-0.3416, 1.2394, 2.9927> <-0.3475, 1.2880, 2.9534> <-0.3833, 1.3346, 2.8937> <-0.3465, 1.3849, 2.8858>
		<-0.3618, 1.2310, 2.9390> <-0.3618, 1.2580, 2.9168> <-0.3500, 1.3024, 2.9001> <-0.3285, 1.3300, 2.9006>
		<-0.3599, 1.2213, 2.8994> <-0.3600, 1.2483, 2.8773> <-0.3445, 1.3020, 2.8765> <-0.3230, 1.3296, 2.8770>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3595, 1.3970, 2.9021> <-0.3050, 1.4714, 2.8904> <-0.1586, 1.5206, 2.9149> <-0.1053, 1.5552, 2.9828>
		<-0.3698, 1.4066, 2.9151> <-0.3153, 1.4810, 2.9034> <-0.1547, 1.5235, 2.9275> <-0.1014, 1.5581, 2.9954>
		<-0.3796, 1.3777, 2.9466> <-0.3276, 1.4474, 2.9305> <-0.1908, 1.4844, 2.9464> <-0.1172, 1.5220, 2.9777>
		<-0.3881, 1.3899, 2.9586> <-0.3361, 1.4596, 2.9425> <-0.1958, 1.4760, 2.9557> <-0.1222, 1.5136, 2.9870>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3595, 1.3970, 2.9021> <-0.3050, 1.4714, 2.8904> <-0.1586, 1.5206, 2.9149> <-0.1053, 1.5552, 2.9828>
		<-0.3465, 1.3849, 2.8858> <-0.2919, 1.4593, 2.8740> <-0.1679, 1.5136, 2.8847> <-0.1145, 1.5483, 2.9526>
		<-0.3285, 1.3300, 2.9006> <-0.2839, 1.3875, 2.9017> <-0.1973, 1.4690, 2.9060> <-0.1403, 1.5041, 2.9345>
		<-0.3230, 1.3296, 2.8770> <-0.2784, 1.3870, 2.8781> <-0.2046, 1.4596, 2.8760> <-0.1475, 1.4946, 2.9045>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1053, 1.5552, 2.9828> <-0.0065, 1.6192, 3.1084> <-0.0119, 1.6531, 3.3808> <0.1072, 1.6998, 3.4960>
		<-0.1014, 1.5581, 2.9954> <-0.0026, 1.6221, 3.1211> <0.0169, 1.7147, 3.4619> <0.1360, 1.7613, 3.5771>
		<-0.1172, 1.5220, 2.9777> <-0.0476, 1.5574, 3.0071> <0.0626, 1.6152, 3.1829> <0.0951, 1.6416, 3.2550>
		<-0.1222, 1.5136, 2.9870> <-0.0527, 1.5490, 3.0165> <0.0386, 1.5978, 3.0813> <0.0711, 1.6242, 3.1535>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1053, 1.5552, 2.9828> <-0.0065, 1.6192, 3.1084> <-0.0119, 1.6531, 3.3808> <0.1072, 1.6998, 3.4960>
		<-0.1014, 1.5581, 2.9954> <-0.0026, 1.6221, 3.1211> <0.0613, 1.6818, 3.4516> <0.1804, 1.7284, 3.5669>
		<-0.1172, 1.5220, 2.9777> <-0.0476, 1.5574, 3.0071> <0.0798, 1.6313, 3.1728> <0.1123, 1.6577, 3.2450>
		<-0.1222, 1.5136, 2.9870> <-0.0527, 1.5490, 3.0165> <0.0386, 1.5978, 3.0813> <0.0711, 1.6242, 3.1535>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1053, 1.5552, 2.9828> <-0.0065, 1.6192, 3.1084> <-0.0119, 1.6531, 3.3808> <0.1072, 1.6998, 3.4960>
		<-0.1145, 1.5483, 2.9526> <-0.0158, 1.6123, 3.0783> <-0.0502, 1.5712, 3.2728> <0.0689, 1.6178, 3.3880>
		<-0.1403, 1.5041, 2.9345> <-0.0826, 1.5395, 2.9633> <0.0132, 1.5628, 3.1365> <0.0572, 1.5829, 3.1920>
		<-0.1475, 1.4946, 2.9045> <-0.0898, 1.5301, 2.9333> <-0.0074, 1.5305, 3.0010> <0.0367, 1.5505, 3.0564>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2811, 1.7642, 3.5780> <0.3239, 1.7722, 3.6789> <0.3497, 1.7173, 3.8224> <0.3568, 1.7021, 3.9310>
		<0.2824, 1.7817, 3.5967> <0.3252, 1.7897, 3.6977> <0.2674, 1.7652, 3.8334> <0.2746, 1.7499, 3.9420>
		<0.2228, 1.7769, 3.5893> <0.1879, 1.7844, 3.6495> <0.1733, 1.7822, 3.7547> <0.1711, 1.7734, 3.8242>
		<0.2014, 1.7837, 3.6015> <0.1664, 1.7912, 3.6617> <0.0870, 1.8174, 3.7328> <0.0848, 1.8087, 3.8023>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2811, 1.7642, 3.5780> <0.2787, 1.7317, 3.5432> <0.1912, 1.6931, 3.5254> <0.1932, 1.6727, 3.4823>
		<0.3239, 1.7722, 3.6789> <0.3215, 1.7397, 3.6441> <0.2476, 1.6855, 3.6200> <0.2495, 1.6650, 3.5769>
		<0.3497, 1.7173, 3.8224> <0.4042, 1.6856, 3.8151> <0.3620, 1.6500, 3.7317> <0.3594, 1.6254, 3.6732>
		<0.3568, 1.7021, 3.9310> <0.4113, 1.6703, 3.9237> <0.4325, 1.6322, 3.8147> <0.4299, 1.6076, 3.7562>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3568, 1.7021, 3.9310> <0.4113, 1.6703, 3.9237> <0.4325, 1.6322, 3.8147> <0.4299, 1.6076, 3.7562>
		<0.3591, 1.6971, 3.9661> <0.4137, 1.6654, 3.9588> <0.4469, 1.6285, 3.8317> <0.4443, 1.6040, 3.7732>
		<0.3196, 1.7250, 4.0174> <0.3716, 1.7062, 3.9482> <0.4756, 1.6627, 3.8880> <0.4731, 1.6227, 3.8089>
		<0.3116, 1.6992, 4.0405> <0.3636, 1.6803, 3.9713> <0.4785, 1.6412, 3.8945> <0.4759, 1.6013, 3.8154>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3568, 1.7021, 3.9310> <0.3591, 1.6971, 3.9661> <0.3196, 1.7250, 4.0174> <0.3116, 1.6992, 4.0405>
		<0.2746, 1.7499, 3.9420> <0.2769, 1.7450, 3.9771> <0.2825, 1.7384, 4.0667> <0.2746, 1.7126, 4.0898>
		<0.1711, 1.7734, 3.8242> <0.1671, 1.7574, 3.9515> <0.2137, 1.7274, 4.0649> <0.2332, 1.6789, 4.1821>
		<0.0848, 1.8087, 3.8023> <0.0808, 1.7926, 3.9295> <0.1629, 1.7560, 4.0890> <0.1824, 1.7075, 4.2062>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3116, 1.6992, 4.0405> <0.3636, 1.6803, 3.9713> <0.4785, 1.6412, 3.8945> <0.4759, 1.6013, 3.8154>
		<0.3039, 1.6740, 4.0630> <0.3559, 1.6552, 3.9938> <0.4887, 1.5651, 3.9176> <0.4862, 1.5252, 3.8386>
		<0.3157, 1.6128, 4.0172> <0.3682, 1.5649, 3.9401> <0.4744, 1.4504, 3.9082> <0.4764, 1.4099, 3.8115>
		<0.3206, 1.5843, 4.0361> <0.3732, 1.5364, 3.9591> <0.4645, 1.3757, 3.9357> <0.4665, 1.3352, 3.8390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3116, 1.6992, 4.0405> <0.3039, 1.6740, 4.0630> <0.3157, 1.6128, 4.0172> <0.3206, 1.5843, 4.0361>
		<0.2746, 1.7126, 4.0898> <0.2669, 1.6874, 4.1123> <0.2717, 1.6528, 4.0815> <0.2767, 1.6243, 4.1005>
		<0.2332, 1.6789, 4.1821> <0.2389, 1.6649, 4.2161> <0.2361, 1.5918, 4.2077> <0.2272, 1.5694, 4.2360>
		<0.1824, 1.7075, 4.2062> <0.1880, 1.6934, 4.2402> <0.1735, 1.6329, 4.2532> <0.1646, 1.6104, 4.2816>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3206, 1.5843, 4.0361> <0.3339, 1.5083, 4.0867> <0.3923, 1.4433, 4.1992> <0.3684, 1.3748, 4.2562>
		<0.2767, 1.6243, 4.1005> <0.2900, 1.5483, 4.1511> <0.3408, 1.4873, 4.2783> <0.3169, 1.4188, 4.3353>
		<0.2272, 1.5694, 4.2360> <0.2144, 1.5369, 4.2769> <0.2225, 1.5019, 4.3826> <0.1914, 1.4661, 4.4078>
		<0.1646, 1.6104, 4.2816> <0.1518, 1.5780, 4.3225> <0.1428, 1.5644, 4.4066> <0.1117, 1.5286, 4.4319>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3206, 1.5843, 4.0361> <0.3732, 1.5364, 3.9591> <0.4645, 1.3757, 3.9357> <0.4665, 1.3352, 3.8390>
		<0.3339, 1.5083, 4.0867> <0.3865, 1.4603, 4.0096> <0.4595, 1.3380, 3.9496> <0.4615, 1.2975, 3.8529>
		<0.3923, 1.4433, 4.1992> <0.4429, 1.4001, 4.1215> <0.4508, 1.3061, 4.0153> <0.4467, 1.2822, 3.9159>
		<0.3684, 1.3748, 4.2562> <0.4190, 1.3316, 4.1785> <0.4345, 1.2803, 4.0419> <0.4304, 1.2563, 3.9425>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3375, 1.1307, 4.0496> <0.3726, 1.1749, 4.0432> <0.4075, 1.2201, 3.9798> <0.4304, 1.2563, 3.9425>
		<0.3622, 1.0867, 3.8341> <0.3973, 1.1310, 3.8278> <0.3999, 1.1760, 3.7966> <0.4227, 1.2122, 3.7593>
		<0.3203, 1.1617, 3.5002> <0.3418, 1.1897, 3.4975> <0.3282, 1.2079, 3.5124> <0.3315, 1.2399, 3.4976>
		<0.3155, 1.0355, 3.3186> <0.3371, 1.0634, 3.3159> <0.3265, 1.1199, 3.3456> <0.3299, 1.1519, 3.3309>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3375, 1.1307, 4.0496> <0.3622, 1.0867, 3.8341> <0.3203, 1.1617, 3.5002> <0.3155, 1.0355, 3.3186>
		<0.3001, 1.0836, 4.0564> <0.3248, 1.0397, 3.8409> <0.2717, 1.0987, 3.5062> <0.2670, 0.9724, 3.3246>
		<0.2471, 1.0280, 4.0106> <0.2443, 0.9687, 3.8271> <0.1934, 0.9921, 3.5298> <0.1818, 0.9075, 3.3570>
		<0.2155, 0.9855, 3.9815> <0.2128, 0.9261, 3.7981> <0.1235, 0.9537, 3.5308> <0.1119, 0.8690, 3.3579>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2155, 0.9855, 3.9815> <0.2128, 0.9261, 3.7981> <0.1235, 0.9537, 3.5308> <0.1119, 0.8690, 3.3579>
		<0.1995, 0.9638, 3.9667> <0.1967, 0.9045, 3.7833> <0.0960, 0.9385, 3.5312> <0.0844, 0.8539, 3.3583>
		<0.2052, 0.9379, 3.9222> <0.2027, 0.8994, 3.7430> <0.0622, 0.9104, 3.5049> <0.0444, 0.8698, 3.3271>
		<0.1830, 0.9226, 3.9073> <0.1805, 0.8842, 3.7281> <0.0311, 0.9097, 3.5006> <0.0133, 0.8691, 3.3227>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1830, 0.9226, 3.9073> <0.1805, 0.8842, 3.7281> <0.0311, 0.9097, 3.5006> <0.0133, 0.8691, 3.3227>
		<0.1472, 0.8981, 3.8832> <0.1447, 0.8596, 3.7039> <0.0178, 0.9094, 3.4988> <0.0000, 0.8688, 3.3209>
		<0.0770, 0.8711, 3.8874> <0.0826, 0.8472, 3.7315> <-0.0203, 0.9007, 3.4994> <-0.0295, 0.8781, 3.3435>
		<0.0362, 0.8621, 3.8605> <0.0418, 0.8382, 3.7046> <-0.0191, 0.8884, 3.4944> <-0.0283, 0.8657, 3.3385>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0362, 0.8621, 3.8605> <0.0418, 0.8382, 3.7046> <-0.0191, 0.8884, 3.4944> <-0.0283, 0.8657, 3.3385>
		<0.0048, 0.8552, 3.8398> <0.0104, 0.8313, 3.6840> <-0.0178, 0.8743, 3.4886> <-0.0270, 0.8516, 3.3327>
		<-0.0150, 0.8801, 3.7870> <0.0175, 0.8688, 3.6570> <0.0319, 0.8555, 3.4582> <0.0225, 0.8419, 3.3247>
		<-0.0409, 0.8733, 3.7598> <-0.0084, 0.8620, 3.6298> <0.0244, 0.8652, 3.4490> <0.0150, 0.8516, 3.3156>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0409, 0.8733, 3.7598> <-0.0084, 0.8620, 3.6298> <0.0244, 0.8652, 3.4490> <0.0150, 0.8516, 3.3156>
		<-0.0620, 0.8677, 3.7376> <-0.0295, 0.8564, 3.6076> <0.0020, 0.8941, 3.4219> <-0.0074, 0.8805, 3.2884>
		<-0.0915, 0.8123, 3.7246> <-0.0650, 0.8194, 3.5896> <-0.0624, 0.9412, 3.4294> <-0.0585, 0.9339, 3.2919>
		<-0.1125, 0.8229, 3.7041> <-0.0859, 0.8300, 3.5692> <-0.0949, 0.9539, 3.4000> <-0.0910, 0.9466, 3.2626>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1125, 0.8229, 3.7041> <-0.0859, 0.8300, 3.5692> <-0.0949, 0.9539, 3.4000> <-0.0910, 0.9466, 3.2626>
		<-0.1587, 0.8462, 3.6592> <-0.1321, 0.8533, 3.5243> <-0.1197, 0.9635, 3.3777> <-0.1158, 0.9562, 3.2402>
		<-0.2093, 0.9464, 3.6358> <-0.1607, 0.8400, 3.6818> <-0.1378, 0.9284, 3.3201> <-0.1316, 0.9077, 3.1963>
		<-0.2308, 0.9692, 3.5749> <-0.1822, 0.8627, 3.6209> <-0.1554, 0.9362, 3.2912> <-0.1492, 0.9154, 3.1673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3222, 1.0443, 3.1110> <-0.3370, 1.0731, 3.0340> <-0.3598, 1.1567, 2.9524> <-0.3599, 1.2213, 2.8994>
		<-0.3362, 1.0471, 3.0127> <-0.3510, 1.0758, 2.9357> <-0.3569, 1.1413, 2.8894> <-0.3571, 1.2059, 2.8364>
		<-0.3693, 1.0551, 2.8826> <-0.3762, 1.0727, 2.8456> <-0.3283, 1.1252, 2.7715> <-0.3215, 1.1649, 2.7609>
		<-0.3689, 1.0535, 2.7833> <-0.3758, 1.0711, 2.7463> <-0.3314, 1.1130, 2.7078> <-0.3246, 1.1527, 2.6972>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3599, 1.2213, 2.8994> <-0.3600, 1.2483, 2.8773> <-0.3445, 1.3020, 2.8765> <-0.3230, 1.3296, 2.8770>
		<-0.3571, 1.2059, 2.8364> <-0.3571, 1.2329, 2.8142> <-0.3312, 1.3009, 2.8194> <-0.3097, 1.3285, 2.8199>
		<-0.3215, 1.1649, 2.7609> <-0.3097, 1.2337, 2.7425> <-0.3465, 1.3231, 2.7493> <-0.3151, 1.3881, 2.7508>
		<-0.3246, 1.1527, 2.6972> <-0.3128, 1.2215, 2.6788> <-0.3421, 1.3280, 2.6910> <-0.3107, 1.3930, 2.6926>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3230, 1.3296, 2.8770> <-0.2784, 1.3870, 2.8781> <-0.2046, 1.4596, 2.8760> <-0.1475, 1.4946, 2.9045>
		<-0.3097, 1.3285, 2.8199> <-0.2651, 1.3859, 2.8210> <-0.2183, 1.4417, 2.8194> <-0.1612, 1.4768, 2.8478>
		<-0.3151, 1.3881, 2.7508> <-0.2945, 1.4307, 2.7518> <-0.2110, 1.4669, 2.7628> <-0.1670, 1.4841, 2.7630>
		<-0.3107, 1.3930, 2.6926> <-0.2902, 1.4355, 2.6936> <-0.2166, 1.4504, 2.7043> <-0.1726, 1.4675, 2.7045>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1475, 1.4946, 2.9045> <-0.0898, 1.5301, 2.9333> <-0.0074, 1.5305, 3.0010> <0.0367, 1.5505, 3.0564>
		<-0.1612, 1.4768, 2.8478> <-0.1036, 1.5122, 2.8766> <-0.0235, 1.5052, 2.8946> <0.0205, 1.5252, 2.9500>
		<-0.1670, 1.4841, 2.7630> <-0.1213, 1.5019, 2.7632> <-0.0398, 1.5005, 2.7766> <0.0014, 1.5031, 2.8032>
		<-0.1726, 1.4675, 2.7045> <-0.1269, 1.4854, 2.7048> <-0.0557, 1.5060, 2.6674> <-0.0146, 1.5085, 2.6940>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0367, 1.5505, 3.0564> <0.1013, 1.5799, 3.1378> <0.1597, 1.6363, 3.2603> <0.2096, 1.6570, 3.3539>
		<0.0205, 1.5252, 2.9500> <0.0852, 1.5546, 3.0314> <0.1208, 1.5841, 3.1145> <0.1707, 1.6048, 3.2081>
		<0.0014, 1.5031, 2.8032> <0.0516, 1.5062, 2.8357> <0.0169, 1.5183, 2.9659> <0.0458, 1.5259, 3.0179>
		<-0.0146, 1.5085, 2.6940> <0.0357, 1.5116, 2.7265> <0.0512, 1.4755, 2.8161> <0.0801, 1.4831, 2.8680>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2096, 1.6570, 3.3539> <0.2216, 1.6619, 3.3764> <0.2405, 1.6306, 3.4070> <0.2372, 1.6337, 3.4325>
		<0.1707, 1.6048, 3.2081> <0.1827, 1.6098, 3.2306> <0.2525, 1.6162, 3.3428> <0.2493, 1.6193, 3.3684>
		<0.0458, 1.5259, 3.0179> <0.1059, 1.5418, 3.1259> <0.2161, 1.5755, 3.1731> <0.2694, 1.6122, 3.2796>
		<0.0801, 1.4831, 2.8680> <0.1402, 1.4990, 2.9760> <0.2241, 1.5491, 3.1123> <0.2774, 1.5857, 3.2188>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2372, 1.6337, 3.4325> <0.2343, 1.6365, 3.4553> <0.1813, 1.6742, 3.4625> <0.1932, 1.6727, 3.4823>
		<0.2493, 1.6193, 3.3684> <0.2464, 1.6221, 3.3912> <0.1839, 1.6464, 3.4037> <0.1957, 1.6448, 3.4236>
		<0.2694, 1.6122, 3.2796> <0.2809, 1.6201, 3.3025> <0.2837, 1.6861, 3.3607> <0.2888, 1.6614, 3.3516>
		<0.2774, 1.5857, 3.2188> <0.2889, 1.5936, 3.2417> <0.2885, 1.6546, 3.3039> <0.2936, 1.6299, 3.2948>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1932, 1.6727, 3.4823> <0.1957, 1.6448, 3.4236> <0.2888, 1.6614, 3.3516> <0.2936, 1.6299, 3.2948>
		<0.2495, 1.6650, 3.5769> <0.2521, 1.6372, 3.5181> <0.3061, 1.5773, 3.3207> <0.3109, 1.5458, 3.2639>
		<0.3594, 1.6254, 3.6732> <0.3512, 1.5478, 3.4881> <0.3490, 1.5418, 3.3379> <0.3238, 1.4596, 3.1563>
		<0.4299, 1.6076, 3.7562> <0.4217, 1.5300, 3.5711> <0.3469, 1.4521, 3.3211> <0.3217, 1.3700, 3.1395>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.4299, 1.6076, 3.7562> <0.4217, 1.5300, 3.5711> <0.3469, 1.4521, 3.3211> <0.3217, 1.3700, 3.1395>
		<0.4443, 1.6040, 3.7732> <0.4361, 1.5263, 3.5881> <0.3460, 1.4148, 3.3141> <0.3209, 1.3327, 3.1325>
		<0.4731, 1.6227, 3.8089> <0.4671, 1.5297, 3.6246> <0.3104, 1.4221, 3.3890> <0.2818, 1.3221, 3.2105>
		<0.4759, 1.6013, 3.8154> <0.4700, 1.5082, 3.6311> <0.3143, 1.3905, 3.4097> <0.2857, 1.2905, 3.2312>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.4759, 1.6013, 3.8154> <0.4700, 1.5082, 3.6311> <0.3143, 1.3905, 3.4097> <0.2857, 1.2905, 3.2312>
		<0.4862, 1.5252, 3.8386> <0.4802, 1.4321, 3.6542> <0.3165, 1.3728, 3.4213> <0.2878, 1.2729, 3.2428>
		<0.4764, 1.4099, 3.8115> <0.4800, 1.3361, 3.6355> <0.3450, 1.3597, 3.3730> <0.3321, 1.2598, 3.2108>
		<0.4665, 1.3352, 3.8390> <0.4701, 1.2614, 3.6630> <0.3503, 1.3430, 3.3849> <0.3374, 1.2432, 3.2227>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.4665, 1.3352, 3.8390> <0.4701, 1.2614, 3.6630> <0.3503, 1.3430, 3.3849> <0.3374, 1.2432, 3.2227>
		<0.4615, 1.2975, 3.8529> <0.4652, 1.2237, 3.6769> <0.3610, 1.3096, 3.4090> <0.3481, 1.2098, 3.2468>
		<0.4467, 1.2822, 3.9159> <0.4391, 1.2381, 3.7327> <0.3356, 1.2783, 3.4799> <0.3339, 1.1904, 3.3132>
		<0.4304, 1.2563, 3.9425> <0.4227, 1.2122, 3.7593> <0.3315, 1.2399, 3.4976> <0.3299, 1.1519, 3.3309>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3069, 0.3147, 2.8763> <0.3095, 0.5310, 3.0090> <0.3101, 0.8906, 3.1103> <0.3155, 1.0355, 3.3186>
		<0.3928, 0.3845, 2.8630> <0.3954, 0.6008, 2.9957> <0.3317, 0.9186, 3.1076> <0.3371, 1.0634, 3.3159>
		<0.4029, 0.5970, 2.9079> <0.3761, 0.7433, 3.0609> <0.3247, 1.0204, 3.1569> <0.3265, 1.1199, 3.3456>
		<0.4195, 0.6645, 2.8207> <0.3926, 0.8107, 2.9737> <0.3281, 1.0524, 3.1421> <0.3299, 1.1519, 3.3309>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3069, 0.3147, 2.8763> <0.2590, 0.2758, 2.8837> <0.1747, 0.3878, 2.8778> <0.1408, 0.4380, 2.8637>
		<0.3095, 0.5310, 3.0090> <0.2616, 0.4920, 3.0163> <0.1661, 0.5172, 3.0260> <0.1321, 0.5673, 3.0119>
		<0.3101, 0.8906, 3.1103> <0.2616, 0.8276, 3.1163> <0.1700, 0.8210, 3.1804> <0.1001, 0.7826, 3.1814>
		<0.3155, 1.0355, 3.3186> <0.2670, 0.9724, 3.3246> <0.1818, 0.9075, 3.3570> <0.1119, 0.8690, 3.3579>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1408, 0.4380, 2.8637> <0.0994, 0.4991, 2.8465> <0.1091, 0.6026, 2.7965> <0.0700, 0.6648, 2.7778>
		<0.1321, 0.5673, 3.0119> <0.0908, 0.6284, 2.9948> <0.0921, 0.6639, 2.9600> <0.0530, 0.7261, 2.9413>
		<0.1001, 0.7826, 3.1814> <0.0726, 0.7674, 3.1818> <0.0274, 0.8310, 3.1569> <-0.0037, 0.8302, 3.1525>
		<0.1119, 0.8690, 3.3579> <0.0844, 0.8539, 3.3583> <0.0444, 0.8698, 3.3271> <0.0133, 0.8691, 3.3227>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0700, 0.6648, 2.7778> <0.0536, 0.6909, 2.7700> <-0.0032, 0.6936, 2.7994> <-0.0275, 0.7059, 2.7831>
		<0.0530, 0.7261, 2.9413> <0.0366, 0.7522, 2.9335> <-0.0034, 0.7415, 2.9660> <-0.0278, 0.7539, 2.9497>
		<-0.0037, 0.8302, 3.1525> <-0.0170, 0.8299, 3.1507> <-0.0397, 0.8533, 3.1722> <-0.0385, 0.8409, 3.1672>
		<0.0133, 0.8691, 3.3227> <0.0000, 0.8688, 3.3209> <-0.0295, 0.8781, 3.3435> <-0.0283, 0.8657, 3.3385>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0275, 0.7059, 2.7831> <-0.0665, 0.7256, 2.7570> <-0.1058, 0.7463, 2.6981> <-0.1190, 0.7605, 2.6510>
		<-0.0278, 0.7539, 2.9497> <-0.0668, 0.7736, 2.9236> <-0.0656, 0.7736, 2.8974> <-0.0788, 0.7878, 2.8504>
		<-0.0385, 0.8409, 3.1672> <-0.0371, 0.8268, 3.1614> <0.0081, 0.8212, 3.1210> <0.0006, 0.8309, 3.1119>
		<-0.0283, 0.8657, 3.3385> <-0.0270, 0.8516, 3.3327> <0.0225, 0.8419, 3.3247> <0.0150, 0.8516, 3.3156>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1190, 0.7605, 2.6510> <-0.1245, 0.7664, 2.6316> <-0.0653, 0.7504, 2.5892> <-0.0812, 0.7637, 2.5922>
		<-0.0788, 0.7878, 2.8504> <-0.0843, 0.7937, 2.8310> <-0.0682, 0.8052, 2.7903> <-0.0841, 0.8186, 2.7933>
		<0.0006, 0.8309, 3.1119> <-0.0218, 0.8598, 3.0848> <-0.0527, 0.9229, 3.0838> <-0.0851, 0.9355, 3.0545>
		<0.0150, 0.8516, 3.3156> <-0.0074, 0.8805, 3.2884> <-0.0585, 0.9339, 3.2919> <-0.0910, 0.9466, 3.2626>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0812, 0.7637, 2.5922> <-0.1124, 0.7900, 2.5981> <-0.1558, 0.7885, 2.6620> <-0.1858, 0.8166, 2.6636>
		<-0.0841, 0.8186, 2.7933> <-0.1153, 0.8448, 2.7992> <-0.1448, 0.8181, 2.8131> <-0.1748, 0.8463, 2.8147>
		<-0.0851, 0.9355, 3.0545> <-0.1099, 0.9451, 3.0321> <-0.1241, 0.8822, 3.0442> <-0.1417, 0.8900, 3.0152>
		<-0.0910, 0.9466, 3.2626> <-0.1158, 0.9562, 3.2402> <-0.1316, 0.9077, 3.1963> <-0.1492, 0.9154, 3.1673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1858, 0.8166, 2.6636> <-0.2242, 0.8528, 2.6657> <-0.2556, 0.9101, 2.6232> <-0.2811, 0.9517, 2.6031>
		<-0.1748, 0.8463, 2.8147> <-0.2133, 0.8824, 2.8168> <-0.2539, 0.9330, 2.7299> <-0.2795, 0.9746, 2.7098>
		<-0.1417, 0.8900, 3.0152> <-0.1825, 0.9080, 2.9482> <-0.2224, 0.9517, 2.9310> <-0.2605, 0.9757, 2.8643>
		<-0.1492, 0.9154, 3.1673> <-0.1900, 0.9335, 3.1002> <-0.2374, 1.0041, 3.0257> <-0.2756, 1.0281, 2.9589>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2811, 0.9517, 2.6031> <-0.2961, 0.9761, 2.5913> <-0.3071, 1.0089, 2.5664> <-0.3199, 1.0357, 2.5579>
		<-0.2795, 0.9746, 2.7098> <-0.2944, 0.9990, 2.6981> <-0.3218, 1.0143, 2.6340> <-0.3346, 1.0411, 2.6256>
		<-0.2605, 0.9757, 2.8643> <-0.2890, 0.9937, 2.8145> <-0.3586, 1.0269, 2.7675> <-0.3686, 1.0524, 2.7139>
		<-0.2756, 1.0281, 2.9589> <-0.3041, 1.0460, 2.9091> <-0.3589, 1.0280, 2.8369> <-0.3689, 1.0535, 2.7833>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3199, 1.0357, 2.5579> <-0.3346, 1.0411, 2.6256> <-0.3686, 1.0524, 2.7139> <-0.3689, 1.0535, 2.7833>
		<-0.3363, 1.0699, 2.5471> <-0.3510, 1.0752, 2.6147> <-0.3755, 1.0700, 2.6769> <-0.3758, 1.0711, 2.7463>
		<-0.3803, 1.1134, 2.5448> <-0.3644, 1.1135, 2.5920> <-0.3337, 1.1037, 2.6589> <-0.3314, 1.1130, 2.7078>
		<-0.3774, 1.1524, 2.5396> <-0.3616, 1.1525, 2.5869> <-0.3269, 1.1433, 2.6483> <-0.3246, 1.1527, 2.6972>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3774, 1.1524, 2.5396> <-0.3616, 1.1525, 2.5869> <-0.3269, 1.1433, 2.6483> <-0.3246, 1.1527, 2.6972>
		<-0.3725, 1.2188, 2.5307> <-0.3566, 1.2189, 2.5780> <-0.3151, 1.2121, 2.6299> <-0.3128, 1.2215, 2.6788>
		<-0.3313, 1.3239, 2.5594> <-0.3357, 1.3338, 2.6127> <-0.3381, 1.3325, 2.6370> <-0.3421, 1.3280, 2.6910>
		<-0.2960, 1.3597, 2.5149> <-0.3004, 1.3697, 2.5682> <-0.3067, 1.3975, 2.6385> <-0.3107, 1.3930, 2.6926>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2960, 1.3597, 2.5149> <-0.3004, 1.3697, 2.5682> <-0.3067, 1.3975, 2.6385> <-0.3107, 1.3930, 2.6926>
		<-0.2616, 1.3945, 2.4715> <-0.2660, 1.4045, 2.5248> <-0.2862, 1.4400, 2.6395> <-0.2902, 1.4355, 2.6936>
		<-0.2485, 1.2864, 2.3407> <-0.2393, 1.3280, 2.4561> <-0.2278, 1.4169, 2.5865> <-0.2166, 1.4504, 2.7043>
		<-0.2033, 1.3289, 2.3200> <-0.1941, 1.3705, 2.4353> <-0.1838, 1.4341, 2.5867> <-0.1726, 1.4675, 2.7045>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2033, 1.3289, 2.3200> <-0.1941, 1.3705, 2.4353> <-0.1838, 1.4341, 2.5867> <-0.1726, 1.4675, 2.7045>
		<-0.1400, 1.3883, 2.2910> <-0.1308, 1.4299, 2.4063> <-0.1381, 1.4519, 2.5869> <-0.1269, 1.4854, 2.7048>
		<-0.1484, 1.5745, 2.3926> <-0.1353, 1.5522, 2.4790> <-0.0687, 1.5104, 2.5782> <-0.0557, 1.5060, 2.6674>
		<-0.0583, 1.5830, 2.4059> <-0.0451, 1.5607, 2.4923> <-0.0276, 1.5130, 2.6048> <-0.0146, 1.5085, 2.6940>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0583, 1.5830, 2.4059> <-0.0451, 1.5607, 2.4923> <-0.0276, 1.5130, 2.6048> <-0.0146, 1.5085, 2.6940>
		<0.0958, 1.5975, 2.4286> <0.1089, 1.5751, 2.5150> <0.0227, 1.5161, 2.6373> <0.0357, 1.5116, 2.7265>
		<0.3103, 1.4735, 2.3496> <0.2069, 1.5020, 2.4862> <0.0885, 1.4288, 2.6529> <0.0512, 1.4755, 2.8161>
		<0.4250, 1.3879, 2.4127> <0.3216, 1.4165, 2.5493> <0.1174, 1.4365, 2.7049> <0.0801, 1.4831, 2.8680>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.4250, 1.3879, 2.4127> <0.3216, 1.4165, 2.5493> <0.1174, 1.4365, 2.7049> <0.0801, 1.4831, 2.8680>
		<0.4804, 1.3466, 2.4432> <0.3769, 1.3751, 2.5798> <0.1775, 1.4523, 2.8129> <0.1402, 1.4990, 2.9760>
		<0.3790, 1.3209, 2.5717> <0.3593, 1.4116, 2.7493> <0.2481, 1.4698, 2.9298> <0.2241, 1.5491, 3.1123>
		<0.3432, 1.2835, 2.6266> <0.3235, 1.3742, 2.8043> <0.3014, 1.5064, 3.0363> <0.2774, 1.5857, 3.2188>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3432, 1.2835, 2.6266> <0.3235, 1.3742, 2.8043> <0.3014, 1.5064, 3.0363> <0.2774, 1.5857, 3.2188>
		<0.3276, 1.2673, 2.6505> <0.3079, 1.3579, 2.8281> <0.3129, 1.5143, 3.0592> <0.2889, 1.5936, 3.2417>
		<0.2738, 1.2487, 2.6675> <0.2831, 1.3722, 2.8574> <0.3053, 1.5451, 3.1061> <0.2885, 1.6546, 3.3039>
		<0.2627, 1.2184, 2.6617> <0.2720, 1.3419, 2.8516> <0.3104, 1.5204, 3.0970> <0.2936, 1.6299, 3.2948>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2627, 1.2184, 2.6617> <0.2720, 1.3419, 2.8516> <0.3104, 1.5204, 3.0970> <0.2936, 1.6299, 3.2948>
		<0.2467, 1.1746, 2.6534> <0.2559, 1.2981, 2.8433> <0.3277, 1.4364, 3.0661> <0.3109, 1.5458, 3.2639>
		<0.2610, 1.1247, 2.5769> <0.2771, 1.2120, 2.7425> <0.3003, 1.3828, 2.9865> <0.3238, 1.4596, 3.1563>
		<0.2682, 1.0791, 2.5875> <0.2843, 1.1664, 2.7531> <0.2982, 1.2932, 2.9697> <0.3217, 1.3700, 3.1395>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2682, 1.0791, 2.5875> <0.2843, 1.1664, 2.7531> <0.2982, 1.2932, 2.9697> <0.3217, 1.3700, 3.1395>
		<0.2755, 1.0324, 2.5984> <0.2916, 1.1196, 2.7640> <0.2974, 1.2559, 2.9627> <0.3209, 1.3327, 3.1325>
		<0.2905, 1.0335, 2.7177> <0.2864, 1.1249, 2.8723> <0.2568, 1.2352, 3.0553> <0.2818, 1.3221, 3.2105>
		<0.2993, 0.9858, 2.7160> <0.2952, 1.0772, 2.8705> <0.2607, 1.2036, 3.0760> <0.2857, 1.2905, 3.2312>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2993, 0.9858, 2.7160> <0.2952, 1.0772, 2.8705> <0.2607, 1.2036, 3.0760> <0.2857, 1.2905, 3.2312>
		<0.3244, 0.8495, 2.7109> <0.3204, 0.9410, 2.8655> <0.2629, 1.1860, 3.0876> <0.2878, 1.2729, 3.2428>
		<0.3189, 0.6772, 2.5276> <0.3105, 0.8843, 2.7240> <0.3128, 1.1105, 2.9682> <0.3321, 1.2598, 3.2108>
		<0.3654, 0.5530, 2.5680> <0.3570, 0.7601, 2.7644> <0.3181, 1.0939, 2.9801> <0.3374, 1.2432, 3.2227>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3654, 0.5530, 2.5680> <0.3570, 0.7601, 2.7644> <0.3181, 1.0939, 2.9801> <0.3374, 1.2432, 3.2227>
		<0.3937, 0.4774, 2.5927> <0.3853, 0.6845, 2.7891> <0.3288, 1.0605, 3.0042> <0.3481, 1.2098, 3.2468>
		<0.4320, 0.7155, 2.7546> <0.4051, 0.8618, 2.9077> <0.3321, 1.0908, 3.1244> <0.3339, 1.1904, 3.3132>
		<0.4195, 0.6645, 2.8207> <0.3926, 0.8107, 2.9737> <0.3281, 1.0524, 3.1421> <0.3299, 1.1519, 3.3309>
	}
/////////////////////////////////////////////
  }
   texture{
      material_map {
            png "dchev_m.png"
            map_type 2 once
            texture {pigment {Clear}}
            texture{donia_CheveuxT}
            }
   translate -.4*y rotate 180*y rotate 70*x scale 2.5 translate <0, 1.3, 3.4>
   }
    //no_shadow
translate <-.5, .5, 0>
scale 1
}
