// Persistence of Vision Raytracer
// Dcor!

#ifndef (MAIN_POV)
#include "common.inc"
#end

//#declare FAST_TEXTURES=1
#include "plateau.inc"
#include "saladier.inc"
#include "aiguiere.inc"

/******************************************************************************
   A faire:
******************************************************************************/



/******************************************************************************

        textures

******************************************************************************/

#ifdef(FAST_TEXTURES)
   #declare Grille_T=
       texture { pigment { P_WoodGrain4A color_map { M_Wood8A }} rotate 1*z}
       texture {
          pigment { P_WoodGrain4B color_map { M_Wood8B }}
          normal {wood turbulence <0.04, 0.04, 1> octaves 4
             scale <0.05, 0.05, 1> * 0.66 bump_size .1}
          finish {specular 1 roughness 0.0001 reflection 0.05}
          finish {specular 1 roughness 0.001 reflection 0.05}
          rotate 1*z
          }
#else
   #declare Grille_T=texture{
      pigment {DarkBrown}
      }
#end
#declare Platre_T=texture{
   pigment{White}
   normal{bumps scale 50}
   //normal{crackle}
   //finish{Dull}
   }

#declare Pierres_T=texture{
   pigment {Clear}
   finish {phong 0.1 phong_size 90 crand 0.1}
   }

/******************************************************************************

        objets

******************************************************************************/

//////////////////////////////////////////////////////////////////////// COUSSIN
#declare Coussin=object{
      union{
         intersection{
            superellipsoid {<.7, .4> scale <.5, .4, .2>}
            box {<-1, -1, .1><1, 1, 1>}
            translate -.1*z
            }
         intersection{
            superellipsoid {<.7, .4> scale <.5, .4, .2>}
            box {<-1, -1, -.1><1, 1, -1>}
            translate .1*z
            }
         }
   #ifndef(FAST_TEXTURES)
      pigment {
         image_map {
            png "itiera_4.png"
            map_type 0 //plan
            interpolate 2
            //once
            }
         translate -.5
         rotate 90*z
         scale <.9, .8, 1>*1.2
         }
      #else
         pigment {rgb <1, .95, .9>*.8}
      #end
      bounded_by{box{<-.5, -.4, -.1>, <.5, .4, .1>}}
      scale 40
   }
//////////////////////////////////////////////////////////////////////// TAPIS
#declare Tapis=object{
   box {-.5, .5}
   #ifndef(FAST_TEXTURES)
      pigment {
         image_map {
            png "data/talish.png"
            map_type 0 //plan
            interpolate 2
            transmit 95, 1.0
            once
            }
         translate -.5
         }
      #else
         pigment {Green}
      #end
   scale <330, 581, 1> /3
   rotate 90*x
   no_shadow
   }
//////////////////////////////////////////////////////////////////////// FONTAINE

#declare Fontaine1=object{
   union{
      torus{145, 5 translate 70*y}
      difference{
         cylinder {-10*y, 70*y, 150}
         cylinder {10*y, 80*y, 140}
         }
      }
   pigment {White}
   }

#declare Fontaine2=object{
   difference{
      cylinder {-10*y, 70*y, 145}
      sphere{0, 1 scale <140, 20, 140> translate 70*y}
      }
   texture{
      material_map {
         png "fontaine.png"
         map_type 0 //plan
         //once
         texture {pigment{SlateBlue}} //0
         texture {pigment{Green}} //1
         texture {pigment{Blue}}   //2
         texture {pigment{Red*.5}}   //3
         texture {pigment{Yellow}}   //4
         texture {pigment{Red}}   //5
         texture {pigment{Orange}}   //6
         texture {pigment{White}}   //7
         }
      rotate 90*x
      scale <176, 1, 306>/5
      }
   }

#declare Fontaine_Eau=object{
   cylinder {30*y, 68*y, 144}
   pigment{Clear}

// texture statement
finish { ambient 0.2 specular 0.5 reflection 0.2 refraction 1 ior 1.3}
normal{ripples}
   }

#declare Fontaine=union{
   object{Fontaine1}
   object{Fontaine2}
   object{Fontaine_Eau}
   }

//////////////////////////////////////////////////////////////////////// SOL

#declare Sol_T_Stone6 =
texture{T_Grnt18 scale <1.5, 3, 3> rotate <0, 0, 40>}
texture{T_Grnt19 scale <2, 4, 1.3> rotate <0, 0, 30>
        finish{phong 0.1 phong_size 90}}
texture{T_Crack1 scale <1, 2, 1.4> rotate <10, 0, -20>
   finish {phong 0.1 phong_size 90 crand 0.1}}

#declare Sol_T_Stone10 =
texture{pigment{color Black}}
texture{T_Grnt17a scale <3, 6, 2> rotate <0, 0, 50>}
texture{T_Grnt3a scale <1, 2, 1> rotate <0, 0, -50>
   finish {phong 0.1 phong_size 90 crand 0.1}}

#declare Sol_T_Stone13 =
texture{T_Grnt24 scale <2, 5, 2> rotate <0, 0, 50>
        finish{ambient 0.2 crand 0.03}}
texture{T_Grnt8a scale <1, 3, 2> rotate <0, 0, -30>
   finish {phong 0.1 phong_size 90 crand 0.1}}

#declare Sol_T_Stone15=
texture{T_Grnt20 scale <1, 2, 2> rotate <0, 0, -30>
        finish{ambient 0.2 diffuse 0.9 crand 0.03}}
texture{T_Grnt8a scale <1, 2, 1> rotate <0, 0, 40>
   finish {phong 0.1 phong_size 90 crand 0.1}}

#declare Sol_T_Stone16=
texture{T_Grnt18 scale <1.3, 2, 2> rotate <0, 0, -30>
        finish{ambient 0.2 diffuse 0.9 crand 0.03}}
texture{T_Grnt19 scale <2, 4, 2> rotate <0, 0, -30>
        finish{ambient 0.2 diffuse 0.9 crand 0.03}}
texture{T_Grnt20a scale <1, 2, 1> rotate <0, 0, 40>
   finish {phong 0.1 phong_size 90 crand 0.1}}

#declare Sol_T_Stone17 =
texture{T_Grnt20 scale <1, 2, 2> rotate <0, 0, -30>
        finish{ambient 0.2 diffuse 0.9 crand 0.03}}
texture{T_Crack3 scale <1, 2, 1.4> rotate <10, 0, -20>
   finish {phong 0.1 phong_size 90 crand 0.1}}

#declare Sol_T_Stone23 =
texture{T_Grnt29 scale <1, 1, 2> rotate <40, 0, 0> rotate <0, 0, 30>}
texture{T_Grnt24a scale <2, 1, 2> rotate <40, 0, 0> rotate <0, 0, 30>}
texture{T_Crack1 scale <1, 2, 1.5> rotate <0, 0, 40>}
texture{pigment{color Yellow filter 0.9}
   finish {phong 0.1 phong_size 90 crand 0.1}}

#declare Sol1=object{
   union{
      box{<-1000, -100, -1000>, <1000, 0, 1000>}
      difference{
         box{<-700, 0, -1000>, <700, 30, 1000>}
         box{<-540, -10, -540>, <540, 40, 540>}
         }
      }
#ifndef(FAST_TEXTURES)
   texture{
      material_map {
         png "sol.png"
         map_type 0 //plan
         texture {Sol_T_Stone6 scale .1}   //0 black
         texture {Sol_T_Stone13 scale .1}   //1 blue
         texture {Sol_T_Stone17 scale .1}   //2 green 1
         texture {Sol_T_Stone17 translate 30 scale .1}   //3 green 2
         texture {Sol_T_Stone17 translate 12 scale .1}   //4 green 3
         texture {Sol_T_Stone23 translate 25 scale .1}   //5 yellow 1
         texture {Sol_T_Stone23 scale .1}   //6 yellow 2
         texture {Sol_T_Stone10}   //7 gold
         }
      rotate 90*x
      scale 100
      }
#else
   pigment {Tan}
#end
   no_shadow
   }

#declare Sol2=object{ // haut
   difference{
      box{<-540, 0, -540>, <540, 30, 540>}
      box{<-500.1, -10, -500.1>, <500.1, 40, 500.1>}
      }
#ifndef(FAST_TEXTURES)
   texture{
      material_map {
         png "sol2.png"
         map_type 0 //plan
         texture {Sol_T_Stone15}    //0 green -> White 1
         texture {Sol_T_Stone15}    //1 blue  -> White 2
         texture {Sol_T_Stone16}    //2 red   -> Black
         texture {pigment {Gray50}} //3 White -> Joints
         }
      rotate 90*x
      scale 10 rotate 45*y
      }
#else
   pigment {Gray80}
#end
   }

#declare Sol3=object{ // intrieur
   difference{
      box{<-500.1, 0, -500.1>, <500.1, 30, 500.1>}
      box{<-500, -10, -500>, <500, 40, 500>}
      }
#ifndef(FAST_TEXTURES)
   texture{
      material_map {
         png "sol2.png"
         map_type 0 //plan
         texture {Sol_T_Stone15}    //0 green -> White 1
         texture {Sol_T_Stone15}    //1 blue  -> White 2
         texture {Sol_T_Stone16}    //2 red   -> Black
         texture {pigment {Gray50}} //3 White -> Joints
         }
      rotate 45*z scale <1/sqrt(2), 1, 1>*10 rotate -45*y
      }
#else
   pigment {White}
#end
   }

#declare Sol=union{
   object {Sol1}
   object {Sol2}
   object {Sol3}
   }

//////////////////////////////////////////////////////////////////////// GRILLE

#declare Grille1=object{
   box{<-685, 0, 0>, <-685.1, 300, 1000>}
   texture{
      material_map {
         png "grille.png"
         map_type 0 //plan
         texture {    //0 black
            pigment {Clear}
            finish {ambient 0 diffuse 0}
            }
          texture {Grille_T}   //1 white
         }
      rotate 90*y rotate 45*x
      scale 30
      }
   }

#declare Grille2=object{
   union{
      box {<-680, 0, 500>, <-690, 40, 0>}
      box {<-680, 290, 500>, <-690, 305, 0>}
      box {<-680, 0, 490>, <-690, 305, 500>}
      }
   texture {Grille_T}
   }

#declare Grille=union{
   object {Grille1}
   object {Grille2}
   }

//////////////////////////////////////////////////////////////////////// MURS

#declare Colonne_tx1=texture{T_Stone41}//blue
#declare Colonne_tx2=texture{T_Stone18}//green
#declare Colonne_tx3=texture{T_Stone21}//red
#declare Colonne_tx4=texture{T_Stone10}//yellow
#declare Colonne_tx5=texture{T_Gold_5A}//bands
#declare Colonne1=object{
   cylinder {0*y, 115*y, 20}
#ifndef(FAST_TEXTURES)
   texture{
      material_map {
         png "colonne.png"
         map_type 2 //cylindre
         texture {pigment{Black}} //0
         texture {Colonne_tx1}    //1
         texture {Colonne_tx2}    //2
         texture {Colonne_tx3}    //3
         texture {Colonne_tx4}    //4
         texture {Colonne_tx5}    //5
         }
      scale <1, 20*6.2831/10, 1>
      }
#else
pigment{rgb <.8, .2, .2>}
#end
   }

#declare Colonne2=object{
   prism {
      linear_sweep linear_spline
      120, 400, 9,
      < 20, 0>, < 14, 14>, < 0, 20>, < -14, 14>, < -20,  0>,
      <-14, -14>, <0,  -20>, <14, -14>, <20, 0>
      rotate 22.5*y
      }
   texture{Platre_T}
   }

#declare Colonne3=object{
   torus {20, 1 scale <1, 2.5, 1> translate 122.5*y}
   texture{Platre_T}
   }

#declare Colonne4=object{
   cylinder {115*y, 120*y, 20}
#ifndef(FAST_TEXTURES)
   texture{
      material_map {
         png "frise1.png"
         map_type 2 //cylindre
         texture {T_Stone15} //0 blue -> white 1
         texture {T_Stone15}    //1 green -> white 2
         texture {T_Stone16}    //2 red -> black
         texture {Colonne_tx5}    //3 white -> gold
         }
      scale <1, 5, 1>
      }
#else
pigment{rgb <.8, .2, .2>}
#end
   }

#declare Colonne=union{
   object {Colonne1}
   object {Colonne2}
   object {Colonne3}
   object {Colonne4}
   }

#declare Murs_Motif=union{
   box {<-8, 0, -8><8, -500, 8>}
   cylinder{-y, 8*y, 7}
   sphere {8*y, 7}
   }

#declare Murs1=object{
   union{
      box {<-670, 150, 500><-700, 500, 1000>}
      box {<-670, 150, -500><-700, 500, -1000>}
      box {<-670, 300, -1000><-700, 500, 1000>}
      box {<700, 150, -1000><730, 150, 1000>}
      box {<700, 150, 730><-700, 500, 700>}
      box {<700, 150, -730><-700, 500, -700>}

      difference{
         box {<-513, 200, -500><-527, 500, 500>} //ct cour
         cylinder {-490*x, -530*x, 1 scale <1, 100, 135> translate <0, 200, 370>}
         }
      difference{
         box {<-220, 200, 513><-500, 500, 527>}
         cylinder {490*z, 530*z, 1 scale <135, 100, 1> translate <-370, 200, 0>}
         }
      difference{
         box {<-220, 200, 520-18.4><500, 500, 520+18.4>}
#declare GROSMUR=1
#ifdef (GROSMUR)
         #declare Murs_x=-200
         #while(Murs_x <= 200)
            #declare Murs_y = 200+100*sqrt(1-(Murs_x/200*Murs_x/200))
            object {Murs_Motif translate <Murs_x, Murs_y, 520+12>}
            object {Murs_Motif translate <Murs_x+8, Murs_y+6, 520>}
            object {Murs_Motif translate <Murs_x, Murs_y, 520-12>}
            #declare Murs_x = Murs_x+12
            #end
#else
         cylinder {490*z, 550*z, 1 scale <200, 100, 1> translate <0, 200, 0>}
#end
         }
      }
   texture{Platre_T}
   }

#declare Murs2=object{
   union{
      box {<-670, 0, 500><-700, 145, 1000>}
      box {<0, 0, 730><-700, 145, 700>}
      }
#ifndef(FAST_TEXTURES)
   texture{
      material_map {
         png "data/col_1.png"
         map_type 0 //plane
         texture {pigment{Black}} //0
         texture {Colonne_tx1}    //1
         texture {Colonne_tx2}    //2
         texture {Colonne_tx3}    //3
         texture {Colonne_tx4}    //4
         texture {Colonne_tx5}    //5
         }
      scale <1/sqrt(2), 1, 1>*20*6.2831/10 rotate -45*y translate 30*y
      }
#else
pigment{rgb <.8, .2, .2>}
#end
   }

#declare Murs3=object{
   union{
      cylinder {500*z, 1000*z, 1 scale <1, 2.5, 1> translate <-670, 152.5, 0>}
      cylinder {-670*x, -700*x, 1 scale <1, 2.5, 1> translate <0, 152.5, 500>}
      sphere {0, 1 scale <1, 2.5, 1> translate <-670, 152.5, 500>}
      cylinder {0*x, -670*x, 1 scale <1, 2.5, 1> translate <0, 152.5, 700>}
      }
   texture{Platre_T}
   }

#declare Murs4=object{ //frise
   union{
      box {<-670, 145, 500><-700, 150, 1000>}
      box {<0, 145, 730><-700, 150, 700>}
      }
#ifndef(FAST_TEXTURES)
   texture{
      material_map {
         png "frise1.png"
         map_type 0 //plan
         texture {T_Stone15} //0 blue -> white 1
         texture {T_Stone15}    //1 green -> white 2
         texture {T_Stone16}    //2 red -> black
         texture {Colonne_tx5}    //3 white -> gold
         }
      scale <1/sqrt(2), 1, 1>*<5*25, 5, 1> rotate -45*y translate 145*y
      }
#else
pigment{rgb <.8, .2, .2>}
#end
   }

#declare Murs=union{
   object{Murs1}
   object{Murs2}
   object{Murs3}
   object{Murs4}
   object{Colonne translate <-520, 30, 220>}
   object{Colonne translate <-520, 30, 520>}
   object{Colonne translate <-220, 30, 520>}
   }

//////////////////////////////////////////////////////////////////////// PLATEAU

#declare Verre0=object{
   difference{
      cylinder {0, 6*y, 2.5}
      cylinder {.5*y, 6.5*y, 2.3}
      }
#ifndef(FAST_TEXTURES)
   pigment {Clear}
   finish {F_Glass4}
#else
   pigment{Red}
#end
   }

#declare Verre1=object{
   cylinder {.5*y, 3*y, 2.3}
#ifndef(FAST_TEXTURES)
   pigment {Tan filter 1.0}
   finish {F_Glass1}
#else
   pigment{Red}
#end
   }

#declare Verre2=object{
   cylinder {.5*y, 4.5*y, 2.3}
#ifndef(FAST_TEXTURES)
   pigment {Tan filter 1.0}
   finish {F_Glass1}
#else
   pigment{Red}
#end
   }

#declare Plateau1=object{
   PlateauS
#ifndef(FAST_TEXTURES)
   texture{T_Gold_3A}
#else
   pigment{Yellow}
#end
   scale 20
   }

#declare Aiguiere1=object {
   union{
      object{aiguiere scale <30, 30, 30>*.8}
      object{#include "col_aiguiere.inc" scale <1.5, 2, 2> translate <0, 8, -7>}
      }
#ifndef(FAST_TEXTURES)
   texture {T_Silver_1C}
#else
   pigment {Gray80}
#end
   }

#declare Aiguiere2=object {
   #include "anse_aiguiere.inc" rotate 90*y scale <1.5, 1.3, 1.5> translate <0, 8, 7>
#ifndef(FAST_TEXTURES)
   pigment {Wheat}
   finish {Shiny}
#else
   pigment {Wheat}
#end
   }

#declare Aiguiere =union{
   object {Aiguiere1}
   object {Aiguiere2}
   }

#declare Plateau=union{
   object {Plateau1}
   union {object {Verre0} object {Verre1} translate <6, .2, 12>}
   union {object {Verre0} object {Verre2} translate <3, .2, 5>}
   object {Verre0 translate <-6, .2, 7>}
   object {Aiguiere rotate -100*y translate <0, .2, -7>}
   }

//////////////////////////////////////////////////////////////////////// SALADIER

#declare Saladier1=object{
   saladier_S
#ifndef(FAST_TEXTURES)
   texture{T_Gold_2B}
#else
   pigment{Yellow}
#end
   scale <12, 2, 12>
   }

#declare Fruit1=object{
   sphere {0, 1 translate .5*y}
   pigment {Orange}
   normal {dents 1 bump_size 3 scale 0.1}
   finish {ambient 0.2 phong 1 phong_size 10}
   scale 3
   }

#declare Fruit2=object{
   union{
      sphere {0, 1 translate <0, .5, 0>}
      sphere {0, 1 translate <0, .5, 2>}
      sphere {0, 1 translate <0, .5, -2>}
      sphere {0, 1 translate <1.5, .5, -1>}
      sphere {0, 1 translate <-1.5, .5, -1>}
      sphere {0, 1 translate <-1, 1.5, -1>}
      sphere {0, 1 translate <1, 1.5, -1.2>}
      }
   pigment {color rgbf <0.9, 1, 0.4, 0.7>}
   finish {Dull ambient 0.2 crand 0.1}
   scale 1
   }

#declare Saladier=union{
   object {Saladier1}
   object {Fruit1 translate <3 ,1, -3>}
   object {Fruit1 translate <-3 ,0.5, -5>}
   object {Fruit2 translate <1 ,0.5, 6>}
   }

//////////////////////////////////////////////////////////////////////// TREPIED

#declare Trepied1=object{
   superellipsoid {<1, 0.4> rotate 90*x scale <12, 3, 12> translate 22*y}
   texture{
      pigment {Red*.4 + Brown*.3}
      normal {crackle scale <2, .5, 2>}
      finish {Glossy}
      }
   }

#declare Trepied2=object{
   cone {<10, 21, 0>, 1.5, <12, -1, 0> 0.5}
   texture{
      pigment { P_WoodGrain4A color_map { M_Wood5A } rotate 1*z}
      finish {Shiny}
      }
   }

#declare Trepied=union{
   object {Trepied1}
   object {Trepied2}
   object {Trepied2 rotate 120*y}
   object {Trepied2 rotate -120*y}
   }

//////////////////////////////////////////////////////////////////////// FAUTEUIL

#declare Fauteuil_1=object {
   union{
      box {<30, 66, 30>, <26, 70, -30>}
      box {<-30, 66, 30>, <-26, 70, -30>}
      box {<-29.9, 40, -29.9>, <29.9, 44, 29.9>}
      difference{
         box {<-29.9, 6, -29.9>, <29.9, 10, 29.9>}
         box {<-26, 5, -26>, <26, 11, 26>}
         }
      }
   texture { pigment { P_WoodGrain4A color_map { M_Wood8A }} rotate 1*z scale 5}
   texture { pigment { P_WoodGrain4B color_map { M_Wood8B }} rotate 1*z scale 5}
   }

#declare Fauteuil_2=object { // Dossier
   union{
      box {<-26, 44, -30>, <26, 90, -26>}
      intersection{
         box {<-26, 90, -30>, <26, 150, -26>}
         cylinder {<-30, 90, -31>, <-30, 90, -25>, 56}
         cylinder {<30, 90, -31>, <30, 90, -25>, 56}
         }
      }
      pigment {Red}
   }

#declare Fauteuil_3=object {
   union{
      box {<-30, 0, -30>, <-26, 70, -26>}
      box {<30, 0, -30>, <26, 70, -26>}
      box {<-30, 0, 30>, <-26, 70, 26>}
      box {<30, 0, 30>, <26, 70, 26>}
      }
   texture { pigment { P_WoodGrain4A color_map { M_Wood8A }} rotate 91*x scale 5}
   texture { pigment { P_WoodGrain4B color_map { M_Wood8B }} rotate 91*x scale 5}
   }

#declare Fauteuil_4=object { // Assise
   intersection{
      box {<-30, 44, -30>, <30, 90, 30>}
      superellipsoid{
         <0.1,0.6>
         rotate 90*x scale <26, 8, 26> translate 44*y
         }
      }
   pigment {
      image_map{
         png "fauteu4.png"
         map_type 0 interpolate 2
         once
         }
      translate -.5 rotate 90*x scale <26*2*1.35, 1, 26*2*1.25>
      }
   }

#declare Fauteuil=union{
   object {Fauteuil_1}
   object {Fauteuil_2}
   object {Fauteuil_3}
   object {Fauteuil_4}
   }

//////////////////////////////////////////////////////////////////////// EXTERIEUR

#declare galaxy_intensity=6
#declare galaxy_bgstars=2
#declare galaxy_bgnebula=0
#declare galaxy_nebula_ambient=<.2, .1, .3>*0
#declare galaxy_declare_only=1
#include "galaxy.bg"

#declare Ciel=sphere{0, 10000 hollow
   pigment {BGMilkyWay scale 1 rotate z * 0*45}//ok
   finish{ambient 10000000}
   }

#declare Montagnes=object {
  height_field {
    tga "montagne.tga"
    water_level 0.0099
    smooth
  }
  pigment {
     bozo color_map{
        [0 SlateBlue*.3]
        [1 Gray20]
        }
     }
  finish {
     ambient .2
     //diffuse 0
     }
  translate <-.5, 0, -.5>
  scale <10000, 1200, 10000>
  translate <-5000, -1000, 3000>
}


#declare Decor=union{
   object {Plateau translate <-400, 25, 370>}
   object {Saladier translate <-350, 0, 420>}
   object {Trepied rotate 25*y translate <-400, 0, 370>}
   object {Fauteuil rotate 190*y translate <-360, 30, 560>}
   object {Sol}
   object {Grille}
   object {Murs}
   object {Ciel}
   object {Montagnes}
   object {Coussin rotate 90*x rotate 50*y scale <1, .7, 1> translate <-240, 5*.7, 300>}
   object {Tapis rotate 30*y translate <-230, 0, 350>}
   }
