
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: Night in the graveyard
// Date: 10th March, 1998
// Auth: E. Grant [ewgr@abaddon.globalnet.co.uk]


#include "colors.inc"
#include "textures.inc"
#include "stones.inc"

camera {
   location <3.5, 6.4, -22>
   look_at <2, 3,  0>
       }

light_source { < 15, 18, 18 > color LightGray shadowless }
light_source { < -10, 30, -20 > color LightGray shadowless }
light_source { < -5, 11, 12 > color rgb < 1.5, 1.53, 1.8 > }
light_source {
               0*x
               color rgb < .41, .42, .43, >
               spotlight
               translate < 0, 40, -20 >
               point_at < 3, 3, -3 >
               radius 3
               tightness 50
               falloff 10
              }
light_source {
               0*x
               color rgb < .91, .92, .96, >
               spotlight
               translate < -5, 28, 12 >
               point_at < -6, 20, 18 >
               radius 15
               tightness 50
               falloff 10
              }

// Ground fog.
       fog { distance 7
             colour rgbf<0.45, 0.46, 0.53, 0.7 >
             fog_type 2
             fog_offset 0.6
             fog_alt 1.3
             turbulence 2
             turb_depth 1
             octaves 2
             lambda 3
             omega .8
           }


// A mossy, gritty ground.
      plane { y, 0 rotate 3*x
    texture {T_Grnt1a scale .7 }

            }

  // A full moon.
     //First an aura
       sphere {< 0, 0, 0 > 5
               pigment {Clear} finish { refraction 0.8 }
         halo { emitting
                linear
                spherical_mapping
                samples 10
                aa_level 0.5
                aa_threshold 3
               jitter 0.3
     colour_map  { [0 color rgbt < 0.37, 0.38, 0.39, 0.65 > ]
                   [1 color rgbt < 1, 1, 1, 1 > ]
                  }
                }
             hollow no_shadow translate < -7.1, 19.55, 20.2 >
           }
    // Then the orb
     sphere { < 0, 0, 0 > 2.6 no_shadow
     pigment  { bumps scale .1
         color_map {  [ 0.0     rgb <0.56, 0.56, 0.53> ]
                      [ 1.0     rgb <0.9, 0.95, 0.95> ]
                   }
            turbulence 0.6
            omega 0.8
            lambda 3.0
         }
      normal { bumps , .2 }
      finish { ambient 1
               diffuse 0.7
               specular 0.1
             }
             translate < -6.1, 18, 16.2 >
           }
// A cloudy sky

   sky_sphere {
    pigment {
      gradient y
      color_map {
        [0.000 0.002 color rgb <0, 0, 0>
                     color rgb <0, 0, 01>]
        [0.002 0.200 color rgb <0.1, 0.1, 0.1>
                     color rgb <0.1, 0.1, 0.12>]
      }
      scale 1
      translate -1
    }
    pigment {
      bozo scale .5
      turbulence 0.65
      octaves 6
      omega 0.7
      lambda 2
      color_map {
          [0.0 0.1 color rgbt <0.65, 0.7, 0.75, 0.4>
                   color rgbt <0.75, 0.75, 0.75, 0.5>]
          [0.1 0.5 color rgbt <0.75, 0.75, 0.75, 0.6 >
                   color rgbt <1, 1, 1, .9>]
          [0.5 1.0 color rgbt <1, 1, 1, 1>
                   color rgbt <1, 1, 1, 1>]
      }
      scale <1.5, 0.5, 0.2>
    }
    rotate <-135, 0, -5>
  }


// Place a path

       box { < -3.5, 0.1, -1.2 > < 3.4, 0.4, 30 > rotate 3*x
         pigment { brick
               color Gray10 color Black
                scale .2
              }
           }

// Declarations.. self explanatory

 #declare Gate_post =
         difference {
              union {
                box { < -1, 0, -1>  < 1,  8,  1>  rotate < 0, 10, 0 >
            texture { PinkAlabaster }
                    }
             sphere { < 0, 9.1, 0 > 1.25
            texture { PinkAlabaster }
                    }
                    }
              torus { 1.4, .7 translate < 0, 7.7, 0 >
            texture { PinkAlabaster   }
                    }
                    }

 #declare Gate_bar =
           union {
             box { < -0.15, 0, -0.2 > < 0.15, 6, 0.2 > texture { Spun_Brass }  pigment { colour Gray10 } finish { diffuse 0.9 reflection 0.5 } }
             box { < -1, 5.84, -0.2 > < 0, 5.9, 0.2 > texture { Spun_Brass }  pigment { colour Gray10 } finish { diffuse 0.9 reflection 0.5 } }
             box { < -1, 3.84, -0.2 > < 0, 3.9, 0.2 > texture { Spun_Brass }  pigment { colour Gray10 } finish { diffuse 0.9 reflection 0.5 } }
             box { < -1, 1.84, -0.2 > < 0, 1.9, 0.2 > texture { Spun_Brass }  pigment { colour Gray10 } finish { diffuse 0.9 reflection 0.5 } }
            cone { < 0, 5.88, 0>,  0.2, < 0, 7, 0>, 0.00001 texture { Silver_Texture }  }
                 }

 #declare Gate =
           union {
          object { Gate_bar translate < 0.8, 0, 0 > }
          object { Gate_bar translate < 1.6, 0, 0 > }
          object { Gate_bar translate < 2.4, 0, 0 > }
          object { Gate_bar translate < 3.2, 0, 0 > }
             box { < -0.15, 0, -0.2 > < 0.15, 6, 0.2 > texture { Spun_Brass } pigment { colour Gray10 } }
            cone { < 0, 5.88, 0>,  0.2, < 0, 7, 0>, 0.00001 texture { Silver_Texture }  }
                 }

 #declare Fence =
           union {
          object { Gate_bar translate < 0.8, 0, 0 > }
          object { Gate_bar translate < 1.6, 0, 0 > }
          object { Gate_bar translate < 2.4, 0, 0 > }
          object { Gate_bar translate < 3.2, 0, 0 > }
          object { Gate_bar }
                 }
 #declare Grave =
           union {
             box { < -2.25, -0.1, 0 > < 2.25, 0.5 , -7 > }
             box { < -2.05, 0.45, -0.2 > < 2.05, 0.65 , -6.8 > }
             box { < -1.85, .64, -0.4 > < 1.85, 1.11 , -6.6 > }
         texture { T_Grnt16 } rotate < 3,-15, 0 > translate < 3, 0, -7 >
                 }

 #declare Cross =
           union {
             box { < -0.3, 0, 0 > < 0.3, 5.8 , 0.75 > }
             box { < -1.4, 4.0, 0 > < 1.4, 4.6, 0.75 > }
         rotate < 3,-10, 0 > translate < 3, 0, -7 >
                 }

 #declare Cross2 =
           union {
             box { < -0.2, 0, 0 > < 0.2, 5.8 , 0.6 > }
             box { < -1.2, 4.4, 0 > < 1.2, 5, 0.6 > }
         rotate < 3,-10, 0 > translate < 3, 0, -7 >
                 }

 #declare Celtic =
      difference {
         union   {
        cylinder { < 0, 4.3, 0 > < 0, 4.3 , 0.749 > 1.2  }
        cylinder { < 0, 4.3, 0 > < 0, 4.3 , 0.749 > .9  }
                 rotate < 0, 0.5, 0 >
                 }
         cylinder
                 { < 0, 4.3, -0.1 > < 0, 4.3 , 0.76 > .95 texture { T_Grnt20 } no_shadow rotate < 0, 0.5, 0 > }
                 rotate < 0,-10, 0 > translate < 2.9, 0, -6.7 >
                 }

 #declare Celtic_Cross =
           union {
          object { Cross }
          object { Celtic }
                 finish { ambient .4}
                 }

 #declare Church=
     union{
    box { <-5, 0, 0> < 5, 0.5, -4> }
    box { <-4, 0.5, 0 > < 4, 1, -3 > }
    box { <-3, 1, 0> < 3, 1.5, -2> }
    box { <-3, 5.8, 0 > < 4, 6.75, -2 > rotate -1*z }
    cylinder { <-2.2, 1.4, -1.6> <-2.2, 6, -1.6> 0.4 }
    cylinder { <3.4, 1.4, -1.5> <3.2, 6, -1.6> 0.4 rotate 3*z }

    texture {T_Grnt11a} finish { crand 0.05 }
     }

 #declare Church2=
      difference {
           box{ <-8, 0, 0> <11, 7.8, 6> texture {T_Grnt11a} finish { crand 0.03 }
             }
    box { <-5, 3.2, -0.1> <-3, 5.8, 0.4> pigment {Khaki} finish { ambient .1 } }
    box { <-1.2, 2, -0.1> <1.3, 5.6, 0.3> rotate -1*x texture {Yellow_Pine scale 2 rotate 3*z } finish { ambient .9 } }
    box { <4, 3.2, -0.1> <6, 5.8, 0.2> rotate -1*x pigment {Gray20} finish { ambient .7 } }
        }

 #declare ChurchRoof=
   prism {
    conic_sweep
    linear_spline
    0, 1.5, 5,

    <5,5>,<-5,5>,<-5,-5>,<5,-5>,<5,5>

    rotate < 180, 50, 0 >
    translate < 11, 3.5, 6 >
    scale <2, 6, 2>
    pigment { gradient y scale .6
    colour_map{ [0 colour MediumTurquoise]
                [0.95 colour CadetBlue] }
              }
        finish { ambient .3 }
       }

// Place objects -all the hard work; -rotate, translate, vegetate ;-)

     object { Gate rotate < 2, -55, 0 > translate -3.3*x }
     object { Gate rotate 132*y translate 3.3*x }
     object { Gate_post translate < -4.5, 0, 0 > }
     object { Gate_post translate < 4.5, 0, 0 > }
     object { Fence translate -8.9*x }
     object { Fence translate 5.8*x }
     object { Fence translate -12.8*x }
     object { Fence translate -16.7*x }
     object { Fence translate 9.8*x }
     object { Fence translate 13.7*x }
     object { Grave }
     object { Celtic_Cross   rotate < -3, 0, 0 >
          pigment { marble   frequency .5 turbulence .9
          colour_map { [ 0.1 Silver ]
                       [ 0.45 LightSteelBlue ]
                       [ 0.67 DarkSlateGray ]
                       [ 0.69 LightSteelBlue ]
                       [ 0.75 Silver ]
                     }}}
     object { Cross2 scale 0.8 texture {T_Stone13 scale 0.6}  translate <5.75, 0, -1> }
     object { Cross scale 0.7 texture {T_Stone6 scale 0.6} rotate 5*z translate <8, 0, -5> }
     object { Cross2  texture {T_Stone8 scale 0.45}  translate < -4, -1, -9> }
     object { Cross scale 0.8 texture {T_Grnt25 scale 0.55}  translate < -7.3, 0, -1.5> }
     object { Church scale <1.2, 1.7, 1.6>  rotate <0, 60, -1> translate < 10, 0.5, 9 > }
     object { Church2 scale <1, 1.6, 1.3>  rotate <-1, 62, 0> translate <10, 0.5, 9 > }
     object { ChurchRoof }


// Grave Legend
          text { ttf "crystal.ttf" "R.I.P." 0.3, 0 scale 1
        texture { Spun_Brass } pigment { colour Gold }
         finish { ambient .2 reflection .4 specular .6 phong 5 phong_size 200 metallic on}
         rotate < 93, -15, 0 >
      translate < 2.35, 1.3, -10 >
                }

           text { ttf "crystal.ttf" "2D" 0.3, 0 scale 1.2
        texture { Spun_Brass } pigment { colour Gold }
         finish { ambient .2 reflection .4 specular .6 phong 5 phong_size 200 metallic on}
         rotate < 93, -15, 0 >
      translate < 3.5, 1.4, -11.6 >
                }

          text { ttf "crystal.ttf" "Graphics" 0.3, 0 scale < 0.7, 0.7, 0.9 >
        texture { Spun_Brass } pigment { colour Gold }
         finish { ambient .2 reflection .4 specular .6 phong 5 phong_size 200 metallic on}
         rotate < 93, -15, 0 >
      translate < 3.2, 1.5, -13.1 >
                }


// Render.... "Good God, it worked."



