// File generated by sPatch, Copyright 1996-1998 by Mike Clifton
// "Hacked" by GSR, Data Copyright 1998
// See other files for GSR License


#include "colors.inc"

global_settings {
	assumed_gamma 2.2
	ambient_light 1
}


#declare MeshScale = 100
#declare HumanMesh = on
#declare Mountains = on
#declare Aurora = on


background { color rgb <0, 0, 0> }

camera {
	right <16/9, 0, 0>
	location <-.2, .6, 1> * MeshScale
	look_at <-.3, .9, 0> * MeshScale
}

#declare LightIntensity = .9

light_source {
    10 * MeshScale * < 0, 100, -200 >
    color rgb LightIntensity * <.9, 1, 1>
}
light_source {
    10 * MeshScale * < -200, 10, 0 >
    color rgb LightIntensity * <0.4, 0.5, 0.4>
}
light_source {
    10 * MeshScale * < -50, 10, 200 >
    color rgb LightIntensity * .5 * <0.4, 0.25, 0.25>
}


cylinder {    // To solve a error of the mesh
	<0, 0, 0>, <0, .6, 0>, .1
	scale <.8, 1, .5>
	texture {
		pigment { Orange }
	}
	scale MeshScale
}


#if (Mountains = on)
	#include "mountain.inc"
#end

#if (Aurora = on)
    #include "aurora.inc"
#end


#declare T_Coat =
	texture {
		pigment { Red }
        finish {
            phong .9
            metallic .5
            ambient .05
        }
        normal {
            wrinkles .5
            scale .075
        }
	}

#declare T_Layer1 = texture { T_Coat }

//#declare T_Layer2 =

#declare T_Layer3 = texture { T_Coat }

#declare T_Layer4 = texture { T_Coat }

#declare T_Layer5 =    // Hat
	texture {
        pigment { NavyBlue }
        finish {
            phong .2
            phong_size 30
        }
        normal { wrinkles 2 scale .05 }
	}

#declare T_Layer6 =    // Ear protections
	texture {
        pigment {
            granite
            color_map {
                [ .5 Orange ]
                [ .5 OrangeRed ]
            }
            scale .01
            turbulence .5
        }
        finish {
            specular 1
            roughness .001
        }
        normal { granite 1.4 scale .025 }
	}

#declare T_Layer7 =    // Glasses
	texture {
		pigment { Green }
	}

#declare T_Layer8 =    // Neck protection
	texture {
		pigment { Blue }
        finish  { specular .1 }
        normal { granite .5 scale .01 }
	}


#if (HumanMesh = on)
// Layer 1
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.146, 0.386, -0.010> <0.145, 0.392, -0.007> <0.146, 0.400, -0.003> <0.144, 0.405, 0.000> 
		<0.145, 0.388, 0.011> <0.144, 0.393, 0.013> <0.147, 0.400, 0.020> <0.145, 0.405, 0.023> 
		<0.127, 0.387, 0.035> <0.128, 0.396, 0.040> <0.139, 0.398, 0.050> <0.144, 0.406, 0.055> 
		<0.116, 0.384, 0.053> <0.117, 0.394, 0.058> <0.130, 0.396, 0.071> <0.135, 0.405, 0.076> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.146, 0.386, -0.010> <0.145, 0.388, 0.011> <0.127, 0.387, 0.035> <0.116, 0.384, 0.053> 
		<0.146, 0.385, -0.011> <0.145, 0.387, 0.010> <0.127, 0.380, 0.031> <0.116, 0.377, 0.049> 
		<0.148, 0.384, -0.010> <0.147, 0.384, 0.011> <0.138, 0.372, 0.036> <0.127, 0.369, 0.053> 
		<0.148, 0.384, -0.010> <0.147, 0.383, 0.011> <0.142, 0.365, 0.036> <0.132, 0.362, 0.054> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.146, 0.386, -0.010> <0.147, 0.385, -0.022> <0.129, 0.380, -0.033> <0.121, 0.378, -0.041> 
		<0.145, 0.392, -0.007> <0.146, 0.391, -0.020> <0.128, 0.389, -0.032> <0.120, 0.387, -0.041> 
		<0.146, 0.400, -0.003> <0.146, 0.400, -0.019> <0.133, 0.398, -0.033> <0.127, 0.397, -0.048> 
		<0.144, 0.405, 0.000> <0.144, 0.405, -0.015> <0.136, 0.406, -0.036> <0.130, 0.405, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.146, 0.386, -0.010> <0.146, 0.385, -0.011> <0.148, 0.384, -0.010> <0.148, 0.384, -0.010> 
		<0.147, 0.385, -0.022> <0.147, 0.385, -0.023> <0.148, 0.385, -0.024> <0.148, 0.384, -0.024> 
		<0.129, 0.380, -0.033> <0.130, 0.374, -0.033> <0.141, 0.372, -0.039> <0.144, 0.367, -0.040> 
		<0.121, 0.378, -0.041> <0.122, 0.371, -0.041> <0.132, 0.370, -0.049> <0.135, 0.364, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.148, 0.384, -0.010> <0.147, 0.383, 0.011> <0.142, 0.365, 0.036> <0.132, 0.362, 0.054> 
		<0.150, 0.374, -0.007> <0.149, 0.373, 0.014> <0.149, 0.355, 0.038> <0.138, 0.352, 0.055> 
		<0.153, 0.361, -0.001> <0.153, 0.361, 0.018> <0.158, 0.340, 0.043> <0.147, 0.339, 0.059> 
		<0.154, 0.351, 0.002> <0.155, 0.351, 0.020> <0.162, 0.329, 0.044> <0.152, 0.328, 0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.148, 0.384, -0.010> <0.150, 0.374, -0.007> <0.153, 0.361, -0.001> <0.154, 0.351, 0.002> 
		<0.148, 0.384, -0.024> <0.151, 0.374, -0.021> <0.153, 0.361, -0.019> <0.154, 0.351, -0.017> 
		<0.144, 0.367, -0.040> <0.150, 0.357, -0.043> <0.160, 0.343, -0.041> <0.162, 0.332, -0.042> 
		<0.135, 0.364, -0.050> <0.141, 0.355, -0.053> <0.148, 0.341, -0.056> <0.150, 0.330, -0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.154, 0.351, 0.002> <0.155, 0.351, 0.020> <0.162, 0.329, 0.044> <0.152, 0.328, 0.059> 
		<0.156, 0.342, 0.004> <0.156, 0.341, 0.023> <0.165, 0.322, 0.044> <0.154, 0.321, 0.059> 
		<0.157, 0.329, 0.005> <0.158, 0.329, 0.022> <0.164, 0.311, 0.046> <0.154, 0.310, 0.059> 
		<0.158, 0.319, 0.005> <0.160, 0.319, 0.022> <0.164, 0.304, 0.044> <0.154, 0.303, 0.057> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.154, 0.351, 0.002> <0.156, 0.342, 0.004> <0.157, 0.329, 0.005> <0.158, 0.319, 0.005> 
		<0.154, 0.351, -0.017> <0.156, 0.342, -0.015> <0.156, 0.329, -0.014> <0.157, 0.319, -0.014> 
		<0.162, 0.332, -0.042> <0.163, 0.323, -0.042> <0.158, 0.310, -0.040> <0.157, 0.301, -0.039> 
		<0.150, 0.330, -0.056> <0.152, 0.322, -0.057> <0.147, 0.310, -0.055> <0.145, 0.301, -0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.158, 0.319, 0.005> <0.160, 0.319, 0.022> <0.164, 0.304, 0.044> <0.154, 0.303, 0.057> 
		<0.159, 0.311, 0.005> <0.160, 0.311, 0.022> <0.164, 0.300, 0.044> <0.154, 0.299, 0.056> 
		<0.163, 0.300, 0.003> <0.164, 0.301, 0.018> <0.162, 0.295, 0.041> <0.152, 0.295, 0.053> 
		<0.161, 0.292, 0.002> <0.162, 0.293, 0.018> <0.159, 0.293, 0.040> <0.149, 0.293, 0.052> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.158, 0.319, 0.005> <0.159, 0.311, 0.005> <0.163, 0.300, 0.003> <0.161, 0.292, 0.002> 
		<0.157, 0.319, -0.014> <0.158, 0.311, -0.014> <0.161, 0.300, -0.015> <0.160, 0.292, -0.015> 
		<0.157, 0.301, -0.039> <0.156, 0.297, -0.039> <0.156, 0.291, -0.041> <0.153, 0.289, -0.039> 
		<0.145, 0.301, -0.055> <0.144, 0.298, -0.054> <0.145, 0.291, -0.054> <0.142, 0.290, -0.052> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.161, 0.292, 0.002> <0.162, 0.293, 0.018> <0.159, 0.293, 0.040> <0.149, 0.293, 0.052> 
		<0.161, 0.290, 0.002> <0.162, 0.290, 0.018> <0.152, 0.290, 0.038> <0.142, 0.290, 0.050> 
		<0.156, 0.293, 0.004> <0.156, 0.293, 0.020> <0.142, 0.291, 0.037> <0.131, 0.291, 0.049> 
		<0.153, 0.293, 0.004> <0.154, 0.293, 0.020> <0.134, 0.289, 0.036> <0.124, 0.288, 0.048> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.161, 0.292, 0.002> <0.161, 0.290, 0.002> <0.156, 0.293, 0.004> <0.153, 0.293, 0.004> 
		<0.160, 0.292, -0.015> <0.159, 0.289, -0.015> <0.155, 0.294, -0.014> <0.153, 0.294, -0.013> 
		<0.153, 0.289, -0.039> <0.147, 0.287, -0.037> <0.139, 0.291, -0.034> <0.133, 0.290, -0.032> 
		<0.142, 0.290, -0.052> <0.136, 0.287, -0.050> <0.127, 0.291, -0.047> <0.121, 0.290, -0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.153, 0.293, 0.004> <0.154, 0.293, 0.020> <0.134, 0.289, 0.036> <0.124, 0.288, 0.048> 
		<0.153, 0.293, 0.005> <0.153, 0.293, 0.020> <0.133, 0.289, 0.036> <0.122, 0.288, 0.047> 
		<0.151, 0.293, 0.005> <0.151, 0.292, 0.021> <0.129, 0.287, 0.035> <0.118, 0.286, 0.047> 
		<0.151, 0.292, 0.005> <0.151, 0.292, 0.021> <0.130, 0.286, 0.036> <0.119, 0.285, 0.047> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.153, 0.293, 0.004> <0.153, 0.293, 0.005> <0.151, 0.293, 0.005> <0.151, 0.292, 0.005> 
		<0.153, 0.294, -0.013> <0.152, 0.294, -0.013> <0.151, 0.294, -0.012> <0.151, 0.293, -0.013> 
		<0.133, 0.290, -0.032> <0.132, 0.290, -0.031> <0.129, 0.289, -0.030> <0.130, 0.288, -0.030> 
		<0.121, 0.290, -0.045> <0.120, 0.290, -0.044> <0.117, 0.288, -0.043> <0.118, 0.287, -0.043> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.151, 0.292, 0.005> <0.151, 0.292, 0.021> <0.130, 0.286, 0.036> <0.119, 0.285, 0.047> 
		<0.153, 0.289, 0.004> <0.153, 0.288, 0.020> <0.138, 0.277, 0.037> <0.127, 0.276, 0.049> 
		<0.157, 0.286, 0.002> <0.158, 0.286, 0.019> <0.155, 0.272, 0.038> <0.144, 0.271, 0.051> 
		<0.158, 0.282, 0.002> <0.159, 0.282, 0.019> <0.160, 0.262, 0.040> <0.149, 0.262, 0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.151, 0.292, 0.005> <0.153, 0.289, 0.004> <0.157, 0.286, 0.002> <0.158, 0.282, 0.002> 
		<0.151, 0.293, -0.013> <0.152, 0.289, -0.013> <0.156, 0.286, -0.017> <0.157, 0.282, -0.018> 
		<0.130, 0.288, -0.030> <0.137, 0.279, -0.034> <0.153, 0.271, -0.039> <0.158, 0.261, -0.044> 
		<0.118, 0.287, -0.043> <0.125, 0.278, -0.047> <0.139, 0.271, -0.054> <0.145, 0.261, -0.058> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.158, 0.282, 0.002> <0.159, 0.282, 0.019> <0.160, 0.262, 0.040> <0.149, 0.262, 0.053> 
		<0.161, 0.273, 0.001> <0.161, 0.273, 0.017> <0.164, 0.255, 0.042> <0.153, 0.255, 0.054> 
		<0.161, 0.260, 0.000> <0.161, 0.260, 0.019> <0.160, 0.244, 0.043> <0.147, 0.244, 0.057> 
		<0.163, 0.251, 0.000> <0.163, 0.251, 0.019> <0.159, 0.236, 0.044> <0.146, 0.236, 0.058> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.158, 0.282, 0.002> <0.161, 0.273, 0.001> <0.161, 0.260, 0.000> <0.163, 0.251, 0.000> 
		<0.157, 0.282, -0.018> <0.160, 0.273, -0.019> <0.161, 0.260, -0.021> <0.163, 0.251, -0.021> 
		<0.158, 0.261, -0.044> <0.162, 0.254, -0.047> <0.160, 0.243, -0.050> <0.160, 0.235, -0.050> 
		<0.145, 0.261, -0.058> <0.148, 0.254, -0.061> <0.147, 0.243, -0.066> <0.146, 0.235, -0.067> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.163, 0.251, 0.000> <0.163, 0.251, 0.019> <0.159, 0.236, 0.044> <0.146, 0.236, 0.058> 
		<0.163, 0.244, 0.000> <0.163, 0.244, 0.019> <0.158, 0.230, 0.045> <0.145, 0.230, 0.058> 
		<0.165, 0.236, 0.002> <0.166, 0.236, 0.020> <0.157, 0.222, 0.045> <0.145, 0.222, 0.059> 
		<0.165, 0.230, 0.002> <0.166, 0.230, 0.021> <0.156, 0.216, 0.045> <0.143, 0.216, 0.058> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.163, 0.251, 0.000> <0.163, 0.244, 0.000> <0.165, 0.236, 0.002> <0.165, 0.230, 0.002> 
		<0.163, 0.251, -0.021> <0.164, 0.244, -0.021> <0.165, 0.236, -0.019> <0.165, 0.230, -0.019> 
		<0.160, 0.235, -0.050> <0.159, 0.229, -0.051> <0.157, 0.222, -0.047> <0.154, 0.217, -0.046> 
		<0.146, 0.235, -0.067> <0.146, 0.229, -0.068> <0.144, 0.221, -0.064> <0.142, 0.216, -0.062> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.165, 0.230, 0.002> <0.166, 0.230, 0.021> <0.156, 0.216, 0.045> <0.143, 0.216, 0.058> 
		<0.165, 0.223, 0.002> <0.165, 0.223, 0.021> <0.155, 0.214, 0.044> <0.143, 0.213, 0.058> 
		<0.165, 0.214, 0.003> <0.165, 0.214, 0.021> <0.152, 0.210, 0.044> <0.141, 0.209, 0.057> 
		<0.162, 0.208, 0.002> <0.163, 0.208, 0.020> <0.150, 0.209, 0.043> <0.139, 0.208, 0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.165, 0.230, 0.002> <0.165, 0.223, 0.002> <0.165, 0.214, 0.003> <0.162, 0.208, 0.002> 
		<0.165, 0.230, -0.019> <0.165, 0.223, -0.019> <0.164, 0.214, -0.017> <0.161, 0.209, -0.018> 
		<0.154, 0.217, -0.046> <0.153, 0.214, -0.045> <0.150, 0.212, -0.044> <0.147, 0.211, -0.043> 
		<0.142, 0.216, -0.062> <0.140, 0.213, -0.061> <0.137, 0.210, -0.059> <0.134, 0.209, -0.058> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.162, 0.208, 0.002> <0.163, 0.208, 0.020> <0.150, 0.209, 0.043> <0.139, 0.208, 0.056> 
		<0.160, 0.204, 0.002> <0.161, 0.204, 0.019> <0.146, 0.206, 0.040> <0.134, 0.206, 0.053> 
		<0.155, 0.202, -0.001> <0.156, 0.202, 0.016> <0.138, 0.207, 0.035> <0.128, 0.207, 0.048> 
		<0.152, 0.199, -0.003> <0.153, 0.199, 0.014> <0.133, 0.205, 0.032> <0.123, 0.206, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.162, 0.208, 0.002> <0.160, 0.204, 0.002> <0.155, 0.202, -0.001> <0.152, 0.199, -0.003> 
		<0.161, 0.209, -0.018> <0.159, 0.205, -0.018> <0.153, 0.203, -0.020> <0.150, 0.200, -0.021> 
		<0.147, 0.211, -0.043> <0.141, 0.209, -0.041> <0.133, 0.208, -0.040> <0.127, 0.207, -0.038> 
		<0.134, 0.209, -0.058> <0.128, 0.207, -0.056> <0.120, 0.208, -0.054> <0.115, 0.206, -0.052> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.152, 0.199, -0.003> <0.153, 0.199, 0.014> <0.133, 0.205, 0.032> <0.123, 0.206, 0.045> 
		<0.151, 0.198, -0.004> <0.152, 0.198, 0.013> <0.132, 0.205, 0.031> <0.121, 0.205, 0.044> 
		<0.148, 0.196, -0.005> <0.150, 0.196, 0.013> <0.130, 0.202, 0.031> <0.119, 0.203, 0.044> 
		<0.149, 0.194, -0.005> <0.150, 0.194, 0.012> <0.131, 0.201, 0.031> <0.120, 0.202, 0.044> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.152, 0.199, -0.003> <0.151, 0.198, -0.004> <0.148, 0.196, -0.005> <0.149, 0.194, -0.005> 
		<0.150, 0.200, -0.021> <0.149, 0.198, -0.022> <0.147, 0.196, -0.022> <0.147, 0.195, -0.022> 
		<0.127, 0.207, -0.038> <0.126, 0.206, -0.038> <0.124, 0.204, -0.037> <0.124, 0.204, -0.037> 
		<0.115, 0.206, -0.052> <0.114, 0.206, -0.051> <0.112, 0.204, -0.051> <0.112, 0.203, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.149, 0.194, -0.005> <0.150, 0.194, 0.012> <0.131, 0.201, 0.031> <0.120, 0.202, 0.044> 
		<0.150, 0.191, -0.005> <0.151, 0.191, 0.012> <0.139, 0.193, 0.034> <0.128, 0.193, 0.048> 
		<0.155, 0.189, -0.004> <0.156, 0.188, 0.014> <0.156, 0.188, 0.039> <0.145, 0.188, 0.052> 
		<0.156, 0.187, -0.004> <0.158, 0.185, 0.014> <0.163, 0.177, 0.042> <0.151, 0.178, 0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.149, 0.194, -0.005> <0.150, 0.191, -0.005> <0.155, 0.189, -0.004> <0.156, 0.187, -0.004> 
		<0.147, 0.195, -0.022> <0.148, 0.192, -0.023> <0.153, 0.191, -0.018> <0.155, 0.188, -0.018> 
		<0.124, 0.204, -0.037> <0.132, 0.198, -0.037> <0.145, 0.195, -0.038> <0.151, 0.187, -0.039> 
		<0.112, 0.203, -0.050> <0.120, 0.198, -0.050> <0.135, 0.195, -0.049> <0.141, 0.187, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.156, 0.187, -0.004> <0.158, 0.185, 0.014> <0.163, 0.177, 0.042> <0.151, 0.178, 0.056> 
		<0.159, 0.179, -0.004> <0.161, 0.178, 0.014> <0.167, 0.170, 0.045> <0.155, 0.170, 0.058> 
		<0.163, 0.169, -0.006> <0.163, 0.167, 0.015> <0.168, 0.157, 0.045> <0.153, 0.157, 0.061> 
		<0.165, 0.161, -0.007> <0.165, 0.159, 0.015> <0.166, 0.148, 0.047> <0.152, 0.148, 0.063> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.156, 0.187, -0.004> <0.159, 0.179, -0.004> <0.163, 0.169, -0.006> <0.165, 0.161, -0.007> 
		<0.155, 0.188, -0.018> <0.158, 0.180, -0.019> <0.162, 0.170, -0.022> <0.164, 0.162, -0.023> 
		<0.151, 0.187, -0.039> <0.156, 0.180, -0.041> <0.159, 0.168, -0.045> <0.159, 0.159, -0.046> 
		<0.141, 0.187, -0.050> <0.146, 0.180, -0.051> <0.147, 0.168, -0.057> <0.148, 0.159, -0.058> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.165, 0.161, -0.007> <0.165, 0.159, 0.015> <0.166, 0.148, 0.047> <0.152, 0.148, 0.063> 
		<0.166, 0.156, -0.007> <0.167, 0.154, 0.015> <0.166, 0.140, 0.048> <0.151, 0.140, 0.064> 
		<0.167, 0.150, -0.006> <0.167, 0.149, 0.017> <0.163, 0.131, 0.046> <0.148, 0.130, 0.063> 
		<0.166, 0.145, -0.006> <0.166, 0.144, 0.016> <0.160, 0.124, 0.046> <0.144, 0.123, 0.063> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.165, 0.161, -0.007> <0.166, 0.156, -0.007> <0.167, 0.150, -0.006> <0.166, 0.145, -0.006> 
		<0.164, 0.162, -0.023> <0.165, 0.158, -0.023> <0.167, 0.150, -0.024> <0.166, 0.146, -0.024> 
		<0.159, 0.159, -0.046> <0.160, 0.150, -0.048> <0.159, 0.139, -0.047> <0.157, 0.129, -0.047> 
		<0.148, 0.159, -0.058> <0.149, 0.150, -0.060> <0.147, 0.137, -0.060> <0.145, 0.128, -0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.166, 0.145, -0.006> <0.166, 0.144, 0.016> <0.160, 0.124, 0.046> <0.144, 0.123, 0.063> 
		<0.164, 0.134, -0.007> <0.164, 0.133, 0.016> <0.158, 0.121, 0.046> <0.143, 0.120, 0.063> 
		<0.161, 0.119, -0.008> <0.161, 0.119, 0.014> <0.151, 0.117, 0.046> <0.139, 0.118, 0.064> 
		<0.156, 0.109, -0.008> <0.155, 0.109, 0.014> <0.149, 0.117, 0.044> <0.137, 0.117, 0.063> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.166, 0.145, -0.006> <0.164, 0.134, -0.007> <0.161, 0.119, -0.008> <0.156, 0.109, -0.008> 
		<0.166, 0.146, -0.024> <0.165, 0.135, -0.025> <0.161, 0.119, -0.024> <0.156, 0.109, -0.024> 
		<0.157, 0.129, -0.047> <0.156, 0.126, -0.047> <0.151, 0.119, -0.047> <0.148, 0.117, -0.046> 
		<0.145, 0.128, -0.060> <0.144, 0.124, -0.060> <0.141, 0.118, -0.059> <0.137, 0.116, -0.057> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.156, 0.109, -0.008> <0.155, 0.109, 0.014> <0.149, 0.117, 0.044> <0.137, 0.117, 0.063> 
		<0.154, 0.106, -0.008> <0.154, 0.107, 0.014> <0.142, 0.115, 0.041> <0.130, 0.115, 0.059> 
		<0.148, 0.108, -0.007> <0.147, 0.108, 0.012> <0.132, 0.116, 0.036> <0.122, 0.116, 0.052> 
		<0.146, 0.106, -0.007> <0.145, 0.107, 0.012> <0.126, 0.115, 0.031> <0.116, 0.115, 0.047> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.156, 0.109, -0.008> <0.154, 0.106, -0.008> <0.148, 0.108, -0.007> <0.146, 0.106, -0.007> 
		<0.156, 0.109, -0.024> <0.154, 0.106, -0.024> <0.149, 0.107, -0.021> <0.146, 0.106, -0.020> 
		<0.148, 0.117, -0.046> <0.144, 0.114, -0.043> <0.135, 0.115, -0.039> <0.131, 0.113, -0.035> 
		<0.137, 0.116, -0.057> <0.133, 0.114, -0.054> <0.126, 0.115, -0.049> <0.121, 0.113, -0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.146, 0.106, -0.007> <0.145, 0.107, 0.012> <0.126, 0.115, 0.031> <0.116, 0.115, 0.047> 
		<0.144, 0.106, -0.006> <0.143, 0.106, 0.012> <0.125, 0.114, 0.031> <0.115, 0.115, 0.046> 
		<0.141, 0.104, -0.006> <0.140, 0.105, 0.011> <0.121, 0.114, 0.029> <0.112, 0.114, 0.044> 
		<0.141, 0.102, -0.006> <0.140, 0.103, 0.012> <0.122, 0.113, 0.029> <0.113, 0.113, 0.044> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.146, 0.106, -0.007> <0.144, 0.106, -0.006> <0.141, 0.104, -0.006> <0.141, 0.102, -0.006> 
		<0.146, 0.106, -0.020> <0.145, 0.105, -0.020> <0.142, 0.104, -0.019> <0.142, 0.102, -0.019> 
		<0.131, 0.113, -0.035> <0.130, 0.113, -0.034> <0.128, 0.111, -0.033> <0.128, 0.110, -0.033> 
		<0.121, 0.113, -0.045> <0.120, 0.113, -0.044> <0.119, 0.111, -0.043> <0.119, 0.110, -0.043> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.141, 0.102, -0.006> <0.140, 0.103, 0.012> <0.122, 0.113, 0.029> <0.113, 0.113, 0.044> 
		<0.141, 0.099, -0.006> <0.140, 0.100, 0.012> <0.129, 0.104, 0.035> <0.120, 0.104, 0.050> 
		<0.145, 0.096, -0.006> <0.145, 0.095, 0.015> <0.143, 0.096, 0.043> <0.132, 0.097, 0.060> 
		<0.146, 0.093, -0.005> <0.146, 0.092, 0.016> <0.149, 0.086, 0.046> <0.138, 0.086, 0.064> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.141, 0.102, -0.006> <0.141, 0.099, -0.006> <0.145, 0.096, -0.006> <0.146, 0.093, -0.005> 
		<0.142, 0.102, -0.019> <0.142, 0.099, -0.019> <0.145, 0.096, -0.023> <0.146, 0.093, -0.021> 
		<0.128, 0.110, -0.033> <0.134, 0.103, -0.038> <0.145, 0.097, -0.044> <0.150, 0.089, -0.047> 
		<0.119, 0.110, -0.043> <0.125, 0.103, -0.047> <0.134, 0.098, -0.056> <0.139, 0.090, -0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.146, 0.093, -0.005> <0.146, 0.092, 0.016> <0.149, 0.086, 0.046> <0.138, 0.086, 0.064> 
		<0.149, 0.084, -0.002> <0.149, 0.084, 0.019> <0.153, 0.078, 0.049> <0.142, 0.078, 0.066> 
		<0.153, 0.075, 0.007> <0.153, 0.074, 0.024> <0.156, 0.065, 0.052> <0.144, 0.065, 0.064> 
		<0.155, 0.066, 0.008> <0.155, 0.065, 0.025> <0.157, 0.055, 0.051> <0.145, 0.055, 0.064> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.146, 0.093, -0.005> <0.149, 0.084, -0.002> <0.153, 0.075, 0.007> <0.155, 0.066, 0.008> 
		<0.146, 0.093, -0.021> <0.149, 0.085, -0.018> <0.154, 0.076, -0.014> <0.155, 0.067, -0.013> 
		<0.150, 0.089, -0.047> <0.154, 0.083, -0.050> <0.159, 0.070, -0.045> <0.160, 0.062, -0.045> 
		<0.139, 0.090, -0.059> <0.143, 0.083, -0.062> <0.146, 0.071, -0.061> <0.147, 0.063, -0.062> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.155, 0.066, 0.008> <0.155, 0.065, 0.025> <0.157, 0.055, 0.051> <0.145, 0.055, 0.064> 
		<0.156, 0.059, 0.008> <0.156, 0.058, 0.026> <0.158, 0.046, 0.050> <0.147, 0.046, 0.063> 
		<0.157, 0.051, 0.002> <0.156, 0.049, 0.022> <0.161, 0.036, 0.045> <0.150, 0.032, 0.061> 
		<0.154, 0.046, -0.001> <0.153, 0.044, 0.019> <0.157, 0.027, 0.044> <0.146, 0.024, 0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.155, 0.066, 0.008> <0.156, 0.059, 0.008> <0.157, 0.051, 0.002> <0.154, 0.046, -0.001> 
		<0.155, 0.067, -0.013> <0.156, 0.061, -0.013> <0.157, 0.052, -0.017> <0.154, 0.047, -0.020> 
		<0.160, 0.062, -0.045> <0.161, 0.053, -0.046> <0.163, 0.042, -0.049> <0.159, 0.033, -0.049> 
		<0.147, 0.063, -0.062> <0.149, 0.054, -0.063> <0.151, 0.041, -0.065> <0.148, 0.033, -0.064> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.154, 0.046, -0.001> <0.153, 0.044, 0.019> <0.157, 0.027, 0.044> <0.146, 0.024, 0.060> 
		<0.152, 0.043, -0.003> <0.152, 0.041, 0.017> <0.154, 0.022, 0.043> <0.143, 0.018, 0.059> 
		<0.145, 0.043, -0.005> <0.145, 0.042, 0.017> <0.144, 0.023, 0.042> <0.133, 0.019, 0.060> 
		<0.142, 0.043, -0.006> <0.141, 0.042, 0.015> <0.138, 0.021, 0.041> <0.127, 0.017, 0.058> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.154, 0.046, -0.001> <0.152, 0.043, -0.003> <0.145, 0.043, -0.005> <0.142, 0.043, -0.006> 
		<0.154, 0.047, -0.020> <0.152, 0.044, -0.022> <0.146, 0.044, -0.022> <0.142, 0.044, -0.023> 
		<0.159, 0.033, -0.049> <0.157, 0.028, -0.048> <0.145, 0.028, -0.047> <0.140, 0.025, -0.045> 
		<0.148, 0.033, -0.064> <0.145, 0.027, -0.064> <0.136, 0.026, -0.061> <0.130, 0.023, -0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.142, 0.043, -0.006> <0.141, 0.042, 0.015> <0.138, 0.021, 0.041> <0.127, 0.017, 0.058> 
		<0.139, 0.043, -0.007> <0.138, 0.041, 0.014> <0.136, 0.021, 0.040> <0.125, 0.016, 0.058> 
		<0.134, 0.043, -0.007> <0.134, 0.043, 0.013> <0.132, 0.021, 0.038> <0.122, 0.017, 0.054> 
		<0.131, 0.043, -0.008> <0.131, 0.042, 0.012> <0.130, 0.021, 0.036> <0.120, 0.016, 0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.142, 0.043, -0.006> <0.139, 0.043, -0.007> <0.134, 0.043, -0.007> <0.131, 0.043, -0.008> 
		<0.142, 0.044, -0.023> <0.139, 0.043, -0.024> <0.134, 0.044, -0.023> <0.131, 0.043, -0.023> 
		<0.140, 0.025, -0.045> <0.137, 0.024, -0.043> <0.132, 0.024, -0.042> <0.129, 0.023, -0.040> 
		<0.130, 0.023, -0.059> <0.127, 0.022, -0.057> <0.123, 0.021, -0.054> <0.120, 0.020, -0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.131, 0.043, -0.008> <0.131, 0.042, 0.012> <0.130, 0.021, 0.036> <0.120, 0.016, 0.053> 
		<0.130, 0.043, -0.008> <0.130, 0.042, 0.012> <0.130, 0.021, 0.035> <0.119, 0.016, 0.052> 
		<0.128, 0.042, -0.009> <0.129, 0.042, 0.011> <0.128, 0.020, 0.034> <0.118, 0.016, 0.051> 
		<0.129, 0.042, -0.009> <0.129, 0.041, 0.011> <0.128, 0.019, 0.034> <0.118, 0.015, 0.051> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.131, 0.043, -0.008> <0.130, 0.043, -0.008> <0.128, 0.042, -0.009> <0.129, 0.042, -0.009> 
		<0.131, 0.043, -0.023> <0.130, 0.043, -0.024> <0.128, 0.043, -0.024> <0.128, 0.042, -0.024> 
		<0.129, 0.023, -0.040> <0.128, 0.022, -0.040> <0.125, 0.022, -0.039> <0.125, 0.021, -0.039> 
		<0.120, 0.020, -0.053> <0.119, 0.019, -0.052> <0.116, 0.019, -0.051> <0.116, 0.017, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.129, 0.042, -0.009> <0.129, 0.041, 0.011> <0.128, 0.019, 0.034> <0.118, 0.015, 0.051> 
		<0.129, 0.040, -0.010> <0.129, 0.040, 0.010> <0.129, 0.018, 0.035> <0.118, 0.014, 0.052> 
		<0.132, 0.040, -0.010> <0.132, 0.040, 0.011> <0.131, 0.019, 0.036> <0.120, 0.014, 0.053> 
		<0.132, 0.038, -0.010> <0.133, 0.038, 0.011> <0.132, 0.017, 0.037> <0.121, 0.013, 0.054> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.129, 0.042, -0.009> <0.129, 0.040, -0.010> <0.132, 0.040, -0.010> <0.132, 0.038, -0.010> 
		<0.128, 0.042, -0.024> <0.129, 0.040, -0.025> <0.132, 0.040, -0.025> <0.132, 0.038, -0.025> 
		<0.125, 0.021, -0.039> <0.125, 0.019, -0.038> <0.128, 0.019, -0.040> <0.128, 0.018, -0.039> 
		<0.116, 0.017, -0.050> <0.116, 0.016, -0.050> <0.120, 0.016, -0.052> <0.120, 0.014, -0.052> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.132, 0.038, -0.010> <0.133, 0.038, 0.011> <0.132, 0.017, 0.037> <0.121, 0.013, 0.054> 
		<0.133, 0.037, -0.010> <0.133, 0.037, 0.011> <0.132, 0.017, 0.037> <0.121, 0.012, 0.054> 
		<0.130, 0.037, -0.009> <0.131, 0.037, 0.011> <0.130, 0.017, 0.036> <0.120, 0.012, 0.053> 
		<0.129, 0.036, -0.009> <0.130, 0.036, 0.011> <0.130, 0.016, 0.036> <0.119, 0.012, 0.052> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.132, 0.038, -0.010> <0.133, 0.037, -0.010> <0.130, 0.037, -0.009> <0.129, 0.036, -0.009> 
		<0.132, 0.038, -0.025> <0.132, 0.037, -0.025> <0.130, 0.037, -0.024> <0.129, 0.036, -0.024> 
		<0.128, 0.018, -0.039> <0.128, 0.016, -0.039> <0.125, 0.016, -0.038> <0.124, 0.015, -0.037> 
		<0.120, 0.014, -0.052> <0.120, 0.013, -0.051> <0.117, 0.012, -0.050> <0.116, 0.011, -0.049> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.144, 0.405, 0.000> <0.143, 0.409, 0.003> <0.137, 0.411, 0.010> <0.137, 0.416, 0.010> 
		<0.145, 0.405, 0.023> <0.144, 0.409, 0.026> <0.137, 0.411, 0.031> <0.137, 0.416, 0.031> 
		<0.144, 0.406, 0.055> <0.147, 0.413, 0.058> <0.135, 0.413, 0.059> <0.137, 0.420, 0.061> 
		<0.135, 0.405, 0.076> <0.138, 0.412, 0.079> <0.138, 0.424, 0.076> <0.140, 0.432, 0.077> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.144, 0.405, 0.000> <0.145, 0.405, 0.023> <0.144, 0.406, 0.055> <0.135, 0.405, 0.076> 
		<0.143, 0.409, 0.003> <0.144, 0.409, 0.026> <0.147, 0.413, 0.058> <0.138, 0.412, 0.079> 
		<0.137, 0.411, 0.010> <0.137, 0.411, 0.031> <0.144, 0.423, 0.056> <0.138, 0.424, 0.076> 
		<0.137, 0.416, 0.010> <0.137, 0.416, 0.031> <0.146, 0.431, 0.058> <0.140, 0.432, 0.077> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.144, 0.405, 0.000> <0.144, 0.405, -0.015> <0.136, 0.406, -0.036> <0.130, 0.405, -0.050> 
		<0.143, 0.409, 0.003> <0.143, 0.409, -0.013> <0.139, 0.414, -0.038> <0.133, 0.413, -0.052> 
		<0.137, 0.411, 0.010> <0.137, 0.411, -0.011> <0.134, 0.412, -0.038> <0.137, 0.424, -0.055> 
		<0.137, 0.416, 0.010> <0.137, 0.416, -0.010> <0.137, 0.420, -0.040> <0.140, 0.432, -0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.144, 0.405, 0.000> <0.144, 0.405, -0.015> <0.136, 0.406, -0.036> <0.130, 0.405, -0.050> 
		<0.143, 0.409, 0.003> <0.143, 0.409, -0.013> <0.139, 0.414, -0.038> <0.133, 0.413, -0.052> 
		<0.137, 0.411, 0.010> <0.137, 0.411, -0.011> <0.142, 0.425, -0.034> <0.137, 0.424, -0.055> 
		<0.137, 0.416, 0.010> <0.137, 0.416, -0.010> <0.145, 0.433, -0.036> <0.140, 0.432, -0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.095, 0.511, -0.076> <0.105, 0.498, -0.084> <0.116, 0.478, -0.096> <0.118, 0.461, -0.104> 
		<0.109, 0.510, -0.073> <0.120, 0.498, -0.081> <0.131, 0.479, -0.092> <0.133, 0.463, -0.100> 
		<0.133, 0.508, -0.069> <0.133, 0.499, -0.079> <0.149, 0.482, -0.080> <0.149, 0.469, -0.080> 
		<0.140, 0.512, -0.056> <0.141, 0.503, -0.066> <0.152, 0.483, -0.065> <0.152, 0.470, -0.065> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.095, 0.511, -0.076> <0.109, 0.510, -0.073> <0.133, 0.508, -0.069> <0.140, 0.512, -0.056> 
		<0.080, 0.528, -0.066> <0.095, 0.527, -0.062> <0.116, 0.526, -0.061> <0.123, 0.530, -0.049> 
		<0.051, 0.538, -0.047> <0.062, 0.539, -0.042> <0.081, 0.537, -0.043> <0.088, 0.537, -0.034> 
		<0.036, 0.557, -0.045> <0.047, 0.558, -0.040> <0.064, 0.555, -0.037> <0.071, 0.555, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.095, 0.511, -0.076> <0.109, 0.510, -0.073> <0.133, 0.508, -0.069> <0.140, 0.512, -0.056> 
		<0.105, 0.498, -0.084> <0.120, 0.498, -0.081> <0.141, 0.499, -0.073> <0.149, 0.503, -0.060> 
		<0.116, 0.478, -0.096> <0.131, 0.479, -0.092> <0.149, 0.482, -0.080> <0.152, 0.483, -0.065> 
		<0.118, 0.461, -0.104> <0.133, 0.463, -0.100> <0.149, 0.469, -0.080> <0.152, 0.470, -0.065> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.095, 0.511, -0.076> <0.080, 0.528, -0.066> <0.051, 0.538, -0.047> <0.036, 0.557, -0.045> 
		<0.066, 0.513, -0.083> <0.052, 0.529, -0.073> <0.042, 0.538, -0.051> <0.027, 0.557, -0.049> 
		<0.027, 0.517, -0.093> <0.029, 0.530, -0.086> <0.015, 0.540, -0.061> <0.014, 0.554, -0.058> 
		<-0.002, 0.519, -0.090> <-0.000, 0.532, -0.084> <0.004, 0.540, -0.061> <0.004, 0.554, -0.058> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.095, 0.511, -0.076> <0.066, 0.513, -0.083> <0.027, 0.517, -0.093> <-0.002, 0.519, -0.090> 
		<0.105, 0.498, -0.084> <0.077, 0.500, -0.091> <0.025, 0.499, -0.101> <-0.004, 0.502, -0.099> 
		<0.116, 0.478, -0.096> <0.080, 0.475, -0.106> <0.030, 0.476, -0.101> <-0.008, 0.475, -0.101> 
		<0.118, 0.461, -0.104> <0.081, 0.458, -0.113> <0.030, 0.457, -0.106> <-0.007, 0.456, -0.107> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.002, 0.519, -0.090> <-0.000, 0.532, -0.084> <0.004, 0.540, -0.061> <0.004, 0.554, -0.058> 
		<-0.030, 0.521, -0.088> <-0.028, 0.534, -0.082> <-0.009, 0.540, -0.061> <-0.009, 0.554, -0.059> 
		<-0.064, 0.528, -0.069> <-0.053, 0.541, -0.061> <-0.038, 0.542, -0.050> <-0.026, 0.557, -0.052> 
		<-0.092, 0.526, -0.062> <-0.081, 0.540, -0.054> <-0.050, 0.542, -0.045> <-0.038, 0.556, -0.047> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.002, 0.519, -0.090> <-0.030, 0.521, -0.088> <-0.064, 0.528, -0.069> <-0.092, 0.526, -0.062> 
		<-0.004, 0.502, -0.099> <-0.032, 0.504, -0.097> <-0.079, 0.509, -0.080> <-0.107, 0.507, -0.073> 
		<-0.008, 0.475, -0.101> <-0.041, 0.474, -0.102> <-0.084, 0.475, -0.104> <-0.116, 0.478, -0.095> 
		<-0.007, 0.456, -0.107> <-0.041, 0.455, -0.107> <-0.087, 0.452, -0.116> <-0.119, 0.455, -0.106> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.092, 0.526, -0.062> <-0.106, 0.525, -0.059> <-0.131, 0.510, -0.069> <-0.140, 0.512, -0.056> 
		<-0.107, 0.507, -0.073> <-0.121, 0.507, -0.070> <-0.132, 0.501, -0.078> <-0.141, 0.503, -0.066> 
		<-0.116, 0.478, -0.095> <-0.132, 0.480, -0.090> <-0.149, 0.482, -0.081> <-0.152, 0.483, -0.065> 
		<-0.119, 0.455, -0.106> <-0.135, 0.456, -0.102> <-0.149, 0.468, -0.081> <-0.152, 0.470, -0.065> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.092, 0.526, -0.062> <-0.081, 0.540, -0.054> <-0.050, 0.542, -0.045> <-0.038, 0.556, -0.047> 
		<-0.106, 0.525, -0.059> <-0.096, 0.539, -0.051> <-0.061, 0.542, -0.042> <-0.049, 0.556, -0.043> 
		<-0.131, 0.510, -0.069> <-0.114, 0.527, -0.061> <-0.082, 0.534, -0.045> <-0.065, 0.552, -0.040> 
		<-0.140, 0.512, -0.056> <-0.123, 0.529, -0.049> <-0.088, 0.535, -0.037> <-0.071, 0.552, -0.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.092, 0.526, -0.062> <-0.106, 0.525, -0.059> <-0.131, 0.510, -0.069> <-0.140, 0.512, -0.056> 
		<-0.107, 0.507, -0.073> <-0.121, 0.507, -0.070> <-0.140, 0.501, -0.072> <-0.149, 0.502, -0.060> 
		<-0.116, 0.478, -0.095> <-0.132, 0.480, -0.090> <-0.149, 0.482, -0.081> <-0.152, 0.483, -0.065> 
		<-0.119, 0.455, -0.106> <-0.135, 0.456, -0.102> <-0.149, 0.468, -0.081> <-0.152, 0.470, -0.065> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.083, 0.510, 0.090> <-0.090, 0.498, 0.092> <-0.093, 0.480, 0.097> <-0.097, 0.467, 0.099> 
		<-0.100, 0.510, 0.087> <-0.107, 0.499, 0.089> <-0.109, 0.481, 0.093> <-0.113, 0.468, 0.096> 
		<-0.129, 0.507, 0.091> <-0.130, 0.498, 0.100> <-0.146, 0.483, 0.102> <-0.146, 0.469, 0.102> 
		<-0.140, 0.512, 0.077> <-0.141, 0.503, 0.087> <-0.152, 0.483, 0.086> <-0.152, 0.470, 0.086> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.083, 0.510, 0.090> <-0.100, 0.510, 0.087> <-0.129, 0.507, 0.091> <-0.140, 0.512, 0.077> 
		<-0.073, 0.526, 0.087> <-0.091, 0.526, 0.084> <-0.113, 0.526, 0.084> <-0.124, 0.531, 0.070> 
		<-0.049, 0.539, 0.083> <-0.061, 0.540, 0.077> <-0.085, 0.542, 0.069> <-0.091, 0.542, 0.058> 
		<-0.042, 0.556, 0.082> <-0.054, 0.557, 0.076> <-0.067, 0.560, 0.064> <-0.074, 0.561, 0.052> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.083, 0.510, 0.090> <-0.100, 0.510, 0.087> <-0.129, 0.507, 0.091> <-0.140, 0.512, 0.077> 
		<-0.090, 0.498, 0.092> <-0.107, 0.499, 0.089> <-0.138, 0.497, 0.094> <-0.149, 0.502, 0.081> 
		<-0.093, 0.480, 0.097> <-0.109, 0.481, 0.093> <-0.146, 0.483, 0.102> <-0.152, 0.483, 0.086> 
		<-0.097, 0.467, 0.099> <-0.113, 0.468, 0.096> <-0.146, 0.469, 0.102> <-0.152, 0.470, 0.086> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.083, 0.510, 0.090> <-0.073, 0.526, 0.087> <-0.049, 0.539, 0.083> <-0.042, 0.556, 0.082> 
		<-0.055, 0.509, 0.095> <-0.045, 0.525, 0.092> <-0.037, 0.538, 0.089> <-0.029, 0.555, 0.088> 
		<-0.017, 0.508, 0.104> <-0.017, 0.522, 0.099> <-0.008, 0.539, 0.089> <-0.010, 0.554, 0.089> 
		<0.011, 0.509, 0.104> <0.011, 0.523, 0.099> <0.005, 0.540, 0.089> <0.004, 0.554, 0.088> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.083, 0.510, 0.090> <-0.055, 0.509, 0.095> <-0.017, 0.508, 0.104> <0.011, 0.509, 0.104> 
		<-0.090, 0.498, 0.092> <-0.062, 0.498, 0.097> <-0.018, 0.494, 0.109> <0.011, 0.494, 0.110> 
		<-0.093, 0.480, 0.097> <-0.063, 0.478, 0.104> <-0.025, 0.477, 0.116> <0.006, 0.476, 0.117> 
		<-0.097, 0.467, 0.099> <-0.067, 0.465, 0.106> <-0.027, 0.462, 0.121> <0.003, 0.461, 0.122> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.011, 0.509, 0.104> <0.011, 0.523, 0.099> <0.005, 0.540, 0.089> <0.004, 0.554, 0.088> 
		<0.032, 0.510, 0.105> <0.032, 0.523, 0.100> <0.016, 0.540, 0.088> <0.015, 0.555, 0.088> 
		<0.059, 0.515, 0.098> <0.051, 0.531, 0.094> <0.037, 0.541, 0.085> <0.029, 0.558, 0.084> 
		<0.079, 0.515, 0.094> <0.071, 0.531, 0.089> <0.046, 0.542, 0.079> <0.038, 0.559, 0.078> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.011, 0.509, 0.104> <0.032, 0.510, 0.105> <0.059, 0.515, 0.098> <0.079, 0.515, 0.094> 
		<0.011, 0.494, 0.110> <0.032, 0.495, 0.110> <0.066, 0.500, 0.103> <0.086, 0.500, 0.098> 
		<0.006, 0.476, 0.117> <0.031, 0.475, 0.118> <0.056, 0.475, 0.112> <0.081, 0.477, 0.106> 
		<0.003, 0.461, 0.122> <0.029, 0.460, 0.123> <0.062, 0.460, 0.112> <0.086, 0.461, 0.106> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.079, 0.515, 0.094> <0.098, 0.515, 0.090> <0.128, 0.508, 0.092> <0.140, 0.512, 0.077> 
		<0.086, 0.500, 0.098> <0.105, 0.501, 0.094> <0.129, 0.499, 0.102> <0.141, 0.503, 0.087> 
		<0.081, 0.477, 0.106> <0.101, 0.478, 0.101> <0.144, 0.482, 0.105> <0.152, 0.483, 0.086> 
		<0.086, 0.461, 0.106> <0.106, 0.462, 0.102> <0.144, 0.469, 0.105> <0.152, 0.470, 0.086> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.079, 0.515, 0.094> <0.071, 0.531, 0.089> <0.046, 0.542, 0.079> <0.038, 0.559, 0.078> 
		<0.098, 0.515, 0.090> <0.090, 0.532, 0.085> <0.056, 0.543, 0.074> <0.048, 0.560, 0.072> 
		<0.128, 0.508, 0.092> <0.110, 0.528, 0.084> <0.077, 0.542, 0.067> <0.058, 0.561, 0.061> 
		<0.140, 0.512, 0.077> <0.121, 0.532, 0.070> <0.084, 0.542, 0.058> <0.065, 0.561, 0.051> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.079, 0.515, 0.094> <0.098, 0.515, 0.090> <0.128, 0.508, 0.092> <0.140, 0.512, 0.077> 
		<0.086, 0.500, 0.098> <0.105, 0.501, 0.094> <0.137, 0.498, 0.095> <0.149, 0.503, 0.081> 
		<0.081, 0.477, 0.106> <0.101, 0.478, 0.101> <0.144, 0.482, 0.105> <0.152, 0.483, 0.086> 
		<0.086, 0.461, 0.106> <0.106, 0.462, 0.102> <0.144, 0.469, 0.105> <0.152, 0.470, 0.086> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.118, 0.461, -0.104> <0.119, 0.446, -0.110> <0.112, 0.425, -0.118> <0.105, 0.410, -0.121> 
		<0.133, 0.463, -0.100> <0.134, 0.448, -0.106> <0.132, 0.429, -0.108> <0.126, 0.414, -0.111> 
		<0.149, 0.469, -0.080> <0.149, 0.457, -0.080> <0.137, 0.438, -0.088> <0.135, 0.431, -0.079> 
		<0.152, 0.470, -0.065> <0.152, 0.458, -0.065> <0.142, 0.439, -0.066> <0.140, 0.432, -0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.118, 0.461, -0.104> <0.133, 0.463, -0.100> <0.149, 0.469, -0.080> <0.152, 0.470, -0.065> 
		<0.119, 0.446, -0.110> <0.134, 0.448, -0.106> <0.149, 0.457, -0.080> <0.152, 0.458, -0.065> 
		<0.112, 0.425, -0.118> <0.132, 0.429, -0.108> <0.139, 0.442, -0.081> <0.144, 0.443, -0.059> 
		<0.105, 0.410, -0.121> <0.126, 0.414, -0.111> <0.135, 0.431, -0.079> <0.140, 0.432, -0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.118, 0.461, -0.104> <0.081, 0.458, -0.113> <0.030, 0.457, -0.106> <-0.007, 0.456, -0.107> 
		<0.119, 0.446, -0.110> <0.083, 0.443, -0.120> <0.031, 0.441, -0.111> <-0.006, 0.440, -0.111> 
		<0.112, 0.425, -0.118> <0.084, 0.420, -0.131> <0.032, 0.422, -0.120> <0.002, 0.422, -0.120> 
		<0.105, 0.410, -0.121> <0.078, 0.405, -0.134> <0.034, 0.407, -0.123> <0.003, 0.406, -0.123> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.007, 0.456, -0.107> <-0.041, 0.455, -0.107> <-0.087, 0.452, -0.116> <-0.119, 0.455, -0.106> 
		<-0.006, 0.440, -0.111> <-0.040, 0.439, -0.112> <-0.089, 0.438, -0.122> <-0.121, 0.441, -0.113> 
		<0.002, 0.422, -0.120> <-0.032, 0.421, -0.120> <-0.083, 0.416, -0.133> <-0.112, 0.422, -0.119> 
		<0.003, 0.406, -0.123> <-0.030, 0.406, -0.123> <-0.077, 0.402, -0.135> <-0.107, 0.407, -0.121> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.119, 0.455, -0.106> <-0.135, 0.456, -0.102> <-0.149, 0.468, -0.081> <-0.152, 0.470, -0.065> 
		<-0.121, 0.441, -0.113> <-0.137, 0.443, -0.109> <-0.149, 0.456, -0.081> <-0.152, 0.458, -0.065> 
		<-0.112, 0.422, -0.119> <-0.133, 0.425, -0.110> <-0.137, 0.438, -0.089> <-0.142, 0.439, -0.066> 
		<-0.107, 0.407, -0.121> <-0.128, 0.411, -0.111> <-0.135, 0.431, -0.079> <-0.140, 0.433, -0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.119, 0.455, -0.106> <-0.135, 0.456, -0.102> <-0.149, 0.468, -0.081> <-0.152, 0.470, -0.065> 
		<-0.121, 0.441, -0.113> <-0.137, 0.443, -0.109> <-0.149, 0.456, -0.081> <-0.152, 0.458, -0.065> 
		<-0.112, 0.422, -0.119> <-0.133, 0.425, -0.110> <-0.139, 0.442, -0.082> <-0.144, 0.444, -0.059> 
		<-0.107, 0.407, -0.121> <-0.128, 0.411, -0.111> <-0.135, 0.431, -0.079> <-0.140, 0.433, -0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.097, 0.467, 0.099> <-0.101, 0.451, 0.102> <-0.111, 0.430, 0.105> <-0.111, 0.414, 0.108> 
		<-0.113, 0.468, 0.096> <-0.118, 0.452, 0.099> <-0.124, 0.432, 0.100> <-0.124, 0.415, 0.103> 
		<-0.146, 0.469, 0.102> <-0.147, 0.457, 0.102> <-0.139, 0.439, 0.101> <-0.137, 0.432, 0.091> 
		<-0.152, 0.470, 0.086> <-0.152, 0.458, 0.086> <-0.142, 0.439, 0.087> <-0.140, 0.433, 0.077> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.097, 0.467, 0.099> <-0.113, 0.468, 0.096> <-0.146, 0.469, 0.102> <-0.152, 0.470, 0.086> 
		<-0.101, 0.451, 0.102> <-0.118, 0.452, 0.099> <-0.147, 0.457, 0.102> <-0.152, 0.458, 0.086> 
		<-0.111, 0.430, 0.105> <-0.124, 0.432, 0.100> <-0.139, 0.444, 0.093> <-0.143, 0.444, 0.079> 
		<-0.111, 0.414, 0.108> <-0.124, 0.415, 0.103> <-0.137, 0.432, 0.091> <-0.140, 0.433, 0.077> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.097, 0.467, 0.099> <-0.067, 0.465, 0.106> <-0.027, 0.462, 0.121> <0.003, 0.461, 0.122> 
		<-0.101, 0.451, 0.102> <-0.071, 0.449, 0.109> <-0.029, 0.448, 0.124> <0.001, 0.447, 0.126> 
		<-0.111, 0.430, 0.105> <-0.080, 0.426, 0.117> <-0.036, 0.428, 0.133> <-0.003, 0.429, 0.131> 
		<-0.111, 0.414, 0.108> <-0.080, 0.410, 0.120> <-0.036, 0.414, 0.134> <-0.003, 0.415, 0.132> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.003, 0.461, 0.122> <0.029, 0.460, 0.123> <0.062, 0.460, 0.112> <0.086, 0.461, 0.106> 
		<0.001, 0.447, 0.126> <0.027, 0.447, 0.127> <0.066, 0.446, 0.113> <0.091, 0.447, 0.107> 
		<-0.003, 0.429, 0.131> <0.033, 0.431, 0.129> <0.075, 0.432, 0.108> <0.108, 0.436, 0.095> 
		<-0.003, 0.415, 0.132> <0.033, 0.416, 0.130> <0.078, 0.418, 0.109> <0.111, 0.422, 0.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.086, 0.461, 0.106> <0.106, 0.462, 0.102> <0.144, 0.469, 0.105> <0.152, 0.470, 0.086> 
		<0.091, 0.447, 0.107> <0.111, 0.449, 0.102> <0.144, 0.457, 0.105> <0.152, 0.458, 0.086> 
		<0.108, 0.436, 0.095> <0.119, 0.437, 0.091> <0.139, 0.440, 0.097> <0.142, 0.439, 0.087> 
		<0.111, 0.422, 0.096> <0.121, 0.423, 0.092> <0.137, 0.433, 0.088> <0.140, 0.432, 0.077> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.086, 0.461, 0.106> <0.106, 0.462, 0.102> <0.144, 0.469, 0.105> <0.152, 0.470, 0.086> 
		<0.091, 0.447, 0.107> <0.111, 0.449, 0.102> <0.144, 0.457, 0.105> <0.152, 0.458, 0.086> 
		<0.108, 0.436, 0.095> <0.119, 0.437, 0.091> <0.140, 0.444, 0.090> <0.143, 0.444, 0.079> 
		<0.111, 0.422, 0.096> <0.121, 0.423, 0.092> <0.137, 0.433, 0.088> <0.140, 0.432, 0.077> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.105, 0.410, -0.121> <0.126, 0.414, -0.111> <0.135, 0.431, -0.079> <0.140, 0.432, -0.056> 
		<0.103, 0.405, -0.122> <0.123, 0.409, -0.112> <0.132, 0.423, -0.077> <0.137, 0.424, -0.055> 
		<0.094, 0.401, -0.118> <0.113, 0.404, -0.107> <0.123, 0.412, -0.073> <0.133, 0.413, -0.052> 
		<0.090, 0.397, -0.115> <0.110, 0.400, -0.104> <0.120, 0.404, -0.071> <0.130, 0.405, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.105, 0.410, -0.121> <0.078, 0.405, -0.134> <0.034, 0.407, -0.123> <0.003, 0.406, -0.123> 
		<0.103, 0.405, -0.122> <0.076, 0.400, -0.135> <0.035, 0.400, -0.125> <0.004, 0.400, -0.125> 
		<0.094, 0.401, -0.118> <0.071, 0.397, -0.132> <0.029, 0.390, -0.126> <0.002, 0.390, -0.126> 
		<0.090, 0.397, -0.115> <0.067, 0.393, -0.128> <0.029, 0.384, -0.124> <0.002, 0.384, -0.124> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.003, 0.406, -0.123> <-0.030, 0.406, -0.123> <-0.077, 0.402, -0.135> <-0.107, 0.407, -0.121> 
		<0.004, 0.400, -0.125> <-0.029, 0.399, -0.125> <-0.076, 0.397, -0.135> <-0.105, 0.403, -0.122> 
		<0.002, 0.390, -0.126> <-0.028, 0.390, -0.126> <-0.074, 0.394, -0.131> <-0.100, 0.398, -0.117> 
		<0.002, 0.384, -0.124> <-0.028, 0.384, -0.124> <-0.071, 0.391, -0.128> <-0.097, 0.395, -0.114> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.107, 0.407, -0.121> <-0.128, 0.411, -0.111> <-0.135, 0.431, -0.079> <-0.140, 0.433, -0.056> 
		<-0.105, 0.403, -0.122> <-0.126, 0.406, -0.112> <-0.133, 0.423, -0.077> <-0.138, 0.424, -0.055> 
		<-0.100, 0.398, -0.117> <-0.119, 0.401, -0.107> <-0.128, 0.412, -0.071> <-0.136, 0.413, -0.051> 
		<-0.097, 0.395, -0.114> <-0.116, 0.398, -0.103> <-0.125, 0.403, -0.071> <-0.133, 0.405, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.111, 0.414, 0.108> <-0.111, 0.406, 0.110> <-0.100, 0.400, 0.114> <-0.096, 0.394, 0.112> 
		<-0.124, 0.415, 0.103> <-0.124, 0.408, 0.104> <-0.116, 0.402, 0.109> <-0.112, 0.396, 0.107> 
		<-0.137, 0.432, 0.091> <-0.135, 0.424, 0.090> <-0.135, 0.410, 0.095> <-0.131, 0.404, 0.092> 
		<-0.140, 0.433, 0.077> <-0.139, 0.425, 0.076> <-0.141, 0.412, 0.080> <-0.137, 0.405, 0.076> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.111, 0.414, 0.108> <-0.080, 0.410, 0.120> <-0.036, 0.414, 0.134> <-0.003, 0.415, 0.132> 
		<-0.111, 0.406, 0.110> <-0.080, 0.403, 0.122> <-0.036, 0.404, 0.134> <-0.003, 0.405, 0.132> 
		<-0.100, 0.400, 0.114> <-0.072, 0.396, 0.124> <-0.028, 0.391, 0.130> <0.003, 0.392, 0.129> 
		<-0.096, 0.394, 0.112> <-0.068, 0.390, 0.122> <-0.026, 0.383, 0.124> <0.004, 0.384, 0.124> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.003, 0.415, 0.132> <0.033, 0.416, 0.130> <0.078, 0.418, 0.109> <0.111, 0.422, 0.096> 
		<-0.003, 0.405, 0.132> <0.033, 0.406, 0.130> <0.079, 0.409, 0.109> <0.112, 0.413, 0.097> 
		<0.003, 0.392, 0.129> <0.031, 0.393, 0.129> <0.074, 0.403, 0.120> <0.101, 0.407, 0.110> 
		<0.004, 0.384, 0.124> <0.032, 0.384, 0.124> <0.070, 0.395, 0.120> <0.096, 0.399, 0.110> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.111, 0.422, 0.096> <0.121, 0.423, 0.092> <0.137, 0.433, 0.088> <0.140, 0.432, 0.077> 
		<0.112, 0.413, 0.097> <0.122, 0.414, 0.093> <0.135, 0.425, 0.087> <0.138, 0.424, 0.076> 
		<0.101, 0.407, 0.110> <0.115, 0.410, 0.105> <0.132, 0.411, 0.093> <0.138, 0.412, 0.079> 
		<0.096, 0.399, 0.110> <0.111, 0.402, 0.105> <0.128, 0.405, 0.090> <0.135, 0.405, 0.076> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.130, 0.405, -0.050> <0.127, 0.397, -0.048> <0.120, 0.387, -0.041> <0.121, 0.378, -0.041> 
		<0.120, 0.404, -0.071> <0.117, 0.396, -0.068> <0.105, 0.383, -0.056> <0.107, 0.374, -0.056> 
		<0.110, 0.400, -0.104> <0.103, 0.391, -0.097> <0.094, 0.379, -0.086> <0.089, 0.369, -0.078> 
		<0.090, 0.397, -0.115> <0.083, 0.388, -0.108> <0.076, 0.377, -0.096> <0.071, 0.367, -0.088> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.090, 0.397, -0.115> <0.067, 0.393, -0.128> <0.029, 0.384, -0.124> <0.002, 0.384, -0.124> 
		<0.083, 0.388, -0.108> <0.060, 0.384, -0.122> <0.028, 0.377, -0.121> <0.001, 0.377, -0.121> 
		<0.076, 0.377, -0.096> <0.058, 0.375, -0.106> <0.024, 0.372, -0.109> <0.003, 0.373, -0.109> 
		<0.071, 0.367, -0.088> <0.052, 0.365, -0.098> <0.024, 0.365, -0.108> <0.002, 0.365, -0.107> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.002, 0.384, -0.124> <-0.028, 0.384, -0.124> <-0.071, 0.391, -0.128> <-0.097, 0.395, -0.114> 
		<0.001, 0.377, -0.121> <-0.029, 0.377, -0.121> <-0.066, 0.383, -0.121> <-0.092, 0.387, -0.106> 
		<0.003, 0.373, -0.109> <-0.023, 0.374, -0.108> <-0.062, 0.379, -0.104> <-0.085, 0.380, -0.094> 
		<0.002, 0.365, -0.107> <-0.023, 0.366, -0.107> <-0.057, 0.371, -0.096> <-0.081, 0.373, -0.086> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.097, 0.395, -0.114> <-0.116, 0.398, -0.103> <-0.125, 0.403, -0.071> <-0.133, 0.405, -0.050> 
		<-0.092, 0.387, -0.106> <-0.111, 0.391, -0.096> <-0.122, 0.394, -0.070> <-0.129, 0.396, -0.049> 
		<-0.085, 0.380, -0.094> <-0.099, 0.381, -0.087> <-0.112, 0.384, -0.063> <-0.120, 0.384, -0.051> 
		<-0.081, 0.373, -0.086> <-0.094, 0.374, -0.079> <-0.110, 0.374, -0.065> <-0.119, 0.374, -0.052> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.133, 0.405, -0.050> <-0.136, 0.413, -0.051> <-0.138, 0.424, -0.055> <-0.140, 0.433, -0.056> 
		<-0.138, 0.407, -0.036> <-0.141, 0.415, -0.036> <-0.135, 0.413, -0.038> <-0.137, 0.421, -0.040> 
		<-0.138, 0.405, -0.015> <-0.138, 0.410, -0.014> <-0.136, 0.412, -0.011> <-0.137, 0.416, -0.010> 
		<-0.139, 0.405, 0.000> <-0.139, 0.410, 0.001> <-0.136, 0.412, 0.010> <-0.137, 0.416, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.133, 0.405, -0.050> <-0.138, 0.407, -0.036> <-0.138, 0.405, -0.015> <-0.139, 0.405, 0.000> 
		<-0.136, 0.413, -0.051> <-0.141, 0.415, -0.036> <-0.138, 0.410, -0.014> <-0.139, 0.410, 0.001> 
		<-0.138, 0.424, -0.055> <-0.142, 0.426, -0.034> <-0.136, 0.412, -0.011> <-0.136, 0.412, 0.010> 
		<-0.140, 0.433, -0.056> <-0.145, 0.434, -0.036> <-0.137, 0.416, -0.010> <-0.137, 0.416, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.133, 0.405, -0.050> <-0.138, 0.407, -0.036> <-0.138, 0.405, -0.015> <-0.139, 0.405, 0.000> 
		<-0.129, 0.396, -0.049> <-0.134, 0.397, -0.035> <-0.139, 0.395, -0.016> <-0.140, 0.395, -0.001> 
		<-0.120, 0.384, -0.051> <-0.130, 0.384, -0.035> <-0.140, 0.381, -0.014> <-0.139, 0.382, 0.004> 
		<-0.119, 0.374, -0.052> <-0.129, 0.373, -0.037> <-0.141, 0.370, -0.013> <-0.140, 0.371, 0.005> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.139, 0.405, 0.000> <-0.139, 0.410, 0.001> <-0.136, 0.412, 0.010> <-0.137, 0.416, 0.010> 
		<-0.140, 0.405, 0.023> <-0.139, 0.410, 0.024> <-0.136, 0.412, 0.031> <-0.137, 0.416, 0.031> 
		<-0.146, 0.407, 0.055> <-0.149, 0.414, 0.059> <-0.135, 0.413, 0.059> <-0.137, 0.421, 0.061> 
		<-0.137, 0.405, 0.076> <-0.141, 0.412, 0.080> <-0.139, 0.425, 0.076> <-0.140, 0.433, 0.077> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.139, 0.405, 0.000> <-0.140, 0.405, 0.023> <-0.146, 0.407, 0.055> <-0.137, 0.405, 0.076> 
		<-0.139, 0.410, 0.001> <-0.139, 0.410, 0.024> <-0.149, 0.414, 0.059> <-0.141, 0.412, 0.080> 
		<-0.136, 0.412, 0.010> <-0.136, 0.412, 0.031> <-0.144, 0.425, 0.056> <-0.139, 0.425, 0.076> 
		<-0.137, 0.416, 0.010> <-0.137, 0.416, 0.031> <-0.146, 0.433, 0.057> <-0.140, 0.433, 0.077> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.139, 0.405, 0.000> <-0.140, 0.405, 0.023> <-0.146, 0.407, 0.055> <-0.137, 0.405, 0.076> 
		<-0.140, 0.395, -0.001> <-0.141, 0.395, 0.022> <-0.140, 0.396, 0.048> <-0.132, 0.394, 0.069> 
		<-0.139, 0.382, 0.004> <-0.139, 0.382, 0.019> <-0.125, 0.391, 0.041> <-0.117, 0.391, 0.053> 
		<-0.140, 0.371, 0.005> <-0.140, 0.372, 0.019> <-0.124, 0.380, 0.034> <-0.115, 0.379, 0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.137, 0.405, 0.076> <-0.131, 0.404, 0.092> <-0.112, 0.396, 0.107> <-0.096, 0.394, 0.112> 
		<-0.132, 0.394, 0.069> <-0.126, 0.393, 0.085> <-0.106, 0.387, 0.104> <-0.090, 0.385, 0.110> 
		<-0.117, 0.391, 0.053> <-0.106, 0.390, 0.068> <-0.100, 0.377, 0.091> <-0.083, 0.375, 0.099> 
		<-0.115, 0.379, 0.046> <-0.104, 0.378, 0.061> <-0.095, 0.368, 0.086> <-0.078, 0.366, 0.094> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.096, 0.394, 0.112> <-0.068, 0.390, 0.122> <-0.026, 0.383, 0.124> <0.004, 0.384, 0.124> 
		<-0.090, 0.385, 0.110> <-0.061, 0.381, 0.119> <-0.025, 0.375, 0.120> <0.005, 0.376, 0.119> 
		<-0.083, 0.375, 0.099> <-0.060, 0.372, 0.109> <-0.017, 0.372, 0.103> <0.008, 0.373, 0.104> 
		<-0.078, 0.366, 0.094> <-0.055, 0.363, 0.104> <-0.020, 0.364, 0.100> <0.005, 0.365, 0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.004, 0.384, 0.124> <0.032, 0.384, 0.124> <0.070, 0.395, 0.120> <0.096, 0.399, 0.110> 
		<0.005, 0.376, 0.119> <0.033, 0.377, 0.119> <0.065, 0.386, 0.120> <0.091, 0.390, 0.110> 
		<0.008, 0.373, 0.104> <0.031, 0.373, 0.104> <0.064, 0.376, 0.109> <0.085, 0.380, 0.100> 
		<0.005, 0.365, 0.100> <0.028, 0.365, 0.101> <0.060, 0.367, 0.105> <0.081, 0.371, 0.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.096, 0.399, 0.110> <0.111, 0.402, 0.105> <0.128, 0.405, 0.090> <0.135, 0.405, 0.076> 
		<0.091, 0.390, 0.110> <0.105, 0.393, 0.105> <0.124, 0.396, 0.086> <0.130, 0.396, 0.071> 
		<0.085, 0.380, 0.100> <0.101, 0.383, 0.093> <0.108, 0.392, 0.072> <0.117, 0.394, 0.058> 
		<0.081, 0.371, 0.096> <0.097, 0.374, 0.090> <0.107, 0.382, 0.067> <0.116, 0.384, 0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.121, 0.378, -0.041> <0.122, 0.371, -0.041> <0.132, 0.370, -0.049> <0.135, 0.364, -0.050> 
		<0.107, 0.374, -0.056> <0.107, 0.368, -0.056> <0.117, 0.366, -0.064> <0.120, 0.361, -0.066> 
		<0.089, 0.369, -0.078> <0.089, 0.368, -0.077> <0.092, 0.367, -0.080> <0.092, 0.366, -0.080> 
		<0.071, 0.367, -0.088> <0.070, 0.366, -0.088> <0.072, 0.365, -0.090> <0.072, 0.364, -0.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.071, 0.367, -0.088> <0.052, 0.365, -0.098> <0.024, 0.365, -0.108> <0.002, 0.365, -0.107> 
		<0.070, 0.366, -0.088> <0.052, 0.364, -0.098> <0.023, 0.359, -0.107> <0.002, 0.360, -0.106> 
		<0.072, 0.365, -0.090> <0.051, 0.363, -0.100> <0.023, 0.355, -0.115> <-0.000, 0.355, -0.115> 
		<0.072, 0.364, -0.090> <0.051, 0.362, -0.100> <0.023, 0.350, -0.117> <-0.000, 0.351, -0.117> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.002, 0.365, -0.107> <-0.023, 0.366, -0.107> <-0.057, 0.371, -0.096> <-0.081, 0.373, -0.086> 
		<0.002, 0.360, -0.106> <-0.024, 0.361, -0.106> <-0.057, 0.370, -0.096> <-0.080, 0.372, -0.085> 
		<-0.000, 0.355, -0.115> <-0.027, 0.356, -0.114> <-0.058, 0.370, -0.098> <-0.082, 0.371, -0.087> 
		<-0.000, 0.351, -0.117> <-0.027, 0.352, -0.116> <-0.058, 0.369, -0.099> <-0.082, 0.370, -0.087> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.081, 0.373, -0.086> <-0.094, 0.374, -0.079> <-0.110, 0.374, -0.065> <-0.119, 0.374, -0.052> 
		<-0.080, 0.372, -0.085> <-0.094, 0.373, -0.079> <-0.110, 0.368, -0.066> <-0.118, 0.367, -0.053> 
		<-0.082, 0.371, -0.087> <-0.097, 0.371, -0.080> <-0.114, 0.360, -0.070> <-0.123, 0.360, -0.056> 
		<-0.082, 0.370, -0.087> <-0.097, 0.370, -0.080> <-0.117, 0.354, -0.071> <-0.126, 0.354, -0.057> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.119, 0.374, -0.052> <-0.129, 0.373, -0.037> <-0.141, 0.370, -0.013> <-0.140, 0.371, 0.005> 
		<-0.118, 0.367, -0.053> <-0.128, 0.367, -0.038> <-0.141, 0.370, -0.013> <-0.141, 0.371, 0.005> 
		<-0.123, 0.360, -0.056> <-0.134, 0.360, -0.040> <-0.142, 0.370, -0.016> <-0.142, 0.371, 0.003> 
		<-0.126, 0.354, -0.057> <-0.137, 0.355, -0.041> <-0.142, 0.370, -0.016> <-0.143, 0.371, 0.003> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.140, 0.371, 0.005> <-0.140, 0.372, 0.019> <-0.124, 0.380, 0.034> <-0.115, 0.379, 0.046> 
		<-0.141, 0.371, 0.005> <-0.140, 0.371, 0.019> <-0.123, 0.374, 0.030> <-0.114, 0.373, 0.042> 
		<-0.142, 0.371, 0.003> <-0.143, 0.372, 0.018> <-0.134, 0.367, 0.036> <-0.126, 0.366, 0.047> 
		<-0.143, 0.371, 0.003> <-0.144, 0.372, 0.018> <-0.139, 0.361, 0.037> <-0.131, 0.360, 0.049> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.115, 0.379, 0.046> <-0.104, 0.378, 0.061> <-0.095, 0.368, 0.086> <-0.078, 0.366, 0.094> 
		<-0.114, 0.373, 0.042> <-0.103, 0.372, 0.057> <-0.094, 0.368, 0.086> <-0.077, 0.366, 0.093> 
		<-0.126, 0.366, 0.047> <-0.114, 0.365, 0.065> <-0.098, 0.366, 0.086> <-0.079, 0.365, 0.095> 
		<-0.131, 0.360, 0.049> <-0.119, 0.359, 0.066> <-0.098, 0.365, 0.086> <-0.079, 0.364, 0.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.078, 0.366, 0.094> <-0.055, 0.363, 0.104> <-0.020, 0.364, 0.100> <0.005, 0.365, 0.100> 
		<-0.077, 0.366, 0.093> <-0.055, 0.363, 0.104> <-0.021, 0.359, 0.098> <0.004, 0.360, 0.098> 
		<-0.079, 0.365, 0.095> <-0.059, 0.364, 0.106> <-0.027, 0.359, 0.110> <-0.004, 0.360, 0.110> 
		<-0.079, 0.364, 0.096> <-0.059, 0.364, 0.106> <-0.028, 0.354, 0.112> <-0.005, 0.355, 0.113> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.005, 0.365, 0.100> <0.028, 0.365, 0.101> <0.060, 0.367, 0.105> <0.081, 0.371, 0.096> 
		<0.004, 0.360, 0.098> <0.027, 0.360, 0.099> <0.060, 0.366, 0.105> <0.081, 0.370, 0.096> 
		<-0.004, 0.360, 0.110> <0.023, 0.360, 0.110> <0.058, 0.368, 0.109> <0.082, 0.369, 0.098> 
		<-0.005, 0.355, 0.113> <0.022, 0.356, 0.113> <0.058, 0.367, 0.109> <0.083, 0.368, 0.098> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.081, 0.371, 0.096> <0.097, 0.374, 0.090> <0.107, 0.382, 0.067> <0.116, 0.384, 0.053> 
		<0.081, 0.370, 0.096> <0.096, 0.373, 0.089> <0.107, 0.375, 0.064> <0.116, 0.377, 0.049> 
		<0.082, 0.369, 0.098> <0.101, 0.370, 0.090> <0.117, 0.367, 0.070> <0.127, 0.369, 0.053> 
		<0.083, 0.368, 0.098> <0.101, 0.369, 0.090> <0.121, 0.360, 0.071> <0.132, 0.362, 0.054> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.135, 0.364, -0.050> <0.141, 0.355, -0.053> <0.148, 0.341, -0.056> <0.150, 0.330, -0.056> 
		<0.120, 0.361, -0.066> <0.126, 0.351, -0.069> <0.133, 0.339, -0.076> <0.135, 0.328, -0.077> 
		<0.092, 0.366, -0.080> <0.094, 0.359, -0.083> <0.099, 0.348, -0.086> <0.100, 0.341, -0.088> 
		<0.072, 0.364, -0.090> <0.074, 0.357, -0.093> <0.075, 0.348, -0.097> <0.076, 0.341, -0.098> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.072, 0.364, -0.090> <0.051, 0.362, -0.100> <0.023, 0.350, -0.117> <-0.000, 0.351, -0.117> 
		<0.074, 0.357, -0.093> <0.053, 0.355, -0.103> <0.023, 0.344, -0.120> <-0.000, 0.345, -0.119> 
		<0.075, 0.348, -0.097> <0.054, 0.348, -0.106> <0.026, 0.337, -0.123> <0.002, 0.337, -0.122> 
		<0.076, 0.341, -0.098> <0.055, 0.341, -0.108> <0.026, 0.331, -0.123> <0.003, 0.331, -0.122> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 0.351, -0.117> <-0.027, 0.352, -0.116> <-0.058, 0.369, -0.099> <-0.082, 0.370, -0.087> 
		<-0.000, 0.345, -0.119> <-0.027, 0.346, -0.119> <-0.059, 0.362, -0.100> <-0.083, 0.362, -0.088> 
		<0.002, 0.337, -0.122> <-0.026, 0.338, -0.120> <-0.059, 0.353, -0.100> <-0.085, 0.352, -0.088> 
		<0.003, 0.331, -0.122> <-0.026, 0.332, -0.120> <-0.060, 0.346, -0.101> <-0.086, 0.345, -0.089> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.082, 0.370, -0.087> <-0.097, 0.370, -0.080> <-0.117, 0.354, -0.071> <-0.126, 0.354, -0.057> 
		<-0.083, 0.362, -0.088> <-0.099, 0.363, -0.081> <-0.123, 0.345, -0.072> <-0.132, 0.345, -0.058> 
		<-0.085, 0.352, -0.088> <-0.105, 0.352, -0.080> <-0.129, 0.336, -0.074> <-0.143, 0.336, -0.058> 
		<-0.086, 0.345, -0.089> <-0.106, 0.344, -0.081> <-0.134, 0.326, -0.073> <-0.148, 0.326, -0.057> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.126, 0.354, -0.057> <-0.137, 0.355, -0.041> <-0.142, 0.370, -0.016> <-0.143, 0.371, 0.003> 
		<-0.132, 0.345, -0.058> <-0.143, 0.346, -0.042> <-0.149, 0.362, -0.018> <-0.150, 0.364, 0.002> 
		<-0.143, 0.336, -0.058> <-0.156, 0.336, -0.044> <-0.162, 0.354, -0.018> <-0.162, 0.355, 0.001> 
		<-0.148, 0.326, -0.057> <-0.160, 0.326, -0.043> <-0.165, 0.344, -0.019> <-0.165, 0.346, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.143, 0.371, 0.003> <-0.144, 0.372, 0.018> <-0.139, 0.361, 0.037> <-0.131, 0.360, 0.049> 
		<-0.150, 0.364, 0.002> <-0.150, 0.364, 0.016> <-0.144, 0.354, 0.039> <-0.136, 0.353, 0.050> 
		<-0.162, 0.355, 0.001> <-0.162, 0.357, 0.018> <-0.157, 0.345, 0.041> <-0.146, 0.345, 0.055> 
		<-0.165, 0.346, -0.000> <-0.165, 0.347, 0.017> <-0.160, 0.337, 0.042> <-0.148, 0.337, 0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.131, 0.360, 0.049> <-0.119, 0.359, 0.066> <-0.098, 0.365, 0.086> <-0.079, 0.364, 0.096> 
		<-0.136, 0.353, 0.050> <-0.124, 0.352, 0.068> <-0.099, 0.360, 0.088> <-0.080, 0.359, 0.098> 
		<-0.146, 0.345, 0.055> <-0.130, 0.345, 0.074> <-0.103, 0.352, 0.090> <-0.080, 0.352, 0.100> 
		<-0.148, 0.337, 0.056> <-0.133, 0.337, 0.075> <-0.103, 0.346, 0.091> <-0.081, 0.346, 0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.079, 0.364, 0.096> <-0.059, 0.364, 0.106> <-0.028, 0.354, 0.112> <-0.005, 0.355, 0.113> 
		<-0.080, 0.359, 0.098> <-0.060, 0.358, 0.108> <-0.030, 0.349, 0.115> <-0.007, 0.350, 0.116> 
		<-0.080, 0.352, 0.100> <-0.059, 0.351, 0.109> <-0.029, 0.341, 0.118> <-0.005, 0.341, 0.118> 
		<-0.081, 0.346, 0.101> <-0.059, 0.346, 0.111> <-0.028, 0.335, 0.118> <-0.004, 0.335, 0.118> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.005, 0.355, 0.113> <0.022, 0.356, 0.113> <0.058, 0.367, 0.109> <0.083, 0.368, 0.098> 
		<-0.007, 0.350, 0.116> <0.020, 0.350, 0.116> <0.060, 0.360, 0.110> <0.085, 0.361, 0.099> 
		<-0.005, 0.341, 0.118> <0.023, 0.341, 0.118> <0.062, 0.353, 0.110> <0.089, 0.352, 0.100> 
		<-0.004, 0.335, 0.118> <0.024, 0.335, 0.118> <0.062, 0.346, 0.111> <0.089, 0.344, 0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.083, 0.368, 0.098> <0.101, 0.369, 0.090> <0.121, 0.360, 0.071> <0.132, 0.362, 0.054> 
		<0.085, 0.361, 0.099> <0.103, 0.362, 0.091> <0.128, 0.350, 0.072> <0.138, 0.352, 0.055> 
		<0.089, 0.352, 0.100> <0.111, 0.351, 0.092> <0.135, 0.338, 0.078> <0.147, 0.339, 0.059> 
		<0.089, 0.344, 0.100> <0.111, 0.343, 0.092> <0.139, 0.327, 0.078> <0.152, 0.328, 0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.150, 0.330, -0.056> <0.152, 0.322, -0.057> <0.147, 0.310, -0.055> <0.145, 0.301, -0.055> 
		<0.135, 0.328, -0.077> <0.136, 0.319, -0.077> <0.132, 0.310, -0.076> <0.130, 0.302, -0.075> 
		<0.100, 0.341, -0.088> <0.101, 0.335, -0.089> <0.102, 0.327, -0.091> <0.101, 0.321, -0.091> 
		<0.076, 0.341, -0.098> <0.077, 0.335, -0.100> <0.079, 0.327, -0.101> <0.079, 0.322, -0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.076, 0.341, -0.098> <0.055, 0.341, -0.108> <0.026, 0.331, -0.123> <0.003, 0.331, -0.122> 
		<0.077, 0.335, -0.100> <0.056, 0.335, -0.109> <0.026, 0.323, -0.123> <0.003, 0.324, -0.122> 
		<0.079, 0.327, -0.101> <0.057, 0.328, -0.111> <0.027, 0.314, -0.121> <0.003, 0.313, -0.121> 
		<0.079, 0.322, -0.101> <0.057, 0.322, -0.111> <0.026, 0.306, -0.120> <0.002, 0.306, -0.119> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.003, 0.331, -0.122> <-0.026, 0.332, -0.120> <-0.060, 0.346, -0.101> <-0.086, 0.345, -0.089> 
		<0.003, 0.324, -0.122> <-0.026, 0.324, -0.121> <-0.061, 0.337, -0.102> <-0.088, 0.336, -0.091> 
		<0.003, 0.313, -0.121> <-0.026, 0.313, -0.120> <-0.064, 0.326, -0.106> <-0.090, 0.325, -0.095> 
		<0.002, 0.306, -0.119> <-0.027, 0.305, -0.118> <-0.064, 0.317, -0.107> <-0.090, 0.317, -0.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.086, 0.345, -0.089> <-0.106, 0.344, -0.081> <-0.134, 0.326, -0.073> <-0.148, 0.326, -0.057> 
		<-0.088, 0.336, -0.091> <-0.107, 0.336, -0.082> <-0.136, 0.320, -0.073> <-0.151, 0.320, -0.057> 
		<-0.090, 0.325, -0.095> <-0.110, 0.325, -0.086> <-0.138, 0.311, -0.072> <-0.151, 0.311, -0.054> 
		<-0.090, 0.317, -0.096> <-0.111, 0.317, -0.087> <-0.136, 0.304, -0.070> <-0.150, 0.304, -0.052> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.148, 0.326, -0.057> <-0.160, 0.326, -0.043> <-0.165, 0.344, -0.019> <-0.165, 0.346, -0.000> 
		<-0.151, 0.320, -0.057> <-0.163, 0.320, -0.042> <-0.167, 0.336, -0.020> <-0.167, 0.337, -0.001> 
		<-0.151, 0.311, -0.054> <-0.160, 0.311, -0.041> <-0.160, 0.325, -0.018> <-0.159, 0.326, -0.002> 
		<-0.150, 0.304, -0.052> <-0.159, 0.305, -0.040> <-0.159, 0.317, -0.018> <-0.159, 0.317, -0.003> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.165, 0.346, -0.000> <-0.165, 0.347, 0.017> <-0.160, 0.337, 0.042> <-0.148, 0.337, 0.056> 
		<-0.167, 0.337, -0.001> <-0.167, 0.339, 0.016> <-0.162, 0.328, 0.043> <-0.151, 0.329, 0.057> 
		<-0.159, 0.326, -0.002> <-0.158, 0.327, 0.016> <-0.156, 0.316, 0.041> <-0.146, 0.317, 0.055> 
		<-0.159, 0.317, -0.003> <-0.158, 0.318, 0.015> <-0.155, 0.308, 0.040> <-0.144, 0.309, 0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.148, 0.337, 0.056> <-0.133, 0.337, 0.075> <-0.103, 0.346, 0.091> <-0.081, 0.346, 0.101> 
		<-0.151, 0.329, 0.057> <-0.135, 0.329, 0.076> <-0.104, 0.339, 0.093> <-0.082, 0.339, 0.103> 
		<-0.146, 0.317, 0.055> <-0.132, 0.318, 0.075> <-0.106, 0.330, 0.096> <-0.083, 0.330, 0.105> 
		<-0.144, 0.309, 0.055> <-0.131, 0.310, 0.074> <-0.106, 0.323, 0.096> <-0.084, 0.323, 0.105> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.081, 0.346, 0.101> <-0.059, 0.346, 0.111> <-0.028, 0.335, 0.118> <-0.004, 0.335, 0.118> 
		<-0.082, 0.339, 0.103> <-0.060, 0.339, 0.112> <-0.027, 0.328, 0.118> <-0.003, 0.327, 0.118> 
		<-0.083, 0.330, 0.105> <-0.059, 0.330, 0.115> <-0.025, 0.320, 0.116> <0.001, 0.318, 0.116> 
		<-0.084, 0.323, 0.105> <-0.059, 0.323, 0.115> <-0.024, 0.312, 0.114> <0.003, 0.310, 0.114> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.004, 0.335, 0.118> <0.024, 0.335, 0.118> <0.062, 0.346, 0.111> <0.089, 0.344, 0.100> 
		<-0.003, 0.327, 0.118> <0.026, 0.327, 0.118> <0.062, 0.336, 0.111> <0.089, 0.334, 0.101> 
		<0.001, 0.318, 0.116> <0.025, 0.316, 0.115> <0.062, 0.323, 0.111> <0.085, 0.322, 0.103> 
		<0.003, 0.310, 0.114> <0.027, 0.309, 0.114> <0.060, 0.313, 0.111> <0.083, 0.312, 0.102> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.089, 0.344, 0.100> <0.111, 0.343, 0.092> <0.139, 0.327, 0.078> <0.152, 0.328, 0.059> 
		<0.089, 0.334, 0.101> <0.111, 0.334, 0.093> <0.142, 0.320, 0.079> <0.154, 0.321, 0.059> 
		<0.085, 0.322, 0.103> <0.108, 0.320, 0.094> <0.139, 0.309, 0.079> <0.154, 0.310, 0.059> 
		<0.083, 0.312, 0.102> <0.107, 0.311, 0.093> <0.138, 0.301, 0.077> <0.154, 0.303, 0.057> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.145, 0.301, -0.055> <0.144, 0.298, -0.054> <0.145, 0.291, -0.054> <0.142, 0.290, -0.052> 
		<0.130, 0.302, -0.075> <0.129, 0.298, -0.074> <0.129, 0.292, -0.071> <0.126, 0.290, -0.070> 
		<0.101, 0.321, -0.091> <0.101, 0.313, -0.090> <0.100, 0.302, -0.088> <0.098, 0.295, -0.086> 
		<0.079, 0.322, -0.101> <0.079, 0.314, -0.100> <0.079, 0.303, -0.098> <0.076, 0.296, -0.095> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.079, 0.322, -0.101> <0.057, 0.322, -0.111> <0.026, 0.306, -0.120> <0.002, 0.306, -0.119> 
		<0.079, 0.314, -0.100> <0.057, 0.314, -0.110> <0.026, 0.303, -0.119> <0.002, 0.302, -0.118> 
		<0.079, 0.303, -0.098> <0.057, 0.304, -0.107> <0.024, 0.298, -0.116> <0.000, 0.297, -0.116> 
		<0.076, 0.296, -0.095> <0.055, 0.297, -0.104> <0.023, 0.296, -0.113> <-0.000, 0.295, -0.113> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.002, 0.306, -0.119> <-0.027, 0.305, -0.118> <-0.064, 0.317, -0.107> <-0.090, 0.317, -0.096> 
		<0.002, 0.302, -0.118> <-0.027, 0.302, -0.117> <-0.064, 0.310, -0.108> <-0.091, 0.310, -0.097> 
		<0.000, 0.297, -0.116> <-0.027, 0.297, -0.117> <-0.066, 0.300, -0.108> <-0.090, 0.300, -0.097> 
		<-0.000, 0.295, -0.113> <-0.027, 0.295, -0.113> <-0.064, 0.293, -0.107> <-0.088, 0.293, -0.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.090, 0.317, -0.096> <-0.111, 0.317, -0.087> <-0.136, 0.304, -0.070> <-0.150, 0.304, -0.052> 
		<-0.091, 0.310, -0.097> <-0.111, 0.310, -0.088> <-0.136, 0.301, -0.069> <-0.149, 0.301, -0.051> 
		<-0.090, 0.300, -0.097> <-0.110, 0.300, -0.089> <-0.132, 0.296, -0.067> <-0.145, 0.296, -0.050> 
		<-0.088, 0.293, -0.096> <-0.107, 0.293, -0.087> <-0.128, 0.295, -0.066> <-0.141, 0.295, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.150, 0.304, -0.052> <-0.159, 0.305, -0.040> <-0.159, 0.317, -0.018> <-0.159, 0.317, -0.003> 
		<-0.149, 0.301, -0.051> <-0.158, 0.301, -0.039> <-0.159, 0.311, -0.018> <-0.158, 0.311, -0.003> 
		<-0.145, 0.296, -0.050> <-0.154, 0.297, -0.038> <-0.163, 0.303, -0.018> <-0.163, 0.303, -0.003> 
		<-0.141, 0.295, -0.050> <-0.151, 0.296, -0.038> <-0.162, 0.297, -0.018> <-0.162, 0.297, -0.003> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.159, 0.317, -0.003> <-0.158, 0.318, 0.015> <-0.155, 0.308, 0.040> <-0.144, 0.309, 0.055> 
		<-0.158, 0.311, -0.003> <-0.157, 0.312, 0.015> <-0.154, 0.304, 0.040> <-0.144, 0.305, 0.054> 
		<-0.163, 0.303, -0.003> <-0.163, 0.303, 0.015> <-0.155, 0.297, 0.039> <-0.144, 0.298, 0.053> 
		<-0.162, 0.297, -0.003> <-0.162, 0.297, 0.015> <-0.151, 0.295, 0.038> <-0.141, 0.295, 0.052> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.144, 0.309, 0.055> <-0.131, 0.310, 0.074> <-0.106, 0.323, 0.096> <-0.084, 0.323, 0.105> 
		<-0.144, 0.305, 0.054> <-0.130, 0.306, 0.074> <-0.106, 0.316, 0.096> <-0.084, 0.316, 0.105> 
		<-0.144, 0.298, 0.053> <-0.130, 0.298, 0.072> <-0.105, 0.305, 0.096> <-0.084, 0.306, 0.105> 
		<-0.141, 0.295, 0.052> <-0.127, 0.295, 0.071> <-0.104, 0.299, 0.094> <-0.082, 0.299, 0.102> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.084, 0.323, 0.105> <-0.059, 0.323, 0.115> <-0.024, 0.312, 0.114> <0.003, 0.310, 0.114> 
		<-0.084, 0.316, 0.105> <-0.059, 0.316, 0.115> <-0.023, 0.309, 0.114> <0.003, 0.307, 0.113> 
		<-0.084, 0.306, 0.105> <-0.060, 0.307, 0.114> <-0.023, 0.303, 0.113> <0.003, 0.302, 0.113> 
		<-0.082, 0.299, 0.102> <-0.059, 0.300, 0.112> <-0.023, 0.300, 0.111> <0.003, 0.299, 0.110> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.003, 0.310, 0.114> <0.027, 0.309, 0.114> <0.060, 0.313, 0.111> <0.083, 0.312, 0.102> 
		<0.003, 0.307, 0.113> <0.028, 0.305, 0.113> <0.059, 0.306, 0.111> <0.082, 0.305, 0.102> 
		<0.003, 0.302, 0.113> <0.026, 0.300, 0.112> <0.060, 0.297, 0.110> <0.081, 0.296, 0.101> 
		<0.003, 0.299, 0.110> <0.026, 0.298, 0.110> <0.057, 0.291, 0.108> <0.079, 0.290, 0.099> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.083, 0.312, 0.102> <0.107, 0.311, 0.093> <0.138, 0.301, 0.077> <0.154, 0.303, 0.057> 
		<0.082, 0.305, 0.102> <0.105, 0.304, 0.093> <0.138, 0.298, 0.076> <0.154, 0.299, 0.056> 
		<0.081, 0.296, 0.101> <0.105, 0.295, 0.092> <0.136, 0.294, 0.072> <0.152, 0.295, 0.053> 
		<0.079, 0.290, 0.099> <0.103, 0.289, 0.090> <0.133, 0.293, 0.071> <0.149, 0.293, 0.052> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.142, 0.290, -0.052> <0.136, 0.287, -0.050> <0.127, 0.291, -0.047> <0.121, 0.290, -0.045> 
		<0.126, 0.290, -0.070> <0.121, 0.288, -0.068> <0.113, 0.290, -0.062> <0.107, 0.290, -0.060> 
		<0.098, 0.295, -0.086> <0.097, 0.292, -0.084> <0.090, 0.292, -0.082> <0.087, 0.291, -0.080> 
		<0.076, 0.296, -0.095> <0.075, 0.293, -0.093> <0.071, 0.293, -0.090> <0.068, 0.291, -0.088> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.076, 0.296, -0.095> <0.055, 0.297, -0.104> <0.023, 0.296, -0.113> <-0.000, 0.295, -0.113> 
		<0.075, 0.293, -0.093> <0.054, 0.294, -0.103> <0.023, 0.293, -0.108> <-0.001, 0.293, -0.108> 
		<0.071, 0.293, -0.090> <0.051, 0.293, -0.098> <0.021, 0.295, -0.099> <-0.000, 0.295, -0.100> 
		<0.068, 0.291, -0.088> <0.049, 0.291, -0.096> <0.020, 0.293, -0.094> <-0.000, 0.293, -0.094> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 0.295, -0.113> <-0.027, 0.295, -0.113> <-0.064, 0.293, -0.107> <-0.088, 0.293, -0.096> 
		<-0.001, 0.293, -0.108> <-0.028, 0.292, -0.108> <-0.063, 0.291, -0.107> <-0.087, 0.291, -0.096> 
		<-0.000, 0.295, -0.100> <-0.025, 0.295, -0.100> <-0.061, 0.291, -0.102> <-0.084, 0.292, -0.093> 
		<-0.000, 0.293, -0.094> <-0.025, 0.293, -0.095> <-0.059, 0.290, -0.101> <-0.082, 0.291, -0.091> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.088, 0.293, -0.096> <-0.107, 0.293, -0.087> <-0.128, 0.295, -0.066> <-0.141, 0.295, -0.050> 
		<-0.087, 0.291, -0.096> <-0.107, 0.291, -0.087> <-0.121, 0.293, -0.065> <-0.135, 0.294, -0.048> 
		<-0.084, 0.292, -0.093> <-0.100, 0.292, -0.086> <-0.114, 0.297, -0.060> <-0.125, 0.297, -0.046> 
		<-0.082, 0.291, -0.091> <-0.098, 0.291, -0.084> <-0.107, 0.297, -0.059> <-0.118, 0.297, -0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.141, 0.295, -0.050> <-0.151, 0.296, -0.038> <-0.162, 0.297, -0.018> <-0.162, 0.297, -0.003> 
		<-0.135, 0.294, -0.048> <-0.144, 0.294, -0.036> <-0.161, 0.294, -0.018> <-0.161, 0.294, -0.003> 
		<-0.125, 0.297, -0.046> <-0.135, 0.297, -0.033> <-0.155, 0.294, -0.018> <-0.155, 0.293, -0.001> 
		<-0.118, 0.297, -0.045> <-0.128, 0.297, -0.031> <-0.152, 0.293, -0.018> <-0.153, 0.292, -0.001> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.162, 0.297, -0.003> <-0.162, 0.297, 0.015> <-0.151, 0.295, 0.038> <-0.141, 0.295, 0.052> 
		<-0.161, 0.294, -0.003> <-0.161, 0.294, 0.015> <-0.147, 0.291, 0.037> <-0.136, 0.292, 0.051> 
		<-0.155, 0.293, -0.001> <-0.156, 0.292, 0.016> <-0.138, 0.293, 0.036> <-0.127, 0.293, 0.050> 
		<-0.153, 0.292, -0.001> <-0.153, 0.291, 0.017> <-0.132, 0.291, 0.035> <-0.121, 0.292, 0.049> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.141, 0.295, 0.052> <-0.127, 0.295, 0.071> <-0.104, 0.299, 0.094> <-0.082, 0.299, 0.102> 
		<-0.136, 0.292, 0.051> <-0.122, 0.292, 0.069> <-0.103, 0.296, 0.093> <-0.082, 0.297, 0.101> 
		<-0.127, 0.293, 0.050> <-0.115, 0.294, 0.065> <-0.097, 0.297, 0.090> <-0.079, 0.297, 0.097> 
		<-0.121, 0.292, 0.049> <-0.110, 0.292, 0.064> <-0.096, 0.295, 0.088> <-0.078, 0.295, 0.095> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.082, 0.299, 0.102> <-0.059, 0.300, 0.112> <-0.023, 0.300, 0.111> <0.003, 0.299, 0.110> 
		<-0.082, 0.297, 0.101> <-0.058, 0.297, 0.111> <-0.023, 0.297, 0.108> <0.003, 0.296, 0.107> 
		<-0.079, 0.297, 0.097> <-0.057, 0.297, 0.106> <-0.021, 0.296, 0.101> <0.003, 0.295, 0.100> 
		<-0.078, 0.295, 0.095> <-0.055, 0.295, 0.104> <-0.022, 0.294, 0.097> <0.002, 0.293, 0.097> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.003, 0.299, 0.110> <0.026, 0.298, 0.110> <0.057, 0.291, 0.108> <0.079, 0.290, 0.099> 
		<0.003, 0.296, 0.107> <0.026, 0.294, 0.107> <0.056, 0.288, 0.107> <0.078, 0.288, 0.098> 
		<0.003, 0.295, 0.100> <0.024, 0.294, 0.100> <0.055, 0.289, 0.102> <0.074, 0.288, 0.095> 
		<0.002, 0.293, 0.097> <0.023, 0.291, 0.096> <0.053, 0.288, 0.101> <0.072, 0.287, 0.093> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.079, 0.290, 0.099> <0.103, 0.289, 0.090> <0.133, 0.293, 0.071> <0.149, 0.293, 0.052> 
		<0.078, 0.288, 0.098> <0.101, 0.287, 0.089> <0.126, 0.289, 0.069> <0.142, 0.290, 0.050> 
		<0.074, 0.288, 0.095> <0.093, 0.288, 0.087> <0.117, 0.289, 0.064> <0.131, 0.291, 0.049> 
		<0.072, 0.287, 0.093> <0.091, 0.286, 0.085> <0.110, 0.287, 0.063> <0.124, 0.288, 0.048> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.121, 0.290, -0.045> <0.120, 0.290, -0.044> <0.117, 0.288, -0.043> <0.118, 0.287, -0.043> 
		<0.107, 0.290, -0.060> <0.106, 0.290, -0.059> <0.103, 0.288, -0.057> <0.104, 0.287, -0.058> 
		<0.087, 0.291, -0.080> <0.086, 0.290, -0.080> <0.085, 0.289, -0.079> <0.085, 0.287, -0.079> 
		<0.068, 0.291, -0.088> <0.067, 0.290, -0.088> <0.066, 0.289, -0.086> <0.066, 0.288, -0.087> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.068, 0.291, -0.088> <0.049, 0.291, -0.096> <0.020, 0.293, -0.094> <-0.000, 0.293, -0.094> 
		<0.067, 0.290, -0.088> <0.048, 0.291, -0.095> <0.020, 0.293, -0.092> <-0.000, 0.293, -0.093> 
		<0.066, 0.289, -0.086> <0.047, 0.289, -0.094> <0.019, 0.290, -0.089> <-0.001, 0.290, -0.090> 
		<0.066, 0.288, -0.087> <0.047, 0.288, -0.094> <0.019, 0.289, -0.090> <-0.001, 0.289, -0.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 0.293, -0.094> <-0.025, 0.293, -0.095> <-0.059, 0.290, -0.101> <-0.082, 0.291, -0.091> 
		<-0.000, 0.293, -0.093> <-0.025, 0.293, -0.093> <-0.058, 0.289, -0.100> <-0.081, 0.290, -0.091> 
		<-0.001, 0.290, -0.090> <-0.025, 0.290, -0.090> <-0.058, 0.288, -0.098> <-0.079, 0.289, -0.089> 
		<-0.001, 0.289, -0.090> <-0.025, 0.289, -0.091> <-0.058, 0.286, -0.099> <-0.080, 0.288, -0.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.082, 0.291, -0.091> <-0.098, 0.291, -0.084> <-0.107, 0.297, -0.059> <-0.118, 0.297, -0.045> 
		<-0.081, 0.290, -0.091> <-0.097, 0.291, -0.084> <-0.106, 0.297, -0.058> <-0.117, 0.297, -0.044> 
		<-0.079, 0.289, -0.089> <-0.096, 0.290, -0.083> <-0.102, 0.296, -0.057> <-0.113, 0.296, -0.043> 
		<-0.080, 0.288, -0.090> <-0.096, 0.288, -0.083> <-0.103, 0.295, -0.057> <-0.114, 0.295, -0.043> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.118, 0.297, -0.045> <-0.128, 0.297, -0.031> <-0.152, 0.293, -0.018> <-0.153, 0.292, -0.001> 
		<-0.117, 0.297, -0.044> <-0.127, 0.297, -0.031> <-0.151, 0.292, -0.018> <-0.152, 0.291, -0.001> 
		<-0.113, 0.296, -0.043> <-0.124, 0.296, -0.030> <-0.148, 0.291, -0.018> <-0.149, 0.289, -0.001> 
		<-0.114, 0.295, -0.043> <-0.124, 0.295, -0.030> <-0.149, 0.290, -0.018> <-0.150, 0.289, -0.002> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.153, 0.292, -0.001> <-0.153, 0.291, 0.017> <-0.132, 0.291, 0.035> <-0.121, 0.292, 0.049> 
		<-0.152, 0.291, -0.001> <-0.152, 0.290, 0.017> <-0.131, 0.291, 0.034> <-0.120, 0.291, 0.048> 
		<-0.149, 0.289, -0.001> <-0.149, 0.288, 0.016> <-0.128, 0.290, 0.034> <-0.117, 0.290, 0.047> 
		<-0.150, 0.289, -0.002> <-0.150, 0.288, 0.016> <-0.129, 0.289, 0.034> <-0.118, 0.289, 0.048> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.121, 0.292, 0.049> <-0.110, 0.292, 0.064> <-0.096, 0.295, 0.088> <-0.078, 0.295, 0.095> 
		<-0.120, 0.291, 0.048> <-0.108, 0.292, 0.063> <-0.095, 0.294, 0.087> <-0.077, 0.294, 0.094> 
		<-0.117, 0.290, 0.047> <-0.106, 0.290, 0.062> <-0.093, 0.293, 0.086> <-0.076, 0.293, 0.093> 
		<-0.118, 0.289, 0.048> <-0.107, 0.290, 0.062> <-0.094, 0.291, 0.086> <-0.077, 0.291, 0.093> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.078, 0.295, 0.095> <-0.055, 0.295, 0.104> <-0.022, 0.294, 0.097> <0.002, 0.293, 0.097> 
		<-0.077, 0.294, 0.094> <-0.055, 0.294, 0.103> <-0.022, 0.293, 0.096> <0.002, 0.292, 0.095> 
		<-0.076, 0.293, 0.093> <-0.055, 0.292, 0.101> <-0.022, 0.291, 0.094> <0.001, 0.290, 0.094> 
		<-0.077, 0.291, 0.093> <-0.055, 0.291, 0.101> <-0.022, 0.290, 0.095> <0.001, 0.289, 0.094> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.002, 0.293, 0.097> <0.023, 0.291, 0.096> <0.053, 0.288, 0.101> <0.072, 0.287, 0.093> 
		<0.002, 0.292, 0.095> <0.023, 0.291, 0.095> <0.052, 0.287, 0.100> <0.072, 0.287, 0.092> 
		<0.001, 0.290, 0.094> <0.022, 0.289, 0.093> <0.051, 0.286, 0.099> <0.070, 0.285, 0.091> 
		<0.001, 0.289, 0.094> <0.022, 0.288, 0.094> <0.051, 0.285, 0.099> <0.070, 0.284, 0.091> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.072, 0.287, 0.093> <0.091, 0.286, 0.085> <0.110, 0.287, 0.063> <0.124, 0.288, 0.048> 
		<0.072, 0.287, 0.092> <0.091, 0.286, 0.084> <0.108, 0.287, 0.063> <0.122, 0.288, 0.047> 
		<0.070, 0.285, 0.091> <0.088, 0.285, 0.084> <0.105, 0.284, 0.062> <0.118, 0.286, 0.047> 
		<0.070, 0.284, 0.091> <0.089, 0.284, 0.084> <0.106, 0.283, 0.062> <0.119, 0.285, 0.047> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.118, 0.287, -0.043> <0.125, 0.278, -0.047> <0.139, 0.271, -0.054> <0.145, 0.261, -0.058> 
		<0.104, 0.287, -0.058> <0.111, 0.278, -0.062> <0.122, 0.270, -0.071> <0.128, 0.260, -0.076> 
		<0.085, 0.287, -0.079> <0.086, 0.285, -0.079> <0.093, 0.283, -0.080> <0.094, 0.281, -0.080> 
		<0.066, 0.288, -0.087> <0.067, 0.285, -0.087> <0.070, 0.283, -0.089> <0.071, 0.281, -0.089> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.066, 0.288, -0.087> <0.047, 0.288, -0.094> <0.019, 0.289, -0.090> <-0.001, 0.289, -0.090> 
		<0.067, 0.285, -0.087> <0.048, 0.285, -0.094> <0.019, 0.280, -0.096> <-0.001, 0.280, -0.096> 
		<0.070, 0.283, -0.089> <0.048, 0.283, -0.097> <0.022, 0.271, -0.108> <-0.002, 0.271, -0.109> 
		<0.071, 0.281, -0.089> <0.049, 0.281, -0.098> <0.022, 0.261, -0.113> <-0.002, 0.261, -0.114> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.001, 0.289, -0.090> <-0.025, 0.289, -0.091> <-0.058, 0.286, -0.099> <-0.080, 0.288, -0.090> 
		<-0.001, 0.280, -0.096> <-0.025, 0.280, -0.097> <-0.058, 0.284, -0.099> <-0.080, 0.285, -0.090> 
		<-0.002, 0.271, -0.109> <-0.028, 0.270, -0.110> <-0.059, 0.281, -0.104> <-0.082, 0.282, -0.093> 
		<-0.002, 0.261, -0.114> <-0.027, 0.261, -0.115> <-0.059, 0.279, -0.105> <-0.082, 0.279, -0.094> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.080, 0.288, -0.090> <-0.096, 0.288, -0.083> <-0.103, 0.295, -0.057> <-0.114, 0.295, -0.043> 
		<-0.080, 0.285, -0.090> <-0.096, 0.286, -0.084> <-0.110, 0.285, -0.059> <-0.121, 0.285, -0.045> 
		<-0.082, 0.282, -0.093> <-0.103, 0.283, -0.084> <-0.120, 0.274, -0.065> <-0.134, 0.275, -0.048> 
		<-0.082, 0.279, -0.094> <-0.103, 0.280, -0.084> <-0.126, 0.264, -0.067> <-0.141, 0.266, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.114, 0.295, -0.043> <-0.124, 0.295, -0.030> <-0.149, 0.290, -0.018> <-0.150, 0.289, -0.002> 
		<-0.121, 0.285, -0.045> <-0.131, 0.285, -0.032> <-0.151, 0.288, -0.019> <-0.151, 0.287, -0.003> 
		<-0.134, 0.275, -0.048> <-0.144, 0.276, -0.036> <-0.157, 0.289, -0.020> <-0.158, 0.289, -0.004> 
		<-0.141, 0.266, -0.050> <-0.151, 0.266, -0.038> <-0.158, 0.286, -0.020> <-0.159, 0.286, -0.004> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.150, 0.289, -0.002> <-0.150, 0.288, 0.016> <-0.129, 0.289, 0.034> <-0.118, 0.289, 0.048> 
		<-0.151, 0.287, -0.003> <-0.152, 0.286, 0.015> <-0.136, 0.281, 0.037> <-0.125, 0.281, 0.051> 
		<-0.158, 0.289, -0.004> <-0.159, 0.289, 0.016> <-0.151, 0.275, 0.040> <-0.139, 0.275, 0.056> 
		<-0.159, 0.286, -0.004> <-0.159, 0.286, 0.016> <-0.158, 0.266, 0.043> <-0.145, 0.266, 0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.118, 0.289, 0.048> <-0.107, 0.290, 0.062> <-0.094, 0.291, 0.086> <-0.077, 0.291, 0.093> 
		<-0.125, 0.281, 0.051> <-0.114, 0.282, 0.065> <-0.094, 0.289, 0.087> <-0.077, 0.289, 0.093> 
		<-0.139, 0.275, 0.056> <-0.125, 0.274, 0.074> <-0.101, 0.286, 0.088> <-0.079, 0.287, 0.096> 
		<-0.145, 0.266, 0.059> <-0.131, 0.266, 0.077> <-0.102, 0.284, 0.089> <-0.080, 0.284, 0.097> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.077, 0.291, 0.093> <-0.055, 0.291, 0.101> <-0.022, 0.290, 0.095> <0.001, 0.289, 0.094> 
		<-0.077, 0.289, 0.093> <-0.055, 0.289, 0.102> <-0.022, 0.283, 0.099> <0.001, 0.282, 0.098> 
		<-0.079, 0.287, 0.096> <-0.055, 0.287, 0.105> <-0.024, 0.277, 0.108> <0.002, 0.276, 0.108> 
		<-0.080, 0.284, 0.097> <-0.056, 0.285, 0.105> <-0.023, 0.270, 0.111> <0.003, 0.269, 0.111> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, 0.289, 0.094> <0.022, 0.288, 0.094> <0.051, 0.285, 0.099> <0.070, 0.284, 0.091> 
		<0.001, 0.282, 0.098> <0.022, 0.281, 0.098> <0.052, 0.283, 0.099> <0.071, 0.282, 0.092> 
		<0.002, 0.276, 0.108> <0.025, 0.275, 0.107> <0.054, 0.282, 0.103> <0.075, 0.281, 0.094> 
		<0.003, 0.269, 0.111> <0.025, 0.268, 0.111> <0.055, 0.280, 0.103> <0.076, 0.279, 0.095> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.070, 0.284, 0.091> <0.089, 0.284, 0.084> <0.106, 0.283, 0.062> <0.119, 0.285, 0.047> 
		<0.071, 0.282, 0.092> <0.090, 0.282, 0.084> <0.114, 0.275, 0.063> <0.127, 0.276, 0.049> 
		<0.075, 0.281, 0.094> <0.099, 0.280, 0.085> <0.126, 0.271, 0.070> <0.144, 0.271, 0.051> 
		<0.076, 0.279, 0.095> <0.100, 0.278, 0.085> <0.132, 0.261, 0.072> <0.149, 0.262, 0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.145, 0.261, -0.058> <0.148, 0.254, -0.061> <0.147, 0.243, -0.066> <0.146, 0.235, -0.067> 
		<0.128, 0.260, -0.076> <0.131, 0.254, -0.079> <0.134, 0.244, -0.083> <0.133, 0.236, -0.084> 
		<0.094, 0.281, -0.080> <0.099, 0.272, -0.083> <0.101, 0.261, -0.088> <0.104, 0.252, -0.091> 
		<0.071, 0.281, -0.089> <0.075, 0.272, -0.092> <0.081, 0.261, -0.096> <0.084, 0.251, -0.098> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.071, 0.281, -0.089> <0.049, 0.281, -0.098> <0.022, 0.261, -0.113> <-0.002, 0.261, -0.114> 
		<0.075, 0.272, -0.092> <0.053, 0.272, -0.100> <0.023, 0.253, -0.117> <-0.001, 0.253, -0.118> 
		<0.081, 0.261, -0.096> <0.057, 0.260, -0.105> <0.027, 0.240, -0.120> <0.001, 0.241, -0.120> 
		<0.084, 0.251, -0.098> <0.060, 0.251, -0.107> <0.028, 0.232, -0.120> <0.002, 0.233, -0.119> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.002, 0.261, -0.114> <-0.027, 0.261, -0.115> <-0.059, 0.279, -0.105> <-0.082, 0.279, -0.094> 
		<-0.001, 0.253, -0.118> <-0.027, 0.253, -0.119> <-0.060, 0.272, -0.105> <-0.083, 0.273, -0.094> 
		<0.001, 0.241, -0.120> <-0.026, 0.242, -0.119> <-0.057, 0.262, -0.104> <-0.082, 0.263, -0.093> 
		<0.002, 0.233, -0.119> <-0.025, 0.234, -0.119> <-0.056, 0.255, -0.104> <-0.081, 0.257, -0.093> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.082, 0.279, -0.094> <-0.103, 0.280, -0.084> <-0.126, 0.264, -0.067> <-0.141, 0.266, -0.050> 
		<-0.083, 0.273, -0.094> <-0.103, 0.273, -0.085> <-0.130, 0.258, -0.068> <-0.145, 0.259, -0.051> 
		<-0.082, 0.263, -0.093> <-0.104, 0.265, -0.083> <-0.132, 0.250, -0.070> <-0.148, 0.250, -0.052> 
		<-0.081, 0.257, -0.093> <-0.103, 0.258, -0.083> <-0.133, 0.243, -0.071> <-0.149, 0.242, -0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.141, 0.266, -0.050> <-0.151, 0.266, -0.038> <-0.158, 0.286, -0.020> <-0.159, 0.286, -0.004> 
		<-0.145, 0.259, -0.051> <-0.155, 0.260, -0.039> <-0.160, 0.277, -0.022> <-0.161, 0.277, -0.006> 
		<-0.148, 0.250, -0.052> <-0.158, 0.250, -0.041> <-0.157, 0.265, -0.022> <-0.157, 0.265, -0.008> 
		<-0.149, 0.242, -0.053> <-0.159, 0.242, -0.043> <-0.157, 0.256, -0.023> <-0.158, 0.256, -0.008> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.159, 0.286, -0.004> <-0.159, 0.286, 0.016> <-0.158, 0.266, 0.043> <-0.145, 0.266, 0.059> 
		<-0.161, 0.277, -0.006> <-0.162, 0.277, 0.014> <-0.162, 0.260, 0.045> <-0.150, 0.260, 0.061> 
		<-0.157, 0.265, -0.008> <-0.158, 0.264, 0.015> <-0.165, 0.248, 0.045> <-0.152, 0.249, 0.064> 
		<-0.158, 0.256, -0.008> <-0.159, 0.255, 0.014> <-0.166, 0.240, 0.046> <-0.153, 0.241, 0.064> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.145, 0.266, 0.059> <-0.131, 0.266, 0.077> <-0.102, 0.284, 0.089> <-0.080, 0.284, 0.097> 
		<-0.150, 0.260, 0.061> <-0.136, 0.259, 0.079> <-0.104, 0.278, 0.091> <-0.082, 0.278, 0.099> 
		<-0.152, 0.249, 0.064> <-0.139, 0.250, 0.084> <-0.106, 0.269, 0.093> <-0.083, 0.269, 0.100> 
		<-0.153, 0.241, 0.064> <-0.140, 0.242, 0.084> <-0.108, 0.262, 0.094> <-0.085, 0.262, 0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.080, 0.284, 0.097> <-0.056, 0.285, 0.105> <-0.023, 0.270, 0.111> <0.003, 0.269, 0.111> 
		<-0.082, 0.278, 0.099> <-0.058, 0.278, 0.107> <-0.022, 0.263, 0.115> <0.004, 0.262, 0.114> 
		<-0.083, 0.269, 0.100> <-0.056, 0.269, 0.109> <-0.020, 0.253, 0.118> <0.008, 0.251, 0.117> 
		<-0.085, 0.262, 0.101> <-0.058, 0.263, 0.110> <-0.021, 0.245, 0.118> <0.007, 0.243, 0.117> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.003, 0.269, 0.111> <0.025, 0.268, 0.111> <0.055, 0.280, 0.103> <0.076, 0.279, 0.095> 
		<0.004, 0.262, 0.114> <0.026, 0.261, 0.114> <0.056, 0.272, 0.103> <0.077, 0.271, 0.095> 
		<0.008, 0.251, 0.117> <0.030, 0.250, 0.115> <0.055, 0.261, 0.101> <0.075, 0.260, 0.092> 
		<0.007, 0.243, 0.117> <0.029, 0.242, 0.116> <0.055, 0.252, 0.101> <0.076, 0.251, 0.092> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.076, 0.279, 0.095> <0.100, 0.278, 0.085> <0.132, 0.261, 0.072> <0.149, 0.262, 0.053> 
		<0.077, 0.271, 0.095> <0.101, 0.269, 0.085> <0.136, 0.254, 0.073> <0.153, 0.255, 0.054> 
		<0.075, 0.260, 0.092> <0.097, 0.259, 0.083> <0.131, 0.244, 0.074> <0.147, 0.244, 0.057> 
		<0.076, 0.251, 0.092> <0.098, 0.250, 0.083> <0.130, 0.236, 0.075> <0.146, 0.236, 0.058> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.146, 0.235, -0.067> <0.146, 0.229, -0.068> <0.144, 0.221, -0.064> <0.142, 0.216, -0.062> 
		<0.133, 0.236, -0.084> <0.133, 0.229, -0.084> <0.133, 0.220, -0.080> <0.130, 0.215, -0.079> 
		<0.104, 0.252, -0.091> <0.107, 0.244, -0.092> <0.108, 0.234, -0.096> <0.107, 0.225, -0.095> 
		<0.084, 0.251, -0.098> <0.087, 0.243, -0.100> <0.089, 0.232, -0.103> <0.088, 0.224, -0.102> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.084, 0.251, -0.098> <0.060, 0.251, -0.107> <0.028, 0.232, -0.120> <0.002, 0.233, -0.119> 
		<0.087, 0.243, -0.100> <0.062, 0.243, -0.109> <0.029, 0.224, -0.120> <0.003, 0.225, -0.119> 
		<0.089, 0.232, -0.103> <0.065, 0.231, -0.111> <0.030, 0.213, -0.117> <0.004, 0.214, -0.115> 
		<0.088, 0.224, -0.102> <0.064, 0.222, -0.111> <0.030, 0.206, -0.113> <0.005, 0.207, -0.112> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.002, 0.233, -0.119> <-0.025, 0.234, -0.119> <-0.056, 0.255, -0.104> <-0.081, 0.257, -0.093> 
		<0.003, 0.225, -0.119> <-0.024, 0.226, -0.118> <-0.056, 0.248, -0.104> <-0.081, 0.249, -0.093> 
		<0.004, 0.214, -0.115> <-0.022, 0.216, -0.114> <-0.055, 0.237, -0.103> <-0.080, 0.239, -0.093> 
		<0.005, 0.207, -0.112> <-0.022, 0.208, -0.111> <-0.054, 0.230, -0.103> <-0.079, 0.232, -0.094> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.081, 0.257, -0.093> <-0.103, 0.258, -0.083> <-0.133, 0.243, -0.071> <-0.149, 0.242, -0.053> 
		<-0.081, 0.249, -0.093> <-0.103, 0.251, -0.083> <-0.134, 0.236, -0.072> <-0.150, 0.236, -0.055> 
		<-0.080, 0.239, -0.093> <-0.102, 0.241, -0.086> <-0.131, 0.227, -0.073> <-0.147, 0.227, -0.057> 
		<-0.079, 0.232, -0.094> <-0.100, 0.234, -0.086> <-0.129, 0.221, -0.074> <-0.145, 0.220, -0.058> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.149, 0.242, -0.053> <-0.159, 0.242, -0.043> <-0.157, 0.256, -0.023> <-0.158, 0.256, -0.008> 
		<-0.150, 0.236, -0.055> <-0.159, 0.236, -0.044> <-0.158, 0.248, -0.023> <-0.159, 0.248, -0.009> 
		<-0.147, 0.227, -0.057> <-0.158, 0.227, -0.046> <-0.161, 0.239, -0.026> <-0.162, 0.238, -0.010> 
		<-0.145, 0.220, -0.058> <-0.156, 0.220, -0.046> <-0.163, 0.231, -0.025> <-0.164, 0.230, -0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.158, 0.256, -0.008> <-0.159, 0.255, 0.014> <-0.166, 0.240, 0.046> <-0.153, 0.241, 0.064> 
		<-0.159, 0.248, -0.009> <-0.160, 0.248, 0.013> <-0.167, 0.231, 0.046> <-0.155, 0.232, 0.064> 
		<-0.162, 0.238, -0.010> <-0.163, 0.236, 0.012> <-0.166, 0.220, 0.044> <-0.154, 0.221, 0.062> 
		<-0.164, 0.230, -0.009> <-0.165, 0.229, 0.013> <-0.165, 0.212, 0.043> <-0.153, 0.212, 0.061> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.153, 0.241, 0.064> <-0.140, 0.242, 0.084> <-0.108, 0.262, 0.094> <-0.085, 0.262, 0.101> 
		<-0.155, 0.232, 0.064> <-0.141, 0.233, 0.085> <-0.110, 0.254, 0.095> <-0.086, 0.254, 0.102> 
		<-0.154, 0.221, 0.062> <-0.142, 0.222, 0.082> <-0.113, 0.242, 0.096> <-0.090, 0.244, 0.104> 
		<-0.153, 0.212, 0.061> <-0.140, 0.213, 0.081> <-0.113, 0.234, 0.096> <-0.091, 0.235, 0.104> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.085, 0.262, 0.101> <-0.058, 0.263, 0.110> <-0.021, 0.245, 0.118> <0.007, 0.243, 0.117> 
		<-0.086, 0.254, 0.102> <-0.059, 0.254, 0.111> <-0.022, 0.237, 0.118> <0.006, 0.235, 0.117> 
		<-0.090, 0.244, 0.104> <-0.065, 0.245, 0.113> <-0.028, 0.228, 0.115> <-0.001, 0.227, 0.113> 
		<-0.091, 0.235, 0.104> <-0.065, 0.236, 0.112> <-0.030, 0.221, 0.113> <-0.004, 0.219, 0.112> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.007, 0.243, 0.117> <0.029, 0.242, 0.116> <0.055, 0.252, 0.101> <0.076, 0.251, 0.092> 
		<0.006, 0.235, 0.117> <0.028, 0.234, 0.116> <0.056, 0.244, 0.101> <0.076, 0.243, 0.093> 
		<-0.001, 0.227, 0.113> <0.024, 0.225, 0.112> <0.054, 0.234, 0.104> <0.077, 0.233, 0.095> 
		<-0.004, 0.219, 0.112> <0.021, 0.218, 0.111> <0.055, 0.226, 0.105> <0.078, 0.225, 0.097> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.076, 0.251, 0.092> <0.098, 0.250, 0.083> <0.130, 0.236, 0.075> <0.146, 0.236, 0.058> 
		<0.076, 0.243, 0.093> <0.098, 0.242, 0.083> <0.129, 0.230, 0.076> <0.145, 0.230, 0.058> 
		<0.077, 0.233, 0.095> <0.099, 0.233, 0.087> <0.129, 0.221, 0.075> <0.145, 0.222, 0.059> 
		<0.078, 0.225, 0.097> <0.099, 0.225, 0.089> <0.128, 0.215, 0.075> <0.143, 0.216, 0.058> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.142, 0.216, -0.062> <0.140, 0.213, -0.061> <0.137, 0.210, -0.059> <0.134, 0.209, -0.058> 
		<0.130, 0.215, -0.079> <0.128, 0.212, -0.078> <0.124, 0.209, -0.074> <0.121, 0.208, -0.073> 
		<0.107, 0.225, -0.095> <0.107, 0.217, -0.095> <0.102, 0.208, -0.091> <0.099, 0.202, -0.088> 
		<0.088, 0.224, -0.102> <0.088, 0.216, -0.101> <0.084, 0.207, -0.097> <0.080, 0.200, -0.094> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.088, 0.224, -0.102> <0.064, 0.222, -0.111> <0.030, 0.206, -0.113> <0.005, 0.207, -0.112> 
		<0.088, 0.216, -0.101> <0.063, 0.214, -0.110> <0.030, 0.202, -0.112> <0.005, 0.203, -0.110> 
		<0.084, 0.207, -0.097> <0.062, 0.205, -0.104> <0.027, 0.198, -0.106> <0.004, 0.199, -0.106> 
		<0.080, 0.200, -0.094> <0.058, 0.198, -0.102> <0.027, 0.196, -0.102> <0.004, 0.197, -0.103> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.005, 0.207, -0.112> <-0.022, 0.208, -0.111> <-0.054, 0.230, -0.103> <-0.079, 0.232, -0.094> 
		<0.005, 0.203, -0.110> <-0.022, 0.205, -0.109> <-0.053, 0.222, -0.103> <-0.078, 0.224, -0.094> 
		<0.004, 0.199, -0.106> <-0.019, 0.200, -0.107> <-0.053, 0.211, -0.104> <-0.075, 0.213, -0.097> 
		<0.004, 0.197, -0.103> <-0.020, 0.198, -0.103> <-0.051, 0.203, -0.103> <-0.073, 0.205, -0.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.079, 0.232, -0.094> <-0.100, 0.234, -0.086> <-0.129, 0.221, -0.074> <-0.145, 0.220, -0.058> 
		<-0.078, 0.224, -0.094> <-0.099, 0.226, -0.087> <-0.128, 0.217, -0.074> <-0.144, 0.217, -0.058> 
		<-0.075, 0.213, -0.097> <-0.097, 0.215, -0.090> <-0.125, 0.213, -0.072> <-0.142, 0.213, -0.056> 
		<-0.073, 0.205, -0.096> <-0.095, 0.207, -0.089> <-0.122, 0.211, -0.071> <-0.139, 0.211, -0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.145, 0.220, -0.058> <-0.156, 0.220, -0.046> <-0.163, 0.231, -0.025> <-0.164, 0.230, -0.009> 
		<-0.144, 0.217, -0.058> <-0.155, 0.217, -0.047> <-0.165, 0.223, -0.024> <-0.166, 0.222, -0.008> 
		<-0.142, 0.213, -0.056> <-0.155, 0.212, -0.043> <-0.170, 0.213, -0.024> <-0.171, 0.212, -0.005> 
		<-0.139, 0.211, -0.055> <-0.152, 0.210, -0.043> <-0.169, 0.205, -0.022> <-0.171, 0.204, -0.003> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.164, 0.230, -0.009> <-0.165, 0.229, 0.013> <-0.165, 0.212, 0.043> <-0.153, 0.212, 0.061> 
		<-0.166, 0.222, -0.008> <-0.167, 0.221, 0.013> <-0.164, 0.207, 0.042> <-0.152, 0.208, 0.060> 
		<-0.171, 0.212, -0.005> <-0.173, 0.210, 0.015> <-0.163, 0.200, 0.045> <-0.150, 0.201, 0.061> 
		<-0.171, 0.204, -0.003> <-0.172, 0.202, 0.017> <-0.159, 0.199, 0.044> <-0.147, 0.200, 0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.153, 0.212, 0.061> <-0.140, 0.213, 0.081> <-0.113, 0.234, 0.096> <-0.091, 0.235, 0.104> 
		<-0.152, 0.208, 0.060> <-0.139, 0.209, 0.080> <-0.113, 0.226, 0.096> <-0.091, 0.227, 0.103> 
		<-0.150, 0.201, 0.061> <-0.137, 0.202, 0.078> <-0.110, 0.214, 0.094> <-0.090, 0.216, 0.101> 
		<-0.147, 0.200, 0.059> <-0.133, 0.200, 0.076> <-0.108, 0.206, 0.092> <-0.088, 0.208, 0.099> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.091, 0.235, 0.104> <-0.065, 0.236, 0.112> <-0.030, 0.221, 0.113> <-0.004, 0.219, 0.112> 
		<-0.091, 0.227, 0.103> <-0.066, 0.228, 0.112> <-0.031, 0.218, 0.112> <-0.005, 0.216, 0.111> 
		<-0.090, 0.216, 0.101> <-0.067, 0.217, 0.109> <-0.030, 0.212, 0.111> <-0.005, 0.211, 0.111> 
		<-0.088, 0.208, 0.099> <-0.064, 0.209, 0.107> <-0.030, 0.210, 0.108> <-0.005, 0.209, 0.109> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.004, 0.219, 0.112> <0.021, 0.218, 0.111> <0.055, 0.226, 0.105> <0.078, 0.225, 0.097> 
		<-0.005, 0.216, 0.111> <0.020, 0.215, 0.110> <0.055, 0.220, 0.106> <0.079, 0.219, 0.098> 
		<-0.005, 0.211, 0.111> <0.021, 0.211, 0.111> <0.058, 0.211, 0.111> <0.082, 0.211, 0.102> 
		<-0.005, 0.209, 0.109> <0.021, 0.209, 0.109> <0.056, 0.205, 0.109> <0.081, 0.205, 0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.078, 0.225, 0.097> <0.099, 0.225, 0.089> <0.128, 0.215, 0.075> <0.143, 0.216, 0.058> 
		<0.079, 0.219, 0.098> <0.100, 0.219, 0.090> <0.127, 0.212, 0.075> <0.143, 0.213, 0.058> 
		<0.082, 0.211, 0.102> <0.103, 0.211, 0.094> <0.127, 0.209, 0.074> <0.141, 0.209, 0.057> 
		<0.081, 0.205, 0.100> <0.101, 0.205, 0.093> <0.125, 0.208, 0.073> <0.139, 0.208, 0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.134, 0.209, -0.058> <0.128, 0.207, -0.056> <0.120, 0.208, -0.054> <0.115, 0.206, -0.052> 
		<0.121, 0.208, -0.073> <0.116, 0.206, -0.071> <0.109, 0.207, -0.066> <0.103, 0.206, -0.064> 
		<0.099, 0.202, -0.088> <0.097, 0.200, -0.087> <0.091, 0.199, -0.085> <0.090, 0.197, -0.084> 
		<0.080, 0.200, -0.094> <0.079, 0.198, -0.093> <0.075, 0.198, -0.091> <0.074, 0.196, -0.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.080, 0.200, -0.094> <0.058, 0.198, -0.102> <0.027, 0.196, -0.102> <0.004, 0.197, -0.103> 
		<0.079, 0.198, -0.093> <0.057, 0.196, -0.101> <0.026, 0.195, -0.099> <0.003, 0.196, -0.099> 
		<0.075, 0.198, -0.091> <0.055, 0.196, -0.098> <0.024, 0.197, -0.094> <0.003, 0.197, -0.094> 
		<0.074, 0.196, -0.090> <0.053, 0.194, -0.096> <0.023, 0.196, -0.091> <0.002, 0.197, -0.091> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.004, 0.197, -0.103> <-0.020, 0.198, -0.103> <-0.051, 0.203, -0.103> <-0.073, 0.205, -0.096> 
		<0.003, 0.196, -0.099> <-0.020, 0.196, -0.100> <-0.050, 0.200, -0.103> <-0.072, 0.202, -0.096> 
		<0.003, 0.197, -0.094> <-0.019, 0.198, -0.094> <-0.050, 0.200, -0.099> <-0.071, 0.201, -0.092> 
		<0.002, 0.197, -0.091> <-0.020, 0.197, -0.091> <-0.049, 0.197, -0.097> <-0.070, 0.199, -0.091> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.073, 0.205, -0.096> <-0.095, 0.207, -0.089> <-0.122, 0.211, -0.071> <-0.139, 0.211, -0.055> 
		<-0.072, 0.202, -0.096> <-0.094, 0.205, -0.088> <-0.117, 0.208, -0.070> <-0.133, 0.207, -0.054> 
		<-0.071, 0.201, -0.092> <-0.088, 0.202, -0.086> <-0.111, 0.207, -0.066> <-0.125, 0.206, -0.053> 
		<-0.070, 0.199, -0.091> <-0.088, 0.200, -0.085> <-0.106, 0.204, -0.066> <-0.119, 0.203, -0.052> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.139, 0.211, -0.055> <-0.152, 0.210, -0.043> <-0.169, 0.205, -0.022> <-0.171, 0.204, -0.003> 
		<-0.133, 0.207, -0.054> <-0.147, 0.207, -0.042> <-0.169, 0.201, -0.021> <-0.170, 0.200, -0.002> 
		<-0.125, 0.206, -0.053> <-0.139, 0.206, -0.039> <-0.163, 0.199, -0.021> <-0.164, 0.198, -0.001> 
		<-0.119, 0.203, -0.052> <-0.133, 0.203, -0.038> <-0.160, 0.196, -0.021> <-0.161, 0.195, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.171, 0.204, -0.003> <-0.172, 0.202, 0.017> <-0.159, 0.199, 0.044> <-0.147, 0.200, 0.059> 
		<-0.170, 0.200, -0.002> <-0.172, 0.198, 0.018> <-0.152, 0.196, 0.040> <-0.139, 0.197, 0.056> 
		<-0.164, 0.198, -0.001> <-0.164, 0.198, 0.017> <-0.141, 0.200, 0.036> <-0.129, 0.201, 0.050> 
		<-0.161, 0.195, -0.000> <-0.161, 0.195, 0.018> <-0.133, 0.199, 0.032> <-0.122, 0.201, 0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.147, 0.200, 0.059> <-0.133, 0.200, 0.076> <-0.108, 0.206, 0.092> <-0.088, 0.208, 0.099> 
		<-0.139, 0.197, 0.056> <-0.126, 0.198, 0.072> <-0.107, 0.204, 0.091> <-0.087, 0.205, 0.098> 
		<-0.129, 0.201, 0.050> <-0.117, 0.203, 0.065> <-0.100, 0.205, 0.090> <-0.082, 0.206, 0.097> 
		<-0.122, 0.201, 0.046> <-0.109, 0.202, 0.061> <-0.098, 0.204, 0.089> <-0.080, 0.204, 0.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.088, 0.208, 0.099> <-0.064, 0.209, 0.107> <-0.030, 0.210, 0.108> <-0.005, 0.209, 0.109> 
		<-0.087, 0.205, 0.098> <-0.063, 0.207, 0.107> <-0.030, 0.206, 0.105> <-0.005, 0.206, 0.105> 
		<-0.082, 0.206, 0.097> <-0.061, 0.206, 0.106> <-0.028, 0.206, 0.099> <-0.005, 0.205, 0.098> 
		<-0.080, 0.204, 0.096> <-0.059, 0.205, 0.105> <-0.028, 0.203, 0.095> <-0.005, 0.203, 0.095> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.005, 0.209, 0.109> <0.021, 0.209, 0.109> <0.056, 0.205, 0.109> <0.081, 0.205, 0.100> 
		<-0.005, 0.206, 0.105> <0.021, 0.206, 0.105> <0.056, 0.202, 0.108> <0.080, 0.202, 0.100> 
		<-0.005, 0.205, 0.098> <0.018, 0.205, 0.098> <0.053, 0.203, 0.102> <0.075, 0.204, 0.094> 
		<-0.005, 0.203, 0.095> <0.018, 0.202, 0.094> <0.051, 0.202, 0.100> <0.072, 0.203, 0.091> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.081, 0.205, 0.100> <0.101, 0.205, 0.093> <0.125, 0.208, 0.073> <0.139, 0.208, 0.056> 
		<0.080, 0.202, 0.100> <0.101, 0.201, 0.092> <0.120, 0.205, 0.070> <0.134, 0.206, 0.053> 
		<0.075, 0.204, 0.094> <0.094, 0.204, 0.087> <0.114, 0.208, 0.064> <0.128, 0.207, 0.048> 
		<0.072, 0.203, 0.091> <0.092, 0.203, 0.084> <0.109, 0.206, 0.061> <0.123, 0.206, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.115, 0.206, -0.052> <0.114, 0.206, -0.051> <0.112, 0.204, -0.051> <0.112, 0.203, -0.050> 
		<0.103, 0.206, -0.064> <0.102, 0.205, -0.064> <0.100, 0.204, -0.063> <0.101, 0.203, -0.063> 
		<0.090, 0.197, -0.084> <0.089, 0.197, -0.083> <0.087, 0.195, -0.083> <0.088, 0.194, -0.083> 
		<0.074, 0.196, -0.090> <0.073, 0.195, -0.089> <0.071, 0.194, -0.088> <0.072, 0.192, -0.088> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.074, 0.196, -0.090> <0.053, 0.194, -0.096> <0.023, 0.196, -0.091> <0.002, 0.197, -0.091> 
		<0.073, 0.195, -0.089> <0.052, 0.194, -0.096> <0.023, 0.196, -0.090> <0.002, 0.197, -0.090> 
		<0.071, 0.194, -0.088> <0.051, 0.192, -0.095> <0.022, 0.196, -0.089> <0.001, 0.196, -0.089> 
		<0.072, 0.192, -0.088> <0.052, 0.191, -0.095> <0.022, 0.196, -0.090> <0.001, 0.196, -0.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.002, 0.197, -0.091> <-0.020, 0.197, -0.091> <-0.049, 0.197, -0.097> <-0.070, 0.199, -0.091> 
		<0.002, 0.197, -0.090> <-0.020, 0.197, -0.090> <-0.049, 0.196, -0.096> <-0.069, 0.197, -0.090> 
		<0.001, 0.196, -0.089> <-0.020, 0.196, -0.089> <-0.049, 0.195, -0.095> <-0.069, 0.196, -0.088> 
		<0.001, 0.196, -0.090> <-0.020, 0.196, -0.090> <-0.049, 0.194, -0.095> <-0.069, 0.194, -0.089> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.070, 0.199, -0.091> <-0.088, 0.200, -0.085> <-0.106, 0.204, -0.066> <-0.119, 0.203, -0.052> 
		<-0.069, 0.197, -0.090> <-0.087, 0.198, -0.084> <-0.104, 0.203, -0.065> <-0.118, 0.203, -0.052> 
		<-0.069, 0.196, -0.088> <-0.086, 0.196, -0.083> <-0.102, 0.201, -0.065> <-0.115, 0.200, -0.052> 
		<-0.069, 0.194, -0.089> <-0.086, 0.195, -0.083> <-0.103, 0.200, -0.065> <-0.116, 0.199, -0.052> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.119, 0.203, -0.052> <-0.133, 0.203, -0.038> <-0.160, 0.196, -0.021> <-0.161, 0.195, -0.000> 
		<-0.118, 0.203, -0.052> <-0.132, 0.202, -0.038> <-0.159, 0.195, -0.020> <-0.160, 0.194, -0.000> 
		<-0.115, 0.200, -0.052> <-0.129, 0.200, -0.038> <-0.157, 0.193, -0.020> <-0.157, 0.192, -0.000> 
		<-0.116, 0.199, -0.052> <-0.130, 0.199, -0.038> <-0.157, 0.191, -0.020> <-0.158, 0.191, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.161, 0.195, -0.000> <-0.161, 0.195, 0.018> <-0.133, 0.199, 0.032> <-0.122, 0.201, 0.046> 
		<-0.160, 0.194, -0.000> <-0.160, 0.194, 0.018> <-0.132, 0.199, 0.032> <-0.120, 0.200, 0.046> 
		<-0.157, 0.192, -0.000> <-0.157, 0.192, 0.018> <-0.129, 0.197, 0.030> <-0.117, 0.199, 0.044> 
		<-0.158, 0.191, -0.000> <-0.158, 0.190, 0.018> <-0.129, 0.196, 0.031> <-0.118, 0.198, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.122, 0.201, 0.046> <-0.109, 0.202, 0.061> <-0.098, 0.204, 0.089> <-0.080, 0.204, 0.096> 
		<-0.120, 0.200, 0.046> <-0.108, 0.202, 0.061> <-0.097, 0.203, 0.088> <-0.079, 0.204, 0.096> 
		<-0.117, 0.199, 0.044> <-0.104, 0.200, 0.059> <-0.095, 0.203, 0.087> <-0.077, 0.203, 0.095> 
		<-0.118, 0.198, 0.045> <-0.105, 0.199, 0.059> <-0.095, 0.201, 0.087> <-0.077, 0.201, 0.095> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.080, 0.204, 0.096> <-0.059, 0.205, 0.105> <-0.028, 0.203, 0.095> <-0.005, 0.203, 0.095> 
		<-0.079, 0.204, 0.096> <-0.058, 0.204, 0.105> <-0.028, 0.202, 0.094> <-0.005, 0.202, 0.093> 
		<-0.077, 0.203, 0.095> <-0.058, 0.203, 0.103> <-0.027, 0.199, 0.093> <-0.006, 0.199, 0.092> 
		<-0.077, 0.201, 0.095> <-0.057, 0.201, 0.103> <-0.027, 0.198, 0.094> <-0.005, 0.198, 0.093> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.005, 0.203, 0.095> <0.018, 0.202, 0.094> <0.051, 0.202, 0.100> <0.072, 0.203, 0.091> 
		<-0.005, 0.202, 0.093> <0.018, 0.201, 0.092> <0.050, 0.202, 0.099> <0.071, 0.202, 0.090> 
		<-0.006, 0.199, 0.092> <0.017, 0.199, 0.091> <0.048, 0.200, 0.096> <0.069, 0.200, 0.088> 
		<-0.005, 0.198, 0.093> <0.017, 0.197, 0.092> <0.049, 0.198, 0.097> <0.070, 0.199, 0.088> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.072, 0.203, 0.091> <0.092, 0.203, 0.084> <0.109, 0.206, 0.061> <0.123, 0.206, 0.045> 
		<0.071, 0.202, 0.090> <0.090, 0.202, 0.083> <0.108, 0.206, 0.060> <0.121, 0.205, 0.044> 
		<0.069, 0.200, 0.088> <0.088, 0.201, 0.081> <0.106, 0.203, 0.059> <0.119, 0.203, 0.044> 
		<0.070, 0.199, 0.088> <0.088, 0.199, 0.081> <0.107, 0.202, 0.060> <0.120, 0.202, 0.044> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.112, 0.203, -0.050> <0.120, 0.198, -0.050> <0.135, 0.195, -0.049> <0.141, 0.187, -0.050> 
		<0.101, 0.203, -0.063> <0.109, 0.197, -0.062> <0.119, 0.194, -0.066> <0.125, 0.187, -0.067> 
		<0.088, 0.194, -0.083> <0.088, 0.191, -0.083> <0.097, 0.189, -0.081> <0.097, 0.187, -0.081> 
		<0.072, 0.192, -0.088> <0.072, 0.190, -0.089> <0.076, 0.188, -0.090> <0.076, 0.185, -0.091> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.072, 0.192, -0.088> <0.052, 0.191, -0.095> <0.022, 0.196, -0.090> <0.001, 0.196, -0.090> 
		<0.072, 0.190, -0.089> <0.052, 0.189, -0.096> <0.020, 0.190, -0.097> <-0.001, 0.190, -0.097> 
		<0.076, 0.188, -0.090> <0.052, 0.186, -0.101> <0.021, 0.186, -0.111> <-0.005, 0.186, -0.111> 
		<0.076, 0.185, -0.091> <0.053, 0.184, -0.101> <0.020, 0.177, -0.115> <-0.005, 0.177, -0.115> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, 0.196, -0.090> <-0.020, 0.196, -0.090> <-0.049, 0.194, -0.095> <-0.069, 0.194, -0.089> 
		<-0.001, 0.190, -0.097> <-0.022, 0.190, -0.097> <-0.049, 0.191, -0.096> <-0.069, 0.191, -0.089> 
		<-0.005, 0.186, -0.111> <-0.026, 0.186, -0.111> <-0.052, 0.189, -0.100> <-0.071, 0.189, -0.092> 
		<-0.005, 0.177, -0.115> <-0.026, 0.177, -0.115> <-0.052, 0.187, -0.101> <-0.072, 0.186, -0.093> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.069, 0.194, -0.089> <-0.086, 0.195, -0.083> <-0.103, 0.200, -0.065> <-0.116, 0.199, -0.052> 
		<-0.069, 0.191, -0.089> <-0.086, 0.192, -0.084> <-0.113, 0.191, -0.067> <-0.125, 0.191, -0.054> 
		<-0.071, 0.189, -0.092> <-0.095, 0.189, -0.083> <-0.124, 0.186, -0.075> <-0.143, 0.186, -0.056> 
		<-0.072, 0.186, -0.093> <-0.096, 0.186, -0.084> <-0.132, 0.176, -0.077> <-0.150, 0.176, -0.058> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.116, 0.199, -0.052> <-0.130, 0.199, -0.038> <-0.157, 0.191, -0.020> <-0.158, 0.191, -0.000> 
		<-0.125, 0.191, -0.054> <-0.140, 0.190, -0.040> <-0.158, 0.188, -0.020> <-0.158, 0.188, 0.000> 
		<-0.143, 0.186, -0.056> <-0.155, 0.185, -0.044> <-0.164, 0.188, -0.018> <-0.163, 0.187, -0.000> 
		<-0.150, 0.176, -0.058> <-0.163, 0.175, -0.045> <-0.164, 0.185, -0.018> <-0.163, 0.184, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.158, 0.191, -0.000> <-0.158, 0.190, 0.018> <-0.129, 0.196, 0.031> <-0.118, 0.198, 0.045> 
		<-0.158, 0.188, 0.000> <-0.158, 0.188, 0.018> <-0.136, 0.186, 0.035> <-0.124, 0.188, 0.049> 
		<-0.163, 0.187, -0.000> <-0.162, 0.185, 0.020> <-0.149, 0.176, 0.043> <-0.136, 0.178, 0.058> 
		<-0.163, 0.184, 0.000> <-0.162, 0.183, 0.020> <-0.156, 0.166, 0.047> <-0.143, 0.168, 0.061> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.118, 0.198, 0.045> <-0.105, 0.199, 0.059> <-0.095, 0.201, 0.087> <-0.077, 0.201, 0.095> 
		<-0.124, 0.188, 0.049> <-0.112, 0.189, 0.064> <-0.094, 0.199, 0.088> <-0.076, 0.199, 0.095> 
		<-0.136, 0.178, 0.058> <-0.120, 0.180, 0.076> <-0.099, 0.196, 0.088> <-0.076, 0.197, 0.097> 
		<-0.143, 0.168, 0.061> <-0.127, 0.169, 0.079> <-0.098, 0.194, 0.089> <-0.076, 0.195, 0.098> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.077, 0.201, 0.095> <-0.057, 0.201, 0.103> <-0.027, 0.198, 0.094> <-0.005, 0.198, 0.093> 
		<-0.076, 0.199, 0.095> <-0.056, 0.199, 0.104> <-0.026, 0.190, 0.100> <-0.005, 0.189, 0.099> 
		<-0.076, 0.197, 0.097> <-0.054, 0.197, 0.106> <-0.027, 0.182, 0.113> <-0.003, 0.182, 0.112> 
		<-0.076, 0.195, 0.098> <-0.054, 0.195, 0.106> <-0.026, 0.173, 0.117> <-0.002, 0.172, 0.117> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.005, 0.198, 0.093> <0.017, 0.197, 0.092> <0.049, 0.198, 0.097> <0.070, 0.199, 0.088> 
		<-0.005, 0.189, 0.099> <0.018, 0.189, 0.098> <0.049, 0.195, 0.097> <0.070, 0.196, 0.089> 
		<-0.003, 0.182, 0.112> <0.022, 0.181, 0.112> <0.051, 0.193, 0.102> <0.073, 0.193, 0.093> 
		<-0.002, 0.172, 0.117> <0.022, 0.171, 0.116> <0.051, 0.189, 0.103> <0.074, 0.190, 0.093> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.070, 0.199, 0.088> <0.088, 0.199, 0.081> <0.107, 0.202, 0.060> <0.120, 0.202, 0.044> 
		<0.070, 0.196, 0.089> <0.089, 0.196, 0.082> <0.115, 0.194, 0.063> <0.128, 0.193, 0.048> 
		<0.073, 0.193, 0.093> <0.098, 0.194, 0.083> <0.128, 0.189, 0.072> <0.145, 0.188, 0.052> 
		<0.074, 0.190, 0.093> <0.098, 0.191, 0.084> <0.134, 0.179, 0.076> <0.151, 0.178, 0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.141, 0.187, -0.050> <0.146, 0.180, -0.051> <0.147, 0.168, -0.057> <0.148, 0.159, -0.058> 
		<0.125, 0.187, -0.067> <0.131, 0.180, -0.068> <0.132, 0.167, -0.073> <0.132, 0.159, -0.074> 
		<0.097, 0.187, -0.081> <0.099, 0.179, -0.083> <0.101, 0.170, -0.084> <0.102, 0.162, -0.085> 
		<0.076, 0.185, -0.091> <0.079, 0.178, -0.092> <0.080, 0.167, -0.093> <0.081, 0.159, -0.093> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.076, 0.185, -0.091> <0.053, 0.184, -0.101> <0.020, 0.177, -0.115> <-0.005, 0.177, -0.115> 
		<0.079, 0.178, -0.092> <0.055, 0.176, -0.102> <0.020, 0.167, -0.119> <-0.006, 0.167, -0.120> 
		<0.080, 0.167, -0.093> <0.056, 0.164, -0.102> <0.024, 0.152, -0.114> <-0.002, 0.152, -0.116> 
		<0.081, 0.159, -0.093> <0.057, 0.156, -0.103> <0.025, 0.141, -0.115> <-0.001, 0.141, -0.116> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.005, 0.177, -0.115> <-0.026, 0.177, -0.115> <-0.052, 0.187, -0.101> <-0.072, 0.186, -0.093> 
		<-0.006, 0.167, -0.120> <-0.027, 0.167, -0.120> <-0.054, 0.179, -0.103> <-0.073, 0.179, -0.095> 
		<-0.002, 0.152, -0.116> <-0.026, 0.152, -0.117> <-0.053, 0.166, -0.106> <-0.075, 0.167, -0.098> 
		<-0.001, 0.141, -0.116> <-0.025, 0.141, -0.117> <-0.054, 0.158, -0.108> <-0.076, 0.159, -0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.072, 0.186, -0.093> <-0.096, 0.186, -0.084> <-0.132, 0.176, -0.077> <-0.150, 0.176, -0.058> 
		<-0.073, 0.179, -0.095> <-0.097, 0.178, -0.086> <-0.136, 0.170, -0.078> <-0.154, 0.170, -0.059> 
		<-0.075, 0.167, -0.098> <-0.099, 0.169, -0.089> <-0.135, 0.160, -0.080> <-0.152, 0.159, -0.061> 
		<-0.076, 0.159, -0.100> <-0.100, 0.161, -0.091> <-0.134, 0.152, -0.080> <-0.151, 0.151, -0.061> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.150, 0.176, -0.058> <-0.163, 0.175, -0.045> <-0.164, 0.185, -0.018> <-0.163, 0.184, 0.000> 
		<-0.154, 0.170, -0.059> <-0.167, 0.169, -0.046> <-0.166, 0.177, -0.017> <-0.165, 0.175, 0.001> 
		<-0.152, 0.159, -0.061> <-0.165, 0.158, -0.046> <-0.166, 0.164, -0.016> <-0.166, 0.163, 0.004> 
		<-0.151, 0.151, -0.061> <-0.164, 0.151, -0.046> <-0.166, 0.155, -0.017> <-0.166, 0.155, 0.003> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.163, 0.184, 0.000> <-0.162, 0.183, 0.020> <-0.156, 0.166, 0.047> <-0.143, 0.168, 0.061> 
		<-0.165, 0.175, 0.001> <-0.164, 0.174, 0.021> <-0.159, 0.161, 0.048> <-0.146, 0.163, 0.063> 
		<-0.166, 0.163, 0.004> <-0.166, 0.163, 0.022> <-0.163, 0.155, 0.048> <-0.150, 0.156, 0.062> 
		<-0.166, 0.155, 0.003> <-0.166, 0.154, 0.021> <-0.163, 0.149, 0.048> <-0.151, 0.150, 0.062> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.143, 0.168, 0.061> <-0.127, 0.169, 0.079> <-0.098, 0.194, 0.089> <-0.076, 0.195, 0.098> 
		<-0.146, 0.163, 0.063> <-0.130, 0.165, 0.081> <-0.098, 0.185, 0.091> <-0.075, 0.186, 0.099> 
		<-0.150, 0.156, 0.062> <-0.132, 0.158, 0.081> <-0.097, 0.175, 0.093> <-0.072, 0.174, 0.102> 
		<-0.151, 0.150, 0.062> <-0.133, 0.153, 0.081> <-0.099, 0.166, 0.094> <-0.073, 0.166, 0.103> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.076, 0.195, 0.098> <-0.054, 0.195, 0.106> <-0.026, 0.173, 0.117> <-0.002, 0.172, 0.117> 
		<-0.075, 0.186, 0.099> <-0.053, 0.187, 0.108> <-0.026, 0.165, 0.120> <-0.002, 0.165, 0.120> 
		<-0.072, 0.174, 0.102> <-0.051, 0.174, 0.110> <-0.025, 0.154, 0.117> <-0.003, 0.154, 0.116> 
		<-0.073, 0.166, 0.103> <-0.052, 0.165, 0.111> <-0.025, 0.146, 0.116> <-0.002, 0.146, 0.115> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.002, 0.172, 0.117> <0.022, 0.171, 0.116> <0.051, 0.189, 0.103> <0.074, 0.190, 0.093> 
		<-0.002, 0.165, 0.120> <0.023, 0.164, 0.119> <0.052, 0.181, 0.104> <0.075, 0.182, 0.095> 
		<-0.003, 0.154, 0.116> <0.021, 0.153, 0.115> <0.051, 0.171, 0.104> <0.074, 0.171, 0.096> 
		<-0.002, 0.146, 0.115> <0.022, 0.146, 0.114> <0.051, 0.163, 0.104> <0.074, 0.163, 0.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.074, 0.190, 0.093> <0.098, 0.191, 0.084> <0.134, 0.179, 0.076> <0.151, 0.178, 0.056> 
		<0.075, 0.182, 0.095> <0.099, 0.183, 0.086> <0.139, 0.171, 0.078> <0.155, 0.170, 0.058> 
		<0.074, 0.171, 0.096> <0.098, 0.172, 0.088> <0.136, 0.157, 0.081> <0.153, 0.157, 0.061> 
		<0.074, 0.163, 0.096> <0.098, 0.163, 0.088> <0.135, 0.148, 0.082> <0.152, 0.148, 0.063> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.148, 0.159, -0.058> <0.149, 0.150, -0.060> <0.147, 0.137, -0.060> <0.145, 0.128, -0.060> 
		<0.132, 0.159, -0.074> <0.133, 0.149, -0.076> <0.131, 0.134, -0.076> <0.129, 0.125, -0.076> 
		<0.102, 0.162, -0.085> <0.102, 0.153, -0.086> <0.101, 0.142, -0.087> <0.100, 0.133, -0.088> 
		<0.081, 0.159, -0.093> <0.081, 0.151, -0.094> <0.081, 0.140, -0.095> <0.079, 0.131, -0.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.081, 0.159, -0.093> <0.057, 0.156, -0.103> <0.025, 0.141, -0.115> <-0.001, 0.141, -0.116> 
		<0.081, 0.151, -0.094> <0.057, 0.148, -0.103> <0.026, 0.133, -0.115> <-0.000, 0.133, -0.116> 
		<0.081, 0.140, -0.095> <0.057, 0.138, -0.104> <0.025, 0.122, -0.114> <0.000, 0.122, -0.116> 
		<0.079, 0.131, -0.096> <0.056, 0.129, -0.105> <0.026, 0.114, -0.113> <0.001, 0.114, -0.115> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.001, 0.141, -0.116> <-0.025, 0.141, -0.117> <-0.054, 0.158, -0.108> <-0.076, 0.159, -0.100> 
		<-0.000, 0.133, -0.116> <-0.024, 0.133, -0.117> <-0.054, 0.150, -0.110> <-0.076, 0.152, -0.102> 
		<0.000, 0.122, -0.116> <-0.024, 0.122, -0.118> <-0.054, 0.140, -0.116> <-0.076, 0.142, -0.108> 
		<0.001, 0.114, -0.115> <-0.023, 0.114, -0.117> <-0.054, 0.132, -0.116> <-0.077, 0.134, -0.108> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.076, 0.159, -0.100> <-0.100, 0.161, -0.091> <-0.134, 0.152, -0.080> <-0.151, 0.151, -0.061> 
		<-0.076, 0.152, -0.102> <-0.100, 0.153, -0.093> <-0.133, 0.145, -0.080> <-0.150, 0.144, -0.061> 
		<-0.076, 0.142, -0.108> <-0.100, 0.144, -0.099> <-0.132, 0.135, -0.080> <-0.148, 0.134, -0.060> 
		<-0.077, 0.134, -0.108> <-0.100, 0.136, -0.099> <-0.129, 0.128, -0.079> <-0.145, 0.127, -0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.151, 0.151, -0.061> <-0.164, 0.151, -0.046> <-0.166, 0.155, -0.017> <-0.166, 0.155, 0.003> 
		<-0.150, 0.144, -0.061> <-0.163, 0.143, -0.046> <-0.165, 0.146, -0.018> <-0.165, 0.146, 0.002> 
		<-0.148, 0.134, -0.060> <-0.158, 0.133, -0.047> <-0.163, 0.136, -0.020> <-0.163, 0.135, -0.003> 
		<-0.145, 0.127, -0.060> <-0.156, 0.126, -0.047> <-0.161, 0.128, -0.022> <-0.161, 0.127, -0.005> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.166, 0.155, 0.003> <-0.166, 0.154, 0.021> <-0.163, 0.149, 0.048> <-0.151, 0.150, 0.062> 
		<-0.165, 0.146, 0.002> <-0.165, 0.146, 0.020> <-0.164, 0.140, 0.048> <-0.152, 0.142, 0.062> 
		<-0.163, 0.135, -0.003> <-0.164, 0.134, 0.017> <-0.161, 0.128, 0.045> <-0.149, 0.130, 0.061> 
		<-0.161, 0.127, -0.005> <-0.161, 0.126, 0.015> <-0.159, 0.119, 0.044> <-0.147, 0.121, 0.061> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.151, 0.150, 0.062> <-0.133, 0.153, 0.081> <-0.099, 0.166, 0.094> <-0.073, 0.166, 0.103> 
		<-0.152, 0.142, 0.062> <-0.134, 0.144, 0.081> <-0.100, 0.158, 0.095> <-0.075, 0.157, 0.104> 
		<-0.149, 0.130, 0.061> <-0.136, 0.132, 0.080> <-0.104, 0.146, 0.097> <-0.082, 0.146, 0.104> 
		<-0.147, 0.121, 0.061> <-0.134, 0.123, 0.080> <-0.106, 0.138, 0.096> <-0.084, 0.138, 0.104> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.073, 0.166, 0.103> <-0.052, 0.165, 0.111> <-0.025, 0.146, 0.116> <-0.002, 0.146, 0.115> 
		<-0.075, 0.157, 0.104> <-0.053, 0.156, 0.112> <-0.024, 0.139, 0.116> <-0.001, 0.139, 0.115> 
		<-0.082, 0.146, 0.104> <-0.056, 0.147, 0.113> <-0.025, 0.129, 0.116> <0.001, 0.129, 0.115> 
		<-0.084, 0.138, 0.104> <-0.059, 0.138, 0.113> <-0.023, 0.122, 0.116> <0.003, 0.122, 0.114> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.002, 0.146, 0.115> <0.022, 0.146, 0.114> <0.051, 0.163, 0.104> <0.074, 0.163, 0.096> 
		<-0.001, 0.139, 0.115> <0.023, 0.138, 0.114> <0.051, 0.155, 0.104> <0.074, 0.155, 0.097> 
		<0.001, 0.129, 0.115> <0.024, 0.129, 0.114> <0.052, 0.145, 0.103> <0.073, 0.145, 0.095> 
		<0.003, 0.122, 0.114> <0.026, 0.122, 0.113> <0.053, 0.137, 0.103> <0.075, 0.137, 0.095> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.074, 0.163, 0.096> <0.098, 0.163, 0.088> <0.135, 0.148, 0.082> <0.152, 0.148, 0.063> 
		<0.074, 0.155, 0.097> <0.098, 0.156, 0.088> <0.134, 0.140, 0.083> <0.151, 0.140, 0.064> 
		<0.073, 0.145, 0.095> <0.095, 0.145, 0.087> <0.132, 0.128, 0.081> <0.148, 0.130, 0.063> 
		<0.075, 0.137, 0.095> <0.097, 0.137, 0.087> <0.129, 0.121, 0.081> <0.144, 0.123, 0.063> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.145, 0.128, -0.060> <0.144, 0.124, -0.060> <0.141, 0.118, -0.059> <0.137, 0.116, -0.057> 
		<0.129, 0.125, -0.076> <0.128, 0.121, -0.076> <0.125, 0.118, -0.076> <0.122, 0.116, -0.074> 
		<0.100, 0.133, -0.088> <0.099, 0.126, -0.088> <0.097, 0.116, -0.090> <0.094, 0.109, -0.089> 
		<0.079, 0.131, -0.096> <0.078, 0.124, -0.096> <0.076, 0.114, -0.099> <0.073, 0.107, -0.097> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.079, 0.131, -0.096> <0.056, 0.129, -0.105> <0.026, 0.114, -0.113> <0.001, 0.114, -0.115> 
		<0.078, 0.124, -0.096> <0.055, 0.122, -0.105> <0.026, 0.111, -0.113> <0.001, 0.111, -0.115> 
		<0.076, 0.114, -0.099> <0.056, 0.112, -0.107> <0.024, 0.107, -0.116> <0.001, 0.107, -0.116> 
		<0.073, 0.107, -0.097> <0.053, 0.105, -0.106> <0.024, 0.106, -0.114> <0.002, 0.106, -0.114> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, 0.114, -0.115> <-0.023, 0.114, -0.117> <-0.054, 0.132, -0.116> <-0.077, 0.134, -0.108> 
		<0.001, 0.111, -0.115> <-0.023, 0.112, -0.117> <-0.055, 0.124, -0.116> <-0.077, 0.126, -0.108> 
		<0.001, 0.107, -0.116> <-0.023, 0.107, -0.116> <-0.057, 0.114, -0.113> <-0.079, 0.116, -0.103> 
		<0.002, 0.106, -0.114> <-0.023, 0.106, -0.114> <-0.056, 0.107, -0.109> <-0.078, 0.109, -0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.077, 0.134, -0.108> <-0.100, 0.136, -0.099> <-0.129, 0.128, -0.079> <-0.145, 0.127, -0.060> 
		<-0.077, 0.126, -0.108> <-0.101, 0.128, -0.099> <-0.128, 0.124, -0.079> <-0.143, 0.123, -0.059> 
		<-0.079, 0.116, -0.103> <-0.100, 0.117, -0.095> <-0.127, 0.118, -0.076> <-0.141, 0.119, -0.059> 
		<-0.078, 0.109, -0.100> <-0.099, 0.111, -0.092> <-0.124, 0.116, -0.075> <-0.137, 0.117, -0.058> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.145, 0.127, -0.060> <-0.156, 0.126, -0.047> <-0.161, 0.128, -0.022> <-0.161, 0.127, -0.005> 
		<-0.143, 0.123, -0.059> <-0.154, 0.122, -0.046> <-0.159, 0.123, -0.023> <-0.160, 0.123, -0.006> 
		<-0.141, 0.119, -0.059> <-0.151, 0.119, -0.046> <-0.157, 0.118, -0.022> <-0.158, 0.116, -0.006> 
		<-0.137, 0.117, -0.058> <-0.148, 0.117, -0.045> <-0.154, 0.114, -0.023> <-0.155, 0.113, -0.007> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.161, 0.127, -0.005> <-0.161, 0.126, 0.015> <-0.159, 0.119, 0.044> <-0.147, 0.121, 0.061> 
		<-0.160, 0.123, -0.006> <-0.160, 0.122, 0.014> <-0.158, 0.115, 0.044> <-0.146, 0.116, 0.061> 
		<-0.158, 0.116, -0.006> <-0.158, 0.114, 0.014> <-0.155, 0.108, 0.044> <-0.143, 0.109, 0.061> 
		<-0.155, 0.113, -0.007> <-0.155, 0.111, 0.014> <-0.150, 0.105, 0.043> <-0.139, 0.106, 0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.147, 0.121, 0.061> <-0.134, 0.123, 0.080> <-0.106, 0.138, 0.096> <-0.084, 0.138, 0.104> 
		<-0.146, 0.116, 0.061> <-0.132, 0.118, 0.080> <-0.107, 0.132, 0.096> <-0.085, 0.132, 0.104> 
		<-0.143, 0.109, 0.061> <-0.132, 0.109, 0.079> <-0.106, 0.122, 0.097> <-0.086, 0.123, 0.104> 
		<-0.139, 0.106, 0.060> <-0.128, 0.107, 0.077> <-0.105, 0.117, 0.095> <-0.085, 0.118, 0.102> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.084, 0.138, 0.104> <-0.059, 0.138, 0.113> <-0.023, 0.122, 0.116> <0.003, 0.122, 0.114> 
		<-0.085, 0.132, 0.104> <-0.060, 0.132, 0.113> <-0.023, 0.120, 0.115> <0.004, 0.119, 0.114> 
		<-0.086, 0.123, 0.104> <-0.060, 0.125, 0.113> <-0.021, 0.116, 0.115> <0.006, 0.115, 0.114> 
		<-0.085, 0.118, 0.102> <-0.059, 0.119, 0.111> <-0.021, 0.115, 0.113> <0.006, 0.114, 0.112> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.003, 0.122, 0.114> <0.026, 0.122, 0.113> <0.053, 0.137, 0.103> <0.075, 0.137, 0.095> 
		<0.004, 0.119, 0.114> <0.027, 0.119, 0.112> <0.055, 0.129, 0.103> <0.076, 0.129, 0.095> 
		<0.006, 0.115, 0.114> <0.030, 0.114, 0.114> <0.060, 0.119, 0.107> <0.083, 0.120, 0.098> 
		<0.006, 0.114, 0.112> <0.030, 0.113, 0.111> <0.062, 0.111, 0.106> <0.084, 0.112, 0.097> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.075, 0.137, 0.095> <0.097, 0.137, 0.087> <0.129, 0.121, 0.081> <0.144, 0.123, 0.063> 
		<0.076, 0.129, 0.095> <0.098, 0.129, 0.087> <0.127, 0.119, 0.081> <0.143, 0.120, 0.063> 
		<0.083, 0.120, 0.098> <0.100, 0.120, 0.091> <0.128, 0.118, 0.080> <0.139, 0.118, 0.064> 
		<0.084, 0.112, 0.097> <0.102, 0.112, 0.091> <0.126, 0.118, 0.078> <0.137, 0.117, 0.063> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.137, 0.116, -0.057> <0.133, 0.114, -0.054> <0.126, 0.115, -0.049> <0.121, 0.113, -0.045> 
		<0.122, 0.116, -0.074> <0.117, 0.113, -0.071> <0.112, 0.115, -0.064> <0.107, 0.113, -0.061> 
		<0.094, 0.109, -0.089> <0.093, 0.106, -0.088> <0.089, 0.107, -0.084> <0.087, 0.106, -0.082> 
		<0.073, 0.107, -0.097> <0.072, 0.105, -0.097> <0.070, 0.106, -0.092> <0.068, 0.105, -0.091> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.073, 0.107, -0.097> <0.053, 0.105, -0.106> <0.024, 0.106, -0.114> <0.002, 0.106, -0.114> 
		<0.072, 0.105, -0.097> <0.052, 0.103, -0.105> <0.024, 0.104, -0.110> <0.002, 0.104, -0.110> 
		<0.070, 0.106, -0.092> <0.051, 0.105, -0.101> <0.022, 0.107, -0.105> <0.001, 0.107, -0.105> 
		<0.068, 0.105, -0.091> <0.050, 0.104, -0.099> <0.022, 0.106, -0.101> <0.001, 0.106, -0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.002, 0.106, -0.114> <-0.023, 0.106, -0.114> <-0.056, 0.107, -0.109> <-0.078, 0.109, -0.100> 
		<0.002, 0.104, -0.110> <-0.023, 0.104, -0.111> <-0.055, 0.105, -0.108> <-0.078, 0.106, -0.098> 
		<0.001, 0.107, -0.105> <-0.021, 0.107, -0.105> <-0.054, 0.106, -0.103> <-0.074, 0.107, -0.095> 
		<0.001, 0.106, -0.101> <-0.021, 0.106, -0.101> <-0.052, 0.105, -0.101> <-0.073, 0.105, -0.093> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.078, 0.109, -0.100> <-0.099, 0.111, -0.092> <-0.124, 0.116, -0.075> <-0.137, 0.117, -0.058> 
		<-0.078, 0.106, -0.098> <-0.098, 0.108, -0.090> <-0.118, 0.113, -0.073> <-0.132, 0.113, -0.056> 
		<-0.074, 0.107, -0.095> <-0.091, 0.107, -0.087> <-0.111, 0.111, -0.066> <-0.123, 0.113, -0.052> 
		<-0.073, 0.105, -0.093> <-0.090, 0.106, -0.085> <-0.105, 0.109, -0.064> <-0.118, 0.110, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.137, 0.117, -0.058> <-0.148, 0.117, -0.045> <-0.154, 0.114, -0.023> <-0.155, 0.113, -0.007> 
		<-0.132, 0.113, -0.056> <-0.142, 0.114, -0.043> <-0.153, 0.113, -0.023> <-0.153, 0.112, -0.007> 
		<-0.123, 0.113, -0.052> <-0.134, 0.114, -0.040> <-0.150, 0.114, -0.023> <-0.150, 0.113, -0.007> 
		<-0.118, 0.110, -0.050> <-0.128, 0.111, -0.038> <-0.148, 0.114, -0.023> <-0.149, 0.113, -0.007> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.155, 0.113, -0.007> <-0.155, 0.111, 0.014> <-0.150, 0.105, 0.043> <-0.139, 0.106, 0.060> 
		<-0.153, 0.112, -0.007> <-0.154, 0.110, 0.014> <-0.145, 0.102, 0.041> <-0.134, 0.103, 0.058> 
		<-0.150, 0.113, -0.007> <-0.151, 0.113, 0.013> <-0.137, 0.106, 0.038> <-0.126, 0.106, 0.055> 
		<-0.149, 0.113, -0.007> <-0.149, 0.112, 0.013> <-0.132, 0.105, 0.036> <-0.120, 0.105, 0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.139, 0.106, 0.060> <-0.128, 0.107, 0.077> <-0.105, 0.117, 0.095> <-0.085, 0.118, 0.102> 
		<-0.134, 0.103, 0.058> <-0.123, 0.104, 0.076> <-0.104, 0.114, 0.094> <-0.084, 0.116, 0.101> 
		<-0.126, 0.106, 0.055> <-0.116, 0.107, 0.070> <-0.098, 0.116, 0.091> <-0.081, 0.118, 0.097> 
		<-0.120, 0.105, 0.053> <-0.111, 0.106, 0.068> <-0.097, 0.116, 0.089> <-0.080, 0.117, 0.095> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.085, 0.118, 0.102> <-0.059, 0.119, 0.111> <-0.021, 0.115, 0.113> <0.006, 0.114, 0.112> 
		<-0.084, 0.116, 0.101> <-0.059, 0.117, 0.110> <-0.021, 0.114, 0.109> <0.006, 0.113, 0.108> 
		<-0.081, 0.118, 0.097> <-0.058, 0.119, 0.106> <-0.020, 0.117, 0.103> <0.005, 0.115, 0.103> 
		<-0.080, 0.117, 0.095> <-0.056, 0.119, 0.104> <-0.021, 0.117, 0.099> <0.004, 0.115, 0.099> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.006, 0.114, 0.112> <0.030, 0.113, 0.111> <0.062, 0.111, 0.106> <0.084, 0.112, 0.097> 
		<0.006, 0.113, 0.108> <0.030, 0.112, 0.108> <0.063, 0.109, 0.105> <0.085, 0.110, 0.097> 
		<0.005, 0.115, 0.103> <0.028, 0.114, 0.102> <0.061, 0.110, 0.103> <0.082, 0.109, 0.093> 
		<0.004, 0.115, 0.099> <0.027, 0.114, 0.098> <0.060, 0.108, 0.102> <0.081, 0.108, 0.092> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.084, 0.112, 0.097> <0.102, 0.112, 0.091> <0.126, 0.118, 0.078> <0.137, 0.117, 0.063> 
		<0.085, 0.110, 0.097> <0.103, 0.110, 0.090> <0.119, 0.116, 0.074> <0.130, 0.115, 0.059> 
		<0.082, 0.109, 0.093> <0.098, 0.109, 0.086> <0.113, 0.116, 0.066> <0.122, 0.116, 0.052> 
		<0.081, 0.108, 0.092> <0.097, 0.108, 0.085> <0.106, 0.115, 0.061> <0.116, 0.115, 0.047> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.121, 0.113, -0.045> <0.120, 0.113, -0.044> <0.119, 0.111, -0.043> <0.119, 0.110, -0.043> 
		<0.107, 0.113, -0.061> <0.106, 0.113, -0.060> <0.104, 0.111, -0.058> <0.105, 0.110, -0.059> 
		<0.087, 0.106, -0.082> <0.086, 0.106, -0.081> <0.085, 0.104, -0.079> <0.085, 0.103, -0.079> 
		<0.068, 0.105, -0.091> <0.067, 0.105, -0.090> <0.065, 0.103, -0.088> <0.065, 0.102, -0.089> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.068, 0.105, -0.091> <0.050, 0.104, -0.099> <0.022, 0.106, -0.101> <0.001, 0.106, -0.101> 
		<0.067, 0.105, -0.090> <0.049, 0.103, -0.098> <0.022, 0.106, -0.100> <0.001, 0.106, -0.100> 
		<0.065, 0.103, -0.088> <0.048, 0.102, -0.097> <0.021, 0.104, -0.100> <0.001, 0.104, -0.100> 
		<0.065, 0.102, -0.089> <0.048, 0.101, -0.097> <0.021, 0.104, -0.100> <0.001, 0.104, -0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, 0.106, -0.101> <-0.021, 0.106, -0.101> <-0.052, 0.105, -0.101> <-0.073, 0.105, -0.093> 
		<0.001, 0.106, -0.100> <-0.021, 0.106, -0.101> <-0.051, 0.104, -0.100> <-0.072, 0.105, -0.092> 
		<0.001, 0.104, -0.100> <-0.021, 0.104, -0.100> <-0.050, 0.103, -0.099> <-0.070, 0.103, -0.090> 
		<0.001, 0.104, -0.100> <-0.021, 0.104, -0.100> <-0.051, 0.102, -0.099> <-0.071, 0.102, -0.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.073, 0.105, -0.093> <-0.090, 0.106, -0.085> <-0.105, 0.109, -0.064> <-0.118, 0.110, -0.050> 
		<-0.072, 0.105, -0.092> <-0.089, 0.105, -0.084> <-0.104, 0.108, -0.063> <-0.117, 0.110, -0.050> 
		<-0.070, 0.103, -0.090> <-0.087, 0.104, -0.083> <-0.103, 0.106, -0.063> <-0.115, 0.108, -0.049> 
		<-0.071, 0.102, -0.090> <-0.087, 0.103, -0.083> <-0.103, 0.105, -0.063> <-0.116, 0.107, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.118, 0.110, -0.050> <-0.128, 0.111, -0.038> <-0.148, 0.114, -0.023> <-0.149, 0.113, -0.007> 
		<-0.117, 0.110, -0.050> <-0.127, 0.111, -0.038> <-0.148, 0.114, -0.023> <-0.148, 0.113, -0.007> 
		<-0.115, 0.108, -0.049> <-0.126, 0.109, -0.038> <-0.147, 0.114, -0.024> <-0.147, 0.113, -0.008> 
		<-0.116, 0.107, -0.050> <-0.126, 0.109, -0.038> <-0.147, 0.113, -0.024> <-0.147, 0.112, -0.008> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.149, 0.113, -0.007> <-0.149, 0.112, 0.013> <-0.132, 0.105, 0.036> <-0.120, 0.105, 0.053> 
		<-0.148, 0.113, -0.007> <-0.149, 0.112, 0.013> <-0.131, 0.105, 0.036> <-0.119, 0.105, 0.053> 
		<-0.147, 0.113, -0.008> <-0.148, 0.112, 0.012> <-0.129, 0.103, 0.036> <-0.117, 0.103, 0.052> 
		<-0.147, 0.112, -0.008> <-0.148, 0.111, 0.012> <-0.130, 0.102, 0.036> <-0.118, 0.102, 0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.120, 0.105, 0.053> <-0.111, 0.106, 0.068> <-0.097, 0.116, 0.089> <-0.080, 0.117, 0.095> 
		<-0.119, 0.105, 0.053> <-0.109, 0.106, 0.068> <-0.096, 0.115, 0.088> <-0.079, 0.117, 0.095> 
		<-0.117, 0.103, 0.052> <-0.108, 0.104, 0.067> <-0.094, 0.115, 0.087> <-0.078, 0.116, 0.093> 
		<-0.118, 0.102, 0.053> <-0.108, 0.103, 0.067> <-0.095, 0.114, 0.087> <-0.078, 0.115, 0.093> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.080, 0.117, 0.095> <-0.056, 0.119, 0.104> <-0.021, 0.117, 0.099> <0.004, 0.115, 0.099> 
		<-0.079, 0.117, 0.095> <-0.056, 0.119, 0.103> <-0.022, 0.117, 0.099> <0.003, 0.115, 0.098> 
		<-0.078, 0.116, 0.093> <-0.056, 0.118, 0.101> <-0.022, 0.116, 0.097> <0.002, 0.114, 0.097> 
		<-0.078, 0.115, 0.093> <-0.056, 0.117, 0.101> <-0.022, 0.115, 0.098> <0.002, 0.114, 0.097> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.004, 0.115, 0.099> <0.027, 0.114, 0.098> <0.060, 0.108, 0.102> <0.081, 0.108, 0.092> 
		<0.003, 0.115, 0.098> <0.027, 0.114, 0.098> <0.060, 0.107, 0.101> <0.081, 0.107, 0.091> 
		<0.002, 0.114, 0.097> <0.026, 0.113, 0.097> <0.060, 0.105, 0.101> <0.082, 0.105, 0.091> 
		<0.002, 0.114, 0.097> <0.026, 0.112, 0.097> <0.060, 0.104, 0.102> <0.082, 0.104, 0.091> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.081, 0.108, 0.092> <0.097, 0.108, 0.085> <0.106, 0.115, 0.061> <0.116, 0.115, 0.047> 
		<0.081, 0.107, 0.091> <0.097, 0.107, 0.084> <0.105, 0.115, 0.061> <0.115, 0.115, 0.046> 
		<0.082, 0.105, 0.091> <0.097, 0.105, 0.083> <0.103, 0.114, 0.058> <0.112, 0.114, 0.044> 
		<0.082, 0.104, 0.091> <0.097, 0.104, 0.084> <0.104, 0.113, 0.059> <0.113, 0.113, 0.044> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.119, 0.110, -0.043> <0.125, 0.103, -0.047> <0.134, 0.098, -0.056> <0.139, 0.090, -0.059> 
		<0.105, 0.110, -0.059> <0.110, 0.103, -0.063> <0.119, 0.098, -0.074> <0.124, 0.090, -0.077> 
		<0.085, 0.103, -0.079> <0.085, 0.101, -0.080> <0.089, 0.098, -0.082> <0.090, 0.095, -0.083> 
		<0.065, 0.102, -0.089> <0.066, 0.100, -0.089> <0.068, 0.097, -0.092> <0.069, 0.095, -0.092> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.065, 0.102, -0.089> <0.048, 0.101, -0.097> <0.021, 0.104, -0.100> <0.001, 0.104, -0.100> 
		<0.066, 0.100, -0.089> <0.048, 0.099, -0.098> <0.020, 0.098, -0.105> <0.001, 0.098, -0.106> 
		<0.068, 0.097, -0.092> <0.047, 0.097, -0.101> <0.022, 0.093, -0.115> <-0.000, 0.093, -0.115> 
		<0.069, 0.095, -0.092> <0.048, 0.094, -0.101> <0.022, 0.086, -0.119> <-0.000, 0.087, -0.119> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, 0.104, -0.100> <-0.021, 0.104, -0.100> <-0.051, 0.102, -0.099> <-0.071, 0.102, -0.090> 
		<0.001, 0.098, -0.106> <-0.021, 0.098, -0.106> <-0.052, 0.099, -0.099> <-0.072, 0.100, -0.090> 
		<-0.000, 0.093, -0.115> <-0.024, 0.093, -0.115> <-0.052, 0.097, -0.102> <-0.075, 0.098, -0.093> 
		<-0.000, 0.087, -0.119> <-0.024, 0.087, -0.120> <-0.054, 0.095, -0.103> <-0.076, 0.096, -0.093> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.071, 0.102, -0.090> <-0.087, 0.103, -0.083> <-0.103, 0.105, -0.063> <-0.116, 0.107, -0.050> 
		<-0.072, 0.100, -0.090> <-0.088, 0.100, -0.083> <-0.110, 0.100, -0.066> <-0.122, 0.101, -0.053> 
		<-0.075, 0.098, -0.093> <-0.095, 0.099, -0.084> <-0.120, 0.096, -0.074> <-0.135, 0.098, -0.058> 
		<-0.076, 0.096, -0.093> <-0.096, 0.096, -0.085> <-0.126, 0.088, -0.076> <-0.140, 0.090, -0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.116, 0.107, -0.050> <-0.126, 0.109, -0.038> <-0.147, 0.113, -0.024> <-0.147, 0.112, -0.008> 
		<-0.122, 0.101, -0.053> <-0.133, 0.103, -0.041> <-0.147, 0.111, -0.023> <-0.148, 0.110, -0.008> 
		<-0.135, 0.098, -0.058> <-0.146, 0.099, -0.045> <-0.150, 0.108, -0.024> <-0.150, 0.107, -0.007> 
		<-0.140, 0.090, -0.060> <-0.151, 0.092, -0.047> <-0.150, 0.106, -0.023> <-0.150, 0.105, -0.006> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.147, 0.112, -0.008> <-0.148, 0.111, 0.012> <-0.130, 0.102, 0.036> <-0.118, 0.102, 0.053> 
		<-0.148, 0.110, -0.008> <-0.148, 0.109, 0.013> <-0.135, 0.095, 0.037> <-0.124, 0.096, 0.054> 
		<-0.150, 0.107, -0.007> <-0.150, 0.106, 0.013> <-0.146, 0.091, 0.040> <-0.135, 0.091, 0.057> 
		<-0.150, 0.105, -0.006> <-0.150, 0.104, 0.015> <-0.152, 0.083, 0.041> <-0.140, 0.083, 0.058> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.118, 0.102, 0.053> <-0.108, 0.103, 0.067> <-0.095, 0.114, 0.087> <-0.078, 0.115, 0.093> 
		<-0.124, 0.096, 0.054> <-0.114, 0.096, 0.068> <-0.095, 0.111, 0.087> <-0.079, 0.112, 0.093> 
		<-0.135, 0.091, 0.057> <-0.123, 0.091, 0.075> <-0.102, 0.108, 0.087> <-0.081, 0.109, 0.095> 
		<-0.140, 0.083, 0.058> <-0.128, 0.083, 0.076> <-0.102, 0.105, 0.088> <-0.082, 0.105, 0.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.078, 0.115, 0.093> <-0.056, 0.117, 0.101> <-0.022, 0.115, 0.098> <0.002, 0.114, 0.097> 
		<-0.079, 0.112, 0.093> <-0.056, 0.114, 0.101> <-0.023, 0.106, 0.102> <0.001, 0.105, 0.102> 
		<-0.081, 0.109, 0.095> <-0.057, 0.109, 0.105> <-0.024, 0.095, 0.111> <0.002, 0.094, 0.111> 
		<-0.082, 0.105, 0.096> <-0.057, 0.105, 0.105> <-0.025, 0.086, 0.114> <0.001, 0.084, 0.114> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.002, 0.114, 0.097> <0.026, 0.112, 0.097> <0.060, 0.104, 0.102> <0.082, 0.104, 0.091> 
		<0.001, 0.105, 0.102> <0.025, 0.103, 0.102> <0.061, 0.102, 0.102> <0.083, 0.101, 0.092> 
		<0.002, 0.094, 0.111> <0.028, 0.092, 0.110> <0.061, 0.099, 0.103> <0.085, 0.099, 0.094> 
		<0.001, 0.084, 0.114> <0.027, 0.083, 0.114> <0.060, 0.096, 0.104> <0.085, 0.096, 0.095> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.082, 0.104, 0.091> <0.097, 0.104, 0.084> <0.104, 0.113, 0.059> <0.113, 0.113, 0.044> 
		<0.083, 0.101, 0.092> <0.098, 0.101, 0.084> <0.111, 0.104, 0.064> <0.120, 0.104, 0.050> 
		<0.085, 0.099, 0.094> <0.103, 0.099, 0.088> <0.122, 0.097, 0.076> <0.132, 0.097, 0.060> 
		<0.085, 0.096, 0.095> <0.102, 0.097, 0.088> <0.128, 0.087, 0.080> <0.138, 0.086, 0.064> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.139, 0.090, -0.059> <0.143, 0.083, -0.062> <0.146, 0.071, -0.061> <0.147, 0.063, -0.062> 
		<0.124, 0.090, -0.077> <0.128, 0.083, -0.080> <0.131, 0.073, -0.080> <0.133, 0.065, -0.081> 
		<0.090, 0.095, -0.083> <0.092, 0.089, -0.085> <0.096, 0.079, -0.085> <0.097, 0.072, -0.086> 
		<0.069, 0.095, -0.092> <0.071, 0.088, -0.094> <0.074, 0.079, -0.095> <0.075, 0.073, -0.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.069, 0.095, -0.092> <0.048, 0.094, -0.101> <0.022, 0.086, -0.119> <-0.000, 0.087, -0.119> 
		<0.071, 0.088, -0.094> <0.050, 0.088, -0.103> <0.022, 0.082, -0.123> <-0.000, 0.082, -0.123> 
		<0.074, 0.079, -0.095> <0.052, 0.080, -0.104> <0.024, 0.073, -0.124> <0.000, 0.074, -0.124> 
		<0.075, 0.073, -0.096> <0.053, 0.073, -0.105> <0.025, 0.068, -0.124> <0.001, 0.068, -0.124> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 0.087, -0.119> <-0.024, 0.087, -0.120> <-0.054, 0.095, -0.103> <-0.076, 0.096, -0.093> 
		<-0.000, 0.082, -0.123> <-0.025, 0.082, -0.123> <-0.056, 0.089, -0.104> <-0.078, 0.090, -0.095> 
		<0.000, 0.074, -0.124> <-0.026, 0.074, -0.124> <-0.058, 0.083, -0.107> <-0.082, 0.082, -0.097> 
		<0.001, 0.068, -0.124> <-0.026, 0.068, -0.125> <-0.059, 0.076, -0.107> <-0.083, 0.075, -0.097> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.076, 0.096, -0.093> <-0.096, 0.096, -0.085> <-0.126, 0.088, -0.076> <-0.140, 0.090, -0.060> 
		<-0.078, 0.090, -0.095> <-0.099, 0.090, -0.086> <-0.131, 0.081, -0.079> <-0.146, 0.083, -0.062> 
		<-0.082, 0.082, -0.097> <-0.104, 0.081, -0.088> <-0.136, 0.069, -0.082> <-0.148, 0.070, -0.063> 
		<-0.083, 0.075, -0.097> <-0.105, 0.074, -0.089> <-0.138, 0.060, -0.082> <-0.150, 0.062, -0.063> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.140, 0.090, -0.060> <-0.151, 0.092, -0.047> <-0.150, 0.106, -0.023> <-0.150, 0.105, -0.006> 
		<-0.146, 0.083, -0.062> <-0.157, 0.085, -0.049> <-0.151, 0.100, -0.019> <-0.151, 0.099, -0.002> 
		<-0.148, 0.070, -0.063> <-0.160, 0.072, -0.043> <-0.150, 0.093, -0.015> <-0.150, 0.093, 0.008> 
		<-0.150, 0.062, -0.063> <-0.162, 0.063, -0.043> <-0.150, 0.086, -0.013> <-0.150, 0.085, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.150, 0.105, -0.006> <-0.150, 0.104, 0.015> <-0.152, 0.083, 0.041> <-0.140, 0.083, 0.058> 
		<-0.151, 0.099, -0.002> <-0.151, 0.098, 0.019> <-0.156, 0.077, 0.042> <-0.144, 0.077, 0.059> 
		<-0.150, 0.093, 0.008> <-0.150, 0.092, 0.025> <-0.157, 0.069, 0.046> <-0.147, 0.067, 0.059> 
		<-0.150, 0.085, 0.010> <-0.149, 0.085, 0.026> <-0.159, 0.062, 0.045> <-0.148, 0.060, 0.058> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.140, 0.083, 0.058> <-0.128, 0.083, 0.076> <-0.102, 0.105, 0.088> <-0.082, 0.105, 0.096> 
		<-0.144, 0.077, 0.059> <-0.132, 0.077, 0.077> <-0.103, 0.095, 0.088> <-0.083, 0.095, 0.096> 
		<-0.147, 0.067, 0.059> <-0.133, 0.064, 0.077> <-0.104, 0.083, 0.086> <-0.083, 0.082, 0.095> 
		<-0.148, 0.060, 0.058> <-0.134, 0.057, 0.076> <-0.104, 0.073, 0.087> <-0.083, 0.072, 0.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.082, 0.105, 0.096> <-0.057, 0.105, 0.105> <-0.025, 0.086, 0.114> <0.001, 0.084, 0.114> 
		<-0.083, 0.095, 0.096> <-0.058, 0.096, 0.106> <-0.026, 0.077, 0.118> <0.000, 0.076, 0.118> 
		<-0.083, 0.082, 0.095> <-0.059, 0.081, 0.105> <-0.028, 0.065, 0.120> <-0.003, 0.064, 0.120> 
		<-0.083, 0.072, 0.096> <-0.059, 0.072, 0.106> <-0.029, 0.056, 0.120> <-0.003, 0.055, 0.120> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, 0.084, 0.114> <0.027, 0.083, 0.114> <0.060, 0.096, 0.104> <0.085, 0.096, 0.095> 
		<0.000, 0.076, 0.118> <0.026, 0.075, 0.117> <0.059, 0.087, 0.105> <0.083, 0.088, 0.096> 
		<-0.003, 0.064, 0.120> <0.022, 0.063, 0.120> <0.053, 0.077, 0.103> <0.076, 0.077, 0.094> 
		<-0.003, 0.055, 0.120> <0.022, 0.054, 0.120> <0.052, 0.068, 0.104> <0.075, 0.068, 0.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.085, 0.096, 0.095> <0.102, 0.097, 0.088> <0.128, 0.087, 0.080> <0.138, 0.086, 0.064> 
		<0.083, 0.088, 0.096> <0.101, 0.088, 0.089> <0.132, 0.079, 0.082> <0.142, 0.078, 0.066> 
		<0.076, 0.077, 0.094> <0.098, 0.077, 0.086> <0.129, 0.065, 0.082> <0.144, 0.065, 0.064> 
		<0.075, 0.068, 0.096> <0.097, 0.068, 0.087> <0.130, 0.056, 0.081> <0.145, 0.055, 0.064> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.147, 0.063, -0.062> <0.149, 0.054, -0.063> <0.151, 0.041, -0.065> <0.148, 0.033, -0.064> 
		<0.133, 0.065, -0.081> <0.134, 0.056, -0.082> <0.137, 0.041, -0.084> <0.134, 0.032, -0.083> 
		<0.097, 0.072, -0.086> <0.099, 0.063, -0.087> <0.100, 0.050, -0.091> <0.101, 0.041, -0.091> 
		<0.075, 0.073, -0.096> <0.077, 0.064, -0.097> <0.079, 0.052, -0.099> <0.080, 0.043, -0.099> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.075, 0.073, -0.096> <0.053, 0.073, -0.105> <0.025, 0.068, -0.124> <0.001, 0.068, -0.124> 
		<0.077, 0.064, -0.097> <0.055, 0.064, -0.106> <0.025, 0.060, -0.124> <0.001, 0.061, -0.125> 
		<0.079, 0.052, -0.099> <0.057, 0.054, -0.108> <0.027, 0.053, -0.123> <0.003, 0.051, -0.123> 
		<0.080, 0.043, -0.099> <0.058, 0.045, -0.108> <0.027, 0.046, -0.122> <0.004, 0.044, -0.122> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, 0.068, -0.124> <-0.026, 0.068, -0.125> <-0.059, 0.076, -0.107> <-0.083, 0.075, -0.097> 
		<0.001, 0.061, -0.125> <-0.025, 0.061, -0.125> <-0.061, 0.062, -0.109> <-0.085, 0.061, -0.099> 
		<0.003, 0.051, -0.123> <-0.025, 0.049, -0.123> <-0.060, 0.044, -0.110> <-0.086, 0.042, -0.100> 
		<0.004, 0.044, -0.122> <-0.024, 0.042, -0.122> <-0.060, 0.030, -0.110> <-0.086, 0.028, -0.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.083, 0.075, -0.097> <-0.105, 0.074, -0.089> <-0.138, 0.060, -0.082> <-0.150, 0.062, -0.063> 
		<-0.085, 0.061, -0.099> <-0.107, 0.060, -0.090> <-0.141, 0.051, -0.082> <-0.153, 0.053, -0.063> 
		<-0.086, 0.042, -0.100> <-0.109, 0.041, -0.092> <-0.147, 0.037, -0.082> <-0.159, 0.041, -0.062> 
		<-0.086, 0.028, -0.100> <-0.109, 0.026, -0.091> <-0.144, 0.028, -0.082> <-0.156, 0.032, -0.061> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.150, 0.062, -0.063> <-0.162, 0.063, -0.043> <-0.150, 0.086, -0.013> <-0.150, 0.085, 0.010> 
		<-0.153, 0.053, -0.063> <-0.165, 0.055, -0.044> <-0.150, 0.075, -0.011> <-0.149, 0.074, 0.012> 
		<-0.159, 0.041, -0.062> <-0.169, 0.044, -0.044> <-0.153, 0.059, -0.013> <-0.151, 0.059, 0.008> 
		<-0.156, 0.032, -0.061> <-0.166, 0.035, -0.044> <-0.149, 0.048, -0.016> <-0.148, 0.049, 0.005> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.150, 0.085, 0.010> <-0.149, 0.085, 0.026> <-0.159, 0.062, 0.045> <-0.148, 0.060, 0.058> 
		<-0.149, 0.074, 0.012> <-0.149, 0.074, 0.028> <-0.160, 0.054, 0.044> <-0.150, 0.052, 0.057> 
		<-0.151, 0.059, 0.008> <-0.150, 0.059, 0.022> <-0.161, 0.044, 0.041> <-0.153, 0.040, 0.053> 
		<-0.148, 0.049, 0.005> <-0.147, 0.049, 0.020> <-0.157, 0.037, 0.040> <-0.149, 0.033, 0.052> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.148, 0.060, 0.058> <-0.134, 0.057, 0.076> <-0.104, 0.073, 0.087> <-0.083, 0.072, 0.096> 
		<-0.150, 0.052, 0.057> <-0.136, 0.049, 0.075> <-0.104, 0.056, 0.088> <-0.083, 0.055, 0.097> 
		<-0.153, 0.040, 0.053> <-0.139, 0.034, 0.074> <-0.107, 0.036, 0.092> <-0.084, 0.033, 0.103> 
		<-0.149, 0.033, 0.052> <-0.136, 0.026, 0.072> <-0.106, 0.020, 0.091> <-0.083, 0.016, 0.102> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.083, 0.072, 0.096> <-0.059, 0.072, 0.106> <-0.029, 0.056, 0.120> <-0.003, 0.055, 0.120> 
		<-0.083, 0.055, 0.097> <-0.059, 0.055, 0.107> <-0.029, 0.043, 0.121> <-0.003, 0.042, 0.121> 
		<-0.084, 0.033, 0.103> <-0.061, 0.030, 0.113> <-0.026, 0.025, 0.118> <-0.001, 0.025, 0.119> 
		<-0.083, 0.016, 0.102> <-0.061, 0.013, 0.112> <-0.027, 0.012, 0.117> <-0.002, 0.013, 0.118> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.003, 0.055, 0.120> <0.022, 0.054, 0.120> <0.052, 0.068, 0.104> <0.075, 0.068, 0.096> 
		<-0.003, 0.042, 0.121> <0.021, 0.042, 0.121> <0.051, 0.053, 0.107> <0.074, 0.053, 0.098> 
		<-0.001, 0.025, 0.119> <0.023, 0.026, 0.120> <0.056, 0.033, 0.116> <0.078, 0.035, 0.107> 
		<-0.002, 0.013, 0.118> <0.022, 0.013, 0.119> <0.055, 0.018, 0.118> <0.078, 0.020, 0.109> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.075, 0.068, 0.096> <0.097, 0.068, 0.087> <0.130, 0.056, 0.081> <0.145, 0.055, 0.064> 
		<0.074, 0.053, 0.098> <0.096, 0.053, 0.090> <0.131, 0.046, 0.080> <0.147, 0.046, 0.063> 
		<0.078, 0.035, 0.107> <0.101, 0.037, 0.098> <0.136, 0.028, 0.081> <0.150, 0.032, 0.061> 
		<0.078, 0.020, 0.109> <0.101, 0.022, 0.100> <0.132, 0.019, 0.080> <0.146, 0.024, 0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.148, 0.033, -0.064> <0.145, 0.027, -0.064> <0.136, 0.026, -0.061> <0.130, 0.023, -0.059> 
		<0.134, 0.032, -0.083> <0.131, 0.027, -0.082> <0.125, 0.023, -0.076> <0.120, 0.021, -0.074> 
		<0.101, 0.041, -0.091> <0.101, 0.037, -0.091> <0.097, 0.032, -0.089> <0.096, 0.028, -0.088> 
		<0.080, 0.043, -0.099> <0.080, 0.039, -0.099> <0.080, 0.033, -0.097> <0.079, 0.029, -0.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.080, 0.043, -0.099> <0.058, 0.045, -0.108> <0.027, 0.046, -0.122> <0.004, 0.044, -0.122> 
		<0.080, 0.039, -0.099> <0.058, 0.040, -0.108> <0.027, 0.043, -0.121> <0.004, 0.040, -0.121> 
		<0.080, 0.033, -0.097> <0.058, 0.034, -0.108> <0.026, 0.037, -0.120> <0.002, 0.035, -0.120> 
		<0.079, 0.029, -0.096> <0.057, 0.031, -0.106> <0.026, 0.033, -0.118> <0.001, 0.032, -0.118> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.004, 0.044, -0.122> <-0.024, 0.042, -0.122> <-0.060, 0.030, -0.110> <-0.086, 0.028, -0.100> 
		<0.004, 0.040, -0.121> <-0.024, 0.038, -0.121> <-0.060, 0.027, -0.110> <-0.086, 0.025, -0.100> 
		<0.002, 0.035, -0.120> <-0.025, 0.034, -0.120> <-0.060, 0.023, -0.108> <-0.085, 0.022, -0.098> 
		<0.001, 0.032, -0.118> <-0.025, 0.030, -0.119> <-0.059, 0.021, -0.106> <-0.084, 0.020, -0.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.086, 0.028, -0.100> <-0.109, 0.026, -0.091> <-0.144, 0.028, -0.082> <-0.156, 0.032, -0.061> 
		<-0.086, 0.025, -0.100> <-0.109, 0.024, -0.091> <-0.143, 0.023, -0.081> <-0.154, 0.027, -0.061> 
		<-0.085, 0.022, -0.098> <-0.103, 0.021, -0.090> <-0.135, 0.023, -0.078> <-0.144, 0.027, -0.061> 
		<-0.084, 0.020, -0.096> <-0.102, 0.019, -0.089> <-0.130, 0.021, -0.078> <-0.139, 0.025, -0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.156, 0.032, -0.061> <-0.166, 0.035, -0.044> <-0.149, 0.048, -0.016> <-0.148, 0.049, 0.005> 
		<-0.154, 0.027, -0.061> <-0.165, 0.030, -0.043> <-0.147, 0.044, -0.017> <-0.146, 0.044, 0.004> 
		<-0.144, 0.027, -0.061> <-0.153, 0.030, -0.045> <-0.139, 0.043, -0.018> <-0.138, 0.042, 0.000> 
		<-0.139, 0.025, -0.060> <-0.148, 0.028, -0.044> <-0.135, 0.041, -0.020> <-0.133, 0.040, -0.002> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.148, 0.049, 0.005> <-0.147, 0.049, 0.020> <-0.157, 0.037, 0.040> <-0.149, 0.033, 0.052> 
		<-0.146, 0.044, 0.004> <-0.145, 0.044, 0.019> <-0.154, 0.031, 0.039> <-0.146, 0.027, 0.051> 
		<-0.138, 0.042, 0.000> <-0.136, 0.042, 0.017> <-0.143, 0.030, 0.038> <-0.135, 0.025, 0.052> 
		<-0.133, 0.040, -0.002> <-0.131, 0.040, 0.015> <-0.138, 0.026, 0.037> <-0.130, 0.021, 0.051> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.149, 0.033, 0.052> <-0.136, 0.026, 0.072> <-0.106, 0.020, 0.091> <-0.083, 0.016, 0.102> 
		<-0.146, 0.027, 0.051> <-0.133, 0.020, 0.071> <-0.106, 0.016, 0.091> <-0.083, 0.013, 0.101> 
		<-0.135, 0.025, 0.052> <-0.126, 0.019, 0.068> <-0.099, 0.012, 0.086> <-0.081, 0.010, 0.095> 
		<-0.130, 0.021, 0.051> <-0.120, 0.015, 0.067> <-0.097, 0.011, 0.083> <-0.079, 0.008, 0.092> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.083, 0.016, 0.102> <-0.061, 0.013, 0.112> <-0.027, 0.012, 0.117> <-0.002, 0.013, 0.118> 
		<-0.083, 0.013, 0.101> <-0.060, 0.009, 0.112> <-0.027, 0.008, 0.116> <-0.002, 0.009, 0.118> 
		<-0.081, 0.010, 0.095> <-0.061, 0.006, 0.106> <-0.028, 0.004, 0.114> <-0.005, 0.005, 0.116> 
		<-0.079, 0.008, 0.092> <-0.059, 0.005, 0.103> <-0.029, 0.001, 0.113> <-0.006, 0.002, 0.115> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.002, 0.013, 0.118> <0.022, 0.013, 0.119> <0.055, 0.018, 0.118> <0.078, 0.020, 0.109> 
		<-0.002, 0.009, 0.118> <0.022, 0.010, 0.119> <0.055, 0.016, 0.118> <0.077, 0.018, 0.110> 
		<-0.005, 0.005, 0.116> <0.019, 0.006, 0.118> <0.053, 0.014, 0.115> <0.075, 0.016, 0.105> 
		<-0.006, 0.002, 0.115> <0.018, 0.003, 0.116> <0.051, 0.013, 0.113> <0.074, 0.016, 0.103> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.078, 0.020, 0.109> <0.101, 0.022, 0.100> <0.132, 0.019, 0.080> <0.146, 0.024, 0.060> 
		<0.077, 0.018, 0.110> <0.101, 0.019, 0.100> <0.129, 0.014, 0.079> <0.143, 0.018, 0.059> 
		<0.075, 0.016, 0.105> <0.094, 0.019, 0.097> <0.122, 0.014, 0.077> <0.133, 0.019, 0.060> 
		<0.074, 0.016, 0.103> <0.093, 0.018, 0.095> <0.116, 0.013, 0.076> <0.127, 0.017, 0.058> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.130, 0.023, -0.059> <0.127, 0.022, -0.057> <0.123, 0.021, -0.054> <0.120, 0.020, -0.053> 
		<0.120, 0.021, -0.074> <0.117, 0.019, -0.073> <0.113, 0.017, -0.069> <0.110, 0.016, -0.067> 
		<0.096, 0.028, -0.088> <0.096, 0.025, -0.086> <0.091, 0.024, -0.083> <0.090, 0.021, -0.081> 
		<0.079, 0.029, -0.096> <0.078, 0.026, -0.094> <0.075, 0.025, -0.091> <0.074, 0.022, -0.089> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.079, 0.029, -0.096> <0.057, 0.031, -0.106> <0.026, 0.033, -0.118> <0.001, 0.032, -0.118> 
		<0.078, 0.026, -0.094> <0.056, 0.028, -0.104> <0.025, 0.031, -0.117> <0.001, 0.030, -0.117> 
		<0.075, 0.025, -0.091> <0.055, 0.026, -0.101> <0.025, 0.030, -0.114> <0.002, 0.029, -0.114> 
		<0.074, 0.022, -0.089> <0.054, 0.023, -0.099> <0.024, 0.028, -0.112> <0.001, 0.027, -0.112> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, 0.032, -0.118> <-0.025, 0.030, -0.119> <-0.059, 0.021, -0.106> <-0.084, 0.020, -0.096> 
		<0.001, 0.030, -0.117> <-0.025, 0.028, -0.117> <-0.058, 0.019, -0.105> <-0.082, 0.018, -0.095> 
		<0.002, 0.029, -0.114> <-0.024, 0.028, -0.114> <-0.057, 0.018, -0.101> <-0.080, 0.016, -0.091> 
		<0.001, 0.027, -0.112> <-0.024, 0.026, -0.112> <-0.056, 0.016, -0.099> <-0.079, 0.015, -0.089> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.084, 0.020, -0.096> <-0.102, 0.019, -0.089> <-0.130, 0.021, -0.078> <-0.139, 0.025, -0.060> 
		<-0.082, 0.018, -0.095> <-0.101, 0.017, -0.087> <-0.127, 0.019, -0.077> <-0.136, 0.023, -0.060> 
		<-0.080, 0.016, -0.091> <-0.097, 0.016, -0.084> <-0.123, 0.018, -0.073> <-0.132, 0.023, -0.058> 
		<-0.079, 0.015, -0.089> <-0.095, 0.014, -0.082> <-0.120, 0.017, -0.072> <-0.129, 0.021, -0.057> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.139, 0.025, -0.060> <-0.148, 0.028, -0.044> <-0.135, 0.041, -0.020> <-0.133, 0.040, -0.002> 
		<-0.136, 0.023, -0.060> <-0.144, 0.027, -0.044> <-0.133, 0.040, -0.021> <-0.131, 0.040, -0.003> 
		<-0.132, 0.023, -0.058> <-0.139, 0.027, -0.044> <-0.129, 0.041, -0.020> <-0.128, 0.040, -0.004> 
		<-0.129, 0.021, -0.057> <-0.136, 0.025, -0.043> <-0.127, 0.040, -0.021> <-0.126, 0.039, -0.005> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.133, 0.040, -0.002> <-0.131, 0.040, 0.015> <-0.138, 0.026, 0.037> <-0.130, 0.021, 0.051> 
		<-0.131, 0.040, -0.003> <-0.130, 0.039, 0.014> <-0.135, 0.024, 0.036> <-0.127, 0.019, 0.050> 
		<-0.128, 0.040, -0.004> <-0.127, 0.039, 0.013> <-0.132, 0.022, 0.034> <-0.124, 0.018, 0.047> 
		<-0.126, 0.039, -0.005> <-0.125, 0.038, 0.012> <-0.130, 0.021, 0.032> <-0.121, 0.016, 0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.130, 0.021, 0.051> <-0.120, 0.015, 0.067> <-0.097, 0.011, 0.083> <-0.079, 0.008, 0.092> 
		<-0.127, 0.019, 0.050> <-0.117, 0.014, 0.067> <-0.095, 0.010, 0.081> <-0.078, 0.007, 0.090> 
		<-0.124, 0.018, 0.047> <-0.114, 0.012, 0.063> <-0.090, 0.011, 0.078> <-0.074, 0.008, 0.087> 
		<-0.121, 0.016, 0.046> <-0.112, 0.011, 0.062> <-0.088, 0.011, 0.075> <-0.072, 0.008, 0.085> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.079, 0.008, 0.092> <-0.059, 0.005, 0.103> <-0.029, 0.001, 0.113> <-0.006, 0.002, 0.115> 
		<-0.078, 0.007, 0.090> <-0.057, 0.004, 0.100> <-0.030, -0.001, 0.112> <-0.007, -0.000, 0.114> 
		<-0.074, 0.008, 0.087> <-0.056, 0.005, 0.097> <-0.029, -0.003, 0.111> <-0.008, -0.002, 0.112> 
		<-0.072, 0.008, 0.085> <-0.054, 0.005, 0.095> <-0.029, -0.005, 0.110> <-0.008, -0.004, 0.111> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.006, 0.002, 0.115> <0.018, 0.003, 0.116> <0.051, 0.013, 0.113> <0.074, 0.016, 0.103> 
		<-0.007, -0.000, 0.114> <0.018, 0.001, 0.116> <0.050, 0.012, 0.111> <0.072, 0.015, 0.101> 
		<-0.008, -0.002, 0.112> <0.016, -0.001, 0.114> <0.048, 0.012, 0.108> <0.070, 0.015, 0.098> 
		<-0.008, -0.004, 0.111> <0.016, -0.003, 0.113> <0.046, 0.011, 0.106> <0.068, 0.015, 0.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.074, 0.016, 0.103> <0.093, 0.018, 0.095> <0.116, 0.013, 0.076> <0.127, 0.017, 0.058> 
		<0.072, 0.015, 0.101> <0.091, 0.017, 0.093> <0.114, 0.012, 0.075> <0.125, 0.016, 0.058> 
		<0.070, 0.015, 0.098> <0.088, 0.018, 0.090> <0.112, 0.012, 0.071> <0.122, 0.017, 0.054> 
		<0.068, 0.015, 0.096> <0.086, 0.018, 0.088> <0.110, 0.012, 0.070> <0.120, 0.016, 0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.120, 0.020, -0.053> <0.119, 0.019, -0.052> <0.116, 0.019, -0.051> <0.116, 0.017, -0.050> 
		<0.110, 0.016, -0.067> <0.109, 0.016, -0.066> <0.107, 0.014, -0.064> <0.107, 0.013, -0.064> 
		<0.090, 0.021, -0.081> <0.089, 0.020, -0.081> <0.088, 0.018, -0.080> <0.089, 0.017, -0.080> 
		<0.074, 0.022, -0.089> <0.074, 0.021, -0.088> <0.073, 0.019, -0.088> <0.074, 0.017, -0.088> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.074, 0.022, -0.089> <0.054, 0.023, -0.099> <0.024, 0.028, -0.112> <0.001, 0.027, -0.112> 
		<0.074, 0.021, -0.088> <0.053, 0.022, -0.099> <0.024, 0.027, -0.111> <0.001, 0.026, -0.111> 
		<0.073, 0.019, -0.088> <0.053, 0.020, -0.098> <0.024, 0.024, -0.110> <0.001, 0.023, -0.110> 
		<0.074, 0.017, -0.088> <0.053, 0.018, -0.099> <0.023, 0.023, -0.110> <-0.000, 0.022, -0.110> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, 0.027, -0.112> <-0.024, 0.026, -0.112> <-0.056, 0.016, -0.099> <-0.079, 0.015, -0.089> 
		<0.001, 0.026, -0.111> <-0.024, 0.024, -0.111> <-0.055, 0.015, -0.098> <-0.078, 0.014, -0.088> 
		<0.001, 0.023, -0.110> <-0.024, 0.022, -0.110> <-0.055, 0.013, -0.097> <-0.077, 0.012, -0.087> 
		<-0.000, 0.022, -0.110> <-0.025, 0.021, -0.110> <-0.055, 0.012, -0.097> <-0.077, 0.011, -0.087> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.079, 0.015, -0.089> <-0.095, 0.014, -0.082> <-0.120, 0.017, -0.072> <-0.129, 0.021, -0.057> 
		<-0.078, 0.014, -0.088> <-0.095, 0.013, -0.081> <-0.119, 0.016, -0.071> <-0.127, 0.020, -0.056> 
		<-0.077, 0.012, -0.087> <-0.093, 0.012, -0.080> <-0.117, 0.014, -0.070> <-0.125, 0.019, -0.056> 
		<-0.077, 0.011, -0.087> <-0.093, 0.010, -0.080> <-0.116, 0.012, -0.070> <-0.125, 0.017, -0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.129, 0.021, -0.057> <-0.136, 0.025, -0.043> <-0.127, 0.040, -0.021> <-0.126, 0.039, -0.005> 
		<-0.127, 0.020, -0.056> <-0.135, 0.024, -0.042> <-0.126, 0.039, -0.022> <-0.125, 0.039, -0.005> 
		<-0.125, 0.019, -0.056> <-0.133, 0.023, -0.043> <-0.125, 0.038, -0.022> <-0.124, 0.038, -0.007> 
		<-0.125, 0.017, -0.055> <-0.132, 0.021, -0.042> <-0.125, 0.037, -0.023> <-0.124, 0.037, -0.007> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.126, 0.039, -0.005> <-0.125, 0.038, 0.012> <-0.130, 0.021, 0.032> <-0.121, 0.016, 0.046> 
		<-0.125, 0.039, -0.005> <-0.124, 0.038, 0.011> <-0.129, 0.020, 0.032> <-0.120, 0.015, 0.046> 
		<-0.124, 0.038, -0.007> <-0.123, 0.037, 0.010> <-0.127, 0.019, 0.030> <-0.118, 0.014, 0.044> 
		<-0.124, 0.037, -0.007> <-0.123, 0.036, 0.010> <-0.127, 0.017, 0.030> <-0.118, 0.013, 0.044> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.121, 0.016, 0.046> <-0.112, 0.011, 0.062> <-0.088, 0.011, 0.075> <-0.072, 0.008, 0.085> 
		<-0.120, 0.015, 0.046> <-0.111, 0.010, 0.061> <-0.087, 0.011, 0.074> <-0.071, 0.008, 0.084> 
		<-0.118, 0.014, 0.044> <-0.109, 0.009, 0.059> <-0.085, 0.011, 0.073> <-0.069, 0.008, 0.082> 
		<-0.118, 0.013, 0.044> <-0.109, 0.007, 0.059> <-0.085, 0.010, 0.072> <-0.069, 0.007, 0.081> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.072, 0.008, 0.085> <-0.054, 0.005, 0.095> <-0.029, -0.005, 0.110> <-0.008, -0.004, 0.111> 
		<-0.071, 0.008, 0.084> <-0.053, 0.005, 0.094> <-0.029, -0.006, 0.109> <-0.008, -0.005, 0.111> 
		<-0.069, 0.008, 0.082> <-0.052, 0.005, 0.093> <-0.029, -0.008, 0.109> <-0.008, -0.007, 0.111> 
		<-0.069, 0.007, 0.081> <-0.052, 0.004, 0.092> <-0.029, -0.009, 0.109> <-0.009, -0.008, 0.111> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.008, -0.004, 0.111> <0.016, -0.003, 0.113> <0.046, 0.011, 0.106> <0.068, 0.015, 0.096> 
		<-0.008, -0.005, 0.111> <0.016, -0.004, 0.113> <0.046, 0.011, 0.105> <0.067, 0.015, 0.095> 
		<-0.008, -0.007, 0.111> <0.015, -0.005, 0.113> <0.044, 0.011, 0.103> <0.066, 0.015, 0.094> 
		<-0.009, -0.008, 0.111> <0.015, -0.006, 0.113> <0.044, 0.010, 0.103> <0.065, 0.013, 0.093> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.068, 0.015, 0.096> <0.086, 0.018, 0.088> <0.110, 0.012, 0.070> <0.120, 0.016, 0.053> 
		<0.067, 0.015, 0.095> <0.086, 0.017, 0.087> <0.109, 0.011, 0.069> <0.119, 0.016, 0.052> 
		<0.066, 0.015, 0.094> <0.084, 0.018, 0.085> <0.108, 0.011, 0.068> <0.118, 0.016, 0.051> 
		<0.065, 0.013, 0.093> <0.083, 0.017, 0.085> <0.108, 0.010, 0.068> <0.118, 0.015, 0.051> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.116, 0.017, -0.050> <0.116, 0.016, -0.050> <0.120, 0.016, -0.052> <0.120, 0.014, -0.052> 
		<0.107, 0.013, -0.064> <0.107, 0.011, -0.064> <0.110, 0.011, -0.066> <0.110, 0.010, -0.066> 
		<0.089, 0.017, -0.080> <0.089, 0.015, -0.081> <0.092, 0.016, -0.083> <0.093, 0.014, -0.084> 
		<0.074, 0.017, -0.088> <0.074, 0.016, -0.089> <0.076, 0.016, -0.091> <0.077, 0.015, -0.092> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.074, 0.017, -0.088> <0.053, 0.018, -0.099> <0.023, 0.023, -0.110> <-0.000, 0.022, -0.110> 
		<0.074, 0.016, -0.089> <0.054, 0.017, -0.099> <0.022, 0.021, -0.110> <-0.001, 0.020, -0.110> 
		<0.076, 0.016, -0.091> <0.054, 0.017, -0.102> <0.023, 0.020, -0.112> <-0.002, 0.020, -0.112> 
		<0.077, 0.015, -0.092> <0.055, 0.016, -0.102> <0.022, 0.019, -0.112> <-0.003, 0.018, -0.112> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 0.022, -0.110> <-0.025, 0.021, -0.110> <-0.055, 0.012, -0.097> <-0.077, 0.011, -0.087> 
		<-0.001, 0.020, -0.110> <-0.025, 0.019, -0.109> <-0.055, 0.011, -0.097> <-0.077, 0.010, -0.088> 
		<-0.002, 0.020, -0.112> <-0.026, 0.019, -0.112> <-0.057, 0.011, -0.100> <-0.079, 0.010, -0.090> 
		<-0.003, 0.018, -0.112> <-0.027, 0.017, -0.111> <-0.057, 0.010, -0.100> <-0.079, 0.009, -0.091> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.077, 0.011, -0.087> <-0.093, 0.010, -0.080> <-0.116, 0.012, -0.070> <-0.125, 0.017, -0.055> 
		<-0.077, 0.010, -0.088> <-0.093, 0.009, -0.081> <-0.116, 0.011, -0.070> <-0.125, 0.016, -0.055> 
		<-0.079, 0.010, -0.090> <-0.095, 0.010, -0.083> <-0.119, 0.011, -0.072> <-0.128, 0.015, -0.056> 
		<-0.079, 0.009, -0.091> <-0.096, 0.009, -0.083> <-0.119, 0.010, -0.072> <-0.128, 0.014, -0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.125, 0.017, -0.055> <-0.132, 0.021, -0.042> <-0.125, 0.037, -0.023> <-0.124, 0.037, -0.007> 
		<-0.125, 0.016, -0.055> <-0.132, 0.020, -0.042> <-0.125, 0.036, -0.023> <-0.124, 0.035, -0.007> 
		<-0.128, 0.015, -0.056> <-0.136, 0.019, -0.043> <-0.128, 0.035, -0.023> <-0.126, 0.034, -0.007> 
		<-0.128, 0.014, -0.056> <-0.135, 0.018, -0.043> <-0.127, 0.033, -0.023> <-0.126, 0.033, -0.007> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.124, 0.037, -0.007> <-0.123, 0.036, 0.010> <-0.127, 0.017, 0.030> <-0.118, 0.013, 0.044> 
		<-0.124, 0.035, -0.007> <-0.123, 0.035, 0.010> <-0.127, 0.016, 0.030> <-0.118, 0.012, 0.044> 
		<-0.126, 0.034, -0.007> <-0.125, 0.033, 0.010> <-0.129, 0.016, 0.032> <-0.120, 0.011, 0.046> 
		<-0.126, 0.033, -0.007> <-0.125, 0.032, 0.010> <-0.129, 0.015, 0.032> <-0.120, 0.010, 0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.118, 0.013, 0.044> <-0.109, 0.007, 0.059> <-0.085, 0.010, 0.072> <-0.069, 0.007, 0.081> 
		<-0.118, 0.012, 0.044> <-0.109, 0.006, 0.059> <-0.085, 0.008, 0.071> <-0.069, 0.005, 0.081> 
		<-0.120, 0.011, 0.046> <-0.111, 0.006, 0.061> <-0.087, 0.007, 0.073> <-0.072, 0.004, 0.082> 
		<-0.120, 0.010, 0.046> <-0.111, 0.005, 0.061> <-0.087, 0.005, 0.073> <-0.072, 0.002, 0.082> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.069, 0.007, 0.081> <-0.052, 0.004, 0.092> <-0.029, -0.009, 0.109> <-0.009, -0.008, 0.111> 
		<-0.069, 0.005, 0.081> <-0.052, 0.002, 0.091> <-0.029, -0.010, 0.109> <-0.009, -0.009, 0.111> 
		<-0.072, 0.004, 0.082> <-0.054, 0.000, 0.093> <-0.031, -0.011, 0.110> <-0.010, -0.010, 0.112> 
		<-0.072, 0.002, 0.082> <-0.054, -0.001, 0.093> <-0.031, -0.013, 0.110> <-0.010, -0.011, 0.112> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.009, -0.008, 0.111> <0.015, -0.006, 0.113> <0.044, 0.010, 0.103> <0.065, 0.013, 0.093> 
		<-0.009, -0.009, 0.111> <0.015, -0.008, 0.113> <0.044, 0.009, 0.103> <0.065, 0.012, 0.093> 
		<-0.010, -0.010, 0.112> <0.015, -0.009, 0.114> <0.045, 0.008, 0.105> <0.067, 0.012, 0.095> 
		<-0.010, -0.011, 0.112> <0.014, -0.010, 0.114> <0.045, 0.007, 0.105> <0.067, 0.011, 0.095> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.065, 0.013, 0.093> <0.083, 0.017, 0.085> <0.108, 0.010, 0.068> <0.118, 0.015, 0.051> 
		<0.065, 0.012, 0.093> <0.083, 0.016, 0.085> <0.108, 0.009, 0.068> <0.118, 0.014, 0.052> 
		<0.067, 0.012, 0.095> <0.085, 0.015, 0.087> <0.110, 0.010, 0.070> <0.120, 0.014, 0.053> 
		<0.067, 0.011, 0.095> <0.085, 0.014, 0.087> <0.110, 0.009, 0.071> <0.121, 0.013, 0.054> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.120, 0.014, -0.052> <0.120, 0.013, -0.051> <0.117, 0.012, -0.050> <0.116, 0.011, -0.049> 
		<0.110, 0.010, -0.066> <0.110, 0.009, -0.065> <0.108, 0.008, -0.064> <0.107, 0.007, -0.063> 
		<0.093, 0.014, -0.084> <0.093, 0.013, -0.084> <0.092, 0.012, -0.083> <0.092, 0.010, -0.083> 
		<0.077, 0.015, -0.092> <0.077, 0.014, -0.092> <0.077, 0.012, -0.091> <0.076, 0.010, -0.091> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.077, 0.015, -0.092> <0.055, 0.016, -0.102> <0.022, 0.019, -0.112> <-0.003, 0.018, -0.112> 
		<0.077, 0.014, -0.092> <0.055, 0.014, -0.103> <0.021, 0.017, -0.112> <-0.003, 0.017, -0.111> 
		<0.077, 0.012, -0.091> <0.054, 0.012, -0.102> <0.021, 0.015, -0.110> <-0.004, 0.015, -0.110> 
		<0.076, 0.010, -0.091> <0.054, 0.011, -0.102> <0.021, 0.014, -0.109> <-0.004, 0.013, -0.109> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.003, 0.018, -0.112> <-0.027, 0.017, -0.111> <-0.057, 0.010, -0.100> <-0.079, 0.009, -0.091> 
		<-0.003, 0.017, -0.111> <-0.027, 0.016, -0.111> <-0.057, 0.009, -0.101> <-0.079, 0.008, -0.091> 
		<-0.004, 0.015, -0.110> <-0.027, 0.014, -0.109> <-0.057, 0.007, -0.099> <-0.078, 0.007, -0.089> 
		<-0.004, 0.013, -0.109> <-0.027, 0.012, -0.109> <-0.057, 0.006, -0.098> <-0.078, 0.005, -0.089> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.079, 0.009, -0.091> <-0.096, 0.009, -0.083> <-0.119, 0.010, -0.072> <-0.128, 0.014, -0.056> 
		<-0.079, 0.008, -0.091> <-0.096, 0.007, -0.084> <-0.119, 0.008, -0.071> <-0.128, 0.012, -0.056> 
		<-0.078, 0.007, -0.089> <-0.094, 0.006, -0.082> <-0.117, 0.007, -0.070> <-0.125, 0.011, -0.055> 
		<-0.078, 0.005, -0.089> <-0.094, 0.005, -0.082> <-0.116, 0.005, -0.070> <-0.124, 0.010, -0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.128, 0.014, -0.056> <-0.135, 0.018, -0.043> <-0.127, 0.033, -0.023> <-0.126, 0.033, -0.007> 
		<-0.128, 0.012, -0.056> <-0.135, 0.016, -0.043> <-0.127, 0.032, -0.023> <-0.126, 0.032, -0.007> 
		<-0.125, 0.011, -0.055> <-0.133, 0.015, -0.042> <-0.125, 0.032, -0.022> <-0.124, 0.031, -0.007> 
		<-0.124, 0.010, -0.055> <-0.132, 0.014, -0.042> <-0.124, 0.031, -0.022> <-0.123, 0.031, -0.006> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.126, 0.033, -0.007> <-0.125, 0.032, 0.010> <-0.129, 0.015, 0.032> <-0.120, 0.010, 0.046> 
		<-0.126, 0.032, -0.007> <-0.125, 0.031, 0.010> <-0.129, 0.014, 0.032> <-0.120, 0.009, 0.046> 
		<-0.124, 0.031, -0.007> <-0.123, 0.031, 0.010> <-0.126, 0.013, 0.031> <-0.118, 0.008, 0.044> 
		<-0.123, 0.031, -0.006> <-0.122, 0.030, 0.010> <-0.125, 0.012, 0.030> <-0.117, 0.007, 0.044> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.120, 0.010, 0.046> <-0.111, 0.005, 0.061> <-0.087, 0.005, 0.073> <-0.072, 0.002, 0.082> 
		<-0.120, 0.009, 0.046> <-0.111, 0.004, 0.061> <-0.088, 0.004, 0.073> <-0.072, 0.001, 0.082> 
		<-0.118, 0.008, 0.044> <-0.109, 0.003, 0.059> <-0.086, 0.003, 0.071> <-0.071, 0.000, 0.081> 
		<-0.117, 0.007, 0.044> <-0.108, 0.002, 0.058> <-0.085, 0.003, 0.071> <-0.070, -0.000, 0.080> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.072, 0.002, 0.082> <-0.054, -0.001, 0.093> <-0.031, -0.013, 0.110> <-0.010, -0.011, 0.112> 
		<-0.072, 0.001, 0.082> <-0.054, -0.002, 0.092> <-0.031, -0.013, 0.110> <-0.010, -0.012, 0.112> 
		<-0.071, 0.000, 0.081> <-0.053, -0.003, 0.091> <-0.030, -0.014, 0.109> <-0.009, -0.013, 0.111> 
		<-0.070, -0.000, 0.080> <-0.053, -0.004, 0.091> <-0.030, -0.015, 0.108> <-0.009, -0.014, 0.110> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.010, -0.011, 0.112> <0.014, -0.010, 0.114> <0.045, 0.007, 0.105> <0.067, 0.011, 0.095> 
		<-0.010, -0.012, 0.112> <0.014, -0.011, 0.114> <0.045, 0.005, 0.105> <0.067, 0.009, 0.095> 
		<-0.009, -0.013, 0.111> <0.014, -0.012, 0.113> <0.044, 0.004, 0.103> <0.066, 0.008, 0.094> 
		<-0.009, -0.014, 0.110> <0.014, -0.012, 0.112> <0.044, 0.003, 0.102> <0.065, 0.007, 0.093> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.067, 0.011, 0.095> <0.085, 0.014, 0.087> <0.110, 0.009, 0.071> <0.121, 0.013, 0.054> 
		<0.067, 0.009, 0.095> <0.085, 0.013, 0.087> <0.111, 0.008, 0.071> <0.121, 0.012, 0.054> 
		<0.066, 0.008, 0.094> <0.084, 0.012, 0.085> <0.109, 0.007, 0.069> <0.120, 0.012, 0.053> 
		<0.065, 0.007, 0.093> <0.083, 0.011, 0.085> <0.109, 0.007, 0.069> <0.119, 0.012, 0.052> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.147, 0.538, 0.010> <-0.152, 0.542, 0.010> <-0.157, 0.549, 0.010> <-0.162, 0.550, 0.010> 
		<-0.147, 0.538, -0.011> <-0.152, 0.542, -0.011> <-0.157, 0.549, -0.008> <-0.162, 0.550, -0.008> 
		<-0.139, 0.526, -0.040> <-0.146, 0.531, -0.037> <-0.155, 0.537, -0.036> <-0.162, 0.539, -0.033> 
		<-0.140, 0.512, -0.056> <-0.147, 0.516, -0.053> <-0.155, 0.524, -0.049> <-0.162, 0.526, -0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.147, 0.538, 0.010> <-0.147, 0.538, -0.011> <-0.139, 0.526, -0.040> <-0.140, 0.512, -0.056> 
		<-0.140, 0.557, 0.010> <-0.140, 0.557, -0.011> <-0.122, 0.543, -0.033> <-0.123, 0.529, -0.049> 
		<-0.099, 0.548, 0.009> <-0.098, 0.546, -0.004> <-0.096, 0.535, -0.027> <-0.088, 0.535, -0.037> 
		<-0.081, 0.559, 0.009> <-0.081, 0.558, -0.004> <-0.079, 0.553, -0.021> <-0.071, 0.552, -0.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.147, 0.538, 0.010> <-0.147, 0.538, 0.032> <-0.139, 0.526, 0.061> <-0.140, 0.512, 0.077> 
		<-0.152, 0.542, 0.010> <-0.152, 0.542, 0.032> <-0.146, 0.531, 0.058> <-0.147, 0.516, 0.074> 
		<-0.157, 0.549, 0.010> <-0.157, 0.549, 0.028> <-0.155, 0.537, 0.056> <-0.155, 0.524, 0.069> 
		<-0.162, 0.550, 0.010> <-0.163, 0.550, 0.028> <-0.163, 0.539, 0.053> <-0.163, 0.526, 0.066> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.147, 0.538, 0.010> <-0.140, 0.557, 0.010> <-0.099, 0.548, 0.009> <-0.081, 0.559, 0.009> 
		<-0.147, 0.538, 0.032> <-0.140, 0.557, 0.032> <-0.099, 0.549, 0.022> <-0.082, 0.561, 0.022> 
		<-0.139, 0.526, 0.061> <-0.123, 0.545, 0.054> <-0.097, 0.543, 0.046> <-0.080, 0.561, 0.040> 
		<-0.140, 0.512, 0.077> <-0.124, 0.531, 0.070> <-0.091, 0.542, 0.058> <-0.074, 0.561, 0.052> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.147, 0.538, 0.010> <-0.147, 0.538, -0.011> <-0.153, 0.514, -0.039> <-0.140, 0.512, -0.056> 
		<-0.140, 0.557, 0.010> <-0.140, 0.557, -0.011> <-0.136, 0.532, -0.032> <-0.123, 0.529, -0.049> 
		<-0.099, 0.548, 0.009> <-0.098, 0.546, -0.004> <-0.096, 0.535, -0.027> <-0.088, 0.535, -0.037> 
		<-0.081, 0.559, 0.009> <-0.081, 0.558, -0.004> <-0.079, 0.553, -0.021> <-0.071, 0.552, -0.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.147, 0.538, 0.010> <-0.147, 0.538, 0.032> <-0.153, 0.517, 0.061> <-0.140, 0.512, 0.077> 
		<-0.140, 0.557, 0.010> <-0.140, 0.557, 0.032> <-0.137, 0.536, 0.054> <-0.124, 0.531, 0.070> 
		<-0.099, 0.548, 0.009> <-0.099, 0.549, 0.022> <-0.097, 0.543, 0.046> <-0.091, 0.542, 0.058> 
		<-0.081, 0.559, 0.009> <-0.082, 0.561, 0.022> <-0.080, 0.561, 0.040> <-0.074, 0.561, 0.052> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.140, 0.512, 0.077> <-0.141, 0.503, 0.087> <-0.152, 0.483, 0.086> <-0.152, 0.470, 0.086> 
		<-0.147, 0.516, 0.074> <-0.148, 0.507, 0.084> <-0.155, 0.483, 0.087> <-0.155, 0.470, 0.087> 
		<-0.155, 0.524, 0.069> <-0.155, 0.512, 0.082> <-0.161, 0.488, 0.090> <-0.159, 0.470, 0.090> 
		<-0.163, 0.526, 0.066> <-0.163, 0.513, 0.079> <-0.165, 0.488, 0.090> <-0.163, 0.470, 0.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.152, 0.470, 0.086> <-0.152, 0.458, 0.086> <-0.142, 0.439, 0.087> <-0.140, 0.433, 0.077> 
		<-0.155, 0.470, 0.087> <-0.155, 0.458, 0.087> <-0.145, 0.434, 0.084> <-0.143, 0.427, 0.074> 
		<-0.159, 0.470, 0.090> <-0.157, 0.451, 0.090> <-0.148, 0.430, 0.083> <-0.145, 0.417, 0.070> 
		<-0.163, 0.470, 0.090> <-0.161, 0.451, 0.090> <-0.154, 0.427, 0.079> <-0.151, 0.414, 0.066> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.140, 0.433, 0.077> <-0.137, 0.421, 0.061> <-0.137, 0.416, 0.031> <-0.137, 0.416, 0.010> 
		<-0.143, 0.427, 0.074> <-0.140, 0.415, 0.057> <-0.139, 0.408, 0.031> <-0.139, 0.408, 0.010> 
		<-0.145, 0.417, 0.070> <-0.142, 0.404, 0.057> <-0.138, 0.395, 0.028> <-0.138, 0.395, 0.010> 
		<-0.151, 0.414, 0.066> <-0.148, 0.401, 0.053> <-0.145, 0.390, 0.028> <-0.145, 0.390, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.137, 0.416, 0.010> <-0.137, 0.416, -0.010> <-0.137, 0.421, -0.040> <-0.140, 0.433, -0.056> 
		<-0.139, 0.408, 0.010> <-0.139, 0.408, -0.010> <-0.140, 0.415, -0.037> <-0.143, 0.427, -0.053> 
		<-0.138, 0.395, 0.010> <-0.138, 0.395, -0.008> <-0.142, 0.404, -0.037> <-0.145, 0.417, -0.049> 
		<-0.145, 0.390, 0.010> <-0.145, 0.390, -0.008> <-0.148, 0.401, -0.033> <-0.151, 0.414, -0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.140, 0.433, -0.056> <-0.142, 0.439, -0.066> <-0.152, 0.458, -0.065> <-0.152, 0.470, -0.065> 
		<-0.143, 0.427, -0.053> <-0.145, 0.434, -0.063> <-0.155, 0.458, -0.066> <-0.155, 0.470, -0.066> 
		<-0.145, 0.417, -0.049> <-0.148, 0.430, -0.062> <-0.157, 0.451, -0.070> <-0.159, 0.470, -0.070> 
		<-0.151, 0.414, -0.046> <-0.153, 0.427, -0.059> <-0.160, 0.451, -0.070> <-0.162, 0.470, -0.070> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.152, 0.470, -0.065> <-0.152, 0.483, -0.065> <-0.141, 0.503, -0.066> <-0.140, 0.512, -0.056> 
		<-0.155, 0.470, -0.066> <-0.155, 0.483, -0.066> <-0.147, 0.507, -0.063> <-0.147, 0.516, -0.053> 
		<-0.159, 0.470, -0.070> <-0.161, 0.488, -0.070> <-0.154, 0.512, -0.062> <-0.155, 0.524, -0.049> 
		<-0.162, 0.470, -0.070> <-0.164, 0.488, -0.070> <-0.162, 0.513, -0.059> <-0.162, 0.526, -0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.162, 0.550, 0.010> <-0.169, 0.551, 0.010> <-0.179, 0.548, 0.010> <-0.183, 0.543, 0.010> 
		<-0.162, 0.550, -0.008> <-0.169, 0.551, -0.008> <-0.179, 0.548, -0.007> <-0.182, 0.543, -0.007> 
		<-0.162, 0.539, -0.033> <-0.168, 0.541, -0.031> <-0.180, 0.537, -0.034> <-0.183, 0.533, -0.030> 
		<-0.162, 0.526, -0.046> <-0.168, 0.528, -0.044> <-0.179, 0.525, -0.045> <-0.182, 0.522, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.162, 0.550, 0.010> <-0.163, 0.550, 0.028> <-0.163, 0.539, 0.053> <-0.163, 0.526, 0.066> 
		<-0.169, 0.551, 0.010> <-0.169, 0.551, 0.028> <-0.168, 0.541, 0.051> <-0.168, 0.528, 0.064> 
		<-0.179, 0.548, 0.010> <-0.179, 0.548, 0.027> <-0.180, 0.537, 0.054> <-0.179, 0.525, 0.065> 
		<-0.183, 0.543, 0.010> <-0.183, 0.543, 0.027> <-0.183, 0.533, 0.050> <-0.183, 0.522, 0.062> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.163, 0.526, 0.066> <-0.163, 0.513, 0.079> <-0.165, 0.488, 0.090> <-0.163, 0.470, 0.090> 
		<-0.168, 0.528, 0.064> <-0.168, 0.515, 0.077> <-0.170, 0.488, 0.089> <-0.168, 0.470, 0.089> 
		<-0.179, 0.525, 0.065> <-0.179, 0.514, 0.077> <-0.179, 0.487, 0.088> <-0.177, 0.470, 0.088> 
		<-0.183, 0.522, 0.062> <-0.182, 0.510, 0.073> <-0.180, 0.487, 0.083> <-0.178, 0.470, 0.083> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.163, 0.470, 0.090> <-0.161, 0.451, 0.090> <-0.154, 0.427, 0.079> <-0.151, 0.414, 0.066> 
		<-0.168, 0.470, 0.089> <-0.166, 0.452, 0.089> <-0.158, 0.424, 0.077> <-0.156, 0.411, 0.064> 
		<-0.177, 0.470, 0.088> <-0.174, 0.453, 0.088> <-0.169, 0.427, 0.077> <-0.167, 0.415, 0.065> 
		<-0.178, 0.470, 0.083> <-0.176, 0.453, 0.083> <-0.172, 0.430, 0.073> <-0.169, 0.418, 0.062> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.151, 0.414, 0.066> <-0.148, 0.401, 0.053> <-0.145, 0.390, 0.028> <-0.145, 0.390, 0.010> 
		<-0.156, 0.411, 0.064> <-0.153, 0.399, 0.051> <-0.150, 0.387, 0.028> <-0.150, 0.387, 0.010> 
		<-0.167, 0.415, 0.065> <-0.164, 0.403, 0.053> <-0.159, 0.393, 0.027> <-0.159, 0.393, 0.010> 
		<-0.169, 0.418, 0.062> <-0.167, 0.407, 0.050> <-0.163, 0.397, 0.027> <-0.163, 0.397, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.145, 0.390, 0.010> <-0.145, 0.390, -0.008> <-0.148, 0.401, -0.033> <-0.151, 0.414, -0.046> 
		<-0.150, 0.387, 0.010> <-0.149, 0.387, -0.008> <-0.153, 0.398, -0.031> <-0.155, 0.411, -0.044> 
		<-0.159, 0.393, 0.010> <-0.159, 0.393, -0.007> <-0.164, 0.403, -0.033> <-0.166, 0.415, -0.045> 
		<-0.163, 0.397, 0.010> <-0.163, 0.397, -0.007> <-0.167, 0.407, -0.030> <-0.169, 0.418, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.151, 0.414, -0.046> <-0.153, 0.427, -0.059> <-0.160, 0.451, -0.070> <-0.162, 0.470, -0.070> 
		<-0.155, 0.411, -0.044> <-0.158, 0.424, -0.057> <-0.165, 0.452, -0.069> <-0.167, 0.470, -0.069> 
		<-0.166, 0.415, -0.045> <-0.169, 0.427, -0.057> <-0.174, 0.453, -0.068> <-0.176, 0.470, -0.068> 
		<-0.169, 0.418, -0.042> <-0.172, 0.430, -0.053> <-0.176, 0.453, -0.063> <-0.178, 0.470, -0.063> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.162, 0.470, -0.070> <-0.164, 0.488, -0.070> <-0.162, 0.513, -0.059> <-0.162, 0.526, -0.046> 
		<-0.167, 0.470, -0.069> <-0.169, 0.488, -0.069> <-0.168, 0.515, -0.057> <-0.168, 0.528, -0.044> 
		<-0.176, 0.470, -0.068> <-0.178, 0.487, -0.068> <-0.178, 0.514, -0.057> <-0.179, 0.525, -0.045> 
		<-0.178, 0.470, -0.063> <-0.180, 0.487, -0.063> <-0.182, 0.510, -0.053> <-0.182, 0.522, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.172, 0.532, 0.010> <-0.172, 0.532, -0.004> <-0.173, 0.524, -0.024> <-0.172, 0.514, -0.034> 
		<-0.176, 0.535, 0.010> <-0.175, 0.535, -0.004> <-0.176, 0.526, -0.026> <-0.175, 0.516, -0.036> 
		<-0.185, 0.539, 0.010> <-0.185, 0.539, -0.007> <-0.185, 0.531, -0.027> <-0.185, 0.519, -0.039> 
		<-0.183, 0.543, 0.010> <-0.182, 0.543, -0.007> <-0.183, 0.533, -0.030> <-0.182, 0.522, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.172, 0.532, 0.010> <-0.176, 0.535, 0.010> <-0.185, 0.539, 0.010> <-0.183, 0.543, 0.010> 
		<-0.173, 0.532, 0.024> <-0.176, 0.535, 0.024> <-0.185, 0.539, 0.027> <-0.183, 0.543, 0.027> 
		<-0.173, 0.524, 0.044> <-0.176, 0.526, 0.046> <-0.186, 0.531, 0.047> <-0.183, 0.533, 0.050> 
		<-0.173, 0.514, 0.054> <-0.176, 0.516, 0.056> <-0.185, 0.519, 0.059> <-0.183, 0.522, 0.062> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.173, 0.514, 0.054> <-0.176, 0.516, 0.056> <-0.185, 0.519, 0.059> <-0.183, 0.522, 0.062> 
		<-0.172, 0.504, 0.064> <-0.175, 0.506, 0.066> <-0.184, 0.507, 0.071> <-0.182, 0.510, 0.073> 
		<-0.170, 0.484, 0.072> <-0.173, 0.484, 0.075> <-0.182, 0.487, 0.079> <-0.180, 0.487, 0.083> 
		<-0.168, 0.470, 0.072> <-0.171, 0.470, 0.075> <-0.180, 0.470, 0.079> <-0.178, 0.470, 0.083> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.168, 0.470, 0.072> <-0.171, 0.470, 0.075> <-0.180, 0.470, 0.079> <-0.178, 0.470, 0.083> 
		<-0.166, 0.456, 0.072> <-0.169, 0.456, 0.075> <-0.177, 0.453, 0.079> <-0.176, 0.453, 0.083> 
		<-0.161, 0.436, 0.064> <-0.164, 0.434, 0.066> <-0.174, 0.433, 0.071> <-0.172, 0.430, 0.073> 
		<-0.160, 0.426, 0.054> <-0.163, 0.424, 0.056> <-0.171, 0.421, 0.059> <-0.169, 0.418, 0.062> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.160, 0.426, 0.054> <-0.163, 0.424, 0.056> <-0.171, 0.421, 0.059> <-0.169, 0.418, 0.062> 
		<-0.159, 0.416, 0.044> <-0.161, 0.414, 0.046> <-0.169, 0.409, 0.047> <-0.167, 0.407, 0.050> 
		<-0.160, 0.408, 0.024> <-0.161, 0.405, 0.024> <-0.165, 0.400, 0.027> <-0.163, 0.397, 0.027> 
		<-0.160, 0.408, 0.010> <-0.161, 0.405, 0.010> <-0.165, 0.400, 0.010> <-0.163, 0.397, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.160, 0.408, 0.010> <-0.161, 0.405, 0.010> <-0.165, 0.400, 0.010> <-0.163, 0.397, 0.010> 
		<-0.160, 0.408, -0.004> <-0.161, 0.405, -0.004> <-0.165, 0.400, -0.007> <-0.163, 0.397, -0.007> 
		<-0.159, 0.416, -0.024> <-0.161, 0.414, -0.026> <-0.169, 0.409, -0.027> <-0.167, 0.407, -0.030> 
		<-0.160, 0.426, -0.034> <-0.163, 0.424, -0.036> <-0.171, 0.421, -0.039> <-0.169, 0.418, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.160, 0.426, -0.034> <-0.163, 0.424, -0.036> <-0.171, 0.421, -0.039> <-0.169, 0.418, -0.042> 
		<-0.161, 0.436, -0.044> <-0.164, 0.434, -0.046> <-0.174, 0.433, -0.051> <-0.172, 0.430, -0.053> 
		<-0.166, 0.456, -0.052> <-0.169, 0.456, -0.055> <-0.177, 0.453, -0.059> <-0.176, 0.453, -0.063> 
		<-0.168, 0.470, -0.052> <-0.171, 0.470, -0.055> <-0.179, 0.470, -0.059> <-0.178, 0.470, -0.063> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.168, 0.470, -0.052> <-0.171, 0.470, -0.055> <-0.179, 0.470, -0.059> <-0.178, 0.470, -0.063> 
		<-0.170, 0.484, -0.052> <-0.173, 0.484, -0.055> <-0.181, 0.487, -0.059> <-0.180, 0.487, -0.063> 
		<-0.172, 0.504, -0.044> <-0.175, 0.506, -0.046> <-0.184, 0.507, -0.051> <-0.182, 0.510, -0.053> 
		<-0.172, 0.514, -0.034> <-0.175, 0.516, -0.036> <-0.185, 0.519, -0.039> <-0.182, 0.522, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.147, 0.538, 0.010> <0.151, 0.542, 0.010> <0.155, 0.549, 0.010> <0.160, 0.550, 0.010> 
		<0.147, 0.538, -0.011> <0.151, 0.542, -0.011> <0.155, 0.549, -0.008> <0.160, 0.550, -0.008> 
		<0.139, 0.526, -0.040> <0.145, 0.531, -0.037> <0.153, 0.537, -0.036> <0.160, 0.539, -0.033> 
		<0.140, 0.512, -0.056> <0.146, 0.516, -0.053> <0.153, 0.525, -0.049> <0.160, 0.526, -0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.147, 0.538, 0.010> <0.147, 0.538, -0.011> <0.139, 0.526, -0.040> <0.140, 0.512, -0.056> 
		<0.140, 0.557, 0.011> <0.140, 0.557, -0.011> <0.122, 0.544, -0.033> <0.123, 0.530, -0.049> 
		<0.099, 0.547, 0.013> <0.100, 0.546, 0.000> <0.096, 0.537, -0.024> <0.088, 0.537, -0.034> 
		<0.082, 0.559, 0.013> <0.084, 0.558, 0.000> <0.079, 0.556, -0.018> <0.071, 0.555, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.147, 0.538, 0.010> <0.147, 0.538, 0.032> <0.139, 0.526, 0.061> <0.140, 0.512, 0.077> 
		<0.151, 0.542, 0.010> <0.151, 0.542, 0.032> <0.145, 0.531, 0.058> <0.146, 0.516, 0.074> 
		<0.155, 0.549, 0.010> <0.155, 0.549, 0.028> <0.153, 0.537, 0.056> <0.153, 0.525, 0.069> 
		<0.160, 0.550, 0.010> <0.160, 0.550, 0.028> <0.160, 0.539, 0.053> <0.160, 0.526, 0.066> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.147, 0.538, 0.010> <0.147, 0.538, 0.032> <0.139, 0.526, 0.061> <0.140, 0.512, 0.077> 
		<0.140, 0.557, 0.011> <0.140, 0.557, 0.033> <0.120, 0.546, 0.054> <0.121, 0.532, 0.070> 
		<0.099, 0.547, 0.013> <0.098, 0.548, 0.026> <0.091, 0.542, 0.047> <0.084, 0.542, 0.058> 
		<0.082, 0.559, 0.013> <0.081, 0.560, 0.026> <0.072, 0.561, 0.041> <0.065, 0.561, 0.051> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.147, 0.538, 0.010> <0.147, 0.538, 0.032> <0.154, 0.516, 0.061> <0.140, 0.512, 0.077> 
		<0.140, 0.557, 0.011> <0.140, 0.557, 0.033> <0.135, 0.536, 0.054> <0.121, 0.532, 0.070> 
		<0.099, 0.547, 0.013> <0.098, 0.548, 0.026> <0.091, 0.542, 0.047> <0.084, 0.542, 0.058> 
		<0.082, 0.559, 0.013> <0.081, 0.560, 0.026> <0.072, 0.561, 0.041> <0.065, 0.561, 0.051> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.147, 0.538, 0.010> <0.140, 0.557, 0.011> <0.099, 0.547, 0.013> <0.082, 0.559, 0.013> 
		<0.147, 0.538, -0.011> <0.140, 0.557, -0.011> <0.100, 0.546, 0.000> <0.084, 0.558, 0.000> 
		<0.151, 0.517, -0.039> <0.134, 0.536, -0.031> <0.096, 0.537, -0.024> <0.079, 0.556, -0.018> 
		<0.140, 0.512, -0.056> <0.123, 0.530, -0.049> <0.088, 0.537, -0.034> <0.071, 0.555, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.140, 0.512, 0.077> <0.141, 0.503, 0.087> <0.152, 0.483, 0.086> <0.152, 0.470, 0.086> 
		<0.146, 0.516, 0.074> <0.147, 0.507, 0.084> <0.154, 0.483, 0.087> <0.154, 0.470, 0.087> 
		<0.153, 0.525, 0.069> <0.153, 0.512, 0.082> <0.159, 0.488, 0.090> <0.157, 0.470, 0.090> 
		<0.160, 0.526, 0.066> <0.160, 0.513, 0.079> <0.162, 0.488, 0.090> <0.160, 0.470, 0.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.152, 0.470, 0.086> <0.152, 0.458, 0.086> <0.142, 0.439, 0.087> <0.140, 0.432, 0.077> 
		<0.154, 0.470, 0.087> <0.154, 0.458, 0.087> <0.145, 0.434, 0.084> <0.143, 0.427, 0.074> 
		<0.157, 0.470, 0.090> <0.156, 0.451, 0.090> <0.146, 0.430, 0.083> <0.143, 0.416, 0.070> 
		<0.160, 0.470, 0.090> <0.158, 0.451, 0.090> <0.151, 0.427, 0.079> <0.148, 0.414, 0.066> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.140, 0.432, 0.077> <0.137, 0.420, 0.061> <0.137, 0.416, 0.031> <0.137, 0.416, 0.010> 
		<0.143, 0.427, 0.074> <0.139, 0.415, 0.057> <0.138, 0.408, 0.031> <0.138, 0.408, 0.010> 
		<0.143, 0.416, 0.070> <0.140, 0.404, 0.057> <0.136, 0.395, 0.028> <0.136, 0.395, 0.010> 
		<0.148, 0.414, 0.066> <0.146, 0.401, 0.053> <0.143, 0.390, 0.028> <0.142, 0.390, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.137, 0.416, 0.010> <0.137, 0.416, -0.010> <0.137, 0.420, -0.040> <0.140, 0.432, -0.056> 
		<0.138, 0.408, 0.010> <0.138, 0.408, -0.010> <0.139, 0.415, -0.037> <0.143, 0.427, -0.053> 
		<0.136, 0.395, 0.010> <0.136, 0.395, -0.008> <0.140, 0.404, -0.037> <0.143, 0.416, -0.049> 
		<0.142, 0.390, 0.010> <0.142, 0.390, -0.008> <0.145, 0.401, -0.033> <0.148, 0.414, -0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.140, 0.432, -0.056> <0.142, 0.439, -0.066> <0.152, 0.458, -0.065> <0.152, 0.470, -0.065> 
		<0.143, 0.427, -0.053> <0.145, 0.434, -0.063> <0.154, 0.458, -0.066> <0.154, 0.470, -0.066> 
		<0.143, 0.416, -0.049> <0.146, 0.430, -0.062> <0.155, 0.451, -0.070> <0.157, 0.470, -0.070> 
		<0.148, 0.414, -0.046> <0.151, 0.427, -0.059> <0.158, 0.451, -0.070> <0.160, 0.470, -0.070> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.152, 0.470, -0.065> <0.152, 0.483, -0.065> <0.141, 0.503, -0.066> <0.140, 0.512, -0.056> 
		<0.154, 0.470, -0.066> <0.154, 0.483, -0.066> <0.147, 0.507, -0.063> <0.146, 0.516, -0.053> 
		<0.157, 0.470, -0.070> <0.159, 0.488, -0.070> <0.153, 0.512, -0.062> <0.153, 0.525, -0.049> 
		<0.160, 0.470, -0.070> <0.162, 0.488, -0.070> <0.160, 0.513, -0.059> <0.160, 0.526, -0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.160, 0.550, 0.010> <0.166, 0.551, 0.010> <0.177, 0.548, 0.010> <0.180, 0.543, 0.010> 
		<0.160, 0.550, -0.008> <0.166, 0.551, -0.008> <0.177, 0.548, -0.007> <0.180, 0.543, -0.007> 
		<0.160, 0.539, -0.033> <0.166, 0.541, -0.031> <0.177, 0.537, -0.034> <0.181, 0.533, -0.030> 
		<0.160, 0.526, -0.046> <0.166, 0.528, -0.044> <0.177, 0.525, -0.045> <0.180, 0.522, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.160, 0.550, 0.010> <0.160, 0.550, 0.028> <0.160, 0.539, 0.053> <0.160, 0.526, 0.066> 
		<0.166, 0.551, 0.010> <0.166, 0.551, 0.028> <0.166, 0.541, 0.051> <0.166, 0.528, 0.064> 
		<0.177, 0.548, 0.010> <0.177, 0.548, 0.027> <0.178, 0.537, 0.054> <0.177, 0.525, 0.065> 
		<0.180, 0.543, 0.010> <0.180, 0.543, 0.027> <0.181, 0.533, 0.050> <0.180, 0.522, 0.062> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.160, 0.526, 0.066> <0.160, 0.513, 0.079> <0.162, 0.488, 0.090> <0.160, 0.470, 0.090> 
		<0.166, 0.528, 0.064> <0.166, 0.515, 0.077> <0.167, 0.488, 0.089> <0.165, 0.470, 0.089> 
		<0.177, 0.525, 0.065> <0.176, 0.514, 0.077> <0.176, 0.487, 0.088> <0.174, 0.470, 0.088> 
		<0.180, 0.522, 0.062> <0.179, 0.510, 0.073> <0.178, 0.487, 0.083> <0.176, 0.470, 0.083> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.160, 0.470, 0.090> <0.158, 0.451, 0.090> <0.151, 0.427, 0.079> <0.148, 0.414, 0.066> 
		<0.165, 0.470, 0.089> <0.163, 0.452, 0.089> <0.156, 0.424, 0.077> <0.153, 0.411, 0.064> 
		<0.174, 0.470, 0.088> <0.172, 0.453, 0.088> <0.167, 0.427, 0.077> <0.164, 0.415, 0.065> 
		<0.176, 0.470, 0.083> <0.174, 0.453, 0.083> <0.169, 0.430, 0.073> <0.167, 0.418, 0.062> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.148, 0.414, 0.066> <0.146, 0.401, 0.053> <0.143, 0.390, 0.028> <0.142, 0.390, 0.010> 
		<0.153, 0.411, 0.064> <0.150, 0.398, 0.051> <0.147, 0.387, 0.028> <0.147, 0.387, 0.010> 
		<0.164, 0.415, 0.065> <0.162, 0.403, 0.053> <0.157, 0.393, 0.027> <0.157, 0.393, 0.010> 
		<0.167, 0.418, 0.062> <0.164, 0.407, 0.050> <0.160, 0.397, 0.027> <0.160, 0.397, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.142, 0.390, 0.010> <0.142, 0.390, -0.008> <0.145, 0.401, -0.033> <0.148, 0.414, -0.046> 
		<0.147, 0.387, 0.010> <0.147, 0.387, -0.008> <0.150, 0.398, -0.031> <0.153, 0.411, -0.044> 
		<0.157, 0.393, 0.010> <0.156, 0.393, -0.007> <0.161, 0.403, -0.033> <0.164, 0.415, -0.045> 
		<0.160, 0.397, 0.010> <0.160, 0.397, -0.007> <0.164, 0.407, -0.030> <0.167, 0.418, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.148, 0.414, -0.046> <0.151, 0.427, -0.059> <0.158, 0.451, -0.070> <0.160, 0.470, -0.070> 
		<0.153, 0.411, -0.044> <0.156, 0.424, -0.057> <0.163, 0.452, -0.069> <0.165, 0.470, -0.069> 
		<0.164, 0.415, -0.045> <0.166, 0.427, -0.057> <0.172, 0.453, -0.068> <0.174, 0.470, -0.068> 
		<0.167, 0.418, -0.042> <0.169, 0.430, -0.053> <0.173, 0.453, -0.063> <0.175, 0.470, -0.063> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.160, 0.470, -0.070> <0.162, 0.488, -0.070> <0.160, 0.513, -0.059> <0.160, 0.526, -0.046> 
		<0.165, 0.470, -0.069> <0.167, 0.488, -0.069> <0.166, 0.515, -0.057> <0.166, 0.528, -0.044> 
		<0.174, 0.470, -0.068> <0.176, 0.487, -0.068> <0.176, 0.514, -0.057> <0.177, 0.525, -0.045> 
		<0.175, 0.470, -0.063> <0.177, 0.487, -0.063> <0.179, 0.510, -0.053> <0.180, 0.522, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.170, 0.532, 0.010> <0.170, 0.532, -0.004> <0.171, 0.524, -0.024> <0.170, 0.514, -0.034> 
		<0.173, 0.535, 0.010> <0.173, 0.535, -0.004> <0.174, 0.526, -0.026> <0.173, 0.516, -0.036> 
		<0.182, 0.539, 0.010> <0.182, 0.539, -0.007> <0.183, 0.531, -0.027> <0.182, 0.519, -0.039> 
		<0.180, 0.543, 0.010> <0.180, 0.543, -0.007> <0.181, 0.533, -0.030> <0.180, 0.522, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.170, 0.532, 0.010> <0.173, 0.535, 0.010> <0.182, 0.539, 0.010> <0.180, 0.543, 0.010> 
		<0.170, 0.532, 0.024> <0.173, 0.535, 0.024> <0.182, 0.539, 0.027> <0.180, 0.543, 0.027> 
		<0.171, 0.524, 0.044> <0.174, 0.526, 0.046> <0.183, 0.531, 0.047> <0.181, 0.533, 0.050> 
		<0.170, 0.514, 0.054> <0.173, 0.516, 0.056> <0.182, 0.519, 0.059> <0.180, 0.522, 0.062> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.170, 0.514, 0.054> <0.173, 0.516, 0.056> <0.182, 0.519, 0.059> <0.180, 0.522, 0.062> 
		<0.169, 0.504, 0.064> <0.172, 0.506, 0.066> <0.182, 0.507, 0.071> <0.179, 0.510, 0.073> 
		<0.168, 0.484, 0.072> <0.171, 0.484, 0.075> <0.179, 0.487, 0.079> <0.178, 0.487, 0.083> 
		<0.166, 0.470, 0.072> <0.169, 0.470, 0.075> <0.177, 0.470, 0.079> <0.176, 0.470, 0.083> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.166, 0.470, 0.072> <0.169, 0.470, 0.075> <0.177, 0.470, 0.079> <0.176, 0.470, 0.083> 
		<0.164, 0.456, 0.072> <0.167, 0.456, 0.075> <0.175, 0.453, 0.079> <0.174, 0.453, 0.083> 
		<0.159, 0.436, 0.064> <0.162, 0.434, 0.066> <0.171, 0.433, 0.071> <0.169, 0.430, 0.073> 
		<0.158, 0.426, 0.054> <0.160, 0.424, 0.056> <0.169, 0.421, 0.059> <0.167, 0.418, 0.062> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.158, 0.426, 0.054> <0.160, 0.424, 0.056> <0.169, 0.421, 0.059> <0.167, 0.418, 0.062> 
		<0.156, 0.416, 0.044> <0.159, 0.414, 0.046> <0.166, 0.409, 0.047> <0.164, 0.407, 0.050> 
		<0.158, 0.408, 0.024> <0.158, 0.405, 0.024> <0.162, 0.400, 0.027> <0.160, 0.397, 0.027> 
		<0.158, 0.408, 0.010> <0.158, 0.405, 0.010> <0.162, 0.400, 0.010> <0.160, 0.397, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.158, 0.408, 0.010> <0.158, 0.405, 0.010> <0.162, 0.400, 0.010> <0.160, 0.397, 0.010> 
		<0.157, 0.408, -0.004> <0.158, 0.405, -0.004> <0.162, 0.400, -0.007> <0.160, 0.397, -0.007> 
		<0.156, 0.416, -0.024> <0.159, 0.414, -0.026> <0.166, 0.409, -0.027> <0.164, 0.407, -0.030> 
		<0.157, 0.426, -0.034> <0.160, 0.424, -0.036> <0.169, 0.421, -0.039> <0.167, 0.418, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.157, 0.426, -0.034> <0.160, 0.424, -0.036> <0.169, 0.421, -0.039> <0.167, 0.418, -0.042> 
		<0.159, 0.436, -0.044> <0.162, 0.434, -0.046> <0.171, 0.433, -0.051> <0.169, 0.430, -0.053> 
		<0.164, 0.456, -0.052> <0.167, 0.456, -0.055> <0.175, 0.453, -0.059> <0.173, 0.453, -0.063> 
		<0.166, 0.470, -0.052> <0.169, 0.470, -0.055> <0.177, 0.470, -0.059> <0.175, 0.470, -0.063> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.166, 0.470, -0.052> <0.169, 0.470, -0.055> <0.177, 0.470, -0.059> <0.175, 0.470, -0.063> 
		<0.168, 0.484, -0.052> <0.171, 0.484, -0.055> <0.179, 0.487, -0.059> <0.177, 0.487, -0.063> 
		<0.169, 0.504, -0.044> <0.172, 0.506, -0.046> <0.181, 0.507, -0.051> <0.179, 0.510, -0.053> 
		<0.170, 0.514, -0.034> <0.173, 0.516, -0.036> <0.182, 0.519, -0.039> <0.180, 0.522, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.082, 0.559, 0.013> <0.081, 0.560, 0.026> <0.072, 0.561, 0.041> <0.065, 0.561, 0.051> 
		<0.077, 0.563, 0.013> <0.076, 0.564, 0.026> <0.067, 0.566, 0.039> <0.060, 0.566, 0.050> 
		<0.086, 0.575, 0.011> <0.086, 0.575, 0.025> <0.080, 0.573, 0.044> <0.074, 0.575, 0.056> 
		<0.085, 0.582, 0.010> <0.085, 0.582, 0.024> <0.080, 0.579, 0.043> <0.073, 0.582, 0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.082, 0.559, 0.013> <0.084, 0.558, 0.000> <0.079, 0.556, -0.018> <0.071, 0.555, -0.028> 
		<0.077, 0.563, 0.013> <0.078, 0.562, 0.000> <0.073, 0.561, -0.016> <0.065, 0.561, -0.027> 
		<0.086, 0.575, 0.011> <0.086, 0.575, -0.003> <0.082, 0.574, -0.023> <0.075, 0.574, -0.035> 
		<0.085, 0.582, 0.010> <0.085, 0.582, -0.003> <0.080, 0.582, -0.022> <0.073, 0.582, -0.034> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.071, 0.555, -0.028> <0.064, 0.555, -0.037> <0.047, 0.558, -0.040> <0.036, 0.557, -0.045> 
		<0.065, 0.561, -0.027> <0.058, 0.561, -0.036> <0.040, 0.566, -0.039> <0.030, 0.565, -0.044> 
		<0.075, 0.574, -0.035> <0.068, 0.574, -0.047> <0.052, 0.573, -0.055> <0.039, 0.573, -0.063> 
		<0.073, 0.582, -0.034> <0.066, 0.582, -0.047> <0.051, 0.582, -0.061> <0.039, 0.582, -0.069> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.036, 0.557, -0.045> <0.027, 0.557, -0.049> <0.014, 0.554, -0.058> <0.004, 0.554, -0.058> 
		<0.030, 0.565, -0.044> <0.020, 0.565, -0.048> <0.014, 0.564, -0.056> <0.004, 0.564, -0.056> 
		<0.039, 0.573, -0.063> <0.028, 0.573, -0.069> <0.011, 0.572, -0.074> <-0.001, 0.572, -0.074> 
		<0.039, 0.582, -0.069> <0.028, 0.582, -0.075> <0.011, 0.581, -0.078> <-0.002, 0.581, -0.078> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.004, 0.554, -0.058> <-0.009, 0.554, -0.059> <-0.026, 0.557, -0.052> <-0.038, 0.556, -0.047> 
		<0.004, 0.564, -0.056> <-0.009, 0.564, -0.057> <-0.019, 0.564, -0.052> <-0.032, 0.564, -0.048> 
		<-0.001, 0.572, -0.074> <-0.014, 0.572, -0.074> <-0.034, 0.573, -0.071> <-0.045, 0.573, -0.064> 
		<-0.002, 0.581, -0.078> <-0.015, 0.581, -0.078> <-0.034, 0.582, -0.076> <-0.045, 0.582, -0.069> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.038, 0.556, -0.047> <-0.049, 0.556, -0.043> <-0.065, 0.552, -0.040> <-0.071, 0.552, -0.031> 
		<-0.032, 0.564, -0.048> <-0.042, 0.564, -0.044> <-0.059, 0.558, -0.038> <-0.065, 0.558, -0.029> 
		<-0.045, 0.573, -0.064> <-0.057, 0.573, -0.057> <-0.069, 0.573, -0.047> <-0.075, 0.573, -0.035> 
		<-0.045, 0.582, -0.069> <-0.056, 0.582, -0.062> <-0.067, 0.582, -0.046> <-0.073, 0.582, -0.034> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.071, 0.552, -0.031> <-0.079, 0.553, -0.021> <-0.081, 0.558, -0.004> <-0.081, 0.559, 0.009> 
		<-0.065, 0.558, -0.029> <-0.073, 0.559, -0.019> <-0.076, 0.562, -0.004> <-0.076, 0.563, 0.009> 
		<-0.075, 0.573, -0.035> <-0.081, 0.573, -0.023> <-0.086, 0.575, -0.004> <-0.086, 0.575, 0.010> 
		<-0.073, 0.582, -0.034> <-0.079, 0.581, -0.022> <-0.085, 0.582, -0.003> <-0.085, 0.582, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.081, 0.559, 0.009> <-0.082, 0.561, 0.022> <-0.080, 0.561, 0.040> <-0.074, 0.561, 0.052> 
		<-0.076, 0.563, 0.009> <-0.076, 0.565, 0.022> <-0.076, 0.566, 0.039> <-0.069, 0.565, 0.051> 
		<-0.086, 0.575, 0.010> <-0.086, 0.575, 0.024> <-0.081, 0.573, 0.044> <-0.075, 0.575, 0.056> 
		<-0.085, 0.582, 0.010> <-0.085, 0.582, 0.024> <-0.080, 0.579, 0.043> <-0.073, 0.582, 0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.074, 0.561, 0.052> <-0.067, 0.560, 0.064> <-0.054, 0.557, 0.076> <-0.042, 0.556, 0.082> 
		<-0.069, 0.565, 0.051> <-0.063, 0.565, 0.062> <-0.049, 0.568, 0.076> <-0.037, 0.567, 0.081> 
		<-0.075, 0.575, 0.056> <-0.068, 0.578, 0.067> <-0.055, 0.583, 0.080> <-0.044, 0.585, 0.087> 
		<-0.073, 0.582, 0.055> <-0.067, 0.584, 0.067> <-0.055, 0.595, 0.078> <-0.044, 0.598, 0.085> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.042, 0.556, 0.082> <-0.029, 0.555, 0.088> <-0.010, 0.554, 0.089> <0.004, 0.554, 0.088> 
		<-0.037, 0.567, 0.081> <-0.024, 0.566, 0.087> <-0.012, 0.567, 0.088> <0.002, 0.567, 0.088> 
		<-0.044, 0.585, 0.087> <-0.032, 0.587, 0.094> <-0.013, 0.583, 0.102> <0.001, 0.583, 0.103> 
		<-0.044, 0.598, 0.085> <-0.032, 0.600, 0.093> <-0.014, 0.596, 0.101> <0.000, 0.596, 0.102> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.004, 0.554, 0.088> <0.015, 0.555, 0.088> <0.029, 0.558, 0.084> <0.038, 0.559, 0.078> 
		<0.002, 0.567, 0.088> <0.013, 0.568, 0.087> <0.024, 0.568, 0.083> <0.034, 0.569, 0.077> 
		<0.001, 0.583, 0.103> <0.014, 0.583, 0.103> <0.031, 0.587, 0.096> <0.042, 0.585, 0.089> 
		<0.000, 0.596, 0.102> <0.014, 0.596, 0.102> <0.031, 0.598, 0.094> <0.042, 0.596, 0.087> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.038, 0.559, 0.078> <0.048, 0.560, 0.072> <0.058, 0.561, 0.061> <0.065, 0.561, 0.051> 
		<0.034, 0.569, 0.077> <0.043, 0.571, 0.071> <0.054, 0.566, 0.059> <0.060, 0.566, 0.050> 
		<0.042, 0.585, 0.089> <0.054, 0.582, 0.082> <0.067, 0.577, 0.068> <0.074, 0.575, 0.056> 
		<0.042, 0.596, 0.087> <0.054, 0.594, 0.080> <0.066, 0.584, 0.067> <0.073, 0.582, 0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.085, 0.582, 0.010> <0.085, 0.582, 0.024> <0.080, 0.579, 0.043> <0.073, 0.582, 0.055> 
		<0.082, 0.590, 0.010> <0.082, 0.590, 0.024> <0.079, 0.589, 0.042> <0.072, 0.592, 0.054> 
		<0.079, 0.611, 0.010> <0.079, 0.613, 0.020> <0.075, 0.614, 0.040> <0.069, 0.614, 0.049> 
		<0.070, 0.609, 0.010> <0.070, 0.611, 0.020> <0.066, 0.611, 0.035> <0.061, 0.611, 0.044> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.085, 0.582, 0.010> <0.085, 0.582, -0.003> <0.080, 0.582, -0.022> <0.073, 0.582, -0.034> 
		<0.082, 0.590, 0.010> <0.082, 0.590, -0.004> <0.078, 0.589, -0.022> <0.071, 0.589, -0.034> 
		<0.079, 0.611, 0.010> <0.079, 0.610, -0.002> <0.069, 0.603, -0.019> <0.065, 0.602, -0.030> 
		<0.070, 0.609, 0.010> <0.070, 0.607, -0.002> <0.063, 0.601, -0.015> <0.059, 0.600, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.073, 0.582, -0.034> <0.066, 0.582, -0.047> <0.051, 0.582, -0.061> <0.039, 0.582, -0.069> 
		<0.071, 0.589, -0.034> <0.064, 0.589, -0.046> <0.051, 0.587, -0.065> <0.039, 0.587, -0.072> 
		<0.065, 0.602, -0.030> <0.058, 0.600, -0.044> <0.048, 0.602, -0.068> <0.036, 0.603, -0.079> 
		<0.059, 0.600, -0.026> <0.052, 0.598, -0.041> <0.046, 0.600, -0.063> <0.034, 0.601, -0.074> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.039, 0.582, -0.069> <0.028, 0.582, -0.075> <0.011, 0.581, -0.078> <-0.002, 0.581, -0.078> 
		<0.039, 0.587, -0.072> <0.028, 0.587, -0.078> <0.010, 0.587, -0.081> <-0.002, 0.587, -0.081> 
		<0.036, 0.603, -0.079> <0.029, 0.603, -0.086> <0.010, 0.604, -0.087> <0.000, 0.604, -0.086> 
		<0.034, 0.601, -0.074> <0.026, 0.601, -0.081> <0.011, 0.602, -0.081> <0.001, 0.602, -0.080> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.002, 0.581, -0.078> <-0.015, 0.581, -0.078> <-0.034, 0.582, -0.076> <-0.045, 0.582, -0.069> 
		<-0.002, 0.587, -0.081> <-0.015, 0.587, -0.081> <-0.033, 0.587, -0.079> <-0.045, 0.588, -0.072> 
		<0.000, 0.604, -0.086> <-0.011, 0.604, -0.086> <-0.031, 0.603, -0.085> <-0.040, 0.603, -0.077> 
		<0.001, 0.602, -0.080> <-0.011, 0.602, -0.080> <-0.028, 0.601, -0.080> <-0.037, 0.601, -0.072> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.045, 0.582, -0.069> <-0.056, 0.582, -0.062> <-0.067, 0.582, -0.046> <-0.073, 0.582, -0.034> 
		<-0.045, 0.588, -0.072> <-0.056, 0.588, -0.065> <-0.066, 0.589, -0.046> <-0.072, 0.589, -0.034> 
		<-0.040, 0.603, -0.077> <-0.051, 0.602, -0.067> <-0.061, 0.602, -0.045> <-0.066, 0.603, -0.031> 
		<-0.037, 0.601, -0.072> <-0.048, 0.601, -0.062> <-0.055, 0.600, -0.041> <-0.060, 0.601, -0.027> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.073, 0.582, -0.034> <-0.079, 0.581, -0.022> <-0.085, 0.582, -0.003> <-0.085, 0.582, 0.010> 
		<-0.072, 0.589, -0.034> <-0.078, 0.588, -0.021> <-0.082, 0.589, -0.003> <-0.082, 0.589, 0.011> 
		<-0.066, 0.603, -0.031> <-0.070, 0.603, -0.020> <-0.076, 0.604, -0.001> <-0.076, 0.605, 0.011> 
		<-0.060, 0.601, -0.027> <-0.065, 0.601, -0.016> <-0.068, 0.601, -0.001> <-0.068, 0.603, 0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.085, 0.582, 0.010> <-0.085, 0.582, 0.024> <-0.080, 0.579, 0.043> <-0.073, 0.582, 0.055> 
		<-0.082, 0.589, 0.011> <-0.082, 0.589, 0.025> <-0.077, 0.589, 0.042> <-0.071, 0.591, 0.054> 
		<-0.076, 0.605, 0.011> <-0.076, 0.607, 0.022> <-0.073, 0.612, 0.042> <-0.068, 0.614, 0.052> 
		<-0.068, 0.603, 0.011> <-0.068, 0.605, 0.022> <-0.065, 0.609, 0.037> <-0.060, 0.611, 0.047> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.073, 0.582, 0.055> <-0.067, 0.584, 0.067> <-0.055, 0.595, 0.078> <-0.044, 0.598, 0.085> 
		<-0.071, 0.591, 0.054> <-0.064, 0.594, 0.066> <-0.055, 0.602, 0.077> <-0.043, 0.605, 0.084> 
		<-0.068, 0.614, 0.052> <-0.064, 0.616, 0.061> <-0.051, 0.621, 0.072> <-0.042, 0.622, 0.077> 
		<-0.060, 0.611, 0.047> <-0.056, 0.613, 0.056> <-0.048, 0.616, 0.068> <-0.039, 0.617, 0.073> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.044, 0.598, 0.085> <-0.032, 0.600, 0.093> <-0.014, 0.596, 0.101> <0.000, 0.596, 0.102> 
		<-0.043, 0.605, 0.084> <-0.031, 0.607, 0.092> <-0.014, 0.605, 0.101> <-0.000, 0.604, 0.101> 
		<-0.042, 0.622, 0.077> <-0.031, 0.623, 0.084> <-0.012, 0.622, 0.090> <0.000, 0.622, 0.090> 
		<-0.039, 0.617, 0.073> <-0.028, 0.618, 0.079> <-0.012, 0.617, 0.083> <0.000, 0.617, 0.083> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.596, 0.102> <0.014, 0.596, 0.102> <0.031, 0.598, 0.094> <0.042, 0.596, 0.087> 
		<-0.000, 0.604, 0.101> <0.013, 0.604, 0.101> <0.031, 0.606, 0.093> <0.042, 0.604, 0.086> 
		<0.000, 0.622, 0.090> <0.012, 0.621, 0.089> <0.030, 0.620, 0.081> <0.040, 0.619, 0.075> 
		<0.000, 0.617, 0.083> <0.012, 0.616, 0.082> <0.027, 0.615, 0.075> <0.037, 0.614, 0.069> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.042, 0.596, 0.087> <0.054, 0.594, 0.080> <0.066, 0.584, 0.067> <0.073, 0.582, 0.055> 
		<0.042, 0.604, 0.086> <0.053, 0.601, 0.078> <0.066, 0.594, 0.066> <0.072, 0.592, 0.054> 
		<0.040, 0.619, 0.075> <0.049, 0.618, 0.069> <0.064, 0.615, 0.059> <0.069, 0.614, 0.049> 
		<0.037, 0.614, 0.069> <0.046, 0.613, 0.064> <0.056, 0.612, 0.053> <0.061, 0.611, 0.044> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.052, 0.572, 0.010> <0.058, 0.583, 0.010> <0.058, 0.605, 0.010> <0.070, 0.609, 0.010> 
		<0.052, 0.572, 0.019> <0.058, 0.583, 0.019> <0.059, 0.607, 0.020> <0.070, 0.611, 0.020> 
		<0.049, 0.572, 0.031> <0.054, 0.583, 0.032> <0.056, 0.607, 0.029> <0.066, 0.611, 0.035> 
		<0.045, 0.572, 0.038> <0.050, 0.583, 0.040> <0.050, 0.608, 0.038> <0.061, 0.611, 0.044> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.052, 0.572, 0.010> <0.052, 0.572, 0.002> <0.049, 0.572, -0.010> <0.045, 0.572, -0.017> 
		<0.058, 0.583, 0.010> <0.058, 0.583, 0.002> <0.053, 0.580, -0.012> <0.049, 0.580, -0.020> 
		<0.058, 0.605, 0.010> <0.058, 0.603, -0.002> <0.055, 0.598, -0.011> <0.051, 0.597, -0.021> 
		<0.070, 0.609, 0.010> <0.070, 0.607, -0.002> <0.063, 0.601, -0.015> <0.059, 0.600, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.045, 0.572, -0.017> <0.041, 0.572, -0.025> <0.033, 0.572, -0.033> <0.026, 0.572, -0.037> 
		<0.049, 0.580, -0.020> <0.045, 0.580, -0.027> <0.036, 0.580, -0.044> <0.028, 0.580, -0.048> 
		<0.051, 0.597, -0.021> <0.044, 0.595, -0.036> <0.041, 0.596, -0.050> <0.029, 0.597, -0.061> 
		<0.059, 0.600, -0.026> <0.052, 0.598, -0.041> <0.046, 0.600, -0.063> <0.034, 0.601, -0.074> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.026, 0.572, -0.037> <0.019, 0.572, -0.042> <0.008, 0.572, -0.045> <0.000, 0.572, -0.045> 
		<0.028, 0.580, -0.048> <0.022, 0.580, -0.053> <0.008, 0.581, -0.055> <0.000, 0.581, -0.055> 
		<0.029, 0.597, -0.061> <0.021, 0.597, -0.068> <0.012, 0.598, -0.067> <0.001, 0.598, -0.067> 
		<0.034, 0.601, -0.074> <0.026, 0.601, -0.081> <0.011, 0.602, -0.081> <0.001, 0.602, -0.080> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.572, -0.045> <-0.008, 0.572, -0.045> <-0.019, 0.572, -0.042> <-0.026, 0.572, -0.037> 
		<0.000, 0.581, -0.055> <-0.008, 0.581, -0.055> <-0.022, 0.580, -0.052> <-0.029, 0.580, -0.048> 
		<0.001, 0.598, -0.067> <-0.010, 0.598, -0.067> <-0.021, 0.597, -0.068> <-0.030, 0.597, -0.061> 
		<0.001, 0.602, -0.080> <-0.011, 0.602, -0.080> <-0.028, 0.601, -0.080> <-0.037, 0.601, -0.072> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.026, 0.572, -0.037> <-0.033, 0.572, -0.033> <-0.041, 0.572, -0.025> <-0.045, 0.572, -0.017> 
		<-0.029, 0.580, -0.048> <-0.036, 0.580, -0.044> <-0.046, 0.580, -0.027> <-0.050, 0.580, -0.020> 
		<-0.030, 0.597, -0.061> <-0.041, 0.597, -0.051> <-0.047, 0.597, -0.036> <-0.052, 0.598, -0.022> 
		<-0.037, 0.601, -0.072> <-0.048, 0.601, -0.062> <-0.055, 0.600, -0.041> <-0.060, 0.601, -0.027> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.045, 0.572, -0.017> <-0.049, 0.572, -0.010> <-0.052, 0.572, 0.002> <-0.052, 0.572, 0.010> 
		<-0.050, 0.580, -0.020> <-0.054, 0.580, -0.013> <-0.057, 0.581, 0.002> <-0.057, 0.581, 0.011> 
		<-0.052, 0.598, -0.022> <-0.056, 0.598, -0.011> <-0.058, 0.598, -0.001> <-0.058, 0.600, 0.011> 
		<-0.060, 0.601, -0.027> <-0.065, 0.601, -0.016> <-0.068, 0.601, -0.001> <-0.068, 0.603, 0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.052, 0.572, 0.010> <-0.052, 0.572, 0.019> <-0.049, 0.572, 0.031> <-0.045, 0.572, 0.038> 
		<-0.057, 0.581, 0.011> <-0.057, 0.581, 0.019> <-0.054, 0.583, 0.033> <-0.050, 0.583, 0.041> 
		<-0.058, 0.600, 0.011> <-0.058, 0.602, 0.022> <-0.054, 0.605, 0.031> <-0.050, 0.607, 0.041> 
		<-0.068, 0.603, 0.011> <-0.068, 0.605, 0.022> <-0.065, 0.609, 0.037> <-0.060, 0.611, 0.047> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.045, 0.572, 0.038> <-0.041, 0.572, 0.045> <-0.033, 0.572, 0.054> <-0.026, 0.572, 0.058> 
		<-0.050, 0.583, 0.041> <-0.046, 0.583, 0.048> <-0.037, 0.585, 0.058> <-0.030, 0.585, 0.063> 
		<-0.050, 0.607, 0.041> <-0.045, 0.609, 0.050> <-0.041, 0.607, 0.058> <-0.033, 0.608, 0.063> 
		<-0.060, 0.611, 0.047> <-0.056, 0.613, 0.056> <-0.048, 0.616, 0.068> <-0.039, 0.617, 0.073> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.026, 0.572, 0.058> <-0.019, 0.572, 0.063> <-0.008, 0.572, 0.066> <0.000, 0.572, 0.066> 
		<-0.030, 0.585, 0.063> <-0.023, 0.585, 0.067> <-0.008, 0.585, 0.071> <0.000, 0.585, 0.071> 
		<-0.033, 0.608, 0.063> <-0.022, 0.609, 0.069> <-0.012, 0.609, 0.071> <0.000, 0.609, 0.071> 
		<-0.039, 0.617, 0.073> <-0.028, 0.618, 0.079> <-0.012, 0.617, 0.083> <0.000, 0.617, 0.083> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.572, 0.066> <0.008, 0.572, 0.066> <0.019, 0.572, 0.063> <0.026, 0.572, 0.058> 
		<0.000, 0.585, 0.071> <0.008, 0.585, 0.071> <0.022, 0.584, 0.066> <0.029, 0.584, 0.062> 
		<0.000, 0.609, 0.071> <0.012, 0.608, 0.070> <0.022, 0.607, 0.066> <0.032, 0.606, 0.059> 
		<0.000, 0.617, 0.083> <0.012, 0.616, 0.082> <0.027, 0.615, 0.075> <0.037, 0.614, 0.069> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.026, 0.572, 0.058> <0.033, 0.572, 0.054> <0.041, 0.572, 0.045> <0.045, 0.572, 0.038> 
		<0.029, 0.584, 0.062> <0.037, 0.584, 0.057> <0.046, 0.583, 0.047> <0.050, 0.583, 0.040> 
		<0.032, 0.606, 0.059> <0.040, 0.605, 0.054> <0.045, 0.608, 0.047> <0.050, 0.608, 0.038> 
		<0.037, 0.614, 0.069> <0.046, 0.613, 0.064> <0.056, 0.612, 0.053> <0.061, 0.611, 0.044> 
	}
	texture { T_Layer1 }
	scale MeshScale
}
// Layer 2
/*union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.585, 0.506, 0.000> <0.585, 0.506, -0.008> <0.585, 0.501, -0.019> <0.585, 0.495, -0.025> 
		<0.583, 0.506, 0.000> <0.583, 0.506, -0.008> <0.583, 0.502, -0.020> <0.583, 0.496, -0.025> 
		<0.582, 0.509, 0.000> <0.582, 0.509, -0.009> <0.582, 0.504, -0.021> <0.582, 0.498, -0.027> 
		<0.580, 0.511, 0.000> <0.580, 0.511, -0.009> <0.580, 0.505, -0.022> <0.580, 0.499, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.585, 0.506, 0.000> <0.583, 0.506, 0.000> <0.582, 0.509, 0.000> <0.580, 0.511, 0.000> 
		<0.585, 0.506, 0.008> <0.583, 0.506, 0.008> <0.582, 0.509, 0.009> <0.580, 0.511, 0.009> 
		<0.585, 0.501, 0.019> <0.583, 0.502, 0.020> <0.582, 0.504, 0.021> <0.580, 0.505, 0.022> 
		<0.585, 0.495, 0.025> <0.583, 0.496, 0.025> <0.582, 0.498, 0.027> <0.580, 0.499, 0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.585, 0.506, 0.000> <0.586, 0.505, 0.000> <0.589, 0.505, 0.000> <0.590, 0.506, 0.000> 
		<0.585, 0.506, -0.008> <0.586, 0.505, -0.008> <0.589, 0.505, -0.008> <0.590, 0.506, -0.008> 
		<0.585, 0.501, -0.019> <0.586, 0.500, -0.019> <0.589, 0.501, -0.019> <0.590, 0.501, -0.019> 
		<0.585, 0.495, -0.025> <0.586, 0.495, -0.024> <0.589, 0.495, -0.024> <0.590, 0.495, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.585, 0.506, 0.000> <0.585, 0.506, 0.008> <0.585, 0.501, 0.019> <0.585, 0.495, 0.025> 
		<0.586, 0.505, 0.000> <0.586, 0.505, 0.008> <0.586, 0.500, 0.019> <0.586, 0.495, 0.024> 
		<0.589, 0.505, 0.000> <0.589, 0.505, 0.008> <0.589, 0.501, 0.019> <0.589, 0.495, 0.024> 
		<0.590, 0.506, 0.000> <0.590, 0.506, 0.008> <0.590, 0.501, 0.019> <0.590, 0.495, 0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.590, 0.506, 0.000> <0.593, 0.507, 0.000> <0.597, 0.509, 0.000> <0.600, 0.511, 0.000> 
		<0.590, 0.506, -0.008> <0.593, 0.507, -0.008> <0.597, 0.509, -0.009> <0.600, 0.511, -0.009> 
		<0.590, 0.501, -0.019> <0.593, 0.502, -0.020> <0.597, 0.504, -0.021> <0.600, 0.505, -0.022> 
		<0.590, 0.495, -0.025> <0.593, 0.496, -0.025> <0.597, 0.498, -0.027> <0.600, 0.499, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.590, 0.506, 0.000> <0.590, 0.506, 0.008> <0.590, 0.501, 0.019> <0.590, 0.495, 0.025> 
		<0.593, 0.507, 0.000> <0.593, 0.507, 0.008> <0.593, 0.502, 0.020> <0.593, 0.496, 0.025> 
		<0.597, 0.509, 0.000> <0.597, 0.509, 0.009> <0.597, 0.504, 0.021> <0.597, 0.498, 0.027> 
		<0.600, 0.511, 0.000> <0.600, 0.511, 0.009> <0.600, 0.505, 0.022> <0.600, 0.499, 0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, 0.511, 0.000> <0.604, 0.512, 0.000> <0.610, 0.515, 0.000> <0.615, 0.516, 0.000> 
		<0.600, 0.511, -0.009> <0.604, 0.512, -0.009> <0.610, 0.515, -0.010> <0.615, 0.516, -0.010> 
		<0.600, 0.505, -0.022> <0.604, 0.507, -0.023> <0.610, 0.509, -0.024> <0.615, 0.510, -0.025> 
		<0.600, 0.499, -0.028> <0.604, 0.500, -0.030> <0.610, 0.502, -0.031> <0.615, 0.502, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, 0.511, 0.000> <0.600, 0.511, 0.009> <0.600, 0.505, 0.022> <0.600, 0.499, 0.028> 
		<0.604, 0.512, 0.000> <0.604, 0.512, 0.009> <0.604, 0.507, 0.023> <0.604, 0.500, 0.030> 
		<0.610, 0.515, 0.000> <0.610, 0.515, 0.010> <0.610, 0.509, 0.024> <0.610, 0.502, 0.031> 
		<0.615, 0.516, 0.000> <0.615, 0.516, 0.010> <0.615, 0.510, 0.025> <0.615, 0.502, 0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.735, 0.496, 0.000> <0.735, 0.496, -0.006> <0.735, 0.493, -0.014> <0.735, 0.489, -0.018> 
		<0.734, 0.497, 0.000> <0.734, 0.497, -0.006> <0.734, 0.494, -0.015> <0.734, 0.490, -0.019> 
		<0.732, 0.501, 0.000> <0.732, 0.501, -0.007> <0.732, 0.497, -0.016> <0.732, 0.492, -0.021> 
		<0.730, 0.501, 0.000> <0.730, 0.501, -0.007> <0.730, 0.497, -0.016> <0.730, 0.492, -0.021> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.735, 0.496, 0.000> <0.734, 0.497, 0.000> <0.732, 0.501, 0.000> <0.730, 0.501, 0.000> 
		<0.735, 0.496, 0.006> <0.734, 0.497, 0.006> <0.732, 0.501, 0.007> <0.730, 0.501, 0.007> 
		<0.735, 0.493, 0.014> <0.734, 0.494, 0.015> <0.732, 0.497, 0.016> <0.730, 0.497, 0.016> 
		<0.735, 0.489, 0.018> <0.734, 0.490, 0.019> <0.732, 0.492, 0.021> <0.730, 0.492, 0.021> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.695, 0.516, 0.000> <0.695, 0.516, -0.010> <0.695, 0.510, -0.025> <0.695, 0.503, -0.032> 
		<0.683, 0.518, 0.000> <0.683, 0.518, -0.010> <0.683, 0.511, -0.026> <0.683, 0.504, -0.033> 
		<0.667, 0.521, 0.000> <0.667, 0.521, -0.011> <0.667, 0.514, -0.027> <0.667, 0.506, -0.035> 
		<0.655, 0.521, 0.000> <0.655, 0.521, -0.011> <0.655, 0.514, -0.027> <0.655, 0.506, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.695, 0.516, 0.000> <0.683, 0.518, 0.000> <0.667, 0.521, 0.000> <0.655, 0.521, 0.000> 
		<0.695, 0.516, 0.010> <0.683, 0.518, 0.010> <0.667, 0.521, 0.011> <0.655, 0.521, 0.011> 
		<0.695, 0.510, 0.025> <0.683, 0.511, 0.026> <0.667, 0.514, 0.027> <0.655, 0.514, 0.027> 
		<0.695, 0.503, 0.032> <0.683, 0.504, 0.033> <0.667, 0.506, 0.035> <0.655, 0.506, 0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.695, 0.516, 0.000> <0.700, 0.515, 0.000> <0.706, 0.513, 0.000> <0.710, 0.511, 0.000> 
		<0.695, 0.516, -0.010> <0.700, 0.515, -0.010> <0.706, 0.513, -0.009> <0.710, 0.511, -0.009> 
		<0.695, 0.510, -0.025> <0.700, 0.509, -0.024> <0.706, 0.507, -0.024> <0.710, 0.506, -0.022> 
		<0.695, 0.503, -0.032> <0.700, 0.502, -0.031> <0.706, 0.501, -0.030> <0.710, 0.499, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.695, 0.516, 0.000> <0.695, 0.516, 0.010> <0.695, 0.510, 0.025> <0.695, 0.503, 0.032> 
		<0.700, 0.515, 0.000> <0.700, 0.515, 0.010> <0.700, 0.509, 0.024> <0.700, 0.502, 0.031> 
		<0.706, 0.513, 0.000> <0.706, 0.513, 0.009> <0.706, 0.507, 0.024> <0.706, 0.501, 0.030> 
		<0.710, 0.511, 0.000> <0.710, 0.511, 0.009> <0.710, 0.506, 0.022> <0.710, 0.499, 0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.720, 0.501, 0.000> <0.720, 0.501, -0.007> <0.720, 0.497, -0.016> <0.720, 0.492, -0.021> 
		<0.717, 0.504, 0.000> <0.717, 0.504, -0.007> <0.717, 0.499, -0.018> <0.717, 0.494, -0.023> 
		<0.714, 0.509, 0.000> <0.714, 0.509, -0.009> <0.714, 0.504, -0.020> <0.714, 0.498, -0.027> 
		<0.710, 0.511, 0.000> <0.710, 0.511, -0.009> <0.710, 0.506, -0.022> <0.710, 0.499, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.720, 0.501, 0.000> <0.717, 0.504, 0.000> <0.714, 0.509, 0.000> <0.710, 0.511, 0.000> 
		<0.720, 0.501, 0.007> <0.717, 0.504, 0.007> <0.714, 0.509, 0.009> <0.710, 0.511, 0.009> 
		<0.720, 0.497, 0.016> <0.717, 0.499, 0.018> <0.714, 0.504, 0.020> <0.710, 0.506, 0.022> 
		<0.720, 0.492, 0.021> <0.717, 0.494, 0.023> <0.714, 0.498, 0.027> <0.710, 0.499, 0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.720, 0.501, 0.000> <0.722, 0.499, 0.000> <0.723, 0.496, 0.000> <0.725, 0.496, 0.000> 
		<0.720, 0.501, -0.007> <0.722, 0.499, -0.007> <0.723, 0.496, -0.006> <0.725, 0.496, -0.006> 
		<0.720, 0.497, -0.016> <0.722, 0.496, -0.015> <0.723, 0.493, -0.014> <0.725, 0.493, -0.014> 
		<0.720, 0.492, -0.021> <0.722, 0.491, -0.020> <0.723, 0.489, -0.018> <0.725, 0.489, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.720, 0.501, 0.000> <0.720, 0.501, 0.007> <0.720, 0.497, 0.016> <0.720, 0.492, 0.021> 
		<0.722, 0.499, 0.000> <0.722, 0.499, 0.007> <0.722, 0.496, 0.015> <0.722, 0.491, 0.020> 
		<0.723, 0.496, 0.000> <0.723, 0.496, 0.006> <0.723, 0.493, 0.014> <0.723, 0.489, 0.018> 
		<0.725, 0.496, 0.000> <0.725, 0.496, 0.006> <0.725, 0.493, 0.014> <0.725, 0.489, 0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.725, 0.496, 0.000> <0.727, 0.496, 0.000> <0.728, 0.501, 0.000> <0.730, 0.501, 0.000> 
		<0.725, 0.496, -0.006> <0.727, 0.496, -0.006> <0.728, 0.501, -0.007> <0.730, 0.501, -0.007> 
		<0.725, 0.493, -0.014> <0.727, 0.493, -0.014> <0.728, 0.497, -0.016> <0.730, 0.497, -0.016> 
		<0.725, 0.489, -0.018> <0.727, 0.489, -0.018> <0.728, 0.492, -0.021> <0.730, 0.492, -0.021> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.725, 0.496, 0.000> <0.725, 0.496, 0.006> <0.725, 0.493, 0.014> <0.725, 0.489, 0.018> 
		<0.727, 0.496, 0.000> <0.727, 0.496, 0.006> <0.727, 0.493, 0.014> <0.727, 0.489, 0.018> 
		<0.728, 0.501, 0.000> <0.728, 0.501, 0.007> <0.728, 0.497, 0.016> <0.728, 0.492, 0.021> 
		<0.730, 0.501, 0.000> <0.730, 0.501, 0.007> <0.730, 0.497, 0.016> <0.730, 0.492, 0.021> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.615, 0.516, 0.000> <0.627, 0.518, 0.000> <0.643, 0.521, 0.000> <0.655, 0.521, 0.000> 
		<0.615, 0.516, -0.010> <0.627, 0.518, -0.010> <0.643, 0.521, -0.011> <0.655, 0.521, -0.011> 
		<0.615, 0.510, -0.025> <0.627, 0.511, -0.026> <0.643, 0.514, -0.027> <0.655, 0.514, -0.027> 
		<0.615, 0.502, -0.032> <0.627, 0.504, -0.033> <0.643, 0.506, -0.035> <0.655, 0.506, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.615, 0.516, 0.000> <0.615, 0.516, 0.010> <0.615, 0.510, 0.025> <0.615, 0.502, 0.032> 
		<0.627, 0.518, 0.000> <0.627, 0.518, 0.010> <0.627, 0.511, 0.026> <0.627, 0.504, 0.033> 
		<0.643, 0.521, 0.000> <0.643, 0.521, 0.011> <0.643, 0.514, 0.027> <0.643, 0.506, 0.035> 
		<0.655, 0.521, 0.000> <0.655, 0.521, 0.011> <0.655, 0.514, 0.027> <0.655, 0.506, 0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.445, 0.510, 0.000> <0.445, 0.510, -0.009> <0.445, 0.505, -0.022> <0.445, 0.498, -0.028> 
		<0.443, 0.511, 0.000> <0.443, 0.511, -0.009> <0.443, 0.506, -0.022> <0.443, 0.499, -0.029> 
		<0.442, 0.514, 0.000> <0.442, 0.514, -0.010> <0.442, 0.508, -0.024> <0.442, 0.501, -0.031> 
		<0.440, 0.515, 0.000> <0.440, 0.515, -0.010> <0.440, 0.509, -0.025> <0.440, 0.502, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.445, 0.510, 0.000> <0.443, 0.511, 0.000> <0.442, 0.514, 0.000> <0.440, 0.515, 0.000> 
		<0.445, 0.510, 0.009> <0.443, 0.511, 0.009> <0.442, 0.514, 0.010> <0.440, 0.515, 0.010> 
		<0.445, 0.505, 0.022> <0.443, 0.506, 0.022> <0.442, 0.508, 0.024> <0.440, 0.509, 0.025> 
		<0.445, 0.498, 0.028> <0.443, 0.499, 0.029> <0.442, 0.501, 0.031> <0.440, 0.502, 0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.445, 0.510, 0.000> <0.446, 0.509, 0.000> <0.449, 0.510, 0.000> <0.450, 0.510, 0.000> 
		<0.445, 0.510, -0.009> <0.446, 0.509, -0.009> <0.449, 0.510, -0.009> <0.450, 0.510, -0.009> 
		<0.445, 0.505, -0.022> <0.446, 0.504, -0.021> <0.449, 0.505, -0.021> <0.450, 0.505, -0.022> 
		<0.445, 0.498, -0.028> <0.446, 0.498, -0.028> <0.449, 0.498, -0.028> <0.450, 0.498, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.445, 0.510, 0.000> <0.445, 0.510, 0.009> <0.445, 0.505, 0.022> <0.445, 0.498, 0.028> 
		<0.446, 0.509, 0.000> <0.446, 0.509, 0.009> <0.446, 0.504, 0.021> <0.446, 0.498, 0.028> 
		<0.449, 0.510, 0.000> <0.449, 0.510, 0.009> <0.449, 0.505, 0.021> <0.449, 0.498, 0.028> 
		<0.450, 0.510, 0.000> <0.450, 0.510, 0.009> <0.450, 0.505, 0.022> <0.450, 0.498, 0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.450, 0.510, 0.000> <0.453, 0.511, 0.000> <0.457, 0.514, 0.000> <0.460, 0.515, 0.000> 
		<0.450, 0.510, -0.009> <0.453, 0.511, -0.009> <0.457, 0.514, -0.010> <0.460, 0.515, -0.010> 
		<0.450, 0.505, -0.022> <0.453, 0.506, -0.023> <0.457, 0.508, -0.024> <0.460, 0.509, -0.025> 
		<0.450, 0.498, -0.028> <0.453, 0.499, -0.029> <0.457, 0.501, -0.031> <0.460, 0.502, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.450, 0.510, 0.000> <0.450, 0.510, 0.009> <0.450, 0.505, 0.022> <0.450, 0.498, 0.028> 
		<0.453, 0.511, 0.000> <0.453, 0.511, 0.009> <0.453, 0.506, 0.023> <0.453, 0.499, 0.029> 
		<0.457, 0.514, 0.000> <0.457, 0.514, 0.010> <0.457, 0.508, 0.024> <0.457, 0.501, 0.031> 
		<0.460, 0.515, 0.000> <0.460, 0.515, 0.010> <0.460, 0.509, 0.025> <0.460, 0.502, 0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.460, 0.515, 0.000> <0.464, 0.517, 0.000> <0.470, 0.519, 0.000> <0.475, 0.520, 0.000> 
		<0.460, 0.515, -0.010> <0.464, 0.517, -0.010> <0.470, 0.519, -0.011> <0.475, 0.520, -0.011> 
		<0.460, 0.509, -0.025> <0.464, 0.511, -0.026> <0.470, 0.513, -0.027> <0.475, 0.514, -0.027> 
		<0.460, 0.502, -0.032> <0.464, 0.503, -0.033> <0.470, 0.505, -0.035> <0.475, 0.506, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.460, 0.515, 0.000> <0.460, 0.515, 0.010> <0.460, 0.509, 0.025> <0.460, 0.502, 0.032> 
		<0.464, 0.517, 0.000> <0.464, 0.517, 0.010> <0.464, 0.511, 0.026> <0.464, 0.503, 0.033> 
		<0.470, 0.519, 0.000> <0.470, 0.519, 0.011> <0.470, 0.513, 0.027> <0.470, 0.505, 0.035> 
		<0.475, 0.520, 0.000> <0.475, 0.520, 0.011> <0.475, 0.514, 0.027> <0.475, 0.506, 0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.555, 0.520, 0.000> <0.555, 0.520, -0.011> <0.555, 0.514, -0.027> <0.555, 0.506, -0.035> 
		<0.542, 0.523, 0.000> <0.542, 0.523, -0.011> <0.542, 0.515, -0.029> <0.542, 0.507, -0.037> 
		<0.524, 0.525, 0.000> <0.524, 0.525, -0.013> <0.524, 0.518, -0.030> <0.524, 0.509, -0.039> 
		<0.510, 0.525, 0.000> <0.510, 0.525, -0.013> <0.510, 0.518, -0.030> <0.510, 0.509, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.555, 0.520, 0.000> <0.542, 0.523, 0.000> <0.524, 0.525, 0.000> <0.510, 0.525, 0.000> 
		<0.555, 0.520, 0.011> <0.542, 0.523, 0.011> <0.524, 0.525, 0.013> <0.510, 0.525, 0.013> 
		<0.555, 0.514, 0.027> <0.542, 0.515, 0.029> <0.524, 0.518, 0.030> <0.510, 0.518, 0.030> 
		<0.555, 0.506, 0.035> <0.542, 0.507, 0.037> <0.524, 0.509, 0.039> <0.510, 0.509, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.555, 0.520, 0.000> <0.560, 0.520, 0.000> <0.566, 0.517, 0.000> <0.570, 0.515, 0.000> 
		<0.555, 0.520, -0.011> <0.560, 0.520, -0.011> <0.566, 0.517, -0.010> <0.570, 0.515, -0.010> 
		<0.555, 0.514, -0.027> <0.560, 0.513, -0.027> <0.566, 0.511, -0.026> <0.570, 0.510, -0.025> 
		<0.555, 0.506, -0.035> <0.560, 0.505, -0.035> <0.566, 0.504, -0.033> <0.570, 0.502, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.555, 0.520, 0.000> <0.555, 0.520, 0.011> <0.555, 0.514, 0.027> <0.555, 0.506, 0.035> 
		<0.560, 0.520, 0.000> <0.560, 0.520, 0.011> <0.560, 0.513, 0.027> <0.560, 0.505, 0.035> 
		<0.566, 0.517, 0.000> <0.566, 0.517, 0.010> <0.566, 0.511, 0.026> <0.566, 0.504, 0.033> 
		<0.570, 0.515, 0.000> <0.570, 0.515, 0.010> <0.570, 0.510, 0.025> <0.570, 0.502, 0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.570, 0.515, 0.000> <0.573, 0.514, 0.000> <0.577, 0.512, 0.000> <0.580, 0.511, 0.000> 
		<0.570, 0.515, -0.010> <0.573, 0.514, -0.010> <0.577, 0.512, -0.009> <0.580, 0.511, -0.009> 
		<0.570, 0.510, -0.025> <0.573, 0.509, -0.024> <0.577, 0.507, -0.023> <0.580, 0.505, -0.022> 
		<0.570, 0.502, -0.032> <0.573, 0.501, -0.031> <0.577, 0.500, -0.030> <0.580, 0.499, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.570, 0.515, 0.000> <0.570, 0.515, 0.010> <0.570, 0.510, 0.025> <0.570, 0.502, 0.032> 
		<0.573, 0.514, 0.000> <0.573, 0.514, 0.010> <0.573, 0.509, 0.024> <0.573, 0.501, 0.031> 
		<0.577, 0.512, 0.000> <0.577, 0.512, 0.009> <0.577, 0.507, 0.023> <0.577, 0.500, 0.030> 
		<0.580, 0.511, 0.000> <0.580, 0.511, 0.009> <0.580, 0.505, 0.022> <0.580, 0.499, 0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.475, 0.520, 0.000> <0.485, 0.522, 0.000> <0.499, 0.525, 0.000> <0.510, 0.525, 0.000> 
		<0.475, 0.520, -0.011> <0.485, 0.522, -0.011> <0.499, 0.525, -0.013> <0.510, 0.525, -0.013> 
		<0.475, 0.514, -0.027> <0.485, 0.515, -0.029> <0.499, 0.518, -0.030> <0.510, 0.518, -0.030> 
		<0.475, 0.506, -0.035> <0.485, 0.507, -0.037> <0.499, 0.509, -0.039> <0.510, 0.509, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.475, 0.520, 0.000> <0.475, 0.520, 0.011> <0.475, 0.514, 0.027> <0.475, 0.506, 0.035> 
		<0.485, 0.522, 0.000> <0.485, 0.522, 0.011> <0.485, 0.515, 0.029> <0.485, 0.507, 0.037> 
		<0.499, 0.525, 0.000> <0.499, 0.525, 0.013> <0.499, 0.518, 0.030> <0.499, 0.509, 0.039> 
		<0.510, 0.525, 0.000> <0.510, 0.525, 0.013> <0.510, 0.518, 0.030> <0.510, 0.509, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.305, 0.515, 0.000> <0.305, 0.515, -0.010> <0.305, 0.509, -0.025> <0.305, 0.502, -0.032> 
		<0.303, 0.516, 0.000> <0.303, 0.516, -0.010> <0.303, 0.510, -0.025> <0.303, 0.502, -0.032> 
		<0.302, 0.519, 0.000> <0.302, 0.519, -0.011> <0.302, 0.512, -0.026> <0.302, 0.504, -0.035> 
		<0.300, 0.520, 0.000> <0.300, 0.520, -0.011> <0.300, 0.513, -0.027> <0.300, 0.505, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.305, 0.515, 0.000> <0.303, 0.516, 0.000> <0.302, 0.519, 0.000> <0.300, 0.520, 0.000> 
		<0.305, 0.515, 0.010> <0.303, 0.516, 0.010> <0.302, 0.519, 0.011> <0.300, 0.520, 0.011> 
		<0.305, 0.509, 0.025> <0.303, 0.510, 0.025> <0.302, 0.512, 0.026> <0.300, 0.513, 0.027> 
		<0.305, 0.502, 0.032> <0.303, 0.502, 0.032> <0.302, 0.504, 0.035> <0.300, 0.505, 0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.305, 0.515, 0.000> <0.306, 0.514, 0.000> <0.309, 0.514, 0.000> <0.310, 0.515, 0.000> 
		<0.305, 0.515, -0.010> <0.306, 0.514, -0.010> <0.309, 0.514, -0.010> <0.310, 0.515, -0.010> 
		<0.305, 0.509, -0.025> <0.306, 0.508, -0.024> <0.309, 0.509, -0.024> <0.310, 0.509, -0.025> 
		<0.305, 0.502, -0.032> <0.306, 0.501, -0.031> <0.309, 0.501, -0.031> <0.310, 0.502, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.305, 0.515, 0.000> <0.305, 0.515, 0.010> <0.305, 0.509, 0.025> <0.305, 0.502, 0.032> 
		<0.306, 0.514, 0.000> <0.306, 0.514, 0.010> <0.306, 0.508, 0.024> <0.306, 0.501, 0.031> 
		<0.309, 0.514, 0.000> <0.309, 0.514, 0.010> <0.309, 0.509, 0.024> <0.309, 0.501, 0.031> 
		<0.310, 0.515, 0.000> <0.310, 0.515, 0.010> <0.310, 0.509, 0.025> <0.310, 0.502, 0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.310, 0.515, 0.000> <0.313, 0.516, 0.000> <0.317, 0.519, 0.000> <0.320, 0.520, 0.000> 
		<0.310, 0.515, -0.010> <0.313, 0.516, -0.010> <0.317, 0.519, -0.011> <0.320, 0.520, -0.011> 
		<0.310, 0.509, -0.025> <0.313, 0.510, -0.025> <0.317, 0.512, -0.026> <0.320, 0.513, -0.027> 
		<0.310, 0.502, -0.032> <0.313, 0.502, -0.033> <0.317, 0.504, -0.034> <0.320, 0.505, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.310, 0.515, 0.000> <0.310, 0.515, 0.010> <0.310, 0.509, 0.025> <0.310, 0.502, 0.032> 
		<0.313, 0.516, 0.000> <0.313, 0.516, 0.010> <0.313, 0.510, 0.025> <0.313, 0.502, 0.033> 
		<0.317, 0.519, 0.000> <0.317, 0.519, 0.011> <0.317, 0.512, 0.026> <0.317, 0.504, 0.034> 
		<0.320, 0.520, 0.000> <0.320, 0.520, 0.011> <0.320, 0.513, 0.027> <0.320, 0.505, 0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.320, 0.520, 0.000> <0.324, 0.522, 0.000> <0.330, 0.524, 0.000> <0.335, 0.525, 0.000> 
		<0.320, 0.520, -0.011> <0.324, 0.522, -0.011> <0.330, 0.524, -0.013> <0.335, 0.525, -0.013> 
		<0.320, 0.513, -0.027> <0.324, 0.515, -0.028> <0.330, 0.517, -0.029> <0.335, 0.518, -0.030> 
		<0.320, 0.505, -0.035> <0.324, 0.506, -0.037> <0.330, 0.508, -0.038> <0.335, 0.509, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.320, 0.520, 0.000> <0.320, 0.520, 0.011> <0.320, 0.513, 0.027> <0.320, 0.505, 0.035> 
		<0.324, 0.522, 0.000> <0.324, 0.522, 0.011> <0.324, 0.515, 0.028> <0.324, 0.506, 0.037> 
		<0.330, 0.524, 0.000> <0.330, 0.524, 0.013> <0.330, 0.517, 0.029> <0.330, 0.508, 0.038> 
		<0.335, 0.525, 0.000> <0.335, 0.525, 0.013> <0.335, 0.518, 0.030> <0.335, 0.509, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.415, 0.525, 0.000> <0.415, 0.525, -0.013> <0.415, 0.518, -0.030> <0.415, 0.509, -0.039> 
		<0.403, 0.527, 0.000> <0.403, 0.527, -0.013> <0.403, 0.519, -0.031> <0.403, 0.510, -0.040> 
		<0.387, 0.530, 0.000> <0.387, 0.530, -0.014> <0.387, 0.522, -0.033> <0.387, 0.512, -0.042> 
		<0.375, 0.530, 0.000> <0.375, 0.530, -0.014> <0.375, 0.522, -0.033> <0.375, 0.512, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.415, 0.525, 0.000> <0.403, 0.527, 0.000> <0.387, 0.530, 0.000> <0.375, 0.530, 0.000> 
		<0.415, 0.525, 0.013> <0.403, 0.527, 0.013> <0.387, 0.530, 0.014> <0.375, 0.530, 0.014> 
		<0.415, 0.518, 0.030> <0.403, 0.519, 0.031> <0.387, 0.522, 0.033> <0.375, 0.522, 0.033> 
		<0.415, 0.509, 0.039> <0.403, 0.510, 0.040> <0.387, 0.512, 0.042> <0.375, 0.512, 0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.415, 0.525, 0.000> <0.420, 0.524, 0.000> <0.426, 0.522, 0.000> <0.430, 0.520, 0.000> 
		<0.415, 0.525, -0.013> <0.420, 0.524, -0.013> <0.426, 0.522, -0.011> <0.430, 0.520, -0.011> 
		<0.415, 0.518, -0.030> <0.420, 0.517, -0.029> <0.426, 0.515, -0.028> <0.430, 0.514, -0.027> 
		<0.415, 0.509, -0.039> <0.420, 0.508, -0.038> <0.426, 0.507, -0.037> <0.430, 0.505, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.415, 0.525, 0.000> <0.415, 0.525, 0.013> <0.415, 0.518, 0.030> <0.415, 0.509, 0.039> 
		<0.420, 0.524, 0.000> <0.420, 0.524, 0.013> <0.420, 0.517, 0.029> <0.420, 0.508, 0.038> 
		<0.426, 0.522, 0.000> <0.426, 0.522, 0.011> <0.426, 0.515, 0.028> <0.426, 0.507, 0.037> 
		<0.430, 0.520, 0.000> <0.430, 0.520, 0.011> <0.430, 0.514, 0.027> <0.430, 0.505, 0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.430, 0.520, 0.000> <0.433, 0.519, 0.000> <0.437, 0.517, 0.000> <0.440, 0.515, 0.000> 
		<0.430, 0.520, -0.011> <0.433, 0.519, -0.011> <0.437, 0.517, -0.010> <0.440, 0.515, -0.010> 
		<0.430, 0.514, -0.027> <0.433, 0.513, -0.026> <0.437, 0.511, -0.026> <0.440, 0.509, -0.025> 
		<0.430, 0.505, -0.035> <0.433, 0.505, -0.034> <0.437, 0.503, -0.033> <0.440, 0.502, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.430, 0.520, 0.000> <0.430, 0.520, 0.011> <0.430, 0.514, 0.027> <0.430, 0.505, 0.035> 
		<0.433, 0.519, 0.000> <0.433, 0.519, 0.011> <0.433, 0.513, 0.026> <0.433, 0.505, 0.034> 
		<0.437, 0.517, 0.000> <0.437, 0.517, 0.010> <0.437, 0.511, 0.026> <0.437, 0.503, 0.033> 
		<0.440, 0.515, 0.000> <0.440, 0.515, 0.010> <0.440, 0.509, 0.025> <0.440, 0.502, 0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.335, 0.525, 0.000> <0.347, 0.527, 0.000> <0.363, 0.530, 0.000> <0.375, 0.530, 0.000> 
		<0.335, 0.525, -0.013> <0.347, 0.527, -0.013> <0.363, 0.530, -0.014> <0.375, 0.530, -0.014> 
		<0.335, 0.518, -0.030> <0.347, 0.519, -0.031> <0.363, 0.522, -0.033> <0.375, 0.522, -0.033> 
		<0.335, 0.509, -0.039> <0.347, 0.510, -0.040> <0.363, 0.512, -0.042> <0.375, 0.512, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.335, 0.525, 0.000> <0.335, 0.525, 0.013> <0.335, 0.518, 0.030> <0.335, 0.509, 0.039> 
		<0.347, 0.527, 0.000> <0.347, 0.527, 0.013> <0.347, 0.519, 0.031> <0.347, 0.510, 0.040> 
		<0.363, 0.530, 0.000> <0.363, 0.530, 0.014> <0.363, 0.522, 0.033> <0.363, 0.512, 0.042> 
		<0.375, 0.530, 0.000> <0.375, 0.530, 0.014> <0.375, 0.522, 0.033> <0.375, 0.512, 0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.160, 0.524, 0.000> <0.160, 0.524, -0.013> <0.160, 0.517, -0.030> <0.160, 0.508, -0.039> 
		<0.158, 0.524, 0.000> <0.158, 0.524, -0.013> <0.158, 0.517, -0.030> <0.158, 0.508, -0.039> 
		<0.156, 0.521, 0.000> <0.156, 0.521, -0.011> <0.157, 0.514, -0.028> <0.157, 0.506, -0.036> 
		<0.155, 0.519, 0.000> <0.155, 0.519, -0.011> <0.155, 0.513, -0.027> <0.155, 0.505, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.160, 0.524, 0.000> <0.158, 0.524, 0.000> <0.156, 0.521, 0.000> <0.155, 0.519, 0.000> 
		<0.160, 0.524, 0.013> <0.158, 0.524, 0.013> <0.156, 0.521, 0.011> <0.155, 0.519, 0.011> 
		<0.160, 0.517, 0.030> <0.158, 0.517, 0.030> <0.157, 0.514, 0.028> <0.155, 0.513, 0.027> 
		<0.160, 0.508, 0.039> <0.158, 0.508, 0.039> <0.157, 0.506, 0.036> <0.155, 0.505, 0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.160, 0.524, 0.000> <0.162, 0.524, 0.000> <0.163, 0.520, 0.000> <0.165, 0.519, 0.000> 
		<0.160, 0.524, -0.013> <0.162, 0.524, -0.013> <0.163, 0.520, -0.011> <0.165, 0.519, -0.011> 
		<0.160, 0.517, -0.030> <0.162, 0.517, -0.030> <0.163, 0.513, -0.028> <0.165, 0.513, -0.027> 
		<0.160, 0.508, -0.039> <0.162, 0.508, -0.039> <0.163, 0.505, -0.036> <0.165, 0.505, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.160, 0.524, 0.000> <0.160, 0.524, 0.013> <0.160, 0.517, 0.030> <0.160, 0.508, 0.039> 
		<0.162, 0.524, 0.000> <0.162, 0.524, 0.013> <0.162, 0.517, 0.030> <0.162, 0.508, 0.039> 
		<0.163, 0.520, 0.000> <0.163, 0.520, 0.011> <0.163, 0.513, 0.028> <0.163, 0.505, 0.036> 
		<0.165, 0.519, 0.000> <0.165, 0.519, 0.011> <0.165, 0.513, 0.027> <0.165, 0.505, 0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.165, 0.519, 0.000> <0.166, 0.519, 0.000> <0.169, 0.519, 0.000> <0.170, 0.519, 0.000> 
		<0.165, 0.519, -0.011> <0.166, 0.519, -0.011> <0.169, 0.519, -0.011> <0.170, 0.519, -0.011> 
		<0.165, 0.513, -0.027> <0.166, 0.512, -0.027> <0.169, 0.512, -0.027> <0.170, 0.513, -0.027> 
		<0.165, 0.505, -0.035> <0.166, 0.504, -0.035> <0.169, 0.504, -0.035> <0.170, 0.505, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.165, 0.519, 0.000> <0.165, 0.519, 0.011> <0.165, 0.513, 0.027> <0.165, 0.505, 0.035> 
		<0.166, 0.519, 0.000> <0.166, 0.519, 0.011> <0.166, 0.512, 0.027> <0.166, 0.504, 0.035> 
		<0.169, 0.519, 0.000> <0.169, 0.519, 0.011> <0.169, 0.512, 0.027> <0.169, 0.504, 0.035> 
		<0.170, 0.519, 0.000> <0.170, 0.519, 0.011> <0.170, 0.513, 0.027> <0.170, 0.505, 0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.170, 0.519, 0.000> <0.173, 0.520, 0.000> <0.177, 0.523, 0.000> <0.180, 0.524, 0.000> 
		<0.170, 0.519, -0.011> <0.173, 0.520, -0.011> <0.177, 0.523, -0.013> <0.180, 0.524, -0.013> 
		<0.170, 0.513, -0.027> <0.173, 0.514, -0.028> <0.177, 0.516, -0.029> <0.180, 0.517, -0.030> 
		<0.170, 0.505, -0.035> <0.173, 0.505, -0.036> <0.177, 0.507, -0.038> <0.180, 0.508, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.170, 0.519, 0.000> <0.170, 0.519, 0.011> <0.170, 0.513, 0.027> <0.170, 0.505, 0.035> 
		<0.173, 0.520, 0.000> <0.173, 0.520, 0.011> <0.173, 0.514, 0.028> <0.173, 0.505, 0.036> 
		<0.177, 0.523, 0.000> <0.177, 0.523, 0.013> <0.177, 0.516, 0.029> <0.177, 0.507, 0.038> 
		<0.180, 0.524, 0.000> <0.180, 0.524, 0.013> <0.180, 0.517, 0.030> <0.180, 0.508, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.275, 0.530, 0.000> <0.275, 0.530, -0.014> <0.275, 0.522, -0.033> <0.275, 0.512, -0.042> 
		<0.263, 0.532, 0.000> <0.263, 0.532, -0.014> <0.263, 0.523, -0.034> <0.263, 0.514, -0.044> 
		<0.247, 0.535, 0.000> <0.247, 0.535, -0.015> <0.247, 0.526, -0.035> <0.247, 0.516, -0.046> 
		<0.235, 0.535, 0.000> <0.235, 0.535, -0.015> <0.235, 0.526, -0.035> <0.235, 0.515, -0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.275, 0.530, 0.000> <0.263, 0.532, 0.000> <0.247, 0.535, 0.000> <0.235, 0.535, 0.000> 
		<0.275, 0.530, 0.014> <0.263, 0.532, 0.014> <0.247, 0.535, 0.015> <0.235, 0.535, 0.015> 
		<0.275, 0.522, 0.033> <0.263, 0.523, 0.034> <0.247, 0.526, 0.035> <0.235, 0.526, 0.035> 
		<0.275, 0.512, 0.042> <0.263, 0.514, 0.044> <0.247, 0.516, 0.046> <0.235, 0.515, 0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.275, 0.530, 0.000> <0.280, 0.529, 0.000> <0.286, 0.526, 0.000> <0.290, 0.525, 0.000> 
		<0.275, 0.530, -0.014> <0.280, 0.529, -0.014> <0.286, 0.526, -0.013> <0.290, 0.525, -0.013> 
		<0.275, 0.522, -0.033> <0.280, 0.521, -0.032> <0.286, 0.519, -0.031> <0.290, 0.518, -0.030> 
		<0.275, 0.512, -0.042> <0.280, 0.511, -0.042> <0.286, 0.510, -0.040> <0.290, 0.509, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.275, 0.530, 0.000> <0.275, 0.530, 0.014> <0.275, 0.522, 0.033> <0.275, 0.512, 0.042> 
		<0.280, 0.529, 0.000> <0.280, 0.529, 0.014> <0.280, 0.521, 0.032> <0.280, 0.511, 0.042> 
		<0.286, 0.526, 0.000> <0.286, 0.526, 0.013> <0.286, 0.519, 0.031> <0.286, 0.510, 0.040> 
		<0.290, 0.525, 0.000> <0.290, 0.525, 0.013> <0.290, 0.518, 0.030> <0.290, 0.509, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.290, 0.525, 0.000> <0.293, 0.523, 0.000> <0.297, 0.522, 0.000> <0.300, 0.520, 0.000> 
		<0.290, 0.525, -0.013> <0.293, 0.523, -0.013> <0.297, 0.522, -0.011> <0.300, 0.520, -0.011> 
		<0.290, 0.518, -0.030> <0.293, 0.517, -0.029> <0.297, 0.515, -0.029> <0.300, 0.513, -0.027> 
		<0.290, 0.509, -0.039> <0.293, 0.508, -0.038> <0.297, 0.506, -0.037> <0.300, 0.505, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.290, 0.525, 0.000> <0.290, 0.525, 0.013> <0.290, 0.518, 0.030> <0.290, 0.509, 0.039> 
		<0.293, 0.523, 0.000> <0.293, 0.523, 0.013> <0.293, 0.517, 0.029> <0.293, 0.508, 0.038> 
		<0.297, 0.522, 0.000> <0.297, 0.522, 0.011> <0.297, 0.515, 0.029> <0.297, 0.506, 0.037> 
		<0.300, 0.520, 0.000> <0.300, 0.520, 0.011> <0.300, 0.513, 0.027> <0.300, 0.505, 0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.195, 0.529, 0.000> <0.195, 0.529, -0.014> <0.195, 0.522, -0.033> <0.195, 0.512, -0.042> 
		<0.190, 0.529, 0.000> <0.190, 0.529, -0.014> <0.190, 0.521, -0.032> <0.190, 0.511, -0.042> 
		<0.184, 0.526, 0.000> <0.184, 0.526, -0.013> <0.184, 0.518, -0.031> <0.184, 0.510, -0.040> 
		<0.180, 0.524, 0.000> <0.180, 0.524, -0.013> <0.180, 0.517, -0.030> <0.180, 0.508, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.195, 0.529, 0.000> <0.190, 0.529, 0.000> <0.184, 0.526, 0.000> <0.180, 0.524, 0.000> 
		<0.195, 0.529, 0.014> <0.190, 0.529, 0.014> <0.184, 0.526, 0.013> <0.180, 0.524, 0.013> 
		<0.195, 0.522, 0.033> <0.190, 0.521, 0.032> <0.184, 0.518, 0.031> <0.180, 0.517, 0.030> 
		<0.195, 0.512, 0.042> <0.190, 0.511, 0.042> <0.184, 0.510, 0.040> <0.180, 0.508, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.195, 0.529, 0.000> <0.207, 0.532, 0.000> <0.223, 0.535, 0.000> <0.235, 0.535, 0.000> 
		<0.195, 0.529, -0.014> <0.207, 0.532, -0.014> <0.223, 0.535, -0.015> <0.235, 0.535, -0.015> 
		<0.195, 0.522, -0.033> <0.207, 0.523, -0.034> <0.223, 0.526, -0.035> <0.235, 0.526, -0.035> 
		<0.195, 0.512, -0.042> <0.207, 0.513, -0.044> <0.223, 0.515, -0.046> <0.235, 0.515, -0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.195, 0.529, 0.000> <0.195, 0.529, 0.014> <0.195, 0.522, 0.033> <0.195, 0.512, 0.042> 
		<0.207, 0.532, 0.000> <0.207, 0.532, 0.014> <0.207, 0.523, 0.034> <0.207, 0.513, 0.044> 
		<0.223, 0.535, 0.000> <0.223, 0.535, 0.015> <0.223, 0.526, 0.035> <0.223, 0.515, 0.046> 
		<0.235, 0.535, 0.000> <0.235, 0.535, 0.015> <0.235, 0.526, 0.035> <0.235, 0.515, 0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.155, 0.505, 0.035> <0.155, 0.497, 0.043> <0.155, 0.481, 0.050> <0.155, 0.469, 0.050> 
		<0.157, 0.506, 0.036> <0.157, 0.498, 0.045> <0.157, 0.481, 0.052> <0.157, 0.469, 0.052> 
		<0.158, 0.508, 0.039> <0.158, 0.499, 0.048> <0.158, 0.482, 0.055> <0.158, 0.469, 0.055> 
		<0.160, 0.508, 0.039> <0.160, 0.499, 0.048> <0.160, 0.482, 0.055> <0.160, 0.469, 0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.155, 0.469, 0.050> <0.155, 0.458, 0.050> <0.155, 0.442, 0.043> <0.155, 0.434, 0.035> 
		<0.157, 0.469, 0.052> <0.157, 0.458, 0.052> <0.157, 0.441, 0.045> <0.157, 0.433, 0.036> 
		<0.158, 0.469, 0.055> <0.158, 0.457, 0.055> <0.158, 0.439, 0.048> <0.158, 0.430, 0.039> 
		<0.160, 0.469, 0.055> <0.160, 0.457, 0.055> <0.160, 0.439, 0.048> <0.160, 0.430, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.155, 0.434, 0.035> <0.155, 0.426, 0.027> <0.155, 0.419, 0.011> <0.155, 0.419, 0.000> 
		<0.157, 0.433, 0.036> <0.157, 0.425, 0.028> <0.157, 0.418, 0.011> <0.157, 0.418, 0.000> 
		<0.158, 0.430, 0.039> <0.158, 0.421, 0.030> <0.158, 0.414, 0.013> <0.158, 0.414, 0.000> 
		<0.160, 0.430, 0.039> <0.160, 0.422, 0.030> <0.160, 0.414, 0.013> <0.160, 0.414, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.155, 0.419, 0.000> <0.155, 0.419, -0.011> <0.155, 0.426, -0.027> <0.155, 0.434, -0.035> 
		<0.157, 0.418, 0.000> <0.157, 0.418, -0.011> <0.157, 0.425, -0.028> <0.157, 0.433, -0.036> 
		<0.158, 0.414, 0.000> <0.158, 0.414, -0.013> <0.158, 0.421, -0.030> <0.158, 0.430, -0.039> 
		<0.160, 0.414, 0.000> <0.160, 0.414, -0.013> <0.160, 0.422, -0.030> <0.160, 0.430, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.155, 0.434, -0.035> <0.155, 0.442, -0.043> <0.155, 0.458, -0.050> <0.155, 0.469, -0.050> 
		<0.157, 0.433, -0.036> <0.157, 0.441, -0.045> <0.157, 0.458, -0.052> <0.157, 0.469, -0.052> 
		<0.158, 0.430, -0.039> <0.158, 0.439, -0.048> <0.158, 0.457, -0.055> <0.158, 0.469, -0.055> 
		<0.160, 0.430, -0.039> <0.160, 0.439, -0.048> <0.160, 0.457, -0.055> <0.160, 0.469, -0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.155, 0.469, -0.050> <0.155, 0.481, -0.050> <0.155, 0.497, -0.043> <0.155, 0.505, -0.035> 
		<0.157, 0.469, -0.052> <0.157, 0.481, -0.052> <0.157, 0.498, -0.045> <0.157, 0.506, -0.036> 
		<0.158, 0.469, -0.055> <0.158, 0.482, -0.055> <0.158, 0.499, -0.048> <0.158, 0.508, -0.039> 
		<0.160, 0.469, -0.055> <0.160, 0.482, -0.055> <0.160, 0.499, -0.048> <0.160, 0.508, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.160, 0.508, 0.039> <0.160, 0.499, 0.048> <0.160, 0.482, 0.055> <0.160, 0.469, 0.055> 
		<0.162, 0.508, 0.039> <0.162, 0.499, 0.048> <0.162, 0.482, 0.055> <0.162, 0.469, 0.055> 
		<0.163, 0.505, 0.036> <0.163, 0.497, 0.044> <0.163, 0.481, 0.051> <0.163, 0.469, 0.051> 
		<0.165, 0.505, 0.035> <0.165, 0.497, 0.043> <0.165, 0.481, 0.050> <0.165, 0.469, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.160, 0.469, 0.055> <0.160, 0.457, 0.055> <0.160, 0.439, 0.048> <0.160, 0.430, 0.039> 
		<0.162, 0.469, 0.055> <0.162, 0.457, 0.055> <0.162, 0.439, 0.048> <0.162, 0.430, 0.039> 
		<0.163, 0.469, 0.051> <0.163, 0.458, 0.051> <0.163, 0.441, 0.044> <0.163, 0.433, 0.036> 
		<0.165, 0.469, 0.050> <0.165, 0.458, 0.050> <0.165, 0.442, 0.043> <0.165, 0.434, 0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.160, 0.430, 0.039> <0.160, 0.422, 0.030> <0.160, 0.414, 0.013> <0.160, 0.414, 0.000> 
		<0.162, 0.430, 0.039> <0.162, 0.422, 0.030> <0.162, 0.414, 0.013> <0.162, 0.414, 0.000> 
		<0.163, 0.433, 0.036> <0.163, 0.425, 0.028> <0.163, 0.418, 0.011> <0.163, 0.418, 0.000> 
		<0.165, 0.434, 0.035> <0.165, 0.426, 0.027> <0.165, 0.419, 0.011> <0.165, 0.419, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.160, 0.414, 0.000> <0.160, 0.414, -0.013> <0.160, 0.422, -0.030> <0.160, 0.430, -0.039> 
		<0.162, 0.414, 0.000> <0.162, 0.414, -0.013> <0.162, 0.422, -0.030> <0.162, 0.430, -0.039> 
		<0.163, 0.418, 0.000> <0.163, 0.418, -0.011> <0.163, 0.425, -0.028> <0.163, 0.433, -0.036> 
		<0.165, 0.419, 0.000> <0.165, 0.419, -0.011> <0.165, 0.426, -0.027> <0.165, 0.434, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.160, 0.430, -0.039> <0.160, 0.439, -0.048> <0.160, 0.457, -0.055> <0.160, 0.469, -0.055> 
		<0.162, 0.430, -0.039> <0.162, 0.439, -0.048> <0.162, 0.457, -0.055> <0.162, 0.469, -0.055> 
		<0.163, 0.433, -0.036> <0.163, 0.441, -0.044> <0.163, 0.458, -0.051> <0.163, 0.469, -0.051> 
		<0.165, 0.434, -0.035> <0.165, 0.442, -0.043> <0.165, 0.458, -0.050> <0.165, 0.469, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.160, 0.469, -0.055> <0.160, 0.482, -0.055> <0.160, 0.499, -0.048> <0.160, 0.508, -0.039> 
		<0.162, 0.469, -0.055> <0.162, 0.482, -0.055> <0.162, 0.499, -0.048> <0.162, 0.508, -0.039> 
		<0.163, 0.469, -0.051> <0.163, 0.481, -0.051> <0.163, 0.497, -0.044> <0.163, 0.505, -0.036> 
		<0.165, 0.469, -0.050> <0.165, 0.481, -0.050> <0.165, 0.497, -0.043> <0.165, 0.505, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.165, 0.505, 0.035> <0.165, 0.497, 0.043> <0.165, 0.481, 0.050> <0.165, 0.469, 0.050> 
		<0.166, 0.504, 0.035> <0.166, 0.496, 0.043> <0.166, 0.481, 0.049> <0.166, 0.469, 0.049> 
		<0.169, 0.504, 0.035> <0.169, 0.496, 0.043> <0.169, 0.481, 0.050> <0.169, 0.469, 0.050> 
		<0.170, 0.505, 0.035> <0.170, 0.497, 0.043> <0.170, 0.481, 0.050> <0.170, 0.469, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.165, 0.469, 0.050> <0.165, 0.458, 0.050> <0.165, 0.442, 0.043> <0.165, 0.434, 0.035> 
		<0.166, 0.469, 0.049> <0.167, 0.458, 0.049> <0.167, 0.443, 0.043> <0.167, 0.434, 0.035> 
		<0.169, 0.469, 0.050> <0.169, 0.458, 0.050> <0.169, 0.442, 0.043> <0.169, 0.434, 0.035> 
		<0.170, 0.469, 0.050> <0.170, 0.458, 0.050> <0.170, 0.442, 0.043> <0.170, 0.434, 0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.165, 0.434, 0.035> <0.165, 0.426, 0.027> <0.165, 0.419, 0.011> <0.165, 0.419, 0.000> 
		<0.167, 0.434, 0.035> <0.167, 0.426, 0.027> <0.167, 0.420, 0.011> <0.167, 0.420, 0.000> 
		<0.169, 0.434, 0.035> <0.169, 0.426, 0.027> <0.169, 0.420, 0.011> <0.169, 0.420, 0.000> 
		<0.170, 0.434, 0.035> <0.170, 0.426, 0.027> <0.170, 0.419, 0.011> <0.170, 0.419, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.165, 0.419, 0.000> <0.165, 0.419, -0.011> <0.165, 0.426, -0.027> <0.165, 0.434, -0.035> 
		<0.167, 0.420, 0.000> <0.167, 0.420, -0.011> <0.167, 0.426, -0.027> <0.167, 0.434, -0.035> 
		<0.169, 0.420, 0.000> <0.169, 0.420, -0.011> <0.169, 0.426, -0.027> <0.169, 0.434, -0.035> 
		<0.170, 0.419, 0.000> <0.170, 0.419, -0.011> <0.170, 0.426, -0.027> <0.170, 0.434, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.165, 0.434, -0.035> <0.165, 0.442, -0.043> <0.165, 0.458, -0.050> <0.165, 0.469, -0.050> 
		<0.167, 0.434, -0.035> <0.167, 0.443, -0.043> <0.167, 0.458, -0.049> <0.166, 0.469, -0.049> 
		<0.169, 0.434, -0.035> <0.169, 0.442, -0.043> <0.169, 0.458, -0.050> <0.169, 0.469, -0.050> 
		<0.170, 0.434, -0.035> <0.170, 0.442, -0.043> <0.170, 0.458, -0.050> <0.170, 0.469, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.165, 0.469, -0.050> <0.165, 0.481, -0.050> <0.165, 0.497, -0.043> <0.165, 0.505, -0.035> 
		<0.166, 0.469, -0.049> <0.166, 0.481, -0.049> <0.166, 0.496, -0.043> <0.166, 0.504, -0.035> 
		<0.169, 0.469, -0.050> <0.169, 0.481, -0.050> <0.169, 0.496, -0.043> <0.169, 0.504, -0.035> 
		<0.170, 0.469, -0.050> <0.170, 0.481, -0.050> <0.170, 0.497, -0.043> <0.170, 0.505, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.170, 0.505, 0.035> <0.170, 0.497, 0.043> <0.170, 0.481, 0.050> <0.170, 0.469, 0.050> 
		<0.173, 0.505, 0.036> <0.173, 0.497, 0.044> <0.173, 0.481, 0.051> <0.173, 0.469, 0.051> 
		<0.177, 0.507, 0.038> <0.177, 0.498, 0.047> <0.177, 0.482, 0.054> <0.177, 0.469, 0.054> 
		<0.180, 0.508, 0.039> <0.180, 0.499, 0.048> <0.180, 0.482, 0.055> <0.180, 0.469, 0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.170, 0.469, 0.050> <0.170, 0.458, 0.050> <0.170, 0.442, 0.043> <0.170, 0.434, 0.035> 
		<0.173, 0.469, 0.051> <0.173, 0.458, 0.051> <0.173, 0.441, 0.044> <0.173, 0.433, 0.036> 
		<0.177, 0.469, 0.054> <0.177, 0.457, 0.054> <0.177, 0.440, 0.047> <0.177, 0.431, 0.038> 
		<0.180, 0.469, 0.055> <0.180, 0.457, 0.055> <0.180, 0.439, 0.048> <0.180, 0.430, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.170, 0.434, 0.035> <0.170, 0.426, 0.027> <0.170, 0.419, 0.011> <0.170, 0.419, 0.000> 
		<0.173, 0.433, 0.036> <0.173, 0.425, 0.028> <0.173, 0.418, 0.011> <0.173, 0.418, 0.000> 
		<0.177, 0.431, 0.038> <0.177, 0.422, 0.029> <0.177, 0.416, 0.013> <0.177, 0.416, 0.000> 
		<0.180, 0.430, 0.039> <0.180, 0.422, 0.030> <0.180, 0.414, 0.013> <0.180, 0.414, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.170, 0.419, 0.000> <0.170, 0.419, -0.011> <0.170, 0.426, -0.027> <0.170, 0.434, -0.035> 
		<0.173, 0.418, 0.000> <0.173, 0.418, -0.011> <0.173, 0.425, -0.028> <0.173, 0.433, -0.036> 
		<0.177, 0.416, 0.000> <0.177, 0.416, -0.013> <0.177, 0.422, -0.029> <0.177, 0.431, -0.038> 
		<0.180, 0.414, 0.000> <0.180, 0.414, -0.013> <0.180, 0.422, -0.030> <0.180, 0.430, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.170, 0.434, -0.035> <0.170, 0.442, -0.043> <0.170, 0.458, -0.050> <0.170, 0.469, -0.050> 
		<0.173, 0.433, -0.036> <0.173, 0.441, -0.044> <0.173, 0.458, -0.051> <0.173, 0.469, -0.051> 
		<0.177, 0.431, -0.038> <0.177, 0.440, -0.047> <0.177, 0.457, -0.054> <0.177, 0.469, -0.054> 
		<0.180, 0.430, -0.039> <0.180, 0.439, -0.048> <0.180, 0.457, -0.055> <0.180, 0.469, -0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.170, 0.469, -0.050> <0.170, 0.481, -0.050> <0.170, 0.497, -0.043> <0.170, 0.505, -0.035> 
		<0.173, 0.469, -0.051> <0.173, 0.481, -0.051> <0.173, 0.497, -0.044> <0.173, 0.505, -0.036> 
		<0.177, 0.469, -0.054> <0.177, 0.482, -0.054> <0.177, 0.498, -0.047> <0.177, 0.507, -0.038> 
		<0.180, 0.469, -0.055> <0.180, 0.482, -0.055> <0.180, 0.499, -0.048> <0.180, 0.508, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.180, 0.508, 0.039> <0.180, 0.499, 0.048> <0.180, 0.482, 0.055> <0.180, 0.469, 0.055> 
		<0.184, 0.510, 0.040> <0.184, 0.501, 0.049> <0.185, 0.482, 0.057> <0.185, 0.469, 0.057> 
		<0.190, 0.511, 0.042> <0.190, 0.501, 0.052> <0.190, 0.483, 0.059> <0.190, 0.469, 0.059> 
		<0.195, 0.512, 0.042> <0.195, 0.502, 0.052> <0.195, 0.483, 0.060> <0.195, 0.469, 0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.180, 0.469, 0.055> <0.180, 0.457, 0.055> <0.180, 0.439, 0.048> <0.180, 0.430, 0.039> 
		<0.185, 0.469, 0.057> <0.185, 0.457, 0.057> <0.185, 0.438, 0.049> <0.185, 0.429, 0.040> 
		<0.190, 0.469, 0.059> <0.191, 0.456, 0.059> <0.191, 0.437, 0.052> <0.191, 0.428, 0.042> 
		<0.195, 0.469, 0.060> <0.195, 0.456, 0.060> <0.195, 0.437, 0.052> <0.195, 0.427, 0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.180, 0.430, 0.039> <0.180, 0.422, 0.030> <0.180, 0.414, 0.013> <0.180, 0.414, 0.000> 
		<0.185, 0.429, 0.040> <0.185, 0.420, 0.031> <0.185, 0.413, 0.013> <0.185, 0.413, 0.000> 
		<0.191, 0.428, 0.042> <0.191, 0.418, 0.032> <0.191, 0.410, 0.014> <0.191, 0.410, 0.000> 
		<0.195, 0.427, 0.042> <0.195, 0.417, 0.033> <0.195, 0.409, 0.014> <0.195, 0.409, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.180, 0.414, 0.000> <0.180, 0.414, -0.013> <0.180, 0.422, -0.030> <0.180, 0.430, -0.039> 
		<0.185, 0.413, 0.000> <0.185, 0.413, -0.013> <0.185, 0.420, -0.031> <0.185, 0.429, -0.040> 
		<0.191, 0.410, 0.000> <0.191, 0.410, -0.014> <0.191, 0.418, -0.032> <0.191, 0.428, -0.042> 
		<0.195, 0.409, 0.000> <0.195, 0.409, -0.014> <0.195, 0.417, -0.033> <0.195, 0.427, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.180, 0.430, -0.039> <0.180, 0.439, -0.048> <0.180, 0.457, -0.055> <0.180, 0.469, -0.055> 
		<0.185, 0.429, -0.040> <0.185, 0.438, -0.049> <0.185, 0.457, -0.057> <0.185, 0.469, -0.057> 
		<0.191, 0.428, -0.042> <0.191, 0.437, -0.052> <0.191, 0.456, -0.059> <0.190, 0.469, -0.059> 
		<0.195, 0.427, -0.042> <0.195, 0.437, -0.052> <0.195, 0.456, -0.060> <0.195, 0.469, -0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.180, 0.469, -0.055> <0.180, 0.482, -0.055> <0.180, 0.499, -0.048> <0.180, 0.508, -0.039> 
		<0.185, 0.469, -0.057> <0.185, 0.482, -0.057> <0.184, 0.501, -0.049> <0.184, 0.510, -0.040> 
		<0.190, 0.469, -0.059> <0.190, 0.483, -0.059> <0.190, 0.501, -0.052> <0.190, 0.511, -0.042> 
		<0.195, 0.469, -0.060> <0.195, 0.483, -0.060> <0.195, 0.502, -0.052> <0.195, 0.512, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.195, 0.512, 0.042> <0.195, 0.502, 0.052> <0.195, 0.483, 0.060> <0.195, 0.469, 0.060> 
		<0.207, 0.513, 0.044> <0.207, 0.504, 0.054> <0.207, 0.483, 0.062> <0.207, 0.469, 0.062> 
		<0.223, 0.515, 0.046> <0.223, 0.505, 0.057> <0.223, 0.484, 0.065> <0.223, 0.470, 0.065> 
		<0.235, 0.515, 0.046> <0.235, 0.505, 0.057> <0.235, 0.484, 0.065> <0.235, 0.470, 0.065> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.195, 0.469, 0.060> <0.195, 0.456, 0.060> <0.195, 0.437, 0.052> <0.195, 0.427, 0.042> 
		<0.207, 0.469, 0.062> <0.207, 0.456, 0.062> <0.207, 0.435, 0.054> <0.207, 0.426, 0.044> 
		<0.223, 0.470, 0.065> <0.223, 0.455, 0.065> <0.223, 0.434, 0.057> <0.223, 0.424, 0.046> 
		<0.235, 0.470, 0.065> <0.235, 0.455, 0.065> <0.235, 0.434, 0.057> <0.235, 0.424, 0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.195, 0.427, 0.042> <0.195, 0.417, 0.033> <0.195, 0.409, 0.014> <0.195, 0.409, 0.000> 
		<0.207, 0.426, 0.044> <0.207, 0.416, 0.034> <0.207, 0.407, 0.014> <0.207, 0.407, 0.000> 
		<0.223, 0.424, 0.046> <0.223, 0.413, 0.035> <0.223, 0.405, 0.015> <0.223, 0.405, 0.000> 
		<0.235, 0.424, 0.046> <0.235, 0.413, 0.035> <0.235, 0.405, 0.015> <0.235, 0.405, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.195, 0.409, 0.000> <0.195, 0.409, -0.014> <0.195, 0.417, -0.033> <0.195, 0.427, -0.042> 
		<0.207, 0.407, 0.000> <0.207, 0.407, -0.014> <0.207, 0.416, -0.034> <0.207, 0.426, -0.044> 
		<0.223, 0.405, 0.000> <0.223, 0.405, -0.015> <0.223, 0.413, -0.035> <0.223, 0.424, -0.046> 
		<0.235, 0.405, 0.000> <0.235, 0.405, -0.015> <0.235, 0.413, -0.035> <0.235, 0.424, -0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.195, 0.427, -0.042> <0.195, 0.437, -0.052> <0.195, 0.456, -0.060> <0.195, 0.469, -0.060> 
		<0.207, 0.426, -0.044> <0.207, 0.435, -0.054> <0.207, 0.456, -0.062> <0.207, 0.469, -0.062> 
		<0.223, 0.424, -0.046> <0.223, 0.434, -0.057> <0.223, 0.455, -0.065> <0.223, 0.470, -0.065> 
		<0.235, 0.424, -0.046> <0.235, 0.434, -0.057> <0.235, 0.455, -0.065> <0.235, 0.470, -0.065> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.195, 0.469, -0.060> <0.195, 0.483, -0.060> <0.195, 0.502, -0.052> <0.195, 0.512, -0.042> 
		<0.207, 0.469, -0.062> <0.207, 0.483, -0.062> <0.207, 0.504, -0.054> <0.207, 0.513, -0.044> 
		<0.223, 0.470, -0.065> <0.223, 0.484, -0.065> <0.223, 0.505, -0.057> <0.223, 0.515, -0.046> 
		<0.235, 0.470, -0.065> <0.235, 0.484, -0.065> <0.235, 0.505, -0.057> <0.235, 0.515, -0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.235, 0.515, 0.046> <0.235, 0.505, 0.057> <0.235, 0.484, 0.065> <0.235, 0.470, 0.065> 
		<0.247, 0.516, 0.046> <0.247, 0.505, 0.057> <0.247, 0.484, 0.065> <0.247, 0.470, 0.065> 
		<0.263, 0.514, 0.044> <0.263, 0.504, 0.054> <0.263, 0.483, 0.062> <0.263, 0.470, 0.062> 
		<0.275, 0.512, 0.042> <0.275, 0.502, 0.052> <0.275, 0.483, 0.060> <0.275, 0.470, 0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.235, 0.470, 0.065> <0.235, 0.455, 0.065> <0.235, 0.434, 0.057> <0.235, 0.424, 0.046> 
		<0.247, 0.470, 0.065> <0.247, 0.455, 0.065> <0.247, 0.434, 0.057> <0.247, 0.424, 0.046> 
		<0.263, 0.470, 0.062> <0.263, 0.456, 0.062> <0.263, 0.435, 0.054> <0.263, 0.426, 0.044> 
		<0.275, 0.470, 0.060> <0.275, 0.456, 0.060> <0.275, 0.437, 0.052> <0.275, 0.427, 0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.235, 0.424, 0.046> <0.235, 0.413, 0.035> <0.235, 0.405, 0.015> <0.235, 0.405, 0.000> 
		<0.247, 0.424, 0.046> <0.247, 0.413, 0.035> <0.247, 0.405, 0.015> <0.247, 0.405, 0.000> 
		<0.263, 0.426, 0.044> <0.263, 0.416, 0.034> <0.263, 0.407, 0.014> <0.263, 0.407, 0.000> 
		<0.275, 0.427, 0.042> <0.275, 0.417, 0.033> <0.275, 0.410, 0.014> <0.275, 0.410, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.235, 0.405, 0.000> <0.235, 0.405, -0.015> <0.235, 0.413, -0.035> <0.235, 0.424, -0.046> 
		<0.247, 0.405, 0.000> <0.247, 0.405, -0.015> <0.247, 0.413, -0.035> <0.247, 0.424, -0.046> 
		<0.263, 0.407, 0.000> <0.263, 0.407, -0.014> <0.263, 0.416, -0.034> <0.263, 0.426, -0.044> 
		<0.275, 0.410, 0.000> <0.275, 0.410, -0.014> <0.275, 0.417, -0.033> <0.275, 0.427, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.235, 0.424, -0.046> <0.235, 0.434, -0.057> <0.235, 0.455, -0.065> <0.235, 0.470, -0.065> 
		<0.247, 0.424, -0.046> <0.247, 0.434, -0.057> <0.247, 0.455, -0.065> <0.247, 0.470, -0.065> 
		<0.263, 0.426, -0.044> <0.263, 0.435, -0.054> <0.263, 0.456, -0.062> <0.263, 0.470, -0.062> 
		<0.275, 0.427, -0.042> <0.275, 0.437, -0.052> <0.275, 0.456, -0.060> <0.275, 0.470, -0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.235, 0.470, -0.065> <0.235, 0.484, -0.065> <0.235, 0.505, -0.057> <0.235, 0.515, -0.046> 
		<0.247, 0.470, -0.065> <0.247, 0.484, -0.065> <0.247, 0.505, -0.057> <0.247, 0.516, -0.046> 
		<0.263, 0.470, -0.062> <0.263, 0.483, -0.062> <0.263, 0.504, -0.054> <0.263, 0.514, -0.044> 
		<0.275, 0.470, -0.060> <0.275, 0.483, -0.060> <0.275, 0.502, -0.052> <0.275, 0.512, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.275, 0.512, 0.042> <0.275, 0.502, 0.052> <0.275, 0.483, 0.060> <0.275, 0.470, 0.060> 
		<0.280, 0.511, 0.042> <0.280, 0.502, 0.052> <0.280, 0.483, 0.059> <0.280, 0.470, 0.059> 
		<0.286, 0.510, 0.040> <0.286, 0.501, 0.049> <0.286, 0.482, 0.057> <0.286, 0.470, 0.057> 
		<0.290, 0.509, 0.039> <0.290, 0.500, 0.048> <0.290, 0.482, 0.055> <0.290, 0.470, 0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.275, 0.470, 0.060> <0.275, 0.456, 0.060> <0.275, 0.437, 0.052> <0.275, 0.427, 0.042> 
		<0.280, 0.470, 0.059> <0.280, 0.456, 0.059> <0.280, 0.438, 0.052> <0.280, 0.428, 0.042> 
		<0.286, 0.470, 0.057> <0.286, 0.457, 0.057> <0.286, 0.438, 0.049> <0.286, 0.430, 0.040> 
		<0.290, 0.470, 0.055> <0.290, 0.457, 0.055> <0.290, 0.440, 0.048> <0.290, 0.431, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.275, 0.427, 0.042> <0.275, 0.417, 0.033> <0.275, 0.410, 0.014> <0.275, 0.410, 0.000> 
		<0.280, 0.428, 0.042> <0.280, 0.418, 0.032> <0.280, 0.411, 0.014> <0.280, 0.411, 0.000> 
		<0.286, 0.430, 0.040> <0.286, 0.421, 0.031> <0.286, 0.413, 0.013> <0.286, 0.413, 0.000> 
		<0.290, 0.431, 0.039> <0.290, 0.422, 0.030> <0.290, 0.415, 0.013> <0.290, 0.415, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.275, 0.410, 0.000> <0.275, 0.410, -0.014> <0.275, 0.417, -0.033> <0.275, 0.427, -0.042> 
		<0.280, 0.411, 0.000> <0.280, 0.411, -0.014> <0.280, 0.418, -0.032> <0.280, 0.428, -0.042> 
		<0.286, 0.413, 0.000> <0.286, 0.413, -0.013> <0.286, 0.421, -0.031> <0.286, 0.430, -0.040> 
		<0.290, 0.415, 0.000> <0.290, 0.415, -0.013> <0.290, 0.422, -0.030> <0.290, 0.431, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.275, 0.427, -0.042> <0.275, 0.437, -0.052> <0.275, 0.456, -0.060> <0.275, 0.470, -0.060> 
		<0.280, 0.428, -0.042> <0.280, 0.438, -0.052> <0.280, 0.456, -0.059> <0.280, 0.470, -0.059> 
		<0.286, 0.430, -0.040> <0.286, 0.438, -0.049> <0.286, 0.457, -0.057> <0.286, 0.470, -0.057> 
		<0.290, 0.431, -0.039> <0.290, 0.440, -0.048> <0.290, 0.457, -0.055> <0.290, 0.470, -0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.275, 0.470, -0.060> <0.275, 0.483, -0.060> <0.275, 0.502, -0.052> <0.275, 0.512, -0.042> 
		<0.280, 0.470, -0.059> <0.280, 0.483, -0.059> <0.280, 0.502, -0.052> <0.280, 0.511, -0.042> 
		<0.286, 0.470, -0.057> <0.286, 0.482, -0.057> <0.286, 0.501, -0.049> <0.286, 0.510, -0.040> 
		<0.290, 0.470, -0.055> <0.290, 0.482, -0.055> <0.290, 0.500, -0.048> <0.290, 0.509, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.290, 0.509, 0.039> <0.290, 0.500, 0.048> <0.290, 0.482, 0.055> <0.290, 0.470, 0.055> 
		<0.293, 0.508, 0.038> <0.293, 0.499, 0.047> <0.293, 0.482, 0.054> <0.293, 0.470, 0.054> 
		<0.297, 0.506, 0.037> <0.297, 0.498, 0.045> <0.297, 0.481, 0.052> <0.297, 0.470, 0.052> 
		<0.300, 0.505, 0.035> <0.300, 0.497, 0.043> <0.300, 0.481, 0.050> <0.300, 0.470, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.290, 0.470, 0.055> <0.290, 0.457, 0.055> <0.290, 0.440, 0.048> <0.290, 0.431, 0.039> 
		<0.293, 0.470, 0.054> <0.293, 0.457, 0.054> <0.293, 0.441, 0.047> <0.293, 0.432, 0.038> 
		<0.297, 0.470, 0.052> <0.297, 0.458, 0.052> <0.297, 0.441, 0.045> <0.297, 0.433, 0.037> 
		<0.300, 0.470, 0.050> <0.300, 0.458, 0.050> <0.300, 0.442, 0.043> <0.300, 0.434, 0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.290, 0.431, 0.039> <0.290, 0.422, 0.030> <0.290, 0.415, 0.013> <0.290, 0.415, 0.000> 
		<0.293, 0.432, 0.038> <0.293, 0.423, 0.029> <0.293, 0.416, 0.013> <0.293, 0.416, 0.000> 
		<0.297, 0.433, 0.037> <0.297, 0.425, 0.029> <0.297, 0.418, 0.011> <0.297, 0.418, 0.000> 
		<0.300, 0.434, 0.035> <0.300, 0.426, 0.027> <0.300, 0.420, 0.011> <0.300, 0.420, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.290, 0.415, 0.000> <0.290, 0.415, -0.013> <0.290, 0.422, -0.030> <0.290, 0.431, -0.039> 
		<0.293, 0.416, 0.000> <0.293, 0.416, -0.013> <0.293, 0.423, -0.029> <0.293, 0.432, -0.038> 
		<0.297, 0.418, 0.000> <0.297, 0.418, -0.011> <0.297, 0.425, -0.029> <0.297, 0.433, -0.037> 
		<0.300, 0.420, 0.000> <0.300, 0.420, -0.011> <0.300, 0.426, -0.027> <0.300, 0.434, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.290, 0.431, -0.039> <0.290, 0.440, -0.048> <0.290, 0.457, -0.055> <0.290, 0.470, -0.055> 
		<0.293, 0.432, -0.038> <0.293, 0.441, -0.047> <0.293, 0.457, -0.054> <0.293, 0.470, -0.054> 
		<0.297, 0.433, -0.037> <0.297, 0.441, -0.045> <0.297, 0.458, -0.052> <0.297, 0.470, -0.052> 
		<0.300, 0.434, -0.035> <0.300, 0.442, -0.043> <0.300, 0.458, -0.050> <0.300, 0.470, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.290, 0.470, -0.055> <0.290, 0.482, -0.055> <0.290, 0.500, -0.048> <0.290, 0.509, -0.039> 
		<0.293, 0.470, -0.054> <0.293, 0.482, -0.054> <0.293, 0.499, -0.047> <0.293, 0.508, -0.038> 
		<0.297, 0.470, -0.052> <0.297, 0.481, -0.052> <0.297, 0.498, -0.045> <0.297, 0.506, -0.037> 
		<0.300, 0.470, -0.050> <0.300, 0.481, -0.050> <0.300, 0.497, -0.043> <0.300, 0.505, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.300, 0.505, 0.035> <0.300, 0.497, 0.043> <0.300, 0.481, 0.050> <0.300, 0.470, 0.050> 
		<0.302, 0.504, 0.035> <0.302, 0.496, 0.043> <0.302, 0.481, 0.049> <0.302, 0.470, 0.049> 
		<0.303, 0.502, 0.032> <0.303, 0.495, 0.040> <0.303, 0.480, 0.046> <0.303, 0.470, 0.046> 
		<0.305, 0.502, 0.032> <0.305, 0.494, 0.039> <0.305, 0.480, 0.045> <0.305, 0.470, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.300, 0.470, 0.050> <0.300, 0.458, 0.050> <0.300, 0.442, 0.043> <0.300, 0.434, 0.035> 
		<0.302, 0.470, 0.049> <0.302, 0.458, 0.049> <0.302, 0.443, 0.043> <0.302, 0.435, 0.035> 
		<0.303, 0.470, 0.046> <0.303, 0.459, 0.046> <0.303, 0.445, 0.040> <0.303, 0.437, 0.032> 
		<0.305, 0.470, 0.045> <0.305, 0.459, 0.045> <0.305, 0.445, 0.039> <0.305, 0.438, 0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.300, 0.434, 0.035> <0.300, 0.426, 0.027> <0.300, 0.420, 0.011> <0.300, 0.420, 0.000> 
		<0.302, 0.435, 0.035> <0.302, 0.427, 0.026> <0.302, 0.421, 0.011> <0.302, 0.421, 0.000> 
		<0.303, 0.437, 0.032> <0.303, 0.430, 0.025> <0.303, 0.424, 0.010> <0.303, 0.424, 0.000> 
		<0.305, 0.438, 0.032> <0.305, 0.431, 0.025> <0.305, 0.425, 0.010> <0.305, 0.425, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.300, 0.420, 0.000> <0.300, 0.420, -0.011> <0.300, 0.426, -0.027> <0.300, 0.434, -0.035> 
		<0.302, 0.421, 0.000> <0.302, 0.421, -0.011> <0.302, 0.427, -0.026> <0.302, 0.435, -0.035> 
		<0.303, 0.424, 0.000> <0.303, 0.424, -0.010> <0.303, 0.430, -0.025> <0.303, 0.437, -0.032> 
		<0.305, 0.425, 0.000> <0.305, 0.425, -0.010> <0.305, 0.431, -0.025> <0.305, 0.438, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.300, 0.434, -0.035> <0.300, 0.442, -0.043> <0.300, 0.458, -0.050> <0.300, 0.470, -0.050> 
		<0.302, 0.435, -0.035> <0.302, 0.443, -0.043> <0.302, 0.458, -0.049> <0.302, 0.470, -0.049> 
		<0.303, 0.437, -0.032> <0.303, 0.445, -0.040> <0.303, 0.459, -0.046> <0.303, 0.470, -0.046> 
		<0.305, 0.438, -0.032> <0.305, 0.445, -0.039> <0.305, 0.459, -0.045> <0.305, 0.470, -0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.300, 0.470, -0.050> <0.300, 0.481, -0.050> <0.300, 0.497, -0.043> <0.300, 0.505, -0.035> 
		<0.302, 0.470, -0.049> <0.302, 0.481, -0.049> <0.302, 0.496, -0.043> <0.302, 0.504, -0.035> 
		<0.303, 0.470, -0.046> <0.303, 0.480, -0.046> <0.303, 0.495, -0.040> <0.303, 0.502, -0.032> 
		<0.305, 0.470, -0.045> <0.305, 0.480, -0.045> <0.305, 0.494, -0.039> <0.305, 0.502, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.305, 0.502, 0.032> <0.305, 0.494, 0.039> <0.305, 0.480, 0.045> <0.305, 0.470, 0.045> 
		<0.306, 0.501, 0.031> <0.306, 0.494, 0.039> <0.306, 0.480, 0.044> <0.306, 0.470, 0.044> 
		<0.309, 0.501, 0.031> <0.309, 0.494, 0.039> <0.309, 0.480, 0.045> <0.309, 0.470, 0.045> 
		<0.310, 0.502, 0.032> <0.310, 0.494, 0.039> <0.310, 0.480, 0.045> <0.310, 0.470, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.305, 0.470, 0.045> <0.305, 0.459, 0.045> <0.305, 0.445, 0.039> <0.305, 0.438, 0.032> 
		<0.306, 0.470, 0.044> <0.307, 0.459, 0.044> <0.307, 0.446, 0.039> <0.307, 0.438, 0.031> 
		<0.309, 0.470, 0.045> <0.309, 0.459, 0.045> <0.309, 0.446, 0.039> <0.309, 0.438, 0.031> 
		<0.310, 0.470, 0.045> <0.310, 0.459, 0.045> <0.310, 0.445, 0.039> <0.310, 0.438, 0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.305, 0.438, 0.032> <0.305, 0.431, 0.025> <0.305, 0.425, 0.010> <0.305, 0.425, 0.000> 
		<0.307, 0.438, 0.031> <0.307, 0.431, 0.024> <0.307, 0.425, 0.010> <0.307, 0.425, 0.000> 
		<0.309, 0.438, 0.031> <0.309, 0.431, 0.024> <0.309, 0.425, 0.010> <0.309, 0.425, 0.000> 
		<0.310, 0.438, 0.032> <0.310, 0.431, 0.025> <0.310, 0.425, 0.010> <0.310, 0.425, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.305, 0.425, 0.000> <0.305, 0.425, -0.010> <0.305, 0.431, -0.025> <0.305, 0.438, -0.032> 
		<0.307, 0.425, 0.000> <0.307, 0.425, -0.010> <0.307, 0.431, -0.024> <0.307, 0.438, -0.031> 
		<0.309, 0.425, 0.000> <0.309, 0.425, -0.010> <0.309, 0.431, -0.024> <0.309, 0.438, -0.031> 
		<0.310, 0.425, 0.000> <0.310, 0.425, -0.010> <0.310, 0.431, -0.025> <0.310, 0.438, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.305, 0.438, -0.032> <0.305, 0.445, -0.039> <0.305, 0.459, -0.045> <0.305, 0.470, -0.045> 
		<0.307, 0.438, -0.031> <0.307, 0.446, -0.039> <0.307, 0.459, -0.044> <0.306, 0.470, -0.044> 
		<0.309, 0.438, -0.031> <0.309, 0.446, -0.039> <0.309, 0.459, -0.045> <0.309, 0.470, -0.045> 
		<0.310, 0.438, -0.032> <0.310, 0.445, -0.039> <0.310, 0.459, -0.045> <0.310, 0.470, -0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.305, 0.470, -0.045> <0.305, 0.480, -0.045> <0.305, 0.494, -0.039> <0.305, 0.502, -0.032> 
		<0.306, 0.470, -0.044> <0.306, 0.480, -0.044> <0.306, 0.494, -0.039> <0.306, 0.501, -0.031> 
		<0.309, 0.470, -0.045> <0.309, 0.480, -0.045> <0.309, 0.494, -0.039> <0.309, 0.501, -0.031> 
		<0.310, 0.470, -0.045> <0.310, 0.480, -0.045> <0.310, 0.494, -0.039> <0.310, 0.502, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.310, 0.502, 0.032> <0.310, 0.494, 0.039> <0.310, 0.480, 0.045> <0.310, 0.470, 0.045> 
		<0.313, 0.502, 0.033> <0.313, 0.495, 0.040> <0.313, 0.480, 0.046> <0.313, 0.470, 0.046> 
		<0.317, 0.504, 0.034> <0.317, 0.496, 0.043> <0.317, 0.481, 0.049> <0.317, 0.470, 0.049> 
		<0.320, 0.505, 0.035> <0.320, 0.497, 0.043> <0.320, 0.481, 0.050> <0.320, 0.470, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.310, 0.470, 0.045> <0.310, 0.459, 0.045> <0.310, 0.445, 0.039> <0.310, 0.438, 0.032> 
		<0.313, 0.470, 0.046> <0.313, 0.459, 0.046> <0.313, 0.444, 0.040> <0.313, 0.437, 0.033> 
		<0.317, 0.470, 0.049> <0.317, 0.458, 0.049> <0.317, 0.443, 0.043> <0.317, 0.435, 0.034> 
		<0.320, 0.470, 0.050> <0.320, 0.458, 0.050> <0.320, 0.443, 0.043> <0.320, 0.434, 0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.310, 0.438, 0.032> <0.310, 0.431, 0.025> <0.310, 0.425, 0.010> <0.310, 0.425, 0.000> 
		<0.313, 0.437, 0.033> <0.313, 0.430, 0.025> <0.313, 0.424, 0.010> <0.313, 0.424, 0.000> 
		<0.317, 0.435, 0.034> <0.317, 0.427, 0.026> <0.317, 0.421, 0.011> <0.317, 0.421, 0.000> 
		<0.320, 0.434, 0.035> <0.320, 0.426, 0.027> <0.320, 0.420, 0.011> <0.320, 0.420, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.310, 0.425, 0.000> <0.310, 0.425, -0.010> <0.310, 0.431, -0.025> <0.310, 0.438, -0.032> 
		<0.313, 0.424, 0.000> <0.313, 0.424, -0.010> <0.313, 0.430, -0.025> <0.313, 0.437, -0.033> 
		<0.317, 0.421, 0.000> <0.317, 0.421, -0.011> <0.317, 0.427, -0.026> <0.317, 0.435, -0.034> 
		<0.320, 0.420, 0.000> <0.320, 0.420, -0.011> <0.320, 0.426, -0.027> <0.320, 0.434, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.310, 0.438, -0.032> <0.310, 0.445, -0.039> <0.310, 0.459, -0.045> <0.310, 0.470, -0.045> 
		<0.313, 0.437, -0.033> <0.313, 0.444, -0.040> <0.313, 0.459, -0.046> <0.313, 0.470, -0.046> 
		<0.317, 0.435, -0.034> <0.317, 0.443, -0.043> <0.317, 0.458, -0.049> <0.317, 0.470, -0.049> 
		<0.320, 0.434, -0.035> <0.320, 0.443, -0.043> <0.320, 0.458, -0.050> <0.320, 0.470, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.310, 0.470, -0.045> <0.310, 0.480, -0.045> <0.310, 0.494, -0.039> <0.310, 0.502, -0.032> 
		<0.313, 0.470, -0.046> <0.313, 0.480, -0.046> <0.313, 0.495, -0.040> <0.313, 0.502, -0.033> 
		<0.317, 0.470, -0.049> <0.317, 0.481, -0.049> <0.317, 0.496, -0.043> <0.317, 0.504, -0.034> 
		<0.320, 0.470, -0.050> <0.320, 0.481, -0.050> <0.320, 0.497, -0.043> <0.320, 0.505, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.320, 0.505, 0.035> <0.320, 0.497, 0.043> <0.320, 0.481, 0.050> <0.320, 0.470, 0.050> 
		<0.324, 0.506, 0.037> <0.324, 0.498, 0.045> <0.325, 0.481, 0.052> <0.325, 0.470, 0.052> 
		<0.330, 0.508, 0.038> <0.330, 0.499, 0.047> <0.330, 0.482, 0.054> <0.330, 0.470, 0.054> 
		<0.335, 0.509, 0.039> <0.335, 0.500, 0.048> <0.335, 0.482, 0.055> <0.335, 0.470, 0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.320, 0.470, 0.050> <0.320, 0.458, 0.050> <0.320, 0.443, 0.043> <0.320, 0.434, 0.035> 
		<0.325, 0.470, 0.052> <0.325, 0.458, 0.052> <0.325, 0.441, 0.045> <0.325, 0.433, 0.037> 
		<0.330, 0.470, 0.054> <0.331, 0.457, 0.054> <0.331, 0.440, 0.047> <0.331, 0.432, 0.038> 
		<0.335, 0.470, 0.055> <0.335, 0.457, 0.055> <0.335, 0.440, 0.048> <0.335, 0.431, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.320, 0.434, 0.035> <0.320, 0.426, 0.027> <0.320, 0.420, 0.011> <0.320, 0.420, 0.000> 
		<0.325, 0.433, 0.037> <0.325, 0.425, 0.028> <0.325, 0.418, 0.011> <0.325, 0.418, 0.000> 
		<0.331, 0.432, 0.038> <0.331, 0.423, 0.029> <0.331, 0.416, 0.013> <0.331, 0.416, 0.000> 
		<0.335, 0.431, 0.039> <0.335, 0.422, 0.030> <0.335, 0.415, 0.013> <0.335, 0.415, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.320, 0.420, 0.000> <0.320, 0.420, -0.011> <0.320, 0.426, -0.027> <0.320, 0.434, -0.035> 
		<0.325, 0.418, 0.000> <0.325, 0.418, -0.011> <0.325, 0.425, -0.028> <0.325, 0.433, -0.037> 
		<0.331, 0.416, 0.000> <0.331, 0.416, -0.013> <0.331, 0.423, -0.029> <0.331, 0.432, -0.038> 
		<0.335, 0.415, 0.000> <0.335, 0.415, -0.013> <0.335, 0.422, -0.030> <0.335, 0.431, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.320, 0.434, -0.035> <0.320, 0.443, -0.043> <0.320, 0.458, -0.050> <0.320, 0.470, -0.050> 
		<0.325, 0.433, -0.037> <0.325, 0.441, -0.045> <0.325, 0.458, -0.052> <0.325, 0.470, -0.052> 
		<0.331, 0.432, -0.038> <0.331, 0.440, -0.047> <0.331, 0.457, -0.054> <0.330, 0.470, -0.054> 
		<0.335, 0.431, -0.039> <0.335, 0.440, -0.048> <0.335, 0.457, -0.055> <0.335, 0.470, -0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.320, 0.470, -0.050> <0.320, 0.481, -0.050> <0.320, 0.497, -0.043> <0.320, 0.505, -0.035> 
		<0.325, 0.470, -0.052> <0.325, 0.481, -0.052> <0.324, 0.498, -0.045> <0.324, 0.506, -0.037> 
		<0.330, 0.470, -0.054> <0.330, 0.482, -0.054> <0.330, 0.499, -0.047> <0.330, 0.508, -0.038> 
		<0.335, 0.470, -0.055> <0.335, 0.482, -0.055> <0.335, 0.500, -0.048> <0.335, 0.509, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.335, 0.509, 0.039> <0.335, 0.500, 0.048> <0.335, 0.482, 0.055> <0.335, 0.470, 0.055> 
		<0.347, 0.510, 0.040> <0.347, 0.501, 0.049> <0.347, 0.482, 0.057> <0.347, 0.470, 0.057> 
		<0.363, 0.512, 0.042> <0.363, 0.503, 0.052> <0.363, 0.484, 0.060> <0.363, 0.470, 0.060> 
		<0.375, 0.512, 0.042> <0.375, 0.503, 0.052> <0.375, 0.484, 0.060> <0.375, 0.470, 0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.335, 0.470, 0.055> <0.335, 0.457, 0.055> <0.335, 0.440, 0.048> <0.335, 0.431, 0.039> 
		<0.347, 0.470, 0.057> <0.347, 0.457, 0.057> <0.347, 0.438, 0.049> <0.347, 0.429, 0.040> 
		<0.363, 0.470, 0.060> <0.363, 0.456, 0.060> <0.363, 0.437, 0.052> <0.363, 0.427, 0.042> 
		<0.375, 0.470, 0.060> <0.375, 0.456, 0.060> <0.375, 0.437, 0.052> <0.375, 0.428, 0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.335, 0.431, 0.039> <0.335, 0.422, 0.030> <0.335, 0.415, 0.013> <0.335, 0.415, 0.000> 
		<0.347, 0.429, 0.040> <0.347, 0.421, 0.031> <0.347, 0.413, 0.013> <0.347, 0.413, 0.000> 
		<0.363, 0.427, 0.042> <0.363, 0.418, 0.033> <0.363, 0.410, 0.014> <0.363, 0.410, 0.000> 
		<0.375, 0.428, 0.042> <0.375, 0.418, 0.033> <0.375, 0.410, 0.014> <0.375, 0.410, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.335, 0.415, 0.000> <0.335, 0.415, -0.013> <0.335, 0.422, -0.030> <0.335, 0.431, -0.039> 
		<0.347, 0.413, 0.000> <0.347, 0.413, -0.013> <0.347, 0.421, -0.031> <0.347, 0.429, -0.040> 
		<0.363, 0.410, 0.000> <0.363, 0.410, -0.014> <0.363, 0.418, -0.033> <0.363, 0.427, -0.042> 
		<0.375, 0.410, 0.000> <0.375, 0.410, -0.014> <0.375, 0.418, -0.033> <0.375, 0.428, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.335, 0.431, -0.039> <0.335, 0.440, -0.048> <0.335, 0.457, -0.055> <0.335, 0.470, -0.055> 
		<0.347, 0.429, -0.040> <0.347, 0.438, -0.049> <0.347, 0.457, -0.057> <0.347, 0.470, -0.057> 
		<0.363, 0.427, -0.042> <0.363, 0.437, -0.052> <0.363, 0.456, -0.060> <0.363, 0.470, -0.060> 
		<0.375, 0.428, -0.042> <0.375, 0.437, -0.052> <0.375, 0.456, -0.060> <0.375, 0.470, -0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.335, 0.470, -0.055> <0.335, 0.482, -0.055> <0.335, 0.500, -0.048> <0.335, 0.509, -0.039> 
		<0.347, 0.470, -0.057> <0.347, 0.482, -0.057> <0.347, 0.501, -0.049> <0.347, 0.510, -0.040> 
		<0.363, 0.470, -0.060> <0.363, 0.484, -0.060> <0.363, 0.503, -0.052> <0.363, 0.512, -0.042> 
		<0.375, 0.470, -0.060> <0.375, 0.484, -0.060> <0.375, 0.503, -0.052> <0.375, 0.512, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.375, 0.512, 0.042> <0.375, 0.503, 0.052> <0.375, 0.484, 0.060> <0.375, 0.470, 0.060> 
		<0.387, 0.512, 0.042> <0.387, 0.503, 0.052> <0.387, 0.484, 0.060> <0.387, 0.470, 0.060> 
		<0.403, 0.510, 0.040> <0.403, 0.502, 0.049> <0.403, 0.483, 0.057> <0.403, 0.470, 0.057> 
		<0.415, 0.509, 0.039> <0.415, 0.500, 0.048> <0.415, 0.483, 0.055> <0.415, 0.470, 0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.375, 0.470, 0.060> <0.375, 0.456, 0.060> <0.375, 0.437, 0.052> <0.375, 0.428, 0.042> 
		<0.387, 0.470, 0.060> <0.387, 0.456, 0.060> <0.387, 0.437, 0.052> <0.387, 0.428, 0.042> 
		<0.403, 0.470, 0.057> <0.403, 0.457, 0.057> <0.403, 0.439, 0.049> <0.403, 0.430, 0.040> 
		<0.415, 0.470, 0.055> <0.415, 0.457, 0.055> <0.415, 0.440, 0.048> <0.415, 0.431, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.375, 0.428, 0.042> <0.375, 0.418, 0.033> <0.375, 0.410, 0.014> <0.375, 0.410, 0.000> 
		<0.387, 0.428, 0.042> <0.387, 0.418, 0.033> <0.387, 0.410, 0.014> <0.387, 0.410, 0.000> 
		<0.403, 0.430, 0.040> <0.403, 0.421, 0.031> <0.403, 0.413, 0.013> <0.403, 0.413, 0.000> 
		<0.415, 0.431, 0.039> <0.415, 0.422, 0.030> <0.415, 0.415, 0.013> <0.415, 0.415, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.375, 0.410, 0.000> <0.375, 0.410, -0.014> <0.375, 0.418, -0.033> <0.375, 0.428, -0.042> 
		<0.387, 0.410, 0.000> <0.387, 0.410, -0.014> <0.387, 0.418, -0.033> <0.387, 0.428, -0.042> 
		<0.403, 0.413, 0.000> <0.403, 0.413, -0.013> <0.403, 0.421, -0.031> <0.403, 0.430, -0.040> 
		<0.415, 0.415, 0.000> <0.415, 0.415, -0.013> <0.415, 0.422, -0.030> <0.415, 0.431, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.375, 0.428, -0.042> <0.375, 0.437, -0.052> <0.375, 0.456, -0.060> <0.375, 0.470, -0.060> 
		<0.387, 0.428, -0.042> <0.387, 0.437, -0.052> <0.387, 0.456, -0.060> <0.387, 0.470, -0.060> 
		<0.403, 0.430, -0.040> <0.403, 0.439, -0.049> <0.403, 0.457, -0.057> <0.403, 0.470, -0.057> 
		<0.415, 0.431, -0.039> <0.415, 0.440, -0.048> <0.415, 0.457, -0.055> <0.415, 0.470, -0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.375, 0.470, -0.060> <0.375, 0.484, -0.060> <0.375, 0.503, -0.052> <0.375, 0.512, -0.042> 
		<0.387, 0.470, -0.060> <0.387, 0.484, -0.060> <0.387, 0.503, -0.052> <0.387, 0.512, -0.042> 
		<0.403, 0.470, -0.057> <0.403, 0.483, -0.057> <0.403, 0.502, -0.049> <0.403, 0.510, -0.040> 
		<0.415, 0.470, -0.055> <0.415, 0.483, -0.055> <0.415, 0.500, -0.048> <0.415, 0.509, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.415, 0.509, 0.039> <0.415, 0.500, 0.048> <0.415, 0.483, 0.055> <0.415, 0.470, 0.055> 
		<0.420, 0.508, 0.038> <0.420, 0.499, 0.047> <0.420, 0.483, 0.054> <0.420, 0.470, 0.054> 
		<0.426, 0.507, 0.037> <0.426, 0.499, 0.045> <0.426, 0.482, 0.052> <0.426, 0.470, 0.052> 
		<0.430, 0.505, 0.035> <0.430, 0.497, 0.043> <0.430, 0.482, 0.050> <0.430, 0.470, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.415, 0.470, 0.055> <0.415, 0.457, 0.055> <0.415, 0.440, 0.048> <0.415, 0.431, 0.039> 
		<0.420, 0.470, 0.054> <0.420, 0.457, 0.054> <0.420, 0.441, 0.047> <0.420, 0.432, 0.038> 
		<0.426, 0.470, 0.052> <0.426, 0.459, 0.052> <0.426, 0.442, 0.045> <0.426, 0.433, 0.037> 
		<0.430, 0.470, 0.050> <0.430, 0.459, 0.050> <0.430, 0.443, 0.043> <0.430, 0.435, 0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.415, 0.431, 0.039> <0.415, 0.422, 0.030> <0.415, 0.415, 0.013> <0.415, 0.415, 0.000> 
		<0.420, 0.432, 0.038> <0.420, 0.423, 0.029> <0.420, 0.416, 0.013> <0.420, 0.416, 0.000> 
		<0.426, 0.433, 0.037> <0.426, 0.425, 0.028> <0.426, 0.418, 0.011> <0.426, 0.418, 0.000> 
		<0.430, 0.435, 0.035> <0.430, 0.427, 0.027> <0.430, 0.420, 0.011> <0.430, 0.420, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.415, 0.415, 0.000> <0.415, 0.415, -0.013> <0.415, 0.422, -0.030> <0.415, 0.431, -0.039> 
		<0.420, 0.416, 0.000> <0.420, 0.416, -0.013> <0.420, 0.423, -0.029> <0.420, 0.432, -0.038> 
		<0.426, 0.418, 0.000> <0.426, 0.418, -0.011> <0.426, 0.425, -0.028> <0.426, 0.433, -0.037> 
		<0.430, 0.420, 0.000> <0.430, 0.420, -0.011> <0.430, 0.427, -0.027> <0.430, 0.435, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.415, 0.431, -0.039> <0.415, 0.440, -0.048> <0.415, 0.457, -0.055> <0.415, 0.470, -0.055> 
		<0.420, 0.432, -0.038> <0.420, 0.441, -0.047> <0.420, 0.457, -0.054> <0.420, 0.470, -0.054> 
		<0.426, 0.433, -0.037> <0.426, 0.442, -0.045> <0.426, 0.459, -0.052> <0.426, 0.470, -0.052> 
		<0.430, 0.435, -0.035> <0.430, 0.443, -0.043> <0.430, 0.459, -0.050> <0.430, 0.470, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.415, 0.470, -0.055> <0.415, 0.483, -0.055> <0.415, 0.500, -0.048> <0.415, 0.509, -0.039> 
		<0.420, 0.470, -0.054> <0.420, 0.483, -0.054> <0.420, 0.499, -0.047> <0.420, 0.508, -0.038> 
		<0.426, 0.470, -0.052> <0.426, 0.482, -0.052> <0.426, 0.499, -0.045> <0.426, 0.507, -0.037> 
		<0.430, 0.470, -0.050> <0.430, 0.482, -0.050> <0.430, 0.497, -0.043> <0.430, 0.505, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.430, 0.505, 0.035> <0.430, 0.497, 0.043> <0.430, 0.482, 0.050> <0.430, 0.470, 0.050> 
		<0.433, 0.505, 0.034> <0.433, 0.496, 0.043> <0.433, 0.482, 0.049> <0.433, 0.470, 0.049> 
		<0.437, 0.503, 0.033> <0.437, 0.496, 0.040> <0.437, 0.480, 0.047> <0.437, 0.470, 0.047> 
		<0.440, 0.502, 0.032> <0.440, 0.495, 0.039> <0.440, 0.480, 0.045> <0.440, 0.470, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.430, 0.470, 0.050> <0.430, 0.459, 0.050> <0.430, 0.443, 0.043> <0.430, 0.435, 0.035> 
		<0.433, 0.470, 0.049> <0.433, 0.459, 0.049> <0.433, 0.444, 0.043> <0.433, 0.436, 0.034> 
		<0.437, 0.470, 0.047> <0.437, 0.460, 0.047> <0.437, 0.444, 0.040> <0.437, 0.437, 0.033> 
		<0.440, 0.470, 0.045> <0.440, 0.460, 0.045> <0.440, 0.446, 0.039> <0.440, 0.438, 0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.430, 0.435, 0.035> <0.430, 0.427, 0.027> <0.430, 0.420, 0.011> <0.430, 0.420, 0.000> 
		<0.433, 0.436, 0.034> <0.433, 0.428, 0.026> <0.433, 0.421, 0.011> <0.433, 0.421, 0.000> 
		<0.437, 0.437, 0.033> <0.437, 0.430, 0.026> <0.437, 0.423, 0.010> <0.437, 0.423, 0.000> 
		<0.440, 0.438, 0.032> <0.440, 0.431, 0.025> <0.440, 0.425, 0.010> <0.440, 0.425, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.430, 0.420, 0.000> <0.430, 0.420, -0.011> <0.430, 0.427, -0.027> <0.430, 0.435, -0.035> 
		<0.433, 0.421, 0.000> <0.433, 0.421, -0.011> <0.433, 0.428, -0.026> <0.433, 0.436, -0.034> 
		<0.437, 0.423, 0.000> <0.437, 0.423, -0.010> <0.437, 0.430, -0.026> <0.437, 0.437, -0.033> 
		<0.440, 0.425, 0.000> <0.440, 0.425, -0.010> <0.440, 0.431, -0.025> <0.440, 0.438, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.430, 0.435, -0.035> <0.430, 0.443, -0.043> <0.430, 0.459, -0.050> <0.430, 0.470, -0.050> 
		<0.433, 0.436, -0.034> <0.433, 0.444, -0.043> <0.433, 0.459, -0.049> <0.433, 0.470, -0.049> 
		<0.437, 0.437, -0.033> <0.437, 0.444, -0.040> <0.437, 0.460, -0.047> <0.437, 0.470, -0.047> 
		<0.440, 0.438, -0.032> <0.440, 0.446, -0.039> <0.440, 0.460, -0.045> <0.440, 0.470, -0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.430, 0.470, -0.050> <0.430, 0.482, -0.050> <0.430, 0.497, -0.043> <0.430, 0.505, -0.035> 
		<0.433, 0.470, -0.049> <0.433, 0.482, -0.049> <0.433, 0.496, -0.043> <0.433, 0.505, -0.034> 
		<0.437, 0.470, -0.047> <0.437, 0.480, -0.047> <0.437, 0.496, -0.040> <0.437, 0.503, -0.033> 
		<0.440, 0.470, -0.045> <0.440, 0.480, -0.045> <0.440, 0.495, -0.039> <0.440, 0.502, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.440, 0.502, 0.032> <0.440, 0.495, 0.039> <0.440, 0.480, 0.045> <0.440, 0.470, 0.045> 
		<0.442, 0.501, 0.031> <0.442, 0.494, 0.038> <0.442, 0.480, 0.044> <0.442, 0.470, 0.044> 
		<0.443, 0.499, 0.029> <0.443, 0.493, 0.035> <0.443, 0.479, 0.041> <0.443, 0.470, 0.041> 
		<0.445, 0.498, 0.028> <0.445, 0.492, 0.035> <0.445, 0.479, 0.040> <0.445, 0.470, 0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.440, 0.470, 0.045> <0.440, 0.460, 0.045> <0.440, 0.446, 0.039> <0.440, 0.438, 0.032> 
		<0.442, 0.470, 0.044> <0.442, 0.460, 0.044> <0.442, 0.446, 0.038> <0.442, 0.439, 0.031> 
		<0.443, 0.470, 0.041> <0.443, 0.461, 0.041> <0.443, 0.448, 0.035> <0.443, 0.441, 0.029> 
		<0.445, 0.470, 0.040> <0.445, 0.461, 0.040> <0.445, 0.448, 0.035> <0.445, 0.442, 0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.440, 0.438, 0.032> <0.440, 0.431, 0.025> <0.440, 0.425, 0.010> <0.440, 0.425, 0.000> 
		<0.442, 0.439, 0.031> <0.442, 0.432, 0.024> <0.442, 0.426, 0.010> <0.442, 0.426, 0.000> 
		<0.443, 0.441, 0.029> <0.443, 0.435, 0.022> <0.443, 0.429, 0.009> <0.443, 0.429, 0.000> 
		<0.445, 0.442, 0.028> <0.445, 0.435, 0.022> <0.445, 0.430, 0.009> <0.445, 0.430, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.440, 0.425, 0.000> <0.440, 0.425, -0.010> <0.440, 0.431, -0.025> <0.440, 0.438, -0.032> 
		<0.442, 0.426, 0.000> <0.442, 0.426, -0.010> <0.442, 0.432, -0.024> <0.442, 0.439, -0.031> 
		<0.443, 0.429, 0.000> <0.443, 0.429, -0.009> <0.443, 0.435, -0.022> <0.443, 0.441, -0.029> 
		<0.445, 0.430, 0.000> <0.445, 0.430, -0.009> <0.445, 0.435, -0.022> <0.445, 0.442, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.440, 0.438, -0.032> <0.440, 0.446, -0.039> <0.440, 0.460, -0.045> <0.440, 0.470, -0.045> 
		<0.442, 0.439, -0.031> <0.442, 0.446, -0.038> <0.442, 0.460, -0.044> <0.442, 0.470, -0.044> 
		<0.443, 0.441, -0.029> <0.443, 0.448, -0.035> <0.443, 0.461, -0.041> <0.443, 0.470, -0.041> 
		<0.445, 0.442, -0.028> <0.445, 0.448, -0.035> <0.445, 0.461, -0.040> <0.445, 0.470, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.440, 0.470, -0.045> <0.440, 0.480, -0.045> <0.440, 0.495, -0.039> <0.440, 0.502, -0.032> 
		<0.442, 0.470, -0.044> <0.442, 0.480, -0.044> <0.442, 0.494, -0.038> <0.442, 0.501, -0.031> 
		<0.443, 0.470, -0.041> <0.443, 0.479, -0.041> <0.443, 0.493, -0.035> <0.443, 0.499, -0.029> 
		<0.445, 0.470, -0.040> <0.445, 0.479, -0.040> <0.445, 0.492, -0.035> <0.445, 0.498, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.445, 0.498, 0.028> <0.445, 0.492, 0.035> <0.445, 0.479, 0.040> <0.445, 0.470, 0.040> 
		<0.446, 0.498, 0.028> <0.446, 0.491, 0.034> <0.446, 0.479, 0.039> <0.446, 0.470, 0.039> 
		<0.449, 0.498, 0.028> <0.449, 0.492, 0.034> <0.449, 0.479, 0.040> <0.449, 0.470, 0.040> 
		<0.450, 0.498, 0.028> <0.450, 0.492, 0.035> <0.450, 0.479, 0.040> <0.450, 0.470, 0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.445, 0.470, 0.040> <0.445, 0.461, 0.040> <0.445, 0.448, 0.035> <0.445, 0.442, 0.028> 
		<0.446, 0.470, 0.039> <0.447, 0.461, 0.039> <0.447, 0.449, 0.034> <0.447, 0.442, 0.028> 
		<0.449, 0.470, 0.040> <0.449, 0.461, 0.040> <0.449, 0.449, 0.034> <0.449, 0.442, 0.028> 
		<0.450, 0.470, 0.040> <0.450, 0.461, 0.040> <0.450, 0.448, 0.035> <0.450, 0.442, 0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.445, 0.442, 0.028> <0.445, 0.435, 0.022> <0.445, 0.430, 0.009> <0.445, 0.430, 0.000> 
		<0.447, 0.442, 0.028> <0.447, 0.436, 0.021> <0.447, 0.431, 0.009> <0.447, 0.431, 0.000> 
		<0.449, 0.442, 0.028> <0.449, 0.436, 0.021> <0.449, 0.431, 0.009> <0.449, 0.431, 0.000> 
		<0.450, 0.442, 0.028> <0.450, 0.435, 0.022> <0.450, 0.430, 0.009> <0.450, 0.430, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.445, 0.430, 0.000> <0.445, 0.430, -0.009> <0.445, 0.435, -0.022> <0.445, 0.442, -0.028> 
		<0.447, 0.431, 0.000> <0.447, 0.431, -0.009> <0.447, 0.436, -0.021> <0.447, 0.442, -0.028> 
		<0.449, 0.431, 0.000> <0.449, 0.431, -0.009> <0.449, 0.436, -0.021> <0.449, 0.442, -0.028> 
		<0.450, 0.430, 0.000> <0.450, 0.430, -0.009> <0.450, 0.435, -0.022> <0.450, 0.442, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.445, 0.442, -0.028> <0.445, 0.448, -0.035> <0.445, 0.461, -0.040> <0.445, 0.470, -0.040> 
		<0.447, 0.442, -0.028> <0.447, 0.449, -0.034> <0.447, 0.461, -0.039> <0.446, 0.470, -0.039> 
		<0.449, 0.442, -0.028> <0.449, 0.449, -0.034> <0.449, 0.461, -0.040> <0.449, 0.470, -0.040> 
		<0.450, 0.442, -0.028> <0.450, 0.448, -0.035> <0.450, 0.461, -0.040> <0.450, 0.470, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.445, 0.470, -0.040> <0.445, 0.479, -0.040> <0.445, 0.492, -0.035> <0.445, 0.498, -0.028> 
		<0.446, 0.470, -0.039> <0.446, 0.479, -0.039> <0.446, 0.491, -0.034> <0.446, 0.498, -0.028> 
		<0.449, 0.470, -0.040> <0.449, 0.479, -0.040> <0.449, 0.492, -0.034> <0.449, 0.498, -0.028> 
		<0.450, 0.470, -0.040> <0.450, 0.479, -0.040> <0.450, 0.492, -0.035> <0.450, 0.498, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.450, 0.498, 0.028> <0.450, 0.492, 0.035> <0.450, 0.479, 0.040> <0.450, 0.470, 0.040> 
		<0.453, 0.499, 0.029> <0.453, 0.493, 0.036> <0.453, 0.479, 0.041> <0.453, 0.470, 0.041> 
		<0.457, 0.501, 0.031> <0.457, 0.494, 0.038> <0.457, 0.481, 0.044> <0.457, 0.470, 0.044> 
		<0.460, 0.502, 0.032> <0.460, 0.495, 0.039> <0.460, 0.481, 0.045> <0.460, 0.470, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.450, 0.470, 0.040> <0.450, 0.461, 0.040> <0.450, 0.448, 0.035> <0.450, 0.442, 0.028> 
		<0.453, 0.470, 0.041> <0.453, 0.461, 0.041> <0.453, 0.448, 0.036> <0.453, 0.441, 0.029> 
		<0.457, 0.470, 0.044> <0.457, 0.460, 0.044> <0.457, 0.447, 0.038> <0.457, 0.439, 0.031> 
		<0.460, 0.470, 0.045> <0.460, 0.460, 0.045> <0.460, 0.446, 0.039> <0.460, 0.438, 0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.450, 0.442, 0.028> <0.450, 0.435, 0.022> <0.450, 0.430, 0.009> <0.450, 0.430, 0.000> 
		<0.453, 0.441, 0.029> <0.453, 0.435, 0.023> <0.453, 0.429, 0.009> <0.453, 0.429, 0.000> 
		<0.457, 0.439, 0.031> <0.457, 0.432, 0.024> <0.457, 0.426, 0.010> <0.457, 0.426, 0.000> 
		<0.460, 0.438, 0.032> <0.460, 0.431, 0.025> <0.460, 0.425, 0.010> <0.460, 0.425, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.450, 0.430, 0.000> <0.450, 0.430, -0.009> <0.450, 0.435, -0.022> <0.450, 0.442, -0.028> 
		<0.453, 0.429, 0.000> <0.453, 0.429, -0.009> <0.453, 0.435, -0.023> <0.453, 0.441, -0.029> 
		<0.457, 0.426, 0.000> <0.457, 0.426, -0.010> <0.457, 0.432, -0.024> <0.457, 0.439, -0.031> 
		<0.460, 0.425, 0.000> <0.460, 0.425, -0.010> <0.460, 0.431, -0.025> <0.460, 0.438, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.450, 0.442, -0.028> <0.450, 0.448, -0.035> <0.450, 0.461, -0.040> <0.450, 0.470, -0.040> 
		<0.453, 0.441, -0.029> <0.453, 0.448, -0.036> <0.453, 0.461, -0.041> <0.453, 0.470, -0.041> 
		<0.457, 0.439, -0.031> <0.457, 0.447, -0.038> <0.457, 0.460, -0.044> <0.457, 0.470, -0.044> 
		<0.460, 0.438, -0.032> <0.460, 0.446, -0.039> <0.460, 0.460, -0.045> <0.460, 0.470, -0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.450, 0.470, -0.040> <0.450, 0.479, -0.040> <0.450, 0.492, -0.035> <0.450, 0.498, -0.028> 
		<0.453, 0.470, -0.041> <0.453, 0.479, -0.041> <0.453, 0.493, -0.036> <0.453, 0.499, -0.029> 
		<0.457, 0.470, -0.044> <0.457, 0.481, -0.044> <0.457, 0.494, -0.038> <0.457, 0.501, -0.031> 
		<0.460, 0.470, -0.045> <0.460, 0.481, -0.045> <0.460, 0.495, -0.039> <0.460, 0.502, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.460, 0.502, 0.032> <0.460, 0.495, 0.039> <0.460, 0.481, 0.045> <0.460, 0.470, 0.045> 
		<0.464, 0.503, 0.033> <0.464, 0.496, 0.040> <0.465, 0.481, 0.047> <0.465, 0.470, 0.047> 
		<0.470, 0.505, 0.035> <0.470, 0.497, 0.043> <0.470, 0.482, 0.049> <0.470, 0.470, 0.049> 
		<0.475, 0.506, 0.035> <0.475, 0.497, 0.043> <0.475, 0.482, 0.050> <0.475, 0.470, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.460, 0.470, 0.045> <0.460, 0.460, 0.045> <0.460, 0.446, 0.039> <0.460, 0.438, 0.032> 
		<0.465, 0.470, 0.047> <0.465, 0.460, 0.047> <0.465, 0.444, 0.040> <0.465, 0.437, 0.033> 
		<0.470, 0.470, 0.049> <0.471, 0.459, 0.049> <0.471, 0.444, 0.043> <0.471, 0.436, 0.035> 
		<0.475, 0.470, 0.050> <0.475, 0.459, 0.050> <0.475, 0.443, 0.043> <0.475, 0.435, 0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.460, 0.438, 0.032> <0.460, 0.431, 0.025> <0.460, 0.425, 0.010> <0.460, 0.425, 0.000> 
		<0.465, 0.437, 0.033> <0.465, 0.430, 0.026> <0.465, 0.423, 0.010> <0.465, 0.423, 0.000> 
		<0.471, 0.436, 0.035> <0.471, 0.427, 0.027> <0.471, 0.421, 0.011> <0.471, 0.421, 0.000> 
		<0.475, 0.435, 0.035> <0.475, 0.427, 0.027> <0.475, 0.420, 0.011> <0.475, 0.420, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.460, 0.425, 0.000> <0.460, 0.425, -0.010> <0.460, 0.431, -0.025> <0.460, 0.438, -0.032> 
		<0.465, 0.423, 0.000> <0.465, 0.423, -0.010> <0.465, 0.430, -0.026> <0.465, 0.437, -0.033> 
		<0.471, 0.421, 0.000> <0.471, 0.421, -0.011> <0.471, 0.427, -0.027> <0.471, 0.436, -0.035> 
		<0.475, 0.420, 0.000> <0.475, 0.420, -0.011> <0.475, 0.427, -0.027> <0.475, 0.435, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.460, 0.438, -0.032> <0.460, 0.446, -0.039> <0.460, 0.460, -0.045> <0.460, 0.470, -0.045> 
		<0.465, 0.437, -0.033> <0.465, 0.444, -0.040> <0.465, 0.460, -0.047> <0.465, 0.470, -0.047> 
		<0.471, 0.436, -0.035> <0.471, 0.444, -0.043> <0.471, 0.459, -0.049> <0.470, 0.470, -0.049> 
		<0.475, 0.435, -0.035> <0.475, 0.443, -0.043> <0.475, 0.459, -0.050> <0.475, 0.470, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.460, 0.470, -0.045> <0.460, 0.481, -0.045> <0.460, 0.495, -0.039> <0.460, 0.502, -0.032> 
		<0.465, 0.470, -0.047> <0.465, 0.481, -0.047> <0.464, 0.496, -0.040> <0.464, 0.503, -0.033> 
		<0.470, 0.470, -0.049> <0.470, 0.482, -0.049> <0.470, 0.497, -0.043> <0.470, 0.505, -0.035> 
		<0.475, 0.470, -0.050> <0.475, 0.482, -0.050> <0.475, 0.497, -0.043> <0.475, 0.506, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.475, 0.506, 0.035> <0.475, 0.497, 0.043> <0.475, 0.482, 0.050> <0.475, 0.470, 0.050> 
		<0.485, 0.507, 0.037> <0.485, 0.499, 0.045> <0.486, 0.482, 0.052> <0.486, 0.470, 0.052> 
		<0.499, 0.509, 0.039> <0.499, 0.500, 0.048> <0.499, 0.483, 0.055> <0.500, 0.470, 0.055> 
		<0.510, 0.509, 0.039> <0.510, 0.500, 0.048> <0.510, 0.483, 0.055> <0.510, 0.470, 0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.475, 0.470, 0.050> <0.475, 0.459, 0.050> <0.475, 0.443, 0.043> <0.475, 0.435, 0.035> 
		<0.486, 0.470, 0.052> <0.486, 0.459, 0.052> <0.486, 0.442, 0.045> <0.486, 0.433, 0.037> 
		<0.500, 0.470, 0.055> <0.500, 0.458, 0.055> <0.500, 0.440, 0.048> <0.500, 0.431, 0.039> 
		<0.510, 0.470, 0.055> <0.510, 0.458, 0.055> <0.510, 0.440, 0.048> <0.510, 0.431, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.475, 0.435, 0.035> <0.475, 0.427, 0.027> <0.475, 0.420, 0.011> <0.475, 0.420, 0.000> 
		<0.486, 0.433, 0.037> <0.486, 0.425, 0.029> <0.486, 0.418, 0.011> <0.486, 0.418, 0.000> 
		<0.500, 0.431, 0.039> <0.500, 0.422, 0.030> <0.500, 0.415, 0.013> <0.500, 0.415, 0.000> 
		<0.510, 0.431, 0.039> <0.510, 0.423, 0.030> <0.510, 0.415, 0.013> <0.510, 0.415, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.475, 0.420, 0.000> <0.475, 0.420, -0.011> <0.475, 0.427, -0.027> <0.475, 0.435, -0.035> 
		<0.486, 0.418, 0.000> <0.486, 0.418, -0.011> <0.486, 0.425, -0.029> <0.486, 0.433, -0.037> 
		<0.500, 0.415, 0.000> <0.500, 0.415, -0.013> <0.500, 0.422, -0.030> <0.500, 0.431, -0.039> 
		<0.510, 0.415, 0.000> <0.510, 0.415, -0.013> <0.510, 0.423, -0.030> <0.510, 0.431, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.475, 0.435, -0.035> <0.475, 0.443, -0.043> <0.475, 0.459, -0.050> <0.475, 0.470, -0.050> 
		<0.486, 0.433, -0.037> <0.486, 0.442, -0.045> <0.486, 0.459, -0.052> <0.486, 0.470, -0.052> 
		<0.500, 0.431, -0.039> <0.500, 0.440, -0.048> <0.500, 0.458, -0.055> <0.500, 0.470, -0.055> 
		<0.510, 0.431, -0.039> <0.510, 0.440, -0.048> <0.510, 0.458, -0.055> <0.510, 0.470, -0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.475, 0.470, -0.050> <0.475, 0.482, -0.050> <0.475, 0.497, -0.043> <0.475, 0.506, -0.035> 
		<0.486, 0.470, -0.052> <0.486, 0.482, -0.052> <0.485, 0.499, -0.045> <0.485, 0.507, -0.037> 
		<0.500, 0.470, -0.055> <0.499, 0.483, -0.055> <0.499, 0.500, -0.048> <0.499, 0.509, -0.039> 
		<0.510, 0.470, -0.055> <0.510, 0.483, -0.055> <0.510, 0.500, -0.048> <0.510, 0.509, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.510, 0.509, 0.039> <0.510, 0.500, 0.048> <0.510, 0.483, 0.055> <0.510, 0.470, 0.055> 
		<0.524, 0.509, 0.039> <0.524, 0.500, 0.048> <0.524, 0.483, 0.055> <0.524, 0.470, 0.055> 
		<0.542, 0.507, 0.037> <0.542, 0.499, 0.045> <0.542, 0.482, 0.052> <0.542, 0.470, 0.052> 
		<0.555, 0.506, 0.035> <0.555, 0.498, 0.043> <0.555, 0.482, 0.050> <0.555, 0.470, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.510, 0.470, 0.055> <0.510, 0.458, 0.055> <0.510, 0.440, 0.048> <0.510, 0.431, 0.039> 
		<0.524, 0.470, 0.055> <0.524, 0.458, 0.055> <0.524, 0.440, 0.048> <0.524, 0.431, 0.039> 
		<0.542, 0.470, 0.052> <0.542, 0.459, 0.052> <0.542, 0.442, 0.045> <0.542, 0.433, 0.037> 
		<0.555, 0.470, 0.050> <0.555, 0.459, 0.050> <0.555, 0.443, 0.043> <0.555, 0.435, 0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.510, 0.431, 0.039> <0.510, 0.423, 0.030> <0.510, 0.415, 0.013> <0.510, 0.415, 0.000> 
		<0.524, 0.431, 0.039> <0.524, 0.423, 0.030> <0.524, 0.415, 0.013> <0.524, 0.415, 0.000> 
		<0.542, 0.433, 0.037> <0.542, 0.425, 0.029> <0.542, 0.418, 0.011> <0.542, 0.418, 0.000> 
		<0.555, 0.435, 0.035> <0.555, 0.427, 0.027> <0.555, 0.420, 0.011> <0.555, 0.420, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.510, 0.415, 0.000> <0.510, 0.415, -0.013> <0.510, 0.423, -0.030> <0.510, 0.431, -0.039> 
		<0.524, 0.415, 0.000> <0.524, 0.415, -0.013> <0.524, 0.423, -0.030> <0.524, 0.431, -0.039> 
		<0.542, 0.418, 0.000> <0.542, 0.418, -0.011> <0.542, 0.425, -0.029> <0.542, 0.433, -0.037> 
		<0.555, 0.420, 0.000> <0.555, 0.420, -0.011> <0.555, 0.427, -0.027> <0.555, 0.435, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.510, 0.431, -0.039> <0.510, 0.440, -0.048> <0.510, 0.458, -0.055> <0.510, 0.470, -0.055> 
		<0.524, 0.431, -0.039> <0.524, 0.440, -0.048> <0.524, 0.458, -0.055> <0.524, 0.470, -0.055> 
		<0.542, 0.433, -0.037> <0.542, 0.442, -0.045> <0.542, 0.459, -0.052> <0.542, 0.470, -0.052> 
		<0.555, 0.435, -0.035> <0.555, 0.443, -0.043> <0.555, 0.459, -0.050> <0.555, 0.470, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.510, 0.470, -0.055> <0.510, 0.483, -0.055> <0.510, 0.500, -0.048> <0.510, 0.509, -0.039> 
		<0.524, 0.470, -0.055> <0.524, 0.483, -0.055> <0.524, 0.500, -0.048> <0.524, 0.509, -0.039> 
		<0.542, 0.470, -0.052> <0.542, 0.482, -0.052> <0.542, 0.499, -0.045> <0.542, 0.507, -0.037> 
		<0.555, 0.470, -0.050> <0.555, 0.482, -0.050> <0.555, 0.498, -0.043> <0.555, 0.506, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.555, 0.506, 0.035> <0.555, 0.498, 0.043> <0.555, 0.482, 0.050> <0.555, 0.470, 0.050> 
		<0.560, 0.505, 0.035> <0.560, 0.497, 0.043> <0.560, 0.482, 0.049> <0.560, 0.470, 0.049> 
		<0.566, 0.504, 0.033> <0.566, 0.496, 0.040> <0.566, 0.481, 0.047> <0.566, 0.470, 0.047> 
		<0.570, 0.502, 0.032> <0.570, 0.495, 0.039> <0.570, 0.481, 0.045> <0.570, 0.470, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.555, 0.470, 0.050> <0.555, 0.459, 0.050> <0.555, 0.443, 0.043> <0.555, 0.435, 0.035> 
		<0.560, 0.470, 0.049> <0.560, 0.459, 0.049> <0.560, 0.444, 0.043> <0.560, 0.436, 0.035> 
		<0.566, 0.470, 0.047> <0.566, 0.460, 0.047> <0.566, 0.445, 0.040> <0.566, 0.437, 0.033> 
		<0.570, 0.470, 0.045> <0.570, 0.460, 0.045> <0.570, 0.446, 0.039> <0.570, 0.439, 0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.555, 0.435, 0.035> <0.555, 0.427, 0.027> <0.555, 0.420, 0.011> <0.555, 0.420, 0.000> 
		<0.560, 0.436, 0.035> <0.560, 0.428, 0.027> <0.560, 0.421, 0.011> <0.560, 0.421, 0.000> 
		<0.566, 0.437, 0.033> <0.566, 0.430, 0.026> <0.566, 0.424, 0.010> <0.566, 0.424, 0.000> 
		<0.570, 0.439, 0.032> <0.570, 0.431, 0.025> <0.570, 0.425, 0.010> <0.570, 0.425, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.555, 0.420, 0.000> <0.555, 0.420, -0.011> <0.555, 0.427, -0.027> <0.555, 0.435, -0.035> 
		<0.560, 0.421, 0.000> <0.560, 0.421, -0.011> <0.560, 0.428, -0.027> <0.560, 0.436, -0.035> 
		<0.566, 0.424, 0.000> <0.566, 0.424, -0.010> <0.566, 0.430, -0.026> <0.566, 0.437, -0.033> 
		<0.570, 0.425, 0.000> <0.570, 0.425, -0.010> <0.570, 0.431, -0.025> <0.570, 0.439, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.555, 0.435, -0.035> <0.555, 0.443, -0.043> <0.555, 0.459, -0.050> <0.555, 0.470, -0.050> 
		<0.560, 0.436, -0.035> <0.560, 0.444, -0.043> <0.560, 0.459, -0.049> <0.560, 0.470, -0.049> 
		<0.566, 0.437, -0.033> <0.566, 0.445, -0.040> <0.566, 0.460, -0.047> <0.566, 0.470, -0.047> 
		<0.570, 0.439, -0.032> <0.570, 0.446, -0.039> <0.570, 0.460, -0.045> <0.570, 0.470, -0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.555, 0.470, -0.050> <0.555, 0.482, -0.050> <0.555, 0.498, -0.043> <0.555, 0.506, -0.035> 
		<0.560, 0.470, -0.049> <0.560, 0.482, -0.049> <0.560, 0.497, -0.043> <0.560, 0.505, -0.035> 
		<0.566, 0.470, -0.047> <0.566, 0.481, -0.047> <0.566, 0.496, -0.040> <0.566, 0.504, -0.033> 
		<0.570, 0.470, -0.045> <0.570, 0.481, -0.045> <0.570, 0.495, -0.039> <0.570, 0.502, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.570, 0.502, 0.032> <0.570, 0.495, 0.039> <0.570, 0.481, 0.045> <0.570, 0.470, 0.045> 
		<0.573, 0.501, 0.031> <0.573, 0.494, 0.038> <0.573, 0.481, 0.044> <0.573, 0.471, 0.044> 
		<0.577, 0.500, 0.030> <0.577, 0.494, 0.036> <0.577, 0.480, 0.042> <0.577, 0.471, 0.042> 
		<0.580, 0.499, 0.028> <0.580, 0.492, 0.035> <0.580, 0.480, 0.040> <0.580, 0.471, 0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.570, 0.470, 0.045> <0.570, 0.460, 0.045> <0.570, 0.446, 0.039> <0.570, 0.439, 0.032> 
		<0.573, 0.471, 0.044> <0.573, 0.460, 0.044> <0.573, 0.447, 0.038> <0.573, 0.440, 0.031> 
		<0.577, 0.471, 0.042> <0.577, 0.461, 0.042> <0.577, 0.447, 0.036> <0.577, 0.441, 0.030> 
		<0.580, 0.471, 0.040> <0.580, 0.461, 0.040> <0.580, 0.449, 0.035> <0.580, 0.442, 0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.570, 0.439, 0.032> <0.570, 0.431, 0.025> <0.570, 0.425, 0.010> <0.570, 0.425, 0.000> 
		<0.573, 0.440, 0.031> <0.573, 0.432, 0.024> <0.573, 0.427, 0.010> <0.573, 0.427, 0.000> 
		<0.577, 0.441, 0.030> <0.577, 0.434, 0.023> <0.577, 0.429, 0.009> <0.577, 0.429, 0.000> 
		<0.580, 0.442, 0.028> <0.580, 0.436, 0.022> <0.580, 0.431, 0.009> <0.580, 0.431, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.570, 0.425, 0.000> <0.570, 0.425, -0.010> <0.570, 0.431, -0.025> <0.570, 0.439, -0.032> 
		<0.573, 0.427, 0.000> <0.573, 0.427, -0.010> <0.573, 0.432, -0.024> <0.573, 0.440, -0.031> 
		<0.577, 0.429, 0.000> <0.577, 0.429, -0.009> <0.577, 0.434, -0.023> <0.577, 0.441, -0.030> 
		<0.580, 0.431, 0.000> <0.580, 0.431, -0.009> <0.580, 0.436, -0.022> <0.580, 0.442, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.570, 0.439, -0.032> <0.570, 0.446, -0.039> <0.570, 0.460, -0.045> <0.570, 0.470, -0.045> 
		<0.573, 0.440, -0.031> <0.573, 0.447, -0.038> <0.573, 0.460, -0.044> <0.573, 0.471, -0.044> 
		<0.577, 0.441, -0.030> <0.577, 0.447, -0.036> <0.577, 0.461, -0.042> <0.577, 0.471, -0.042> 
		<0.580, 0.442, -0.028> <0.580, 0.449, -0.035> <0.580, 0.461, -0.040> <0.580, 0.471, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.570, 0.470, -0.045> <0.570, 0.481, -0.045> <0.570, 0.495, -0.039> <0.570, 0.502, -0.032> 
		<0.573, 0.471, -0.044> <0.573, 0.481, -0.044> <0.573, 0.494, -0.038> <0.573, 0.501, -0.031> 
		<0.577, 0.471, -0.042> <0.577, 0.480, -0.042> <0.577, 0.494, -0.036> <0.577, 0.500, -0.030> 
		<0.580, 0.471, -0.040> <0.580, 0.480, -0.040> <0.580, 0.492, -0.035> <0.580, 0.499, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.580, 0.499, 0.028> <0.580, 0.492, 0.035> <0.580, 0.480, 0.040> <0.580, 0.471, 0.040> 
		<0.582, 0.498, 0.027> <0.582, 0.491, 0.034> <0.582, 0.480, 0.039> <0.582, 0.471, 0.039> 
		<0.583, 0.496, 0.025> <0.583, 0.490, 0.031> <0.583, 0.479, 0.036> <0.583, 0.471, 0.036> 
		<0.585, 0.495, 0.025> <0.585, 0.490, 0.030> <0.585, 0.479, 0.035> <0.585, 0.471, 0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.580, 0.471, 0.040> <0.580, 0.461, 0.040> <0.580, 0.449, 0.035> <0.580, 0.442, 0.028> 
		<0.582, 0.471, 0.039> <0.582, 0.461, 0.039> <0.582, 0.450, 0.034> <0.582, 0.443, 0.027> 
		<0.583, 0.471, 0.036> <0.583, 0.462, 0.036> <0.583, 0.451, 0.031> <0.583, 0.445, 0.025> 
		<0.585, 0.471, 0.035> <0.585, 0.462, 0.035> <0.585, 0.451, 0.030> <0.585, 0.446, 0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.580, 0.442, 0.028> <0.580, 0.436, 0.022> <0.580, 0.431, 0.009> <0.580, 0.431, 0.000> 
		<0.582, 0.443, 0.027> <0.582, 0.437, 0.021> <0.582, 0.432, 0.009> <0.582, 0.432, 0.000> 
		<0.583, 0.445, 0.025> <0.583, 0.439, 0.020> <0.583, 0.435, 0.008> <0.583, 0.435, 0.000> 
		<0.585, 0.446, 0.025> <0.585, 0.440, 0.019> <0.585, 0.436, 0.008> <0.585, 0.436, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.580, 0.431, 0.000> <0.580, 0.431, -0.009> <0.580, 0.436, -0.022> <0.580, 0.442, -0.028> 
		<0.582, 0.432, 0.000> <0.582, 0.432, -0.009> <0.582, 0.437, -0.021> <0.582, 0.443, -0.027> 
		<0.583, 0.435, 0.000> <0.583, 0.435, -0.008> <0.583, 0.439, -0.020> <0.583, 0.445, -0.025> 
		<0.585, 0.436, 0.000> <0.585, 0.436, -0.008> <0.585, 0.440, -0.019> <0.585, 0.446, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.580, 0.442, -0.028> <0.580, 0.449, -0.035> <0.580, 0.461, -0.040> <0.580, 0.471, -0.040> 
		<0.582, 0.443, -0.027> <0.582, 0.450, -0.034> <0.582, 0.461, -0.039> <0.582, 0.471, -0.039> 
		<0.583, 0.445, -0.025> <0.583, 0.451, -0.031> <0.583, 0.462, -0.036> <0.583, 0.471, -0.036> 
		<0.585, 0.446, -0.025> <0.585, 0.451, -0.030> <0.585, 0.462, -0.035> <0.585, 0.471, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.580, 0.471, -0.040> <0.580, 0.480, -0.040> <0.580, 0.492, -0.035> <0.580, 0.499, -0.028> 
		<0.582, 0.471, -0.039> <0.582, 0.480, -0.039> <0.582, 0.491, -0.034> <0.582, 0.498, -0.027> 
		<0.583, 0.471, -0.036> <0.583, 0.479, -0.036> <0.583, 0.490, -0.031> <0.583, 0.496, -0.025> 
		<0.585, 0.471, -0.035> <0.585, 0.479, -0.035> <0.585, 0.490, -0.030> <0.585, 0.495, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.585, 0.495, 0.025> <0.585, 0.490, 0.030> <0.585, 0.479, 0.035> <0.585, 0.471, 0.035> 
		<0.586, 0.495, 0.024> <0.586, 0.489, 0.030> <0.586, 0.479, 0.034> <0.586, 0.471, 0.034> 
		<0.589, 0.495, 0.024> <0.589, 0.489, 0.030> <0.589, 0.479, 0.035> <0.589, 0.471, 0.035> 
		<0.590, 0.495, 0.025> <0.590, 0.490, 0.030> <0.590, 0.479, 0.035> <0.590, 0.471, 0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.585, 0.471, 0.035> <0.585, 0.462, 0.035> <0.585, 0.451, 0.030> <0.585, 0.446, 0.025> 
		<0.586, 0.471, 0.034> <0.586, 0.463, 0.034> <0.587, 0.452, 0.030> <0.587, 0.446, 0.024> 
		<0.589, 0.471, 0.035> <0.589, 0.463, 0.035> <0.589, 0.452, 0.030> <0.589, 0.446, 0.024> 
		<0.590, 0.471, 0.035> <0.590, 0.463, 0.035> <0.590, 0.451, 0.030> <0.590, 0.446, 0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.585, 0.446, 0.025> <0.585, 0.440, 0.019> <0.585, 0.436, 0.008> <0.585, 0.436, 0.000> 
		<0.587, 0.446, 0.024> <0.587, 0.441, 0.019> <0.587, 0.436, 0.008> <0.587, 0.436, 0.000> 
		<0.589, 0.446, 0.024> <0.589, 0.440, 0.019> <0.589, 0.436, 0.008> <0.589, 0.436, 0.000> 
		<0.590, 0.446, 0.025> <0.590, 0.440, 0.019> <0.590, 0.436, 0.008> <0.590, 0.436, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.585, 0.436, 0.000> <0.585, 0.436, -0.008> <0.585, 0.440, -0.019> <0.585, 0.446, -0.025> 
		<0.587, 0.436, 0.000> <0.587, 0.436, -0.008> <0.587, 0.441, -0.019> <0.587, 0.446, -0.024> 
		<0.589, 0.436, 0.000> <0.589, 0.436, -0.008> <0.589, 0.440, -0.019> <0.589, 0.446, -0.024> 
		<0.590, 0.436, 0.000> <0.590, 0.436, -0.008> <0.590, 0.440, -0.019> <0.590, 0.446, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.585, 0.446, -0.025> <0.585, 0.451, -0.030> <0.585, 0.462, -0.035> <0.585, 0.471, -0.035> 
		<0.587, 0.446, -0.024> <0.587, 0.452, -0.030> <0.586, 0.463, -0.034> <0.586, 0.471, -0.034> 
		<0.589, 0.446, -0.024> <0.589, 0.452, -0.030> <0.589, 0.463, -0.035> <0.589, 0.471, -0.035> 
		<0.590, 0.446, -0.025> <0.590, 0.451, -0.030> <0.590, 0.463, -0.035> <0.590, 0.471, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.585, 0.471, -0.035> <0.585, 0.479, -0.035> <0.585, 0.490, -0.030> <0.585, 0.495, -0.025> 
		<0.586, 0.471, -0.034> <0.586, 0.479, -0.034> <0.586, 0.489, -0.030> <0.586, 0.495, -0.024> 
		<0.589, 0.471, -0.035> <0.589, 0.479, -0.035> <0.589, 0.489, -0.030> <0.589, 0.495, -0.024> 
		<0.590, 0.471, -0.035> <0.590, 0.479, -0.035> <0.590, 0.490, -0.030> <0.590, 0.495, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.590, 0.495, 0.025> <0.590, 0.490, 0.030> <0.590, 0.479, 0.035> <0.590, 0.471, 0.035> 
		<0.593, 0.496, 0.025> <0.593, 0.490, 0.031> <0.593, 0.479, 0.036> <0.593, 0.471, 0.036> 
		<0.597, 0.498, 0.027> <0.597, 0.491, 0.034> <0.597, 0.480, 0.039> <0.597, 0.471, 0.039> 
		<0.600, 0.499, 0.028> <0.600, 0.492, 0.035> <0.600, 0.480, 0.040> <0.600, 0.471, 0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.590, 0.471, 0.035> <0.590, 0.463, 0.035> <0.590, 0.451, 0.030> <0.590, 0.446, 0.025> 
		<0.593, 0.471, 0.036> <0.593, 0.463, 0.036> <0.593, 0.451, 0.031> <0.593, 0.445, 0.025> 
		<0.597, 0.471, 0.039> <0.597, 0.461, 0.039> <0.597, 0.450, 0.034> <0.597, 0.443, 0.027> 
		<0.600, 0.471, 0.040> <0.600, 0.461, 0.040> <0.600, 0.449, 0.035> <0.600, 0.442, 0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.590, 0.446, 0.025> <0.590, 0.440, 0.019> <0.590, 0.436, 0.008> <0.590, 0.436, 0.000> 
		<0.593, 0.445, 0.025> <0.593, 0.439, 0.020> <0.593, 0.434, 0.008> <0.593, 0.434, 0.000> 
		<0.597, 0.443, 0.027> <0.597, 0.437, 0.021> <0.597, 0.432, 0.009> <0.597, 0.432, 0.000> 
		<0.600, 0.442, 0.028> <0.600, 0.436, 0.022> <0.600, 0.431, 0.009> <0.600, 0.431, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.590, 0.436, 0.000> <0.590, 0.436, -0.008> <0.590, 0.440, -0.019> <0.590, 0.446, -0.025> 
		<0.593, 0.434, 0.000> <0.593, 0.434, -0.008> <0.593, 0.439, -0.020> <0.593, 0.445, -0.025> 
		<0.597, 0.432, 0.000> <0.597, 0.432, -0.009> <0.597, 0.437, -0.021> <0.597, 0.443, -0.027> 
		<0.600, 0.431, 0.000> <0.600, 0.431, -0.009> <0.600, 0.436, -0.022> <0.600, 0.442, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.590, 0.446, -0.025> <0.590, 0.451, -0.030> <0.590, 0.463, -0.035> <0.590, 0.471, -0.035> 
		<0.593, 0.445, -0.025> <0.593, 0.451, -0.031> <0.593, 0.463, -0.036> <0.593, 0.471, -0.036> 
		<0.597, 0.443, -0.027> <0.597, 0.450, -0.034> <0.597, 0.461, -0.039> <0.597, 0.471, -0.039> 
		<0.600, 0.442, -0.028> <0.600, 0.449, -0.035> <0.600, 0.461, -0.040> <0.600, 0.471, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.590, 0.471, -0.035> <0.590, 0.479, -0.035> <0.590, 0.490, -0.030> <0.590, 0.495, -0.025> 
		<0.593, 0.471, -0.036> <0.593, 0.479, -0.036> <0.593, 0.490, -0.031> <0.593, 0.496, -0.025> 
		<0.597, 0.471, -0.039> <0.597, 0.480, -0.039> <0.597, 0.491, -0.034> <0.597, 0.498, -0.027> 
		<0.600, 0.471, -0.040> <0.600, 0.480, -0.040> <0.600, 0.492, -0.035> <0.600, 0.499, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, 0.499, 0.028> <0.600, 0.492, 0.035> <0.600, 0.480, 0.040> <0.600, 0.471, 0.040> 
		<0.604, 0.500, 0.030> <0.604, 0.494, 0.036> <0.605, 0.480, 0.042> <0.605, 0.471, 0.042> 
		<0.610, 0.502, 0.031> <0.610, 0.495, 0.039> <0.610, 0.481, 0.044> <0.610, 0.471, 0.044> 
		<0.615, 0.502, 0.032> <0.615, 0.495, 0.039> <0.615, 0.481, 0.045> <0.615, 0.471, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, 0.471, 0.040> <0.600, 0.461, 0.040> <0.600, 0.449, 0.035> <0.600, 0.442, 0.028> 
		<0.605, 0.471, 0.042> <0.605, 0.461, 0.042> <0.605, 0.448, 0.036> <0.605, 0.441, 0.030> 
		<0.610, 0.471, 0.044> <0.610, 0.460, 0.044> <0.611, 0.447, 0.039> <0.611, 0.439, 0.031> 
		<0.615, 0.471, 0.045> <0.615, 0.460, 0.045> <0.615, 0.446, 0.039> <0.615, 0.439, 0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, 0.442, 0.028> <0.600, 0.436, 0.022> <0.600, 0.431, 0.009> <0.600, 0.431, 0.000> 
		<0.605, 0.441, 0.030> <0.605, 0.435, 0.023> <0.605, 0.429, 0.009> <0.605, 0.429, 0.000> 
		<0.611, 0.439, 0.031> <0.611, 0.432, 0.024> <0.611, 0.426, 0.010> <0.611, 0.426, 0.000> 
		<0.615, 0.439, 0.032> <0.615, 0.431, 0.025> <0.615, 0.426, 0.010> <0.615, 0.426, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, 0.431, 0.000> <0.600, 0.431, -0.009> <0.600, 0.436, -0.022> <0.600, 0.442, -0.028> 
		<0.605, 0.429, 0.000> <0.605, 0.429, -0.009> <0.605, 0.435, -0.023> <0.605, 0.441, -0.030> 
		<0.611, 0.426, 0.000> <0.611, 0.426, -0.010> <0.611, 0.432, -0.024> <0.611, 0.439, -0.031> 
		<0.615, 0.426, 0.000> <0.615, 0.426, -0.010> <0.615, 0.431, -0.025> <0.615, 0.439, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, 0.442, -0.028> <0.600, 0.449, -0.035> <0.600, 0.461, -0.040> <0.600, 0.471, -0.040> 
		<0.605, 0.441, -0.030> <0.605, 0.448, -0.036> <0.605, 0.461, -0.042> <0.605, 0.471, -0.042> 
		<0.611, 0.439, -0.031> <0.611, 0.447, -0.039> <0.610, 0.460, -0.044> <0.610, 0.471, -0.044> 
		<0.615, 0.439, -0.032> <0.615, 0.446, -0.039> <0.615, 0.460, -0.045> <0.615, 0.471, -0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.600, 0.471, -0.040> <0.600, 0.480, -0.040> <0.600, 0.492, -0.035> <0.600, 0.499, -0.028> 
		<0.605, 0.471, -0.042> <0.605, 0.480, -0.042> <0.604, 0.494, -0.036> <0.604, 0.500, -0.030> 
		<0.610, 0.471, -0.044> <0.610, 0.481, -0.044> <0.610, 0.495, -0.039> <0.610, 0.502, -0.031> 
		<0.615, 0.471, -0.045> <0.615, 0.481, -0.045> <0.615, 0.495, -0.039> <0.615, 0.502, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.615, 0.502, 0.032> <0.615, 0.495, 0.039> <0.615, 0.481, 0.045> <0.615, 0.471, 0.045> 
		<0.627, 0.504, 0.033> <0.627, 0.497, 0.041> <0.627, 0.481, 0.047> <0.627, 0.471, 0.047> 
		<0.643, 0.506, 0.035> <0.643, 0.498, 0.043> <0.643, 0.482, 0.050> <0.643, 0.471, 0.050> 
		<0.655, 0.506, 0.035> <0.655, 0.498, 0.043> <0.655, 0.482, 0.050> <0.655, 0.471, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.615, 0.471, 0.045> <0.615, 0.460, 0.045> <0.615, 0.446, 0.039> <0.615, 0.439, 0.032> 
		<0.627, 0.471, 0.047> <0.627, 0.460, 0.047> <0.627, 0.445, 0.041> <0.627, 0.437, 0.033> 
		<0.643, 0.471, 0.050> <0.643, 0.459, 0.050> <0.643, 0.443, 0.043> <0.643, 0.435, 0.035> 
		<0.655, 0.471, 0.050> <0.655, 0.459, 0.050> <0.655, 0.443, 0.043> <0.655, 0.435, 0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.615, 0.439, 0.032> <0.615, 0.431, 0.025> <0.615, 0.426, 0.010> <0.615, 0.426, 0.000> 
		<0.627, 0.437, 0.033> <0.627, 0.430, 0.026> <0.627, 0.423, 0.010> <0.627, 0.423, 0.000> 
		<0.643, 0.435, 0.035> <0.643, 0.427, 0.027> <0.643, 0.421, 0.011> <0.643, 0.421, 0.000> 
		<0.655, 0.435, 0.035> <0.655, 0.427, 0.027> <0.655, 0.421, 0.011> <0.655, 0.421, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.615, 0.426, 0.000> <0.615, 0.426, -0.010> <0.615, 0.431, -0.025> <0.615, 0.439, -0.032> 
		<0.627, 0.423, 0.000> <0.627, 0.423, -0.010> <0.627, 0.430, -0.026> <0.627, 0.437, -0.033> 
		<0.643, 0.421, 0.000> <0.643, 0.421, -0.011> <0.643, 0.427, -0.027> <0.643, 0.435, -0.035> 
		<0.655, 0.421, 0.000> <0.655, 0.421, -0.011> <0.655, 0.427, -0.027> <0.655, 0.435, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.615, 0.439, -0.032> <0.615, 0.446, -0.039> <0.615, 0.460, -0.045> <0.615, 0.471, -0.045> 
		<0.627, 0.437, -0.033> <0.627, 0.445, -0.041> <0.627, 0.460, -0.047> <0.627, 0.471, -0.047> 
		<0.643, 0.435, -0.035> <0.643, 0.443, -0.043> <0.643, 0.459, -0.050> <0.643, 0.471, -0.050> 
		<0.655, 0.435, -0.035> <0.655, 0.443, -0.043> <0.655, 0.459, -0.050> <0.655, 0.471, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.615, 0.471, -0.045> <0.615, 0.481, -0.045> <0.615, 0.495, -0.039> <0.615, 0.502, -0.032> 
		<0.627, 0.471, -0.047> <0.627, 0.481, -0.047> <0.627, 0.497, -0.041> <0.627, 0.504, -0.033> 
		<0.643, 0.471, -0.050> <0.643, 0.482, -0.050> <0.643, 0.498, -0.043> <0.643, 0.506, -0.035> 
		<0.655, 0.471, -0.050> <0.655, 0.482, -0.050> <0.655, 0.498, -0.043> <0.655, 0.506, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.655, 0.506, 0.035> <0.655, 0.498, 0.043> <0.655, 0.482, 0.050> <0.655, 0.471, 0.050> 
		<0.667, 0.506, 0.035> <0.667, 0.498, 0.043> <0.667, 0.482, 0.050> <0.667, 0.471, 0.050> 
		<0.683, 0.504, 0.033> <0.683, 0.497, 0.041> <0.683, 0.481, 0.047> <0.683, 0.471, 0.047> 
		<0.695, 0.503, 0.032> <0.695, 0.495, 0.039> <0.695, 0.481, 0.045> <0.695, 0.471, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.655, 0.471, 0.050> <0.655, 0.459, 0.050> <0.655, 0.443, 0.043> <0.655, 0.435, 0.035> 
		<0.667, 0.471, 0.050> <0.667, 0.459, 0.050> <0.667, 0.444, 0.043> <0.667, 0.435, 0.035> 
		<0.683, 0.471, 0.047> <0.683, 0.460, 0.047> <0.683, 0.445, 0.041> <0.683, 0.437, 0.033> 
		<0.695, 0.471, 0.045> <0.695, 0.461, 0.045> <0.695, 0.446, 0.039> <0.695, 0.439, 0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.655, 0.435, 0.035> <0.655, 0.427, 0.027> <0.655, 0.421, 0.011> <0.655, 0.421, 0.000> 
		<0.667, 0.435, 0.035> <0.667, 0.427, 0.027> <0.667, 0.421, 0.011> <0.667, 0.421, 0.000> 
		<0.683, 0.437, 0.033> <0.683, 0.430, 0.026> <0.683, 0.424, 0.010> <0.683, 0.424, 0.000> 
		<0.695, 0.439, 0.032> <0.695, 0.432, 0.025> <0.695, 0.426, 0.010> <0.695, 0.426, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.655, 0.421, 0.000> <0.655, 0.421, -0.011> <0.655, 0.427, -0.027> <0.655, 0.435, -0.035> 
		<0.667, 0.421, 0.000> <0.667, 0.421, -0.011> <0.667, 0.427, -0.027> <0.667, 0.435, -0.035> 
		<0.683, 0.424, 0.000> <0.683, 0.424, -0.010> <0.683, 0.430, -0.026> <0.683, 0.437, -0.033> 
		<0.695, 0.426, 0.000> <0.695, 0.426, -0.010> <0.695, 0.432, -0.025> <0.695, 0.439, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.655, 0.435, -0.035> <0.655, 0.443, -0.043> <0.655, 0.459, -0.050> <0.655, 0.471, -0.050> 
		<0.667, 0.435, -0.035> <0.667, 0.444, -0.043> <0.667, 0.459, -0.050> <0.667, 0.471, -0.050> 
		<0.683, 0.437, -0.033> <0.683, 0.445, -0.041> <0.683, 0.460, -0.047> <0.683, 0.471, -0.047> 
		<0.695, 0.439, -0.032> <0.695, 0.446, -0.039> <0.695, 0.461, -0.045> <0.695, 0.471, -0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.655, 0.471, -0.050> <0.655, 0.482, -0.050> <0.655, 0.498, -0.043> <0.655, 0.506, -0.035> 
		<0.667, 0.471, -0.050> <0.667, 0.482, -0.050> <0.667, 0.498, -0.043> <0.667, 0.506, -0.035> 
		<0.683, 0.471, -0.047> <0.683, 0.481, -0.047> <0.683, 0.497, -0.041> <0.683, 0.504, -0.033> 
		<0.695, 0.471, -0.045> <0.695, 0.481, -0.045> <0.695, 0.495, -0.039> <0.695, 0.503, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.695, 0.503, 0.032> <0.695, 0.495, 0.039> <0.695, 0.481, 0.045> <0.695, 0.471, 0.045> 
		<0.700, 0.502, 0.031> <0.700, 0.495, 0.039> <0.700, 0.481, 0.044> <0.700, 0.471, 0.044> 
		<0.706, 0.501, 0.030> <0.706, 0.494, 0.037> <0.706, 0.480, 0.042> <0.706, 0.471, 0.042> 
		<0.710, 0.499, 0.028> <0.710, 0.493, 0.035> <0.710, 0.480, 0.040> <0.710, 0.471, 0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.695, 0.471, 0.045> <0.695, 0.461, 0.045> <0.695, 0.446, 0.039> <0.695, 0.439, 0.032> 
		<0.700, 0.471, 0.044> <0.700, 0.461, 0.044> <0.700, 0.447, 0.039> <0.700, 0.440, 0.031> 
		<0.706, 0.471, 0.042> <0.706, 0.462, 0.042> <0.706, 0.447, 0.037> <0.706, 0.441, 0.030> 
		<0.710, 0.471, 0.040> <0.710, 0.462, 0.040> <0.710, 0.449, 0.035> <0.710, 0.443, 0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.695, 0.439, 0.032> <0.695, 0.432, 0.025> <0.695, 0.426, 0.010> <0.695, 0.426, 0.000> 
		<0.700, 0.440, 0.031> <0.700, 0.432, 0.024> <0.700, 0.427, 0.010> <0.700, 0.427, 0.000> 
		<0.706, 0.441, 0.030> <0.706, 0.434, 0.024> <0.706, 0.428, 0.009> <0.706, 0.428, 0.000> 
		<0.710, 0.443, 0.028> <0.710, 0.436, 0.022> <0.710, 0.431, 0.009> <0.710, 0.431, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.695, 0.426, 0.000> <0.695, 0.426, -0.010> <0.695, 0.432, -0.025> <0.695, 0.439, -0.032> 
		<0.700, 0.427, 0.000> <0.700, 0.427, -0.010> <0.700, 0.432, -0.024> <0.700, 0.440, -0.031> 
		<0.706, 0.428, 0.000> <0.706, 0.428, -0.009> <0.706, 0.434, -0.024> <0.706, 0.441, -0.030> 
		<0.710, 0.431, 0.000> <0.710, 0.431, -0.009> <0.710, 0.436, -0.022> <0.710, 0.443, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.695, 0.439, -0.032> <0.695, 0.446, -0.039> <0.695, 0.461, -0.045> <0.695, 0.471, -0.045> 
		<0.700, 0.440, -0.031> <0.700, 0.447, -0.039> <0.700, 0.461, -0.044> <0.700, 0.471, -0.044> 
		<0.706, 0.441, -0.030> <0.706, 0.447, -0.037> <0.706, 0.462, -0.042> <0.706, 0.471, -0.042> 
		<0.710, 0.443, -0.028> <0.710, 0.449, -0.035> <0.710, 0.462, -0.040> <0.710, 0.471, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.695, 0.471, -0.045> <0.695, 0.481, -0.045> <0.695, 0.495, -0.039> <0.695, 0.503, -0.032> 
		<0.700, 0.471, -0.044> <0.700, 0.481, -0.044> <0.700, 0.495, -0.039> <0.700, 0.502, -0.031> 
		<0.706, 0.471, -0.042> <0.706, 0.480, -0.042> <0.706, 0.494, -0.037> <0.706, 0.501, -0.030> 
		<0.710, 0.471, -0.040> <0.710, 0.480, -0.040> <0.710, 0.493, -0.035> <0.710, 0.499, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.710, 0.499, 0.028> <0.710, 0.493, 0.035> <0.710, 0.480, 0.040> <0.710, 0.471, 0.040> 
		<0.714, 0.498, 0.027> <0.714, 0.491, 0.033> <0.714, 0.480, 0.038> <0.714, 0.471, 0.038> 
		<0.717, 0.494, 0.023> <0.717, 0.489, 0.028> <0.717, 0.478, 0.033> <0.717, 0.471, 0.033> 
		<0.720, 0.492, 0.021> <0.720, 0.487, 0.026> <0.720, 0.478, 0.030> <0.720, 0.471, 0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.710, 0.471, 0.040> <0.710, 0.462, 0.040> <0.710, 0.449, 0.035> <0.710, 0.443, 0.028> 
		<0.714, 0.471, 0.038> <0.714, 0.462, 0.038> <0.714, 0.451, 0.033> <0.714, 0.444, 0.027> 
		<0.717, 0.471, 0.033> <0.717, 0.464, 0.033> <0.717, 0.452, 0.028> <0.717, 0.448, 0.023> 
		<0.720, 0.471, 0.030> <0.720, 0.464, 0.030> <0.720, 0.455, 0.026> <0.720, 0.450, 0.021> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.710, 0.443, 0.028> <0.710, 0.436, 0.022> <0.710, 0.431, 0.009> <0.710, 0.431, 0.000> 
		<0.714, 0.444, 0.027> <0.714, 0.438, 0.020> <0.714, 0.433, 0.009> <0.714, 0.433, 0.000> 
		<0.717, 0.448, 0.023> <0.717, 0.443, 0.018> <0.717, 0.438, 0.007> <0.717, 0.438, 0.000> 
		<0.720, 0.450, 0.021> <0.720, 0.445, 0.016> <0.720, 0.441, 0.007> <0.720, 0.441, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.710, 0.431, 0.000> <0.710, 0.431, -0.009> <0.710, 0.436, -0.022> <0.710, 0.443, -0.028> 
		<0.714, 0.433, 0.000> <0.714, 0.433, -0.009> <0.714, 0.438, -0.020> <0.714, 0.444, -0.027> 
		<0.717, 0.438, 0.000> <0.717, 0.438, -0.007> <0.717, 0.443, -0.018> <0.717, 0.448, -0.023> 
		<0.720, 0.441, 0.000> <0.720, 0.441, -0.007> <0.720, 0.445, -0.016> <0.720, 0.450, -0.021> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.710, 0.443, -0.028> <0.710, 0.449, -0.035> <0.710, 0.462, -0.040> <0.710, 0.471, -0.040> 
		<0.714, 0.444, -0.027> <0.714, 0.451, -0.033> <0.714, 0.462, -0.038> <0.714, 0.471, -0.038> 
		<0.717, 0.448, -0.023> <0.717, 0.452, -0.028> <0.717, 0.464, -0.033> <0.717, 0.471, -0.033> 
		<0.720, 0.450, -0.021> <0.720, 0.455, -0.026> <0.720, 0.464, -0.030> <0.720, 0.471, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.710, 0.471, -0.040> <0.710, 0.480, -0.040> <0.710, 0.493, -0.035> <0.710, 0.499, -0.028> 
		<0.714, 0.471, -0.038> <0.714, 0.480, -0.038> <0.714, 0.491, -0.033> <0.714, 0.498, -0.027> 
		<0.717, 0.471, -0.033> <0.717, 0.478, -0.033> <0.717, 0.489, -0.028> <0.717, 0.494, -0.023> 
		<0.720, 0.471, -0.030> <0.720, 0.478, -0.030> <0.720, 0.487, -0.026> <0.720, 0.492, -0.021> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.720, 0.492, 0.021> <0.720, 0.487, 0.026> <0.720, 0.478, 0.030> <0.720, 0.471, 0.030> 
		<0.722, 0.491, 0.020> <0.722, 0.486, 0.025> <0.722, 0.478, 0.029> <0.722, 0.471, 0.029> 
		<0.723, 0.489, 0.018> <0.723, 0.485, 0.022> <0.723, 0.477, 0.025> <0.723, 0.471, 0.025> 
		<0.725, 0.489, 0.018> <0.725, 0.485, 0.022> <0.725, 0.477, 0.025> <0.725, 0.471, 0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.720, 0.471, 0.030> <0.720, 0.464, 0.030> <0.720, 0.455, 0.026> <0.720, 0.450, 0.021> 
		<0.722, 0.471, 0.029> <0.722, 0.464, 0.029> <0.722, 0.456, 0.025> <0.722, 0.451, 0.020> 
		<0.723, 0.471, 0.025> <0.723, 0.465, 0.025> <0.723, 0.457, 0.022> <0.723, 0.453, 0.018> 
		<0.725, 0.471, 0.025> <0.725, 0.465, 0.025> <0.725, 0.457, 0.022> <0.725, 0.453, 0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.720, 0.450, 0.021> <0.720, 0.445, 0.016> <0.720, 0.441, 0.007> <0.720, 0.441, 0.000> 
		<0.722, 0.451, 0.020> <0.722, 0.446, 0.015> <0.722, 0.442, 0.007> <0.722, 0.442, 0.000> 
		<0.723, 0.453, 0.018> <0.723, 0.449, 0.014> <0.723, 0.446, 0.006> <0.723, 0.446, 0.000> 
		<0.725, 0.453, 0.018> <0.725, 0.449, 0.014> <0.725, 0.446, 0.006> <0.725, 0.446, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.720, 0.441, 0.000> <0.720, 0.441, -0.007> <0.720, 0.445, -0.016> <0.720, 0.450, -0.021> 
		<0.722, 0.442, 0.000> <0.722, 0.442, -0.007> <0.722, 0.446, -0.015> <0.722, 0.451, -0.020> 
		<0.723, 0.446, 0.000> <0.723, 0.446, -0.006> <0.723, 0.449, -0.014> <0.723, 0.453, -0.018> 
		<0.725, 0.446, 0.000> <0.725, 0.446, -0.006> <0.725, 0.449, -0.014> <0.725, 0.453, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.720, 0.450, -0.021> <0.720, 0.455, -0.026> <0.720, 0.464, -0.030> <0.720, 0.471, -0.030> 
		<0.722, 0.451, -0.020> <0.722, 0.456, -0.025> <0.722, 0.464, -0.029> <0.722, 0.471, -0.029> 
		<0.723, 0.453, -0.018> <0.723, 0.457, -0.022> <0.723, 0.465, -0.025> <0.723, 0.471, -0.025> 
		<0.725, 0.453, -0.018> <0.725, 0.457, -0.022> <0.725, 0.465, -0.025> <0.725, 0.471, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.720, 0.471, -0.030> <0.720, 0.478, -0.030> <0.720, 0.487, -0.026> <0.720, 0.492, -0.021> 
		<0.722, 0.471, -0.029> <0.722, 0.478, -0.029> <0.722, 0.486, -0.025> <0.722, 0.491, -0.020> 
		<0.723, 0.471, -0.025> <0.723, 0.477, -0.025> <0.723, 0.485, -0.022> <0.723, 0.489, -0.018> 
		<0.725, 0.471, -0.025> <0.725, 0.477, -0.025> <0.725, 0.485, -0.022> <0.725, 0.489, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.725, 0.489, 0.018> <0.725, 0.485, 0.022> <0.725, 0.477, 0.025> <0.725, 0.471, 0.025> 
		<0.727, 0.489, 0.018> <0.727, 0.485, 0.022> <0.727, 0.477, 0.025> <0.727, 0.471, 0.025> 
		<0.728, 0.492, 0.021> <0.728, 0.487, 0.026> <0.728, 0.478, 0.030> <0.728, 0.471, 0.030> 
		<0.730, 0.492, 0.021> <0.730, 0.487, 0.026> <0.730, 0.478, 0.030> <0.730, 0.471, 0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.725, 0.471, 0.025> <0.725, 0.465, 0.025> <0.725, 0.457, 0.022> <0.725, 0.453, 0.018> 
		<0.727, 0.471, 0.025> <0.727, 0.465, 0.025> <0.727, 0.457, 0.022> <0.727, 0.453, 0.018> 
		<0.728, 0.471, 0.030> <0.728, 0.464, 0.030> <0.728, 0.455, 0.026> <0.728, 0.450, 0.021> 
		<0.730, 0.471, 0.030> <0.730, 0.464, 0.030> <0.730, 0.455, 0.026> <0.730, 0.450, 0.021> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.725, 0.453, 0.018> <0.725, 0.449, 0.014> <0.725, 0.446, 0.006> <0.725, 0.446, 0.000> 
		<0.727, 0.453, 0.018> <0.727, 0.449, 0.014> <0.727, 0.446, 0.006> <0.727, 0.446, 0.000> 
		<0.728, 0.450, 0.021> <0.728, 0.445, 0.016> <0.728, 0.441, 0.007> <0.728, 0.441, 0.000> 
		<0.730, 0.450, 0.021> <0.730, 0.445, 0.016> <0.730, 0.441, 0.007> <0.730, 0.441, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.725, 0.446, 0.000> <0.725, 0.446, -0.006> <0.725, 0.449, -0.014> <0.725, 0.453, -0.018> 
		<0.727, 0.446, 0.000> <0.727, 0.446, -0.006> <0.727, 0.449, -0.014> <0.727, 0.453, -0.018> 
		<0.728, 0.441, 0.000> <0.728, 0.441, -0.007> <0.728, 0.445, -0.016> <0.728, 0.450, -0.021> 
		<0.730, 0.441, 0.000> <0.730, 0.441, -0.007> <0.730, 0.445, -0.016> <0.730, 0.450, -0.021> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.725, 0.453, -0.018> <0.725, 0.457, -0.022> <0.725, 0.465, -0.025> <0.725, 0.471, -0.025> 
		<0.727, 0.453, -0.018> <0.727, 0.457, -0.022> <0.727, 0.465, -0.025> <0.727, 0.471, -0.025> 
		<0.728, 0.450, -0.021> <0.728, 0.455, -0.026> <0.728, 0.464, -0.030> <0.728, 0.471, -0.030> 
		<0.730, 0.450, -0.021> <0.730, 0.455, -0.026> <0.730, 0.464, -0.030> <0.730, 0.471, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.725, 0.471, -0.025> <0.725, 0.477, -0.025> <0.725, 0.485, -0.022> <0.725, 0.489, -0.018> 
		<0.727, 0.471, -0.025> <0.727, 0.477, -0.025> <0.727, 0.485, -0.022> <0.727, 0.489, -0.018> 
		<0.728, 0.471, -0.030> <0.728, 0.478, -0.030> <0.728, 0.487, -0.026> <0.728, 0.492, -0.021> 
		<0.730, 0.471, -0.030> <0.730, 0.478, -0.030> <0.730, 0.487, -0.026> <0.730, 0.492, -0.021> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.730, 0.492, 0.021> <0.730, 0.487, 0.026> <0.730, 0.478, 0.030> <0.730, 0.471, 0.030> 
		<0.732, 0.492, 0.021> <0.732, 0.487, 0.026> <0.732, 0.478, 0.030> <0.732, 0.471, 0.030> 
		<0.734, 0.490, 0.019> <0.734, 0.486, 0.023> <0.734, 0.477, 0.026> <0.734, 0.471, 0.026> 
		<0.735, 0.489, 0.018> <0.735, 0.485, 0.022> <0.735, 0.477, 0.025> <0.735, 0.471, 0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.730, 0.471, 0.030> <0.730, 0.464, 0.030> <0.730, 0.455, 0.026> <0.730, 0.450, 0.021> 
		<0.732, 0.471, 0.030> <0.732, 0.464, 0.030> <0.732, 0.455, 0.026> <0.732, 0.450, 0.021> 
		<0.734, 0.471, 0.026> <0.734, 0.465, 0.026> <0.734, 0.456, 0.023> <0.734, 0.452, 0.019> 
		<0.735, 0.471, 0.025> <0.735, 0.465, 0.025> <0.735, 0.457, 0.022> <0.735, 0.453, 0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.730, 0.450, 0.021> <0.730, 0.445, 0.016> <0.730, 0.441, 0.007> <0.730, 0.441, 0.000> 
		<0.732, 0.450, 0.021> <0.732, 0.445, 0.016> <0.732, 0.441, 0.007> <0.732, 0.441, 0.000> 
		<0.734, 0.452, 0.019> <0.734, 0.448, 0.015> <0.734, 0.444, 0.006> <0.734, 0.444, 0.000> 
		<0.735, 0.453, 0.018> <0.735, 0.449, 0.014> <0.735, 0.446, 0.006> <0.735, 0.446, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.730, 0.441, 0.000> <0.730, 0.441, -0.007> <0.730, 0.445, -0.016> <0.730, 0.450, -0.021> 
		<0.732, 0.441, 0.000> <0.732, 0.441, -0.007> <0.732, 0.445, -0.016> <0.732, 0.450, -0.021> 
		<0.734, 0.444, 0.000> <0.734, 0.444, -0.006> <0.734, 0.448, -0.015> <0.734, 0.452, -0.019> 
		<0.735, 0.446, 0.000> <0.735, 0.446, -0.006> <0.735, 0.449, -0.014> <0.735, 0.453, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.730, 0.450, -0.021> <0.730, 0.455, -0.026> <0.730, 0.464, -0.030> <0.730, 0.471, -0.030> 
		<0.732, 0.450, -0.021> <0.732, 0.455, -0.026> <0.732, 0.464, -0.030> <0.732, 0.471, -0.030> 
		<0.734, 0.452, -0.019> <0.734, 0.456, -0.023> <0.734, 0.465, -0.026> <0.734, 0.471, -0.026> 
		<0.735, 0.453, -0.018> <0.735, 0.457, -0.022> <0.735, 0.465, -0.025> <0.735, 0.471, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.730, 0.471, -0.030> <0.730, 0.478, -0.030> <0.730, 0.487, -0.026> <0.730, 0.492, -0.021> 
		<0.732, 0.471, -0.030> <0.732, 0.478, -0.030> <0.732, 0.487, -0.026> <0.732, 0.492, -0.021> 
		<0.734, 0.471, -0.026> <0.734, 0.477, -0.026> <0.734, 0.486, -0.023> <0.734, 0.490, -0.019> 
		<0.735, 0.471, -0.025> <0.735, 0.477, -0.025> <0.735, 0.485, -0.022> <0.735, 0.489, -0.018> 
	}
	texture { T_Layer2 }
	scale MeshScale
}*/
// Layer 3
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.317, 0.154, 0.010> <-0.315, 0.154, 0.002> <-0.313, 0.153, -0.010> <-0.307, 0.153, -0.015> 
		<-0.317, 0.155, 0.010> <-0.316, 0.155, 0.002> <-0.314, 0.155, -0.010> <-0.308, 0.154, -0.016> 
		<-0.320, 0.156, 0.010> <-0.318, 0.156, 0.001> <-0.318, 0.156, -0.011> <-0.311, 0.155, -0.017> 
		<-0.321, 0.158, 0.010> <-0.319, 0.158, 0.001> <-0.318, 0.157, -0.012> <-0.311, 0.157, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.317, 0.154, 0.010> <-0.317, 0.155, 0.010> <-0.320, 0.156, 0.010> <-0.321, 0.158, 0.010> 
		<-0.318, 0.154, 0.017> <-0.319, 0.155, 0.017> <-0.322, 0.156, 0.018> <-0.323, 0.158, 0.018> 
		<-0.323, 0.154, 0.031> <-0.325, 0.156, 0.032> <-0.329, 0.156, 0.032> <-0.330, 0.158, 0.034> 
		<-0.317, 0.153, 0.035> <-0.319, 0.155, 0.036> <-0.322, 0.156, 0.037> <-0.323, 0.158, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.317, 0.154, 0.010> <-0.316, 0.153, 0.010> <-0.317, 0.151, 0.010> <-0.317, 0.150, 0.010> 
		<-0.315, 0.154, 0.002> <-0.315, 0.153, 0.002> <-0.315, 0.151, 0.002> <-0.316, 0.150, 0.002> 
		<-0.313, 0.153, -0.010> <-0.312, 0.152, -0.009> <-0.313, 0.150, -0.009> <-0.313, 0.149, -0.010> 
		<-0.307, 0.153, -0.015> <-0.306, 0.152, -0.014> <-0.307, 0.150, -0.015> <-0.307, 0.149, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.317, 0.154, 0.010> <-0.318, 0.154, 0.017> <-0.323, 0.154, 0.031> <-0.317, 0.153, 0.035> 
		<-0.316, 0.153, 0.010> <-0.318, 0.153, 0.017> <-0.323, 0.153, 0.030> <-0.317, 0.152, 0.035> 
		<-0.317, 0.151, 0.010> <-0.318, 0.151, 0.017> <-0.323, 0.151, 0.031> <-0.316, 0.151, 0.035> 
		<-0.317, 0.150, 0.010> <-0.318, 0.150, 0.017> <-0.323, 0.150, 0.031> <-0.316, 0.150, 0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.317, 0.150, 0.010> <-0.318, 0.147, 0.010> <-0.321, 0.145, 0.010> <-0.321, 0.142, 0.010> 
		<-0.316, 0.150, 0.002> <-0.316, 0.147, 0.002> <-0.320, 0.144, 0.001> <-0.320, 0.142, 0.001> 
		<-0.313, 0.149, -0.010> <-0.314, 0.147, -0.010> <-0.318, 0.144, -0.012> <-0.319, 0.142, -0.013> 
		<-0.307, 0.149, -0.015> <-0.308, 0.146, -0.016> <-0.312, 0.144, -0.018> <-0.312, 0.141, -0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.317, 0.150, 0.010> <-0.318, 0.150, 0.017> <-0.323, 0.150, 0.031> <-0.316, 0.150, 0.035> 
		<-0.318, 0.147, 0.010> <-0.319, 0.148, 0.017> <-0.322, 0.148, 0.032> <-0.316, 0.147, 0.036> 
		<-0.321, 0.145, 0.010> <-0.321, 0.145, 0.018> <-0.325, 0.144, 0.033> <-0.318, 0.144, 0.038> 
		<-0.321, 0.142, 0.010> <-0.322, 0.142, 0.018> <-0.324, 0.142, 0.033> <-0.317, 0.141, 0.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.321, 0.142, 0.010> <-0.321, 0.137, 0.010> <-0.320, 0.132, 0.010> <-0.320, 0.127, 0.010> 
		<-0.320, 0.142, 0.001> <-0.321, 0.137, 0.001> <-0.320, 0.132, -0.000> <-0.320, 0.127, 0.000> 
		<-0.319, 0.142, -0.013> <-0.319, 0.138, -0.014> <-0.319, 0.132, -0.014> <-0.318, 0.128, -0.015> 
		<-0.312, 0.141, -0.019> <-0.313, 0.137, -0.020> <-0.312, 0.132, -0.021> <-0.311, 0.128, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.321, 0.142, 0.010> <-0.322, 0.142, 0.018> <-0.324, 0.142, 0.033> <-0.317, 0.141, 0.038> 
		<-0.321, 0.137, 0.010> <-0.322, 0.138, 0.018> <-0.323, 0.137, 0.035> <-0.316, 0.137, 0.040> 
		<-0.320, 0.132, 0.010> <-0.320, 0.132, 0.020> <-0.319, 0.132, 0.035> <-0.311, 0.132, 0.041> 
		<-0.320, 0.127, 0.010> <-0.320, 0.127, 0.020> <-0.317, 0.127, 0.036> <-0.309, 0.127, 0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.288, 0.041, 0.010> <-0.287, 0.041, 0.004> <-0.282, 0.041, -0.003> <-0.278, 0.041, -0.007> 
		<-0.290, 0.042, 0.010> <-0.289, 0.042, 0.004> <-0.284, 0.042, -0.004> <-0.280, 0.042, -0.009> 
		<-0.295, 0.043, 0.010> <-0.293, 0.043, 0.003> <-0.288, 0.043, -0.006> <-0.283, 0.043, -0.011> 
		<-0.296, 0.045, 0.010> <-0.294, 0.045, 0.003> <-0.289, 0.045, -0.006> <-0.284, 0.045, -0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.288, 0.041, 0.010> <-0.290, 0.042, 0.010> <-0.295, 0.043, 0.010> <-0.296, 0.045, 0.010> 
		<-0.289, 0.041, 0.016> <-0.291, 0.042, 0.016> <-0.296, 0.043, 0.017> <-0.297, 0.045, 0.017> 
		<-0.288, 0.041, 0.024> <-0.290, 0.043, 0.025> <-0.295, 0.043, 0.027> <-0.296, 0.045, 0.027> 
		<-0.285, 0.042, 0.029> <-0.287, 0.043, 0.030> <-0.290, 0.043, 0.032> <-0.291, 0.045, 0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.321, 0.070, 0.010> <-0.319, 0.070, -0.002> <-0.306, 0.069, -0.014> <-0.297, 0.069, -0.022> 
		<-0.323, 0.079, 0.010> <-0.320, 0.079, -0.001> <-0.307, 0.078, -0.015> <-0.298, 0.078, -0.023> 
		<-0.323, 0.092, 0.011> <-0.322, 0.092, -0.002> <-0.307, 0.090, -0.016> <-0.298, 0.090, -0.025> 
		<-0.322, 0.101, 0.011> <-0.322, 0.101, -0.002> <-0.309, 0.099, -0.016> <-0.300, 0.099, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.321, 0.070, 0.010> <-0.323, 0.079, 0.010> <-0.323, 0.092, 0.011> <-0.322, 0.101, 0.011> 
		<-0.323, 0.071, 0.020> <-0.325, 0.080, 0.020> <-0.323, 0.092, 0.023> <-0.323, 0.101, 0.023> 
		<-0.318, 0.071, 0.036> <-0.317, 0.079, 0.037> <-0.312, 0.090, 0.037> <-0.312, 0.099, 0.037> 
		<-0.310, 0.071, 0.043> <-0.309, 0.079, 0.044> <-0.304, 0.090, 0.046> <-0.304, 0.098, 0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.321, 0.070, 0.010> <-0.320, 0.067, 0.010> <-0.317, 0.062, 0.010> <-0.314, 0.060, 0.010> 
		<-0.319, 0.070, -0.002> <-0.318, 0.066, -0.002> <-0.315, 0.062, -0.000> <-0.312, 0.059, -0.000> 
		<-0.306, 0.069, -0.014> <-0.306, 0.066, -0.013> <-0.303, 0.061, -0.013> <-0.301, 0.059, -0.012> 
		<-0.297, 0.069, -0.022> <-0.296, 0.066, -0.021> <-0.295, 0.062, -0.020> <-0.293, 0.059, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.321, 0.070, 0.010> <-0.323, 0.071, 0.020> <-0.318, 0.071, 0.036> <-0.310, 0.071, 0.043> 
		<-0.320, 0.067, 0.010> <-0.322, 0.067, 0.020> <-0.318, 0.067, 0.035> <-0.311, 0.068, 0.042> 
		<-0.317, 0.062, 0.010> <-0.319, 0.062, 0.019> <-0.316, 0.063, 0.035> <-0.310, 0.063, 0.041> 
		<-0.314, 0.060, 0.010> <-0.316, 0.060, 0.019> <-0.314, 0.060, 0.033> <-0.308, 0.061, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.299, 0.052, 0.010> <-0.298, 0.052, 0.003> <-0.292, 0.052, -0.006> <-0.286, 0.052, -0.011> 
		<-0.304, 0.055, 0.010> <-0.302, 0.054, 0.003> <-0.294, 0.054, -0.008> <-0.288, 0.054, -0.013> 
		<-0.310, 0.057, 0.010> <-0.308, 0.056, -0.000> <-0.300, 0.056, -0.010> <-0.292, 0.056, -0.017> 
		<-0.314, 0.060, 0.010> <-0.312, 0.059, -0.000> <-0.301, 0.059, -0.012> <-0.293, 0.059, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.299, 0.052, 0.010> <-0.304, 0.055, 0.010> <-0.310, 0.057, 0.010> <-0.314, 0.060, 0.010> 
		<-0.301, 0.053, 0.017> <-0.305, 0.055, 0.017> <-0.313, 0.057, 0.019> <-0.316, 0.060, 0.019> 
		<-0.300, 0.053, 0.027> <-0.304, 0.055, 0.030> <-0.312, 0.057, 0.031> <-0.314, 0.060, 0.033> 
		<-0.296, 0.053, 0.032> <-0.299, 0.055, 0.034> <-0.305, 0.057, 0.037> <-0.308, 0.061, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.299, 0.052, 0.010> <-0.297, 0.051, 0.010> <-0.293, 0.051, 0.010> <-0.292, 0.049, 0.010> 
		<-0.298, 0.052, 0.003> <-0.295, 0.051, 0.003> <-0.292, 0.051, 0.004> <-0.291, 0.049, 0.004> 
		<-0.292, 0.052, -0.006> <-0.290, 0.051, -0.005> <-0.286, 0.050, -0.003> <-0.286, 0.048, -0.003> 
		<-0.286, 0.052, -0.011> <-0.285, 0.051, -0.010> <-0.282, 0.051, -0.008> <-0.281, 0.049, -0.008> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.299, 0.052, 0.010> <-0.301, 0.053, 0.017> <-0.300, 0.053, 0.027> <-0.296, 0.053, 0.032> 
		<-0.297, 0.051, 0.010> <-0.299, 0.051, 0.017> <-0.298, 0.052, 0.026> <-0.294, 0.052, 0.031> 
		<-0.293, 0.051, 0.010> <-0.294, 0.051, 0.016> <-0.294, 0.051, 0.024> <-0.290, 0.052, 0.029> 
		<-0.292, 0.049, 0.010> <-0.293, 0.049, 0.016> <-0.293, 0.049, 0.024> <-0.289, 0.049, 0.029> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.292, 0.049, 0.010> <-0.291, 0.047, 0.010> <-0.296, 0.046, 0.010> <-0.296, 0.045, 0.010> 
		<-0.291, 0.049, 0.004> <-0.290, 0.047, 0.004> <-0.295, 0.046, 0.003> <-0.294, 0.045, 0.003> 
		<-0.286, 0.048, -0.003> <-0.285, 0.047, -0.003> <-0.289, 0.046, -0.006> <-0.289, 0.045, -0.006> 
		<-0.281, 0.049, -0.008> <-0.280, 0.047, -0.008> <-0.284, 0.047, -0.011> <-0.284, 0.045, -0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.292, 0.049, 0.010> <-0.293, 0.049, 0.016> <-0.293, 0.049, 0.024> <-0.289, 0.049, 0.029> 
		<-0.291, 0.047, 0.010> <-0.292, 0.047, 0.016> <-0.292, 0.048, 0.024> <-0.288, 0.048, 0.029> 
		<-0.296, 0.046, 0.010> <-0.298, 0.046, 0.017> <-0.297, 0.047, 0.027> <-0.292, 0.047, 0.032> 
		<-0.296, 0.045, 0.010> <-0.297, 0.045, 0.017> <-0.296, 0.045, 0.027> <-0.291, 0.045, 0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.320, 0.127, 0.010> <-0.320, 0.120, 0.010> <-0.322, 0.109, 0.011> <-0.322, 0.101, 0.011> 
		<-0.320, 0.127, 0.000> <-0.320, 0.120, 0.000> <-0.322, 0.109, -0.002> <-0.322, 0.101, -0.002> 
		<-0.318, 0.128, -0.015> <-0.315, 0.119, -0.016> <-0.311, 0.108, -0.016> <-0.309, 0.099, -0.016> 
		<-0.311, 0.128, -0.022> <-0.308, 0.119, -0.023> <-0.302, 0.108, -0.025> <-0.300, 0.099, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.320, 0.127, 0.010> <-0.320, 0.127, 0.020> <-0.317, 0.127, 0.036> <-0.309, 0.127, 0.042> 
		<-0.320, 0.120, 0.010> <-0.320, 0.119, 0.020> <-0.315, 0.119, 0.037> <-0.307, 0.119, 0.043> 
		<-0.322, 0.109, 0.011> <-0.323, 0.109, 0.023> <-0.312, 0.108, 0.037> <-0.304, 0.107, 0.045> 
		<-0.322, 0.101, 0.011> <-0.323, 0.101, 0.023> <-0.312, 0.099, 0.037> <-0.304, 0.098, 0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.317, 0.277, 0.010> <-0.318, 0.277, 0.000> <-0.311, 0.268, -0.012> <-0.304, 0.265, -0.019> 
		<-0.317, 0.279, 0.010> <-0.318, 0.279, 0.000> <-0.313, 0.272, -0.012> <-0.306, 0.269, -0.019> 
		<-0.320, 0.280, 0.010> <-0.321, 0.280, 0.000> <-0.311, 0.277, -0.011> <-0.304, 0.275, -0.018> 
		<-0.320, 0.282, 0.010> <-0.321, 0.282, 0.000> <-0.311, 0.282, -0.012> <-0.304, 0.279, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.317, 0.277, 0.010> <-0.317, 0.279, 0.010> <-0.320, 0.280, 0.010> <-0.320, 0.282, 0.010> 
		<-0.316, 0.277, 0.021> <-0.316, 0.278, 0.021> <-0.320, 0.280, 0.020> <-0.320, 0.282, 0.020> 
		<-0.308, 0.267, 0.032> <-0.309, 0.271, 0.032> <-0.308, 0.277, 0.031> <-0.308, 0.281, 0.031> 
		<-0.300, 0.265, 0.039> <-0.301, 0.269, 0.038> <-0.301, 0.274, 0.038> <-0.301, 0.278, 0.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.317, 0.277, 0.010> <-0.317, 0.272, 0.010> <-0.320, 0.267, 0.010> <-0.320, 0.263, 0.011> 
		<-0.318, 0.277, 0.000> <-0.318, 0.272, 0.000> <-0.320, 0.267, -0.000> <-0.321, 0.263, -0.000> 
		<-0.311, 0.268, -0.012> <-0.311, 0.266, -0.012> <-0.307, 0.264, -0.011> <-0.307, 0.262, -0.011> 
		<-0.304, 0.265, -0.019> <-0.304, 0.263, -0.019> <-0.299, 0.263, -0.018> <-0.299, 0.261, -0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.317, 0.277, 0.010> <-0.316, 0.277, 0.021> <-0.308, 0.267, 0.032> <-0.300, 0.265, 0.039> 
		<-0.317, 0.272, 0.010> <-0.316, 0.272, 0.021> <-0.307, 0.266, 0.032> <-0.299, 0.263, 0.039> 
		<-0.320, 0.267, 0.010> <-0.319, 0.267, 0.022> <-0.304, 0.264, 0.031> <-0.295, 0.263, 0.038> 
		<-0.320, 0.263, 0.011> <-0.320, 0.263, 0.022> <-0.304, 0.262, 0.032> <-0.295, 0.261, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.320, 0.263, 0.011> <-0.321, 0.261, 0.011> <-0.320, 0.258, 0.011> <-0.319, 0.256, 0.011> 
		<-0.321, 0.263, -0.000> <-0.321, 0.261, -0.000> <-0.319, 0.258, -0.001> <-0.319, 0.256, -0.001> 
		<-0.307, 0.262, -0.011> <-0.305, 0.260, -0.012> <-0.307, 0.257, -0.013> <-0.306, 0.255, -0.014> 
		<-0.299, 0.261, -0.019> <-0.297, 0.259, -0.019> <-0.299, 0.256, -0.022> <-0.299, 0.254, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.320, 0.263, 0.011> <-0.320, 0.263, 0.022> <-0.304, 0.262, 0.032> <-0.295, 0.261, 0.039> 
		<-0.321, 0.261, 0.011> <-0.320, 0.261, 0.022> <-0.304, 0.259, 0.033> <-0.295, 0.258, 0.040> 
		<-0.320, 0.258, 0.011> <-0.320, 0.258, 0.022> <-0.307, 0.257, 0.034> <-0.299, 0.256, 0.042> 
		<-0.319, 0.256, 0.011> <-0.320, 0.255, 0.022> <-0.308, 0.255, 0.035> <-0.300, 0.253, 0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.319, 0.256, 0.011> <-0.319, 0.250, 0.011> <-0.317, 0.243, 0.011> <-0.317, 0.237, 0.011> 
		<-0.319, 0.256, -0.001> <-0.319, 0.250, -0.001> <-0.315, 0.243, -0.001> <-0.316, 0.237, -0.001> 
		<-0.306, 0.255, -0.014> <-0.306, 0.249, -0.014> <-0.301, 0.241, -0.013> <-0.303, 0.236, -0.013> 
		<-0.299, 0.254, -0.022> <-0.298, 0.248, -0.023> <-0.294, 0.240, -0.022> <-0.296, 0.235, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.319, 0.256, 0.011> <-0.320, 0.255, 0.022> <-0.308, 0.255, 0.035> <-0.300, 0.253, 0.042> 
		<-0.319, 0.250, 0.011> <-0.319, 0.250, 0.022> <-0.309, 0.249, 0.036> <-0.301, 0.248, 0.043> 
		<-0.317, 0.243, 0.011> <-0.318, 0.243, 0.021> <-0.307, 0.241, 0.035> <-0.300, 0.240, 0.043> 
		<-0.317, 0.237, 0.011> <-0.318, 0.237, 0.021> <-0.309, 0.236, 0.034> <-0.302, 0.235, 0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.320, 0.177, 0.010> <-0.319, 0.177, -0.000> <-0.315, 0.178, -0.015> <-0.307, 0.177, -0.022> 
		<-0.321, 0.186, 0.010> <-0.320, 0.186, -0.000> <-0.316, 0.187, -0.015> <-0.308, 0.187, -0.022> 
		<-0.327, 0.198, 0.010> <-0.328, 0.198, 0.000> <-0.324, 0.199, -0.013> <-0.317, 0.199, -0.020> 
		<-0.327, 0.207, 0.010> <-0.327, 0.207, 0.000> <-0.322, 0.209, -0.013> <-0.315, 0.209, -0.020> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.320, 0.177, 0.010> <-0.321, 0.186, 0.010> <-0.327, 0.198, 0.010> <-0.327, 0.207, 0.010> 
		<-0.321, 0.177, 0.020> <-0.322, 0.186, 0.020> <-0.327, 0.198, 0.020> <-0.327, 0.207, 0.020> 
		<-0.319, 0.176, 0.036> <-0.318, 0.186, 0.035> <-0.322, 0.199, 0.033> <-0.321, 0.209, 0.033> 
		<-0.312, 0.176, 0.042> <-0.311, 0.186, 0.042> <-0.315, 0.199, 0.039> <-0.314, 0.209, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.320, 0.177, 0.010> <-0.320, 0.173, 0.010> <-0.322, 0.169, 0.010> <-0.322, 0.166, 0.010> 
		<-0.319, 0.177, -0.000> <-0.319, 0.174, -0.000> <-0.321, 0.169, -0.000> <-0.321, 0.166, -0.000> 
		<-0.315, 0.178, -0.015> <-0.314, 0.174, -0.015> <-0.317, 0.169, -0.016> <-0.318, 0.165, -0.015> 
		<-0.307, 0.177, -0.022> <-0.307, 0.173, -0.022> <-0.310, 0.168, -0.023> <-0.310, 0.164, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.320, 0.177, 0.010> <-0.321, 0.177, 0.020> <-0.319, 0.176, 0.036> <-0.312, 0.176, 0.042> 
		<-0.320, 0.173, 0.010> <-0.320, 0.173, 0.020> <-0.320, 0.172, 0.036> <-0.312, 0.172, 0.042> 
		<-0.322, 0.169, 0.010> <-0.323, 0.169, 0.020> <-0.324, 0.169, 0.037> <-0.317, 0.168, 0.043> 
		<-0.322, 0.166, 0.010> <-0.324, 0.166, 0.020> <-0.326, 0.166, 0.036> <-0.319, 0.165, 0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.322, 0.166, 0.010> <-0.322, 0.163, 0.010> <-0.322, 0.160, 0.010> <-0.321, 0.158, 0.010> 
		<-0.321, 0.166, -0.000> <-0.321, 0.163, -0.000> <-0.320, 0.160, 0.001> <-0.319, 0.158, 0.001> 
		<-0.318, 0.165, -0.015> <-0.319, 0.163, -0.015> <-0.319, 0.159, -0.014> <-0.318, 0.157, -0.012> 
		<-0.310, 0.164, -0.022> <-0.311, 0.162, -0.021> <-0.312, 0.159, -0.020> <-0.311, 0.157, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.322, 0.166, 0.010> <-0.324, 0.166, 0.020> <-0.326, 0.166, 0.036> <-0.319, 0.165, 0.042> 
		<-0.322, 0.163, 0.010> <-0.324, 0.163, 0.020> <-0.328, 0.163, 0.036> <-0.320, 0.162, 0.042> 
		<-0.322, 0.160, 0.010> <-0.324, 0.160, 0.018> <-0.330, 0.161, 0.035> <-0.323, 0.160, 0.040> 
		<-0.321, 0.158, 0.010> <-0.323, 0.158, 0.018> <-0.330, 0.158, 0.034> <-0.323, 0.158, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.317, 0.237, 0.011> <-0.319, 0.228, 0.011> <-0.327, 0.216, 0.010> <-0.327, 0.207, 0.010> 
		<-0.316, 0.237, -0.001> <-0.318, 0.228, -0.001> <-0.327, 0.216, 0.000> <-0.327, 0.207, 0.000> 
		<-0.303, 0.236, -0.013> <-0.306, 0.226, -0.012> <-0.320, 0.219, -0.013> <-0.322, 0.209, -0.013> 
		<-0.296, 0.235, -0.022> <-0.299, 0.226, -0.022> <-0.313, 0.219, -0.020> <-0.315, 0.209, -0.020> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.317, 0.237, 0.011> <-0.318, 0.237, 0.021> <-0.309, 0.236, 0.034> <-0.302, 0.235, 0.042> 
		<-0.319, 0.228, 0.011> <-0.320, 0.228, 0.021> <-0.312, 0.227, 0.034> <-0.305, 0.227, 0.042> 
		<-0.327, 0.216, 0.010> <-0.326, 0.216, 0.020> <-0.319, 0.218, 0.033> <-0.312, 0.217, 0.039> 
		<-0.327, 0.207, 0.010> <-0.327, 0.207, 0.020> <-0.321, 0.209, 0.033> <-0.314, 0.209, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.280, 0.393, 0.009> <-0.280, 0.394, -0.001> <-0.274, 0.388, -0.016> <-0.267, 0.384, -0.023> 
		<-0.281, 0.395, 0.009> <-0.280, 0.396, -0.001> <-0.274, 0.389, -0.016> <-0.267, 0.386, -0.023> 
		<-0.283, 0.398, 0.009> <-0.283, 0.398, -0.002> <-0.278, 0.391, -0.018> <-0.270, 0.387, -0.026> 
		<-0.283, 0.400, 0.009> <-0.283, 0.400, -0.002> <-0.278, 0.393, -0.018> <-0.270, 0.389, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.280, 0.393, 0.009> <-0.281, 0.395, 0.009> <-0.283, 0.398, 0.009> <-0.283, 0.400, 0.009> 
		<-0.281, 0.393, 0.020> <-0.281, 0.395, 0.020> <-0.283, 0.398, 0.021> <-0.283, 0.400, 0.021> 
		<-0.275, 0.387, 0.034> <-0.275, 0.388, 0.034> <-0.279, 0.390, 0.036> <-0.279, 0.392, 0.037> 
		<-0.269, 0.383, 0.041> <-0.269, 0.385, 0.042> <-0.271, 0.386, 0.044> <-0.271, 0.388, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.280, 0.393, 0.009> <-0.280, 0.392, 0.009> <-0.282, 0.390, 0.009> <-0.282, 0.389, 0.009> 
		<-0.280, 0.394, -0.001> <-0.280, 0.392, -0.001> <-0.282, 0.390, -0.001> <-0.282, 0.389, -0.002> 
		<-0.274, 0.388, -0.016> <-0.274, 0.386, -0.015> <-0.275, 0.385, -0.015> <-0.276, 0.383, -0.016> 
		<-0.267, 0.384, -0.023> <-0.267, 0.383, -0.022> <-0.268, 0.381, -0.022> <-0.269, 0.380, -0.023> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.280, 0.393, 0.009> <-0.281, 0.393, 0.020> <-0.275, 0.387, 0.034> <-0.269, 0.383, 0.041> 
		<-0.280, 0.392, 0.009> <-0.281, 0.392, 0.020> <-0.275, 0.385, 0.033> <-0.269, 0.382, 0.040> 
		<-0.282, 0.390, 0.009> <-0.282, 0.390, 0.020> <-0.276, 0.384, 0.033> <-0.270, 0.380, 0.040> 
		<-0.282, 0.389, 0.009> <-0.282, 0.388, 0.020> <-0.277, 0.382, 0.033> <-0.270, 0.379, 0.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.282, 0.389, 0.009> <-0.283, 0.386, 0.009> <-0.283, 0.381, 0.009> <-0.284, 0.379, 0.009> 
		<-0.282, 0.389, -0.002> <-0.283, 0.386, -0.002> <-0.283, 0.381, -0.002> <-0.284, 0.379, -0.002> 
		<-0.276, 0.383, -0.016> <-0.278, 0.380, -0.016> <-0.280, 0.376, -0.017> <-0.282, 0.372, -0.018> 
		<-0.269, 0.380, -0.023> <-0.271, 0.376, -0.023> <-0.273, 0.372, -0.025> <-0.275, 0.368, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.282, 0.389, 0.009> <-0.282, 0.388, 0.020> <-0.277, 0.382, 0.033> <-0.270, 0.379, 0.041> 
		<-0.283, 0.386, 0.009> <-0.283, 0.385, 0.020> <-0.278, 0.379, 0.034> <-0.272, 0.375, 0.042> 
		<-0.283, 0.381, 0.009> <-0.283, 0.381, 0.020> <-0.280, 0.375, 0.035> <-0.274, 0.371, 0.044> 
		<-0.284, 0.379, 0.009> <-0.284, 0.378, 0.020> <-0.282, 0.372, 0.036> <-0.275, 0.368, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.284, 0.379, 0.009> <-0.287, 0.375, 0.009> <-0.293, 0.373, 0.009> <-0.295, 0.369, 0.010> 
		<-0.284, 0.379, -0.002> <-0.287, 0.375, -0.002> <-0.294, 0.373, -0.002> <-0.295, 0.369, -0.002> 
		<-0.282, 0.372, -0.018> <-0.284, 0.369, -0.018> <-0.288, 0.365, -0.017> <-0.290, 0.361, -0.016> 
		<-0.275, 0.368, -0.026> <-0.277, 0.365, -0.026> <-0.280, 0.361, -0.024> <-0.282, 0.358, -0.024> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.284, 0.379, 0.009> <-0.284, 0.378, 0.020> <-0.282, 0.372, 0.036> <-0.275, 0.368, 0.045> 
		<-0.287, 0.375, 0.009> <-0.287, 0.375, 0.021> <-0.283, 0.369, 0.036> <-0.277, 0.365, 0.045> 
		<-0.293, 0.373, 0.009> <-0.293, 0.373, 0.021> <-0.286, 0.365, 0.036> <-0.280, 0.361, 0.044> 
		<-0.295, 0.369, 0.010> <-0.295, 0.369, 0.021> <-0.288, 0.362, 0.035> <-0.281, 0.358, 0.044> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.314, 0.316, 0.011> <-0.314, 0.316, 0.001> <-0.313, 0.313, -0.012> <-0.307, 0.311, -0.019> 
		<-0.311, 0.321, 0.011> <-0.312, 0.321, 0.001> <-0.312, 0.319, -0.013> <-0.306, 0.318, -0.020> 
		<-0.306, 0.327, 0.011> <-0.306, 0.327, 0.001> <-0.308, 0.327, -0.015> <-0.301, 0.325, -0.022> 
		<-0.304, 0.333, 0.011> <-0.304, 0.333, 0.000> <-0.305, 0.333, -0.016> <-0.298, 0.331, -0.023> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.314, 0.316, 0.011> <-0.311, 0.321, 0.011> <-0.306, 0.327, 0.011> <-0.304, 0.333, 0.011> 
		<-0.313, 0.316, 0.020> <-0.310, 0.321, 0.020> <-0.305, 0.327, 0.021> <-0.303, 0.333, 0.021> 
		<-0.308, 0.313, 0.034> <-0.308, 0.319, 0.034> <-0.304, 0.328, 0.035> <-0.301, 0.333, 0.036> 
		<-0.302, 0.311, 0.041> <-0.302, 0.318, 0.041> <-0.298, 0.325, 0.043> <-0.295, 0.331, 0.044> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.314, 0.316, 0.011> <-0.315, 0.312, 0.010> <-0.316, 0.306, 0.010> <-0.317, 0.301, 0.010> 
		<-0.314, 0.316, 0.001> <-0.316, 0.312, 0.001> <-0.317, 0.306, 0.000> <-0.318, 0.301, 0.000> 
		<-0.313, 0.313, -0.012> <-0.314, 0.309, -0.012> <-0.311, 0.305, -0.013> <-0.310, 0.301, -0.013> 
		<-0.307, 0.311, -0.019> <-0.308, 0.307, -0.019> <-0.305, 0.303, -0.021> <-0.304, 0.299, -0.021> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.314, 0.316, 0.011> <-0.313, 0.316, 0.020> <-0.308, 0.313, 0.034> <-0.302, 0.311, 0.041> 
		<-0.315, 0.312, 0.010> <-0.314, 0.312, 0.020> <-0.309, 0.309, 0.033> <-0.302, 0.307, 0.041> 
		<-0.316, 0.306, 0.010> <-0.315, 0.306, 0.021> <-0.305, 0.305, 0.034> <-0.297, 0.302, 0.042> 
		<-0.317, 0.301, 0.010> <-0.316, 0.301, 0.021> <-0.305, 0.301, 0.034> <-0.297, 0.298, 0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.317, 0.301, 0.010> <-0.318, 0.296, 0.010> <-0.320, 0.288, 0.010> <-0.320, 0.282, 0.010> 
		<-0.318, 0.301, 0.000> <-0.319, 0.296, 0.000> <-0.321, 0.288, 0.000> <-0.321, 0.282, 0.000> 
		<-0.310, 0.301, -0.013> <-0.310, 0.295, -0.013> <-0.311, 0.287, -0.012> <-0.311, 0.282, -0.012> 
		<-0.304, 0.299, -0.021> <-0.304, 0.293, -0.021> <-0.304, 0.285, -0.019> <-0.304, 0.279, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.317, 0.301, 0.010> <-0.316, 0.301, 0.021> <-0.305, 0.301, 0.034> <-0.297, 0.298, 0.042> 
		<-0.318, 0.296, 0.010> <-0.317, 0.295, 0.021> <-0.304, 0.294, 0.033> <-0.297, 0.292, 0.041> 
		<-0.320, 0.288, 0.010> <-0.320, 0.288, 0.020> <-0.308, 0.287, 0.032> <-0.300, 0.285, 0.039> 
		<-0.320, 0.282, 0.010> <-0.320, 0.282, 0.020> <-0.308, 0.281, 0.031> <-0.301, 0.278, 0.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.295, 0.369, 0.010> <-0.299, 0.359, 0.010> <-0.300, 0.343, 0.010> <-0.304, 0.333, 0.011> 
		<-0.295, 0.369, -0.002> <-0.300, 0.359, -0.001> <-0.301, 0.343, 0.000> <-0.304, 0.333, 0.000> 
		<-0.290, 0.361, -0.016> <-0.295, 0.353, -0.016> <-0.301, 0.341, -0.016> <-0.305, 0.333, -0.016> 
		<-0.282, 0.358, -0.024> <-0.287, 0.350, -0.024> <-0.294, 0.339, -0.023> <-0.298, 0.331, -0.023> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.295, 0.369, 0.010> <-0.295, 0.369, 0.021> <-0.288, 0.362, 0.035> <-0.281, 0.358, 0.044> 
		<-0.299, 0.359, 0.010> <-0.299, 0.359, 0.021> <-0.292, 0.354, 0.035> <-0.285, 0.350, 0.044> 
		<-0.300, 0.343, 0.010> <-0.300, 0.343, 0.021> <-0.297, 0.342, 0.036> <-0.291, 0.339, 0.044> 
		<-0.304, 0.333, 0.011> <-0.303, 0.333, 0.021> <-0.301, 0.333, 0.036> <-0.295, 0.331, 0.044> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.159, 0.539, 0.010> <-0.158, 0.539, -0.007> <-0.147, 0.530, -0.027> <-0.143, 0.519, -0.039> 
		<-0.157, 0.540, 0.010> <-0.156, 0.540, -0.006> <-0.143, 0.531, -0.027> <-0.139, 0.520, -0.039> 
		<-0.155, 0.537, 0.010> <-0.152, 0.536, -0.006> <-0.139, 0.528, -0.025> <-0.135, 0.518, -0.035> 
		<-0.153, 0.535, 0.010> <-0.150, 0.535, -0.006> <-0.136, 0.527, -0.023> <-0.131, 0.517, -0.034> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.159, 0.539, 0.010> <-0.157, 0.540, 0.010> <-0.155, 0.537, 0.010> <-0.153, 0.535, 0.010> 
		<-0.161, 0.540, 0.026> <-0.158, 0.540, 0.026> <-0.157, 0.537, 0.024> <-0.155, 0.535, 0.024> 
		<-0.155, 0.531, 0.047> <-0.153, 0.532, 0.047> <-0.151, 0.528, 0.045> <-0.150, 0.527, 0.044> 
		<-0.151, 0.520, 0.058> <-0.149, 0.521, 0.058> <-0.148, 0.519, 0.055> <-0.146, 0.518, 0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.159, 0.539, 0.010> <-0.162, 0.539, 0.010> <-0.161, 0.534, 0.010> <-0.162, 0.532, 0.010> 
		<-0.158, 0.539, -0.007> <-0.160, 0.538, -0.007> <-0.159, 0.533, -0.005> <-0.161, 0.531, -0.005> 
		<-0.147, 0.530, -0.027> <-0.150, 0.530, -0.027> <-0.148, 0.525, -0.024> <-0.150, 0.523, -0.024> 
		<-0.143, 0.519, -0.039> <-0.145, 0.519, -0.039> <-0.144, 0.515, -0.035> <-0.146, 0.514, -0.034> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.159, 0.539, 0.010> <-0.161, 0.540, 0.026> <-0.155, 0.531, 0.047> <-0.151, 0.520, 0.058> 
		<-0.162, 0.539, 0.010> <-0.163, 0.539, 0.026> <-0.157, 0.530, 0.047> <-0.154, 0.519, 0.058> 
		<-0.161, 0.534, 0.010> <-0.162, 0.534, 0.024> <-0.157, 0.526, 0.044> <-0.154, 0.516, 0.055> 
		<-0.162, 0.532, 0.010> <-0.164, 0.532, 0.024> <-0.160, 0.524, 0.044> <-0.157, 0.514, 0.054> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.162, 0.532, 0.010> <-0.163, 0.530, 0.010> <-0.165, 0.530, 0.010> <-0.167, 0.530, 0.010> 
		<-0.161, 0.531, -0.005> <-0.161, 0.530, -0.005> <-0.164, 0.530, -0.005> <-0.165, 0.530, -0.005> 
		<-0.150, 0.523, -0.024> <-0.152, 0.522, -0.023> <-0.156, 0.522, -0.023> <-0.158, 0.522, -0.024> 
		<-0.146, 0.514, -0.034> <-0.148, 0.512, -0.033> <-0.152, 0.512, -0.034> <-0.155, 0.512, -0.034> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.162, 0.532, 0.010> <-0.164, 0.532, 0.024> <-0.160, 0.524, 0.044> <-0.157, 0.514, 0.054> 
		<-0.163, 0.530, 0.010> <-0.165, 0.531, 0.024> <-0.161, 0.523, 0.043> <-0.158, 0.513, 0.053> 
		<-0.165, 0.530, 0.010> <-0.166, 0.530, 0.024> <-0.163, 0.523, 0.043> <-0.161, 0.513, 0.054> 
		<-0.167, 0.530, 0.010> <-0.168, 0.530, 0.024> <-0.165, 0.522, 0.044> <-0.162, 0.513, 0.054> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.167, 0.530, 0.010> <-0.173, 0.529, 0.010> <-0.183, 0.531, 0.010> <-0.189, 0.527, 0.010> 
		<-0.165, 0.530, -0.005> <-0.172, 0.529, -0.005> <-0.182, 0.531, -0.006> <-0.188, 0.527, -0.006> 
		<-0.158, 0.522, -0.024> <-0.166, 0.521, -0.025> <-0.176, 0.523, -0.027> <-0.183, 0.520, -0.027> 
		<-0.155, 0.512, -0.034> <-0.162, 0.511, -0.035> <-0.173, 0.513, -0.039> <-0.180, 0.510, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.167, 0.530, 0.010> <-0.168, 0.530, 0.024> <-0.165, 0.522, 0.044> <-0.162, 0.513, 0.054> 
		<-0.173, 0.529, 0.010> <-0.175, 0.529, 0.024> <-0.172, 0.521, 0.045> <-0.169, 0.511, 0.055> 
		<-0.183, 0.531, 0.010> <-0.184, 0.531, 0.025> <-0.182, 0.523, 0.047> <-0.179, 0.513, 0.059> 
		<-0.189, 0.527, 0.010> <-0.190, 0.527, 0.026> <-0.188, 0.520, 0.047> <-0.185, 0.510, 0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.266, 0.447, 0.009> <-0.266, 0.447, -0.004> <-0.262, 0.441, -0.023> <-0.255, 0.435, -0.033> 
		<-0.261, 0.456, 0.009> <-0.261, 0.456, -0.004> <-0.259, 0.450, -0.023> <-0.252, 0.444, -0.032> 
		<-0.255, 0.468, 0.010> <-0.256, 0.468, -0.002> <-0.257, 0.464, -0.019> <-0.252, 0.458, -0.028> 
		<-0.249, 0.475, 0.010> <-0.250, 0.475, -0.002> <-0.251, 0.471, -0.019> <-0.246, 0.465, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.266, 0.447, 0.009> <-0.261, 0.456, 0.009> <-0.255, 0.468, 0.010> <-0.249, 0.475, 0.010> 
		<-0.266, 0.447, 0.023> <-0.261, 0.456, 0.023> <-0.254, 0.468, 0.022> <-0.247, 0.475, 0.022> 
		<-0.263, 0.442, 0.042> <-0.258, 0.451, 0.042> <-0.251, 0.463, 0.039> <-0.244, 0.471, 0.039> 
		<-0.257, 0.435, 0.052> <-0.251, 0.445, 0.052> <-0.245, 0.457, 0.048> <-0.238, 0.465, 0.048> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.266, 0.447, 0.009> <-0.270, 0.440, 0.009> <-0.275, 0.431, 0.010> <-0.277, 0.423, 0.010> 
		<-0.266, 0.447, -0.004> <-0.269, 0.440, -0.004> <-0.274, 0.431, -0.003> <-0.276, 0.423, -0.003> 
		<-0.262, 0.441, -0.023> <-0.264, 0.434, -0.023> <-0.267, 0.425, -0.022> <-0.269, 0.418, -0.021> 
		<-0.255, 0.435, -0.033> <-0.257, 0.428, -0.033> <-0.260, 0.419, -0.031> <-0.262, 0.412, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.266, 0.447, 0.009> <-0.266, 0.447, 0.023> <-0.263, 0.442, 0.042> <-0.257, 0.435, 0.052> 
		<-0.270, 0.440, 0.009> <-0.270, 0.440, 0.023> <-0.267, 0.435, 0.042> <-0.260, 0.428, 0.052> 
		<-0.275, 0.431, 0.010> <-0.276, 0.431, 0.022> <-0.273, 0.425, 0.041> <-0.266, 0.419, 0.050> 
		<-0.277, 0.423, 0.010> <-0.278, 0.423, 0.022> <-0.275, 0.418, 0.040> <-0.268, 0.412, 0.049> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.277, 0.423, 0.010> <-0.280, 0.416, 0.010> <-0.282, 0.407, 0.010> <-0.283, 0.400, 0.009> 
		<-0.276, 0.423, -0.003> <-0.279, 0.416, -0.003> <-0.282, 0.407, -0.002> <-0.283, 0.400, -0.002> 
		<-0.269, 0.418, -0.021> <-0.272, 0.411, -0.020> <-0.276, 0.400, -0.020> <-0.278, 0.393, -0.018> 
		<-0.262, 0.412, -0.030> <-0.264, 0.405, -0.029> <-0.268, 0.396, -0.028> <-0.270, 0.389, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.277, 0.423, 0.010> <-0.278, 0.423, 0.022> <-0.275, 0.418, 0.040> <-0.268, 0.412, 0.049> 
		<-0.280, 0.416, 0.010> <-0.281, 0.416, 0.022> <-0.277, 0.411, 0.039> <-0.270, 0.405, 0.047> 
		<-0.282, 0.407, 0.010> <-0.283, 0.407, 0.021> <-0.279, 0.399, 0.039> <-0.271, 0.395, 0.046> 
		<-0.283, 0.400, 0.009> <-0.283, 0.400, 0.021> <-0.279, 0.392, 0.037> <-0.271, 0.388, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.210, 0.507, 0.011> <-0.209, 0.507, -0.003> <-0.202, 0.502, -0.023> <-0.199, 0.492, -0.032> 
		<-0.203, 0.513, 0.011> <-0.202, 0.513, -0.003> <-0.196, 0.506, -0.024> <-0.192, 0.497, -0.034> 
		<-0.197, 0.523, 0.010> <-0.196, 0.523, -0.006> <-0.191, 0.516, -0.027> <-0.187, 0.506, -0.038> 
		<-0.189, 0.527, 0.010> <-0.188, 0.527, -0.006> <-0.183, 0.520, -0.027> <-0.180, 0.510, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.210, 0.507, 0.011> <-0.203, 0.513, 0.011> <-0.197, 0.523, 0.010> <-0.189, 0.527, 0.010> 
		<-0.211, 0.507, 0.024> <-0.205, 0.513, 0.024> <-0.198, 0.523, 0.026> <-0.190, 0.527, 0.026> 
		<-0.211, 0.501, 0.043> <-0.204, 0.506, 0.044> <-0.196, 0.516, 0.047> <-0.188, 0.520, 0.047> 
		<-0.207, 0.492, 0.052> <-0.200, 0.498, 0.053> <-0.193, 0.506, 0.058> <-0.185, 0.510, 0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.210, 0.507, 0.011> <-0.221, 0.497, 0.011> <-0.238, 0.486, 0.010> <-0.249, 0.475, 0.010> 
		<-0.209, 0.507, -0.003> <-0.220, 0.497, -0.003> <-0.239, 0.486, -0.002> <-0.250, 0.475, -0.002> 
		<-0.202, 0.502, -0.023> <-0.216, 0.493, -0.020> <-0.239, 0.482, -0.019> <-0.251, 0.471, -0.019> 
		<-0.199, 0.492, -0.032> <-0.212, 0.483, -0.030> <-0.234, 0.477, -0.028> <-0.246, 0.465, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.210, 0.507, 0.011> <-0.211, 0.507, 0.024> <-0.211, 0.501, 0.043> <-0.207, 0.492, 0.052> 
		<-0.221, 0.497, 0.011> <-0.222, 0.497, 0.024> <-0.220, 0.493, 0.041> <-0.216, 0.484, 0.050> 
		<-0.238, 0.486, 0.010> <-0.237, 0.486, 0.022> <-0.235, 0.481, 0.039> <-0.230, 0.475, 0.048> 
		<-0.249, 0.475, 0.010> <-0.247, 0.475, 0.022> <-0.244, 0.471, 0.039> <-0.238, 0.465, 0.048> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.146, 0.518, 0.053> <-0.142, 0.508, 0.064> <-0.133, 0.490, 0.072> <-0.128, 0.477, 0.072> 
		<-0.148, 0.519, 0.055> <-0.144, 0.509, 0.065> <-0.136, 0.490, 0.074> <-0.131, 0.476, 0.074> 
		<-0.149, 0.521, 0.058> <-0.145, 0.511, 0.069> <-0.138, 0.490, 0.078> <-0.134, 0.475, 0.078> 
		<-0.151, 0.520, 0.058> <-0.147, 0.510, 0.069> <-0.142, 0.489, 0.078> <-0.137, 0.474, 0.078> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.128, 0.477, 0.072> <-0.123, 0.463, 0.072> <-0.119, 0.444, 0.064> <-0.116, 0.435, 0.054> 
		<-0.131, 0.476, 0.074> <-0.126, 0.463, 0.074> <-0.121, 0.443, 0.066> <-0.118, 0.433, 0.056> 
		<-0.134, 0.475, 0.078> <-0.129, 0.460, 0.078> <-0.123, 0.440, 0.070> <-0.119, 0.430, 0.059> 
		<-0.137, 0.474, 0.078> <-0.132, 0.460, 0.078> <-0.126, 0.439, 0.070> <-0.122, 0.429, 0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.116, 0.435, 0.054> <-0.113, 0.425, 0.044> <-0.108, 0.418, 0.024> <-0.109, 0.418, 0.010> 
		<-0.118, 0.433, 0.056> <-0.115, 0.424, 0.045> <-0.110, 0.416, 0.024> <-0.111, 0.416, 0.010> 
		<-0.119, 0.430, 0.059> <-0.116, 0.419, 0.047> <-0.111, 0.411, 0.026> <-0.112, 0.411, 0.010> 
		<-0.122, 0.429, 0.059> <-0.118, 0.418, 0.047> <-0.114, 0.411, 0.026> <-0.115, 0.411, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.109, 0.418, 0.010> <-0.110, 0.418, -0.005> <-0.119, 0.425, -0.024> <-0.121, 0.435, -0.035> 
		<-0.111, 0.416, 0.010> <-0.112, 0.416, -0.005> <-0.120, 0.423, -0.026> <-0.123, 0.433, -0.036> 
		<-0.112, 0.411, 0.010> <-0.112, 0.411, -0.006> <-0.120, 0.419, -0.028> <-0.123, 0.430, -0.040> 
		<-0.115, 0.411, 0.010> <-0.115, 0.411, -0.006> <-0.122, 0.418, -0.028> <-0.125, 0.429, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.121, 0.435, -0.035> <-0.124, 0.444, -0.045> <-0.124, 0.464, -0.053> <-0.126, 0.477, -0.052> 
		<-0.123, 0.433, -0.036> <-0.125, 0.443, -0.046> <-0.126, 0.463, -0.054> <-0.128, 0.476, -0.054> 
		<-0.123, 0.430, -0.040> <-0.126, 0.440, -0.050> <-0.128, 0.461, -0.059> <-0.131, 0.476, -0.059> 
		<-0.125, 0.429, -0.040> <-0.128, 0.439, -0.050> <-0.131, 0.460, -0.059> <-0.133, 0.475, -0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.126, 0.477, -0.052> <-0.127, 0.490, -0.052> <-0.127, 0.508, -0.043> <-0.131, 0.517, -0.034> 
		<-0.128, 0.476, -0.054> <-0.130, 0.490, -0.054> <-0.131, 0.509, -0.045> <-0.135, 0.518, -0.035> 
		<-0.131, 0.476, -0.059> <-0.133, 0.491, -0.059> <-0.135, 0.510, -0.049> <-0.139, 0.520, -0.039> 
		<-0.133, 0.475, -0.059> <-0.136, 0.490, -0.058> <-0.139, 0.510, -0.049> <-0.143, 0.519, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.151, 0.520, 0.058> <-0.147, 0.510, 0.069> <-0.142, 0.489, 0.078> <-0.137, 0.474, 0.078> 
		<-0.154, 0.519, 0.058> <-0.150, 0.509, 0.069> <-0.144, 0.489, 0.078> <-0.140, 0.474, 0.078> 
		<-0.154, 0.516, 0.055> <-0.151, 0.506, 0.065> <-0.145, 0.487, 0.073> <-0.141, 0.473, 0.073> 
		<-0.157, 0.514, 0.054> <-0.154, 0.505, 0.064> <-0.148, 0.486, 0.072> <-0.144, 0.473, 0.072> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.137, 0.474, 0.078> <-0.132, 0.460, 0.078> <-0.126, 0.439, 0.070> <-0.122, 0.429, 0.059> 
		<-0.140, 0.474, 0.078> <-0.135, 0.459, 0.078> <-0.128, 0.439, 0.070> <-0.125, 0.428, 0.058> 
		<-0.141, 0.473, 0.073> <-0.137, 0.460, 0.073> <-0.130, 0.441, 0.065> <-0.128, 0.431, 0.055> 
		<-0.144, 0.473, 0.072> <-0.139, 0.459, 0.072> <-0.133, 0.441, 0.064> <-0.130, 0.431, 0.054> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.122, 0.429, 0.059> <-0.118, 0.418, 0.047> <-0.114, 0.411, 0.026> <-0.115, 0.411, 0.010> 
		<-0.125, 0.428, 0.058> <-0.121, 0.418, 0.047> <-0.118, 0.410, 0.025> <-0.118, 0.410, 0.010> 
		<-0.128, 0.431, 0.055> <-0.125, 0.422, 0.045> <-0.122, 0.414, 0.024> <-0.122, 0.414, 0.010> 
		<-0.130, 0.431, 0.054> <-0.127, 0.422, 0.044> <-0.125, 0.414, 0.024> <-0.126, 0.414, 0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.115, 0.411, 0.010> <-0.115, 0.411, -0.006> <-0.122, 0.418, -0.028> <-0.125, 0.429, -0.040> 
		<-0.118, 0.410, 0.010> <-0.119, 0.410, -0.006> <-0.125, 0.418, -0.028> <-0.128, 0.428, -0.040> 
		<-0.122, 0.414, 0.010> <-0.123, 0.414, -0.005> <-0.128, 0.422, -0.026> <-0.130, 0.432, -0.036> 
		<-0.126, 0.414, 0.009> <-0.126, 0.414, -0.005> <-0.131, 0.422, -0.025> <-0.133, 0.432, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.125, 0.429, -0.040> <-0.128, 0.439, -0.050> <-0.131, 0.460, -0.059> <-0.133, 0.475, -0.059> 
		<-0.128, 0.428, -0.040> <-0.131, 0.439, -0.050> <-0.133, 0.460, -0.059> <-0.136, 0.474, -0.059> 
		<-0.130, 0.432, -0.036> <-0.132, 0.441, -0.046> <-0.134, 0.460, -0.054> <-0.137, 0.474, -0.053> 
		<-0.133, 0.432, -0.035> <-0.135, 0.441, -0.045> <-0.137, 0.460, -0.053> <-0.139, 0.473, -0.052> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.133, 0.475, -0.059> <-0.136, 0.490, -0.058> <-0.139, 0.510, -0.049> <-0.143, 0.519, -0.039> 
		<-0.136, 0.474, -0.059> <-0.139, 0.489, -0.058> <-0.141, 0.509, -0.049> <-0.145, 0.519, -0.039> 
		<-0.137, 0.474, -0.053> <-0.139, 0.487, -0.053> <-0.141, 0.506, -0.044> <-0.144, 0.515, -0.035> 
		<-0.139, 0.473, -0.052> <-0.141, 0.487, -0.052> <-0.143, 0.505, -0.044> <-0.146, 0.514, -0.034> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.157, 0.514, 0.054> <-0.154, 0.505, 0.064> <-0.148, 0.486, 0.072> <-0.144, 0.473, 0.072> 
		<-0.158, 0.513, 0.053> <-0.155, 0.504, 0.063> <-0.150, 0.486, 0.071> <-0.145, 0.472, 0.071> 
		<-0.161, 0.513, 0.054> <-0.158, 0.503, 0.064> <-0.152, 0.485, 0.071> <-0.148, 0.471, 0.071> 
		<-0.162, 0.513, 0.054> <-0.160, 0.503, 0.064> <-0.154, 0.484, 0.072> <-0.150, 0.471, 0.072> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.144, 0.473, 0.072> <-0.139, 0.459, 0.072> <-0.133, 0.441, 0.064> <-0.130, 0.431, 0.054> 
		<-0.145, 0.472, 0.071> <-0.141, 0.459, 0.071> <-0.135, 0.441, 0.063> <-0.132, 0.431, 0.053> 
		<-0.148, 0.471, 0.071> <-0.144, 0.458, 0.071> <-0.138, 0.440, 0.064> <-0.135, 0.430, 0.054> 
		<-0.150, 0.471, 0.072> <-0.146, 0.457, 0.072> <-0.140, 0.439, 0.064> <-0.138, 0.429, 0.054> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.130, 0.431, 0.054> <-0.127, 0.422, 0.044> <-0.125, 0.414, 0.024> <-0.126, 0.414, 0.009> 
		<-0.132, 0.431, 0.053> <-0.130, 0.422, 0.043> <-0.128, 0.414, 0.024> <-0.128, 0.414, 0.009> 
		<-0.135, 0.430, 0.054> <-0.133, 0.420, 0.043> <-0.131, 0.413, 0.024> <-0.132, 0.413, 0.009> 
		<-0.138, 0.429, 0.054> <-0.135, 0.420, 0.044> <-0.134, 0.412, 0.024> <-0.134, 0.412, 0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.126, 0.414, 0.009> <-0.126, 0.414, -0.005> <-0.131, 0.422, -0.025> <-0.133, 0.432, -0.035> 
		<-0.128, 0.414, 0.009> <-0.129, 0.414, -0.005> <-0.133, 0.422, -0.024> <-0.135, 0.432, -0.035> 
		<-0.132, 0.413, 0.009> <-0.132, 0.413, -0.005> <-0.136, 0.421, -0.025> <-0.138, 0.430, -0.035> 
		<-0.134, 0.412, 0.009> <-0.134, 0.412, -0.005> <-0.138, 0.420, -0.025> <-0.140, 0.430, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.133, 0.432, -0.035> <-0.135, 0.441, -0.045> <-0.137, 0.460, -0.053> <-0.139, 0.473, -0.052> 
		<-0.135, 0.432, -0.035> <-0.137, 0.441, -0.044> <-0.139, 0.459, -0.052> <-0.141, 0.473, -0.051> 
		<-0.138, 0.430, -0.035> <-0.140, 0.440, -0.045> <-0.142, 0.458, -0.052> <-0.144, 0.472, -0.052> 
		<-0.140, 0.430, -0.035> <-0.142, 0.439, -0.045> <-0.144, 0.458, -0.053> <-0.146, 0.471, -0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.139, 0.473, -0.052> <-0.141, 0.487, -0.052> <-0.143, 0.505, -0.044> <-0.146, 0.514, -0.034> 
		<-0.141, 0.473, -0.051> <-0.143, 0.486, -0.051> <-0.145, 0.503, -0.043> <-0.148, 0.512, -0.033> 
		<-0.144, 0.472, -0.052> <-0.147, 0.485, -0.052> <-0.149, 0.503, -0.043> <-0.152, 0.512, -0.034> 
		<-0.146, 0.471, -0.053> <-0.149, 0.485, -0.052> <-0.151, 0.503, -0.044> <-0.155, 0.512, -0.034> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.162, 0.513, 0.054> <-0.160, 0.503, 0.064> <-0.154, 0.484, 0.072> <-0.150, 0.471, 0.072> 
		<-0.169, 0.511, 0.055> <-0.166, 0.502, 0.065> <-0.160, 0.483, 0.073> <-0.156, 0.470, 0.073> 
		<-0.179, 0.513, 0.059> <-0.175, 0.503, 0.070> <-0.169, 0.483, 0.079> <-0.163, 0.469, 0.079> 
		<-0.185, 0.510, 0.059> <-0.182, 0.500, 0.070> <-0.174, 0.481, 0.078> <-0.169, 0.467, 0.078> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.150, 0.471, 0.072> <-0.146, 0.457, 0.072> <-0.140, 0.439, 0.064> <-0.138, 0.429, 0.054> 
		<-0.156, 0.470, 0.073> <-0.152, 0.456, 0.073> <-0.144, 0.438, 0.065> <-0.142, 0.428, 0.055> 
		<-0.163, 0.469, 0.079> <-0.158, 0.455, 0.079> <-0.150, 0.436, 0.072> <-0.147, 0.426, 0.061> 
		<-0.169, 0.467, 0.078> <-0.163, 0.453, 0.078> <-0.154, 0.434, 0.070> <-0.150, 0.424, 0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.138, 0.429, 0.054> <-0.135, 0.420, 0.044> <-0.134, 0.412, 0.024> <-0.134, 0.412, 0.009> 
		<-0.142, 0.428, 0.055> <-0.139, 0.418, 0.045> <-0.138, 0.411, 0.024> <-0.139, 0.411, 0.009> 
		<-0.147, 0.426, 0.061> <-0.144, 0.416, 0.049> <-0.145, 0.409, 0.025> <-0.145, 0.409, 0.010> 
		<-0.150, 0.424, 0.059> <-0.147, 0.414, 0.047> <-0.149, 0.407, 0.025> <-0.149, 0.407, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.134, 0.412, 0.009> <-0.134, 0.412, -0.005> <-0.138, 0.420, -0.025> <-0.140, 0.430, -0.035> 
		<-0.139, 0.411, 0.009> <-0.139, 0.411, -0.005> <-0.142, 0.418, -0.026> <-0.144, 0.428, -0.036> 
		<-0.145, 0.409, 0.010> <-0.146, 0.409, -0.006> <-0.146, 0.415, -0.030> <-0.150, 0.426, -0.042> 
		<-0.149, 0.407, 0.010> <-0.150, 0.407, -0.006> <-0.151, 0.414, -0.028> <-0.154, 0.424, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.140, 0.430, -0.035> <-0.142, 0.439, -0.045> <-0.144, 0.458, -0.053> <-0.146, 0.471, -0.053> 
		<-0.144, 0.428, -0.036> <-0.146, 0.438, -0.046> <-0.151, 0.457, -0.054> <-0.153, 0.470, -0.054> 
		<-0.150, 0.426, -0.042> <-0.153, 0.435, -0.053> <-0.158, 0.456, -0.060> <-0.162, 0.470, -0.060> 
		<-0.154, 0.424, -0.040> <-0.157, 0.434, -0.051> <-0.164, 0.453, -0.059> <-0.169, 0.467, -0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.146, 0.471, -0.053> <-0.149, 0.485, -0.052> <-0.151, 0.503, -0.044> <-0.155, 0.512, -0.034> 
		<-0.153, 0.470, -0.054> <-0.156, 0.483, -0.054> <-0.159, 0.502, -0.045> <-0.162, 0.511, -0.035> 
		<-0.162, 0.470, -0.060> <-0.166, 0.484, -0.060> <-0.170, 0.503, -0.049> <-0.173, 0.513, -0.039> 
		<-0.169, 0.467, -0.059> <-0.173, 0.481, -0.059> <-0.177, 0.500, -0.049> <-0.180, 0.510, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.185, 0.510, 0.059> <-0.182, 0.500, 0.070> <-0.174, 0.481, 0.078> <-0.169, 0.467, 0.078> 
		<-0.193, 0.506, 0.058> <-0.190, 0.496, 0.069> <-0.181, 0.478, 0.077> <-0.176, 0.464, 0.077> 
		<-0.200, 0.498, 0.053> <-0.196, 0.489, 0.063> <-0.187, 0.470, 0.068> <-0.181, 0.459, 0.066> 
		<-0.207, 0.492, 0.052> <-0.203, 0.483, 0.061> <-0.193, 0.465, 0.068> <-0.186, 0.454, 0.066> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.169, 0.467, 0.078> <-0.163, 0.453, 0.078> <-0.154, 0.434, 0.070> <-0.150, 0.424, 0.059> 
		<-0.176, 0.464, 0.077> <-0.170, 0.450, 0.077> <-0.160, 0.432, 0.066> <-0.156, 0.422, 0.055> 
		<-0.181, 0.459, 0.066> <-0.173, 0.446, 0.064> <-0.165, 0.434, 0.046> <-0.159, 0.424, 0.036> 
		<-0.186, 0.454, 0.066> <-0.179, 0.441, 0.064> <-0.169, 0.428, 0.048> <-0.164, 0.418, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.150, 0.424, 0.059> <-0.147, 0.414, 0.047> <-0.149, 0.407, 0.025> <-0.149, 0.407, 0.010> 
		<-0.156, 0.422, 0.055> <-0.153, 0.412, 0.044> <-0.151, 0.405, 0.026> <-0.152, 0.405, 0.010> 
		<-0.159, 0.424, 0.036> <-0.155, 0.417, 0.029> <-0.152, 0.401, 0.021> <-0.154, 0.401, 0.010> 
		<-0.164, 0.418, 0.039> <-0.160, 0.411, 0.032> <-0.153, 0.398, 0.021> <-0.154, 0.398, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.149, 0.407, 0.010> <-0.150, 0.407, -0.006> <-0.151, 0.414, -0.028> <-0.154, 0.424, -0.040> 
		<-0.152, 0.405, 0.010> <-0.152, 0.405, -0.006> <-0.158, 0.411, -0.024> <-0.161, 0.421, -0.036> 
		<-0.154, 0.401, 0.010> <-0.156, 0.401, -0.001> <-0.163, 0.417, -0.008> <-0.168, 0.424, -0.015> 
		<-0.154, 0.398, 0.010> <-0.156, 0.398, -0.001> <-0.169, 0.410, -0.010> <-0.174, 0.418, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.154, 0.424, -0.040> <-0.157, 0.434, -0.051> <-0.164, 0.453, -0.059> <-0.169, 0.467, -0.059> 
		<-0.161, 0.421, -0.036> <-0.165, 0.431, -0.047> <-0.172, 0.450, -0.058> <-0.176, 0.464, -0.058> 
		<-0.168, 0.424, -0.015> <-0.174, 0.433, -0.025> <-0.179, 0.445, -0.045> <-0.183, 0.459, -0.047> 
		<-0.174, 0.418, -0.018> <-0.180, 0.427, -0.028> <-0.185, 0.440, -0.044> <-0.190, 0.454, -0.047> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.169, 0.467, -0.059> <-0.173, 0.481, -0.059> <-0.177, 0.500, -0.049> <-0.180, 0.510, -0.039> 
		<-0.176, 0.464, -0.058> <-0.181, 0.478, -0.058> <-0.184, 0.497, -0.049> <-0.187, 0.506, -0.038> 
		<-0.183, 0.459, -0.047> <-0.187, 0.471, -0.050> <-0.189, 0.488, -0.043> <-0.192, 0.497, -0.034> 
		<-0.190, 0.454, -0.047> <-0.194, 0.466, -0.049> <-0.196, 0.484, -0.042> <-0.199, 0.492, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.207, 0.492, 0.052> <-0.203, 0.483, 0.061> <-0.193, 0.465, 0.068> <-0.186, 0.454, 0.066> 
		<-0.216, 0.484, 0.050> <-0.212, 0.475, 0.060> <-0.201, 0.459, 0.067> <-0.194, 0.447, 0.065> 
		<-0.230, 0.475, 0.048> <-0.223, 0.467, 0.060> <-0.213, 0.451, 0.072> <-0.204, 0.440, 0.075> 
		<-0.238, 0.465, 0.048> <-0.232, 0.458, 0.060> <-0.220, 0.444, 0.071> <-0.211, 0.433, 0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.186, 0.454, 0.066> <-0.179, 0.441, 0.064> <-0.169, 0.428, 0.048> <-0.164, 0.418, 0.039> 
		<-0.194, 0.447, 0.065> <-0.187, 0.435, 0.063> <-0.177, 0.418, 0.053> <-0.172, 0.409, 0.043> 
		<-0.204, 0.440, 0.075> <-0.193, 0.428, 0.079> <-0.174, 0.411, 0.082> <-0.166, 0.402, 0.072> 
		<-0.211, 0.433, 0.075> <-0.201, 0.421, 0.079> <-0.184, 0.402, 0.083> <-0.175, 0.393, 0.073> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.164, 0.418, 0.039> <-0.160, 0.411, 0.032> <-0.153, 0.398, 0.021> <-0.154, 0.398, 0.010> 
		<-0.172, 0.409, 0.043> <-0.167, 0.402, 0.036> <-0.154, 0.391, 0.021> <-0.156, 0.391, 0.010> 
		<-0.166, 0.402, 0.072> <-0.155, 0.390, 0.059> <-0.150, 0.380, 0.031> <-0.151, 0.380, 0.011> 
		<-0.175, 0.393, 0.073> <-0.164, 0.381, 0.060> <-0.154, 0.374, 0.031> <-0.155, 0.374, 0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.154, 0.398, 0.010> <-0.156, 0.398, -0.001> <-0.169, 0.410, -0.010> <-0.174, 0.418, -0.018> 
		<-0.156, 0.391, 0.010> <-0.158, 0.391, -0.001> <-0.177, 0.401, -0.014> <-0.182, 0.408, -0.022> 
		<-0.151, 0.380, 0.011> <-0.152, 0.380, -0.011> <-0.161, 0.390, -0.039> <-0.172, 0.402, -0.052> 
		<-0.155, 0.374, 0.011> <-0.156, 0.374, -0.011> <-0.170, 0.381, -0.039> <-0.181, 0.392, -0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.174, 0.418, -0.018> <-0.180, 0.427, -0.028> <-0.185, 0.440, -0.044> <-0.190, 0.454, -0.047> 
		<-0.182, 0.408, -0.022> <-0.188, 0.418, -0.032> <-0.192, 0.434, -0.044> <-0.197, 0.448, -0.047> 
		<-0.172, 0.402, -0.052> <-0.180, 0.410, -0.062> <-0.195, 0.429, -0.060> <-0.205, 0.440, -0.056> 
		<-0.181, 0.392, -0.053> <-0.189, 0.401, -0.062> <-0.201, 0.422, -0.060> <-0.211, 0.433, -0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.190, 0.454, -0.047> <-0.194, 0.466, -0.049> <-0.196, 0.484, -0.042> <-0.199, 0.492, -0.032> 
		<-0.197, 0.448, -0.047> <-0.201, 0.460, -0.049> <-0.209, 0.475, -0.039> <-0.212, 0.483, -0.030> 
		<-0.205, 0.440, -0.056> <-0.215, 0.452, -0.052> <-0.227, 0.469, -0.040> <-0.234, 0.477, -0.028> 
		<-0.211, 0.433, -0.056> <-0.221, 0.445, -0.052> <-0.238, 0.457, -0.041> <-0.246, 0.465, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.238, 0.465, 0.048> <-0.232, 0.458, 0.060> <-0.220, 0.444, 0.071> <-0.211, 0.433, 0.075> 
		<-0.245, 0.457, 0.048> <-0.239, 0.450, 0.060> <-0.227, 0.437, 0.071> <-0.217, 0.426, 0.075> 
		<-0.251, 0.445, 0.052> <-0.246, 0.439, 0.061> <-0.234, 0.427, 0.068> <-0.225, 0.419, 0.067> 
		<-0.257, 0.435, 0.052> <-0.251, 0.430, 0.061> <-0.238, 0.418, 0.066> <-0.229, 0.411, 0.065> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.211, 0.433, 0.075> <-0.201, 0.421, 0.079> <-0.184, 0.402, 0.083> <-0.175, 0.393, 0.073> 
		<-0.217, 0.426, 0.075> <-0.207, 0.415, 0.079> <-0.193, 0.394, 0.083> <-0.184, 0.385, 0.073> 
		<-0.225, 0.419, 0.067> <-0.215, 0.410, 0.064> <-0.201, 0.397, 0.056> <-0.192, 0.392, 0.047> 
		<-0.229, 0.411, 0.065> <-0.219, 0.402, 0.063> <-0.209, 0.390, 0.049> <-0.199, 0.385, 0.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.175, 0.393, 0.073> <-0.164, 0.381, 0.060> <-0.154, 0.374, 0.031> <-0.155, 0.374, 0.011> 
		<-0.184, 0.385, 0.073> <-0.173, 0.373, 0.061> <-0.157, 0.371, 0.031> <-0.158, 0.371, 0.011> 
		<-0.192, 0.392, 0.047> <-0.183, 0.387, 0.039> <-0.164, 0.380, 0.024> <-0.165, 0.380, 0.011> 
		<-0.199, 0.385, 0.041> <-0.190, 0.380, 0.033> <-0.168, 0.378, 0.024> <-0.169, 0.378, 0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.155, 0.374, 0.011> <-0.156, 0.374, -0.011> <-0.170, 0.381, -0.039> <-0.181, 0.392, -0.053> 
		<-0.158, 0.371, 0.011> <-0.159, 0.371, -0.011> <-0.178, 0.372, -0.040> <-0.189, 0.384, -0.054> 
		<-0.165, 0.380, 0.011> <-0.166, 0.380, -0.003> <-0.188, 0.388, -0.019> <-0.197, 0.393, -0.028> 
		<-0.169, 0.378, 0.011> <-0.170, 0.378, -0.003> <-0.194, 0.380, -0.011> <-0.203, 0.385, -0.020> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.181, 0.392, -0.053> <-0.189, 0.401, -0.062> <-0.201, 0.422, -0.060> <-0.211, 0.433, -0.056> 
		<-0.189, 0.384, -0.054> <-0.197, 0.392, -0.063> <-0.207, 0.415, -0.060> <-0.216, 0.426, -0.056> 
		<-0.197, 0.393, -0.028> <-0.206, 0.398, -0.036> <-0.213, 0.410, -0.046> <-0.223, 0.418, -0.049> 
		<-0.203, 0.385, -0.020> <-0.212, 0.390, -0.029> <-0.217, 0.402, -0.045> <-0.226, 0.411, -0.047> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.211, 0.433, -0.056> <-0.221, 0.445, -0.052> <-0.238, 0.457, -0.041> <-0.246, 0.465, -0.028> 
		<-0.216, 0.426, -0.056> <-0.227, 0.438, -0.052> <-0.245, 0.450, -0.041> <-0.252, 0.458, -0.028> 
		<-0.223, 0.418, -0.049> <-0.231, 0.427, -0.051> <-0.246, 0.438, -0.041> <-0.252, 0.444, -0.032> 
		<-0.226, 0.411, -0.047> <-0.234, 0.419, -0.049> <-0.248, 0.429, -0.041> <-0.255, 0.435, -0.033> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.257, 0.435, 0.052> <-0.251, 0.430, 0.061> <-0.238, 0.418, 0.066> <-0.229, 0.411, 0.065> 
		<-0.260, 0.428, 0.052> <-0.255, 0.423, 0.061> <-0.241, 0.412, 0.065> <-0.232, 0.404, 0.063> 
		<-0.266, 0.419, 0.050> <-0.258, 0.413, 0.059> <-0.243, 0.401, 0.065> <-0.232, 0.393, 0.065> 
		<-0.268, 0.412, 0.049> <-0.260, 0.405, 0.058> <-0.244, 0.393, 0.064> <-0.233, 0.385, 0.064> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.229, 0.411, 0.065> <-0.219, 0.402, 0.063> <-0.209, 0.390, 0.049> <-0.199, 0.385, 0.041> 
		<-0.232, 0.404, 0.063> <-0.222, 0.395, 0.061> <-0.213, 0.387, 0.046> <-0.203, 0.382, 0.038> 
		<-0.232, 0.393, 0.065> <-0.222, 0.387, 0.066> <-0.211, 0.376, 0.056> <-0.203, 0.373, 0.048> 
		<-0.233, 0.385, 0.064> <-0.224, 0.379, 0.064> <-0.212, 0.370, 0.057> <-0.204, 0.367, 0.049> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.199, 0.385, 0.041> <-0.190, 0.380, 0.033> <-0.168, 0.378, 0.024> <-0.169, 0.378, 0.011> 
		<-0.203, 0.382, 0.038> <-0.194, 0.377, 0.030> <-0.173, 0.376, 0.024> <-0.174, 0.376, 0.010> 
		<-0.203, 0.373, 0.048> <-0.194, 0.370, 0.038> <-0.178, 0.369, 0.024> <-0.178, 0.369, 0.010> 
		<-0.204, 0.367, 0.049> <-0.195, 0.364, 0.040> <-0.181, 0.364, 0.024> <-0.180, 0.364, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.169, 0.378, 0.011> <-0.170, 0.378, -0.003> <-0.194, 0.380, -0.011> <-0.203, 0.385, -0.020> 
		<-0.174, 0.376, 0.010> <-0.175, 0.376, -0.004> <-0.197, 0.376, -0.008> <-0.206, 0.382, -0.017> 
		<-0.178, 0.369, 0.010> <-0.177, 0.369, -0.003> <-0.193, 0.369, -0.018> <-0.202, 0.373, -0.027> 
		<-0.180, 0.364, 0.010> <-0.179, 0.364, -0.003> <-0.192, 0.363, -0.019> <-0.200, 0.367, -0.029> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.203, 0.385, -0.020> <-0.212, 0.390, -0.029> <-0.217, 0.402, -0.045> <-0.226, 0.411, -0.047> 
		<-0.206, 0.382, -0.017> <-0.214, 0.386, -0.025> <-0.220, 0.395, -0.043> <-0.229, 0.404, -0.045> 
		<-0.202, 0.373, -0.027> <-0.209, 0.376, -0.036> <-0.220, 0.387, -0.047> <-0.230, 0.394, -0.047> 
		<-0.200, 0.367, -0.029> <-0.208, 0.371, -0.037> <-0.221, 0.379, -0.045> <-0.231, 0.386, -0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.226, 0.411, -0.047> <-0.234, 0.419, -0.049> <-0.248, 0.429, -0.041> <-0.255, 0.435, -0.033> 
		<-0.229, 0.404, -0.045> <-0.237, 0.412, -0.047> <-0.251, 0.422, -0.041> <-0.257, 0.428, -0.033> 
		<-0.230, 0.394, -0.047> <-0.241, 0.401, -0.047> <-0.252, 0.413, -0.039> <-0.260, 0.419, -0.031> 
		<-0.231, 0.386, -0.046> <-0.241, 0.394, -0.046> <-0.254, 0.406, -0.039> <-0.262, 0.412, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.268, 0.412, 0.049> <-0.260, 0.405, 0.058> <-0.244, 0.393, 0.064> <-0.233, 0.385, 0.064> 
		<-0.270, 0.405, 0.047> <-0.262, 0.398, 0.057> <-0.245, 0.390, 0.064> <-0.234, 0.382, 0.064> 
		<-0.271, 0.395, 0.046> <-0.263, 0.390, 0.055> <-0.245, 0.382, 0.061> <-0.234, 0.377, 0.061> 
		<-0.271, 0.388, 0.045> <-0.263, 0.383, 0.053> <-0.247, 0.378, 0.059> <-0.235, 0.374, 0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.233, 0.385, 0.064> <-0.224, 0.379, 0.064> <-0.212, 0.370, 0.057> <-0.204, 0.367, 0.049> 
		<-0.234, 0.382, 0.064> <-0.225, 0.375, 0.064> <-0.212, 0.368, 0.057> <-0.205, 0.365, 0.050> 
		<-0.234, 0.377, 0.061> <-0.224, 0.373, 0.062> <-0.211, 0.364, 0.054> <-0.203, 0.362, 0.047> 
		<-0.235, 0.374, 0.060> <-0.225, 0.370, 0.060> <-0.212, 0.362, 0.053> <-0.204, 0.360, 0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.204, 0.367, 0.049> <-0.195, 0.364, 0.040> <-0.181, 0.364, 0.024> <-0.180, 0.364, 0.010> 
		<-0.205, 0.365, 0.050> <-0.196, 0.361, 0.040> <-0.182, 0.363, 0.024> <-0.181, 0.363, 0.010> 
		<-0.203, 0.362, 0.047> <-0.193, 0.359, 0.039> <-0.180, 0.360, 0.023> <-0.178, 0.360, 0.010> 
		<-0.204, 0.360, 0.046> <-0.194, 0.357, 0.037> <-0.181, 0.359, 0.023> <-0.179, 0.359, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.180, 0.364, 0.010> <-0.179, 0.364, -0.003> <-0.192, 0.363, -0.019> <-0.200, 0.367, -0.029> 
		<-0.181, 0.363, 0.010> <-0.180, 0.363, -0.003> <-0.191, 0.361, -0.020> <-0.199, 0.365, -0.029> 
		<-0.178, 0.360, 0.010> <-0.177, 0.360, -0.001> <-0.188, 0.359, -0.019> <-0.196, 0.362, -0.027> 
		<-0.179, 0.359, 0.010> <-0.178, 0.359, -0.001> <-0.188, 0.357, -0.017> <-0.196, 0.360, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.200, 0.367, -0.029> <-0.208, 0.371, -0.037> <-0.221, 0.379, -0.045> <-0.231, 0.386, -0.046> 
		<-0.199, 0.365, -0.029> <-0.207, 0.368, -0.038> <-0.221, 0.376, -0.045> <-0.231, 0.383, -0.045> 
		<-0.196, 0.362, -0.027> <-0.204, 0.365, -0.035> <-0.218, 0.374, -0.042> <-0.229, 0.378, -0.042> 
		<-0.196, 0.360, -0.025> <-0.204, 0.362, -0.033> <-0.218, 0.370, -0.040> <-0.230, 0.375, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.231, 0.386, -0.046> <-0.241, 0.394, -0.046> <-0.254, 0.406, -0.039> <-0.262, 0.412, -0.030> 
		<-0.231, 0.383, -0.045> <-0.242, 0.390, -0.045> <-0.257, 0.399, -0.038> <-0.264, 0.405, -0.029> 
		<-0.229, 0.378, -0.042> <-0.241, 0.383, -0.043> <-0.259, 0.391, -0.037> <-0.268, 0.396, -0.028> 
		<-0.230, 0.375, -0.040> <-0.242, 0.380, -0.040> <-0.260, 0.384, -0.035> <-0.270, 0.389, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.271, 0.388, 0.045> <-0.263, 0.383, 0.053> <-0.247, 0.378, 0.059> <-0.235, 0.374, 0.060> 
		<-0.271, 0.386, 0.044> <-0.263, 0.381, 0.052> <-0.248, 0.377, 0.058> <-0.236, 0.372, 0.058> 
		<-0.269, 0.385, 0.042> <-0.263, 0.381, 0.049> <-0.248, 0.375, 0.055> <-0.239, 0.371, 0.055> 
		<-0.269, 0.383, 0.041> <-0.262, 0.379, 0.048> <-0.250, 0.374, 0.054> <-0.240, 0.370, 0.054> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.235, 0.374, 0.060> <-0.225, 0.370, 0.060> <-0.212, 0.362, 0.053> <-0.204, 0.360, 0.046> 
		<-0.236, 0.372, 0.058> <-0.226, 0.368, 0.058> <-0.213, 0.360, 0.052> <-0.205, 0.358, 0.045> 
		<-0.239, 0.371, 0.055> <-0.229, 0.367, 0.056> <-0.216, 0.361, 0.050> <-0.208, 0.359, 0.043> 
		<-0.240, 0.370, 0.054> <-0.230, 0.366, 0.055> <-0.217, 0.360, 0.049> <-0.209, 0.357, 0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.204, 0.360, 0.046> <-0.194, 0.357, 0.037> <-0.181, 0.359, 0.023> <-0.179, 0.359, 0.010> 
		<-0.205, 0.358, 0.045> <-0.195, 0.356, 0.036> <-0.182, 0.356, 0.023> <-0.181, 0.356, 0.010> 
		<-0.208, 0.359, 0.043> <-0.199, 0.356, 0.036> <-0.187, 0.354, 0.022> <-0.186, 0.354, 0.010> 
		<-0.209, 0.357, 0.042> <-0.201, 0.354, 0.035> <-0.190, 0.352, 0.022> <-0.188, 0.352, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.179, 0.359, 0.010> <-0.178, 0.359, -0.001> <-0.188, 0.357, -0.017> <-0.196, 0.360, -0.025> 
		<-0.181, 0.356, 0.010> <-0.180, 0.356, -0.001> <-0.188, 0.356, -0.016> <-0.196, 0.358, -0.024> 
		<-0.186, 0.354, 0.010> <-0.184, 0.354, 0.000> <-0.192, 0.356, -0.015> <-0.199, 0.358, -0.022> 
		<-0.188, 0.352, 0.010> <-0.187, 0.352, 0.000> <-0.193, 0.354, -0.015> <-0.200, 0.357, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.196, 0.360, -0.025> <-0.204, 0.362, -0.033> <-0.218, 0.370, -0.040> <-0.230, 0.375, -0.040> 
		<-0.196, 0.358, -0.024> <-0.204, 0.361, -0.032> <-0.219, 0.368, -0.039> <-0.230, 0.373, -0.039> 
		<-0.199, 0.358, -0.022> <-0.207, 0.362, -0.030> <-0.222, 0.368, -0.036> <-0.232, 0.372, -0.036> 
		<-0.200, 0.357, -0.022> <-0.208, 0.360, -0.029> <-0.223, 0.366, -0.035> <-0.234, 0.370, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.230, 0.375, -0.040> <-0.242, 0.380, -0.040> <-0.260, 0.384, -0.035> <-0.270, 0.389, -0.026> 
		<-0.230, 0.373, -0.039> <-0.242, 0.378, -0.039> <-0.261, 0.382, -0.034> <-0.270, 0.387, -0.026> 
		<-0.232, 0.372, -0.036> <-0.243, 0.376, -0.036> <-0.259, 0.382, -0.031> <-0.267, 0.386, -0.023> 
		<-0.234, 0.370, -0.035> <-0.244, 0.375, -0.036> <-0.259, 0.380, -0.030> <-0.267, 0.384, -0.023> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.269, 0.383, 0.041> <-0.262, 0.379, 0.048> <-0.250, 0.374, 0.054> <-0.240, 0.370, 0.054> 
		<-0.269, 0.382, 0.040> <-0.262, 0.378, 0.047> <-0.251, 0.373, 0.053> <-0.241, 0.369, 0.054> 
		<-0.270, 0.380, 0.040> <-0.264, 0.376, 0.047> <-0.252, 0.371, 0.054> <-0.243, 0.367, 0.054> 
		<-0.270, 0.379, 0.041> <-0.264, 0.375, 0.048> <-0.253, 0.370, 0.054> <-0.244, 0.366, 0.054> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.240, 0.370, 0.054> <-0.230, 0.366, 0.055> <-0.217, 0.360, 0.049> <-0.209, 0.357, 0.042> 
		<-0.241, 0.369, 0.054> <-0.231, 0.365, 0.054> <-0.218, 0.359, 0.048> <-0.210, 0.356, 0.042> 
		<-0.243, 0.367, 0.054> <-0.233, 0.363, 0.054> <-0.219, 0.357, 0.049> <-0.210, 0.354, 0.042> 
		<-0.244, 0.366, 0.054> <-0.233, 0.361, 0.055> <-0.219, 0.356, 0.049> <-0.211, 0.353, 0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.209, 0.357, 0.042> <-0.201, 0.354, 0.035> <-0.190, 0.352, 0.022> <-0.188, 0.352, 0.010> 
		<-0.210, 0.356, 0.042> <-0.201, 0.353, 0.035> <-0.191, 0.351, 0.022> <-0.189, 0.351, 0.010> 
		<-0.210, 0.354, 0.042> <-0.202, 0.352, 0.035> <-0.191, 0.349, 0.022> <-0.189, 0.349, 0.010> 
		<-0.211, 0.353, 0.042> <-0.202, 0.350, 0.035> <-0.191, 0.348, 0.022> <-0.190, 0.348, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.188, 0.352, 0.010> <-0.187, 0.352, 0.000> <-0.193, 0.354, -0.015> <-0.200, 0.357, -0.022> 
		<-0.189, 0.351, 0.010> <-0.187, 0.351, 0.000> <-0.194, 0.353, -0.014> <-0.201, 0.356, -0.021> 
		<-0.189, 0.349, 0.010> <-0.188, 0.349, 0.000> <-0.194, 0.351, -0.014> <-0.201, 0.354, -0.021> 
		<-0.190, 0.348, 0.010> <-0.188, 0.348, 0.000> <-0.194, 0.350, -0.015> <-0.201, 0.353, -0.021> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.200, 0.357, -0.022> <-0.208, 0.360, -0.029> <-0.223, 0.366, -0.035> <-0.234, 0.370, -0.035> 
		<-0.201, 0.356, -0.021> <-0.209, 0.359, -0.029> <-0.224, 0.365, -0.035> <-0.235, 0.369, -0.035> 
		<-0.201, 0.354, -0.021> <-0.209, 0.357, -0.029> <-0.225, 0.363, -0.035> <-0.237, 0.368, -0.035> 
		<-0.201, 0.353, -0.021> <-0.210, 0.356, -0.030> <-0.226, 0.362, -0.035> <-0.237, 0.366, -0.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.234, 0.370, -0.035> <-0.244, 0.375, -0.036> <-0.259, 0.380, -0.030> <-0.267, 0.384, -0.023> 
		<-0.235, 0.369, -0.035> <-0.245, 0.374, -0.035> <-0.259, 0.379, -0.029> <-0.267, 0.383, -0.022> 
		<-0.237, 0.368, -0.035> <-0.247, 0.372, -0.035> <-0.261, 0.377, -0.030> <-0.268, 0.381, -0.022> 
		<-0.237, 0.366, -0.036> <-0.248, 0.370, -0.036> <-0.261, 0.376, -0.030> <-0.269, 0.380, -0.023> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.270, 0.379, 0.041> <-0.264, 0.375, 0.048> <-0.253, 0.370, 0.054> <-0.244, 0.366, 0.054> 
		<-0.272, 0.375, 0.042> <-0.266, 0.372, 0.049> <-0.254, 0.366, 0.055> <-0.245, 0.363, 0.055> 
		<-0.274, 0.371, 0.044> <-0.268, 0.367, 0.052> <-0.255, 0.362, 0.058> <-0.246, 0.358, 0.058> 
		<-0.275, 0.368, 0.045> <-0.269, 0.364, 0.052> <-0.256, 0.359, 0.059> <-0.247, 0.355, 0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.244, 0.366, 0.054> <-0.233, 0.361, 0.055> <-0.219, 0.356, 0.049> <-0.211, 0.353, 0.042> 
		<-0.245, 0.363, 0.055> <-0.235, 0.358, 0.056> <-0.220, 0.352, 0.050> <-0.211, 0.350, 0.043> 
		<-0.246, 0.358, 0.058> <-0.235, 0.354, 0.058> <-0.222, 0.348, 0.053> <-0.213, 0.345, 0.045> 
		<-0.247, 0.355, 0.059> <-0.236, 0.350, 0.059> <-0.222, 0.344, 0.053> <-0.214, 0.341, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.211, 0.353, 0.042> <-0.202, 0.350, 0.035> <-0.191, 0.348, 0.022> <-0.190, 0.348, 0.010> 
		<-0.211, 0.350, 0.043> <-0.203, 0.347, 0.036> <-0.192, 0.344, 0.022> <-0.191, 0.344, 0.010> 
		<-0.213, 0.345, 0.045> <-0.204, 0.342, 0.037> <-0.193, 0.339, 0.023> <-0.192, 0.339, 0.010> 
		<-0.214, 0.341, 0.045> <-0.205, 0.338, 0.037> <-0.193, 0.336, 0.023> <-0.192, 0.335, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.190, 0.348, 0.010> <-0.188, 0.348, 0.000> <-0.194, 0.350, -0.015> <-0.201, 0.353, -0.021> 
		<-0.191, 0.344, 0.010> <-0.189, 0.344, 0.000> <-0.196, 0.346, -0.015> <-0.203, 0.349, -0.022> 
		<-0.192, 0.339, 0.010> <-0.190, 0.339, -0.001> <-0.197, 0.342, -0.017> <-0.205, 0.345, -0.024> 
		<-0.192, 0.335, 0.010> <-0.191, 0.335, -0.001> <-0.198, 0.338, -0.017> <-0.206, 0.341, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.201, 0.353, -0.021> <-0.210, 0.356, -0.030> <-0.226, 0.362, -0.035> <-0.237, 0.366, -0.036> 
		<-0.203, 0.349, -0.022> <-0.211, 0.353, -0.030> <-0.228, 0.358, -0.036> <-0.239, 0.363, -0.037> 
		<-0.205, 0.345, -0.024> <-0.213, 0.348, -0.033> <-0.229, 0.354, -0.039> <-0.240, 0.358, -0.039> 
		<-0.206, 0.341, -0.025> <-0.214, 0.344, -0.033> <-0.230, 0.350, -0.040> <-0.241, 0.355, -0.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.237, 0.366, -0.036> <-0.248, 0.370, -0.036> <-0.261, 0.376, -0.030> <-0.269, 0.380, -0.023> 
		<-0.239, 0.363, -0.037> <-0.249, 0.367, -0.037> <-0.263, 0.373, -0.031> <-0.271, 0.376, -0.023> 
		<-0.240, 0.358, -0.039> <-0.251, 0.363, -0.039> <-0.266, 0.368, -0.034> <-0.273, 0.372, -0.025> 
		<-0.241, 0.355, -0.041> <-0.252, 0.359, -0.041> <-0.268, 0.364, -0.034> <-0.275, 0.368, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.275, 0.368, 0.045> <-0.269, 0.364, 0.052> <-0.256, 0.359, 0.059> <-0.247, 0.355, 0.059> 
		<-0.277, 0.365, 0.045> <-0.271, 0.361, 0.053> <-0.258, 0.356, 0.061> <-0.248, 0.352, 0.061> 
		<-0.280, 0.361, 0.044> <-0.273, 0.357, 0.053> <-0.260, 0.352, 0.064> <-0.249, 0.347, 0.064> 
		<-0.281, 0.358, 0.044> <-0.274, 0.354, 0.053> <-0.262, 0.348, 0.064> <-0.251, 0.344, 0.064> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.247, 0.355, 0.059> <-0.236, 0.350, 0.059> <-0.222, 0.344, 0.053> <-0.214, 0.341, 0.045> 
		<-0.248, 0.352, 0.061> <-0.237, 0.347, 0.061> <-0.222, 0.340, 0.053> <-0.214, 0.337, 0.046> 
		<-0.249, 0.347, 0.064> <-0.236, 0.342, 0.064> <-0.222, 0.336, 0.053> <-0.212, 0.332, 0.044> 
		<-0.251, 0.344, 0.064> <-0.238, 0.338, 0.064> <-0.221, 0.332, 0.054> <-0.211, 0.328, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.214, 0.341, 0.045> <-0.205, 0.338, 0.037> <-0.193, 0.336, 0.023> <-0.192, 0.335, 0.010> 
		<-0.214, 0.337, 0.046> <-0.205, 0.334, 0.038> <-0.194, 0.331, 0.022> <-0.192, 0.331, 0.010> 
		<-0.212, 0.332, 0.044> <-0.203, 0.329, 0.036> <-0.193, 0.326, 0.022> <-0.192, 0.326, 0.010> 
		<-0.211, 0.328, 0.045> <-0.203, 0.325, 0.037> <-0.192, 0.322, 0.022> <-0.192, 0.322, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.192, 0.335, 0.010> <-0.191, 0.335, -0.001> <-0.198, 0.338, -0.017> <-0.206, 0.341, -0.025> 
		<-0.192, 0.331, 0.010> <-0.191, 0.331, -0.001> <-0.199, 0.334, -0.018> <-0.207, 0.337, -0.025> 
		<-0.192, 0.326, 0.010> <-0.192, 0.325, -0.002> <-0.199, 0.328, -0.016> <-0.207, 0.331, -0.024> 
		<-0.192, 0.322, 0.010> <-0.191, 0.321, -0.002> <-0.201, 0.324, -0.017> <-0.208, 0.328, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.206, 0.341, -0.025> <-0.214, 0.344, -0.033> <-0.230, 0.350, -0.040> <-0.241, 0.355, -0.041> 
		<-0.207, 0.337, -0.025> <-0.215, 0.340, -0.034> <-0.230, 0.347, -0.042> <-0.242, 0.351, -0.042> 
		<-0.207, 0.331, -0.024> <-0.215, 0.335, -0.033> <-0.230, 0.342, -0.045> <-0.242, 0.346, -0.045> 
		<-0.208, 0.328, -0.025> <-0.217, 0.331, -0.034> <-0.231, 0.338, -0.046> <-0.243, 0.343, -0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.241, 0.355, -0.041> <-0.252, 0.359, -0.041> <-0.268, 0.364, -0.034> <-0.275, 0.368, -0.026> 
		<-0.242, 0.351, -0.042> <-0.253, 0.355, -0.042> <-0.270, 0.361, -0.034> <-0.277, 0.365, -0.026> 
		<-0.242, 0.346, -0.045> <-0.255, 0.352, -0.045> <-0.271, 0.356, -0.034> <-0.280, 0.361, -0.024> 
		<-0.243, 0.343, -0.045> <-0.256, 0.348, -0.045> <-0.273, 0.353, -0.034> <-0.282, 0.358, -0.024> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.281, 0.358, 0.044> <-0.274, 0.354, 0.053> <-0.262, 0.348, 0.064> <-0.251, 0.344, 0.064> 
		<-0.285, 0.350, 0.044> <-0.279, 0.346, 0.052> <-0.265, 0.340, 0.065> <-0.254, 0.336, 0.065> 
		<-0.291, 0.339, 0.044> <-0.284, 0.337, 0.053> <-0.272, 0.328, 0.062> <-0.261, 0.326, 0.063> 
		<-0.295, 0.331, 0.044> <-0.288, 0.328, 0.053> <-0.275, 0.320, 0.063> <-0.264, 0.317, 0.063> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.251, 0.344, 0.064> <-0.238, 0.338, 0.064> <-0.221, 0.332, 0.054> <-0.211, 0.328, 0.045> 
		<-0.254, 0.336, 0.065> <-0.242, 0.330, 0.065> <-0.220, 0.327, 0.055> <-0.210, 0.324, 0.045> 
		<-0.261, 0.326, 0.063> <-0.244, 0.322, 0.064> <-0.220, 0.319, 0.060> <-0.206, 0.317, 0.050> 
		<-0.264, 0.317, 0.063> <-0.247, 0.314, 0.065> <-0.222, 0.315, 0.060> <-0.208, 0.313, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.211, 0.328, 0.045> <-0.203, 0.325, 0.037> <-0.192, 0.322, 0.022> <-0.192, 0.322, 0.010> 
		<-0.210, 0.324, 0.045> <-0.202, 0.320, 0.037> <-0.192, 0.317, 0.022> <-0.191, 0.317, 0.010> 
		<-0.206, 0.317, 0.050> <-0.195, 0.316, 0.042> <-0.184, 0.311, 0.023> <-0.186, 0.311, 0.009> 
		<-0.208, 0.313, 0.050> <-0.197, 0.311, 0.042> <-0.186, 0.307, 0.023> <-0.188, 0.307, 0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.192, 0.322, 0.010> <-0.191, 0.321, -0.002> <-0.201, 0.324, -0.017> <-0.208, 0.328, -0.025> 
		<-0.191, 0.317, 0.010> <-0.191, 0.317, -0.002> <-0.202, 0.319, -0.018> <-0.210, 0.322, -0.026> 
		<-0.186, 0.311, 0.009> <-0.187, 0.311, -0.005> <-0.201, 0.314, -0.021> <-0.213, 0.316, -0.031> 
		<-0.188, 0.307, 0.009> <-0.189, 0.307, -0.005> <-0.205, 0.310, -0.021> <-0.216, 0.312, -0.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.208, 0.328, -0.025> <-0.217, 0.331, -0.034> <-0.231, 0.338, -0.046> <-0.243, 0.343, -0.045> 
		<-0.210, 0.322, -0.026> <-0.218, 0.326, -0.035> <-0.233, 0.330, -0.046> <-0.245, 0.335, -0.046> 
		<-0.213, 0.316, -0.031> <-0.221, 0.318, -0.038> <-0.235, 0.322, -0.045> <-0.246, 0.325, -0.044> 
		<-0.216, 0.312, -0.031> <-0.224, 0.313, -0.038> <-0.239, 0.315, -0.045> <-0.250, 0.318, -0.044> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.243, 0.343, -0.045> <-0.256, 0.348, -0.045> <-0.273, 0.353, -0.034> <-0.282, 0.358, -0.024> 
		<-0.245, 0.335, -0.046> <-0.258, 0.341, -0.046> <-0.278, 0.345, -0.033> <-0.287, 0.350, -0.024> 
		<-0.246, 0.325, -0.044> <-0.262, 0.328, -0.042> <-0.283, 0.336, -0.035> <-0.294, 0.339, -0.023> 
		<-0.250, 0.318, -0.044> <-0.266, 0.322, -0.042> <-0.287, 0.328, -0.034> <-0.298, 0.331, -0.023> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.295, 0.331, 0.044> <-0.288, 0.328, 0.053> <-0.275, 0.320, 0.063> <-0.264, 0.317, 0.063> 
		<-0.298, 0.325, 0.043> <-0.291, 0.322, 0.052> <-0.277, 0.316, 0.063> <-0.265, 0.313, 0.064> 
		<-0.302, 0.318, 0.041> <-0.293, 0.315, 0.051> <-0.278, 0.310, 0.065> <-0.265, 0.307, 0.066> 
		<-0.302, 0.311, 0.041> <-0.294, 0.309, 0.051> <-0.279, 0.306, 0.065> <-0.266, 0.303, 0.066> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.264, 0.317, 0.063> <-0.247, 0.314, 0.065> <-0.222, 0.315, 0.060> <-0.208, 0.313, 0.050> 
		<-0.265, 0.313, 0.064> <-0.248, 0.310, 0.065> <-0.224, 0.308, 0.060> <-0.210, 0.306, 0.050> 
		<-0.265, 0.307, 0.066> <-0.251, 0.305, 0.067> <-0.229, 0.304, 0.055> <-0.219, 0.301, 0.045> 
		<-0.266, 0.303, 0.066> <-0.252, 0.300, 0.066> <-0.233, 0.298, 0.055> <-0.223, 0.295, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.208, 0.313, 0.050> <-0.197, 0.311, 0.042> <-0.186, 0.307, 0.023> <-0.188, 0.307, 0.009> 
		<-0.210, 0.306, 0.050> <-0.199, 0.304, 0.042> <-0.190, 0.300, 0.023> <-0.191, 0.299, 0.010> 
		<-0.219, 0.301, 0.045> <-0.211, 0.299, 0.038> <-0.201, 0.295, 0.021> <-0.203, 0.295, 0.010> 
		<-0.223, 0.295, 0.045> <-0.214, 0.293, 0.037> <-0.206, 0.289, 0.021> <-0.207, 0.289, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.188, 0.307, 0.009> <-0.189, 0.307, -0.005> <-0.205, 0.310, -0.021> <-0.216, 0.312, -0.031> 
		<-0.191, 0.299, 0.010> <-0.193, 0.299, -0.005> <-0.210, 0.304, -0.021> <-0.221, 0.306, -0.031> 
		<-0.203, 0.295, 0.010> <-0.205, 0.295, -0.004> <-0.222, 0.300, -0.017> <-0.231, 0.302, -0.026> 
		<-0.207, 0.289, 0.010> <-0.210, 0.289, -0.004> <-0.225, 0.293, -0.016> <-0.235, 0.295, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.216, 0.312, -0.031> <-0.224, 0.313, -0.038> <-0.239, 0.315, -0.045> <-0.250, 0.318, -0.044> 
		<-0.221, 0.306, -0.031> <-0.229, 0.307, -0.038> <-0.243, 0.310, -0.045> <-0.253, 0.312, -0.044> 
		<-0.231, 0.302, -0.026> <-0.240, 0.304, -0.034> <-0.251, 0.306, -0.047> <-0.262, 0.309, -0.046> 
		<-0.235, 0.295, -0.025> <-0.243, 0.297, -0.033> <-0.255, 0.301, -0.047> <-0.267, 0.303, -0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.250, 0.318, -0.044> <-0.266, 0.322, -0.042> <-0.287, 0.328, -0.034> <-0.298, 0.331, -0.023> 
		<-0.253, 0.312, -0.044> <-0.269, 0.316, -0.042> <-0.290, 0.322, -0.033> <-0.301, 0.325, -0.022> 
		<-0.262, 0.309, -0.046> <-0.277, 0.312, -0.045> <-0.297, 0.315, -0.031> <-0.306, 0.318, -0.020> 
		<-0.267, 0.303, -0.046> <-0.281, 0.307, -0.044> <-0.298, 0.309, -0.030> <-0.307, 0.311, -0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.302, 0.311, 0.041> <-0.294, 0.309, 0.051> <-0.279, 0.306, 0.065> <-0.266, 0.303, 0.066> 
		<-0.302, 0.307, 0.041> <-0.294, 0.305, 0.051> <-0.280, 0.301, 0.064> <-0.267, 0.298, 0.065> 
		<-0.297, 0.302, 0.042> <-0.290, 0.300, 0.049> <-0.280, 0.295, 0.061> <-0.270, 0.292, 0.062> 
		<-0.297, 0.298, 0.042> <-0.290, 0.296, 0.049> <-0.280, 0.290, 0.060> <-0.270, 0.287, 0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.266, 0.303, 0.066> <-0.252, 0.300, 0.066> <-0.233, 0.298, 0.055> <-0.223, 0.295, 0.045> 
		<-0.267, 0.298, 0.065> <-0.253, 0.295, 0.066> <-0.236, 0.293, 0.054> <-0.226, 0.290, 0.044> 
		<-0.270, 0.292, 0.062> <-0.257, 0.288, 0.062> <-0.239, 0.285, 0.054> <-0.229, 0.282, 0.045> 
		<-0.270, 0.287, 0.060> <-0.257, 0.283, 0.061> <-0.239, 0.279, 0.053> <-0.229, 0.277, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.223, 0.295, 0.045> <-0.214, 0.293, 0.037> <-0.206, 0.289, 0.021> <-0.207, 0.289, 0.010> 
		<-0.226, 0.290, 0.044> <-0.217, 0.288, 0.036> <-0.208, 0.285, 0.021> <-0.210, 0.285, 0.010> 
		<-0.229, 0.282, 0.045> <-0.220, 0.281, 0.038> <-0.209, 0.279, 0.022> <-0.210, 0.279, 0.010> 
		<-0.229, 0.277, 0.045> <-0.220, 0.275, 0.037> <-0.209, 0.274, 0.022> <-0.210, 0.274, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.207, 0.289, 0.010> <-0.210, 0.289, -0.004> <-0.225, 0.293, -0.016> <-0.235, 0.295, -0.025> 
		<-0.210, 0.285, 0.010> <-0.212, 0.285, -0.003> <-0.227, 0.288, -0.016> <-0.237, 0.290, -0.025> 
		<-0.210, 0.279, 0.010> <-0.210, 0.279, -0.003> <-0.225, 0.280, -0.018> <-0.235, 0.282, -0.026> 
		<-0.210, 0.274, 0.010> <-0.210, 0.274, -0.003> <-0.223, 0.275, -0.018> <-0.233, 0.277, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.235, 0.295, -0.025> <-0.243, 0.297, -0.033> <-0.255, 0.301, -0.047> <-0.267, 0.303, -0.046> 
		<-0.237, 0.290, -0.025> <-0.245, 0.292, -0.033> <-0.259, 0.296, -0.046> <-0.270, 0.299, -0.045> 
		<-0.235, 0.282, -0.026> <-0.245, 0.284, -0.034> <-0.261, 0.288, -0.043> <-0.273, 0.292, -0.042> 
		<-0.233, 0.277, -0.026> <-0.244, 0.279, -0.034> <-0.262, 0.283, -0.041> <-0.274, 0.287, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.267, 0.303, -0.046> <-0.281, 0.307, -0.044> <-0.298, 0.309, -0.030> <-0.307, 0.311, -0.019> 
		<-0.270, 0.299, -0.045> <-0.284, 0.302, -0.044> <-0.299, 0.305, -0.030> <-0.308, 0.307, -0.019> 
		<-0.273, 0.292, -0.042> <-0.284, 0.296, -0.041> <-0.297, 0.300, -0.029> <-0.305, 0.303, -0.021> 
		<-0.274, 0.287, -0.040> <-0.285, 0.290, -0.040> <-0.297, 0.296, -0.029> <-0.304, 0.299, -0.021> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.297, 0.298, 0.042> <-0.290, 0.296, 0.049> <-0.280, 0.290, 0.060> <-0.270, 0.287, 0.060> 
		<-0.297, 0.292, 0.041> <-0.290, 0.290, 0.049> <-0.281, 0.283, 0.058> <-0.271, 0.280, 0.059> 
		<-0.300, 0.285, 0.039> <-0.292, 0.282, 0.046> <-0.282, 0.274, 0.057> <-0.271, 0.271, 0.058> 
		<-0.301, 0.278, 0.038> <-0.293, 0.276, 0.045> <-0.282, 0.268, 0.055> <-0.271, 0.265, 0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.270, 0.287, 0.060> <-0.257, 0.283, 0.061> <-0.239, 0.279, 0.053> <-0.229, 0.277, 0.045> 
		<-0.271, 0.280, 0.059> <-0.258, 0.276, 0.059> <-0.240, 0.273, 0.053> <-0.229, 0.270, 0.044> 
		<-0.271, 0.271, 0.058> <-0.257, 0.267, 0.058> <-0.237, 0.264, 0.051> <-0.225, 0.263, 0.043> 
		<-0.271, 0.265, 0.055> <-0.257, 0.261, 0.056> <-0.237, 0.259, 0.050> <-0.225, 0.257, 0.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.229, 0.277, 0.045> <-0.220, 0.275, 0.037> <-0.209, 0.274, 0.022> <-0.210, 0.274, 0.010> 
		<-0.229, 0.270, 0.044> <-0.220, 0.269, 0.037> <-0.209, 0.268, 0.022> <-0.209, 0.268, 0.010> 
		<-0.225, 0.263, 0.043> <-0.216, 0.261, 0.037> <-0.205, 0.261, 0.021> <-0.205, 0.260, 0.009> 
		<-0.225, 0.257, 0.041> <-0.216, 0.255, 0.035> <-0.206, 0.255, 0.020> <-0.206, 0.255, 0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.210, 0.274, 0.010> <-0.210, 0.274, -0.003> <-0.223, 0.275, -0.018> <-0.233, 0.277, -0.026> 
		<-0.209, 0.268, 0.010> <-0.210, 0.268, -0.003> <-0.221, 0.268, -0.017> <-0.232, 0.270, -0.025> 
		<-0.205, 0.260, 0.009> <-0.205, 0.260, -0.001> <-0.216, 0.261, -0.018> <-0.226, 0.263, -0.024> 
		<-0.206, 0.255, 0.009> <-0.206, 0.254, -0.002> <-0.215, 0.255, -0.016> <-0.224, 0.256, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.233, 0.277, -0.026> <-0.244, 0.279, -0.034> <-0.262, 0.283, -0.041> <-0.274, 0.287, -0.040> 
		<-0.232, 0.270, -0.025> <-0.242, 0.272, -0.033> <-0.263, 0.277, -0.040> <-0.276, 0.281, -0.039> 
		<-0.226, 0.263, -0.024> <-0.239, 0.265, -0.033> <-0.259, 0.267, -0.039> <-0.274, 0.271, -0.038> 
		<-0.224, 0.256, -0.022> <-0.237, 0.258, -0.031> <-0.259, 0.261, -0.036> <-0.274, 0.265, -0.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.274, 0.287, -0.040> <-0.285, 0.290, -0.040> <-0.297, 0.296, -0.029> <-0.304, 0.299, -0.021> 
		<-0.276, 0.281, -0.039> <-0.286, 0.284, -0.038> <-0.297, 0.290, -0.029> <-0.304, 0.293, -0.021> 
		<-0.274, 0.271, -0.038> <-0.285, 0.274, -0.037> <-0.297, 0.282, -0.026> <-0.304, 0.285, -0.019> 
		<-0.274, 0.265, -0.036> <-0.285, 0.268, -0.035> <-0.297, 0.276, -0.026> <-0.304, 0.279, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.301, 0.278, 0.038> <-0.293, 0.276, 0.045> <-0.282, 0.268, 0.055> <-0.271, 0.265, 0.055> 
		<-0.301, 0.274, 0.038> <-0.293, 0.272, 0.045> <-0.282, 0.266, 0.054> <-0.271, 0.263, 0.055> 
		<-0.301, 0.269, 0.038> <-0.294, 0.266, 0.045> <-0.280, 0.264, 0.051> <-0.271, 0.262, 0.051> 
		<-0.300, 0.265, 0.039> <-0.293, 0.262, 0.045> <-0.280, 0.262, 0.050> <-0.271, 0.261, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.271, 0.265, 0.055> <-0.257, 0.261, 0.056> <-0.237, 0.259, 0.050> <-0.225, 0.257, 0.041> 
		<-0.271, 0.263, 0.055> <-0.257, 0.259, 0.055> <-0.237, 0.257, 0.049> <-0.225, 0.255, 0.041> 
		<-0.271, 0.262, 0.051> <-0.257, 0.260, 0.051> <-0.238, 0.257, 0.046> <-0.227, 0.255, 0.038> 
		<-0.271, 0.261, 0.050> <-0.257, 0.259, 0.050> <-0.238, 0.255, 0.046> <-0.227, 0.253, 0.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.225, 0.257, 0.041> <-0.216, 0.255, 0.035> <-0.206, 0.255, 0.020> <-0.206, 0.255, 0.009> 
		<-0.225, 0.255, 0.041> <-0.216, 0.254, 0.034> <-0.207, 0.252, 0.020> <-0.207, 0.252, 0.009> 
		<-0.227, 0.255, 0.038> <-0.219, 0.254, 0.033> <-0.211, 0.253, 0.019> <-0.212, 0.253, 0.009> 
		<-0.227, 0.253, 0.038> <-0.219, 0.252, 0.032> <-0.213, 0.251, 0.019> <-0.214, 0.251, 0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.206, 0.255, 0.009> <-0.206, 0.254, -0.002> <-0.215, 0.255, -0.016> <-0.224, 0.256, -0.022> 
		<-0.207, 0.252, 0.009> <-0.207, 0.252, -0.002> <-0.215, 0.253, -0.016> <-0.224, 0.254, -0.022> 
		<-0.212, 0.253, 0.009> <-0.212, 0.252, -0.000> <-0.220, 0.253, -0.014> <-0.228, 0.254, -0.020> 
		<-0.214, 0.251, 0.009> <-0.214, 0.251, -0.001> <-0.221, 0.251, -0.014> <-0.229, 0.253, -0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.224, 0.256, -0.022> <-0.237, 0.258, -0.031> <-0.259, 0.261, -0.036> <-0.274, 0.265, -0.036> 
		<-0.224, 0.254, -0.022> <-0.237, 0.256, -0.030> <-0.259, 0.259, -0.036> <-0.274, 0.263, -0.035> 
		<-0.228, 0.254, -0.020> <-0.240, 0.256, -0.027> <-0.260, 0.260, -0.032> <-0.275, 0.263, -0.032> 
		<-0.229, 0.253, -0.019> <-0.241, 0.254, -0.027> <-0.261, 0.259, -0.031> <-0.275, 0.261, -0.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.274, 0.265, -0.036> <-0.285, 0.268, -0.035> <-0.297, 0.276, -0.026> <-0.304, 0.279, -0.018> 
		<-0.274, 0.263, -0.035> <-0.285, 0.266, -0.034> <-0.297, 0.272, -0.026> <-0.304, 0.275, -0.018> 
		<-0.275, 0.263, -0.032> <-0.284, 0.264, -0.032> <-0.299, 0.267, -0.025> <-0.306, 0.269, -0.019> 
		<-0.275, 0.261, -0.031> <-0.284, 0.262, -0.031> <-0.298, 0.263, -0.025> <-0.304, 0.265, -0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.300, 0.265, 0.039> <-0.293, 0.262, 0.045> <-0.280, 0.262, 0.050> <-0.271, 0.261, 0.050> 
		<-0.299, 0.263, 0.039> <-0.292, 0.261, 0.045> <-0.280, 0.261, 0.050> <-0.271, 0.260, 0.050> 
		<-0.295, 0.263, 0.038> <-0.289, 0.262, 0.043> <-0.278, 0.259, 0.050> <-0.270, 0.258, 0.050> 
		<-0.295, 0.261, 0.039> <-0.289, 0.260, 0.044> <-0.278, 0.258, 0.051> <-0.270, 0.257, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.271, 0.261, 0.050> <-0.257, 0.259, 0.050> <-0.238, 0.255, 0.046> <-0.227, 0.253, 0.038> 
		<-0.271, 0.260, 0.050> <-0.257, 0.258, 0.050> <-0.238, 0.254, 0.045> <-0.227, 0.252, 0.037> 
		<-0.270, 0.258, 0.050> <-0.256, 0.256, 0.050> <-0.237, 0.253, 0.046> <-0.226, 0.250, 0.037> 
		<-0.270, 0.257, 0.050> <-0.256, 0.255, 0.050> <-0.236, 0.251, 0.046> <-0.225, 0.249, 0.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.227, 0.253, 0.038> <-0.219, 0.252, 0.032> <-0.213, 0.251, 0.019> <-0.214, 0.251, 0.009> 
		<-0.227, 0.252, 0.037> <-0.219, 0.251, 0.031> <-0.214, 0.250, 0.018> <-0.215, 0.250, 0.009> 
		<-0.226, 0.250, 0.037> <-0.218, 0.249, 0.032> <-0.214, 0.248, 0.018> <-0.214, 0.248, 0.009> 
		<-0.225, 0.249, 0.038> <-0.218, 0.248, 0.032> <-0.215, 0.247, 0.018> <-0.215, 0.247, 0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.214, 0.251, 0.009> <-0.214, 0.251, -0.001> <-0.221, 0.251, -0.014> <-0.229, 0.253, -0.019> 
		<-0.215, 0.250, 0.009> <-0.215, 0.250, -0.001> <-0.222, 0.250, -0.013> <-0.230, 0.252, -0.018> 
		<-0.214, 0.248, 0.009> <-0.215, 0.247, -0.000> <-0.222, 0.248, -0.013> <-0.230, 0.250, -0.019> 
		<-0.215, 0.247, 0.009> <-0.216, 0.247, -0.000> <-0.222, 0.247, -0.014> <-0.230, 0.248, -0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.229, 0.253, -0.019> <-0.241, 0.254, -0.027> <-0.261, 0.259, -0.031> <-0.275, 0.261, -0.031> 
		<-0.230, 0.252, -0.018> <-0.242, 0.253, -0.026> <-0.261, 0.258, -0.030> <-0.275, 0.260, -0.030> 
		<-0.230, 0.250, -0.019> <-0.242, 0.252, -0.026> <-0.261, 0.255, -0.030> <-0.275, 0.258, -0.030> 
		<-0.230, 0.248, -0.019> <-0.241, 0.250, -0.027> <-0.261, 0.254, -0.031> <-0.275, 0.257, -0.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.275, 0.261, -0.031> <-0.284, 0.262, -0.031> <-0.298, 0.263, -0.025> <-0.304, 0.265, -0.019> 
		<-0.275, 0.260, -0.030> <-0.284, 0.261, -0.030> <-0.297, 0.261, -0.025> <-0.304, 0.263, -0.019> 
		<-0.275, 0.258, -0.030> <-0.283, 0.259, -0.030> <-0.293, 0.262, -0.023> <-0.299, 0.263, -0.018> 
		<-0.275, 0.257, -0.031> <-0.283, 0.258, -0.031> <-0.293, 0.260, -0.024> <-0.299, 0.261, -0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.295, 0.261, 0.039> <-0.289, 0.260, 0.044> <-0.278, 0.258, 0.051> <-0.270, 0.257, 0.050> 
		<-0.295, 0.258, 0.040> <-0.289, 0.257, 0.045> <-0.278, 0.256, 0.052> <-0.270, 0.254, 0.052> 
		<-0.299, 0.256, 0.042> <-0.292, 0.255, 0.049> <-0.279, 0.253, 0.055> <-0.269, 0.252, 0.054> 
		<-0.300, 0.253, 0.042> <-0.292, 0.253, 0.049> <-0.279, 0.251, 0.056> <-0.270, 0.249, 0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.270, 0.257, 0.050> <-0.256, 0.255, 0.050> <-0.236, 0.251, 0.046> <-0.225, 0.249, 0.038> 
		<-0.270, 0.254, 0.052> <-0.256, 0.252, 0.051> <-0.234, 0.249, 0.047> <-0.223, 0.247, 0.038> 
		<-0.269, 0.252, 0.054> <-0.253, 0.249, 0.054> <-0.229, 0.246, 0.052> <-0.217, 0.244, 0.040> 
		<-0.270, 0.249, 0.056> <-0.253, 0.246, 0.055> <-0.229, 0.242, 0.053> <-0.217, 0.241, 0.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.225, 0.249, 0.038> <-0.218, 0.248, 0.032> <-0.215, 0.247, 0.018> <-0.215, 0.247, 0.009> 
		<-0.223, 0.247, 0.038> <-0.216, 0.245, 0.033> <-0.217, 0.245, 0.018> <-0.217, 0.245, 0.009> 
		<-0.217, 0.244, 0.040> <-0.210, 0.243, 0.033> <-0.222, 0.244, 0.019> <-0.223, 0.244, 0.009> 
		<-0.217, 0.241, 0.041> <-0.211, 0.239, 0.034> <-0.222, 0.242, 0.019> <-0.224, 0.242, 0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.215, 0.247, 0.009> <-0.216, 0.247, -0.000> <-0.222, 0.247, -0.014> <-0.230, 0.248, -0.019> 
		<-0.217, 0.245, 0.009> <-0.218, 0.244, -0.000> <-0.221, 0.244, -0.014> <-0.229, 0.246, -0.020> 
		<-0.223, 0.244, 0.009> <-0.224, 0.244, -0.000> <-0.219, 0.241, -0.015> <-0.226, 0.242, -0.021> 
		<-0.224, 0.242, 0.009> <-0.225, 0.241, -0.000> <-0.219, 0.239, -0.016> <-0.226, 0.240, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.230, 0.248, -0.019> <-0.241, 0.250, -0.027> <-0.261, 0.254, -0.031> <-0.275, 0.257, -0.031> 
		<-0.229, 0.246, -0.020> <-0.241, 0.248, -0.027> <-0.261, 0.252, -0.032> <-0.276, 0.254, -0.032> 
		<-0.226, 0.242, -0.021> <-0.238, 0.244, -0.031> <-0.261, 0.248, -0.035> <-0.277, 0.252, -0.035> 
		<-0.226, 0.240, -0.022> <-0.238, 0.241, -0.032> <-0.261, 0.246, -0.036> <-0.277, 0.249, -0.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.275, 0.257, -0.031> <-0.283, 0.258, -0.031> <-0.293, 0.260, -0.024> <-0.299, 0.261, -0.019> 
		<-0.276, 0.254, -0.032> <-0.283, 0.256, -0.032> <-0.292, 0.258, -0.025> <-0.297, 0.259, -0.019> 
		<-0.277, 0.252, -0.035> <-0.284, 0.253, -0.035> <-0.294, 0.255, -0.027> <-0.299, 0.256, -0.022> 
		<-0.277, 0.249, -0.036> <-0.285, 0.250, -0.036> <-0.293, 0.253, -0.028> <-0.299, 0.254, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.300, 0.253, 0.042> <-0.292, 0.253, 0.049> <-0.279, 0.251, 0.056> <-0.270, 0.249, 0.056> 
		<-0.301, 0.248, 0.043> <-0.294, 0.247, 0.050> <-0.280, 0.246, 0.058> <-0.270, 0.245, 0.058> 
		<-0.300, 0.240, 0.043> <-0.293, 0.240, 0.050> <-0.283, 0.240, 0.059> <-0.273, 0.239, 0.059> 
		<-0.302, 0.235, 0.042> <-0.295, 0.235, 0.050> <-0.283, 0.235, 0.060> <-0.273, 0.234, 0.061> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.270, 0.249, 0.056> <-0.253, 0.246, 0.055> <-0.229, 0.242, 0.053> <-0.217, 0.241, 0.041> 
		<-0.270, 0.245, 0.058> <-0.254, 0.242, 0.057> <-0.229, 0.238, 0.054> <-0.218, 0.236, 0.043> 
		<-0.273, 0.239, 0.059> <-0.258, 0.237, 0.060> <-0.235, 0.234, 0.055> <-0.224, 0.233, 0.044> 
		<-0.273, 0.234, 0.061> <-0.258, 0.233, 0.061> <-0.236, 0.230, 0.056> <-0.225, 0.228, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.217, 0.241, 0.041> <-0.211, 0.239, 0.034> <-0.222, 0.242, 0.019> <-0.224, 0.242, 0.009> 
		<-0.218, 0.236, 0.043> <-0.211, 0.235, 0.036> <-0.224, 0.237, 0.019> <-0.225, 0.237, 0.009> 
		<-0.224, 0.233, 0.044> <-0.216, 0.231, 0.037> <-0.221, 0.230, 0.020> <-0.222, 0.230, 0.009> 
		<-0.225, 0.228, 0.045> <-0.218, 0.227, 0.037> <-0.220, 0.226, 0.020> <-0.221, 0.226, 0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.224, 0.242, 0.009> <-0.225, 0.241, -0.000> <-0.219, 0.239, -0.016> <-0.226, 0.240, -0.022> 
		<-0.225, 0.237, 0.009> <-0.226, 0.237, -0.000> <-0.219, 0.235, -0.017> <-0.226, 0.236, -0.023> 
		<-0.222, 0.230, 0.009> <-0.223, 0.230, -0.002> <-0.223, 0.231, -0.018> <-0.231, 0.232, -0.025> 
		<-0.221, 0.226, 0.009> <-0.222, 0.226, -0.002> <-0.223, 0.227, -0.018> <-0.231, 0.228, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.226, 0.240, -0.022> <-0.238, 0.241, -0.032> <-0.261, 0.246, -0.036> <-0.277, 0.249, -0.036> 
		<-0.226, 0.236, -0.023> <-0.238, 0.238, -0.034> <-0.261, 0.242, -0.038> <-0.277, 0.245, -0.038> 
		<-0.231, 0.232, -0.025> <-0.242, 0.234, -0.034> <-0.263, 0.237, -0.041> <-0.277, 0.239, -0.040> 
		<-0.231, 0.228, -0.026> <-0.242, 0.230, -0.035> <-0.262, 0.232, -0.041> <-0.277, 0.234, -0.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.277, 0.249, -0.036> <-0.285, 0.250, -0.036> <-0.293, 0.253, -0.028> <-0.299, 0.254, -0.022> 
		<-0.277, 0.245, -0.038> <-0.285, 0.246, -0.038> <-0.293, 0.247, -0.029> <-0.298, 0.248, -0.023> 
		<-0.277, 0.239, -0.040> <-0.285, 0.239, -0.039> <-0.289, 0.240, -0.029> <-0.294, 0.240, -0.022> 
		<-0.277, 0.234, -0.041> <-0.285, 0.235, -0.040> <-0.291, 0.235, -0.028> <-0.296, 0.235, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.302, 0.235, 0.042> <-0.295, 0.235, 0.050> <-0.283, 0.235, 0.060> <-0.273, 0.234, 0.061> 
		<-0.305, 0.227, 0.042> <-0.298, 0.226, 0.049> <-0.283, 0.227, 0.062> <-0.273, 0.226, 0.062> 
		<-0.312, 0.217, 0.039> <-0.301, 0.217, 0.050> <-0.287, 0.215, 0.064> <-0.272, 0.214, 0.065> 
		<-0.314, 0.209, 0.039> <-0.303, 0.209, 0.050> <-0.286, 0.207, 0.063> <-0.271, 0.206, 0.065> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.273, 0.234, 0.061> <-0.258, 0.233, 0.061> <-0.236, 0.230, 0.056> <-0.225, 0.228, 0.045> 
		<-0.273, 0.226, 0.062> <-0.258, 0.224, 0.063> <-0.238, 0.223, 0.057> <-0.228, 0.221, 0.046> 
		<-0.272, 0.214, 0.065> <-0.258, 0.214, 0.067> <-0.238, 0.212, 0.058> <-0.228, 0.211, 0.049> 
		<-0.271, 0.206, 0.065> <-0.257, 0.205, 0.067> <-0.238, 0.204, 0.058> <-0.229, 0.204, 0.049> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.225, 0.228, 0.045> <-0.218, 0.227, 0.037> <-0.220, 0.226, 0.020> <-0.221, 0.226, 0.009> 
		<-0.228, 0.221, 0.046> <-0.220, 0.220, 0.039> <-0.219, 0.219, 0.020> <-0.220, 0.219, 0.009> 
		<-0.228, 0.211, 0.049> <-0.220, 0.211, 0.040> <-0.219, 0.209, 0.022> <-0.218, 0.209, 0.010> 
		<-0.229, 0.204, 0.049> <-0.221, 0.203, 0.040> <-0.218, 0.202, 0.022> <-0.218, 0.202, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.221, 0.226, 0.009> <-0.222, 0.226, -0.002> <-0.223, 0.227, -0.018> <-0.231, 0.228, -0.026> 
		<-0.220, 0.219, 0.009> <-0.221, 0.219, -0.001> <-0.223, 0.219, -0.020> <-0.231, 0.221, -0.027> 
		<-0.218, 0.209, 0.010> <-0.217, 0.209, -0.002> <-0.217, 0.211, -0.021> <-0.225, 0.211, -0.029> 
		<-0.218, 0.202, 0.010> <-0.217, 0.202, -0.002> <-0.216, 0.203, -0.021> <-0.225, 0.204, -0.029> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.231, 0.228, -0.026> <-0.242, 0.230, -0.035> <-0.262, 0.232, -0.041> <-0.277, 0.234, -0.041> 
		<-0.231, 0.221, -0.027> <-0.242, 0.222, -0.037> <-0.261, 0.224, -0.043> <-0.276, 0.226, -0.042> 
		<-0.225, 0.211, -0.029> <-0.236, 0.212, -0.040> <-0.259, 0.214, -0.046> <-0.274, 0.214, -0.045> 
		<-0.225, 0.204, -0.029> <-0.235, 0.204, -0.040> <-0.257, 0.205, -0.046> <-0.272, 0.206, -0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.277, 0.234, -0.041> <-0.285, 0.235, -0.040> <-0.291, 0.235, -0.028> <-0.296, 0.235, -0.022> 
		<-0.276, 0.226, -0.042> <-0.284, 0.227, -0.042> <-0.294, 0.225, -0.028> <-0.299, 0.226, -0.022> 
		<-0.274, 0.214, -0.045> <-0.289, 0.215, -0.043> <-0.303, 0.218, -0.031> <-0.313, 0.219, -0.020> 
		<-0.272, 0.206, -0.045> <-0.287, 0.207, -0.043> <-0.305, 0.209, -0.031> <-0.315, 0.209, -0.020> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.314, 0.209, 0.039> <-0.303, 0.209, 0.050> <-0.286, 0.207, 0.063> <-0.271, 0.206, 0.065> 
		<-0.315, 0.199, 0.039> <-0.305, 0.199, 0.050> <-0.284, 0.198, 0.063> <-0.269, 0.197, 0.065> 
		<-0.311, 0.186, 0.042> <-0.300, 0.186, 0.052> <-0.281, 0.186, 0.062> <-0.266, 0.186, 0.062> 
		<-0.312, 0.176, 0.042> <-0.301, 0.176, 0.052> <-0.280, 0.177, 0.060> <-0.265, 0.177, 0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.271, 0.206, 0.065> <-0.257, 0.205, 0.067> <-0.238, 0.204, 0.058> <-0.229, 0.204, 0.049> 
		<-0.269, 0.197, 0.065> <-0.256, 0.196, 0.066> <-0.239, 0.197, 0.058> <-0.230, 0.196, 0.049> 
		<-0.266, 0.186, 0.062> <-0.254, 0.186, 0.063> <-0.236, 0.185, 0.055> <-0.228, 0.185, 0.046> 
		<-0.265, 0.177, 0.060> <-0.254, 0.178, 0.061> <-0.238, 0.178, 0.054> <-0.231, 0.178, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.229, 0.204, 0.049> <-0.221, 0.203, 0.040> <-0.218, 0.202, 0.022> <-0.218, 0.202, 0.010> 
		<-0.230, 0.196, 0.049> <-0.222, 0.195, 0.040> <-0.218, 0.195, 0.022> <-0.218, 0.195, 0.010> 
		<-0.228, 0.185, 0.046> <-0.221, 0.185, 0.038> <-0.219, 0.186, 0.021> <-0.219, 0.186, 0.010> 
		<-0.231, 0.178, 0.045> <-0.224, 0.178, 0.037> <-0.221, 0.179, 0.021> <-0.221, 0.179, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.218, 0.202, 0.010> <-0.217, 0.202, -0.002> <-0.216, 0.203, -0.021> <-0.225, 0.204, -0.029> 
		<-0.218, 0.195, 0.010> <-0.217, 0.195, -0.002> <-0.216, 0.195, -0.021> <-0.224, 0.196, -0.029> 
		<-0.219, 0.186, 0.010> <-0.218, 0.186, -0.001> <-0.218, 0.187, -0.018> <-0.225, 0.186, -0.026> 
		<-0.221, 0.179, 0.010> <-0.220, 0.179, -0.001> <-0.221, 0.180, -0.017> <-0.227, 0.178, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.225, 0.204, -0.029> <-0.235, 0.204, -0.040> <-0.257, 0.205, -0.046> <-0.272, 0.206, -0.045> 
		<-0.224, 0.196, -0.029> <-0.235, 0.197, -0.040> <-0.255, 0.195, -0.046> <-0.269, 0.196, -0.045> 
		<-0.225, 0.186, -0.026> <-0.232, 0.184, -0.035> <-0.251, 0.182, -0.044> <-0.263, 0.182, -0.043> 
		<-0.227, 0.178, -0.025> <-0.235, 0.177, -0.034> <-0.250, 0.172, -0.042> <-0.262, 0.172, -0.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.272, 0.206, -0.045> <-0.287, 0.207, -0.043> <-0.305, 0.209, -0.031> <-0.315, 0.209, -0.020> 
		<-0.269, 0.196, -0.045> <-0.284, 0.196, -0.043> <-0.307, 0.199, -0.031> <-0.317, 0.199, -0.020> 
		<-0.263, 0.182, -0.043> <-0.278, 0.182, -0.043> <-0.297, 0.186, -0.031> <-0.308, 0.187, -0.022> 
		<-0.262, 0.172, -0.041> <-0.277, 0.171, -0.041> <-0.296, 0.176, -0.032> <-0.307, 0.177, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.312, 0.176, 0.042> <-0.301, 0.176, 0.052> <-0.280, 0.177, 0.060> <-0.265, 0.177, 0.060> 
		<-0.312, 0.172, 0.042> <-0.301, 0.172, 0.053> <-0.280, 0.172, 0.059> <-0.265, 0.172, 0.059> 
		<-0.317, 0.168, 0.043> <-0.305, 0.167, 0.053> <-0.284, 0.166, 0.057> <-0.268, 0.165, 0.057> 
		<-0.319, 0.165, 0.042> <-0.307, 0.163, 0.052> <-0.284, 0.161, 0.055> <-0.268, 0.160, 0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.265, 0.177, 0.060> <-0.254, 0.178, 0.061> <-0.238, 0.178, 0.054> <-0.231, 0.178, 0.045> 
		<-0.265, 0.172, 0.059> <-0.254, 0.172, 0.060> <-0.240, 0.171, 0.053> <-0.233, 0.171, 0.044> 
		<-0.268, 0.165, 0.057> <-0.260, 0.164, 0.057> <-0.246, 0.165, 0.050> <-0.241, 0.165, 0.043> 
		<-0.268, 0.160, 0.055> <-0.260, 0.159, 0.055> <-0.249, 0.159, 0.048> <-0.244, 0.159, 0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.231, 0.178, 0.045> <-0.224, 0.178, 0.037> <-0.221, 0.179, 0.021> <-0.221, 0.179, 0.010> 
		<-0.233, 0.171, 0.044> <-0.226, 0.172, 0.036> <-0.223, 0.172, 0.021> <-0.223, 0.173, 0.010> 
		<-0.241, 0.165, 0.043> <-0.235, 0.165, 0.035> <-0.230, 0.165, 0.020> <-0.229, 0.165, 0.010> 
		<-0.244, 0.159, 0.042> <-0.237, 0.159, 0.034> <-0.231, 0.159, 0.020> <-0.231, 0.159, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.221, 0.179, 0.010> <-0.220, 0.179, -0.001> <-0.221, 0.180, -0.017> <-0.227, 0.178, -0.025> 
		<-0.223, 0.173, 0.010> <-0.222, 0.173, -0.001> <-0.223, 0.173, -0.016> <-0.229, 0.172, -0.024> 
		<-0.229, 0.165, 0.010> <-0.228, 0.165, 0.000> <-0.231, 0.165, -0.016> <-0.237, 0.165, -0.024> 
		<-0.231, 0.159, 0.010> <-0.230, 0.159, 0.000> <-0.233, 0.158, -0.014> <-0.240, 0.159, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.227, 0.178, -0.025> <-0.235, 0.177, -0.034> <-0.250, 0.172, -0.042> <-0.262, 0.172, -0.041> 
		<-0.229, 0.172, -0.024> <-0.237, 0.170, -0.033> <-0.250, 0.168, -0.041> <-0.262, 0.168, -0.040> 
		<-0.237, 0.165, -0.024> <-0.243, 0.165, -0.031> <-0.257, 0.163, -0.038> <-0.267, 0.164, -0.038> 
		<-0.240, 0.159, -0.022> <-0.246, 0.159, -0.029> <-0.259, 0.160, -0.036> <-0.269, 0.161, -0.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.262, 0.172, -0.041> <-0.277, 0.171, -0.041> <-0.296, 0.176, -0.032> <-0.307, 0.177, -0.022> 
		<-0.262, 0.168, -0.040> <-0.277, 0.167, -0.040> <-0.296, 0.172, -0.032> <-0.307, 0.173, -0.022> 
		<-0.267, 0.164, -0.038> <-0.280, 0.165, -0.038> <-0.300, 0.167, -0.031> <-0.310, 0.168, -0.023> 
		<-0.269, 0.161, -0.036> <-0.282, 0.162, -0.036> <-0.300, 0.163, -0.030> <-0.310, 0.164, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.319, 0.165, 0.042> <-0.307, 0.163, 0.052> <-0.284, 0.161, 0.055> <-0.268, 0.160, 0.055> 
		<-0.320, 0.162, 0.042> <-0.308, 0.161, 0.052> <-0.284, 0.158, 0.054> <-0.268, 0.157, 0.054> 
		<-0.323, 0.160, 0.040> <-0.308, 0.158, 0.050> <-0.283, 0.155, 0.052> <-0.265, 0.154, 0.052> 
		<-0.323, 0.158, 0.039> <-0.308, 0.156, 0.049> <-0.282, 0.153, 0.050> <-0.264, 0.152, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.268, 0.160, 0.055> <-0.260, 0.159, 0.055> <-0.249, 0.159, 0.048> <-0.244, 0.159, 0.042> 
		<-0.268, 0.157, 0.054> <-0.260, 0.156, 0.054> <-0.250, 0.157, 0.048> <-0.245, 0.157, 0.041> 
		<-0.265, 0.154, 0.052> <-0.258, 0.153, 0.052> <-0.247, 0.153, 0.045> <-0.242, 0.153, 0.040> 
		<-0.264, 0.152, 0.050> <-0.257, 0.151, 0.050> <-0.248, 0.151, 0.044> <-0.243, 0.151, 0.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.244, 0.159, 0.042> <-0.237, 0.159, 0.034> <-0.231, 0.159, 0.020> <-0.231, 0.159, 0.010> 
		<-0.245, 0.157, 0.041> <-0.238, 0.156, 0.033> <-0.232, 0.156, 0.020> <-0.231, 0.156, 0.010> 
		<-0.242, 0.153, 0.040> <-0.236, 0.153, 0.033> <-0.229, 0.153, 0.019> <-0.228, 0.153, 0.010> 
		<-0.243, 0.151, 0.038> <-0.236, 0.151, 0.031> <-0.230, 0.151, 0.019> <-0.229, 0.151, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.231, 0.159, 0.010> <-0.230, 0.159, 0.000> <-0.233, 0.158, -0.014> <-0.240, 0.159, -0.022> 
		<-0.231, 0.156, 0.010> <-0.231, 0.156, 0.000> <-0.234, 0.156, -0.014> <-0.241, 0.156, -0.021> 
		<-0.228, 0.153, 0.010> <-0.228, 0.153, 0.001> <-0.231, 0.152, -0.014> <-0.238, 0.153, -0.020> 
		<-0.229, 0.151, 0.010> <-0.228, 0.150, 0.001> <-0.232, 0.150, -0.013> <-0.239, 0.151, -0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.240, 0.159, -0.022> <-0.246, 0.159, -0.029> <-0.259, 0.160, -0.036> <-0.269, 0.161, -0.036> 
		<-0.241, 0.156, -0.021> <-0.247, 0.157, -0.029> <-0.261, 0.157, -0.035> <-0.270, 0.158, -0.035> 
		<-0.238, 0.153, -0.020> <-0.246, 0.153, -0.027> <-0.261, 0.154, -0.033> <-0.273, 0.155, -0.033> 
		<-0.239, 0.151, -0.019> <-0.247, 0.151, -0.026> <-0.263, 0.153, -0.031> <-0.274, 0.153, -0.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.269, 0.161, -0.036> <-0.282, 0.162, -0.036> <-0.300, 0.163, -0.030> <-0.310, 0.164, -0.022> 
		<-0.270, 0.158, -0.035> <-0.283, 0.159, -0.035> <-0.301, 0.161, -0.030> <-0.311, 0.162, -0.021> 
		<-0.273, 0.155, -0.033> <-0.284, 0.156, -0.033> <-0.303, 0.158, -0.027> <-0.312, 0.159, -0.020> 
		<-0.274, 0.153, -0.031> <-0.286, 0.154, -0.031> <-0.302, 0.156, -0.026> <-0.311, 0.157, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.323, 0.158, 0.039> <-0.308, 0.156, 0.049> <-0.282, 0.153, 0.050> <-0.264, 0.152, 0.050> 
		<-0.322, 0.156, 0.037> <-0.308, 0.154, 0.048> <-0.282, 0.152, 0.049> <-0.264, 0.150, 0.049> 
		<-0.319, 0.155, 0.036> <-0.305, 0.153, 0.045> <-0.280, 0.151, 0.046> <-0.263, 0.149, 0.046> 
		<-0.317, 0.153, 0.035> <-0.303, 0.152, 0.044> <-0.279, 0.149, 0.045> <-0.262, 0.148, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.264, 0.152, 0.050> <-0.257, 0.151, 0.050> <-0.248, 0.151, 0.044> <-0.243, 0.151, 0.038> 
		<-0.264, 0.150, 0.049> <-0.256, 0.150, 0.049> <-0.248, 0.150, 0.043> <-0.243, 0.150, 0.038> 
		<-0.263, 0.149, 0.046> <-0.257, 0.149, 0.046> <-0.249, 0.149, 0.040> <-0.245, 0.149, 0.036> 
		<-0.262, 0.148, 0.045> <-0.256, 0.147, 0.045> <-0.249, 0.147, 0.040> <-0.245, 0.147, 0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.243, 0.151, 0.038> <-0.236, 0.151, 0.031> <-0.230, 0.151, 0.019> <-0.229, 0.151, 0.010> 
		<-0.243, 0.150, 0.038> <-0.237, 0.149, 0.030> <-0.230, 0.149, 0.019> <-0.229, 0.149, 0.010> 
		<-0.245, 0.149, 0.036> <-0.239, 0.149, 0.029> <-0.232, 0.148, 0.018> <-0.232, 0.148, 0.010> 
		<-0.245, 0.147, 0.035> <-0.240, 0.147, 0.029> <-0.233, 0.147, 0.018> <-0.233, 0.147, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.229, 0.151, 0.010> <-0.228, 0.150, 0.001> <-0.232, 0.150, -0.013> <-0.239, 0.151, -0.019> 
		<-0.229, 0.149, 0.010> <-0.228, 0.149, 0.001> <-0.232, 0.149, -0.012> <-0.239, 0.149, -0.018> 
		<-0.232, 0.148, 0.010> <-0.232, 0.148, 0.002> <-0.235, 0.148, -0.011> <-0.242, 0.149, -0.016> 
		<-0.233, 0.147, 0.010> <-0.232, 0.147, 0.002> <-0.236, 0.147, -0.010> <-0.242, 0.147, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.239, 0.151, -0.019> <-0.247, 0.151, -0.026> <-0.263, 0.153, -0.031> <-0.274, 0.153, -0.031> 
		<-0.239, 0.149, -0.018> <-0.247, 0.150, -0.025> <-0.264, 0.151, -0.030> <-0.275, 0.152, -0.030> 
		<-0.242, 0.149, -0.016> <-0.250, 0.149, -0.023> <-0.265, 0.151, -0.027> <-0.275, 0.151, -0.027> 
		<-0.242, 0.147, -0.015> <-0.251, 0.148, -0.022> <-0.266, 0.149, -0.026> <-0.276, 0.150, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.274, 0.153, -0.031> <-0.286, 0.154, -0.031> <-0.302, 0.156, -0.026> <-0.311, 0.157, -0.018> 
		<-0.275, 0.152, -0.030> <-0.287, 0.153, -0.029> <-0.302, 0.154, -0.025> <-0.311, 0.155, -0.017> 
		<-0.275, 0.151, -0.027> <-0.285, 0.152, -0.027> <-0.300, 0.154, -0.022> <-0.308, 0.154, -0.016> 
		<-0.276, 0.150, -0.026> <-0.286, 0.151, -0.026> <-0.300, 0.152, -0.021> <-0.307, 0.153, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.317, 0.153, 0.035> <-0.303, 0.152, 0.044> <-0.279, 0.149, 0.045> <-0.262, 0.148, 0.045> 
		<-0.317, 0.152, 0.035> <-0.302, 0.151, 0.044> <-0.279, 0.148, 0.045> <-0.262, 0.147, 0.045> 
		<-0.316, 0.151, 0.035> <-0.302, 0.149, 0.044> <-0.278, 0.146, 0.045> <-0.261, 0.145, 0.045> 
		<-0.316, 0.150, 0.035> <-0.302, 0.148, 0.044> <-0.278, 0.145, 0.045> <-0.261, 0.144, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.262, 0.148, 0.045> <-0.256, 0.147, 0.045> <-0.249, 0.147, 0.040> <-0.245, 0.147, 0.035> 
		<-0.262, 0.147, 0.045> <-0.256, 0.146, 0.045> <-0.249, 0.146, 0.039> <-0.245, 0.146, 0.035> 
		<-0.261, 0.145, 0.045> <-0.255, 0.144, 0.045> <-0.249, 0.144, 0.039> <-0.245, 0.144, 0.035> 
		<-0.261, 0.144, 0.045> <-0.255, 0.143, 0.045> <-0.248, 0.143, 0.040> <-0.244, 0.143, 0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.245, 0.147, 0.035> <-0.240, 0.147, 0.029> <-0.233, 0.147, 0.018> <-0.233, 0.147, 0.010> 
		<-0.245, 0.146, 0.035> <-0.240, 0.146, 0.028> <-0.233, 0.146, 0.018> <-0.233, 0.146, 0.010> 
		<-0.245, 0.144, 0.035> <-0.239, 0.144, 0.028> <-0.233, 0.144, 0.018> <-0.233, 0.144, 0.010> 
		<-0.244, 0.143, 0.035> <-0.239, 0.143, 0.029> <-0.232, 0.143, 0.018> <-0.232, 0.143, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.233, 0.147, 0.010> <-0.232, 0.147, 0.002> <-0.236, 0.147, -0.010> <-0.242, 0.147, -0.015> 
		<-0.233, 0.146, 0.010> <-0.233, 0.146, 0.002> <-0.237, 0.146, -0.010> <-0.243, 0.146, -0.015> 
		<-0.233, 0.144, 0.010> <-0.232, 0.144, 0.002> <-0.237, 0.144, -0.010> <-0.243, 0.144, -0.015> 
		<-0.232, 0.143, 0.010> <-0.232, 0.143, 0.002> <-0.236, 0.143, -0.010> <-0.243, 0.143, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.242, 0.147, -0.015> <-0.251, 0.148, -0.022> <-0.266, 0.149, -0.026> <-0.276, 0.150, -0.026> 
		<-0.243, 0.146, -0.015> <-0.251, 0.147, -0.021> <-0.266, 0.148, -0.025> <-0.277, 0.149, -0.025> 
		<-0.243, 0.144, -0.015> <-0.252, 0.145, -0.022> <-0.267, 0.146, -0.025> <-0.278, 0.147, -0.025> 
		<-0.243, 0.143, -0.015> <-0.251, 0.144, -0.022> <-0.267, 0.145, -0.026> <-0.278, 0.146, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.276, 0.150, -0.026> <-0.286, 0.151, -0.026> <-0.300, 0.152, -0.021> <-0.307, 0.153, -0.015> 
		<-0.277, 0.149, -0.025> <-0.286, 0.150, -0.025> <-0.299, 0.151, -0.021> <-0.306, 0.152, -0.014> 
		<-0.278, 0.147, -0.025> <-0.287, 0.148, -0.025> <-0.300, 0.149, -0.021> <-0.307, 0.150, -0.015> 
		<-0.278, 0.146, -0.026> <-0.287, 0.147, -0.026> <-0.300, 0.148, -0.021> <-0.307, 0.149, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.316, 0.150, 0.035> <-0.302, 0.148, 0.044> <-0.278, 0.145, 0.045> <-0.261, 0.144, 0.045> 
		<-0.316, 0.147, 0.036> <-0.302, 0.145, 0.045> <-0.278, 0.143, 0.046> <-0.262, 0.141, 0.046> 
		<-0.318, 0.144, 0.038> <-0.304, 0.143, 0.047> <-0.279, 0.140, 0.049> <-0.263, 0.139, 0.049> 
		<-0.317, 0.141, 0.038> <-0.304, 0.140, 0.048> <-0.280, 0.138, 0.050> <-0.263, 0.137, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.261, 0.144, 0.045> <-0.255, 0.143, 0.045> <-0.248, 0.143, 0.040> <-0.244, 0.143, 0.035> 
		<-0.262, 0.141, 0.046> <-0.256, 0.141, 0.046> <-0.247, 0.142, 0.041> <-0.243, 0.142, 0.036> 
		<-0.263, 0.139, 0.049> <-0.254, 0.139, 0.049> <-0.245, 0.141, 0.044> <-0.240, 0.141, 0.038> 
		<-0.263, 0.137, 0.050> <-0.255, 0.137, 0.050> <-0.244, 0.139, 0.045> <-0.238, 0.139, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.244, 0.143, 0.035> <-0.239, 0.143, 0.029> <-0.232, 0.143, 0.018> <-0.232, 0.143, 0.010> 
		<-0.243, 0.142, 0.036> <-0.237, 0.142, 0.029> <-0.230, 0.142, 0.018> <-0.230, 0.142, 0.010> 
		<-0.240, 0.141, 0.038> <-0.233, 0.142, 0.031> <-0.226, 0.142, 0.019> <-0.226, 0.142, 0.010> 
		<-0.238, 0.139, 0.039> <-0.232, 0.140, 0.032> <-0.225, 0.140, 0.019> <-0.225, 0.140, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.232, 0.143, 0.010> <-0.232, 0.143, 0.002> <-0.236, 0.143, -0.010> <-0.243, 0.143, -0.015> 
		<-0.230, 0.142, 0.010> <-0.230, 0.142, 0.002> <-0.235, 0.141, -0.011> <-0.241, 0.141, -0.016> 
		<-0.226, 0.142, 0.010> <-0.226, 0.142, 0.001> <-0.230, 0.141, -0.012> <-0.237, 0.141, -0.018> 
		<-0.225, 0.140, 0.010> <-0.225, 0.140, 0.001> <-0.229, 0.139, -0.013> <-0.236, 0.139, -0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.243, 0.143, -0.015> <-0.251, 0.144, -0.022> <-0.267, 0.145, -0.026> <-0.278, 0.146, -0.026> 
		<-0.241, 0.141, -0.016> <-0.250, 0.142, -0.023> <-0.266, 0.143, -0.027> <-0.277, 0.144, -0.027> 
		<-0.237, 0.141, -0.018> <-0.247, 0.141, -0.026> <-0.263, 0.141, -0.029> <-0.275, 0.141, -0.029> 
		<-0.236, 0.139, -0.019> <-0.245, 0.139, -0.027> <-0.263, 0.138, -0.031> <-0.275, 0.138, -0.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.278, 0.146, -0.026> <-0.287, 0.147, -0.026> <-0.300, 0.148, -0.021> <-0.307, 0.149, -0.015> 
		<-0.277, 0.144, -0.027> <-0.287, 0.144, -0.027> <-0.301, 0.146, -0.022> <-0.308, 0.146, -0.016> 
		<-0.275, 0.141, -0.029> <-0.287, 0.141, -0.029> <-0.303, 0.143, -0.025> <-0.312, 0.144, -0.018> 
		<-0.275, 0.138, -0.031> <-0.286, 0.139, -0.031> <-0.303, 0.140, -0.026> <-0.312, 0.141, -0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.317, 0.141, 0.038> <-0.304, 0.140, 0.048> <-0.280, 0.138, 0.050> <-0.263, 0.137, 0.050> 
		<-0.316, 0.137, 0.040> <-0.302, 0.136, 0.049> <-0.281, 0.135, 0.052> <-0.264, 0.134, 0.052> 
		<-0.311, 0.132, 0.041> <-0.300, 0.132, 0.050> <-0.278, 0.130, 0.054> <-0.265, 0.130, 0.054> 
		<-0.309, 0.127, 0.042> <-0.299, 0.127, 0.051> <-0.279, 0.127, 0.055> <-0.266, 0.127, 0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.263, 0.137, 0.050> <-0.255, 0.137, 0.050> <-0.244, 0.139, 0.045> <-0.238, 0.139, 0.039> 
		<-0.264, 0.134, 0.052> <-0.256, 0.134, 0.052> <-0.243, 0.136, 0.046> <-0.237, 0.137, 0.040> 
		<-0.265, 0.130, 0.054> <-0.255, 0.130, 0.054> <-0.243, 0.132, 0.049> <-0.236, 0.132, 0.041> 
		<-0.266, 0.127, 0.055> <-0.256, 0.127, 0.055> <-0.242, 0.128, 0.049> <-0.236, 0.129, 0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.238, 0.139, 0.039> <-0.232, 0.140, 0.032> <-0.225, 0.140, 0.019> <-0.225, 0.140, 0.010> 
		<-0.237, 0.137, 0.040> <-0.230, 0.137, 0.033> <-0.224, 0.137, 0.019> <-0.224, 0.137, 0.010> 
		<-0.236, 0.132, 0.041> <-0.229, 0.133, 0.034> <-0.225, 0.133, 0.020> <-0.225, 0.133, 0.010> 
		<-0.236, 0.129, 0.042> <-0.229, 0.129, 0.034> <-0.225, 0.130, 0.020> <-0.225, 0.130, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.225, 0.140, 0.010> <-0.225, 0.140, 0.001> <-0.229, 0.139, -0.013> <-0.236, 0.139, -0.019> 
		<-0.224, 0.137, 0.010> <-0.223, 0.137, 0.001> <-0.227, 0.137, -0.014> <-0.235, 0.136, -0.020> 
		<-0.225, 0.133, 0.010> <-0.225, 0.133, -0.000> <-0.228, 0.132, -0.015> <-0.235, 0.132, -0.022> 
		<-0.225, 0.130, 0.010> <-0.225, 0.130, -0.000> <-0.228, 0.129, -0.015> <-0.235, 0.128, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.236, 0.139, -0.019> <-0.245, 0.139, -0.027> <-0.263, 0.138, -0.031> <-0.275, 0.138, -0.031> 
		<-0.235, 0.136, -0.020> <-0.244, 0.136, -0.028> <-0.262, 0.135, -0.032> <-0.274, 0.135, -0.032> 
		<-0.235, 0.132, -0.022> <-0.244, 0.131, -0.030> <-0.261, 0.131, -0.035> <-0.273, 0.131, -0.035> 
		<-0.235, 0.128, -0.022> <-0.243, 0.128, -0.031> <-0.260, 0.128, -0.036> <-0.272, 0.128, -0.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.275, 0.138, -0.031> <-0.286, 0.139, -0.031> <-0.303, 0.140, -0.026> <-0.312, 0.141, -0.019> 
		<-0.274, 0.135, -0.032> <-0.286, 0.136, -0.032> <-0.304, 0.136, -0.028> <-0.313, 0.137, -0.020> 
		<-0.273, 0.131, -0.035> <-0.285, 0.131, -0.035> <-0.303, 0.132, -0.030> <-0.312, 0.132, -0.021> 
		<-0.272, 0.128, -0.036> <-0.284, 0.128, -0.035> <-0.302, 0.128, -0.030> <-0.311, 0.128, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.309, 0.127, 0.042> <-0.299, 0.127, 0.051> <-0.279, 0.127, 0.055> <-0.266, 0.127, 0.055> 
		<-0.307, 0.119, 0.043> <-0.296, 0.119, 0.052> <-0.282, 0.118, 0.057> <-0.268, 0.119, 0.057> 
		<-0.304, 0.107, 0.045> <-0.297, 0.107, 0.052> <-0.282, 0.108, 0.060> <-0.273, 0.108, 0.060> 
		<-0.304, 0.098, 0.046> <-0.297, 0.098, 0.053> <-0.284, 0.099, 0.060> <-0.274, 0.099, 0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.266, 0.127, 0.055> <-0.256, 0.127, 0.055> <-0.242, 0.128, 0.049> <-0.236, 0.129, 0.042> 
		<-0.268, 0.119, 0.057> <-0.258, 0.119, 0.057> <-0.242, 0.120, 0.051> <-0.235, 0.121, 0.043> 
		<-0.273, 0.108, 0.060> <-0.260, 0.108, 0.060> <-0.246, 0.109, 0.054> <-0.237, 0.109, 0.045> 
		<-0.274, 0.099, 0.060> <-0.262, 0.100, 0.060> <-0.245, 0.101, 0.054> <-0.236, 0.101, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.236, 0.129, 0.042> <-0.229, 0.129, 0.034> <-0.225, 0.130, 0.020> <-0.225, 0.130, 0.010> 
		<-0.235, 0.121, 0.043> <-0.228, 0.121, 0.036> <-0.224, 0.121, 0.020> <-0.224, 0.121, 0.010> 
		<-0.237, 0.109, 0.045> <-0.229, 0.110, 0.038> <-0.223, 0.110, 0.022> <-0.222, 0.110, 0.011> 
		<-0.236, 0.101, 0.045> <-0.228, 0.101, 0.038> <-0.222, 0.101, 0.022> <-0.221, 0.101, 0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.225, 0.130, 0.010> <-0.225, 0.130, -0.000> <-0.228, 0.129, -0.015> <-0.235, 0.128, -0.022> 
		<-0.224, 0.121, 0.010> <-0.224, 0.121, 0.000> <-0.226, 0.120, -0.017> <-0.234, 0.120, -0.024> 
		<-0.222, 0.110, 0.011> <-0.222, 0.110, -0.001> <-0.223, 0.109, -0.018> <-0.231, 0.108, -0.026> 
		<-0.221, 0.101, 0.011> <-0.221, 0.101, -0.001> <-0.223, 0.100, -0.018> <-0.231, 0.100, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.235, 0.128, -0.022> <-0.243, 0.128, -0.031> <-0.260, 0.128, -0.036> <-0.272, 0.128, -0.036> 
		<-0.234, 0.120, -0.024> <-0.242, 0.119, -0.032> <-0.260, 0.120, -0.038> <-0.271, 0.119, -0.037> 
		<-0.231, 0.108, -0.026> <-0.240, 0.108, -0.035> <-0.259, 0.108, -0.040> <-0.272, 0.108, -0.040> 
		<-0.231, 0.100, -0.026> <-0.240, 0.099, -0.035> <-0.258, 0.100, -0.040> <-0.271, 0.100, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.272, 0.128, -0.036> <-0.284, 0.128, -0.035> <-0.302, 0.128, -0.030> <-0.311, 0.128, -0.022> 
		<-0.271, 0.119, -0.037> <-0.284, 0.119, -0.037> <-0.299, 0.119, -0.032> <-0.308, 0.119, -0.023> 
		<-0.272, 0.108, -0.040> <-0.281, 0.108, -0.040> <-0.295, 0.108, -0.032> <-0.302, 0.108, -0.025> 
		<-0.271, 0.100, -0.040> <-0.281, 0.099, -0.040> <-0.293, 0.098, -0.032> <-0.300, 0.099, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.304, 0.098, 0.046> <-0.297, 0.098, 0.053> <-0.284, 0.099, 0.060> <-0.274, 0.099, 0.060> 
		<-0.304, 0.090, 0.046> <-0.297, 0.090, 0.053> <-0.285, 0.091, 0.060> <-0.276, 0.091, 0.060> 
		<-0.309, 0.079, 0.044> <-0.301, 0.080, 0.052> <-0.287, 0.080, 0.057> <-0.275, 0.080, 0.057> 
		<-0.310, 0.071, 0.043> <-0.302, 0.071, 0.051> <-0.286, 0.072, 0.055> <-0.275, 0.072, 0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.274, 0.099, 0.060> <-0.262, 0.100, 0.060> <-0.245, 0.101, 0.054> <-0.236, 0.101, 0.045> 
		<-0.276, 0.091, 0.060> <-0.263, 0.092, 0.060> <-0.244, 0.091, 0.054> <-0.235, 0.092, 0.045> 
		<-0.275, 0.080, 0.057> <-0.261, 0.080, 0.057> <-0.242, 0.080, 0.053> <-0.230, 0.080, 0.043> 
		<-0.275, 0.072, 0.055> <-0.260, 0.072, 0.055> <-0.240, 0.071, 0.051> <-0.228, 0.071, 0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.236, 0.101, 0.045> <-0.228, 0.101, 0.038> <-0.222, 0.101, 0.022> <-0.221, 0.101, 0.011> 
		<-0.235, 0.092, 0.045> <-0.226, 0.092, 0.038> <-0.221, 0.092, 0.022> <-0.220, 0.092, 0.011> 
		<-0.230, 0.080, 0.043> <-0.222, 0.080, 0.037> <-0.216, 0.080, 0.020> <-0.216, 0.080, 0.010> 
		<-0.228, 0.071, 0.042> <-0.220, 0.071, 0.036> <-0.217, 0.071, 0.020> <-0.217, 0.071, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.221, 0.101, 0.011> <-0.221, 0.101, -0.001> <-0.223, 0.100, -0.018> <-0.231, 0.100, -0.026> 
		<-0.220, 0.092, 0.011> <-0.219, 0.092, -0.001> <-0.223, 0.091, -0.018> <-0.230, 0.091, -0.026> 
		<-0.216, 0.080, 0.010> <-0.217, 0.080, -0.000> <-0.222, 0.080, -0.017> <-0.230, 0.080, -0.024> 
		<-0.217, 0.071, 0.010> <-0.218, 0.072, -0.001> <-0.224, 0.072, -0.015> <-0.232, 0.072, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.231, 0.100, -0.026> <-0.240, 0.099, -0.035> <-0.258, 0.100, -0.040> <-0.271, 0.100, -0.040> 
		<-0.230, 0.091, -0.026> <-0.239, 0.091, -0.035> <-0.258, 0.091, -0.040> <-0.270, 0.091, -0.040> 
		<-0.230, 0.080, -0.024> <-0.239, 0.080, -0.031> <-0.258, 0.080, -0.036> <-0.269, 0.079, -0.036> 
		<-0.232, 0.072, -0.022> <-0.241, 0.071, -0.029> <-0.257, 0.071, -0.034> <-0.268, 0.071, -0.034> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.271, 0.100, -0.040> <-0.281, 0.099, -0.040> <-0.293, 0.098, -0.032> <-0.300, 0.099, -0.025> 
		<-0.270, 0.091, -0.040> <-0.280, 0.091, -0.039> <-0.291, 0.090, -0.032> <-0.298, 0.090, -0.025> 
		<-0.269, 0.079, -0.036> <-0.279, 0.079, -0.036> <-0.291, 0.078, -0.029> <-0.298, 0.078, -0.023> 
		<-0.268, 0.071, -0.034> <-0.278, 0.071, -0.034> <-0.290, 0.069, -0.028> <-0.297, 0.069, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.310, 0.071, 0.043> <-0.302, 0.071, 0.051> <-0.286, 0.072, 0.055> <-0.275, 0.072, 0.055> 
		<-0.311, 0.068, 0.042> <-0.303, 0.068, 0.050> <-0.286, 0.068, 0.055> <-0.275, 0.068, 0.054> 
		<-0.310, 0.063, 0.041> <-0.302, 0.063, 0.049> <-0.285, 0.064, 0.053> <-0.273, 0.064, 0.053> 
		<-0.308, 0.061, 0.039> <-0.300, 0.061, 0.047> <-0.284, 0.061, 0.051> <-0.273, 0.061, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.275, 0.072, 0.055> <-0.260, 0.072, 0.055> <-0.240, 0.071, 0.051> <-0.228, 0.071, 0.042> 
		<-0.275, 0.068, 0.054> <-0.260, 0.068, 0.054> <-0.239, 0.068, 0.050> <-0.227, 0.068, 0.041> 
		<-0.273, 0.064, 0.053> <-0.259, 0.064, 0.052> <-0.236, 0.063, 0.050> <-0.225, 0.063, 0.040> 
		<-0.273, 0.061, 0.050> <-0.258, 0.061, 0.050> <-0.237, 0.060, 0.048> <-0.226, 0.060, 0.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.228, 0.071, 0.042> <-0.220, 0.071, 0.036> <-0.217, 0.071, 0.020> <-0.217, 0.071, 0.010> 
		<-0.227, 0.068, 0.041> <-0.219, 0.067, 0.035> <-0.217, 0.067, 0.020> <-0.218, 0.067, 0.010> 
		<-0.225, 0.063, 0.040> <-0.218, 0.063, 0.034> <-0.221, 0.064, 0.018> <-0.223, 0.064, 0.010> 
		<-0.226, 0.060, 0.038> <-0.219, 0.060, 0.033> <-0.224, 0.061, 0.018> <-0.226, 0.061, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.217, 0.071, 0.010> <-0.218, 0.072, -0.001> <-0.224, 0.072, -0.015> <-0.232, 0.072, -0.022> 
		<-0.218, 0.067, 0.010> <-0.219, 0.068, -0.001> <-0.225, 0.068, -0.014> <-0.233, 0.068, -0.021> 
		<-0.223, 0.064, 0.010> <-0.226, 0.064, 0.001> <-0.231, 0.064, -0.013> <-0.238, 0.064, -0.020> 
		<-0.226, 0.061, 0.010> <-0.229, 0.062, 0.001> <-0.234, 0.062, -0.011> <-0.241, 0.062, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.232, 0.072, -0.022> <-0.241, 0.071, -0.029> <-0.257, 0.071, -0.034> <-0.268, 0.071, -0.034> 
		<-0.233, 0.068, -0.021> <-0.242, 0.068, -0.029> <-0.257, 0.068, -0.033> <-0.268, 0.068, -0.033> 
		<-0.238, 0.064, -0.020> <-0.244, 0.064, -0.026> <-0.259, 0.064, -0.031> <-0.267, 0.063, -0.031> 
		<-0.241, 0.062, -0.018> <-0.247, 0.061, -0.024> <-0.258, 0.061, -0.029> <-0.267, 0.061, -0.029> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.268, 0.071, -0.034> <-0.278, 0.071, -0.034> <-0.290, 0.069, -0.028> <-0.297, 0.069, -0.022> 
		<-0.268, 0.068, -0.033> <-0.277, 0.067, -0.033> <-0.289, 0.066, -0.027> <-0.296, 0.066, -0.021> 
		<-0.267, 0.063, -0.031> <-0.276, 0.063, -0.032> <-0.288, 0.062, -0.025> <-0.295, 0.062, -0.020> 
		<-0.267, 0.061, -0.029> <-0.276, 0.060, -0.029> <-0.287, 0.059, -0.024> <-0.293, 0.059, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.308, 0.061, 0.039> <-0.300, 0.061, 0.047> <-0.284, 0.061, 0.051> <-0.273, 0.061, 0.050> 
		<-0.305, 0.057, 0.037> <-0.297, 0.057, 0.045> <-0.283, 0.058, 0.048> <-0.272, 0.058, 0.048> 
		<-0.299, 0.055, 0.034> <-0.294, 0.056, 0.040> <-0.279, 0.056, 0.044> <-0.271, 0.056, 0.044> 
		<-0.296, 0.053, 0.032> <-0.290, 0.053, 0.038> <-0.278, 0.054, 0.041> <-0.270, 0.054, 0.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.273, 0.061, 0.050> <-0.258, 0.061, 0.050> <-0.237, 0.060, 0.048> <-0.226, 0.060, 0.038> 
		<-0.272, 0.058, 0.048> <-0.257, 0.058, 0.048> <-0.238, 0.057, 0.046> <-0.227, 0.057, 0.036> 
		<-0.271, 0.056, 0.044> <-0.260, 0.056, 0.043> <-0.240, 0.055, 0.041> <-0.232, 0.055, 0.033> 
		<-0.270, 0.054, 0.041> <-0.259, 0.054, 0.040> <-0.243, 0.053, 0.039> <-0.235, 0.053, 0.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.226, 0.060, 0.038> <-0.219, 0.060, 0.033> <-0.224, 0.061, 0.018> <-0.226, 0.061, 0.010> 
		<-0.227, 0.057, 0.036> <-0.221, 0.057, 0.031> <-0.228, 0.058, 0.018> <-0.230, 0.059, 0.010> 
		<-0.232, 0.055, 0.033> <-0.227, 0.055, 0.029> <-0.233, 0.056, 0.016> <-0.235, 0.056, 0.010> 
		<-0.235, 0.053, 0.031> <-0.230, 0.053, 0.027> <-0.237, 0.054, 0.016> <-0.239, 0.054, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.226, 0.061, 0.010> <-0.229, 0.062, 0.001> <-0.234, 0.062, -0.011> <-0.241, 0.062, -0.018> 
		<-0.230, 0.059, 0.010> <-0.232, 0.059, 0.001> <-0.237, 0.059, -0.010> <-0.244, 0.059, -0.016> 
		<-0.235, 0.056, 0.010> <-0.238, 0.056, 0.003> <-0.243, 0.057, -0.008> <-0.248, 0.057, -0.013> 
		<-0.239, 0.054, 0.010> <-0.242, 0.054, 0.004> <-0.246, 0.054, -0.005> <-0.251, 0.054, -0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.241, 0.062, -0.018> <-0.247, 0.061, -0.024> <-0.258, 0.061, -0.029> <-0.267, 0.061, -0.029> 
		<-0.244, 0.059, -0.016> <-0.250, 0.059, -0.022> <-0.258, 0.058, -0.027> <-0.267, 0.058, -0.027> 
		<-0.248, 0.057, -0.013> <-0.252, 0.056, -0.017> <-0.262, 0.056, -0.022> <-0.267, 0.055, -0.022> 
		<-0.251, 0.054, -0.011> <-0.255, 0.054, -0.014> <-0.262, 0.054, -0.019> <-0.267, 0.053, -0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.267, 0.061, -0.029> <-0.276, 0.060, -0.029> <-0.287, 0.059, -0.024> <-0.293, 0.059, -0.018> 
		<-0.267, 0.058, -0.027> <-0.275, 0.057, -0.027> <-0.285, 0.056, -0.022> <-0.292, 0.056, -0.017> 
		<-0.267, 0.055, -0.022> <-0.273, 0.055, -0.023> <-0.284, 0.054, -0.018> <-0.288, 0.054, -0.013> 
		<-0.267, 0.053, -0.019> <-0.273, 0.053, -0.020> <-0.281, 0.052, -0.016> <-0.286, 0.052, -0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.296, 0.053, 0.032> <-0.290, 0.053, 0.038> <-0.278, 0.054, 0.041> <-0.270, 0.054, 0.041> 
		<-0.294, 0.052, 0.031> <-0.288, 0.052, 0.037> <-0.278, 0.052, 0.039> <-0.270, 0.052, 0.039> 
		<-0.290, 0.052, 0.029> <-0.286, 0.052, 0.033> <-0.275, 0.052, 0.036> <-0.269, 0.052, 0.036> 
		<-0.289, 0.049, 0.029> <-0.284, 0.049, 0.033> <-0.275, 0.050, 0.036> <-0.268, 0.050, 0.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.270, 0.054, 0.041> <-0.259, 0.054, 0.040> <-0.243, 0.053, 0.039> <-0.235, 0.053, 0.031> 
		<-0.270, 0.052, 0.039> <-0.259, 0.052, 0.039> <-0.245, 0.052, 0.037> <-0.237, 0.052, 0.030> 
		<-0.269, 0.052, 0.036> <-0.261, 0.052, 0.036> <-0.248, 0.052, 0.033> <-0.242, 0.052, 0.028> 
		<-0.268, 0.050, 0.036> <-0.261, 0.050, 0.036> <-0.249, 0.050, 0.033> <-0.244, 0.050, 0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.235, 0.053, 0.031> <-0.230, 0.053, 0.027> <-0.237, 0.054, 0.016> <-0.239, 0.054, 0.010> 
		<-0.237, 0.052, 0.030> <-0.233, 0.052, 0.025> <-0.239, 0.053, 0.016> <-0.241, 0.053, 0.010> 
		<-0.242, 0.052, 0.028> <-0.239, 0.052, 0.024> <-0.243, 0.052, 0.015> <-0.245, 0.052, 0.010> 
		<-0.244, 0.050, 0.028> <-0.241, 0.050, 0.024> <-0.244, 0.050, 0.015> <-0.245, 0.050, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.239, 0.054, 0.010> <-0.242, 0.054, 0.004> <-0.246, 0.054, -0.005> <-0.251, 0.054, -0.011> 
		<-0.241, 0.053, 0.010> <-0.244, 0.053, 0.004> <-0.248, 0.053, -0.004> <-0.253, 0.053, -0.010> 
		<-0.245, 0.052, 0.010> <-0.247, 0.052, 0.005> <-0.251, 0.052, -0.003> <-0.255, 0.052, -0.007> 
		<-0.245, 0.050, 0.010> <-0.247, 0.050, 0.005> <-0.251, 0.050, -0.002> <-0.255, 0.050, -0.007> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.251, 0.054, -0.011> <-0.255, 0.054, -0.014> <-0.262, 0.054, -0.019> <-0.267, 0.053, -0.019> 
		<-0.253, 0.053, -0.010> <-0.256, 0.053, -0.014> <-0.262, 0.052, -0.018> <-0.267, 0.052, -0.018> 
		<-0.255, 0.052, -0.007> <-0.258, 0.052, -0.010> <-0.263, 0.052, -0.014> <-0.267, 0.051, -0.015> 
		<-0.255, 0.050, -0.007> <-0.258, 0.050, -0.010> <-0.262, 0.050, -0.014> <-0.266, 0.050, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.267, 0.053, -0.019> <-0.273, 0.053, -0.020> <-0.281, 0.052, -0.016> <-0.286, 0.052, -0.011> 
		<-0.267, 0.052, -0.018> <-0.273, 0.052, -0.018> <-0.280, 0.051, -0.014> <-0.285, 0.051, -0.010> 
		<-0.267, 0.051, -0.015> <-0.272, 0.051, -0.015> <-0.278, 0.051, -0.011> <-0.282, 0.051, -0.008> 
		<-0.266, 0.050, -0.015> <-0.271, 0.049, -0.015> <-0.278, 0.049, -0.011> <-0.281, 0.049, -0.008> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.289, 0.049, 0.029> <-0.284, 0.049, 0.033> <-0.275, 0.050, 0.036> <-0.268, 0.050, 0.036> 
		<-0.288, 0.048, 0.029> <-0.284, 0.048, 0.033> <-0.275, 0.048, 0.036> <-0.268, 0.048, 0.036> 
		<-0.292, 0.047, 0.032> <-0.288, 0.047, 0.038> <-0.276, 0.048, 0.041> <-0.269, 0.048, 0.041> 
		<-0.291, 0.045, 0.032> <-0.287, 0.046, 0.038> <-0.276, 0.046, 0.041> <-0.269, 0.046, 0.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.268, 0.050, 0.036> <-0.261, 0.050, 0.036> <-0.249, 0.050, 0.033> <-0.244, 0.050, 0.028> 
		<-0.268, 0.048, 0.036> <-0.261, 0.048, 0.036> <-0.251, 0.048, 0.033> <-0.245, 0.048, 0.028> 
		<-0.269, 0.048, 0.041> <-0.260, 0.048, 0.040> <-0.245, 0.048, 0.038> <-0.239, 0.048, 0.031> 
		<-0.269, 0.046, 0.041> <-0.260, 0.046, 0.040> <-0.246, 0.046, 0.038> <-0.240, 0.046, 0.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.244, 0.050, 0.028> <-0.241, 0.050, 0.024> <-0.244, 0.050, 0.015> <-0.245, 0.050, 0.010> 
		<-0.245, 0.048, 0.028> <-0.242, 0.048, 0.024> <-0.244, 0.048, 0.015> <-0.245, 0.048, 0.011> 
		<-0.239, 0.048, 0.031> <-0.234, 0.048, 0.027> <-0.237, 0.049, 0.016> <-0.239, 0.049, 0.010> 
		<-0.240, 0.046, 0.031> <-0.235, 0.046, 0.027> <-0.237, 0.047, 0.016> <-0.239, 0.047, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.245, 0.050, 0.010> <-0.247, 0.050, 0.005> <-0.251, 0.050, -0.002> <-0.255, 0.050, -0.007> 
		<-0.245, 0.048, 0.011> <-0.247, 0.048, 0.005> <-0.251, 0.048, -0.002> <-0.255, 0.048, -0.007> 
		<-0.239, 0.049, 0.010> <-0.241, 0.049, 0.003> <-0.246, 0.049, -0.005> <-0.251, 0.049, -0.010> 
		<-0.239, 0.047, 0.010> <-0.241, 0.047, 0.003> <-0.246, 0.047, -0.005> <-0.251, 0.047, -0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.255, 0.050, -0.007> <-0.258, 0.050, -0.010> <-0.262, 0.050, -0.014> <-0.266, 0.050, -0.015> 
		<-0.255, 0.048, -0.007> <-0.257, 0.048, -0.010> <-0.262, 0.048, -0.014> <-0.266, 0.048, -0.014> 
		<-0.251, 0.049, -0.010> <-0.255, 0.049, -0.014> <-0.261, 0.048, -0.019> <-0.266, 0.048, -0.019> 
		<-0.251, 0.047, -0.010> <-0.254, 0.047, -0.014> <-0.261, 0.046, -0.019> <-0.266, 0.046, -0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.266, 0.050, -0.015> <-0.271, 0.049, -0.015> <-0.278, 0.049, -0.011> <-0.281, 0.049, -0.008> 
		<-0.266, 0.048, -0.014> <-0.271, 0.047, -0.015> <-0.277, 0.047, -0.011> <-0.280, 0.047, -0.008> 
		<-0.266, 0.048, -0.019> <-0.272, 0.048, -0.019> <-0.280, 0.047, -0.015> <-0.284, 0.047, -0.011> 
		<-0.266, 0.046, -0.019> <-0.272, 0.046, -0.019> <-0.279, 0.045, -0.015> <-0.284, 0.045, -0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.291, 0.045, 0.032> <-0.287, 0.046, 0.038> <-0.276, 0.046, 0.041> <-0.269, 0.046, 0.041> 
		<-0.290, 0.043, 0.032> <-0.285, 0.043, 0.038> <-0.276, 0.044, 0.041> <-0.269, 0.044, 0.040> 
		<-0.287, 0.043, 0.030> <-0.283, 0.043, 0.034> <-0.273, 0.043, 0.037> <-0.268, 0.043, 0.037> 
		<-0.285, 0.042, 0.029> <-0.281, 0.042, 0.033> <-0.273, 0.042, 0.036> <-0.267, 0.042, 0.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.269, 0.046, 0.041> <-0.260, 0.046, 0.040> <-0.246, 0.046, 0.038> <-0.240, 0.046, 0.031> 
		<-0.269, 0.044, 0.040> <-0.259, 0.044, 0.040> <-0.247, 0.044, 0.038> <-0.241, 0.044, 0.031> 
		<-0.268, 0.043, 0.037> <-0.261, 0.043, 0.037> <-0.249, 0.043, 0.034> <-0.245, 0.044, 0.029> 
		<-0.267, 0.042, 0.036> <-0.261, 0.042, 0.035> <-0.252, 0.042, 0.033> <-0.247, 0.042, 0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.240, 0.046, 0.031> <-0.235, 0.046, 0.027> <-0.237, 0.047, 0.016> <-0.239, 0.047, 0.010> 
		<-0.241, 0.044, 0.031> <-0.236, 0.044, 0.027> <-0.238, 0.044, 0.016> <-0.239, 0.044, 0.010> 
		<-0.245, 0.044, 0.029> <-0.242, 0.044, 0.025> <-0.243, 0.044, 0.016> <-0.244, 0.044, 0.011> 
		<-0.247, 0.042, 0.028> <-0.244, 0.043, 0.024> <-0.245, 0.043, 0.016> <-0.246, 0.043, 0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.239, 0.047, 0.010> <-0.241, 0.047, 0.003> <-0.246, 0.047, -0.005> <-0.251, 0.047, -0.010> 
		<-0.239, 0.044, 0.010> <-0.241, 0.045, 0.004> <-0.246, 0.045, -0.005> <-0.251, 0.045, -0.010> 
		<-0.244, 0.044, 0.011> <-0.245, 0.044, 0.005> <-0.250, 0.044, -0.003> <-0.253, 0.044, -0.008> 
		<-0.246, 0.043, 0.011> <-0.247, 0.043, 0.005> <-0.251, 0.043, -0.002> <-0.254, 0.043, -0.007> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.251, 0.047, -0.010> <-0.254, 0.047, -0.014> <-0.261, 0.046, -0.019> <-0.266, 0.046, -0.019> 
		<-0.251, 0.045, -0.010> <-0.254, 0.045, -0.014> <-0.260, 0.045, -0.019> <-0.265, 0.044, -0.019> 
		<-0.253, 0.044, -0.008> <-0.256, 0.044, -0.011> <-0.261, 0.044, -0.016> <-0.265, 0.043, -0.016> 
		<-0.254, 0.043, -0.007> <-0.257, 0.043, -0.010> <-0.261, 0.043, -0.014> <-0.265, 0.042, -0.014> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.266, 0.046, -0.019> <-0.272, 0.046, -0.019> <-0.279, 0.045, -0.015> <-0.284, 0.045, -0.011> 
		<-0.265, 0.044, -0.019> <-0.271, 0.044, -0.019> <-0.279, 0.043, -0.015> <-0.283, 0.043, -0.011> 
		<-0.265, 0.043, -0.016> <-0.270, 0.043, -0.016> <-0.277, 0.043, -0.012> <-0.280, 0.042, -0.009> 
		<-0.265, 0.042, -0.014> <-0.269, 0.042, -0.014> <-0.275, 0.041, -0.011> <-0.278, 0.041, -0.007> 
	}
	texture { T_Layer3 }
	scale MeshScale
}
// Layer 4
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.318, 0.154, 0.010> <0.316, 0.154, 0.002> <0.314, 0.153, -0.010> <0.308, 0.153, -0.015> 
		<0.319, 0.155, 0.010> <0.317, 0.155, 0.002> <0.315, 0.155, -0.010> <0.309, 0.154, -0.016> 
		<0.321, 0.156, 0.010> <0.320, 0.156, 0.001> <0.319, 0.156, -0.011> <0.312, 0.155, -0.017> 
		<0.322, 0.158, 0.010> <0.321, 0.158, 0.001> <0.320, 0.157, -0.012> <0.313, 0.157, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.318, 0.154, 0.010> <0.319, 0.155, 0.010> <0.321, 0.156, 0.010> <0.322, 0.158, 0.010> 
		<0.320, 0.154, 0.017> <0.320, 0.155, 0.017> <0.323, 0.156, 0.018> <0.324, 0.158, 0.018> 
		<0.325, 0.154, 0.031> <0.326, 0.156, 0.032> <0.331, 0.156, 0.032> <0.331, 0.158, 0.034> 
		<0.319, 0.153, 0.035> <0.320, 0.155, 0.036> <0.324, 0.156, 0.037> <0.324, 0.158, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.318, 0.154, 0.010> <0.318, 0.153, 0.010> <0.318, 0.151, 0.010> <0.318, 0.150, 0.010> 
		<0.316, 0.154, 0.002> <0.316, 0.153, 0.002> <0.317, 0.151, 0.002> <0.317, 0.150, 0.002> 
		<0.314, 0.153, -0.010> <0.314, 0.152, -0.009> <0.314, 0.150, -0.009> <0.315, 0.149, -0.010> 
		<0.308, 0.153, -0.015> <0.308, 0.152, -0.014> <0.308, 0.150, -0.015> <0.309, 0.149, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.318, 0.154, 0.010> <0.320, 0.154, 0.017> <0.325, 0.154, 0.031> <0.319, 0.153, 0.035> 
		<0.318, 0.153, 0.010> <0.319, 0.153, 0.017> <0.324, 0.153, 0.030> <0.318, 0.152, 0.035> 
		<0.318, 0.151, 0.010> <0.319, 0.151, 0.017> <0.324, 0.151, 0.031> <0.318, 0.151, 0.035> 
		<0.318, 0.150, 0.010> <0.320, 0.150, 0.017> <0.324, 0.150, 0.031> <0.318, 0.150, 0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.318, 0.150, 0.010> <0.319, 0.147, 0.010> <0.322, 0.145, 0.010> <0.322, 0.142, 0.010> 
		<0.317, 0.150, 0.002> <0.318, 0.147, 0.002> <0.321, 0.144, 0.001> <0.321, 0.142, 0.001> 
		<0.315, 0.149, -0.010> <0.316, 0.147, -0.010> <0.320, 0.144, -0.012> <0.320, 0.142, -0.013> 
		<0.309, 0.149, -0.015> <0.310, 0.146, -0.016> <0.313, 0.144, -0.018> <0.313, 0.141, -0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.318, 0.150, 0.010> <0.320, 0.150, 0.017> <0.324, 0.150, 0.031> <0.318, 0.150, 0.035> 
		<0.319, 0.147, 0.010> <0.321, 0.148, 0.017> <0.324, 0.148, 0.032> <0.318, 0.147, 0.036> 
		<0.322, 0.145, 0.010> <0.323, 0.145, 0.018> <0.326, 0.144, 0.033> <0.319, 0.144, 0.038> 
		<0.322, 0.142, 0.010> <0.323, 0.142, 0.018> <0.326, 0.142, 0.033> <0.318, 0.141, 0.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.322, 0.142, 0.010> <0.323, 0.137, 0.010> <0.321, 0.132, 0.010> <0.321, 0.127, 0.010> 
		<0.321, 0.142, 0.001> <0.322, 0.137, 0.001> <0.321, 0.132, -0.000> <0.321, 0.127, 0.000> 
		<0.320, 0.142, -0.013> <0.321, 0.138, -0.014> <0.320, 0.132, -0.014> <0.319, 0.128, -0.015> 
		<0.313, 0.141, -0.019> <0.314, 0.137, -0.020> <0.313, 0.132, -0.021> <0.312, 0.128, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.322, 0.142, 0.010> <0.323, 0.142, 0.018> <0.326, 0.142, 0.033> <0.318, 0.141, 0.038> 
		<0.323, 0.137, 0.010> <0.324, 0.138, 0.018> <0.324, 0.137, 0.035> <0.317, 0.137, 0.040> 
		<0.321, 0.132, 0.010> <0.321, 0.132, 0.020> <0.320, 0.132, 0.035> <0.312, 0.132, 0.041> 
		<0.321, 0.127, 0.010> <0.321, 0.127, 0.020> <0.319, 0.127, 0.036> <0.311, 0.127, 0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.289, 0.041, 0.010> <0.288, 0.041, 0.004> <0.284, 0.041, -0.003> <0.280, 0.041, -0.007> 
		<0.292, 0.042, 0.010> <0.291, 0.042, 0.004> <0.285, 0.042, -0.004> <0.281, 0.042, -0.009> 
		<0.296, 0.043, 0.010> <0.295, 0.043, 0.003> <0.289, 0.043, -0.006> <0.284, 0.043, -0.011> 
		<0.297, 0.045, 0.010> <0.296, 0.045, 0.003> <0.290, 0.045, -0.006> <0.285, 0.045, -0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.289, 0.041, 0.010> <0.292, 0.042, 0.010> <0.296, 0.043, 0.010> <0.297, 0.045, 0.010> 
		<0.290, 0.041, 0.016> <0.293, 0.042, 0.016> <0.297, 0.043, 0.017> <0.298, 0.045, 0.017> 
		<0.290, 0.041, 0.024> <0.292, 0.043, 0.025> <0.296, 0.043, 0.027> <0.297, 0.045, 0.027> 
		<0.286, 0.042, 0.029> <0.288, 0.043, 0.030> <0.292, 0.043, 0.032> <0.293, 0.045, 0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.322, 0.070, 0.010> <0.320, 0.070, -0.002> <0.307, 0.069, -0.014> <0.298, 0.069, -0.022> 
		<0.324, 0.079, 0.010> <0.322, 0.079, -0.001> <0.309, 0.078, -0.015> <0.300, 0.078, -0.023> 
		<0.324, 0.092, 0.011> <0.323, 0.092, -0.002> <0.308, 0.090, -0.016> <0.299, 0.090, -0.025> 
		<0.324, 0.101, 0.011> <0.323, 0.101, -0.002> <0.310, 0.099, -0.016> <0.301, 0.099, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.322, 0.070, 0.010> <0.324, 0.079, 0.010> <0.324, 0.092, 0.011> <0.324, 0.101, 0.011> 
		<0.324, 0.071, 0.020> <0.326, 0.080, 0.020> <0.325, 0.092, 0.023> <0.324, 0.101, 0.023> 
		<0.319, 0.071, 0.036> <0.318, 0.079, 0.037> <0.313, 0.090, 0.037> <0.313, 0.099, 0.037> 
		<0.312, 0.071, 0.043> <0.311, 0.079, 0.044> <0.305, 0.090, 0.046> <0.305, 0.098, 0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.322, 0.070, 0.010> <0.322, 0.067, 0.010> <0.318, 0.062, 0.010> <0.316, 0.060, 0.010> 
		<0.320, 0.070, -0.002> <0.319, 0.066, -0.002> <0.316, 0.062, -0.000> <0.313, 0.059, -0.000> 
		<0.307, 0.069, -0.014> <0.307, 0.066, -0.013> <0.304, 0.061, -0.013> <0.303, 0.059, -0.012> 
		<0.298, 0.069, -0.022> <0.298, 0.066, -0.021> <0.296, 0.062, -0.020> <0.295, 0.059, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.322, 0.070, 0.010> <0.324, 0.071, 0.020> <0.319, 0.071, 0.036> <0.312, 0.071, 0.043> 
		<0.322, 0.067, 0.010> <0.324, 0.067, 0.020> <0.319, 0.067, 0.035> <0.312, 0.068, 0.042> 
		<0.318, 0.062, 0.010> <0.321, 0.062, 0.019> <0.318, 0.063, 0.035> <0.311, 0.063, 0.041> 
		<0.316, 0.060, 0.010> <0.318, 0.060, 0.019> <0.316, 0.060, 0.033> <0.309, 0.061, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.301, 0.052, 0.010> <0.299, 0.052, 0.003> <0.293, 0.052, -0.006> <0.287, 0.052, -0.011> 
		<0.305, 0.055, 0.010> <0.303, 0.054, 0.003> <0.295, 0.054, -0.008> <0.290, 0.054, -0.013> 
		<0.312, 0.057, 0.010> <0.309, 0.056, -0.000> <0.301, 0.056, -0.010> <0.293, 0.056, -0.017> 
		<0.316, 0.060, 0.010> <0.313, 0.059, -0.000> <0.303, 0.059, -0.012> <0.295, 0.059, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.301, 0.052, 0.010> <0.305, 0.055, 0.010> <0.312, 0.057, 0.010> <0.316, 0.060, 0.010> 
		<0.302, 0.053, 0.017> <0.307, 0.055, 0.017> <0.314, 0.057, 0.019> <0.318, 0.060, 0.019> 
		<0.302, 0.053, 0.027> <0.305, 0.055, 0.030> <0.313, 0.057, 0.031> <0.316, 0.060, 0.033> 
		<0.297, 0.053, 0.032> <0.301, 0.055, 0.034> <0.306, 0.057, 0.037> <0.309, 0.061, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.301, 0.052, 0.010> <0.298, 0.051, 0.010> <0.294, 0.051, 0.010> <0.293, 0.049, 0.010> 
		<0.299, 0.052, 0.003> <0.297, 0.051, 0.003> <0.293, 0.051, 0.004> <0.292, 0.049, 0.004> 
		<0.293, 0.052, -0.006> <0.292, 0.051, -0.005> <0.288, 0.050, -0.003> <0.287, 0.048, -0.003> 
		<0.287, 0.052, -0.011> <0.286, 0.051, -0.010> <0.283, 0.051, -0.008> <0.282, 0.049, -0.008> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.301, 0.052, 0.010> <0.302, 0.053, 0.017> <0.302, 0.053, 0.027> <0.297, 0.053, 0.032> 
		<0.298, 0.051, 0.010> <0.300, 0.051, 0.017> <0.300, 0.052, 0.026> <0.295, 0.052, 0.031> 
		<0.294, 0.051, 0.010> <0.295, 0.051, 0.016> <0.295, 0.051, 0.024> <0.291, 0.052, 0.029> 
		<0.293, 0.049, 0.010> <0.294, 0.049, 0.016> <0.294, 0.049, 0.024> <0.290, 0.049, 0.029> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.293, 0.049, 0.010> <0.292, 0.047, 0.010> <0.298, 0.046, 0.010> <0.297, 0.045, 0.010> 
		<0.292, 0.049, 0.004> <0.291, 0.047, 0.004> <0.296, 0.046, 0.003> <0.296, 0.045, 0.003> 
		<0.287, 0.048, -0.003> <0.286, 0.047, -0.003> <0.291, 0.046, -0.006> <0.290, 0.045, -0.006> 
		<0.282, 0.049, -0.008> <0.282, 0.047, -0.008> <0.286, 0.047, -0.011> <0.285, 0.045, -0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.293, 0.049, 0.010> <0.294, 0.049, 0.016> <0.294, 0.049, 0.024> <0.290, 0.049, 0.029> 
		<0.292, 0.047, 0.010> <0.294, 0.047, 0.016> <0.293, 0.048, 0.024> <0.289, 0.048, 0.029> 
		<0.298, 0.046, 0.010> <0.299, 0.046, 0.017> <0.298, 0.047, 0.027> <0.294, 0.047, 0.032> 
		<0.297, 0.045, 0.010> <0.298, 0.045, 0.017> <0.297, 0.045, 0.027> <0.293, 0.045, 0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.321, 0.127, 0.010> <0.322, 0.120, 0.010> <0.324, 0.109, 0.011> <0.324, 0.101, 0.011> 
		<0.321, 0.127, 0.000> <0.322, 0.120, 0.000> <0.323, 0.109, -0.002> <0.323, 0.101, -0.002> 
		<0.319, 0.128, -0.015> <0.317, 0.119, -0.016> <0.312, 0.108, -0.016> <0.310, 0.099, -0.016> 
		<0.312, 0.128, -0.022> <0.309, 0.119, -0.023> <0.303, 0.108, -0.025> <0.301, 0.099, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.321, 0.127, 0.010> <0.321, 0.127, 0.020> <0.319, 0.127, 0.036> <0.311, 0.127, 0.042> 
		<0.322, 0.120, 0.010> <0.321, 0.119, 0.020> <0.316, 0.119, 0.037> <0.308, 0.119, 0.043> 
		<0.324, 0.109, 0.011> <0.324, 0.109, 0.023> <0.313, 0.108, 0.037> <0.305, 0.107, 0.045> 
		<0.324, 0.101, 0.011> <0.324, 0.101, 0.023> <0.313, 0.099, 0.037> <0.305, 0.098, 0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.318, 0.277, 0.010> <0.319, 0.277, 0.000> <0.313, 0.268, -0.012> <0.306, 0.265, -0.019> 
		<0.318, 0.279, 0.010> <0.319, 0.279, 0.000> <0.314, 0.272, -0.012> <0.307, 0.269, -0.019> 
		<0.322, 0.280, 0.010> <0.322, 0.280, 0.000> <0.312, 0.277, -0.011> <0.306, 0.275, -0.018> 
		<0.322, 0.282, 0.010> <0.322, 0.282, 0.000> <0.312, 0.282, -0.012> <0.306, 0.279, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.318, 0.277, 0.010> <0.318, 0.279, 0.010> <0.322, 0.280, 0.010> <0.322, 0.282, 0.010> 
		<0.317, 0.277, 0.021> <0.317, 0.278, 0.021> <0.321, 0.280, 0.020> <0.321, 0.282, 0.020> 
		<0.309, 0.267, 0.032> <0.310, 0.271, 0.032> <0.310, 0.277, 0.031> <0.310, 0.281, 0.031> 
		<0.301, 0.265, 0.039> <0.303, 0.269, 0.038> <0.303, 0.274, 0.038> <0.302, 0.278, 0.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.318, 0.277, 0.010> <0.318, 0.272, 0.010> <0.321, 0.267, 0.010> <0.322, 0.263, 0.011> 
		<0.319, 0.277, 0.000> <0.319, 0.272, 0.000> <0.322, 0.267, -0.000> <0.322, 0.263, -0.000> 
		<0.313, 0.268, -0.012> <0.312, 0.266, -0.012> <0.309, 0.264, -0.011> <0.308, 0.262, -0.011> 
		<0.306, 0.265, -0.019> <0.305, 0.263, -0.019> <0.301, 0.263, -0.018> <0.300, 0.261, -0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.318, 0.277, 0.010> <0.317, 0.277, 0.021> <0.309, 0.267, 0.032> <0.301, 0.265, 0.039> 
		<0.318, 0.272, 0.010> <0.317, 0.272, 0.021> <0.308, 0.266, 0.032> <0.301, 0.263, 0.039> 
		<0.321, 0.267, 0.010> <0.320, 0.267, 0.022> <0.305, 0.264, 0.031> <0.297, 0.263, 0.038> 
		<0.322, 0.263, 0.011> <0.321, 0.263, 0.022> <0.305, 0.262, 0.032> <0.297, 0.261, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.322, 0.263, 0.011> <0.322, 0.261, 0.011> <0.321, 0.258, 0.011> <0.321, 0.256, 0.011> 
		<0.322, 0.263, -0.000> <0.322, 0.261, -0.000> <0.321, 0.258, -0.001> <0.321, 0.256, -0.001> 
		<0.308, 0.262, -0.011> <0.307, 0.260, -0.012> <0.308, 0.257, -0.013> <0.308, 0.255, -0.014> 
		<0.300, 0.261, -0.019> <0.299, 0.259, -0.019> <0.300, 0.256, -0.022> <0.300, 0.254, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.322, 0.263, 0.011> <0.321, 0.263, 0.022> <0.305, 0.262, 0.032> <0.297, 0.261, 0.039> 
		<0.322, 0.261, 0.011> <0.321, 0.261, 0.022> <0.305, 0.259, 0.033> <0.297, 0.258, 0.040> 
		<0.321, 0.258, 0.011> <0.321, 0.258, 0.022> <0.309, 0.257, 0.034> <0.300, 0.256, 0.042> 
		<0.321, 0.256, 0.011> <0.321, 0.255, 0.022> <0.309, 0.255, 0.035> <0.301, 0.253, 0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.321, 0.256, 0.011> <0.320, 0.250, 0.011> <0.318, 0.243, 0.011> <0.319, 0.237, 0.011> 
		<0.321, 0.256, -0.001> <0.320, 0.250, -0.001> <0.317, 0.243, -0.001> <0.318, 0.237, -0.001> 
		<0.308, 0.255, -0.014> <0.307, 0.249, -0.014> <0.302, 0.241, -0.013> <0.304, 0.236, -0.013> 
		<0.300, 0.254, -0.022> <0.299, 0.248, -0.023> <0.295, 0.240, -0.022> <0.297, 0.235, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.321, 0.256, 0.011> <0.321, 0.255, 0.022> <0.309, 0.255, 0.035> <0.301, 0.253, 0.042> 
		<0.320, 0.250, 0.011> <0.320, 0.250, 0.022> <0.311, 0.249, 0.036> <0.303, 0.248, 0.043> 
		<0.318, 0.243, 0.011> <0.319, 0.243, 0.021> <0.309, 0.241, 0.035> <0.302, 0.240, 0.043> 
		<0.319, 0.237, 0.011> <0.320, 0.237, 0.021> <0.310, 0.236, 0.034> <0.303, 0.235, 0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.321, 0.177, 0.010> <0.321, 0.177, -0.000> <0.316, 0.178, -0.015> <0.308, 0.177, -0.022> 
		<0.322, 0.186, 0.010> <0.322, 0.186, -0.000> <0.317, 0.187, -0.015> <0.309, 0.187, -0.022> 
		<0.329, 0.198, 0.010> <0.329, 0.198, 0.000> <0.325, 0.199, -0.013> <0.319, 0.199, -0.020> 
		<0.328, 0.207, 0.010> <0.329, 0.207, 0.000> <0.324, 0.209, -0.013> <0.317, 0.209, -0.020> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.321, 0.177, 0.010> <0.322, 0.186, 0.010> <0.329, 0.198, 0.010> <0.328, 0.207, 0.010> 
		<0.322, 0.177, 0.020> <0.323, 0.186, 0.020> <0.328, 0.198, 0.020> <0.328, 0.207, 0.020> 
		<0.321, 0.176, 0.036> <0.320, 0.186, 0.035> <0.324, 0.199, 0.033> <0.322, 0.209, 0.033> 
		<0.313, 0.176, 0.042> <0.312, 0.186, 0.042> <0.317, 0.199, 0.039> <0.315, 0.209, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.321, 0.177, 0.010> <0.321, 0.173, 0.010> <0.324, 0.169, 0.010> <0.324, 0.166, 0.010> 
		<0.321, 0.177, -0.000> <0.320, 0.174, -0.000> <0.322, 0.169, -0.000> <0.322, 0.166, -0.000> 
		<0.316, 0.178, -0.015> <0.316, 0.174, -0.015> <0.319, 0.169, -0.016> <0.320, 0.165, -0.015> 
		<0.308, 0.177, -0.022> <0.308, 0.173, -0.022> <0.311, 0.168, -0.023> <0.312, 0.164, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.321, 0.177, 0.010> <0.322, 0.177, 0.020> <0.321, 0.176, 0.036> <0.313, 0.176, 0.042> 
		<0.321, 0.173, 0.010> <0.322, 0.173, 0.020> <0.321, 0.172, 0.036> <0.314, 0.172, 0.042> 
		<0.324, 0.169, 0.010> <0.325, 0.169, 0.020> <0.326, 0.169, 0.037> <0.318, 0.168, 0.043> 
		<0.324, 0.166, 0.010> <0.325, 0.166, 0.020> <0.328, 0.166, 0.036> <0.320, 0.165, 0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.324, 0.166, 0.010> <0.324, 0.163, 0.010> <0.323, 0.160, 0.010> <0.322, 0.158, 0.010> 
		<0.322, 0.166, -0.000> <0.322, 0.163, -0.000> <0.322, 0.160, 0.001> <0.321, 0.158, 0.001> 
		<0.320, 0.165, -0.015> <0.320, 0.163, -0.015> <0.320, 0.159, -0.014> <0.320, 0.157, -0.012> 
		<0.312, 0.164, -0.022> <0.312, 0.162, -0.021> <0.313, 0.159, -0.020> <0.313, 0.157, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.324, 0.166, 0.010> <0.325, 0.166, 0.020> <0.328, 0.166, 0.036> <0.320, 0.165, 0.042> 
		<0.324, 0.163, 0.010> <0.325, 0.163, 0.020> <0.329, 0.163, 0.036> <0.322, 0.162, 0.042> 
		<0.323, 0.160, 0.010> <0.325, 0.160, 0.018> <0.331, 0.161, 0.035> <0.324, 0.160, 0.040> 
		<0.322, 0.158, 0.010> <0.324, 0.158, 0.018> <0.331, 0.158, 0.034> <0.324, 0.158, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.319, 0.237, 0.011> <0.320, 0.228, 0.011> <0.328, 0.216, 0.010> <0.328, 0.207, 0.010> 
		<0.318, 0.237, -0.001> <0.319, 0.228, -0.001> <0.328, 0.216, 0.000> <0.329, 0.207, 0.000> 
		<0.304, 0.236, -0.013> <0.308, 0.226, -0.012> <0.322, 0.219, -0.013> <0.324, 0.209, -0.013> 
		<0.297, 0.235, -0.022> <0.300, 0.226, -0.022> <0.315, 0.219, -0.020> <0.317, 0.209, -0.020> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.319, 0.237, 0.011> <0.320, 0.237, 0.021> <0.310, 0.236, 0.034> <0.303, 0.235, 0.042> 
		<0.320, 0.228, 0.011> <0.321, 0.228, 0.021> <0.313, 0.227, 0.034> <0.306, 0.227, 0.042> 
		<0.328, 0.216, 0.010> <0.328, 0.216, 0.020> <0.320, 0.218, 0.033> <0.314, 0.217, 0.039> 
		<0.328, 0.207, 0.010> <0.328, 0.207, 0.020> <0.322, 0.209, 0.033> <0.315, 0.209, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.282, 0.393, 0.009> <0.282, 0.394, -0.001> <0.276, 0.388, -0.016> <0.268, 0.384, -0.023> 
		<0.282, 0.395, 0.009> <0.282, 0.396, -0.001> <0.276, 0.389, -0.016> <0.268, 0.386, -0.023> 
		<0.285, 0.398, 0.009> <0.284, 0.398, -0.002> <0.279, 0.391, -0.018> <0.271, 0.387, -0.026> 
		<0.284, 0.400, 0.009> <0.284, 0.400, -0.002> <0.279, 0.393, -0.018> <0.271, 0.389, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.282, 0.393, 0.009> <0.282, 0.395, 0.009> <0.285, 0.398, 0.009> <0.284, 0.400, 0.009> 
		<0.282, 0.393, 0.020> <0.282, 0.395, 0.020> <0.285, 0.398, 0.021> <0.285, 0.400, 0.021> 
		<0.277, 0.387, 0.034> <0.277, 0.388, 0.034> <0.280, 0.390, 0.036> <0.280, 0.392, 0.037> 
		<0.270, 0.383, 0.041> <0.270, 0.385, 0.042> <0.273, 0.386, 0.044> <0.273, 0.388, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.282, 0.393, 0.009> <0.282, 0.392, 0.009> <0.283, 0.390, 0.009> <0.284, 0.389, 0.009> 
		<0.282, 0.394, -0.001> <0.281, 0.392, -0.001> <0.283, 0.390, -0.001> <0.283, 0.389, -0.002> 
		<0.276, 0.388, -0.016> <0.275, 0.386, -0.015> <0.277, 0.385, -0.015> <0.277, 0.383, -0.016> 
		<0.268, 0.384, -0.023> <0.268, 0.383, -0.022> <0.269, 0.381, -0.022> <0.270, 0.380, -0.023> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.282, 0.393, 0.009> <0.282, 0.393, 0.020> <0.277, 0.387, 0.034> <0.270, 0.383, 0.041> 
		<0.282, 0.392, 0.009> <0.282, 0.392, 0.020> <0.276, 0.385, 0.033> <0.270, 0.382, 0.040> 
		<0.283, 0.390, 0.009> <0.283, 0.390, 0.020> <0.278, 0.384, 0.033> <0.271, 0.380, 0.040> 
		<0.284, 0.389, 0.009> <0.284, 0.388, 0.020> <0.278, 0.382, 0.033> <0.272, 0.379, 0.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.284, 0.389, 0.009> <0.284, 0.386, 0.009> <0.284, 0.381, 0.009> <0.286, 0.379, 0.009> 
		<0.283, 0.389, -0.002> <0.284, 0.386, -0.002> <0.284, 0.381, -0.002> <0.286, 0.379, -0.002> 
		<0.277, 0.383, -0.016> <0.279, 0.380, -0.016> <0.281, 0.376, -0.017> <0.284, 0.372, -0.018> 
		<0.270, 0.380, -0.023> <0.272, 0.376, -0.023> <0.275, 0.372, -0.025> <0.277, 0.368, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.284, 0.389, 0.009> <0.284, 0.388, 0.020> <0.278, 0.382, 0.033> <0.272, 0.379, 0.041> 
		<0.284, 0.386, 0.009> <0.285, 0.385, 0.020> <0.280, 0.379, 0.034> <0.273, 0.375, 0.042> 
		<0.284, 0.381, 0.009> <0.284, 0.381, 0.020> <0.281, 0.375, 0.035> <0.275, 0.371, 0.044> 
		<0.286, 0.379, 0.009> <0.286, 0.378, 0.020> <0.283, 0.372, 0.036> <0.277, 0.368, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.286, 0.379, 0.009> <0.288, 0.375, 0.009> <0.295, 0.373, 0.009> <0.296, 0.369, 0.010> 
		<0.286, 0.379, -0.002> <0.288, 0.375, -0.002> <0.295, 0.373, -0.002> <0.297, 0.369, -0.002> 
		<0.284, 0.372, -0.018> <0.286, 0.369, -0.018> <0.289, 0.365, -0.017> <0.291, 0.361, -0.016> 
		<0.277, 0.368, -0.026> <0.279, 0.365, -0.026> <0.282, 0.361, -0.024> <0.284, 0.358, -0.024> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.286, 0.379, 0.009> <0.286, 0.378, 0.020> <0.283, 0.372, 0.036> <0.277, 0.368, 0.045> 
		<0.288, 0.375, 0.009> <0.288, 0.375, 0.021> <0.285, 0.369, 0.036> <0.278, 0.365, 0.045> 
		<0.295, 0.373, 0.009> <0.294, 0.373, 0.021> <0.288, 0.365, 0.036> <0.281, 0.361, 0.044> 
		<0.296, 0.369, 0.010> <0.296, 0.369, 0.021> <0.289, 0.362, 0.035> <0.283, 0.358, 0.044> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.315, 0.316, 0.011> <0.316, 0.316, 0.001> <0.314, 0.313, -0.012> <0.309, 0.311, -0.019> 
		<0.313, 0.321, 0.011> <0.313, 0.321, 0.001> <0.313, 0.319, -0.013> <0.307, 0.318, -0.020> 
		<0.307, 0.327, 0.011> <0.308, 0.327, 0.001> <0.310, 0.327, -0.015> <0.303, 0.325, -0.022> 
		<0.305, 0.333, 0.011> <0.306, 0.333, 0.000> <0.307, 0.333, -0.016> <0.300, 0.331, -0.023> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.315, 0.316, 0.011> <0.313, 0.321, 0.011> <0.307, 0.327, 0.011> <0.305, 0.333, 0.011> 
		<0.314, 0.316, 0.020> <0.312, 0.321, 0.020> <0.307, 0.327, 0.021> <0.305, 0.333, 0.021> 
		<0.310, 0.313, 0.034> <0.309, 0.319, 0.034> <0.305, 0.328, 0.035> <0.302, 0.333, 0.036> 
		<0.303, 0.311, 0.041> <0.303, 0.318, 0.041> <0.299, 0.325, 0.043> <0.296, 0.331, 0.044> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.315, 0.316, 0.011> <0.317, 0.312, 0.010> <0.317, 0.306, 0.010> <0.318, 0.301, 0.010> 
		<0.316, 0.316, 0.001> <0.317, 0.312, 0.001> <0.319, 0.306, 0.000> <0.319, 0.301, 0.000> 
		<0.314, 0.313, -0.012> <0.315, 0.309, -0.012> <0.312, 0.305, -0.013> <0.312, 0.301, -0.013> 
		<0.309, 0.311, -0.019> <0.309, 0.307, -0.019> <0.306, 0.303, -0.021> <0.305, 0.299, -0.021> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.315, 0.316, 0.011> <0.314, 0.316, 0.020> <0.310, 0.313, 0.034> <0.303, 0.311, 0.041> 
		<0.317, 0.312, 0.010> <0.316, 0.312, 0.020> <0.310, 0.309, 0.033> <0.304, 0.307, 0.041> 
		<0.317, 0.306, 0.010> <0.316, 0.306, 0.021> <0.306, 0.305, 0.034> <0.299, 0.302, 0.042> 
		<0.318, 0.301, 0.010> <0.317, 0.301, 0.021> <0.306, 0.301, 0.034> <0.299, 0.298, 0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.318, 0.301, 0.010> <0.320, 0.296, 0.010> <0.322, 0.288, 0.010> <0.322, 0.282, 0.010> 
		<0.319, 0.301, 0.000> <0.321, 0.296, 0.000> <0.322, 0.288, 0.000> <0.322, 0.282, 0.000> 
		<0.312, 0.301, -0.013> <0.311, 0.295, -0.013> <0.312, 0.287, -0.012> <0.312, 0.282, -0.012> 
		<0.305, 0.299, -0.021> <0.305, 0.293, -0.021> <0.306, 0.285, -0.019> <0.306, 0.279, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.318, 0.301, 0.010> <0.317, 0.301, 0.021> <0.306, 0.301, 0.034> <0.299, 0.298, 0.042> 
		<0.320, 0.296, 0.010> <0.318, 0.295, 0.021> <0.306, 0.294, 0.033> <0.298, 0.292, 0.041> 
		<0.322, 0.288, 0.010> <0.321, 0.288, 0.020> <0.309, 0.287, 0.032> <0.302, 0.285, 0.039> 
		<0.322, 0.282, 0.010> <0.321, 0.282, 0.020> <0.310, 0.281, 0.031> <0.302, 0.278, 0.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.296, 0.369, 0.010> <0.301, 0.359, 0.010> <0.302, 0.343, 0.010> <0.305, 0.333, 0.011> 
		<0.297, 0.369, -0.002> <0.301, 0.359, -0.001> <0.302, 0.343, 0.000> <0.306, 0.333, 0.000> 
		<0.291, 0.361, -0.016> <0.296, 0.353, -0.016> <0.302, 0.341, -0.016> <0.307, 0.333, -0.016> 
		<0.284, 0.358, -0.024> <0.289, 0.350, -0.024> <0.295, 0.339, -0.023> <0.300, 0.331, -0.023> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.296, 0.369, 0.010> <0.296, 0.369, 0.021> <0.289, 0.362, 0.035> <0.283, 0.358, 0.044> 
		<0.301, 0.359, 0.010> <0.301, 0.359, 0.021> <0.294, 0.354, 0.035> <0.287, 0.350, 0.044> 
		<0.302, 0.343, 0.010> <0.301, 0.343, 0.021> <0.299, 0.342, 0.036> <0.293, 0.339, 0.044> 
		<0.305, 0.333, 0.011> <0.305, 0.333, 0.021> <0.302, 0.333, 0.036> <0.296, 0.331, 0.044> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.161, 0.539, 0.010> <0.159, 0.539, -0.007> <0.149, 0.530, -0.027> <0.144, 0.519, -0.039> 
		<0.158, 0.540, 0.010> <0.157, 0.540, -0.006> <0.145, 0.531, -0.027> <0.140, 0.520, -0.039> 
		<0.156, 0.537, 0.010> <0.153, 0.536, -0.006> <0.141, 0.528, -0.025> <0.136, 0.518, -0.035> 
		<0.154, 0.535, 0.010> <0.151, 0.535, -0.006> <0.137, 0.527, -0.023> <0.132, 0.517, -0.034> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.161, 0.539, 0.010> <0.158, 0.540, 0.010> <0.156, 0.537, 0.010> <0.154, 0.535, 0.010> 
		<0.162, 0.540, 0.026> <0.160, 0.540, 0.026> <0.158, 0.537, 0.024> <0.156, 0.535, 0.024> 
		<0.156, 0.531, 0.047> <0.154, 0.532, 0.047> <0.153, 0.528, 0.045> <0.151, 0.527, 0.044> 
		<0.152, 0.520, 0.058> <0.150, 0.521, 0.058> <0.149, 0.519, 0.055> <0.148, 0.518, 0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.161, 0.539, 0.010> <0.163, 0.539, 0.010> <0.162, 0.534, 0.010> <0.164, 0.532, 0.010> 
		<0.159, 0.539, -0.007> <0.162, 0.538, -0.007> <0.160, 0.533, -0.005> <0.162, 0.531, -0.005> 
		<0.149, 0.530, -0.027> <0.151, 0.530, -0.027> <0.150, 0.525, -0.024> <0.152, 0.523, -0.024> 
		<0.144, 0.519, -0.039> <0.147, 0.519, -0.039> <0.146, 0.515, -0.035> <0.148, 0.514, -0.034> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.161, 0.539, 0.010> <0.162, 0.540, 0.026> <0.156, 0.531, 0.047> <0.152, 0.520, 0.058> 
		<0.163, 0.539, 0.010> <0.164, 0.539, 0.026> <0.159, 0.530, 0.047> <0.155, 0.519, 0.058> 
		<0.162, 0.534, 0.010> <0.164, 0.534, 0.024> <0.159, 0.526, 0.044> <0.156, 0.516, 0.055> 
		<0.164, 0.532, 0.010> <0.165, 0.532, 0.024> <0.161, 0.524, 0.044> <0.158, 0.514, 0.054> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.164, 0.532, 0.010> <0.165, 0.530, 0.010> <0.167, 0.530, 0.010> <0.168, 0.530, 0.010> 
		<0.162, 0.531, -0.005> <0.163, 0.530, -0.005> <0.165, 0.530, -0.005> <0.167, 0.530, -0.005> 
		<0.152, 0.523, -0.024> <0.154, 0.522, -0.023> <0.157, 0.522, -0.023> <0.159, 0.522, -0.024> 
		<0.148, 0.514, -0.034> <0.150, 0.512, -0.033> <0.154, 0.512, -0.034> <0.156, 0.512, -0.034> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.164, 0.532, 0.010> <0.165, 0.532, 0.024> <0.161, 0.524, 0.044> <0.158, 0.514, 0.054> 
		<0.165, 0.530, 0.010> <0.166, 0.531, 0.024> <0.162, 0.523, 0.043> <0.159, 0.513, 0.053> 
		<0.167, 0.530, 0.010> <0.168, 0.530, 0.024> <0.165, 0.523, 0.043> <0.162, 0.513, 0.054> 
		<0.168, 0.530, 0.010> <0.169, 0.530, 0.024> <0.166, 0.522, 0.044> <0.164, 0.513, 0.054> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.168, 0.530, 0.010> <0.175, 0.529, 0.010> <0.184, 0.531, 0.010> <0.191, 0.527, 0.010> 
		<0.167, 0.530, -0.005> <0.173, 0.529, -0.005> <0.184, 0.531, -0.006> <0.190, 0.527, -0.006> 
		<0.159, 0.522, -0.024> <0.167, 0.521, -0.025> <0.178, 0.523, -0.027> <0.185, 0.520, -0.027> 
		<0.156, 0.512, -0.034> <0.164, 0.511, -0.035> <0.174, 0.513, -0.039> <0.181, 0.510, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.168, 0.530, 0.010> <0.169, 0.530, 0.024> <0.166, 0.522, 0.044> <0.164, 0.513, 0.054> 
		<0.175, 0.529, 0.010> <0.176, 0.529, 0.024> <0.173, 0.521, 0.045> <0.170, 0.511, 0.055> 
		<0.184, 0.531, 0.010> <0.185, 0.531, 0.025> <0.183, 0.523, 0.047> <0.180, 0.513, 0.059> 
		<0.191, 0.527, 0.010> <0.191, 0.527, 0.026> <0.190, 0.520, 0.047> <0.186, 0.510, 0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.267, 0.447, 0.009> <0.267, 0.447, -0.004> <0.263, 0.441, -0.023> <0.256, 0.435, -0.033> 
		<0.262, 0.456, 0.009> <0.262, 0.456, -0.004> <0.260, 0.450, -0.023> <0.253, 0.444, -0.032> 
		<0.257, 0.468, 0.010> <0.258, 0.468, -0.002> <0.259, 0.464, -0.019> <0.254, 0.458, -0.028> 
		<0.250, 0.475, 0.010> <0.251, 0.475, -0.002> <0.252, 0.471, -0.019> <0.247, 0.465, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.267, 0.447, 0.009> <0.262, 0.456, 0.009> <0.257, 0.468, 0.010> <0.250, 0.475, 0.010> 
		<0.268, 0.447, 0.023> <0.263, 0.456, 0.023> <0.256, 0.468, 0.022> <0.249, 0.475, 0.022> 
		<0.265, 0.442, 0.042> <0.259, 0.451, 0.042> <0.252, 0.463, 0.039> <0.245, 0.471, 0.039> 
		<0.258, 0.435, 0.052> <0.253, 0.445, 0.052> <0.247, 0.457, 0.048> <0.240, 0.465, 0.048> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.267, 0.447, 0.009> <0.271, 0.440, 0.009> <0.276, 0.431, 0.010> <0.279, 0.423, 0.010> 
		<0.267, 0.447, -0.004> <0.271, 0.440, -0.004> <0.275, 0.431, -0.003> <0.278, 0.423, -0.003> 
		<0.263, 0.441, -0.023> <0.265, 0.434, -0.023> <0.268, 0.425, -0.022> <0.271, 0.418, -0.021> 
		<0.256, 0.435, -0.033> <0.258, 0.428, -0.033> <0.261, 0.419, -0.031> <0.263, 0.412, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.267, 0.447, 0.009> <0.268, 0.447, 0.023> <0.265, 0.442, 0.042> <0.258, 0.435, 0.052> 
		<0.271, 0.440, 0.009> <0.271, 0.440, 0.023> <0.268, 0.435, 0.042> <0.262, 0.428, 0.052> 
		<0.276, 0.431, 0.010> <0.277, 0.431, 0.022> <0.274, 0.425, 0.041> <0.267, 0.419, 0.050> 
		<0.279, 0.423, 0.010> <0.280, 0.423, 0.022> <0.276, 0.418, 0.040> <0.269, 0.412, 0.049> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.279, 0.423, 0.010> <0.281, 0.416, 0.010> <0.284, 0.407, 0.010> <0.284, 0.400, 0.009> 
		<0.278, 0.423, -0.003> <0.280, 0.416, -0.003> <0.283, 0.407, -0.002> <0.284, 0.400, -0.002> 
		<0.271, 0.418, -0.021> <0.273, 0.411, -0.020> <0.278, 0.400, -0.020> <0.279, 0.393, -0.018> 
		<0.263, 0.412, -0.030> <0.265, 0.405, -0.029> <0.270, 0.396, -0.028> <0.271, 0.389, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.279, 0.423, 0.010> <0.280, 0.423, 0.022> <0.276, 0.418, 0.040> <0.269, 0.412, 0.049> 
		<0.281, 0.416, 0.010> <0.282, 0.416, 0.022> <0.278, 0.411, 0.039> <0.271, 0.405, 0.047> 
		<0.284, 0.407, 0.010> <0.284, 0.407, 0.021> <0.280, 0.399, 0.039> <0.272, 0.395, 0.046> 
		<0.284, 0.400, 0.009> <0.285, 0.400, 0.021> <0.280, 0.392, 0.037> <0.273, 0.388, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.211, 0.507, 0.011> <0.210, 0.507, -0.003> <0.204, 0.502, -0.023> <0.200, 0.492, -0.032> 
		<0.205, 0.513, 0.011> <0.203, 0.513, -0.003> <0.197, 0.506, -0.024> <0.194, 0.497, -0.034> 
		<0.198, 0.523, 0.010> <0.197, 0.523, -0.006> <0.192, 0.516, -0.027> <0.188, 0.506, -0.038> 
		<0.191, 0.527, 0.010> <0.190, 0.527, -0.006> <0.185, 0.520, -0.027> <0.181, 0.510, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.211, 0.507, 0.011> <0.205, 0.513, 0.011> <0.198, 0.523, 0.010> <0.191, 0.527, 0.010> 
		<0.212, 0.507, 0.024> <0.206, 0.513, 0.024> <0.199, 0.523, 0.026> <0.191, 0.527, 0.026> 
		<0.212, 0.501, 0.043> <0.205, 0.506, 0.044> <0.198, 0.516, 0.047> <0.190, 0.520, 0.047> 
		<0.208, 0.492, 0.052> <0.202, 0.498, 0.053> <0.194, 0.506, 0.058> <0.186, 0.510, 0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.211, 0.507, 0.011> <0.223, 0.497, 0.011> <0.240, 0.486, 0.010> <0.250, 0.475, 0.010> 
		<0.210, 0.507, -0.003> <0.221, 0.497, -0.003> <0.241, 0.486, -0.002> <0.251, 0.475, -0.002> 
		<0.204, 0.502, -0.023> <0.217, 0.493, -0.020> <0.241, 0.482, -0.019> <0.252, 0.471, -0.019> 
		<0.200, 0.492, -0.032> <0.214, 0.483, -0.030> <0.236, 0.477, -0.028> <0.247, 0.465, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.211, 0.507, 0.011> <0.212, 0.507, 0.024> <0.212, 0.501, 0.043> <0.208, 0.492, 0.052> 
		<0.223, 0.497, 0.011> <0.224, 0.497, 0.024> <0.221, 0.493, 0.041> <0.218, 0.484, 0.050> 
		<0.240, 0.486, 0.010> <0.238, 0.486, 0.022> <0.237, 0.481, 0.039> <0.231, 0.475, 0.048> 
		<0.250, 0.475, 0.010> <0.249, 0.475, 0.022> <0.245, 0.471, 0.039> <0.240, 0.465, 0.048> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.148, 0.518, 0.053> <0.143, 0.508, 0.064> <0.134, 0.490, 0.072> <0.129, 0.477, 0.072> 
		<0.149, 0.519, 0.055> <0.145, 0.509, 0.065> <0.137, 0.490, 0.074> <0.132, 0.476, 0.074> 
		<0.150, 0.521, 0.058> <0.147, 0.511, 0.069> <0.140, 0.490, 0.078> <0.135, 0.475, 0.078> 
		<0.152, 0.520, 0.058> <0.149, 0.510, 0.069> <0.143, 0.489, 0.078> <0.138, 0.474, 0.078> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.129, 0.477, 0.072> <0.125, 0.463, 0.072> <0.120, 0.444, 0.064> <0.117, 0.435, 0.054> 
		<0.132, 0.476, 0.074> <0.127, 0.463, 0.074> <0.122, 0.443, 0.066> <0.119, 0.433, 0.056> 
		<0.135, 0.475, 0.078> <0.130, 0.460, 0.078> <0.124, 0.440, 0.070> <0.121, 0.430, 0.059> 
		<0.138, 0.474, 0.078> <0.134, 0.460, 0.078> <0.127, 0.439, 0.070> <0.123, 0.429, 0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.117, 0.435, 0.054> <0.114, 0.425, 0.044> <0.110, 0.418, 0.024> <0.111, 0.418, 0.010> 
		<0.119, 0.433, 0.056> <0.116, 0.424, 0.045> <0.111, 0.416, 0.024> <0.112, 0.416, 0.010> 
		<0.121, 0.430, 0.059> <0.117, 0.419, 0.047> <0.113, 0.411, 0.026> <0.113, 0.411, 0.010> 
		<0.123, 0.429, 0.059> <0.120, 0.418, 0.047> <0.115, 0.411, 0.026> <0.116, 0.411, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.111, 0.418, 0.010> <0.112, 0.418, -0.005> <0.120, 0.425, -0.024> <0.123, 0.435, -0.035> 
		<0.112, 0.416, 0.010> <0.113, 0.416, -0.005> <0.121, 0.423, -0.026> <0.124, 0.433, -0.036> 
		<0.113, 0.411, 0.010> <0.114, 0.411, -0.006> <0.121, 0.419, -0.028> <0.124, 0.430, -0.040> 
		<0.116, 0.411, 0.010> <0.117, 0.411, -0.006> <0.123, 0.418, -0.028> <0.127, 0.429, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.123, 0.435, -0.035> <0.125, 0.444, -0.045> <0.125, 0.464, -0.053> <0.127, 0.477, -0.052> 
		<0.124, 0.433, -0.036> <0.127, 0.443, -0.046> <0.128, 0.463, -0.054> <0.129, 0.476, -0.054> 
		<0.124, 0.430, -0.040> <0.127, 0.440, -0.050> <0.129, 0.461, -0.059> <0.132, 0.476, -0.059> 
		<0.127, 0.429, -0.040> <0.130, 0.439, -0.050> <0.132, 0.460, -0.059> <0.135, 0.475, -0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.127, 0.477, -0.052> <0.129, 0.490, -0.052> <0.128, 0.508, -0.043> <0.132, 0.517, -0.034> 
		<0.129, 0.476, -0.054> <0.131, 0.490, -0.054> <0.132, 0.509, -0.045> <0.136, 0.518, -0.035> 
		<0.132, 0.476, -0.059> <0.135, 0.491, -0.059> <0.136, 0.510, -0.049> <0.140, 0.520, -0.039> 
		<0.135, 0.475, -0.059> <0.138, 0.490, -0.058> <0.140, 0.510, -0.049> <0.144, 0.519, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.152, 0.520, 0.058> <0.149, 0.510, 0.069> <0.143, 0.489, 0.078> <0.138, 0.474, 0.078> 
		<0.155, 0.519, 0.058> <0.151, 0.509, 0.069> <0.146, 0.489, 0.078> <0.141, 0.474, 0.078> 
		<0.156, 0.516, 0.055> <0.153, 0.506, 0.065> <0.147, 0.487, 0.073> <0.142, 0.473, 0.073> 
		<0.158, 0.514, 0.054> <0.155, 0.505, 0.064> <0.149, 0.486, 0.072> <0.145, 0.473, 0.072> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.138, 0.474, 0.078> <0.134, 0.460, 0.078> <0.127, 0.439, 0.070> <0.123, 0.429, 0.059> 
		<0.141, 0.474, 0.078> <0.136, 0.459, 0.078> <0.130, 0.439, 0.070> <0.126, 0.428, 0.058> 
		<0.142, 0.473, 0.073> <0.138, 0.460, 0.073> <0.132, 0.441, 0.065> <0.129, 0.431, 0.055> 
		<0.145, 0.473, 0.072> <0.141, 0.459, 0.072> <0.135, 0.441, 0.064> <0.132, 0.431, 0.054> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.123, 0.429, 0.059> <0.120, 0.418, 0.047> <0.115, 0.411, 0.026> <0.116, 0.411, 0.010> 
		<0.126, 0.428, 0.058> <0.123, 0.418, 0.047> <0.119, 0.410, 0.025> <0.119, 0.410, 0.010> 
		<0.129, 0.431, 0.055> <0.126, 0.422, 0.045> <0.123, 0.414, 0.024> <0.124, 0.414, 0.010> 
		<0.132, 0.431, 0.054> <0.129, 0.422, 0.044> <0.127, 0.414, 0.024> <0.127, 0.414, 0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.116, 0.411, 0.010> <0.117, 0.411, -0.006> <0.123, 0.418, -0.028> <0.127, 0.429, -0.040> 
		<0.119, 0.410, 0.010> <0.120, 0.410, -0.006> <0.126, 0.418, -0.028> <0.129, 0.428, -0.040> 
		<0.124, 0.414, 0.010> <0.124, 0.414, -0.005> <0.130, 0.422, -0.026> <0.132, 0.432, -0.036> 
		<0.127, 0.414, 0.009> <0.127, 0.414, -0.005> <0.132, 0.422, -0.025> <0.134, 0.432, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.127, 0.429, -0.040> <0.130, 0.439, -0.050> <0.132, 0.460, -0.059> <0.135, 0.475, -0.059> 
		<0.129, 0.428, -0.040> <0.132, 0.439, -0.050> <0.134, 0.460, -0.059> <0.137, 0.474, -0.059> 
		<0.132, 0.432, -0.036> <0.134, 0.441, -0.046> <0.136, 0.460, -0.054> <0.138, 0.474, -0.053> 
		<0.134, 0.432, -0.035> <0.136, 0.441, -0.045> <0.138, 0.460, -0.053> <0.140, 0.473, -0.052> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.135, 0.475, -0.059> <0.138, 0.490, -0.058> <0.140, 0.510, -0.049> <0.144, 0.519, -0.039> 
		<0.137, 0.474, -0.059> <0.140, 0.489, -0.058> <0.143, 0.509, -0.049> <0.147, 0.519, -0.039> 
		<0.138, 0.474, -0.053> <0.140, 0.487, -0.053> <0.142, 0.506, -0.044> <0.146, 0.515, -0.035> 
		<0.140, 0.473, -0.052> <0.142, 0.487, -0.052> <0.144, 0.505, -0.044> <0.148, 0.514, -0.034> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.158, 0.514, 0.054> <0.155, 0.505, 0.064> <0.149, 0.486, 0.072> <0.145, 0.473, 0.072> 
		<0.159, 0.513, 0.053> <0.156, 0.504, 0.063> <0.151, 0.486, 0.071> <0.147, 0.472, 0.071> 
		<0.162, 0.513, 0.054> <0.159, 0.503, 0.064> <0.154, 0.485, 0.071> <0.150, 0.471, 0.071> 
		<0.164, 0.513, 0.054> <0.161, 0.503, 0.064> <0.155, 0.484, 0.072> <0.151, 0.471, 0.072> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.145, 0.473, 0.072> <0.141, 0.459, 0.072> <0.135, 0.441, 0.064> <0.132, 0.431, 0.054> 
		<0.147, 0.472, 0.071> <0.142, 0.459, 0.071> <0.137, 0.441, 0.063> <0.134, 0.431, 0.053> 
		<0.150, 0.471, 0.071> <0.146, 0.458, 0.071> <0.139, 0.440, 0.064> <0.137, 0.430, 0.054> 
		<0.151, 0.471, 0.072> <0.147, 0.457, 0.072> <0.141, 0.439, 0.064> <0.139, 0.429, 0.054> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.132, 0.431, 0.054> <0.129, 0.422, 0.044> <0.127, 0.414, 0.024> <0.127, 0.414, 0.009> 
		<0.134, 0.431, 0.053> <0.131, 0.422, 0.043> <0.129, 0.414, 0.024> <0.130, 0.414, 0.009> 
		<0.137, 0.430, 0.054> <0.134, 0.420, 0.043> <0.133, 0.413, 0.024> <0.133, 0.413, 0.009> 
		<0.139, 0.429, 0.054> <0.136, 0.420, 0.044> <0.135, 0.412, 0.024> <0.135, 0.412, 0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.127, 0.414, 0.009> <0.127, 0.414, -0.005> <0.132, 0.422, -0.025> <0.134, 0.432, -0.035> 
		<0.130, 0.414, 0.009> <0.130, 0.414, -0.005> <0.134, 0.422, -0.024> <0.136, 0.432, -0.035> 
		<0.133, 0.413, 0.009> <0.133, 0.413, -0.005> <0.137, 0.421, -0.025> <0.139, 0.430, -0.035> 
		<0.135, 0.412, 0.009> <0.136, 0.412, -0.005> <0.139, 0.420, -0.025> <0.141, 0.430, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.134, 0.432, -0.035> <0.136, 0.441, -0.045> <0.138, 0.460, -0.053> <0.140, 0.473, -0.052> 
		<0.136, 0.432, -0.035> <0.138, 0.441, -0.044> <0.140, 0.459, -0.052> <0.142, 0.473, -0.051> 
		<0.139, 0.430, -0.035> <0.141, 0.440, -0.045> <0.143, 0.458, -0.052> <0.146, 0.472, -0.052> 
		<0.141, 0.430, -0.035> <0.143, 0.439, -0.045> <0.145, 0.458, -0.053> <0.148, 0.471, -0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.140, 0.473, -0.052> <0.142, 0.487, -0.052> <0.144, 0.505, -0.044> <0.148, 0.514, -0.034> 
		<0.142, 0.473, -0.051> <0.144, 0.486, -0.051> <0.146, 0.503, -0.043> <0.150, 0.512, -0.033> 
		<0.146, 0.472, -0.052> <0.148, 0.485, -0.052> <0.150, 0.503, -0.043> <0.154, 0.512, -0.034> 
		<0.148, 0.471, -0.053> <0.150, 0.485, -0.052> <0.153, 0.503, -0.044> <0.156, 0.512, -0.034> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.164, 0.513, 0.054> <0.161, 0.503, 0.064> <0.155, 0.484, 0.072> <0.151, 0.471, 0.072> 
		<0.170, 0.511, 0.055> <0.168, 0.502, 0.065> <0.161, 0.483, 0.073> <0.157, 0.470, 0.073> 
		<0.180, 0.513, 0.059> <0.177, 0.503, 0.070> <0.170, 0.483, 0.079> <0.165, 0.469, 0.079> 
		<0.186, 0.510, 0.059> <0.183, 0.500, 0.070> <0.176, 0.481, 0.078> <0.170, 0.467, 0.078> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.151, 0.471, 0.072> <0.147, 0.457, 0.072> <0.141, 0.439, 0.064> <0.139, 0.429, 0.054> 
		<0.157, 0.470, 0.073> <0.153, 0.456, 0.073> <0.146, 0.438, 0.065> <0.143, 0.428, 0.055> 
		<0.165, 0.469, 0.079> <0.159, 0.455, 0.079> <0.151, 0.436, 0.072> <0.148, 0.426, 0.061> 
		<0.170, 0.467, 0.078> <0.164, 0.453, 0.078> <0.155, 0.434, 0.070> <0.152, 0.424, 0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.139, 0.429, 0.054> <0.136, 0.420, 0.044> <0.135, 0.412, 0.024> <0.135, 0.412, 0.009> 
		<0.143, 0.428, 0.055> <0.140, 0.418, 0.045> <0.140, 0.411, 0.024> <0.140, 0.411, 0.009> 
		<0.148, 0.426, 0.061> <0.145, 0.416, 0.049> <0.146, 0.409, 0.025> <0.147, 0.409, 0.010> 
		<0.152, 0.424, 0.059> <0.148, 0.414, 0.047> <0.150, 0.407, 0.025> <0.151, 0.407, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.135, 0.412, 0.009> <0.136, 0.412, -0.005> <0.139, 0.420, -0.025> <0.141, 0.430, -0.035> 
		<0.140, 0.411, 0.009> <0.140, 0.411, -0.005> <0.143, 0.418, -0.026> <0.145, 0.428, -0.036> 
		<0.147, 0.409, 0.010> <0.147, 0.409, -0.006> <0.148, 0.415, -0.030> <0.151, 0.426, -0.042> 
		<0.151, 0.407, 0.010> <0.151, 0.407, -0.006> <0.152, 0.414, -0.028> <0.155, 0.424, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.141, 0.430, -0.035> <0.143, 0.439, -0.045> <0.145, 0.458, -0.053> <0.148, 0.471, -0.053> 
		<0.145, 0.428, -0.036> <0.147, 0.438, -0.046> <0.152, 0.457, -0.054> <0.155, 0.470, -0.054> 
		<0.151, 0.426, -0.042> <0.154, 0.435, -0.053> <0.159, 0.456, -0.060> <0.164, 0.470, -0.060> 
		<0.155, 0.424, -0.040> <0.158, 0.434, -0.051> <0.166, 0.453, -0.059> <0.170, 0.467, -0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.148, 0.471, -0.053> <0.150, 0.485, -0.052> <0.153, 0.503, -0.044> <0.156, 0.512, -0.034> 
		<0.155, 0.470, -0.054> <0.157, 0.483, -0.054> <0.160, 0.502, -0.045> <0.164, 0.511, -0.035> 
		<0.164, 0.470, -0.060> <0.168, 0.484, -0.060> <0.171, 0.503, -0.049> <0.174, 0.513, -0.039> 
		<0.170, 0.467, -0.059> <0.174, 0.481, -0.059> <0.178, 0.500, -0.049> <0.181, 0.510, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.186, 0.510, 0.059> <0.183, 0.500, 0.070> <0.176, 0.481, 0.078> <0.170, 0.467, 0.078> 
		<0.194, 0.506, 0.058> <0.191, 0.496, 0.069> <0.183, 0.478, 0.077> <0.177, 0.464, 0.077> 
		<0.202, 0.498, 0.053> <0.198, 0.489, 0.063> <0.189, 0.470, 0.068> <0.182, 0.459, 0.066> 
		<0.208, 0.492, 0.052> <0.204, 0.483, 0.061> <0.195, 0.465, 0.068> <0.188, 0.454, 0.066> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.170, 0.467, 0.078> <0.164, 0.453, 0.078> <0.155, 0.434, 0.070> <0.152, 0.424, 0.059> 
		<0.177, 0.464, 0.077> <0.171, 0.450, 0.077> <0.161, 0.432, 0.066> <0.158, 0.422, 0.055> 
		<0.182, 0.459, 0.066> <0.174, 0.446, 0.064> <0.166, 0.434, 0.046> <0.161, 0.424, 0.036> 
		<0.188, 0.454, 0.066> <0.180, 0.441, 0.064> <0.171, 0.428, 0.048> <0.165, 0.418, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.152, 0.424, 0.059> <0.148, 0.414, 0.047> <0.150, 0.407, 0.025> <0.151, 0.407, 0.010> 
		<0.158, 0.422, 0.055> <0.154, 0.412, 0.044> <0.153, 0.405, 0.026> <0.153, 0.405, 0.010> 
		<0.161, 0.424, 0.036> <0.157, 0.417, 0.029> <0.153, 0.401, 0.021> <0.155, 0.401, 0.010> 
		<0.165, 0.418, 0.039> <0.161, 0.411, 0.032> <0.154, 0.398, 0.021> <0.156, 0.398, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.151, 0.407, 0.010> <0.151, 0.407, -0.006> <0.152, 0.414, -0.028> <0.155, 0.424, -0.040> 
		<0.153, 0.405, 0.010> <0.154, 0.405, -0.006> <0.160, 0.411, -0.024> <0.163, 0.421, -0.036> 
		<0.155, 0.401, 0.010> <0.157, 0.401, -0.001> <0.165, 0.417, -0.008> <0.169, 0.424, -0.015> 
		<0.156, 0.398, 0.010> <0.158, 0.398, -0.001> <0.170, 0.410, -0.010> <0.175, 0.418, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.155, 0.424, -0.040> <0.158, 0.434, -0.051> <0.166, 0.453, -0.059> <0.170, 0.467, -0.059> 
		<0.163, 0.421, -0.036> <0.166, 0.431, -0.047> <0.173, 0.450, -0.058> <0.178, 0.464, -0.058> 
		<0.169, 0.424, -0.015> <0.175, 0.433, -0.025> <0.180, 0.445, -0.045> <0.185, 0.459, -0.047> 
		<0.175, 0.418, -0.018> <0.181, 0.427, -0.028> <0.186, 0.440, -0.044> <0.191, 0.454, -0.047> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.170, 0.467, -0.059> <0.174, 0.481, -0.059> <0.178, 0.500, -0.049> <0.181, 0.510, -0.039> 
		<0.178, 0.464, -0.058> <0.182, 0.478, -0.058> <0.185, 0.497, -0.049> <0.188, 0.506, -0.038> 
		<0.185, 0.459, -0.047> <0.189, 0.471, -0.050> <0.191, 0.488, -0.043> <0.194, 0.497, -0.034> 
		<0.191, 0.454, -0.047> <0.195, 0.466, -0.049> <0.197, 0.484, -0.042> <0.200, 0.492, -0.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.208, 0.492, 0.052> <0.204, 0.483, 0.061> <0.195, 0.465, 0.068> <0.188, 0.454, 0.066> 
		<0.218, 0.484, 0.050> <0.214, 0.475, 0.060> <0.202, 0.459, 0.067> <0.196, 0.447, 0.065> 
		<0.231, 0.475, 0.048> <0.225, 0.467, 0.060> <0.215, 0.451, 0.072> <0.205, 0.440, 0.075> 
		<0.240, 0.465, 0.048> <0.233, 0.458, 0.060> <0.222, 0.444, 0.071> <0.212, 0.433, 0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.188, 0.454, 0.066> <0.180, 0.441, 0.064> <0.171, 0.428, 0.048> <0.165, 0.418, 0.039> 
		<0.196, 0.447, 0.065> <0.188, 0.435, 0.063> <0.179, 0.418, 0.053> <0.173, 0.409, 0.043> 
		<0.205, 0.440, 0.075> <0.195, 0.428, 0.079> <0.176, 0.411, 0.082> <0.167, 0.402, 0.072> 
		<0.212, 0.433, 0.075> <0.202, 0.421, 0.079> <0.185, 0.402, 0.083> <0.177, 0.393, 0.073> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.165, 0.418, 0.039> <0.161, 0.411, 0.032> <0.154, 0.398, 0.021> <0.156, 0.398, 0.010> 
		<0.173, 0.409, 0.043> <0.169, 0.402, 0.036> <0.155, 0.391, 0.021> <0.157, 0.391, 0.010> 
		<0.167, 0.402, 0.072> <0.156, 0.390, 0.059> <0.151, 0.380, 0.031> <0.152, 0.380, 0.011> 
		<0.177, 0.393, 0.073> <0.166, 0.381, 0.060> <0.155, 0.374, 0.031> <0.156, 0.374, 0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.156, 0.398, 0.010> <0.158, 0.398, -0.001> <0.170, 0.410, -0.010> <0.175, 0.418, -0.018> 
		<0.157, 0.391, 0.010> <0.159, 0.391, -0.001> <0.178, 0.401, -0.014> <0.183, 0.408, -0.022> 
		<0.152, 0.380, 0.011> <0.153, 0.380, -0.011> <0.162, 0.390, -0.039> <0.174, 0.402, -0.052> 
		<0.156, 0.374, 0.011> <0.157, 0.374, -0.011> <0.171, 0.381, -0.039> <0.182, 0.392, -0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.175, 0.418, -0.018> <0.181, 0.427, -0.028> <0.186, 0.440, -0.044> <0.191, 0.454, -0.047> 
		<0.183, 0.408, -0.022> <0.189, 0.418, -0.032> <0.194, 0.434, -0.044> <0.198, 0.448, -0.047> 
		<0.174, 0.402, -0.052> <0.182, 0.410, -0.062> <0.196, 0.429, -0.060> <0.206, 0.440, -0.056> 
		<0.182, 0.392, -0.053> <0.190, 0.401, -0.062> <0.202, 0.422, -0.060> <0.212, 0.433, -0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.191, 0.454, -0.047> <0.195, 0.466, -0.049> <0.197, 0.484, -0.042> <0.200, 0.492, -0.032> 
		<0.198, 0.448, -0.047> <0.202, 0.460, -0.049> <0.210, 0.475, -0.039> <0.214, 0.483, -0.030> 
		<0.206, 0.440, -0.056> <0.217, 0.452, -0.052> <0.228, 0.469, -0.040> <0.236, 0.477, -0.028> 
		<0.212, 0.433, -0.056> <0.223, 0.445, -0.052> <0.240, 0.457, -0.041> <0.247, 0.465, -0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.240, 0.465, 0.048> <0.233, 0.458, 0.060> <0.222, 0.444, 0.071> <0.212, 0.433, 0.075> 
		<0.247, 0.457, 0.048> <0.240, 0.450, 0.060> <0.228, 0.437, 0.071> <0.218, 0.426, 0.075> 
		<0.253, 0.445, 0.052> <0.247, 0.439, 0.061> <0.235, 0.427, 0.068> <0.226, 0.419, 0.067> 
		<0.258, 0.435, 0.052> <0.252, 0.430, 0.061> <0.239, 0.418, 0.066> <0.230, 0.411, 0.065> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.212, 0.433, 0.075> <0.202, 0.421, 0.079> <0.185, 0.402, 0.083> <0.177, 0.393, 0.073> 
		<0.218, 0.426, 0.075> <0.208, 0.415, 0.079> <0.194, 0.394, 0.083> <0.186, 0.385, 0.073> 
		<0.226, 0.419, 0.067> <0.216, 0.410, 0.064> <0.202, 0.397, 0.056> <0.193, 0.392, 0.047> 
		<0.230, 0.411, 0.065> <0.220, 0.402, 0.063> <0.210, 0.390, 0.049> <0.201, 0.385, 0.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.177, 0.393, 0.073> <0.166, 0.381, 0.060> <0.155, 0.374, 0.031> <0.156, 0.374, 0.011> 
		<0.186, 0.385, 0.073> <0.175, 0.373, 0.061> <0.158, 0.371, 0.031> <0.159, 0.371, 0.011> 
		<0.193, 0.392, 0.047> <0.184, 0.387, 0.039> <0.166, 0.380, 0.024> <0.166, 0.380, 0.011> 
		<0.201, 0.385, 0.041> <0.192, 0.380, 0.033> <0.170, 0.378, 0.024> <0.170, 0.378, 0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.156, 0.374, 0.011> <0.157, 0.374, -0.011> <0.171, 0.381, -0.039> <0.182, 0.392, -0.053> 
		<0.159, 0.371, 0.011> <0.160, 0.371, -0.011> <0.179, 0.372, -0.040> <0.190, 0.384, -0.054> 
		<0.166, 0.380, 0.011> <0.167, 0.380, -0.003> <0.190, 0.388, -0.019> <0.199, 0.393, -0.028> 
		<0.170, 0.378, 0.011> <0.171, 0.378, -0.003> <0.195, 0.380, -0.011> <0.205, 0.385, -0.020> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.182, 0.392, -0.053> <0.190, 0.401, -0.062> <0.202, 0.422, -0.060> <0.212, 0.433, -0.056> 
		<0.190, 0.384, -0.054> <0.198, 0.392, -0.063> <0.208, 0.415, -0.060> <0.218, 0.426, -0.056> 
		<0.199, 0.393, -0.028> <0.207, 0.398, -0.036> <0.215, 0.410, -0.046> <0.224, 0.418, -0.049> 
		<0.205, 0.385, -0.020> <0.213, 0.390, -0.029> <0.218, 0.402, -0.045> <0.227, 0.411, -0.047> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.212, 0.433, -0.056> <0.223, 0.445, -0.052> <0.240, 0.457, -0.041> <0.247, 0.465, -0.028> 
		<0.218, 0.426, -0.056> <0.228, 0.438, -0.052> <0.246, 0.450, -0.041> <0.254, 0.458, -0.028> 
		<0.224, 0.418, -0.049> <0.232, 0.427, -0.051> <0.247, 0.438, -0.041> <0.253, 0.444, -0.032> 
		<0.227, 0.411, -0.047> <0.236, 0.419, -0.049> <0.250, 0.429, -0.041> <0.256, 0.435, -0.033> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.258, 0.435, 0.052> <0.252, 0.430, 0.061> <0.239, 0.418, 0.066> <0.230, 0.411, 0.065> 
		<0.262, 0.428, 0.052> <0.256, 0.423, 0.061> <0.242, 0.412, 0.065> <0.233, 0.404, 0.063> 
		<0.267, 0.419, 0.050> <0.259, 0.413, 0.059> <0.244, 0.401, 0.065> <0.233, 0.393, 0.065> 
		<0.269, 0.412, 0.049> <0.262, 0.405, 0.058> <0.246, 0.393, 0.064> <0.234, 0.385, 0.064> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.230, 0.411, 0.065> <0.220, 0.402, 0.063> <0.210, 0.390, 0.049> <0.201, 0.385, 0.041> 
		<0.233, 0.404, 0.063> <0.223, 0.395, 0.061> <0.214, 0.387, 0.046> <0.205, 0.382, 0.038> 
		<0.233, 0.393, 0.065> <0.224, 0.387, 0.066> <0.212, 0.376, 0.056> <0.205, 0.373, 0.048> 
		<0.234, 0.385, 0.064> <0.225, 0.379, 0.064> <0.213, 0.370, 0.057> <0.206, 0.367, 0.049> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.201, 0.385, 0.041> <0.192, 0.380, 0.033> <0.170, 0.378, 0.024> <0.170, 0.378, 0.011> 
		<0.205, 0.382, 0.038> <0.196, 0.377, 0.030> <0.175, 0.376, 0.024> <0.175, 0.376, 0.010> 
		<0.205, 0.373, 0.048> <0.195, 0.370, 0.038> <0.180, 0.369, 0.024> <0.179, 0.369, 0.010> 
		<0.206, 0.367, 0.049> <0.196, 0.364, 0.040> <0.182, 0.364, 0.024> <0.181, 0.364, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.170, 0.378, 0.011> <0.171, 0.378, -0.003> <0.195, 0.380, -0.011> <0.205, 0.385, -0.020> 
		<0.175, 0.376, 0.010> <0.176, 0.376, -0.004> <0.198, 0.376, -0.008> <0.207, 0.382, -0.017> 
		<0.179, 0.369, 0.010> <0.178, 0.369, -0.003> <0.195, 0.369, -0.018> <0.203, 0.373, -0.027> 
		<0.181, 0.364, 0.010> <0.181, 0.364, -0.003> <0.193, 0.363, -0.019> <0.201, 0.367, -0.029> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.205, 0.385, -0.020> <0.213, 0.390, -0.029> <0.218, 0.402, -0.045> <0.227, 0.411, -0.047> 
		<0.207, 0.382, -0.017> <0.216, 0.386, -0.025> <0.221, 0.395, -0.043> <0.230, 0.404, -0.045> 
		<0.203, 0.373, -0.027> <0.211, 0.376, -0.036> <0.222, 0.387, -0.047> <0.231, 0.394, -0.047> 
		<0.201, 0.367, -0.029> <0.209, 0.371, -0.037> <0.222, 0.379, -0.045> <0.232, 0.386, -0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.227, 0.411, -0.047> <0.236, 0.419, -0.049> <0.250, 0.429, -0.041> <0.256, 0.435, -0.033> 
		<0.230, 0.404, -0.045> <0.239, 0.412, -0.047> <0.252, 0.422, -0.041> <0.258, 0.428, -0.033> 
		<0.231, 0.394, -0.047> <0.242, 0.401, -0.047> <0.253, 0.413, -0.039> <0.261, 0.419, -0.031> 
		<0.232, 0.386, -0.046> <0.243, 0.394, -0.046> <0.256, 0.406, -0.039> <0.263, 0.412, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.269, 0.412, 0.049> <0.262, 0.405, 0.058> <0.246, 0.393, 0.064> <0.234, 0.385, 0.064> 
		<0.271, 0.405, 0.047> <0.264, 0.398, 0.057> <0.246, 0.390, 0.064> <0.235, 0.382, 0.064> 
		<0.272, 0.395, 0.046> <0.264, 0.390, 0.055> <0.247, 0.382, 0.061> <0.235, 0.377, 0.061> 
		<0.273, 0.388, 0.045> <0.265, 0.383, 0.053> <0.248, 0.378, 0.059> <0.237, 0.374, 0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.234, 0.385, 0.064> <0.225, 0.379, 0.064> <0.213, 0.370, 0.057> <0.206, 0.367, 0.049> 
		<0.235, 0.382, 0.064> <0.226, 0.375, 0.064> <0.214, 0.368, 0.057> <0.206, 0.365, 0.050> 
		<0.235, 0.377, 0.061> <0.225, 0.373, 0.062> <0.212, 0.364, 0.054> <0.204, 0.362, 0.047> 
		<0.237, 0.374, 0.060> <0.226, 0.370, 0.060> <0.213, 0.362, 0.053> <0.205, 0.360, 0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.206, 0.367, 0.049> <0.196, 0.364, 0.040> <0.182, 0.364, 0.024> <0.181, 0.364, 0.010> 
		<0.206, 0.365, 0.050> <0.197, 0.361, 0.040> <0.183, 0.363, 0.024> <0.182, 0.363, 0.010> 
		<0.204, 0.362, 0.047> <0.195, 0.359, 0.039> <0.181, 0.360, 0.023> <0.179, 0.360, 0.010> 
		<0.205, 0.360, 0.046> <0.195, 0.357, 0.037> <0.182, 0.359, 0.023> <0.180, 0.359, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.181, 0.364, 0.010> <0.181, 0.364, -0.003> <0.193, 0.363, -0.019> <0.201, 0.367, -0.029> 
		<0.182, 0.363, 0.010> <0.182, 0.363, -0.003> <0.192, 0.361, -0.020> <0.201, 0.365, -0.029> 
		<0.179, 0.360, 0.010> <0.178, 0.360, -0.001> <0.189, 0.359, -0.019> <0.197, 0.362, -0.027> 
		<0.180, 0.359, 0.010> <0.179, 0.359, -0.001> <0.189, 0.357, -0.017> <0.197, 0.360, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.201, 0.367, -0.029> <0.209, 0.371, -0.037> <0.222, 0.379, -0.045> <0.232, 0.386, -0.046> 
		<0.201, 0.365, -0.029> <0.208, 0.368, -0.038> <0.223, 0.376, -0.045> <0.233, 0.383, -0.045> 
		<0.197, 0.362, -0.027> <0.205, 0.365, -0.035> <0.219, 0.374, -0.042> <0.230, 0.378, -0.042> 
		<0.197, 0.360, -0.025> <0.205, 0.362, -0.033> <0.220, 0.370, -0.040> <0.231, 0.375, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.232, 0.386, -0.046> <0.243, 0.394, -0.046> <0.256, 0.406, -0.039> <0.263, 0.412, -0.030> 
		<0.233, 0.383, -0.045> <0.243, 0.390, -0.045> <0.258, 0.399, -0.038> <0.265, 0.405, -0.029> 
		<0.230, 0.378, -0.042> <0.243, 0.383, -0.043> <0.260, 0.391, -0.037> <0.270, 0.396, -0.028> 
		<0.231, 0.375, -0.040> <0.243, 0.380, -0.040> <0.262, 0.384, -0.035> <0.271, 0.389, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.273, 0.388, 0.045> <0.265, 0.383, 0.053> <0.248, 0.378, 0.059> <0.237, 0.374, 0.060> 
		<0.273, 0.386, 0.044> <0.265, 0.381, 0.052> <0.249, 0.377, 0.058> <0.238, 0.372, 0.058> 
		<0.270, 0.385, 0.042> <0.264, 0.381, 0.049> <0.249, 0.375, 0.055> <0.240, 0.371, 0.055> 
		<0.270, 0.383, 0.041> <0.264, 0.379, 0.048> <0.251, 0.374, 0.054> <0.242, 0.370, 0.054> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.237, 0.374, 0.060> <0.226, 0.370, 0.060> <0.213, 0.362, 0.053> <0.205, 0.360, 0.046> 
		<0.238, 0.372, 0.058> <0.227, 0.368, 0.058> <0.214, 0.360, 0.052> <0.206, 0.358, 0.045> 
		<0.240, 0.371, 0.055> <0.230, 0.367, 0.056> <0.217, 0.361, 0.050> <0.209, 0.359, 0.043> 
		<0.242, 0.370, 0.054> <0.232, 0.366, 0.055> <0.218, 0.360, 0.049> <0.211, 0.357, 0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.205, 0.360, 0.046> <0.195, 0.357, 0.037> <0.182, 0.359, 0.023> <0.180, 0.359, 0.010> 
		<0.206, 0.358, 0.045> <0.196, 0.356, 0.036> <0.184, 0.356, 0.023> <0.182, 0.356, 0.010> 
		<0.209, 0.359, 0.043> <0.201, 0.356, 0.036> <0.189, 0.354, 0.022> <0.187, 0.354, 0.010> 
		<0.211, 0.357, 0.042> <0.202, 0.354, 0.035> <0.191, 0.352, 0.022> <0.189, 0.352, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.180, 0.359, 0.010> <0.179, 0.359, -0.001> <0.189, 0.357, -0.017> <0.197, 0.360, -0.025> 
		<0.182, 0.356, 0.010> <0.181, 0.356, -0.001> <0.189, 0.356, -0.016> <0.197, 0.358, -0.024> 
		<0.187, 0.354, 0.010> <0.186, 0.354, 0.000> <0.193, 0.356, -0.015> <0.200, 0.358, -0.022> 
		<0.189, 0.352, 0.010> <0.188, 0.352, 0.000> <0.194, 0.354, -0.015> <0.201, 0.357, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.197, 0.360, -0.025> <0.205, 0.362, -0.033> <0.220, 0.370, -0.040> <0.231, 0.375, -0.040> 
		<0.197, 0.358, -0.024> <0.205, 0.361, -0.032> <0.220, 0.368, -0.039> <0.231, 0.373, -0.039> 
		<0.200, 0.358, -0.022> <0.208, 0.362, -0.030> <0.223, 0.368, -0.036> <0.234, 0.372, -0.036> 
		<0.201, 0.357, -0.022> <0.209, 0.360, -0.029> <0.224, 0.366, -0.035> <0.235, 0.370, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.231, 0.375, -0.040> <0.243, 0.380, -0.040> <0.262, 0.384, -0.035> <0.271, 0.389, -0.026> 
		<0.231, 0.373, -0.039> <0.244, 0.378, -0.039> <0.262, 0.382, -0.034> <0.271, 0.387, -0.026> 
		<0.234, 0.372, -0.036> <0.244, 0.376, -0.036> <0.261, 0.382, -0.031> <0.268, 0.386, -0.023> 
		<0.235, 0.370, -0.035> <0.246, 0.375, -0.036> <0.260, 0.380, -0.030> <0.268, 0.384, -0.023> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.270, 0.383, 0.041> <0.264, 0.379, 0.048> <0.251, 0.374, 0.054> <0.242, 0.370, 0.054> 
		<0.270, 0.382, 0.040> <0.264, 0.378, 0.047> <0.252, 0.373, 0.053> <0.243, 0.369, 0.054> 
		<0.271, 0.380, 0.040> <0.265, 0.376, 0.047> <0.253, 0.371, 0.054> <0.244, 0.367, 0.054> 
		<0.272, 0.379, 0.041> <0.266, 0.375, 0.048> <0.254, 0.370, 0.054> <0.245, 0.366, 0.054> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.242, 0.370, 0.054> <0.232, 0.366, 0.055> <0.218, 0.360, 0.049> <0.211, 0.357, 0.042> 
		<0.243, 0.369, 0.054> <0.233, 0.365, 0.054> <0.219, 0.359, 0.048> <0.211, 0.356, 0.042> 
		<0.244, 0.367, 0.054> <0.234, 0.363, 0.054> <0.220, 0.357, 0.049> <0.212, 0.354, 0.042> 
		<0.245, 0.366, 0.054> <0.235, 0.361, 0.055> <0.220, 0.356, 0.049> <0.212, 0.353, 0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.211, 0.357, 0.042> <0.202, 0.354, 0.035> <0.191, 0.352, 0.022> <0.189, 0.352, 0.010> 
		<0.211, 0.356, 0.042> <0.203, 0.353, 0.035> <0.192, 0.351, 0.022> <0.190, 0.351, 0.010> 
		<0.212, 0.354, 0.042> <0.203, 0.352, 0.035> <0.192, 0.349, 0.022> <0.191, 0.349, 0.010> 
		<0.212, 0.353, 0.042> <0.203, 0.350, 0.035> <0.193, 0.348, 0.022> <0.191, 0.348, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.189, 0.352, 0.010> <0.188, 0.352, 0.000> <0.194, 0.354, -0.015> <0.201, 0.357, -0.022> 
		<0.190, 0.351, 0.010> <0.189, 0.351, 0.000> <0.195, 0.353, -0.014> <0.202, 0.356, -0.021> 
		<0.191, 0.349, 0.010> <0.189, 0.349, 0.000> <0.195, 0.351, -0.014> <0.202, 0.354, -0.021> 
		<0.191, 0.348, 0.010> <0.190, 0.348, 0.000> <0.196, 0.350, -0.015> <0.203, 0.353, -0.021> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.201, 0.357, -0.022> <0.209, 0.360, -0.029> <0.224, 0.366, -0.035> <0.235, 0.370, -0.035> 
		<0.202, 0.356, -0.021> <0.210, 0.359, -0.029> <0.225, 0.365, -0.035> <0.236, 0.369, -0.035> 
		<0.202, 0.354, -0.021> <0.211, 0.357, -0.029> <0.227, 0.363, -0.035> <0.238, 0.368, -0.035> 
		<0.203, 0.353, -0.021> <0.211, 0.356, -0.030> <0.227, 0.362, -0.035> <0.239, 0.366, -0.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.235, 0.370, -0.035> <0.246, 0.375, -0.036> <0.260, 0.380, -0.030> <0.268, 0.384, -0.023> 
		<0.236, 0.369, -0.035> <0.247, 0.374, -0.035> <0.260, 0.379, -0.029> <0.268, 0.383, -0.022> 
		<0.238, 0.368, -0.035> <0.248, 0.372, -0.035> <0.262, 0.377, -0.030> <0.269, 0.381, -0.022> 
		<0.239, 0.366, -0.036> <0.249, 0.370, -0.036> <0.263, 0.376, -0.030> <0.270, 0.380, -0.023> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.272, 0.379, 0.041> <0.266, 0.375, 0.048> <0.254, 0.370, 0.054> <0.245, 0.366, 0.054> 
		<0.273, 0.375, 0.042> <0.267, 0.372, 0.049> <0.255, 0.366, 0.055> <0.246, 0.363, 0.055> 
		<0.275, 0.371, 0.044> <0.269, 0.367, 0.052> <0.257, 0.362, 0.058> <0.247, 0.358, 0.058> 
		<0.277, 0.368, 0.045> <0.271, 0.364, 0.052> <0.258, 0.359, 0.059> <0.248, 0.355, 0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.245, 0.366, 0.054> <0.235, 0.361, 0.055> <0.220, 0.356, 0.049> <0.212, 0.353, 0.042> 
		<0.246, 0.363, 0.055> <0.236, 0.358, 0.056> <0.221, 0.352, 0.050> <0.213, 0.350, 0.043> 
		<0.247, 0.358, 0.058> <0.237, 0.354, 0.058> <0.223, 0.348, 0.053> <0.215, 0.345, 0.045> 
		<0.248, 0.355, 0.059> <0.238, 0.350, 0.059> <0.223, 0.344, 0.053> <0.215, 0.341, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.212, 0.353, 0.042> <0.203, 0.350, 0.035> <0.193, 0.348, 0.022> <0.191, 0.348, 0.010> 
		<0.213, 0.350, 0.043> <0.204, 0.347, 0.036> <0.194, 0.344, 0.022> <0.192, 0.344, 0.010> 
		<0.215, 0.345, 0.045> <0.206, 0.342, 0.037> <0.194, 0.339, 0.023> <0.193, 0.339, 0.010> 
		<0.215, 0.341, 0.045> <0.206, 0.338, 0.037> <0.195, 0.336, 0.023> <0.193, 0.335, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.191, 0.348, 0.010> <0.190, 0.348, 0.000> <0.196, 0.350, -0.015> <0.203, 0.353, -0.021> 
		<0.192, 0.344, 0.010> <0.191, 0.344, 0.000> <0.197, 0.346, -0.015> <0.204, 0.349, -0.022> 
		<0.193, 0.339, 0.010> <0.192, 0.339, -0.001> <0.199, 0.342, -0.017> <0.206, 0.345, -0.024> 
		<0.193, 0.335, 0.010> <0.192, 0.335, -0.001> <0.200, 0.338, -0.017> <0.207, 0.341, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.203, 0.353, -0.021> <0.211, 0.356, -0.030> <0.227, 0.362, -0.035> <0.239, 0.366, -0.036> 
		<0.204, 0.349, -0.022> <0.213, 0.353, -0.030> <0.229, 0.358, -0.036> <0.240, 0.363, -0.037> 
		<0.206, 0.345, -0.024> <0.214, 0.348, -0.033> <0.230, 0.354, -0.039> <0.241, 0.358, -0.039> 
		<0.207, 0.341, -0.025> <0.216, 0.344, -0.033> <0.231, 0.350, -0.040> <0.242, 0.355, -0.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.239, 0.366, -0.036> <0.249, 0.370, -0.036> <0.263, 0.376, -0.030> <0.270, 0.380, -0.023> 
		<0.240, 0.363, -0.037> <0.250, 0.367, -0.037> <0.265, 0.373, -0.031> <0.272, 0.376, -0.023> 
		<0.241, 0.358, -0.039> <0.253, 0.363, -0.039> <0.267, 0.368, -0.034> <0.275, 0.372, -0.025> 
		<0.242, 0.355, -0.041> <0.253, 0.359, -0.041> <0.269, 0.364, -0.034> <0.277, 0.368, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.277, 0.368, 0.045> <0.271, 0.364, 0.052> <0.258, 0.359, 0.059> <0.248, 0.355, 0.059> 
		<0.278, 0.365, 0.045> <0.272, 0.361, 0.053> <0.259, 0.356, 0.061> <0.249, 0.352, 0.061> 
		<0.281, 0.361, 0.044> <0.274, 0.357, 0.053> <0.261, 0.352, 0.064> <0.251, 0.347, 0.064> 
		<0.283, 0.358, 0.044> <0.276, 0.354, 0.053> <0.263, 0.348, 0.064> <0.252, 0.344, 0.064> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.248, 0.355, 0.059> <0.238, 0.350, 0.059> <0.223, 0.344, 0.053> <0.215, 0.341, 0.045> 
		<0.249, 0.352, 0.061> <0.239, 0.347, 0.061> <0.223, 0.340, 0.053> <0.215, 0.337, 0.046> 
		<0.251, 0.347, 0.064> <0.238, 0.342, 0.064> <0.223, 0.336, 0.053> <0.213, 0.332, 0.044> 
		<0.252, 0.344, 0.064> <0.239, 0.338, 0.064> <0.223, 0.332, 0.054> <0.213, 0.328, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.215, 0.341, 0.045> <0.206, 0.338, 0.037> <0.195, 0.336, 0.023> <0.193, 0.335, 0.010> 
		<0.215, 0.337, 0.046> <0.206, 0.334, 0.038> <0.195, 0.331, 0.022> <0.194, 0.331, 0.010> 
		<0.213, 0.332, 0.044> <0.205, 0.329, 0.036> <0.194, 0.326, 0.022> <0.194, 0.326, 0.010> 
		<0.213, 0.328, 0.045> <0.204, 0.325, 0.037> <0.194, 0.322, 0.022> <0.193, 0.322, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.193, 0.335, 0.010> <0.192, 0.335, -0.001> <0.200, 0.338, -0.017> <0.207, 0.341, -0.025> 
		<0.194, 0.331, 0.010> <0.192, 0.331, -0.001> <0.201, 0.334, -0.018> <0.208, 0.337, -0.025> 
		<0.194, 0.326, 0.010> <0.193, 0.325, -0.002> <0.201, 0.328, -0.016> <0.208, 0.331, -0.024> 
		<0.193, 0.322, 0.010> <0.193, 0.321, -0.002> <0.202, 0.324, -0.017> <0.210, 0.328, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.207, 0.341, -0.025> <0.216, 0.344, -0.033> <0.231, 0.350, -0.040> <0.242, 0.355, -0.041> 
		<0.208, 0.337, -0.025> <0.217, 0.340, -0.034> <0.232, 0.347, -0.042> <0.243, 0.351, -0.042> 
		<0.208, 0.331, -0.024> <0.217, 0.335, -0.033> <0.231, 0.342, -0.045> <0.243, 0.346, -0.045> 
		<0.210, 0.328, -0.025> <0.218, 0.331, -0.034> <0.232, 0.338, -0.046> <0.244, 0.343, -0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.242, 0.355, -0.041> <0.253, 0.359, -0.041> <0.269, 0.364, -0.034> <0.277, 0.368, -0.026> 
		<0.243, 0.351, -0.042> <0.254, 0.355, -0.042> <0.271, 0.361, -0.034> <0.279, 0.365, -0.026> 
		<0.243, 0.346, -0.045> <0.256, 0.352, -0.045> <0.272, 0.356, -0.034> <0.282, 0.361, -0.024> 
		<0.244, 0.343, -0.045> <0.257, 0.348, -0.045> <0.274, 0.353, -0.034> <0.284, 0.358, -0.024> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.283, 0.358, 0.044> <0.276, 0.354, 0.053> <0.263, 0.348, 0.064> <0.252, 0.344, 0.064> 
		<0.287, 0.350, 0.044> <0.280, 0.346, 0.052> <0.267, 0.340, 0.065> <0.256, 0.336, 0.065> 
		<0.293, 0.339, 0.044> <0.286, 0.337, 0.053> <0.274, 0.328, 0.062> <0.262, 0.326, 0.063> 
		<0.296, 0.331, 0.044> <0.289, 0.328, 0.053> <0.277, 0.320, 0.063> <0.265, 0.317, 0.063> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.252, 0.344, 0.064> <0.239, 0.338, 0.064> <0.223, 0.332, 0.054> <0.213, 0.328, 0.045> 
		<0.256, 0.336, 0.065> <0.243, 0.330, 0.065> <0.221, 0.327, 0.055> <0.212, 0.324, 0.045> 
		<0.262, 0.326, 0.063> <0.245, 0.322, 0.064> <0.221, 0.319, 0.060> <0.207, 0.317, 0.050> 
		<0.265, 0.317, 0.063> <0.248, 0.314, 0.065> <0.223, 0.315, 0.060> <0.209, 0.313, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.213, 0.328, 0.045> <0.204, 0.325, 0.037> <0.194, 0.322, 0.022> <0.193, 0.322, 0.010> 
		<0.212, 0.324, 0.045> <0.203, 0.320, 0.037> <0.193, 0.317, 0.022> <0.193, 0.317, 0.010> 
		<0.207, 0.317, 0.050> <0.196, 0.316, 0.042> <0.186, 0.311, 0.023> <0.187, 0.311, 0.009> 
		<0.209, 0.313, 0.050> <0.198, 0.311, 0.042> <0.188, 0.307, 0.023> <0.189, 0.307, 0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.193, 0.322, 0.010> <0.193, 0.321, -0.002> <0.202, 0.324, -0.017> <0.210, 0.328, -0.025> 
		<0.193, 0.317, 0.010> <0.192, 0.317, -0.002> <0.204, 0.319, -0.018> <0.211, 0.322, -0.026> 
		<0.187, 0.311, 0.009> <0.189, 0.311, -0.005> <0.203, 0.314, -0.021> <0.214, 0.316, -0.031> 
		<0.189, 0.307, 0.009> <0.191, 0.307, -0.005> <0.206, 0.310, -0.021> <0.217, 0.312, -0.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.210, 0.328, -0.025> <0.218, 0.331, -0.034> <0.232, 0.338, -0.046> <0.244, 0.343, -0.045> 
		<0.211, 0.322, -0.026> <0.220, 0.326, -0.035> <0.234, 0.330, -0.046> <0.246, 0.335, -0.046> 
		<0.214, 0.316, -0.031> <0.222, 0.318, -0.038> <0.236, 0.322, -0.045> <0.247, 0.325, -0.044> 
		<0.217, 0.312, -0.031> <0.226, 0.313, -0.038> <0.240, 0.315, -0.045> <0.251, 0.318, -0.044> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.244, 0.343, -0.045> <0.257, 0.348, -0.045> <0.274, 0.353, -0.034> <0.284, 0.358, -0.024> 
		<0.246, 0.335, -0.046> <0.259, 0.341, -0.046> <0.279, 0.345, -0.033> <0.289, 0.350, -0.024> 
		<0.247, 0.325, -0.044> <0.263, 0.328, -0.042> <0.284, 0.336, -0.035> <0.295, 0.339, -0.023> 
		<0.251, 0.318, -0.044> <0.267, 0.322, -0.042> <0.288, 0.328, -0.034> <0.300, 0.331, -0.023> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.296, 0.331, 0.044> <0.289, 0.328, 0.053> <0.277, 0.320, 0.063> <0.265, 0.317, 0.063> 
		<0.299, 0.325, 0.043> <0.292, 0.322, 0.052> <0.278, 0.316, 0.063> <0.267, 0.313, 0.064> 
		<0.303, 0.318, 0.041> <0.294, 0.315, 0.051> <0.280, 0.310, 0.065> <0.267, 0.307, 0.066> 
		<0.303, 0.311, 0.041> <0.295, 0.309, 0.051> <0.281, 0.306, 0.065> <0.267, 0.303, 0.066> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.265, 0.317, 0.063> <0.248, 0.314, 0.065> <0.223, 0.315, 0.060> <0.209, 0.313, 0.050> 
		<0.267, 0.313, 0.064> <0.250, 0.310, 0.065> <0.225, 0.308, 0.060> <0.211, 0.306, 0.050> 
		<0.267, 0.307, 0.066> <0.252, 0.305, 0.067> <0.231, 0.304, 0.055> <0.220, 0.301, 0.045> 
		<0.267, 0.303, 0.066> <0.253, 0.300, 0.066> <0.234, 0.298, 0.055> <0.224, 0.295, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.209, 0.313, 0.050> <0.198, 0.311, 0.042> <0.188, 0.307, 0.023> <0.189, 0.307, 0.009> 
		<0.211, 0.306, 0.050> <0.200, 0.304, 0.042> <0.191, 0.300, 0.023> <0.193, 0.299, 0.010> 
		<0.220, 0.301, 0.045> <0.212, 0.299, 0.038> <0.202, 0.295, 0.021> <0.204, 0.295, 0.010> 
		<0.224, 0.295, 0.045> <0.216, 0.293, 0.037> <0.207, 0.289, 0.021> <0.209, 0.289, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.189, 0.307, 0.009> <0.191, 0.307, -0.005> <0.206, 0.310, -0.021> <0.217, 0.312, -0.031> 
		<0.193, 0.299, 0.010> <0.194, 0.299, -0.005> <0.211, 0.304, -0.021> <0.222, 0.306, -0.031> 
		<0.204, 0.295, 0.010> <0.207, 0.295, -0.004> <0.223, 0.300, -0.017> <0.233, 0.302, -0.026> 
		<0.209, 0.289, 0.010> <0.211, 0.289, -0.004> <0.226, 0.293, -0.016> <0.236, 0.295, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.217, 0.312, -0.031> <0.226, 0.313, -0.038> <0.240, 0.315, -0.045> <0.251, 0.318, -0.044> 
		<0.222, 0.306, -0.031> <0.231, 0.307, -0.038> <0.244, 0.310, -0.045> <0.255, 0.312, -0.044> 
		<0.233, 0.302, -0.026> <0.241, 0.304, -0.034> <0.252, 0.306, -0.047> <0.264, 0.309, -0.046> 
		<0.236, 0.295, -0.025> <0.244, 0.297, -0.033> <0.257, 0.301, -0.047> <0.268, 0.303, -0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.251, 0.318, -0.044> <0.267, 0.322, -0.042> <0.288, 0.328, -0.034> <0.300, 0.331, -0.023> 
		<0.255, 0.312, -0.044> <0.270, 0.316, -0.042> <0.291, 0.322, -0.033> <0.303, 0.325, -0.022> 
		<0.264, 0.309, -0.046> <0.278, 0.312, -0.045> <0.298, 0.315, -0.031> <0.307, 0.318, -0.020> 
		<0.268, 0.303, -0.046> <0.282, 0.307, -0.044> <0.299, 0.309, -0.030> <0.309, 0.311, -0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.303, 0.311, 0.041> <0.295, 0.309, 0.051> <0.281, 0.306, 0.065> <0.267, 0.303, 0.066> 
		<0.304, 0.307, 0.041> <0.295, 0.305, 0.051> <0.282, 0.301, 0.064> <0.269, 0.298, 0.065> 
		<0.299, 0.302, 0.042> <0.292, 0.300, 0.049> <0.281, 0.295, 0.061> <0.271, 0.292, 0.062> 
		<0.299, 0.298, 0.042> <0.292, 0.296, 0.049> <0.282, 0.290, 0.060> <0.272, 0.287, 0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.267, 0.303, 0.066> <0.253, 0.300, 0.066> <0.234, 0.298, 0.055> <0.224, 0.295, 0.045> 
		<0.269, 0.298, 0.065> <0.254, 0.295, 0.066> <0.237, 0.293, 0.054> <0.227, 0.290, 0.044> 
		<0.271, 0.292, 0.062> <0.258, 0.288, 0.062> <0.240, 0.285, 0.054> <0.230, 0.282, 0.045> 
		<0.272, 0.287, 0.060> <0.259, 0.283, 0.061> <0.241, 0.279, 0.053> <0.230, 0.277, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.224, 0.295, 0.045> <0.216, 0.293, 0.037> <0.207, 0.289, 0.021> <0.209, 0.289, 0.010> 
		<0.227, 0.290, 0.044> <0.219, 0.288, 0.036> <0.209, 0.285, 0.021> <0.211, 0.285, 0.010> 
		<0.230, 0.282, 0.045> <0.221, 0.281, 0.038> <0.210, 0.279, 0.022> <0.211, 0.279, 0.010> 
		<0.230, 0.277, 0.045> <0.221, 0.275, 0.037> <0.210, 0.274, 0.022> <0.211, 0.274, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.209, 0.289, 0.010> <0.211, 0.289, -0.004> <0.226, 0.293, -0.016> <0.236, 0.295, -0.025> 
		<0.211, 0.285, 0.010> <0.214, 0.285, -0.003> <0.229, 0.288, -0.016> <0.238, 0.290, -0.025> 
		<0.211, 0.279, 0.010> <0.212, 0.279, -0.003> <0.226, 0.280, -0.018> <0.236, 0.282, -0.026> 
		<0.211, 0.274, 0.010> <0.212, 0.274, -0.003> <0.224, 0.275, -0.018> <0.235, 0.277, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.236, 0.295, -0.025> <0.244, 0.297, -0.033> <0.257, 0.301, -0.047> <0.268, 0.303, -0.046> 
		<0.238, 0.290, -0.025> <0.247, 0.292, -0.033> <0.260, 0.296, -0.046> <0.271, 0.299, -0.045> 
		<0.236, 0.282, -0.026> <0.247, 0.284, -0.034> <0.262, 0.288, -0.043> <0.275, 0.292, -0.042> 
		<0.235, 0.277, -0.026> <0.245, 0.279, -0.034> <0.263, 0.283, -0.041> <0.276, 0.287, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.268, 0.303, -0.046> <0.282, 0.307, -0.044> <0.299, 0.309, -0.030> <0.309, 0.311, -0.019> 
		<0.271, 0.299, -0.045> <0.286, 0.302, -0.044> <0.300, 0.305, -0.030> <0.309, 0.307, -0.019> 
		<0.275, 0.292, -0.042> <0.285, 0.296, -0.041> <0.299, 0.300, -0.029> <0.306, 0.303, -0.021> 
		<0.276, 0.287, -0.040> <0.287, 0.290, -0.040> <0.298, 0.296, -0.029> <0.305, 0.299, -0.021> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.299, 0.298, 0.042> <0.292, 0.296, 0.049> <0.282, 0.290, 0.060> <0.272, 0.287, 0.060> 
		<0.298, 0.292, 0.041> <0.291, 0.290, 0.049> <0.282, 0.283, 0.058> <0.272, 0.280, 0.059> 
		<0.302, 0.285, 0.039> <0.294, 0.282, 0.046> <0.283, 0.274, 0.057> <0.272, 0.271, 0.058> 
		<0.302, 0.278, 0.038> <0.294, 0.276, 0.045> <0.283, 0.268, 0.055> <0.272, 0.265, 0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.272, 0.287, 0.060> <0.259, 0.283, 0.061> <0.241, 0.279, 0.053> <0.230, 0.277, 0.045> 
		<0.272, 0.280, 0.059> <0.259, 0.276, 0.059> <0.241, 0.273, 0.053> <0.231, 0.270, 0.044> 
		<0.272, 0.271, 0.058> <0.258, 0.267, 0.058> <0.238, 0.264, 0.051> <0.227, 0.263, 0.043> 
		<0.272, 0.265, 0.055> <0.258, 0.261, 0.056> <0.238, 0.259, 0.050> <0.226, 0.257, 0.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.230, 0.277, 0.045> <0.221, 0.275, 0.037> <0.210, 0.274, 0.022> <0.211, 0.274, 0.010> 
		<0.231, 0.270, 0.044> <0.222, 0.269, 0.037> <0.210, 0.268, 0.022> <0.211, 0.268, 0.010> 
		<0.227, 0.263, 0.043> <0.218, 0.261, 0.037> <0.207, 0.261, 0.021> <0.206, 0.260, 0.009> 
		<0.226, 0.257, 0.041> <0.217, 0.255, 0.035> <0.208, 0.255, 0.020> <0.208, 0.255, 0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.211, 0.274, 0.010> <0.212, 0.274, -0.003> <0.224, 0.275, -0.018> <0.235, 0.277, -0.026> 
		<0.211, 0.268, 0.010> <0.211, 0.268, -0.003> <0.223, 0.268, -0.017> <0.233, 0.270, -0.025> 
		<0.206, 0.260, 0.009> <0.206, 0.260, -0.001> <0.218, 0.261, -0.018> <0.227, 0.263, -0.024> 
		<0.208, 0.255, 0.009> <0.207, 0.254, -0.002> <0.217, 0.255, -0.016> <0.226, 0.256, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.235, 0.277, -0.026> <0.245, 0.279, -0.034> <0.263, 0.283, -0.041> <0.276, 0.287, -0.040> 
		<0.233, 0.270, -0.025> <0.243, 0.272, -0.033> <0.264, 0.277, -0.040> <0.277, 0.281, -0.039> 
		<0.227, 0.263, -0.024> <0.240, 0.265, -0.033> <0.261, 0.267, -0.039> <0.276, 0.271, -0.038> 
		<0.226, 0.256, -0.022> <0.239, 0.258, -0.031> <0.261, 0.261, -0.036> <0.276, 0.265, -0.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.276, 0.287, -0.040> <0.287, 0.290, -0.040> <0.298, 0.296, -0.029> <0.305, 0.299, -0.021> 
		<0.277, 0.281, -0.039> <0.288, 0.284, -0.038> <0.298, 0.290, -0.029> <0.305, 0.293, -0.021> 
		<0.276, 0.271, -0.038> <0.286, 0.274, -0.037> <0.298, 0.282, -0.026> <0.306, 0.285, -0.019> 
		<0.276, 0.265, -0.036> <0.287, 0.268, -0.035> <0.298, 0.276, -0.026> <0.306, 0.279, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.302, 0.278, 0.038> <0.294, 0.276, 0.045> <0.283, 0.268, 0.055> <0.272, 0.265, 0.055> 
		<0.303, 0.274, 0.038> <0.295, 0.272, 0.045> <0.283, 0.266, 0.054> <0.272, 0.263, 0.055> 
		<0.303, 0.269, 0.038> <0.296, 0.266, 0.045> <0.282, 0.264, 0.051> <0.272, 0.262, 0.051> 
		<0.301, 0.265, 0.039> <0.294, 0.262, 0.045> <0.281, 0.262, 0.050> <0.272, 0.261, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.272, 0.265, 0.055> <0.258, 0.261, 0.056> <0.238, 0.259, 0.050> <0.226, 0.257, 0.041> 
		<0.272, 0.263, 0.055> <0.258, 0.259, 0.055> <0.238, 0.257, 0.049> <0.226, 0.255, 0.041> 
		<0.272, 0.262, 0.051> <0.259, 0.260, 0.051> <0.239, 0.257, 0.046> <0.228, 0.255, 0.038> 
		<0.272, 0.261, 0.050> <0.258, 0.259, 0.050> <0.239, 0.255, 0.046> <0.228, 0.253, 0.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.226, 0.257, 0.041> <0.217, 0.255, 0.035> <0.208, 0.255, 0.020> <0.208, 0.255, 0.009> 
		<0.226, 0.255, 0.041> <0.217, 0.254, 0.034> <0.208, 0.252, 0.020> <0.208, 0.252, 0.009> 
		<0.228, 0.255, 0.038> <0.221, 0.254, 0.033> <0.213, 0.253, 0.019> <0.213, 0.253, 0.009> 
		<0.228, 0.253, 0.038> <0.221, 0.252, 0.032> <0.215, 0.251, 0.019> <0.215, 0.251, 0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.208, 0.255, 0.009> <0.207, 0.254, -0.002> <0.217, 0.255, -0.016> <0.226, 0.256, -0.022> 
		<0.208, 0.252, 0.009> <0.208, 0.252, -0.002> <0.216, 0.253, -0.016> <0.225, 0.254, -0.022> 
		<0.213, 0.253, 0.009> <0.214, 0.252, -0.000> <0.221, 0.253, -0.014> <0.229, 0.254, -0.020> 
		<0.215, 0.251, 0.009> <0.215, 0.251, -0.001> <0.222, 0.251, -0.014> <0.230, 0.253, -0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.226, 0.256, -0.022> <0.239, 0.258, -0.031> <0.261, 0.261, -0.036> <0.276, 0.265, -0.036> 
		<0.225, 0.254, -0.022> <0.238, 0.256, -0.030> <0.261, 0.259, -0.036> <0.276, 0.263, -0.035> 
		<0.229, 0.254, -0.020> <0.241, 0.256, -0.027> <0.262, 0.260, -0.032> <0.276, 0.263, -0.032> 
		<0.230, 0.253, -0.019> <0.242, 0.254, -0.027> <0.262, 0.259, -0.031> <0.276, 0.261, -0.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.276, 0.265, -0.036> <0.287, 0.268, -0.035> <0.298, 0.276, -0.026> <0.306, 0.279, -0.018> 
		<0.276, 0.263, -0.035> <0.287, 0.266, -0.034> <0.298, 0.272, -0.026> <0.306, 0.275, -0.018> 
		<0.276, 0.263, -0.032> <0.285, 0.264, -0.032> <0.300, 0.267, -0.025> <0.307, 0.269, -0.019> 
		<0.276, 0.261, -0.031> <0.286, 0.262, -0.031> <0.299, 0.263, -0.025> <0.306, 0.265, -0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.301, 0.265, 0.039> <0.294, 0.262, 0.045> <0.281, 0.262, 0.050> <0.272, 0.261, 0.050> 
		<0.301, 0.263, 0.039> <0.294, 0.261, 0.045> <0.281, 0.261, 0.050> <0.272, 0.260, 0.050> 
		<0.297, 0.263, 0.038> <0.290, 0.262, 0.043> <0.280, 0.259, 0.050> <0.271, 0.258, 0.050> 
		<0.297, 0.261, 0.039> <0.290, 0.260, 0.044> <0.280, 0.258, 0.051> <0.271, 0.257, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.272, 0.261, 0.050> <0.258, 0.259, 0.050> <0.239, 0.255, 0.046> <0.228, 0.253, 0.038> 
		<0.272, 0.260, 0.050> <0.258, 0.258, 0.050> <0.239, 0.254, 0.045> <0.228, 0.252, 0.037> 
		<0.271, 0.258, 0.050> <0.257, 0.256, 0.050> <0.238, 0.253, 0.046> <0.227, 0.250, 0.037> 
		<0.271, 0.257, 0.050> <0.257, 0.255, 0.050> <0.237, 0.251, 0.046> <0.226, 0.249, 0.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.228, 0.253, 0.038> <0.221, 0.252, 0.032> <0.215, 0.251, 0.019> <0.215, 0.251, 0.009> 
		<0.228, 0.252, 0.037> <0.221, 0.251, 0.031> <0.216, 0.250, 0.018> <0.216, 0.250, 0.009> 
		<0.227, 0.250, 0.037> <0.220, 0.249, 0.032> <0.215, 0.248, 0.018> <0.216, 0.248, 0.009> 
		<0.226, 0.249, 0.038> <0.219, 0.248, 0.032> <0.216, 0.247, 0.018> <0.217, 0.247, 0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.215, 0.251, 0.009> <0.215, 0.251, -0.001> <0.222, 0.251, -0.014> <0.230, 0.253, -0.019> 
		<0.216, 0.250, 0.009> <0.216, 0.250, -0.001> <0.223, 0.250, -0.013> <0.231, 0.252, -0.018> 
		<0.216, 0.248, 0.009> <0.216, 0.247, -0.000> <0.224, 0.248, -0.013> <0.231, 0.250, -0.019> 
		<0.217, 0.247, 0.009> <0.217, 0.247, -0.000> <0.223, 0.247, -0.014> <0.231, 0.248, -0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.230, 0.253, -0.019> <0.242, 0.254, -0.027> <0.262, 0.259, -0.031> <0.276, 0.261, -0.031> 
		<0.231, 0.252, -0.018> <0.243, 0.253, -0.026> <0.262, 0.258, -0.030> <0.276, 0.260, -0.030> 
		<0.231, 0.250, -0.019> <0.243, 0.252, -0.026> <0.262, 0.255, -0.030> <0.276, 0.258, -0.030> 
		<0.231, 0.248, -0.019> <0.243, 0.250, -0.027> <0.262, 0.254, -0.031> <0.276, 0.257, -0.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.276, 0.261, -0.031> <0.286, 0.262, -0.031> <0.299, 0.263, -0.025> <0.306, 0.265, -0.019> 
		<0.276, 0.260, -0.030> <0.286, 0.261, -0.030> <0.298, 0.261, -0.025> <0.305, 0.263, -0.019> 
		<0.276, 0.258, -0.030> <0.284, 0.259, -0.030> <0.295, 0.262, -0.023> <0.301, 0.263, -0.018> 
		<0.276, 0.257, -0.031> <0.284, 0.258, -0.031> <0.294, 0.260, -0.024> <0.300, 0.261, -0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.297, 0.261, 0.039> <0.290, 0.260, 0.044> <0.280, 0.258, 0.051> <0.271, 0.257, 0.050> 
		<0.297, 0.258, 0.040> <0.290, 0.257, 0.045> <0.279, 0.256, 0.052> <0.271, 0.254, 0.052> 
		<0.300, 0.256, 0.042> <0.293, 0.255, 0.049> <0.280, 0.253, 0.055> <0.271, 0.252, 0.054> 
		<0.301, 0.253, 0.042> <0.294, 0.253, 0.049> <0.281, 0.251, 0.056> <0.271, 0.249, 0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.271, 0.257, 0.050> <0.257, 0.255, 0.050> <0.237, 0.251, 0.046> <0.226, 0.249, 0.038> 
		<0.271, 0.254, 0.052> <0.257, 0.252, 0.051> <0.235, 0.249, 0.047> <0.224, 0.247, 0.038> 
		<0.271, 0.252, 0.054> <0.254, 0.249, 0.054> <0.230, 0.246, 0.052> <0.219, 0.244, 0.040> 
		<0.271, 0.249, 0.056> <0.255, 0.246, 0.055> <0.230, 0.242, 0.053> <0.219, 0.241, 0.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.226, 0.249, 0.038> <0.219, 0.248, 0.032> <0.216, 0.247, 0.018> <0.217, 0.247, 0.009> 
		<0.224, 0.247, 0.038> <0.217, 0.245, 0.033> <0.218, 0.245, 0.018> <0.219, 0.245, 0.009> 
		<0.219, 0.244, 0.040> <0.212, 0.243, 0.033> <0.223, 0.244, 0.019> <0.224, 0.244, 0.009> 
		<0.219, 0.241, 0.041> <0.212, 0.239, 0.034> <0.224, 0.242, 0.019> <0.225, 0.242, 0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.217, 0.247, 0.009> <0.217, 0.247, -0.000> <0.223, 0.247, -0.014> <0.231, 0.248, -0.019> 
		<0.219, 0.245, 0.009> <0.220, 0.244, -0.000> <0.223, 0.244, -0.014> <0.230, 0.246, -0.020> 
		<0.224, 0.244, 0.009> <0.225, 0.244, -0.000> <0.220, 0.241, -0.015> <0.227, 0.242, -0.021> 
		<0.225, 0.242, 0.009> <0.226, 0.241, -0.000> <0.220, 0.239, -0.016> <0.227, 0.240, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.231, 0.248, -0.019> <0.243, 0.250, -0.027> <0.262, 0.254, -0.031> <0.276, 0.257, -0.031> 
		<0.230, 0.246, -0.020> <0.242, 0.248, -0.027> <0.263, 0.252, -0.032> <0.277, 0.254, -0.032> 
		<0.227, 0.242, -0.021> <0.239, 0.244, -0.031> <0.262, 0.248, -0.035> <0.278, 0.252, -0.035> 
		<0.227, 0.240, -0.022> <0.239, 0.241, -0.032> <0.262, 0.246, -0.036> <0.278, 0.249, -0.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.276, 0.257, -0.031> <0.284, 0.258, -0.031> <0.294, 0.260, -0.024> <0.300, 0.261, -0.019> 
		<0.277, 0.254, -0.032> <0.285, 0.256, -0.032> <0.293, 0.258, -0.025> <0.299, 0.259, -0.019> 
		<0.278, 0.252, -0.035> <0.286, 0.253, -0.035> <0.295, 0.255, -0.027> <0.300, 0.256, -0.022> 
		<0.278, 0.249, -0.036> <0.286, 0.250, -0.036> <0.295, 0.253, -0.028> <0.300, 0.254, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.301, 0.253, 0.042> <0.294, 0.253, 0.049> <0.281, 0.251, 0.056> <0.271, 0.249, 0.056> 
		<0.303, 0.248, 0.043> <0.295, 0.247, 0.050> <0.281, 0.246, 0.058> <0.271, 0.245, 0.058> 
		<0.302, 0.240, 0.043> <0.295, 0.240, 0.050> <0.284, 0.240, 0.059> <0.274, 0.239, 0.059> 
		<0.303, 0.235, 0.042> <0.296, 0.235, 0.050> <0.284, 0.235, 0.060> <0.274, 0.234, 0.061> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.271, 0.249, 0.056> <0.255, 0.246, 0.055> <0.230, 0.242, 0.053> <0.219, 0.241, 0.041> 
		<0.271, 0.245, 0.058> <0.255, 0.242, 0.057> <0.230, 0.238, 0.054> <0.219, 0.236, 0.043> 
		<0.274, 0.239, 0.059> <0.259, 0.237, 0.060> <0.236, 0.234, 0.055> <0.225, 0.233, 0.044> 
		<0.274, 0.234, 0.061> <0.259, 0.233, 0.061> <0.237, 0.230, 0.056> <0.227, 0.228, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.219, 0.241, 0.041> <0.212, 0.239, 0.034> <0.224, 0.242, 0.019> <0.225, 0.242, 0.009> 
		<0.219, 0.236, 0.043> <0.212, 0.235, 0.036> <0.225, 0.237, 0.019> <0.226, 0.237, 0.009> 
		<0.225, 0.233, 0.044> <0.218, 0.231, 0.037> <0.222, 0.230, 0.020> <0.223, 0.230, 0.009> 
		<0.227, 0.228, 0.045> <0.219, 0.227, 0.037> <0.222, 0.226, 0.020> <0.223, 0.226, 0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.225, 0.242, 0.009> <0.226, 0.241, -0.000> <0.220, 0.239, -0.016> <0.227, 0.240, -0.022> 
		<0.226, 0.237, 0.009> <0.228, 0.237, -0.000> <0.220, 0.235, -0.017> <0.228, 0.236, -0.023> 
		<0.223, 0.230, 0.009> <0.224, 0.230, -0.002> <0.225, 0.231, -0.018> <0.233, 0.232, -0.025> 
		<0.223, 0.226, 0.009> <0.224, 0.226, -0.002> <0.225, 0.227, -0.018> <0.233, 0.228, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.227, 0.240, -0.022> <0.239, 0.241, -0.032> <0.262, 0.246, -0.036> <0.278, 0.249, -0.036> 
		<0.228, 0.236, -0.023> <0.240, 0.238, -0.034> <0.263, 0.242, -0.038> <0.279, 0.245, -0.038> 
		<0.233, 0.232, -0.025> <0.243, 0.234, -0.034> <0.264, 0.237, -0.041> <0.279, 0.239, -0.040> 
		<0.233, 0.228, -0.026> <0.243, 0.230, -0.035> <0.264, 0.232, -0.041> <0.278, 0.234, -0.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.278, 0.249, -0.036> <0.286, 0.250, -0.036> <0.295, 0.253, -0.028> <0.300, 0.254, -0.022> 
		<0.279, 0.245, -0.038> <0.286, 0.246, -0.038> <0.294, 0.247, -0.029> <0.299, 0.248, -0.023> 
		<0.279, 0.239, -0.040> <0.287, 0.239, -0.039> <0.290, 0.240, -0.029> <0.295, 0.240, -0.022> 
		<0.278, 0.234, -0.041> <0.286, 0.235, -0.040> <0.292, 0.235, -0.028> <0.297, 0.235, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.303, 0.235, 0.042> <0.296, 0.235, 0.050> <0.284, 0.235, 0.060> <0.274, 0.234, 0.061> 
		<0.306, 0.227, 0.042> <0.299, 0.226, 0.049> <0.284, 0.227, 0.062> <0.274, 0.226, 0.062> 
		<0.314, 0.217, 0.039> <0.303, 0.217, 0.050> <0.288, 0.215, 0.064> <0.273, 0.214, 0.065> 
		<0.315, 0.209, 0.039> <0.304, 0.209, 0.050> <0.287, 0.207, 0.063> <0.272, 0.206, 0.065> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.274, 0.234, 0.061> <0.259, 0.233, 0.061> <0.237, 0.230, 0.056> <0.227, 0.228, 0.045> 
		<0.274, 0.226, 0.062> <0.259, 0.224, 0.063> <0.240, 0.223, 0.057> <0.229, 0.221, 0.046> 
		<0.273, 0.214, 0.065> <0.260, 0.214, 0.067> <0.239, 0.212, 0.058> <0.230, 0.211, 0.049> 
		<0.272, 0.206, 0.065> <0.259, 0.205, 0.067> <0.240, 0.204, 0.058> <0.231, 0.204, 0.049> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.227, 0.228, 0.045> <0.219, 0.227, 0.037> <0.222, 0.226, 0.020> <0.223, 0.226, 0.009> 
		<0.229, 0.221, 0.046> <0.221, 0.220, 0.039> <0.221, 0.219, 0.020> <0.222, 0.219, 0.009> 
		<0.230, 0.211, 0.049> <0.221, 0.211, 0.040> <0.220, 0.209, 0.022> <0.219, 0.209, 0.010> 
		<0.231, 0.204, 0.049> <0.222, 0.203, 0.040> <0.220, 0.202, 0.022> <0.219, 0.202, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.223, 0.226, 0.009> <0.224, 0.226, -0.002> <0.225, 0.227, -0.018> <0.233, 0.228, -0.026> 
		<0.222, 0.219, 0.009> <0.222, 0.219, -0.001> <0.224, 0.219, -0.020> <0.232, 0.221, -0.027> 
		<0.219, 0.209, 0.010> <0.218, 0.209, -0.002> <0.218, 0.211, -0.021> <0.227, 0.211, -0.029> 
		<0.219, 0.202, 0.010> <0.218, 0.202, -0.002> <0.218, 0.203, -0.021> <0.226, 0.204, -0.029> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.233, 0.228, -0.026> <0.243, 0.230, -0.035> <0.264, 0.232, -0.041> <0.278, 0.234, -0.041> 
		<0.232, 0.221, -0.027> <0.243, 0.222, -0.037> <0.263, 0.224, -0.043> <0.277, 0.226, -0.042> 
		<0.227, 0.211, -0.029> <0.237, 0.212, -0.040> <0.260, 0.214, -0.046> <0.275, 0.214, -0.045> 
		<0.226, 0.204, -0.029> <0.236, 0.204, -0.040> <0.258, 0.205, -0.046> <0.273, 0.206, -0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.278, 0.234, -0.041> <0.286, 0.235, -0.040> <0.292, 0.235, -0.028> <0.297, 0.235, -0.022> 
		<0.277, 0.226, -0.042> <0.285, 0.227, -0.042> <0.295, 0.225, -0.028> <0.300, 0.226, -0.022> 
		<0.275, 0.214, -0.045> <0.290, 0.215, -0.043> <0.304, 0.218, -0.031> <0.315, 0.219, -0.020> 
		<0.273, 0.206, -0.045> <0.288, 0.207, -0.043> <0.306, 0.209, -0.031> <0.317, 0.209, -0.020> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.315, 0.209, 0.039> <0.304, 0.209, 0.050> <0.287, 0.207, 0.063> <0.272, 0.206, 0.065> 
		<0.317, 0.199, 0.039> <0.306, 0.199, 0.050> <0.286, 0.198, 0.063> <0.271, 0.197, 0.065> 
		<0.312, 0.186, 0.042> <0.301, 0.186, 0.052> <0.282, 0.186, 0.062> <0.267, 0.186, 0.062> 
		<0.313, 0.176, 0.042> <0.302, 0.176, 0.052> <0.282, 0.177, 0.060> <0.266, 0.177, 0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.272, 0.206, 0.065> <0.259, 0.205, 0.067> <0.240, 0.204, 0.058> <0.231, 0.204, 0.049> 
		<0.271, 0.197, 0.065> <0.257, 0.196, 0.066> <0.241, 0.197, 0.058> <0.231, 0.196, 0.049> 
		<0.267, 0.186, 0.062> <0.256, 0.186, 0.063> <0.237, 0.185, 0.055> <0.230, 0.185, 0.046> 
		<0.266, 0.177, 0.060> <0.255, 0.178, 0.061> <0.240, 0.178, 0.054> <0.232, 0.178, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.231, 0.204, 0.049> <0.222, 0.203, 0.040> <0.220, 0.202, 0.022> <0.219, 0.202, 0.010> 
		<0.231, 0.196, 0.049> <0.223, 0.195, 0.040> <0.220, 0.195, 0.022> <0.219, 0.195, 0.010> 
		<0.230, 0.185, 0.046> <0.223, 0.185, 0.038> <0.221, 0.186, 0.021> <0.220, 0.186, 0.010> 
		<0.232, 0.178, 0.045> <0.225, 0.178, 0.037> <0.223, 0.179, 0.021> <0.222, 0.179, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.219, 0.202, 0.010> <0.218, 0.202, -0.002> <0.218, 0.203, -0.021> <0.226, 0.204, -0.029> 
		<0.219, 0.195, 0.010> <0.218, 0.195, -0.002> <0.217, 0.195, -0.021> <0.225, 0.196, -0.029> 
		<0.220, 0.186, 0.010> <0.220, 0.186, -0.001> <0.219, 0.187, -0.018> <0.226, 0.186, -0.026> 
		<0.222, 0.179, 0.010> <0.222, 0.179, -0.001> <0.222, 0.180, -0.017> <0.229, 0.178, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.226, 0.204, -0.029> <0.236, 0.204, -0.040> <0.258, 0.205, -0.046> <0.273, 0.206, -0.045> 
		<0.225, 0.196, -0.029> <0.236, 0.197, -0.040> <0.256, 0.195, -0.046> <0.271, 0.196, -0.045> 
		<0.226, 0.186, -0.026> <0.233, 0.184, -0.035> <0.253, 0.182, -0.044> <0.264, 0.182, -0.043> 
		<0.229, 0.178, -0.025> <0.236, 0.177, -0.034> <0.252, 0.172, -0.042> <0.264, 0.172, -0.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.273, 0.206, -0.045> <0.288, 0.207, -0.043> <0.306, 0.209, -0.031> <0.317, 0.209, -0.020> 
		<0.271, 0.196, -0.045> <0.286, 0.196, -0.043> <0.308, 0.199, -0.031> <0.319, 0.199, -0.020> 
		<0.264, 0.182, -0.043> <0.279, 0.182, -0.043> <0.298, 0.186, -0.031> <0.309, 0.187, -0.022> 
		<0.264, 0.172, -0.041> <0.278, 0.171, -0.041> <0.297, 0.176, -0.032> <0.308, 0.177, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.313, 0.176, 0.042> <0.302, 0.176, 0.052> <0.282, 0.177, 0.060> <0.266, 0.177, 0.060> 
		<0.314, 0.172, 0.042> <0.303, 0.172, 0.053> <0.281, 0.172, 0.059> <0.266, 0.172, 0.059> 
		<0.318, 0.168, 0.043> <0.306, 0.167, 0.053> <0.285, 0.166, 0.057> <0.270, 0.165, 0.057> 
		<0.320, 0.165, 0.042> <0.308, 0.163, 0.052> <0.285, 0.161, 0.055> <0.269, 0.160, 0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.266, 0.177, 0.060> <0.255, 0.178, 0.061> <0.240, 0.178, 0.054> <0.232, 0.178, 0.045> 
		<0.266, 0.172, 0.059> <0.255, 0.172, 0.060> <0.242, 0.171, 0.053> <0.234, 0.171, 0.044> 
		<0.270, 0.165, 0.057> <0.261, 0.164, 0.057> <0.248, 0.165, 0.050> <0.242, 0.165, 0.043> 
		<0.269, 0.160, 0.055> <0.261, 0.159, 0.055> <0.250, 0.159, 0.048> <0.245, 0.159, 0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.232, 0.178, 0.045> <0.225, 0.178, 0.037> <0.223, 0.179, 0.021> <0.222, 0.179, 0.010> 
		<0.234, 0.171, 0.044> <0.227, 0.172, 0.036> <0.225, 0.172, 0.021> <0.224, 0.173, 0.010> 
		<0.242, 0.165, 0.043> <0.236, 0.165, 0.035> <0.231, 0.165, 0.020> <0.230, 0.165, 0.010> 
		<0.245, 0.159, 0.042> <0.239, 0.159, 0.034> <0.233, 0.159, 0.020> <0.232, 0.159, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.222, 0.179, 0.010> <0.222, 0.179, -0.001> <0.222, 0.180, -0.017> <0.229, 0.178, -0.025> 
		<0.224, 0.173, 0.010> <0.224, 0.173, -0.001> <0.224, 0.173, -0.016> <0.231, 0.172, -0.024> 
		<0.230, 0.165, 0.010> <0.230, 0.165, 0.000> <0.232, 0.165, -0.016> <0.238, 0.165, -0.024> 
		<0.232, 0.159, 0.010> <0.232, 0.159, 0.000> <0.235, 0.158, -0.014> <0.241, 0.159, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.229, 0.178, -0.025> <0.236, 0.177, -0.034> <0.252, 0.172, -0.042> <0.264, 0.172, -0.041> 
		<0.231, 0.172, -0.024> <0.238, 0.170, -0.033> <0.252, 0.168, -0.041> <0.263, 0.168, -0.040> 
		<0.238, 0.165, -0.024> <0.245, 0.165, -0.031> <0.258, 0.163, -0.038> <0.268, 0.164, -0.038> 
		<0.241, 0.159, -0.022> <0.247, 0.159, -0.029> <0.260, 0.160, -0.036> <0.270, 0.161, -0.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.264, 0.172, -0.041> <0.278, 0.171, -0.041> <0.297, 0.176, -0.032> <0.308, 0.177, -0.022> 
		<0.263, 0.168, -0.040> <0.278, 0.167, -0.040> <0.297, 0.172, -0.032> <0.308, 0.173, -0.022> 
		<0.268, 0.164, -0.038> <0.281, 0.165, -0.038> <0.301, 0.167, -0.031> <0.311, 0.168, -0.023> 
		<0.270, 0.161, -0.036> <0.283, 0.162, -0.036> <0.302, 0.163, -0.030> <0.312, 0.164, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.320, 0.165, 0.042> <0.308, 0.163, 0.052> <0.285, 0.161, 0.055> <0.269, 0.160, 0.055> 
		<0.322, 0.162, 0.042> <0.309, 0.161, 0.052> <0.285, 0.158, 0.054> <0.269, 0.157, 0.054> 
		<0.324, 0.160, 0.040> <0.310, 0.158, 0.050> <0.285, 0.155, 0.052> <0.267, 0.154, 0.052> 
		<0.324, 0.158, 0.039> <0.309, 0.156, 0.049> <0.284, 0.153, 0.050> <0.266, 0.152, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.269, 0.160, 0.055> <0.261, 0.159, 0.055> <0.250, 0.159, 0.048> <0.245, 0.159, 0.042> 
		<0.269, 0.157, 0.054> <0.261, 0.156, 0.054> <0.251, 0.157, 0.048> <0.246, 0.157, 0.041> 
		<0.267, 0.154, 0.052> <0.259, 0.153, 0.052> <0.249, 0.153, 0.045> <0.244, 0.153, 0.040> 
		<0.266, 0.152, 0.050> <0.258, 0.151, 0.050> <0.249, 0.151, 0.044> <0.244, 0.151, 0.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.245, 0.159, 0.042> <0.239, 0.159, 0.034> <0.233, 0.159, 0.020> <0.232, 0.159, 0.010> 
		<0.246, 0.157, 0.041> <0.240, 0.156, 0.033> <0.234, 0.156, 0.020> <0.233, 0.156, 0.010> 
		<0.244, 0.153, 0.040> <0.237, 0.153, 0.033> <0.231, 0.153, 0.019> <0.230, 0.153, 0.010> 
		<0.244, 0.151, 0.038> <0.238, 0.151, 0.031> <0.231, 0.151, 0.019> <0.230, 0.151, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.232, 0.159, 0.010> <0.232, 0.159, 0.000> <0.235, 0.158, -0.014> <0.241, 0.159, -0.022> 
		<0.233, 0.156, 0.010> <0.232, 0.156, 0.000> <0.236, 0.156, -0.014> <0.242, 0.156, -0.021> 
		<0.230, 0.153, 0.010> <0.229, 0.153, 0.001> <0.233, 0.152, -0.014> <0.239, 0.153, -0.020> 
		<0.230, 0.151, 0.010> <0.230, 0.150, 0.001> <0.233, 0.150, -0.013> <0.240, 0.151, -0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.241, 0.159, -0.022> <0.247, 0.159, -0.029> <0.260, 0.160, -0.036> <0.270, 0.161, -0.036> 
		<0.242, 0.156, -0.021> <0.248, 0.157, -0.029> <0.262, 0.157, -0.035> <0.272, 0.158, -0.035> 
		<0.239, 0.153, -0.020> <0.248, 0.153, -0.027> <0.263, 0.154, -0.033> <0.274, 0.155, -0.033> 
		<0.240, 0.151, -0.019> <0.248, 0.151, -0.026> <0.264, 0.153, -0.031> <0.275, 0.153, -0.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.270, 0.161, -0.036> <0.283, 0.162, -0.036> <0.302, 0.163, -0.030> <0.312, 0.164, -0.022> 
		<0.272, 0.158, -0.035> <0.285, 0.159, -0.035> <0.302, 0.161, -0.030> <0.312, 0.162, -0.021> 
		<0.274, 0.155, -0.033> <0.286, 0.156, -0.033> <0.304, 0.158, -0.027> <0.313, 0.159, -0.020> 
		<0.275, 0.153, -0.031> <0.287, 0.154, -0.031> <0.304, 0.156, -0.026> <0.313, 0.157, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.324, 0.158, 0.039> <0.309, 0.156, 0.049> <0.284, 0.153, 0.050> <0.266, 0.152, 0.050> 
		<0.324, 0.156, 0.037> <0.309, 0.154, 0.048> <0.283, 0.152, 0.049> <0.265, 0.150, 0.049> 
		<0.320, 0.155, 0.036> <0.306, 0.153, 0.045> <0.281, 0.151, 0.046> <0.264, 0.149, 0.046> 
		<0.319, 0.153, 0.035> <0.304, 0.152, 0.044> <0.280, 0.149, 0.045> <0.264, 0.148, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.266, 0.152, 0.050> <0.258, 0.151, 0.050> <0.249, 0.151, 0.044> <0.244, 0.151, 0.038> 
		<0.265, 0.150, 0.049> <0.258, 0.150, 0.049> <0.249, 0.150, 0.043> <0.244, 0.150, 0.038> 
		<0.264, 0.149, 0.046> <0.258, 0.149, 0.046> <0.250, 0.149, 0.040> <0.246, 0.149, 0.036> 
		<0.264, 0.148, 0.045> <0.258, 0.147, 0.045> <0.250, 0.147, 0.040> <0.247, 0.147, 0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.244, 0.151, 0.038> <0.238, 0.151, 0.031> <0.231, 0.151, 0.019> <0.230, 0.151, 0.010> 
		<0.244, 0.150, 0.038> <0.238, 0.149, 0.030> <0.231, 0.149, 0.019> <0.230, 0.149, 0.010> 
		<0.246, 0.149, 0.036> <0.241, 0.149, 0.029> <0.234, 0.148, 0.018> <0.233, 0.148, 0.010> 
		<0.247, 0.147, 0.035> <0.241, 0.147, 0.029> <0.234, 0.147, 0.018> <0.234, 0.147, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.230, 0.151, 0.010> <0.230, 0.150, 0.001> <0.233, 0.150, -0.013> <0.240, 0.151, -0.019> 
		<0.230, 0.149, 0.010> <0.230, 0.149, 0.001> <0.234, 0.149, -0.012> <0.240, 0.149, -0.018> 
		<0.233, 0.148, 0.010> <0.233, 0.148, 0.002> <0.237, 0.148, -0.011> <0.243, 0.149, -0.016> 
		<0.234, 0.147, 0.010> <0.234, 0.147, 0.002> <0.238, 0.147, -0.010> <0.244, 0.147, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.240, 0.151, -0.019> <0.248, 0.151, -0.026> <0.264, 0.153, -0.031> <0.275, 0.153, -0.031> 
		<0.240, 0.149, -0.018> <0.249, 0.150, -0.025> <0.265, 0.151, -0.030> <0.276, 0.152, -0.030> 
		<0.243, 0.149, -0.016> <0.251, 0.149, -0.023> <0.266, 0.151, -0.027> <0.277, 0.151, -0.027> 
		<0.244, 0.147, -0.015> <0.252, 0.148, -0.022> <0.267, 0.149, -0.026> <0.278, 0.150, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.275, 0.153, -0.031> <0.287, 0.154, -0.031> <0.304, 0.156, -0.026> <0.313, 0.157, -0.018> 
		<0.276, 0.152, -0.030> <0.288, 0.153, -0.029> <0.303, 0.154, -0.025> <0.312, 0.155, -0.017> 
		<0.277, 0.151, -0.027> <0.287, 0.152, -0.027> <0.302, 0.154, -0.022> <0.309, 0.154, -0.016> 
		<0.278, 0.150, -0.026> <0.287, 0.151, -0.026> <0.301, 0.152, -0.021> <0.308, 0.153, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.319, 0.153, 0.035> <0.304, 0.152, 0.044> <0.280, 0.149, 0.045> <0.264, 0.148, 0.045> 
		<0.318, 0.152, 0.035> <0.304, 0.151, 0.044> <0.280, 0.148, 0.045> <0.263, 0.147, 0.045> 
		<0.318, 0.151, 0.035> <0.303, 0.149, 0.044> <0.279, 0.146, 0.045> <0.263, 0.145, 0.045> 
		<0.318, 0.150, 0.035> <0.303, 0.148, 0.044> <0.280, 0.145, 0.045> <0.263, 0.144, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.264, 0.148, 0.045> <0.258, 0.147, 0.045> <0.250, 0.147, 0.040> <0.247, 0.147, 0.035> 
		<0.263, 0.147, 0.045> <0.257, 0.146, 0.045> <0.251, 0.146, 0.039> <0.247, 0.146, 0.035> 
		<0.263, 0.145, 0.045> <0.257, 0.144, 0.045> <0.250, 0.144, 0.039> <0.246, 0.144, 0.035> 
		<0.263, 0.144, 0.045> <0.257, 0.143, 0.045> <0.249, 0.143, 0.040> <0.245, 0.143, 0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.247, 0.147, 0.035> <0.241, 0.147, 0.029> <0.234, 0.147, 0.018> <0.234, 0.147, 0.010> 
		<0.247, 0.146, 0.035> <0.241, 0.146, 0.028> <0.235, 0.146, 0.018> <0.234, 0.146, 0.010> 
		<0.246, 0.144, 0.035> <0.241, 0.144, 0.028> <0.234, 0.144, 0.018> <0.234, 0.144, 0.010> 
		<0.245, 0.143, 0.035> <0.240, 0.143, 0.029> <0.233, 0.143, 0.018> <0.233, 0.143, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.234, 0.147, 0.010> <0.234, 0.147, 0.002> <0.238, 0.147, -0.010> <0.244, 0.147, -0.015> 
		<0.234, 0.146, 0.010> <0.234, 0.146, 0.002> <0.238, 0.146, -0.010> <0.244, 0.146, -0.015> 
		<0.234, 0.144, 0.010> <0.234, 0.144, 0.002> <0.238, 0.144, -0.010> <0.245, 0.144, -0.015> 
		<0.233, 0.143, 0.010> <0.233, 0.143, 0.002> <0.238, 0.143, -0.010> <0.244, 0.143, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.244, 0.147, -0.015> <0.252, 0.148, -0.022> <0.267, 0.149, -0.026> <0.278, 0.150, -0.026> 
		<0.244, 0.146, -0.015> <0.253, 0.147, -0.021> <0.267, 0.148, -0.025> <0.278, 0.149, -0.025> 
		<0.245, 0.144, -0.015> <0.253, 0.145, -0.022> <0.268, 0.146, -0.025> <0.279, 0.147, -0.025> 
		<0.244, 0.143, -0.015> <0.253, 0.144, -0.022> <0.268, 0.145, -0.026> <0.279, 0.146, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.278, 0.150, -0.026> <0.287, 0.151, -0.026> <0.301, 0.152, -0.021> <0.308, 0.153, -0.015> 
		<0.278, 0.149, -0.025> <0.288, 0.150, -0.025> <0.300, 0.151, -0.021> <0.308, 0.152, -0.014> 
		<0.279, 0.147, -0.025> <0.289, 0.148, -0.025> <0.301, 0.149, -0.021> <0.308, 0.150, -0.015> 
		<0.279, 0.146, -0.026> <0.288, 0.147, -0.026> <0.302, 0.148, -0.021> <0.309, 0.149, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.318, 0.150, 0.035> <0.303, 0.148, 0.044> <0.280, 0.145, 0.045> <0.263, 0.144, 0.045> 
		<0.318, 0.147, 0.036> <0.303, 0.145, 0.045> <0.280, 0.143, 0.046> <0.263, 0.141, 0.046> 
		<0.319, 0.144, 0.038> <0.306, 0.143, 0.047> <0.281, 0.140, 0.049> <0.264, 0.139, 0.049> 
		<0.318, 0.141, 0.038> <0.305, 0.140, 0.048> <0.281, 0.138, 0.050> <0.265, 0.137, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.263, 0.144, 0.045> <0.257, 0.143, 0.045> <0.249, 0.143, 0.040> <0.245, 0.143, 0.035> 
		<0.263, 0.141, 0.046> <0.257, 0.141, 0.046> <0.248, 0.142, 0.041> <0.244, 0.142, 0.036> 
		<0.264, 0.139, 0.049> <0.256, 0.139, 0.049> <0.247, 0.141, 0.044> <0.241, 0.141, 0.038> 
		<0.265, 0.137, 0.050> <0.256, 0.137, 0.050> <0.245, 0.139, 0.045> <0.240, 0.139, 0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.245, 0.143, 0.035> <0.240, 0.143, 0.029> <0.233, 0.143, 0.018> <0.233, 0.143, 0.010> 
		<0.244, 0.142, 0.036> <0.239, 0.142, 0.029> <0.232, 0.142, 0.018> <0.231, 0.142, 0.010> 
		<0.241, 0.141, 0.038> <0.234, 0.142, 0.031> <0.228, 0.142, 0.019> <0.227, 0.142, 0.010> 
		<0.240, 0.139, 0.039> <0.233, 0.140, 0.032> <0.227, 0.140, 0.019> <0.226, 0.140, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.233, 0.143, 0.010> <0.233, 0.143, 0.002> <0.238, 0.143, -0.010> <0.244, 0.143, -0.015> 
		<0.231, 0.142, 0.010> <0.231, 0.142, 0.002> <0.236, 0.141, -0.011> <0.243, 0.141, -0.016> 
		<0.227, 0.142, 0.010> <0.227, 0.142, 0.001> <0.231, 0.141, -0.012> <0.239, 0.141, -0.018> 
		<0.226, 0.140, 0.010> <0.226, 0.140, 0.001> <0.230, 0.139, -0.013> <0.237, 0.139, -0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.244, 0.143, -0.015> <0.253, 0.144, -0.022> <0.268, 0.145, -0.026> <0.279, 0.146, -0.026> 
		<0.243, 0.141, -0.016> <0.251, 0.142, -0.023> <0.268, 0.143, -0.027> <0.279, 0.144, -0.027> 
		<0.239, 0.141, -0.018> <0.248, 0.141, -0.026> <0.265, 0.141, -0.029> <0.277, 0.141, -0.029> 
		<0.237, 0.139, -0.019> <0.247, 0.139, -0.027> <0.264, 0.138, -0.031> <0.276, 0.138, -0.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.279, 0.146, -0.026> <0.288, 0.147, -0.026> <0.302, 0.148, -0.021> <0.309, 0.149, -0.015> 
		<0.279, 0.144, -0.027> <0.288, 0.144, -0.027> <0.303, 0.146, -0.022> <0.310, 0.146, -0.016> 
		<0.277, 0.141, -0.029> <0.289, 0.141, -0.029> <0.304, 0.143, -0.025> <0.313, 0.144, -0.018> 
		<0.276, 0.138, -0.031> <0.288, 0.139, -0.031> <0.304, 0.140, -0.026> <0.313, 0.141, -0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.318, 0.141, 0.038> <0.305, 0.140, 0.048> <0.281, 0.138, 0.050> <0.265, 0.137, 0.050> 
		<0.317, 0.137, 0.040> <0.304, 0.136, 0.049> <0.282, 0.135, 0.052> <0.265, 0.134, 0.052> 
		<0.312, 0.132, 0.041> <0.302, 0.132, 0.050> <0.280, 0.130, 0.054> <0.266, 0.130, 0.054> 
		<0.311, 0.127, 0.042> <0.300, 0.127, 0.051> <0.281, 0.127, 0.055> <0.267, 0.127, 0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.265, 0.137, 0.050> <0.256, 0.137, 0.050> <0.245, 0.139, 0.045> <0.240, 0.139, 0.039> 
		<0.265, 0.134, 0.052> <0.257, 0.134, 0.052> <0.244, 0.136, 0.046> <0.238, 0.137, 0.040> 
		<0.266, 0.130, 0.054> <0.256, 0.130, 0.054> <0.244, 0.132, 0.049> <0.237, 0.132, 0.041> 
		<0.267, 0.127, 0.055> <0.257, 0.127, 0.055> <0.244, 0.128, 0.049> <0.237, 0.129, 0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.240, 0.139, 0.039> <0.233, 0.140, 0.032> <0.227, 0.140, 0.019> <0.226, 0.140, 0.010> 
		<0.238, 0.137, 0.040> <0.232, 0.137, 0.033> <0.225, 0.137, 0.019> <0.225, 0.137, 0.010> 
		<0.237, 0.132, 0.041> <0.231, 0.133, 0.034> <0.227, 0.133, 0.020> <0.227, 0.133, 0.010> 
		<0.237, 0.129, 0.042> <0.230, 0.129, 0.034> <0.226, 0.130, 0.020> <0.226, 0.130, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.226, 0.140, 0.010> <0.226, 0.140, 0.001> <0.230, 0.139, -0.013> <0.237, 0.139, -0.019> 
		<0.225, 0.137, 0.010> <0.224, 0.137, 0.001> <0.229, 0.137, -0.014> <0.236, 0.136, -0.020> 
		<0.227, 0.133, 0.010> <0.226, 0.133, -0.000> <0.229, 0.132, -0.015> <0.237, 0.132, -0.022> 
		<0.226, 0.130, 0.010> <0.226, 0.130, -0.000> <0.229, 0.129, -0.015> <0.236, 0.128, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.237, 0.139, -0.019> <0.247, 0.139, -0.027> <0.264, 0.138, -0.031> <0.276, 0.138, -0.031> 
		<0.236, 0.136, -0.020> <0.245, 0.136, -0.028> <0.263, 0.135, -0.032> <0.275, 0.135, -0.032> 
		<0.237, 0.132, -0.022> <0.245, 0.131, -0.030> <0.262, 0.131, -0.035> <0.274, 0.131, -0.035> 
		<0.236, 0.128, -0.022> <0.245, 0.128, -0.031> <0.262, 0.128, -0.036> <0.274, 0.128, -0.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.276, 0.138, -0.031> <0.288, 0.139, -0.031> <0.304, 0.140, -0.026> <0.313, 0.141, -0.019> 
		<0.275, 0.135, -0.032> <0.287, 0.136, -0.032> <0.305, 0.136, -0.028> <0.314, 0.137, -0.020> 
		<0.274, 0.131, -0.035> <0.286, 0.131, -0.035> <0.304, 0.132, -0.030> <0.313, 0.132, -0.021> 
		<0.274, 0.128, -0.036> <0.286, 0.128, -0.035> <0.303, 0.128, -0.030> <0.312, 0.128, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.311, 0.127, 0.042> <0.300, 0.127, 0.051> <0.281, 0.127, 0.055> <0.267, 0.127, 0.055> 
		<0.308, 0.119, 0.043> <0.298, 0.119, 0.052> <0.283, 0.118, 0.057> <0.269, 0.119, 0.057> 
		<0.305, 0.107, 0.045> <0.298, 0.107, 0.052> <0.284, 0.108, 0.060> <0.274, 0.108, 0.060> 
		<0.305, 0.098, 0.046> <0.298, 0.098, 0.053> <0.285, 0.099, 0.060> <0.275, 0.099, 0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.267, 0.127, 0.055> <0.257, 0.127, 0.055> <0.244, 0.128, 0.049> <0.237, 0.129, 0.042> 
		<0.269, 0.119, 0.057> <0.260, 0.119, 0.057> <0.243, 0.120, 0.051> <0.237, 0.121, 0.043> 
		<0.274, 0.108, 0.060> <0.262, 0.108, 0.060> <0.247, 0.109, 0.054> <0.238, 0.109, 0.045> 
		<0.275, 0.099, 0.060> <0.263, 0.100, 0.060> <0.246, 0.101, 0.054> <0.237, 0.101, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.237, 0.129, 0.042> <0.230, 0.129, 0.034> <0.226, 0.130, 0.020> <0.226, 0.130, 0.010> 
		<0.237, 0.121, 0.043> <0.230, 0.121, 0.036> <0.226, 0.121, 0.020> <0.226, 0.121, 0.010> 
		<0.238, 0.109, 0.045> <0.230, 0.110, 0.038> <0.225, 0.110, 0.022> <0.224, 0.110, 0.011> 
		<0.237, 0.101, 0.045> <0.229, 0.101, 0.038> <0.224, 0.101, 0.022> <0.223, 0.101, 0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.226, 0.130, 0.010> <0.226, 0.130, -0.000> <0.229, 0.129, -0.015> <0.236, 0.128, -0.022> 
		<0.226, 0.121, 0.010> <0.225, 0.121, 0.000> <0.228, 0.120, -0.017> <0.235, 0.120, -0.024> 
		<0.224, 0.110, 0.011> <0.223, 0.110, -0.001> <0.225, 0.109, -0.018> <0.233, 0.108, -0.026> 
		<0.223, 0.101, 0.011> <0.222, 0.101, -0.001> <0.224, 0.100, -0.018> <0.232, 0.100, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.236, 0.128, -0.022> <0.245, 0.128, -0.031> <0.262, 0.128, -0.036> <0.274, 0.128, -0.036> 
		<0.235, 0.120, -0.024> <0.244, 0.119, -0.032> <0.261, 0.120, -0.038> <0.273, 0.119, -0.037> 
		<0.233, 0.108, -0.026> <0.242, 0.108, -0.035> <0.260, 0.108, -0.040> <0.273, 0.108, -0.040> 
		<0.232, 0.100, -0.026> <0.241, 0.099, -0.035> <0.260, 0.100, -0.040> <0.272, 0.100, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.274, 0.128, -0.036> <0.286, 0.128, -0.035> <0.303, 0.128, -0.030> <0.312, 0.128, -0.022> 
		<0.273, 0.119, -0.037> <0.285, 0.119, -0.037> <0.301, 0.119, -0.032> <0.309, 0.119, -0.023> 
		<0.273, 0.108, -0.040> <0.283, 0.108, -0.040> <0.296, 0.108, -0.032> <0.303, 0.108, -0.025> 
		<0.272, 0.100, -0.040> <0.282, 0.099, -0.040> <0.294, 0.098, -0.032> <0.301, 0.099, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.305, 0.098, 0.046> <0.298, 0.098, 0.053> <0.285, 0.099, 0.060> <0.275, 0.099, 0.060> 
		<0.305, 0.090, 0.046> <0.298, 0.090, 0.053> <0.287, 0.091, 0.060> <0.277, 0.091, 0.060> 
		<0.311, 0.079, 0.044> <0.303, 0.080, 0.052> <0.288, 0.080, 0.057> <0.277, 0.080, 0.057> 
		<0.312, 0.071, 0.043> <0.304, 0.071, 0.051> <0.288, 0.072, 0.055> <0.276, 0.072, 0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.275, 0.099, 0.060> <0.263, 0.100, 0.060> <0.246, 0.101, 0.054> <0.237, 0.101, 0.045> 
		<0.277, 0.091, 0.060> <0.265, 0.092, 0.060> <0.245, 0.091, 0.054> <0.236, 0.092, 0.045> 
		<0.277, 0.080, 0.057> <0.262, 0.080, 0.057> <0.243, 0.080, 0.053> <0.232, 0.080, 0.043> 
		<0.276, 0.072, 0.055> <0.262, 0.072, 0.055> <0.241, 0.071, 0.051> <0.230, 0.071, 0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.237, 0.101, 0.045> <0.229, 0.101, 0.038> <0.224, 0.101, 0.022> <0.223, 0.101, 0.011> 
		<0.236, 0.092, 0.045> <0.228, 0.092, 0.038> <0.222, 0.092, 0.022> <0.222, 0.092, 0.011> 
		<0.232, 0.080, 0.043> <0.224, 0.080, 0.037> <0.217, 0.080, 0.020> <0.218, 0.080, 0.010> 
		<0.230, 0.071, 0.042> <0.222, 0.071, 0.036> <0.218, 0.071, 0.020> <0.219, 0.071, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.223, 0.101, 0.011> <0.222, 0.101, -0.001> <0.224, 0.100, -0.018> <0.232, 0.100, -0.026> 
		<0.222, 0.092, 0.011> <0.221, 0.092, -0.001> <0.224, 0.091, -0.018> <0.232, 0.091, -0.026> 
		<0.218, 0.080, 0.010> <0.218, 0.080, -0.000> <0.224, 0.080, -0.017> <0.232, 0.080, -0.024> 
		<0.219, 0.071, 0.010> <0.219, 0.072, -0.001> <0.226, 0.072, -0.015> <0.234, 0.072, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.232, 0.100, -0.026> <0.241, 0.099, -0.035> <0.260, 0.100, -0.040> <0.272, 0.100, -0.040> 
		<0.232, 0.091, -0.026> <0.241, 0.091, -0.035> <0.259, 0.091, -0.040> <0.272, 0.091, -0.040> 
		<0.232, 0.080, -0.024> <0.240, 0.080, -0.031> <0.259, 0.080, -0.036> <0.271, 0.079, -0.036> 
		<0.234, 0.072, -0.022> <0.242, 0.071, -0.029> <0.258, 0.071, -0.034> <0.270, 0.071, -0.034> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.272, 0.100, -0.040> <0.282, 0.099, -0.040> <0.294, 0.098, -0.032> <0.301, 0.099, -0.025> 
		<0.272, 0.091, -0.040> <0.282, 0.091, -0.039> <0.292, 0.090, -0.032> <0.299, 0.090, -0.025> 
		<0.271, 0.079, -0.036> <0.280, 0.079, -0.036> <0.293, 0.078, -0.029> <0.300, 0.078, -0.023> 
		<0.270, 0.071, -0.034> <0.279, 0.071, -0.034> <0.291, 0.069, -0.028> <0.298, 0.069, -0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.312, 0.071, 0.043> <0.304, 0.071, 0.051> <0.288, 0.072, 0.055> <0.276, 0.072, 0.055> 
		<0.312, 0.068, 0.042> <0.304, 0.068, 0.050> <0.287, 0.068, 0.055> <0.276, 0.068, 0.054> 
		<0.311, 0.063, 0.041> <0.303, 0.063, 0.049> <0.286, 0.064, 0.053> <0.275, 0.064, 0.053> 
		<0.309, 0.061, 0.039> <0.301, 0.061, 0.047> <0.285, 0.061, 0.051> <0.274, 0.061, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.276, 0.072, 0.055> <0.262, 0.072, 0.055> <0.241, 0.071, 0.051> <0.230, 0.071, 0.042> 
		<0.276, 0.068, 0.054> <0.262, 0.068, 0.054> <0.240, 0.068, 0.050> <0.229, 0.068, 0.041> 
		<0.275, 0.064, 0.053> <0.260, 0.064, 0.052> <0.237, 0.063, 0.050> <0.226, 0.063, 0.040> 
		<0.274, 0.061, 0.050> <0.260, 0.061, 0.050> <0.238, 0.060, 0.048> <0.227, 0.060, 0.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.230, 0.071, 0.042> <0.222, 0.071, 0.036> <0.218, 0.071, 0.020> <0.219, 0.071, 0.010> 
		<0.229, 0.068, 0.041> <0.221, 0.067, 0.035> <0.219, 0.067, 0.020> <0.219, 0.067, 0.010> 
		<0.226, 0.063, 0.040> <0.220, 0.063, 0.034> <0.222, 0.064, 0.018> <0.225, 0.064, 0.010> 
		<0.227, 0.060, 0.038> <0.221, 0.060, 0.033> <0.226, 0.061, 0.018> <0.228, 0.061, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.219, 0.071, 0.010> <0.219, 0.072, -0.001> <0.226, 0.072, -0.015> <0.234, 0.072, -0.022> 
		<0.219, 0.067, 0.010> <0.220, 0.068, -0.001> <0.227, 0.068, -0.014> <0.235, 0.068, -0.021> 
		<0.225, 0.064, 0.010> <0.227, 0.064, 0.001> <0.232, 0.064, -0.013> <0.239, 0.064, -0.020> 
		<0.228, 0.061, 0.010> <0.230, 0.062, 0.001> <0.235, 0.062, -0.011> <0.242, 0.062, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.234, 0.072, -0.022> <0.242, 0.071, -0.029> <0.258, 0.071, -0.034> <0.270, 0.071, -0.034> 
		<0.235, 0.068, -0.021> <0.243, 0.068, -0.029> <0.258, 0.068, -0.033> <0.269, 0.068, -0.033> 
		<0.239, 0.064, -0.020> <0.245, 0.064, -0.026> <0.260, 0.064, -0.031> <0.269, 0.063, -0.031> 
		<0.242, 0.062, -0.018> <0.248, 0.061, -0.024> <0.260, 0.061, -0.029> <0.268, 0.061, -0.029> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.270, 0.071, -0.034> <0.279, 0.071, -0.034> <0.291, 0.069, -0.028> <0.298, 0.069, -0.022> 
		<0.269, 0.068, -0.033> <0.279, 0.067, -0.033> <0.291, 0.066, -0.027> <0.298, 0.066, -0.021> 
		<0.269, 0.063, -0.031> <0.277, 0.063, -0.032> <0.290, 0.062, -0.025> <0.296, 0.062, -0.020> 
		<0.268, 0.061, -0.029> <0.277, 0.060, -0.029> <0.288, 0.059, -0.024> <0.295, 0.059, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.309, 0.061, 0.039> <0.301, 0.061, 0.047> <0.285, 0.061, 0.051> <0.274, 0.061, 0.050> 
		<0.306, 0.057, 0.037> <0.299, 0.057, 0.045> <0.284, 0.058, 0.048> <0.273, 0.058, 0.048> 
		<0.301, 0.055, 0.034> <0.295, 0.056, 0.040> <0.280, 0.056, 0.044> <0.272, 0.056, 0.044> 
		<0.297, 0.053, 0.032> <0.291, 0.053, 0.038> <0.279, 0.054, 0.041> <0.271, 0.054, 0.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.274, 0.061, 0.050> <0.260, 0.061, 0.050> <0.238, 0.060, 0.048> <0.227, 0.060, 0.038> 
		<0.273, 0.058, 0.048> <0.259, 0.058, 0.048> <0.239, 0.057, 0.046> <0.228, 0.057, 0.036> 
		<0.272, 0.056, 0.044> <0.261, 0.056, 0.043> <0.241, 0.055, 0.041> <0.233, 0.055, 0.033> 
		<0.271, 0.054, 0.041> <0.260, 0.054, 0.040> <0.244, 0.053, 0.039> <0.236, 0.053, 0.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.227, 0.060, 0.038> <0.221, 0.060, 0.033> <0.226, 0.061, 0.018> <0.228, 0.061, 0.010> 
		<0.228, 0.057, 0.036> <0.222, 0.057, 0.031> <0.229, 0.058, 0.018> <0.231, 0.059, 0.010> 
		<0.233, 0.055, 0.033> <0.229, 0.055, 0.029> <0.234, 0.056, 0.016> <0.237, 0.056, 0.010> 
		<0.236, 0.053, 0.031> <0.232, 0.053, 0.027> <0.238, 0.054, 0.016> <0.240, 0.054, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.228, 0.061, 0.010> <0.230, 0.062, 0.001> <0.235, 0.062, -0.011> <0.242, 0.062, -0.018> 
		<0.231, 0.059, 0.010> <0.234, 0.059, 0.001> <0.238, 0.059, -0.010> <0.245, 0.059, -0.016> 
		<0.237, 0.056, 0.010> <0.239, 0.056, 0.003> <0.245, 0.057, -0.008> <0.250, 0.057, -0.013> 
		<0.240, 0.054, 0.010> <0.243, 0.054, 0.004> <0.248, 0.054, -0.005> <0.253, 0.054, -0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.242, 0.062, -0.018> <0.248, 0.061, -0.024> <0.260, 0.061, -0.029> <0.268, 0.061, -0.029> 
		<0.245, 0.059, -0.016> <0.251, 0.059, -0.022> <0.259, 0.058, -0.027> <0.268, 0.058, -0.027> 
		<0.250, 0.057, -0.013> <0.253, 0.056, -0.017> <0.263, 0.056, -0.022> <0.268, 0.055, -0.022> 
		<0.253, 0.054, -0.011> <0.256, 0.054, -0.014> <0.263, 0.054, -0.019> <0.268, 0.053, -0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.268, 0.061, -0.029> <0.277, 0.060, -0.029> <0.288, 0.059, -0.024> <0.295, 0.059, -0.018> 
		<0.268, 0.058, -0.027> <0.277, 0.057, -0.027> <0.286, 0.056, -0.022> <0.293, 0.056, -0.017> 
		<0.268, 0.055, -0.022> <0.275, 0.055, -0.023> <0.285, 0.054, -0.018> <0.290, 0.054, -0.013> 
		<0.268, 0.053, -0.019> <0.274, 0.053, -0.020> <0.283, 0.052, -0.016> <0.287, 0.052, -0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.297, 0.053, 0.032> <0.291, 0.053, 0.038> <0.279, 0.054, 0.041> <0.271, 0.054, 0.041> 
		<0.295, 0.052, 0.031> <0.289, 0.052, 0.037> <0.279, 0.052, 0.039> <0.271, 0.052, 0.039> 
		<0.291, 0.052, 0.029> <0.287, 0.052, 0.033> <0.277, 0.052, 0.036> <0.270, 0.052, 0.036> 
		<0.290, 0.049, 0.029> <0.286, 0.049, 0.033> <0.276, 0.050, 0.036> <0.270, 0.050, 0.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.271, 0.054, 0.041> <0.260, 0.054, 0.040> <0.244, 0.053, 0.039> <0.236, 0.053, 0.031> 
		<0.271, 0.052, 0.039> <0.260, 0.052, 0.039> <0.247, 0.052, 0.037> <0.239, 0.052, 0.030> 
		<0.270, 0.052, 0.036> <0.262, 0.052, 0.036> <0.249, 0.052, 0.033> <0.244, 0.052, 0.028> 
		<0.270, 0.050, 0.036> <0.262, 0.050, 0.036> <0.251, 0.050, 0.033> <0.246, 0.050, 0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.236, 0.053, 0.031> <0.232, 0.053, 0.027> <0.238, 0.054, 0.016> <0.240, 0.054, 0.010> 
		<0.239, 0.052, 0.030> <0.234, 0.052, 0.025> <0.240, 0.053, 0.016> <0.242, 0.053, 0.010> 
		<0.244, 0.052, 0.028> <0.240, 0.052, 0.024> <0.245, 0.052, 0.015> <0.246, 0.052, 0.010> 
		<0.246, 0.050, 0.028> <0.242, 0.050, 0.024> <0.245, 0.050, 0.015> <0.246, 0.050, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.240, 0.054, 0.010> <0.243, 0.054, 0.004> <0.248, 0.054, -0.005> <0.253, 0.054, -0.011> 
		<0.242, 0.053, 0.010> <0.245, 0.053, 0.004> <0.249, 0.053, -0.004> <0.254, 0.053, -0.010> 
		<0.246, 0.052, 0.010> <0.248, 0.052, 0.005> <0.252, 0.052, -0.003> <0.256, 0.052, -0.007> 
		<0.246, 0.050, 0.010> <0.248, 0.050, 0.005> <0.252, 0.050, -0.002> <0.256, 0.050, -0.007> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.253, 0.054, -0.011> <0.256, 0.054, -0.014> <0.263, 0.054, -0.019> <0.268, 0.053, -0.019> 
		<0.254, 0.053, -0.010> <0.258, 0.053, -0.014> <0.263, 0.052, -0.018> <0.268, 0.052, -0.018> 
		<0.256, 0.052, -0.007> <0.259, 0.052, -0.010> <0.264, 0.052, -0.014> <0.268, 0.051, -0.015> 
		<0.256, 0.050, -0.007> <0.259, 0.050, -0.010> <0.264, 0.050, -0.014> <0.268, 0.050, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.268, 0.053, -0.019> <0.274, 0.053, -0.020> <0.283, 0.052, -0.016> <0.287, 0.052, -0.011> 
		<0.268, 0.052, -0.018> <0.274, 0.052, -0.018> <0.281, 0.051, -0.014> <0.286, 0.051, -0.010> 
		<0.268, 0.051, -0.015> <0.273, 0.051, -0.015> <0.280, 0.051, -0.011> <0.283, 0.051, -0.008> 
		<0.268, 0.050, -0.015> <0.273, 0.049, -0.015> <0.279, 0.049, -0.011> <0.282, 0.049, -0.008> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.290, 0.049, 0.029> <0.286, 0.049, 0.033> <0.276, 0.050, 0.036> <0.270, 0.050, 0.036> 
		<0.289, 0.048, 0.029> <0.285, 0.048, 0.033> <0.276, 0.048, 0.036> <0.270, 0.048, 0.036> 
		<0.294, 0.047, 0.032> <0.289, 0.047, 0.038> <0.278, 0.048, 0.041> <0.271, 0.048, 0.041> 
		<0.293, 0.045, 0.032> <0.288, 0.046, 0.038> <0.278, 0.046, 0.041> <0.270, 0.046, 0.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.270, 0.050, 0.036> <0.262, 0.050, 0.036> <0.251, 0.050, 0.033> <0.246, 0.050, 0.028> 
		<0.270, 0.048, 0.036> <0.262, 0.048, 0.036> <0.252, 0.048, 0.033> <0.247, 0.048, 0.028> 
		<0.271, 0.048, 0.041> <0.261, 0.048, 0.040> <0.247, 0.048, 0.038> <0.240, 0.048, 0.031> 
		<0.270, 0.046, 0.041> <0.261, 0.046, 0.040> <0.247, 0.046, 0.038> <0.241, 0.046, 0.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.246, 0.050, 0.028> <0.242, 0.050, 0.024> <0.245, 0.050, 0.015> <0.246, 0.050, 0.010> 
		<0.247, 0.048, 0.028> <0.243, 0.048, 0.024> <0.245, 0.048, 0.015> <0.246, 0.048, 0.011> 
		<0.240, 0.048, 0.031> <0.236, 0.048, 0.027> <0.239, 0.049, 0.016> <0.240, 0.049, 0.010> 
		<0.241, 0.046, 0.031> <0.236, 0.046, 0.027> <0.239, 0.047, 0.016> <0.240, 0.047, 0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.246, 0.050, 0.010> <0.248, 0.050, 0.005> <0.252, 0.050, -0.002> <0.256, 0.050, -0.007> 
		<0.246, 0.048, 0.011> <0.248, 0.048, 0.005> <0.252, 0.048, -0.002> <0.256, 0.048, -0.007> 
		<0.240, 0.049, 0.010> <0.242, 0.049, 0.003> <0.248, 0.049, -0.005> <0.252, 0.049, -0.010> 
		<0.240, 0.047, 0.010> <0.242, 0.047, 0.003> <0.247, 0.047, -0.005> <0.252, 0.047, -0.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.256, 0.050, -0.007> <0.259, 0.050, -0.010> <0.264, 0.050, -0.014> <0.268, 0.050, -0.015> 
		<0.256, 0.048, -0.007> <0.259, 0.048, -0.010> <0.263, 0.048, -0.014> <0.268, 0.048, -0.014> 
		<0.252, 0.049, -0.010> <0.256, 0.049, -0.014> <0.262, 0.048, -0.019> <0.267, 0.048, -0.019> 
		<0.252, 0.047, -0.010> <0.256, 0.047, -0.014> <0.262, 0.046, -0.019> <0.267, 0.046, -0.019> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.268, 0.050, -0.015> <0.273, 0.049, -0.015> <0.279, 0.049, -0.011> <0.282, 0.049, -0.008> 
		<0.268, 0.048, -0.014> <0.272, 0.047, -0.015> <0.278, 0.047, -0.011> <0.282, 0.047, -0.008> 
		<0.267, 0.048, -0.019> <0.273, 0.048, -0.019> <0.281, 0.047, -0.015> <0.286, 0.047, -0.011> 
		<0.267, 0.046, -0.019> <0.273, 0.046, -0.019> <0.281, 0.045, -0.015> <0.285, 0.045, -0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.293, 0.045, 0.032> <0.288, 0.046, 0.038> <0.278, 0.046, 0.041> <0.270, 0.046, 0.041> 
		<0.292, 0.043, 0.032> <0.287, 0.043, 0.038> <0.277, 0.044, 0.041> <0.270, 0.044, 0.040> 
		<0.288, 0.043, 0.030> <0.284, 0.043, 0.034> <0.275, 0.043, 0.037> <0.269, 0.043, 0.037> 
		<0.286, 0.042, 0.029> <0.282, 0.042, 0.033> <0.274, 0.042, 0.036> <0.269, 0.042, 0.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.270, 0.046, 0.041> <0.261, 0.046, 0.040> <0.247, 0.046, 0.038> <0.241, 0.046, 0.031> 
		<0.270, 0.044, 0.040> <0.261, 0.044, 0.040> <0.249, 0.044, 0.038> <0.242, 0.044, 0.031> 
		<0.269, 0.043, 0.037> <0.263, 0.043, 0.037> <0.251, 0.043, 0.034> <0.246, 0.044, 0.029> 
		<0.269, 0.042, 0.036> <0.262, 0.042, 0.035> <0.253, 0.042, 0.033> <0.249, 0.042, 0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.241, 0.046, 0.031> <0.236, 0.046, 0.027> <0.239, 0.047, 0.016> <0.240, 0.047, 0.010> 
		<0.242, 0.044, 0.031> <0.238, 0.044, 0.027> <0.239, 0.044, 0.016> <0.241, 0.044, 0.010> 
		<0.246, 0.044, 0.029> <0.243, 0.044, 0.025> <0.244, 0.044, 0.016> <0.245, 0.044, 0.011> 
		<0.249, 0.042, 0.028> <0.245, 0.043, 0.024> <0.246, 0.043, 0.016> <0.247, 0.043, 0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.240, 0.047, 0.010> <0.242, 0.047, 0.003> <0.247, 0.047, -0.005> <0.252, 0.047, -0.010> 
		<0.241, 0.044, 0.010> <0.242, 0.045, 0.004> <0.247, 0.045, -0.005> <0.252, 0.045, -0.010> 
		<0.245, 0.044, 0.011> <0.246, 0.044, 0.005> <0.251, 0.044, -0.003> <0.254, 0.044, -0.008> 
		<0.247, 0.043, 0.011> <0.248, 0.043, 0.005> <0.252, 0.043, -0.002> <0.255, 0.043, -0.007> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.252, 0.047, -0.010> <0.256, 0.047, -0.014> <0.262, 0.046, -0.019> <0.267, 0.046, -0.019> 
		<0.252, 0.045, -0.010> <0.255, 0.045, -0.014> <0.262, 0.045, -0.019> <0.267, 0.044, -0.019> 
		<0.254, 0.044, -0.008> <0.257, 0.044, -0.011> <0.263, 0.044, -0.016> <0.267, 0.043, -0.016> 
		<0.255, 0.043, -0.007> <0.258, 0.043, -0.010> <0.262, 0.043, -0.014> <0.266, 0.042, -0.014> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.267, 0.046, -0.019> <0.273, 0.046, -0.019> <0.281, 0.045, -0.015> <0.285, 0.045, -0.011> 
		<0.267, 0.044, -0.019> <0.273, 0.044, -0.019> <0.280, 0.043, -0.015> <0.284, 0.043, -0.011> 
		<0.267, 0.043, -0.016> <0.271, 0.043, -0.016> <0.278, 0.043, -0.012> <0.281, 0.042, -0.009> 
		<0.266, 0.042, -0.014> <0.271, 0.042, -0.014> <0.277, 0.041, -0.011> <0.280, 0.041, -0.007> 
	}
	texture { T_Layer4 }
	scale MeshScale
}
// Layer 5
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.002, 0.756, 0.055> <0.002, 0.756, 0.055> <0.002, 0.756, 0.055> <0.002, 0.756, 0.055> 
		<0.013, 0.754, 0.054> <0.013, 0.754, 0.054> <0.010, 0.756, 0.048> <0.010, 0.756, 0.048> 
		<0.030, 0.755, 0.054> <0.031, 0.757, 0.047> <0.028, 0.757, 0.043> <0.023, 0.758, 0.038> 
		<0.040, 0.748, 0.051> <0.040, 0.751, 0.044> <0.034, 0.753, 0.035> <0.029, 0.754, 0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.002, 0.756, 0.055> <0.013, 0.754, 0.054> <0.030, 0.755, 0.054> <0.040, 0.748, 0.051> 
		<0.002, 0.756, 0.055> <0.013, 0.754, 0.054> <0.030, 0.752, 0.062> <0.039, 0.746, 0.059> 
		<0.002, 0.756, 0.055> <0.009, 0.751, 0.061> <0.026, 0.750, 0.066> <0.032, 0.742, 0.069> 
		<0.002, 0.756, 0.055> <0.009, 0.751, 0.061> <0.020, 0.748, 0.071> <0.026, 0.740, 0.074> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.095, 0.665, 0.015> <0.096, 0.674, -0.004> <0.083, 0.686, -0.031> <0.069, 0.692, -0.045> 
		<0.093, 0.674, 0.019> <0.094, 0.683, -0.000> <0.082, 0.694, -0.027> <0.067, 0.700, -0.040> 
		<0.082, 0.688, 0.025> <0.082, 0.696, 0.007> <0.073, 0.705, -0.015> <0.059, 0.711, -0.028> 
		<0.089, 0.694, 0.028> <0.089, 0.703, 0.009> <0.078, 0.713, -0.017> <0.063, 0.719, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.095, 0.665, 0.015> <0.093, 0.674, 0.019> <0.082, 0.688, 0.025> <0.089, 0.694, 0.028> 
		<0.095, 0.656, 0.035> <0.093, 0.665, 0.038> <0.082, 0.679, 0.043> <0.089, 0.686, 0.046> 
		<0.083, 0.642, 0.061> <0.082, 0.651, 0.064> <0.075, 0.667, 0.063> <0.078, 0.672, 0.071> 
		<0.067, 0.636, 0.075> <0.066, 0.645, 0.078> <0.060, 0.661, 0.076> <0.064, 0.666, 0.084> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.089, 0.654, 0.010> <0.089, 0.662, -0.007> <0.078, 0.672, -0.033> <0.064, 0.678, -0.046> 
		<0.079, 0.667, 0.017> <0.079, 0.676, -0.001> <0.070, 0.683, -0.020> <0.057, 0.688, -0.033> 
		<0.083, 0.691, 0.028> <0.082, 0.699, 0.013> <0.072, 0.711, -0.016> <0.060, 0.716, -0.027> 
		<0.075, 0.706, 0.035> <0.075, 0.714, 0.019> <0.066, 0.723, -0.004> <0.054, 0.728, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.089, 0.654, 0.010> <0.079, 0.667, 0.017> <0.083, 0.691, 0.028> <0.075, 0.706, 0.035> 
		<0.089, 0.645, 0.028> <0.079, 0.658, 0.035> <0.083, 0.684, 0.043> <0.075, 0.699, 0.050> 
		<0.078, 0.630, 0.051> <0.072, 0.647, 0.050> <0.073, 0.668, 0.067> <0.068, 0.685, 0.069> 
		<0.064, 0.624, 0.064> <0.058, 0.641, 0.063> <0.062, 0.664, 0.078> <0.056, 0.680, 0.079> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.089, 0.654, 0.010> <0.093, 0.649, 0.008> <0.102, 0.665, 0.014> <0.102, 0.671, 0.017> 
		<0.089, 0.662, -0.007> <0.093, 0.657, -0.010> <0.102, 0.674, -0.006> <0.102, 0.681, -0.004> 
		<0.078, 0.672, -0.033> <0.081, 0.668, -0.038> <0.090, 0.686, -0.035> <0.090, 0.693, -0.033> 
		<0.064, 0.678, -0.046> <0.067, 0.673, -0.051> <0.073, 0.693, -0.050> <0.073, 0.700, -0.048> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.089, 0.654, 0.010> <0.089, 0.645, 0.028> <0.078, 0.630, 0.051> <0.064, 0.624, 0.064> 
		<0.093, 0.649, 0.008> <0.093, 0.640, 0.026> <0.080, 0.623, 0.051> <0.066, 0.617, 0.064> 
		<0.102, 0.665, 0.014> <0.101, 0.655, 0.036> <0.087, 0.640, 0.063> <0.070, 0.633, 0.079> 
		<0.102, 0.671, 0.017> <0.101, 0.661, 0.038> <0.087, 0.647, 0.067> <0.071, 0.640, 0.082> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.075, 0.706, 0.035> <0.068, 0.721, 0.041> <0.053, 0.739, 0.047> <0.040, 0.748, 0.051> 
		<0.075, 0.714, 0.019> <0.067, 0.728, 0.025> <0.054, 0.741, 0.040> <0.040, 0.751, 0.044> 
		<0.066, 0.723, -0.004> <0.061, 0.735, 0.008> <0.044, 0.748, 0.021> <0.034, 0.753, 0.035> 
		<0.054, 0.728, -0.015> <0.049, 0.740, -0.004> <0.039, 0.749, 0.017> <0.029, 0.754, 0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.075, 0.706, 0.035> <0.068, 0.721, 0.041> <0.053, 0.739, 0.047> <0.040, 0.748, 0.051> 
		<0.075, 0.699, 0.050> <0.068, 0.713, 0.056> <0.053, 0.736, 0.055> <0.039, 0.746, 0.059> 
		<0.068, 0.685, 0.069> <0.062, 0.704, 0.070> <0.044, 0.726, 0.074> <0.032, 0.742, 0.069> 
		<0.056, 0.680, 0.079> <0.050, 0.699, 0.081> <0.038, 0.724, 0.079> <0.026, 0.740, 0.074> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.102, 0.671, 0.017> <0.102, 0.679, 0.020> <0.095, 0.700, 0.030> <0.089, 0.694, 0.028> 
		<0.102, 0.681, -0.004> <0.102, 0.689, -0.000> <0.095, 0.708, 0.011> <0.089, 0.703, 0.009> 
		<0.090, 0.693, -0.033> <0.090, 0.701, -0.030> <0.082, 0.719, -0.020> <0.078, 0.713, -0.017> 
		<0.073, 0.700, -0.048> <0.073, 0.708, -0.045> <0.067, 0.725, -0.033> <0.063, 0.719, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.102, 0.671, 0.017> <0.101, 0.661, 0.038> <0.087, 0.647, 0.067> <0.071, 0.640, 0.082> 
		<0.102, 0.679, 0.020> <0.101, 0.669, 0.042> <0.087, 0.654, 0.070> <0.071, 0.647, 0.085> 
		<0.095, 0.700, 0.030> <0.095, 0.691, 0.048> <0.081, 0.676, 0.077> <0.067, 0.670, 0.090> 
		<0.089, 0.694, 0.028> <0.089, 0.686, 0.046> <0.078, 0.672, 0.071> <0.064, 0.666, 0.084> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.002, 0.756, 0.055> <0.009, 0.751, 0.061> <0.020, 0.748, 0.071> <0.026, 0.740, 0.074> 
		<0.002, 0.756, 0.055> <0.009, 0.751, 0.061> <0.014, 0.746, 0.077> <0.020, 0.738, 0.079> 
		<0.002, 0.756, 0.055> <0.001, 0.750, 0.064> <0.009, 0.745, 0.080> <0.009, 0.735, 0.085> 
		<0.002, 0.756, 0.055> <0.001, 0.750, 0.064> <0.000, 0.744, 0.080> <0.001, 0.734, 0.085> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.002, 0.756, 0.055> <0.001, 0.750, 0.064> <0.000, 0.744, 0.080> <0.001, 0.734, 0.085> 
		<0.002, 0.756, 0.055> <0.001, 0.750, 0.064> <-0.009, 0.743, 0.080> <-0.009, 0.734, 0.086> 
		<0.002, 0.756, 0.055> <-0.007, 0.750, 0.061> <-0.014, 0.743, 0.077> <-0.021, 0.733, 0.081> 
		<0.002, 0.756, 0.055> <-0.007, 0.750, 0.061> <-0.021, 0.744, 0.071> <-0.028, 0.735, 0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.002, 0.756, 0.055> <-0.007, 0.750, 0.061> <-0.021, 0.744, 0.071> <-0.028, 0.735, 0.075> 
		<0.002, 0.756, 0.055> <-0.007, 0.750, 0.061> <-0.027, 0.745, 0.066> <-0.034, 0.736, 0.069> 
		<0.002, 0.756, 0.055> <-0.011, 0.752, 0.054> <-0.029, 0.746, 0.061> <-0.039, 0.739, 0.058> 
		<0.002, 0.756, 0.055> <-0.011, 0.752, 0.054> <-0.029, 0.750, 0.053> <-0.040, 0.742, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.002, 0.756, 0.055> <-0.011, 0.752, 0.054> <-0.029, 0.750, 0.053> <-0.040, 0.742, 0.050> 
		<0.002, 0.756, 0.055> <-0.011, 0.752, 0.054> <-0.029, 0.753, 0.045> <-0.040, 0.746, 0.042> 
		<0.002, 0.756, 0.055> <-0.007, 0.756, 0.047> <-0.027, 0.755, 0.042> <-0.035, 0.752, 0.032> 
		<0.002, 0.756, 0.055> <-0.007, 0.756, 0.047> <-0.021, 0.758, 0.036> <-0.029, 0.754, 0.027> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.002, 0.756, 0.055> <-0.007, 0.756, 0.047> <-0.021, 0.758, 0.036> <-0.029, 0.754, 0.027> 
		<0.002, 0.756, 0.055> <-0.007, 0.756, 0.047> <-0.015, 0.760, 0.030> <-0.022, 0.757, 0.021> 
		<0.002, 0.756, 0.055> <0.001, 0.757, 0.043> <-0.009, 0.760, 0.027> <-0.009, 0.757, 0.015> 
		<0.002, 0.756, 0.055> <0.001, 0.757, 0.043> <0.000, 0.760, 0.027> <-0.000, 0.757, 0.016> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.002, 0.756, 0.055> <0.001, 0.757, 0.043> <0.000, 0.760, 0.027> <-0.000, 0.757, 0.016> 
		<0.002, 0.756, 0.055> <0.001, 0.757, 0.043> <0.010, 0.760, 0.028> <0.010, 0.757, 0.016> 
		<0.002, 0.756, 0.055> <0.010, 0.756, 0.048> <0.015, 0.759, 0.032> <0.022, 0.756, 0.024> 
		<0.002, 0.756, 0.055> <0.010, 0.756, 0.048> <0.023, 0.758, 0.038> <0.029, 0.754, 0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.026, 0.740, 0.074> <0.038, 0.724, 0.079> <0.050, 0.699, 0.081> <0.056, 0.680, 0.079> 
		<0.020, 0.738, 0.079> <0.031, 0.722, 0.084> <0.038, 0.695, 0.093> <0.044, 0.676, 0.091> 
		<0.009, 0.735, 0.085> <0.009, 0.721, 0.094> <0.020, 0.696, 0.101> <0.020, 0.679, 0.101> 
		<0.001, 0.734, 0.085> <0.001, 0.720, 0.094> <0.003, 0.697, 0.101> <0.003, 0.679, 0.102> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, 0.734, 0.085> <0.001, 0.720, 0.094> <0.003, 0.697, 0.101> <0.003, 0.679, 0.102> 
		<-0.009, 0.734, 0.086> <-0.008, 0.719, 0.095> <-0.015, 0.697, 0.102> <-0.016, 0.680, 0.103> 
		<-0.021, 0.733, 0.081> <-0.032, 0.720, 0.086> <-0.036, 0.697, 0.095> <-0.042, 0.680, 0.095> 
		<-0.028, 0.735, 0.075> <-0.039, 0.722, 0.080> <-0.050, 0.701, 0.084> <-0.056, 0.684, 0.083> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.028, 0.735, 0.075> <-0.039, 0.722, 0.080> <-0.050, 0.701, 0.084> <-0.056, 0.684, 0.083> 
		<-0.034, 0.736, 0.069> <-0.045, 0.723, 0.074> <-0.062, 0.704, 0.073> <-0.068, 0.688, 0.072> 
		<-0.039, 0.739, 0.058> <-0.053, 0.730, 0.054> <-0.069, 0.710, 0.057> <-0.077, 0.696, 0.050> 
		<-0.040, 0.742, 0.050> <-0.053, 0.733, 0.047> <-0.069, 0.717, 0.041> <-0.077, 0.703, 0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.040, 0.742, 0.050> <-0.053, 0.733, 0.047> <-0.069, 0.717, 0.041> <-0.077, 0.703, 0.035> 
		<-0.040, 0.746, 0.042> <-0.053, 0.736, 0.039> <-0.070, 0.724, 0.024> <-0.077, 0.710, 0.018> 
		<-0.035, 0.752, 0.032> <-0.045, 0.746, 0.019> <-0.064, 0.734, 0.007> <-0.069, 0.722, -0.005> 
		<-0.029, 0.754, 0.027> <-0.039, 0.749, 0.014> <-0.052, 0.739, -0.005> <-0.057, 0.727, -0.017> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.029, 0.754, 0.027> <-0.039, 0.749, 0.014> <-0.052, 0.739, -0.005> <-0.057, 0.727, -0.017> 
		<-0.022, 0.757, 0.021> <-0.033, 0.751, 0.008> <-0.040, 0.744, -0.017> <-0.045, 0.733, -0.029> 
		<-0.009, 0.757, 0.015> <-0.010, 0.753, -0.002> <-0.021, 0.746, -0.026> <-0.021, 0.735, -0.040> 
		<-0.000, 0.757, 0.016> <-0.001, 0.753, -0.002> <-0.004, 0.746, -0.025> <-0.004, 0.735, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 0.757, 0.016> <-0.001, 0.753, -0.002> <-0.004, 0.746, -0.025> <-0.004, 0.735, -0.040> 
		<0.010, 0.757, 0.016> <0.009, 0.754, -0.001> <0.015, 0.746, -0.025> <0.015, 0.735, -0.039> 
		<0.022, 0.756, 0.024> <0.032, 0.751, 0.010> <0.035, 0.745, -0.016> <0.041, 0.733, -0.028> 
		<0.029, 0.754, 0.030> <0.039, 0.749, 0.017> <0.049, 0.740, -0.004> <0.054, 0.728, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.056, 0.680, 0.079> <0.062, 0.664, 0.078> <0.058, 0.641, 0.063> <0.064, 0.624, 0.064> 
		<0.044, 0.676, 0.091> <0.050, 0.659, 0.089> <0.043, 0.635, 0.076> <0.049, 0.618, 0.077> 
		<0.020, 0.679, 0.101> <0.020, 0.660, 0.102> <0.022, 0.636, 0.086> <0.021, 0.617, 0.090> 
		<0.003, 0.679, 0.102> <0.003, 0.660, 0.103> <0.001, 0.636, 0.087> <-0.000, 0.617, 0.091> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.003, 0.679, 0.102> <0.003, 0.660, 0.103> <0.001, 0.636, 0.087> <-0.000, 0.617, 0.091> 
		<-0.016, 0.680, 0.103> <-0.016, 0.661, 0.103> <-0.020, 0.636, 0.088> <-0.021, 0.618, 0.091> 
		<-0.042, 0.680, 0.095> <-0.048, 0.663, 0.094> <-0.044, 0.638, 0.083> <-0.050, 0.621, 0.083> 
		<-0.056, 0.684, 0.083> <-0.061, 0.667, 0.082> <-0.059, 0.643, 0.070> <-0.065, 0.627, 0.069> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.056, 0.684, 0.083> <-0.061, 0.667, 0.082> <-0.059, 0.643, 0.070> <-0.065, 0.627, 0.069> 
		<-0.068, 0.688, 0.072> <-0.074, 0.671, 0.072> <-0.073, 0.649, 0.056> <-0.080, 0.632, 0.056> 
		<-0.077, 0.696, 0.050> <-0.085, 0.682, 0.044> <-0.080, 0.657, 0.035> <-0.089, 0.644, 0.028> 
		<-0.077, 0.703, 0.035> <-0.085, 0.689, 0.028> <-0.079, 0.665, 0.016> <-0.089, 0.653, 0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.077, 0.703, 0.035> <-0.085, 0.689, 0.028> <-0.079, 0.665, 0.016> <-0.089, 0.653, 0.009> 
		<-0.077, 0.710, 0.018> <-0.085, 0.696, 0.012> <-0.079, 0.674, -0.003> <-0.088, 0.662, -0.010> 
		<-0.069, 0.722, -0.005> <-0.074, 0.711, -0.017> <-0.071, 0.685, -0.023> <-0.076, 0.675, -0.036> 
		<-0.057, 0.727, -0.017> <-0.062, 0.716, -0.029> <-0.056, 0.691, -0.037> <-0.061, 0.681, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.057, 0.727, -0.017> <-0.062, 0.716, -0.029> <-0.056, 0.691, -0.037> <-0.061, 0.681, -0.050> 
		<-0.045, 0.733, -0.029> <-0.050, 0.721, -0.041> <-0.042, 0.697, -0.050> <-0.047, 0.687, -0.063> 
		<-0.021, 0.735, -0.040> <-0.021, 0.724, -0.053> <-0.021, 0.699, -0.059> <-0.019, 0.690, -0.074> 
		<-0.004, 0.735, -0.040> <-0.004, 0.725, -0.053> <-0.001, 0.698, -0.059> <0.001, 0.689, -0.073> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.004, 0.735, -0.040> <-0.004, 0.725, -0.053> <-0.001, 0.698, -0.059> <0.001, 0.689, -0.073> 
		<0.015, 0.735, -0.039> <0.015, 0.725, -0.053> <0.020, 0.698, -0.058> <0.022, 0.688, -0.072> 
		<0.041, 0.733, -0.028> <0.046, 0.721, -0.040> <0.042, 0.694, -0.047> <0.049, 0.684, -0.059> 
		<0.054, 0.728, -0.015> <0.060, 0.716, -0.027> <0.057, 0.688, -0.033> <0.064, 0.678, -0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.064, 0.624, 0.064> <0.066, 0.617, 0.064> <0.070, 0.633, 0.079> <0.071, 0.640, 0.082> 
		<0.049, 0.618, 0.077> <0.051, 0.611, 0.078> <0.054, 0.627, 0.093> <0.054, 0.633, 0.097> 
		<0.021, 0.617, 0.090> <0.020, 0.610, 0.091> <0.023, 0.623, 0.108> <0.023, 0.629, 0.111> 
		<-0.000, 0.617, 0.091> <-0.001, 0.610, 0.092> <0.000, 0.623, 0.108> <0.000, 0.630, 0.111> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 0.617, 0.091> <-0.001, 0.610, 0.092> <0.000, 0.623, 0.108> <0.000, 0.630, 0.111> 
		<-0.021, 0.618, 0.091> <-0.021, 0.611, 0.093> <-0.023, 0.624, 0.108> <-0.023, 0.630, 0.111> 
		<-0.050, 0.621, 0.083> <-0.053, 0.615, 0.083> <-0.055, 0.629, 0.095> <-0.055, 0.635, 0.097> 
		<-0.065, 0.627, 0.069> <-0.067, 0.621, 0.069> <-0.072, 0.636, 0.080> <-0.072, 0.642, 0.082> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.065, 0.627, 0.069> <-0.067, 0.621, 0.069> <-0.072, 0.636, 0.080> <-0.072, 0.642, 0.082> 
		<-0.080, 0.632, 0.056> <-0.082, 0.627, 0.056> <-0.088, 0.643, 0.065> <-0.088, 0.648, 0.067> 
		<-0.089, 0.644, 0.028> <-0.093, 0.639, 0.025> <-0.102, 0.655, 0.035> <-0.102, 0.661, 0.038> 
		<-0.089, 0.653, 0.009> <-0.093, 0.648, 0.006> <-0.102, 0.664, 0.014> <-0.102, 0.671, 0.017> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.089, 0.653, 0.009> <-0.093, 0.648, 0.006> <-0.102, 0.664, 0.014> <-0.102, 0.671, 0.017> 
		<-0.088, 0.662, -0.010> <-0.092, 0.657, -0.013> <-0.102, 0.675, -0.008> <-0.102, 0.681, -0.005> 
		<-0.076, 0.675, -0.036> <-0.078, 0.671, -0.041> <-0.086, 0.690, -0.037> <-0.087, 0.697, -0.034> 
		<-0.061, 0.681, -0.050> <-0.063, 0.677, -0.055> <-0.069, 0.697, -0.053> <-0.070, 0.704, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.061, 0.681, -0.050> <-0.063, 0.677, -0.055> <-0.069, 0.697, -0.053> <-0.070, 0.704, -0.050> 
		<-0.047, 0.687, -0.063> <-0.049, 0.683, -0.068> <-0.053, 0.704, -0.068> <-0.054, 0.710, -0.064> 
		<-0.019, 0.690, -0.074> <-0.019, 0.686, -0.079> <-0.022, 0.707, -0.079> <-0.023, 0.713, -0.076> 
		<0.001, 0.689, -0.073> <0.001, 0.685, -0.079> <0.000, 0.706, -0.078> <-0.000, 0.712, -0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, 0.689, -0.073> <0.001, 0.685, -0.079> <0.000, 0.706, -0.078> <-0.000, 0.712, -0.075> 
		<0.022, 0.688, -0.072> <0.022, 0.685, -0.078> <0.024, 0.705, -0.078> <0.024, 0.712, -0.075> 
		<0.049, 0.684, -0.059> <0.052, 0.679, -0.064> <0.057, 0.700, -0.066> <0.056, 0.707, -0.063> 
		<0.064, 0.678, -0.046> <0.067, 0.673, -0.051> <0.073, 0.693, -0.050> <0.073, 0.700, -0.048> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.071, 0.640, 0.082> <0.071, 0.647, 0.085> <0.067, 0.670, 0.090> <0.064, 0.666, 0.084> 
		<0.054, 0.633, 0.097> <0.054, 0.641, 0.100> <0.052, 0.664, 0.104> <0.049, 0.660, 0.097> 
		<0.023, 0.629, 0.111> <0.023, 0.637, 0.114> <0.021, 0.659, 0.118> <0.021, 0.657, 0.109> 
		<0.000, 0.630, 0.111> <0.000, 0.637, 0.114> <0.000, 0.659, 0.118> <-0.001, 0.658, 0.110> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.630, 0.111> <0.000, 0.637, 0.114> <0.000, 0.659, 0.118> <-0.001, 0.658, 0.110> 
		<-0.023, 0.630, 0.111> <-0.023, 0.638, 0.114> <-0.020, 0.660, 0.118> <-0.021, 0.658, 0.110> 
		<-0.055, 0.635, 0.097> <-0.055, 0.643, 0.101> <-0.052, 0.669, 0.105> <-0.048, 0.664, 0.099> 
		<-0.072, 0.642, 0.082> <-0.071, 0.650, 0.085> <-0.066, 0.675, 0.092> <-0.063, 0.670, 0.086> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.072, 0.642, 0.082> <-0.071, 0.650, 0.085> <-0.066, 0.675, 0.092> <-0.063, 0.670, 0.086> 
		<-0.088, 0.648, 0.067> <-0.088, 0.657, 0.070> <-0.081, 0.681, 0.078> <-0.077, 0.676, 0.072> 
		<-0.102, 0.661, 0.038> <-0.102, 0.669, 0.041> <-0.094, 0.691, 0.048> <-0.088, 0.686, 0.046> 
		<-0.102, 0.671, 0.017> <-0.102, 0.679, 0.020> <-0.095, 0.699, 0.030> <-0.089, 0.694, 0.027> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.102, 0.671, 0.017> <-0.102, 0.679, 0.020> <-0.095, 0.699, 0.030> <-0.089, 0.694, 0.027> 
		<-0.102, 0.681, -0.005> <-0.101, 0.689, -0.002> <-0.095, 0.707, 0.011> <-0.089, 0.702, 0.009> 
		<-0.087, 0.697, -0.034> <-0.088, 0.703, -0.031> <-0.085, 0.719, -0.018> <-0.080, 0.713, -0.017> 
		<-0.070, 0.704, -0.050> <-0.071, 0.710, -0.046> <-0.071, 0.725, -0.030> <-0.066, 0.719, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.070, 0.704, -0.050> <-0.071, 0.710, -0.046> <-0.071, 0.725, -0.030> <-0.066, 0.719, -0.030> 
		<-0.054, 0.710, -0.064> <-0.055, 0.717, -0.061> <-0.056, 0.731, -0.044> <-0.051, 0.725, -0.044> 
		<-0.023, 0.713, -0.076> <-0.023, 0.721, -0.072> <-0.022, 0.739, -0.057> <-0.021, 0.731, -0.053> 
		<-0.000, 0.712, -0.075> <-0.000, 0.720, -0.072> <-0.001, 0.739, -0.057> <0.000, 0.731, -0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 0.712, -0.075> <-0.000, 0.720, -0.072> <-0.001, 0.739, -0.057> <0.000, 0.731, -0.053> 
		<0.024, 0.712, -0.075> <0.024, 0.719, -0.071> <0.020, 0.739, -0.057> <0.021, 0.731, -0.053> 
		<0.056, 0.707, -0.063> <0.056, 0.714, -0.060> <0.053, 0.731, -0.046> <0.049, 0.725, -0.044> 
		<0.073, 0.700, -0.048> <0.073, 0.708, -0.045> <0.067, 0.725, -0.033> <0.063, 0.719, -0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.064, 0.666, 0.084> <0.060, 0.661, 0.076> <0.066, 0.645, 0.078> <0.067, 0.636, 0.075> 
		<0.049, 0.660, 0.097> <0.046, 0.655, 0.090> <0.051, 0.639, 0.092> <0.052, 0.630, 0.089> 
		<0.021, 0.657, 0.109> <0.020, 0.655, 0.100> <0.021, 0.636, 0.104> <0.021, 0.627, 0.101> 
		<-0.001, 0.658, 0.110> <-0.001, 0.656, 0.101> <-0.001, 0.637, 0.104> <-0.001, 0.628, 0.102> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.001, 0.658, 0.110> <-0.001, 0.656, 0.101> <-0.001, 0.637, 0.104> <-0.001, 0.628, 0.102> 
		<-0.021, 0.658, 0.110> <-0.022, 0.656, 0.101> <-0.022, 0.637, 0.104> <-0.022, 0.628, 0.102> 
		<-0.048, 0.664, 0.099> <-0.044, 0.658, 0.092> <-0.051, 0.641, 0.093> <-0.053, 0.631, 0.091> 
		<-0.063, 0.670, 0.086> <-0.058, 0.664, 0.078> <-0.067, 0.647, 0.079> <-0.068, 0.637, 0.077> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.063, 0.670, 0.086> <-0.058, 0.664, 0.078> <-0.067, 0.647, 0.079> <-0.068, 0.637, 0.077> 
		<-0.077, 0.676, 0.072> <-0.073, 0.669, 0.065> <-0.082, 0.653, 0.065> <-0.084, 0.643, 0.062> 
		<-0.088, 0.686, 0.046> <-0.081, 0.680, 0.043> <-0.094, 0.664, 0.038> <-0.096, 0.656, 0.034> 
		<-0.089, 0.694, 0.027> <-0.082, 0.688, 0.025> <-0.093, 0.674, 0.018> <-0.095, 0.665, 0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.089, 0.694, 0.027> <-0.082, 0.688, 0.025> <-0.093, 0.674, 0.018> <-0.095, 0.665, 0.015> 
		<-0.089, 0.702, 0.009> <-0.082, 0.696, 0.006> <-0.093, 0.684, -0.003> <-0.095, 0.675, -0.006> 
		<-0.080, 0.713, -0.017> <-0.075, 0.706, -0.017> <-0.082, 0.697, -0.029> <-0.081, 0.690, -0.035> 
		<-0.066, 0.719, -0.030> <-0.061, 0.712, -0.030> <-0.065, 0.703, -0.044> <-0.065, 0.697, -0.049> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.066, 0.719, -0.030> <-0.061, 0.712, -0.030> <-0.065, 0.703, -0.044> <-0.065, 0.697, -0.049> 
		<-0.051, 0.725, -0.044> <-0.046, 0.718, -0.044> <-0.051, 0.709, -0.057> <-0.050, 0.703, -0.063> 
		<-0.021, 0.731, -0.053> <-0.021, 0.722, -0.050> <-0.020, 0.713, -0.067> <-0.020, 0.705, -0.073> 
		<0.000, 0.731, -0.053> <0.001, 0.722, -0.050> <0.000, 0.712, -0.066> <0.001, 0.704, -0.072> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.731, -0.053> <0.001, 0.722, -0.050> <0.000, 0.712, -0.066> <0.001, 0.704, -0.072> 
		<0.021, 0.731, -0.053> <0.021, 0.722, -0.050> <0.023, 0.711, -0.066> <0.023, 0.704, -0.071> 
		<0.049, 0.725, -0.044> <0.044, 0.717, -0.041> <0.051, 0.706, -0.055> <0.053, 0.698, -0.059> 
		<0.063, 0.719, -0.030> <0.059, 0.711, -0.028> <0.067, 0.700, -0.040> <0.069, 0.692, -0.045> 
	}
	texture { T_Layer5 }
	scale MeshScale
}
// Layer 6
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.106, 0.630, 0.015> <-0.106, 0.630, 0.028> <-0.103, 0.630, 0.045> <-0.090, 0.630, 0.045> 
		<-0.106, 0.630, 0.002> <-0.106, 0.630, 0.015> <-0.103, 0.614, 0.045> <-0.090, 0.614, 0.045> 
		<-0.103, 0.630, -0.015> <-0.103, 0.614, -0.015> <-0.090, 0.600, 0.015> <-0.090, 0.600, 0.031> 
		<-0.090, 0.630, -0.015> <-0.090, 0.614, -0.015> <-0.090, 0.600, -0.001> <-0.090, 0.600, 0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.106, 0.630, 0.015> <-0.106, 0.630, 0.015> <-0.106, 0.630, 0.015> <-0.106, 0.630, 0.015> 
		<-0.106, 0.617, 0.015> <-0.106, 0.617, 0.002> <-0.106, 0.617, 0.002> <-0.106, 0.630, 0.002> 
		<-0.103, 0.600, 0.015> <-0.103, 0.600, -0.001> <-0.103, 0.614, -0.015> <-0.103, 0.630, -0.015> 
		<-0.090, 0.600, 0.015> <-0.090, 0.600, -0.001> <-0.090, 0.614, -0.015> <-0.090, 0.630, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.106, 0.630, 0.015> <-0.106, 0.630, 0.002> <-0.103, 0.630, -0.015> <-0.090, 0.630, -0.015> 
		<-0.106, 0.630, 0.028> <-0.106, 0.630, 0.015> <-0.103, 0.646, -0.015> <-0.090, 0.646, -0.015> 
		<-0.103, 0.630, 0.045> <-0.103, 0.646, 0.045> <-0.090, 0.660, 0.015> <-0.090, 0.660, -0.001> 
		<-0.090, 0.630, 0.045> <-0.090, 0.646, 0.045> <-0.090, 0.660, 0.031> <-0.090, 0.660, 0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.106, 0.630, 0.015> <-0.106, 0.630, 0.015> <-0.106, 0.630, 0.015> <-0.106, 0.630, 0.015> 
		<-0.106, 0.643, 0.015> <-0.106, 0.643, 0.002> <-0.106, 0.643, 0.002> <-0.106, 0.630, 0.002> 
		<-0.103, 0.660, 0.015> <-0.103, 0.660, -0.001> <-0.103, 0.646, -0.015> <-0.103, 0.630, -0.015> 
		<-0.090, 0.660, 0.015> <-0.090, 0.660, -0.001> <-0.090, 0.646, -0.015> <-0.090, 0.630, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.106, 0.630, 0.015> <-0.106, 0.630, 0.002> <-0.103, 0.630, -0.015> <-0.090, 0.630, -0.015> 
		<-0.106, 0.643, 0.015> <-0.106, 0.643, 0.002> <-0.090, 0.630, -0.015> <-0.077, 0.630, -0.015> 
		<-0.103, 0.660, 0.015> <-0.090, 0.660, 0.015> <-0.074, 0.643, 0.002> <-0.074, 0.630, 0.002> 
		<-0.090, 0.660, 0.015> <-0.077, 0.660, 0.015> <-0.074, 0.643, 0.015> <-0.074, 0.630, 0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.106, 0.630, 0.015> <-0.106, 0.630, 0.002> <-0.103, 0.630, -0.015> <-0.090, 0.630, -0.015> 
		<-0.106, 0.617, 0.015> <-0.106, 0.617, 0.002> <-0.090, 0.630, -0.015> <-0.077, 0.630, -0.015> 
		<-0.103, 0.600, 0.015> <-0.090, 0.600, 0.015> <-0.074, 0.617, 0.002> <-0.074, 0.630, 0.002> 
		<-0.090, 0.600, 0.015> <-0.077, 0.600, 0.015> <-0.074, 0.617, 0.015> <-0.074, 0.630, 0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.106, 0.630, 0.015> <-0.106, 0.630, 0.015> <-0.106, 0.630, 0.015> <-0.106, 0.630, 0.015> 
		<-0.106, 0.643, 0.015> <-0.106, 0.643, 0.028> <-0.106, 0.643, 0.028> <-0.106, 0.630, 0.028> 
		<-0.103, 0.660, 0.015> <-0.103, 0.660, 0.031> <-0.103, 0.646, 0.045> <-0.103, 0.630, 0.045> 
		<-0.090, 0.660, 0.015> <-0.090, 0.660, 0.031> <-0.090, 0.646, 0.045> <-0.090, 0.630, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.106, 0.630, 0.015> <-0.106, 0.630, 0.015> <-0.106, 0.630, 0.015> <-0.106, 0.630, 0.015> 
		<-0.106, 0.630, 0.028> <-0.106, 0.617, 0.028> <-0.106, 0.617, 0.028> <-0.106, 0.617, 0.015> 
		<-0.103, 0.630, 0.045> <-0.103, 0.614, 0.045> <-0.103, 0.600, 0.031> <-0.103, 0.600, 0.015> 
		<-0.090, 0.630, 0.045> <-0.090, 0.614, 0.045> <-0.090, 0.600, 0.031> <-0.090, 0.600, 0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.106, 0.630, 0.015> <-0.106, 0.643, 0.015> <-0.103, 0.660, 0.015> <-0.090, 0.660, 0.015> 
		<-0.106, 0.630, 0.028> <-0.106, 0.643, 0.028> <-0.090, 0.660, 0.015> <-0.077, 0.660, 0.015> 
		<-0.103, 0.630, 0.045> <-0.090, 0.630, 0.045> <-0.074, 0.643, 0.028> <-0.074, 0.643, 0.015> 
		<-0.090, 0.630, 0.045> <-0.077, 0.630, 0.045> <-0.074, 0.630, 0.028> <-0.074, 0.630, 0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.106, 0.630, 0.015> <-0.106, 0.630, 0.028> <-0.103, 0.630, 0.045> <-0.090, 0.630, 0.045> 
		<-0.106, 0.617, 0.015> <-0.106, 0.617, 0.028> <-0.090, 0.630, 0.045> <-0.077, 0.630, 0.045> 
		<-0.103, 0.600, 0.015> <-0.090, 0.600, 0.015> <-0.074, 0.617, 0.028> <-0.074, 0.630, 0.028> 
		<-0.090, 0.600, 0.015> <-0.077, 0.600, 0.015> <-0.074, 0.617, 0.015> <-0.074, 0.630, 0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.106, 0.630, 0.015> <-0.106, 0.617, 0.015> <-0.103, 0.600, 0.015> <-0.090, 0.600, 0.015> 
		<-0.106, 0.643, 0.015> <-0.106, 0.630, 0.015> <-0.103, 0.600, 0.031> <-0.090, 0.600, 0.031> 
		<-0.103, 0.660, 0.015> <-0.103, 0.660, 0.031> <-0.090, 0.630, 0.045> <-0.090, 0.614, 0.045> 
		<-0.090, 0.660, 0.015> <-0.090, 0.660, 0.031> <-0.090, 0.646, 0.045> <-0.090, 0.630, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.106, 0.630, 0.015> <-0.106, 0.617, 0.015> <-0.103, 0.600, 0.015> <-0.090, 0.600, 0.015> 
		<-0.106, 0.643, 0.015> <-0.106, 0.630, 0.015> <-0.103, 0.600, -0.001> <-0.090, 0.600, -0.001> 
		<-0.103, 0.660, 0.015> <-0.103, 0.660, -0.001> <-0.090, 0.630, -0.015> <-0.090, 0.614, -0.015> 
		<-0.090, 0.660, 0.015> <-0.090, 0.660, -0.001> <-0.090, 0.646, -0.015> <-0.090, 0.630, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.074, 0.630, 0.015> <-0.074, 0.630, 0.028> <-0.077, 0.630, 0.045> <-0.090, 0.630, 0.045> 
		<-0.074, 0.630, 0.002> <-0.074, 0.630, 0.015> <-0.077, 0.646, 0.045> <-0.090, 0.646, 0.045> 
		<-0.077, 0.630, -0.015> <-0.077, 0.646, -0.015> <-0.090, 0.660, 0.015> <-0.090, 0.660, 0.031> 
		<-0.090, 0.630, -0.015> <-0.090, 0.646, -0.015> <-0.090, 0.660, -0.001> <-0.090, 0.660, 0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.074, 0.630, 0.015> <-0.074, 0.630, 0.015> <-0.074, 0.630, 0.015> <-0.074, 0.630, 0.015> 
		<-0.074, 0.643, 0.015> <-0.074, 0.643, 0.028> <-0.074, 0.643, 0.028> <-0.074, 0.630, 0.028> 
		<-0.077, 0.660, 0.015> <-0.077, 0.660, 0.031> <-0.077, 0.646, 0.045> <-0.077, 0.630, 0.045> 
		<-0.090, 0.660, 0.015> <-0.090, 0.660, 0.031> <-0.090, 0.646, 0.045> <-0.090, 0.630, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.074, 0.630, 0.015> <-0.074, 0.630, 0.002> <-0.077, 0.630, -0.015> <-0.090, 0.630, -0.015> 
		<-0.074, 0.630, 0.028> <-0.074, 0.630, 0.015> <-0.077, 0.614, -0.015> <-0.090, 0.614, -0.015> 
		<-0.077, 0.630, 0.045> <-0.077, 0.614, 0.045> <-0.090, 0.600, 0.015> <-0.090, 0.600, -0.001> 
		<-0.090, 0.630, 0.045> <-0.090, 0.614, 0.045> <-0.090, 0.600, 0.031> <-0.090, 0.600, 0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.074, 0.630, 0.015> <-0.074, 0.630, 0.015> <-0.074, 0.630, 0.015> <-0.074, 0.630, 0.015> 
		<-0.074, 0.617, 0.015> <-0.074, 0.617, 0.028> <-0.074, 0.617, 0.028> <-0.074, 0.630, 0.028> 
		<-0.077, 0.600, 0.015> <-0.077, 0.600, 0.031> <-0.077, 0.614, 0.045> <-0.077, 0.630, 0.045> 
		<-0.090, 0.600, 0.015> <-0.090, 0.600, 0.031> <-0.090, 0.614, 0.045> <-0.090, 0.630, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.074, 0.630, 0.015> <-0.074, 0.630, 0.015> <-0.074, 0.630, 0.015> <-0.074, 0.630, 0.015> 
		<-0.074, 0.617, 0.015> <-0.074, 0.617, 0.002> <-0.074, 0.617, 0.002> <-0.074, 0.630, 0.002> 
		<-0.077, 0.600, 0.015> <-0.077, 0.600, -0.001> <-0.077, 0.614, -0.015> <-0.077, 0.630, -0.015> 
		<-0.090, 0.600, 0.015> <-0.090, 0.600, -0.001> <-0.090, 0.614, -0.015> <-0.090, 0.630, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.074, 0.630, 0.015> <-0.074, 0.630, 0.015> <-0.074, 0.630, 0.015> <-0.074, 0.630, 0.015> 
		<-0.074, 0.643, 0.015> <-0.074, 0.643, 0.002> <-0.074, 0.643, 0.002> <-0.074, 0.630, 0.002> 
		<-0.077, 0.660, 0.015> <-0.077, 0.660, -0.001> <-0.077, 0.646, -0.015> <-0.077, 0.630, -0.015> 
		<-0.090, 0.660, 0.015> <-0.090, 0.660, -0.001> <-0.090, 0.646, -0.015> <-0.090, 0.630, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.074, 0.630, 0.015> <-0.074, 0.643, 0.015> <-0.077, 0.660, 0.015> <-0.090, 0.660, 0.015> 
		<-0.074, 0.617, 0.015> <-0.074, 0.630, 0.015> <-0.077, 0.660, -0.001> <-0.090, 0.660, -0.001> 
		<-0.077, 0.600, 0.015> <-0.077, 0.600, -0.001> <-0.090, 0.630, -0.015> <-0.090, 0.646, -0.015> 
		<-0.090, 0.600, 0.015> <-0.090, 0.600, -0.001> <-0.090, 0.614, -0.015> <-0.090, 0.630, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.074, 0.630, 0.015> <-0.074, 0.643, 0.015> <-0.077, 0.660, 0.015> <-0.090, 0.660, 0.015> 
		<-0.074, 0.617, 0.015> <-0.074, 0.630, 0.015> <-0.077, 0.660, 0.031> <-0.090, 0.660, 0.031> 
		<-0.077, 0.600, 0.015> <-0.077, 0.600, 0.031> <-0.090, 0.630, 0.045> <-0.090, 0.646, 0.045> 
		<-0.090, 0.600, 0.015> <-0.090, 0.600, 0.031> <-0.090, 0.614, 0.045> <-0.090, 0.630, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.074, 0.630, 0.015> <0.074, 0.630, 0.028> <0.077, 0.630, 0.045> <0.090, 0.630, 0.045> 
		<0.074, 0.630, 0.002> <0.074, 0.630, 0.015> <0.077, 0.614, 0.045> <0.090, 0.614, 0.045> 
		<0.077, 0.630, -0.015> <0.077, 0.614, -0.015> <0.090, 0.600, 0.015> <0.090, 0.600, 0.031> 
		<0.090, 0.630, -0.015> <0.090, 0.614, -0.015> <0.090, 0.600, -0.001> <0.090, 0.600, 0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.074, 0.630, 0.015> <0.074, 0.630, 0.015> <0.074, 0.630, 0.015> <0.074, 0.630, 0.015> 
		<0.074, 0.617, 0.015> <0.074, 0.617, 0.002> <0.074, 0.617, 0.002> <0.074, 0.630, 0.002> 
		<0.077, 0.600, 0.015> <0.077, 0.600, -0.001> <0.077, 0.614, -0.015> <0.077, 0.630, -0.015> 
		<0.090, 0.600, 0.015> <0.090, 0.600, -0.001> <0.090, 0.614, -0.015> <0.090, 0.630, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.074, 0.630, 0.015> <0.074, 0.630, 0.002> <0.077, 0.630, -0.015> <0.090, 0.630, -0.015> 
		<0.074, 0.630, 0.028> <0.074, 0.630, 0.015> <0.077, 0.646, -0.015> <0.090, 0.646, -0.015> 
		<0.077, 0.630, 0.045> <0.077, 0.646, 0.045> <0.090, 0.660, 0.015> <0.090, 0.660, -0.001> 
		<0.090, 0.630, 0.045> <0.090, 0.646, 0.045> <0.090, 0.660, 0.031> <0.090, 0.660, 0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.074, 0.630, 0.015> <0.074, 0.630, 0.015> <0.074, 0.630, 0.015> <0.074, 0.630, 0.015> 
		<0.074, 0.643, 0.015> <0.074, 0.643, 0.002> <0.074, 0.643, 0.002> <0.074, 0.630, 0.002> 
		<0.077, 0.660, 0.015> <0.077, 0.660, -0.001> <0.077, 0.646, -0.015> <0.077, 0.630, -0.015> 
		<0.090, 0.660, 0.015> <0.090, 0.660, -0.001> <0.090, 0.646, -0.015> <0.090, 0.630, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.074, 0.630, 0.015> <0.074, 0.630, 0.002> <0.077, 0.630, -0.015> <0.090, 0.630, -0.015> 
		<0.074, 0.643, 0.015> <0.074, 0.643, 0.002> <0.090, 0.630, -0.015> <0.103, 0.630, -0.015> 
		<0.077, 0.660, 0.015> <0.090, 0.660, 0.015> <0.106, 0.643, 0.002> <0.106, 0.630, 0.002> 
		<0.090, 0.660, 0.015> <0.103, 0.660, 0.015> <0.106, 0.643, 0.015> <0.106, 0.630, 0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.074, 0.630, 0.015> <0.074, 0.630, 0.002> <0.077, 0.630, -0.015> <0.090, 0.630, -0.015> 
		<0.074, 0.617, 0.015> <0.074, 0.617, 0.002> <0.090, 0.630, -0.015> <0.103, 0.630, -0.015> 
		<0.077, 0.600, 0.015> <0.090, 0.600, 0.015> <0.106, 0.617, 0.002> <0.106, 0.630, 0.002> 
		<0.090, 0.600, 0.015> <0.103, 0.600, 0.015> <0.106, 0.617, 0.015> <0.106, 0.630, 0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.074, 0.630, 0.015> <0.074, 0.630, 0.015> <0.074, 0.630, 0.015> <0.074, 0.630, 0.015> 
		<0.074, 0.643, 0.015> <0.074, 0.643, 0.028> <0.074, 0.643, 0.028> <0.074, 0.630, 0.028> 
		<0.077, 0.660, 0.015> <0.077, 0.660, 0.031> <0.077, 0.646, 0.045> <0.077, 0.630, 0.045> 
		<0.090, 0.660, 0.015> <0.090, 0.660, 0.031> <0.090, 0.646, 0.045> <0.090, 0.630, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.074, 0.630, 0.015> <0.074, 0.630, 0.015> <0.074, 0.630, 0.015> <0.074, 0.630, 0.015> 
		<0.074, 0.630, 0.028> <0.074, 0.617, 0.028> <0.074, 0.617, 0.028> <0.074, 0.617, 0.015> 
		<0.077, 0.630, 0.045> <0.077, 0.614, 0.045> <0.077, 0.600, 0.031> <0.077, 0.600, 0.015> 
		<0.090, 0.630, 0.045> <0.090, 0.614, 0.045> <0.090, 0.600, 0.031> <0.090, 0.600, 0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.074, 0.630, 0.015> <0.074, 0.643, 0.015> <0.077, 0.660, 0.015> <0.090, 0.660, 0.015> 
		<0.074, 0.630, 0.028> <0.074, 0.643, 0.028> <0.090, 0.660, 0.015> <0.103, 0.660, 0.015> 
		<0.077, 0.630, 0.045> <0.090, 0.630, 0.045> <0.106, 0.643, 0.028> <0.106, 0.643, 0.015> 
		<0.090, 0.630, 0.045> <0.103, 0.630, 0.045> <0.106, 0.630, 0.028> <0.106, 0.630, 0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.074, 0.630, 0.015> <0.074, 0.630, 0.028> <0.077, 0.630, 0.045> <0.090, 0.630, 0.045> 
		<0.074, 0.617, 0.015> <0.074, 0.617, 0.028> <0.090, 0.630, 0.045> <0.103, 0.630, 0.045> 
		<0.077, 0.600, 0.015> <0.090, 0.600, 0.015> <0.106, 0.617, 0.028> <0.106, 0.630, 0.028> 
		<0.090, 0.600, 0.015> <0.103, 0.600, 0.015> <0.106, 0.617, 0.015> <0.106, 0.630, 0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.074, 0.630, 0.015> <0.074, 0.617, 0.015> <0.077, 0.600, 0.015> <0.090, 0.600, 0.015> 
		<0.074, 0.643, 0.015> <0.074, 0.630, 0.015> <0.077, 0.600, 0.031> <0.090, 0.600, 0.031> 
		<0.077, 0.660, 0.015> <0.077, 0.660, 0.031> <0.090, 0.630, 0.045> <0.090, 0.614, 0.045> 
		<0.090, 0.660, 0.015> <0.090, 0.660, 0.031> <0.090, 0.646, 0.045> <0.090, 0.630, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.074, 0.630, 0.015> <0.074, 0.617, 0.015> <0.077, 0.600, 0.015> <0.090, 0.600, 0.015> 
		<0.074, 0.643, 0.015> <0.074, 0.630, 0.015> <0.077, 0.600, -0.001> <0.090, 0.600, -0.001> 
		<0.077, 0.660, 0.015> <0.077, 0.660, -0.001> <0.090, 0.630, -0.015> <0.090, 0.614, -0.015> 
		<0.090, 0.660, 0.015> <0.090, 0.660, -0.001> <0.090, 0.646, -0.015> <0.090, 0.630, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.106, 0.630, 0.015> <0.106, 0.630, 0.028> <0.103, 0.630, 0.045> <0.090, 0.630, 0.045> 
		<0.106, 0.630, 0.002> <0.106, 0.630, 0.015> <0.103, 0.646, 0.045> <0.090, 0.646, 0.045> 
		<0.103, 0.630, -0.015> <0.103, 0.646, -0.015> <0.090, 0.660, 0.015> <0.090, 0.660, 0.031> 
		<0.090, 0.630, -0.015> <0.090, 0.646, -0.015> <0.090, 0.660, -0.001> <0.090, 0.660, 0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.106, 0.630, 0.015> <0.106, 0.630, 0.015> <0.106, 0.630, 0.015> <0.106, 0.630, 0.015> 
		<0.106, 0.643, 0.015> <0.106, 0.643, 0.028> <0.106, 0.643, 0.028> <0.106, 0.630, 0.028> 
		<0.103, 0.660, 0.015> <0.103, 0.660, 0.031> <0.103, 0.646, 0.045> <0.103, 0.630, 0.045> 
		<0.090, 0.660, 0.015> <0.090, 0.660, 0.031> <0.090, 0.646, 0.045> <0.090, 0.630, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.106, 0.630, 0.015> <0.106, 0.630, 0.002> <0.103, 0.630, -0.015> <0.090, 0.630, -0.015> 
		<0.106, 0.630, 0.028> <0.106, 0.630, 0.015> <0.103, 0.614, -0.015> <0.090, 0.614, -0.015> 
		<0.103, 0.630, 0.045> <0.103, 0.614, 0.045> <0.090, 0.600, 0.015> <0.090, 0.600, -0.001> 
		<0.090, 0.630, 0.045> <0.090, 0.614, 0.045> <0.090, 0.600, 0.031> <0.090, 0.600, 0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.106, 0.630, 0.015> <0.106, 0.630, 0.015> <0.106, 0.630, 0.015> <0.106, 0.630, 0.015> 
		<0.106, 0.617, 0.015> <0.106, 0.617, 0.028> <0.106, 0.617, 0.028> <0.106, 0.630, 0.028> 
		<0.103, 0.600, 0.015> <0.103, 0.600, 0.031> <0.103, 0.614, 0.045> <0.103, 0.630, 0.045> 
		<0.090, 0.600, 0.015> <0.090, 0.600, 0.031> <0.090, 0.614, 0.045> <0.090, 0.630, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.106, 0.630, 0.015> <0.106, 0.630, 0.015> <0.106, 0.630, 0.015> <0.106, 0.630, 0.015> 
		<0.106, 0.617, 0.015> <0.106, 0.617, 0.002> <0.106, 0.617, 0.002> <0.106, 0.630, 0.002> 
		<0.103, 0.600, 0.015> <0.103, 0.600, -0.001> <0.103, 0.614, -0.015> <0.103, 0.630, -0.015> 
		<0.090, 0.600, 0.015> <0.090, 0.600, -0.001> <0.090, 0.614, -0.015> <0.090, 0.630, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.106, 0.630, 0.015> <0.106, 0.630, 0.015> <0.106, 0.630, 0.015> <0.106, 0.630, 0.015> 
		<0.106, 0.643, 0.015> <0.106, 0.643, 0.002> <0.106, 0.643, 0.002> <0.106, 0.630, 0.002> 
		<0.103, 0.660, 0.015> <0.103, 0.660, -0.001> <0.103, 0.646, -0.015> <0.103, 0.630, -0.015> 
		<0.090, 0.660, 0.015> <0.090, 0.660, -0.001> <0.090, 0.646, -0.015> <0.090, 0.630, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.106, 0.630, 0.015> <0.106, 0.643, 0.015> <0.103, 0.660, 0.015> <0.090, 0.660, 0.015> 
		<0.106, 0.617, 0.015> <0.106, 0.630, 0.015> <0.103, 0.660, -0.001> <0.090, 0.660, -0.001> 
		<0.103, 0.600, 0.015> <0.103, 0.600, -0.001> <0.090, 0.630, -0.015> <0.090, 0.646, -0.015> 
		<0.090, 0.600, 0.015> <0.090, 0.600, -0.001> <0.090, 0.614, -0.015> <0.090, 0.630, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.106, 0.630, 0.015> <0.106, 0.643, 0.015> <0.103, 0.660, 0.015> <0.090, 0.660, 0.015> 
		<0.106, 0.617, 0.015> <0.106, 0.630, 0.015> <0.103, 0.660, 0.031> <0.090, 0.660, 0.031> 
		<0.103, 0.600, 0.015> <0.103, 0.600, 0.031> <0.090, 0.630, 0.045> <0.090, 0.646, 0.045> 
		<0.090, 0.600, 0.015> <0.090, 0.600, 0.031> <0.090, 0.614, 0.045> <0.090, 0.630, 0.045> 
	}
	texture { T_Layer6 }
	scale MeshScale
}
// Layer 7
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.680, -0.070> <0.000, 0.680, -0.076> <0.000, 0.682, -0.084> <0.000, 0.680, -0.090> 
		<-0.018, 0.680, -0.070> <-0.018, 0.680, -0.076> <-0.018, 0.682, -0.084> <-0.018, 0.680, -0.090> 
		<-0.043, 0.680, -0.062> <-0.043, 0.680, -0.068> <-0.045, 0.681, -0.077> <-0.043, 0.680, -0.082> 
		<-0.058, 0.673, -0.055> <-0.058, 0.673, -0.061> <-0.060, 0.674, -0.070> <-0.058, 0.673, -0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.680, -0.070> <0.018, 0.680, -0.070> <0.043, 0.680, -0.062> <0.058, 0.673, -0.055> 
		<0.000, 0.680, -0.076> <0.018, 0.680, -0.076> <0.043, 0.680, -0.068> <0.058, 0.673, -0.061> 
		<0.000, 0.682, -0.084> <0.018, 0.682, -0.084> <0.045, 0.681, -0.077> <0.060, 0.674, -0.070> 
		<0.000, 0.680, -0.090> <0.018, 0.680, -0.090> <0.043, 0.680, -0.082> <0.058, 0.673, -0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.058, 0.673, -0.055> <0.067, 0.668, -0.051> <0.076, 0.657, -0.035> <0.076, 0.645, -0.035> 
		<0.058, 0.673, -0.061> <0.067, 0.668, -0.057> <0.076, 0.657, -0.041> <0.076, 0.645, -0.041> 
		<0.060, 0.674, -0.070> <0.070, 0.669, -0.065> <0.080, 0.657, -0.050> <0.080, 0.645, -0.050> 
		<0.058, 0.673, -0.075> <0.067, 0.668, -0.071> <0.076, 0.657, -0.055> <0.076, 0.645, -0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.076, 0.645, -0.035> <0.076, 0.631, -0.035> <0.070, 0.609, -0.049> <0.058, 0.607, -0.055> 
		<0.076, 0.645, -0.041> <0.076, 0.631, -0.041> <0.070, 0.609, -0.055> <0.058, 0.607, -0.061> 
		<0.080, 0.645, -0.050> <0.080, 0.631, -0.050> <0.071, 0.606, -0.064> <0.059, 0.604, -0.070> 
		<0.076, 0.645, -0.055> <0.076, 0.631, -0.055> <0.070, 0.609, -0.069> <0.058, 0.607, -0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.058, 0.607, -0.055> <0.040, 0.605, -0.063> <0.020, 0.635, -0.070> <0.000, 0.635, -0.070> 
		<0.058, 0.607, -0.061> <0.040, 0.605, -0.069> <0.020, 0.635, -0.076> <0.000, 0.635, -0.076> 
		<0.059, 0.604, -0.070> <0.041, 0.602, -0.078> <0.020, 0.633, -0.084> <0.000, 0.633, -0.084> 
		<0.058, 0.607, -0.075> <0.040, 0.605, -0.083> <0.020, 0.635, -0.090> <0.000, 0.635, -0.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.635, -0.070> <-0.020, 0.635, -0.070> <-0.040, 0.605, -0.063> <-0.058, 0.607, -0.055> 
		<0.000, 0.635, -0.076> <-0.020, 0.635, -0.076> <-0.040, 0.605, -0.069> <-0.058, 0.607, -0.061> 
		<0.000, 0.633, -0.084> <-0.020, 0.633, -0.084> <-0.041, 0.602, -0.078> <-0.059, 0.604, -0.070> 
		<0.000, 0.635, -0.090> <-0.020, 0.635, -0.090> <-0.040, 0.605, -0.083> <-0.058, 0.607, -0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.058, 0.607, -0.055> <-0.070, 0.609, -0.049> <-0.076, 0.631, -0.035> <-0.076, 0.645, -0.035> 
		<-0.058, 0.607, -0.061> <-0.070, 0.609, -0.055> <-0.076, 0.631, -0.041> <-0.076, 0.645, -0.041> 
		<-0.059, 0.604, -0.070> <-0.071, 0.606, -0.064> <-0.080, 0.631, -0.050> <-0.080, 0.645, -0.050> 
		<-0.058, 0.607, -0.075> <-0.070, 0.609, -0.069> <-0.076, 0.631, -0.055> <-0.076, 0.645, -0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.076, 0.645, -0.035> <-0.076, 0.657, -0.035> <-0.067, 0.668, -0.051> <-0.058, 0.673, -0.055> 
		<-0.076, 0.645, -0.041> <-0.076, 0.657, -0.041> <-0.067, 0.668, -0.057> <-0.058, 0.673, -0.061> 
		<-0.080, 0.645, -0.050> <-0.080, 0.657, -0.050> <-0.070, 0.669, -0.065> <-0.060, 0.674, -0.070> 
		<-0.076, 0.645, -0.055> <-0.076, 0.657, -0.055> <-0.067, 0.668, -0.071> <-0.058, 0.673, -0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.675, -0.085> <-0.016, 0.675, -0.085> <-0.037, 0.674, -0.077> <-0.050, 0.669, -0.070> 
		<0.000, 0.676, -0.087> <-0.016, 0.676, -0.087> <-0.039, 0.676, -0.078> <-0.052, 0.670, -0.072> 
		<0.000, 0.679, -0.092> <-0.018, 0.679, -0.092> <-0.041, 0.679, -0.085> <-0.056, 0.672, -0.078> 
		<0.000, 0.680, -0.090> <-0.018, 0.680, -0.090> <-0.043, 0.680, -0.082> <-0.058, 0.673, -0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.675, -0.085> <0.000, 0.676, -0.087> <0.000, 0.679, -0.092> <0.000, 0.680, -0.090> 
		<0.016, 0.675, -0.085> <0.016, 0.676, -0.087> <0.018, 0.679, -0.092> <0.018, 0.680, -0.090> 
		<0.037, 0.674, -0.077> <0.039, 0.676, -0.078> <0.041, 0.679, -0.085> <0.043, 0.680, -0.082> 
		<0.050, 0.669, -0.070> <0.052, 0.670, -0.072> <0.056, 0.672, -0.078> <0.058, 0.673, -0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.050, 0.669, -0.070> <0.052, 0.670, -0.072> <0.056, 0.672, -0.078> <0.058, 0.673, -0.075> 
		<0.058, 0.665, -0.065> <0.061, 0.666, -0.067> <0.066, 0.667, -0.073> <0.067, 0.668, -0.071> 
		<0.065, 0.656, -0.050> <0.068, 0.655, -0.052> <0.074, 0.657, -0.058> <0.076, 0.657, -0.055> 
		<0.066, 0.645, -0.050> <0.069, 0.645, -0.052> <0.074, 0.645, -0.058> <0.076, 0.645, -0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.066, 0.645, -0.050> <0.069, 0.645, -0.052> <0.074, 0.645, -0.058> <0.076, 0.645, -0.055> 
		<0.067, 0.634, -0.050> <0.070, 0.634, -0.052> <0.074, 0.631, -0.058> <0.076, 0.631, -0.055> 
		<0.064, 0.619, -0.065> <0.065, 0.616, -0.067> <0.070, 0.611, -0.072> <0.070, 0.609, -0.069> 
		<0.055, 0.618, -0.070> <0.056, 0.615, -0.072> <0.057, 0.609, -0.078> <0.058, 0.607, -0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.055, 0.618, -0.070> <0.056, 0.615, -0.072> <0.057, 0.609, -0.078> <0.058, 0.607, -0.075> 
		<0.039, 0.617, -0.079> <0.039, 0.614, -0.080> <0.039, 0.607, -0.086> <0.040, 0.605, -0.083> 
		<0.018, 0.640, -0.085> <0.018, 0.638, -0.087> <0.020, 0.636, -0.092> <0.020, 0.635, -0.090> 
		<0.000, 0.640, -0.085> <0.000, 0.638, -0.087> <0.000, 0.636, -0.092> <0.000, 0.635, -0.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.640, -0.085> <0.000, 0.638, -0.087> <0.000, 0.636, -0.092> <0.000, 0.635, -0.090> 
		<-0.018, 0.640, -0.085> <-0.018, 0.638, -0.087> <-0.020, 0.636, -0.092> <-0.020, 0.635, -0.090> 
		<-0.039, 0.617, -0.079> <-0.039, 0.614, -0.080> <-0.039, 0.607, -0.086> <-0.040, 0.605, -0.083> 
		<-0.055, 0.618, -0.070> <-0.056, 0.615, -0.072> <-0.057, 0.609, -0.078> <-0.058, 0.607, -0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.055, 0.618, -0.070> <-0.056, 0.615, -0.072> <-0.057, 0.609, -0.078> <-0.058, 0.607, -0.075> 
		<-0.064, 0.619, -0.065> <-0.065, 0.616, -0.067> <-0.070, 0.611, -0.072> <-0.070, 0.609, -0.069> 
		<-0.067, 0.634, -0.050> <-0.070, 0.634, -0.052> <-0.074, 0.631, -0.058> <-0.076, 0.631, -0.055> 
		<-0.066, 0.645, -0.050> <-0.069, 0.645, -0.052> <-0.074, 0.645, -0.058> <-0.076, 0.645, -0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.066, 0.645, -0.050> <-0.069, 0.645, -0.052> <-0.074, 0.645, -0.058> <-0.076, 0.645, -0.055> 
		<-0.065, 0.656, -0.050> <-0.068, 0.655, -0.052> <-0.074, 0.657, -0.058> <-0.076, 0.657, -0.055> 
		<-0.058, 0.665, -0.065> <-0.061, 0.666, -0.067> <-0.066, 0.667, -0.073> <-0.067, 0.668, -0.071> 
		<-0.050, 0.669, -0.070> <-0.052, 0.670, -0.072> <-0.056, 0.672, -0.078> <-0.058, 0.673, -0.075> 
	}
	texture { T_Layer7 }
	scale MeshScale
}
// Layer 8
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.589, 0.058> <0.000, 0.597, 0.063> <0.000, 0.606, 0.073> <0.000, 0.614, 0.075> 
		<-0.013, 0.589, 0.058> <-0.013, 0.597, 0.063> <-0.022, 0.606, 0.073> <-0.022, 0.614, 0.075> 
		<-0.032, 0.590, 0.051> <-0.042, 0.599, 0.056> <-0.055, 0.607, 0.077> <-0.057, 0.620, 0.074> 
		<-0.041, 0.590, 0.041> <-0.050, 0.599, 0.046> <-0.070, 0.606, 0.061> <-0.073, 0.620, 0.058> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.589, 0.058> <0.013, 0.589, 0.058> <0.032, 0.590, 0.051> <0.041, 0.590, 0.041> 
		<0.000, 0.597, 0.063> <0.013, 0.597, 0.063> <0.042, 0.599, 0.056> <0.050, 0.599, 0.046> 
		<0.000, 0.606, 0.073> <0.022, 0.606, 0.073> <0.055, 0.607, 0.077> <0.070, 0.606, 0.061> 
		<0.000, 0.614, 0.075> <0.022, 0.614, 0.075> <0.057, 0.620, 0.074> <0.073, 0.620, 0.058> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.041, 0.590, 0.041> <0.052, 0.590, 0.027> <0.058, 0.590, 0.002> <0.058, 0.590, -0.015> 
		<0.050, 0.599, 0.046> <0.061, 0.599, 0.032> <0.066, 0.596, 0.002> <0.066, 0.596, -0.015> 
		<0.070, 0.606, 0.061> <0.086, 0.605, 0.044> <0.084, 0.606, 0.007> <0.080, 0.602, -0.015> 
		<0.073, 0.620, 0.058> <0.088, 0.619, 0.042> <0.089, 0.616, 0.007> <0.085, 0.612, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.058, 0.590, -0.015> <0.058, 0.590, -0.027> <0.050, 0.590, -0.043> <0.041, 0.590, -0.051> 
		<0.066, 0.596, -0.015> <0.066, 0.597, -0.027> <0.054, 0.592, -0.044> <0.044, 0.593, -0.051> 
		<0.080, 0.602, -0.015> <0.078, 0.599, -0.030> <0.063, 0.596, -0.044> <0.051, 0.595, -0.054> 
		<0.085, 0.612, -0.015> <0.082, 0.609, -0.030> <0.065, 0.600, -0.043> <0.053, 0.599, -0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.041, 0.590, -0.051> <0.031, 0.591, -0.058> <0.013, 0.595, -0.060> <0.000, 0.595, -0.060> 
		<0.044, 0.593, -0.051> <0.034, 0.594, -0.059> <0.013, 0.597, -0.068> <0.000, 0.597, -0.068> 
		<0.051, 0.595, -0.054> <0.037, 0.593, -0.065> <0.019, 0.597, -0.078> <0.000, 0.597, -0.078> 
		<0.053, 0.599, -0.053> <0.039, 0.597, -0.065> <0.019, 0.600, -0.085> <0.000, 0.600, -0.085> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.595, -0.060> <-0.013, 0.595, -0.060> <-0.031, 0.591, -0.058> <-0.041, 0.590, -0.051> 
		<0.000, 0.597, -0.068> <-0.013, 0.597, -0.068> <-0.034, 0.594, -0.059> <-0.044, 0.593, -0.051> 
		<0.000, 0.597, -0.078> <-0.019, 0.597, -0.078> <-0.037, 0.593, -0.065> <-0.051, 0.595, -0.054> 
		<0.000, 0.600, -0.085> <-0.019, 0.600, -0.085> <-0.039, 0.597, -0.065> <-0.053, 0.599, -0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.041, 0.590, -0.051> <-0.050, 0.590, -0.043> <-0.058, 0.590, -0.027> <-0.058, 0.590, -0.015> 
		<-0.044, 0.593, -0.051> <-0.054, 0.592, -0.044> <-0.066, 0.597, -0.027> <-0.066, 0.596, -0.015> 
		<-0.051, 0.595, -0.054> <-0.063, 0.596, -0.044> <-0.078, 0.599, -0.030> <-0.080, 0.602, -0.015> 
		<-0.053, 0.599, -0.053> <-0.065, 0.600, -0.043> <-0.082, 0.609, -0.030> <-0.085, 0.612, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.058, 0.590, -0.015> <-0.058, 0.590, 0.002> <-0.052, 0.590, 0.027> <-0.041, 0.590, 0.041> 
		<-0.066, 0.596, -0.015> <-0.066, 0.596, 0.002> <-0.061, 0.599, 0.032> <-0.050, 0.599, 0.046> 
		<-0.080, 0.602, -0.015> <-0.084, 0.606, 0.007> <-0.086, 0.605, 0.044> <-0.070, 0.606, 0.061> 
		<-0.085, 0.612, -0.015> <-0.089, 0.616, 0.007> <-0.088, 0.619, 0.042> <-0.073, 0.620, 0.058> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.614, 0.075> <0.000, 0.619, 0.076> <0.000, 0.624, 0.068> <0.000, 0.629, 0.068> 
		<-0.022, 0.614, 0.075> <-0.022, 0.619, 0.076> <-0.018, 0.624, 0.068> <-0.018, 0.629, 0.068> 
		<-0.057, 0.620, 0.074> <-0.059, 0.631, 0.072> <-0.042, 0.621, 0.047> <-0.036, 0.630, 0.046> 
		<-0.073, 0.620, 0.058> <-0.074, 0.630, 0.056> <-0.054, 0.621, 0.034> <-0.048, 0.630, 0.033> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.614, 0.075> <0.022, 0.614, 0.075> <0.057, 0.620, 0.074> <0.073, 0.620, 0.058> 
		<0.000, 0.619, 0.076> <0.022, 0.619, 0.076> <0.059, 0.631, 0.072> <0.074, 0.630, 0.056> 
		<0.000, 0.624, 0.068> <0.018, 0.624, 0.068> <0.042, 0.621, 0.047> <0.054, 0.621, 0.034> 
		<0.000, 0.629, 0.068> <0.018, 0.629, 0.068> <0.036, 0.630, 0.046> <0.048, 0.630, 0.033> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.073, 0.620, 0.058> <0.088, 0.619, 0.042> <0.089, 0.616, 0.007> <0.085, 0.612, -0.015> 
		<0.074, 0.630, 0.056> <0.090, 0.630, 0.040> <0.092, 0.621, 0.007> <0.088, 0.617, -0.015> 
		<0.054, 0.621, 0.034> <0.065, 0.620, 0.022> <0.077, 0.628, 0.003> <0.077, 0.623, -0.013> 
		<0.048, 0.630, 0.033> <0.059, 0.630, 0.021> <0.077, 0.633, 0.001> <0.077, 0.629, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.085, 0.612, -0.015> <0.082, 0.609, -0.030> <0.065, 0.600, -0.043> <0.053, 0.599, -0.053> 
		<0.088, 0.617, -0.015> <0.085, 0.614, -0.030> <0.066, 0.603, -0.043> <0.054, 0.601, -0.052> 
		<0.077, 0.623, -0.013> <0.077, 0.619, -0.027> <0.058, 0.607, -0.035> <0.048, 0.605, -0.045> 
		<0.077, 0.629, -0.015> <0.077, 0.625, -0.029> <0.058, 0.609, -0.038> <0.048, 0.607, -0.048> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.053, 0.599, -0.053> <0.039, 0.597, -0.065> <0.019, 0.600, -0.085> <0.000, 0.600, -0.085> 
		<0.054, 0.601, -0.052> <0.040, 0.600, -0.064> <0.019, 0.602, -0.088> <0.000, 0.602, -0.088> 
		<0.048, 0.605, -0.045> <0.034, 0.601, -0.058> <0.019, 0.607, -0.089> <0.000, 0.607, -0.089> 
		<0.048, 0.607, -0.048> <0.034, 0.603, -0.061> <0.019, 0.610, -0.090> <0.000, 0.610, -0.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.600, -0.085> <-0.019, 0.600, -0.085> <-0.039, 0.597, -0.065> <-0.053, 0.599, -0.053> 
		<0.000, 0.602, -0.088> <-0.019, 0.602, -0.088> <-0.040, 0.600, -0.064> <-0.054, 0.601, -0.052> 
		<0.000, 0.607, -0.089> <-0.019, 0.607, -0.089> <-0.034, 0.601, -0.058> <-0.048, 0.605, -0.045> 
		<0.000, 0.610, -0.090> <-0.019, 0.610, -0.090> <-0.034, 0.603, -0.061> <-0.048, 0.607, -0.048> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.053, 0.599, -0.053> <-0.065, 0.600, -0.043> <-0.082, 0.609, -0.030> <-0.085, 0.612, -0.015> 
		<-0.054, 0.601, -0.052> <-0.066, 0.603, -0.043> <-0.085, 0.614, -0.030> <-0.088, 0.617, -0.015> 
		<-0.048, 0.605, -0.045> <-0.058, 0.607, -0.035> <-0.077, 0.619, -0.027> <-0.077, 0.623, -0.013> 
		<-0.048, 0.607, -0.048> <-0.058, 0.609, -0.038> <-0.077, 0.625, -0.029> <-0.077, 0.629, -0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.085, 0.612, -0.015> <-0.089, 0.616, 0.007> <-0.088, 0.619, 0.042> <-0.073, 0.620, 0.058> 
		<-0.088, 0.617, -0.015> <-0.092, 0.621, 0.007> <-0.090, 0.630, 0.040> <-0.074, 0.630, 0.056> 
		<-0.077, 0.623, -0.013> <-0.077, 0.628, 0.003> <-0.065, 0.620, 0.022> <-0.054, 0.621, 0.034> 
		<-0.077, 0.629, -0.015> <-0.077, 0.633, 0.001> <-0.059, 0.630, 0.021> <-0.048, 0.630, 0.033> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.629, 0.068> <0.000, 0.636, 0.068> <0.000, 0.643, 0.075> <0.000, 0.649, 0.075> 
		<-0.018, 0.629, 0.068> <-0.018, 0.636, 0.068> <-0.017, 0.643, 0.075> <-0.017, 0.649, 0.075> 
		<-0.036, 0.630, 0.046> <-0.031, 0.637, 0.045> <-0.042, 0.643, 0.063> <-0.042, 0.651, 0.066> 
		<-0.048, 0.630, 0.033> <-0.043, 0.637, 0.032> <-0.053, 0.642, 0.050> <-0.053, 0.650, 0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.629, 0.068> <0.018, 0.629, 0.068> <0.036, 0.630, 0.046> <0.048, 0.630, 0.033> 
		<0.000, 0.636, 0.068> <0.018, 0.636, 0.068> <0.031, 0.637, 0.045> <0.043, 0.637, 0.032> 
		<0.000, 0.643, 0.075> <0.017, 0.643, 0.075> <0.042, 0.643, 0.063> <0.053, 0.642, 0.050> 
		<0.000, 0.649, 0.075> <0.017, 0.649, 0.075> <0.042, 0.651, 0.066> <0.053, 0.650, 0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.048, 0.630, 0.033> <0.059, 0.630, 0.021> <0.077, 0.633, 0.001> <0.077, 0.629, -0.015> 
		<0.043, 0.637, 0.032> <0.055, 0.637, 0.019> <0.077, 0.638, -0.001> <0.077, 0.634, -0.017> 
		<0.053, 0.642, 0.050> <0.070, 0.640, 0.031> <0.086, 0.644, 0.001> <0.086, 0.636, -0.023> 
		<0.053, 0.650, 0.053> <0.069, 0.648, 0.034> <0.085, 0.649, -0.001> <0.085, 0.641, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.077, 0.629, -0.015> <0.077, 0.625, -0.029> <0.058, 0.609, -0.038> <0.048, 0.607, -0.048> 
		<0.077, 0.634, -0.017> <0.077, 0.630, -0.031> <0.058, 0.613, -0.043> <0.048, 0.610, -0.053> 
		<0.086, 0.636, -0.023> <0.086, 0.630, -0.041> <0.068, 0.607, -0.052> <0.054, 0.604, -0.064> 
		<0.085, 0.641, -0.025> <0.085, 0.635, -0.043> <0.067, 0.612, -0.056> <0.053, 0.609, -0.068> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.048, 0.607, -0.048> <0.034, 0.603, -0.061> <0.019, 0.610, -0.090> <0.000, 0.610, -0.090> 
		<0.048, 0.610, -0.053> <0.034, 0.607, -0.066> <0.019, 0.614, -0.092> <0.000, 0.614, -0.092> 
		<0.054, 0.604, -0.064> <0.040, 0.602, -0.076> <0.018, 0.620, -0.096> <0.000, 0.620, -0.096> 
		<0.053, 0.609, -0.068> <0.039, 0.606, -0.080> <0.018, 0.625, -0.095> <0.000, 0.625, -0.095> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.610, -0.090> <-0.019, 0.610, -0.090> <-0.034, 0.603, -0.061> <-0.048, 0.607, -0.048> 
		<0.000, 0.614, -0.092> <-0.019, 0.614, -0.092> <-0.034, 0.607, -0.066> <-0.048, 0.610, -0.053> 
		<0.000, 0.620, -0.096> <-0.018, 0.620, -0.096> <-0.040, 0.602, -0.076> <-0.054, 0.604, -0.064> 
		<0.000, 0.625, -0.095> <-0.018, 0.625, -0.095> <-0.039, 0.606, -0.080> <-0.053, 0.609, -0.068> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.048, 0.607, -0.048> <-0.058, 0.609, -0.038> <-0.077, 0.625, -0.029> <-0.077, 0.629, -0.015> 
		<-0.048, 0.610, -0.053> <-0.058, 0.613, -0.043> <-0.077, 0.630, -0.031> <-0.077, 0.634, -0.017> 
		<-0.054, 0.604, -0.064> <-0.068, 0.607, -0.052> <-0.086, 0.630, -0.041> <-0.086, 0.636, -0.023> 
		<-0.053, 0.609, -0.068> <-0.067, 0.612, -0.056> <-0.085, 0.635, -0.043> <-0.085, 0.641, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.077, 0.629, -0.015> <-0.077, 0.633, 0.001> <-0.059, 0.630, 0.021> <-0.048, 0.630, 0.033> 
		<-0.077, 0.634, -0.017> <-0.077, 0.638, -0.001> <-0.055, 0.637, 0.019> <-0.043, 0.637, 0.032> 
		<-0.086, 0.636, -0.023> <-0.086, 0.644, 0.001> <-0.070, 0.640, 0.031> <-0.053, 0.642, 0.050> 
		<-0.085, 0.641, -0.025> <-0.085, 0.649, -0.001> <-0.069, 0.648, 0.034> <-0.053, 0.650, 0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.664, 0.065> <-0.015, 0.664, 0.065> <-0.037, 0.665, 0.058> <-0.046, 0.665, 0.046> 
		<0.000, 0.660, 0.068> <-0.015, 0.660, 0.068> <-0.039, 0.661, 0.060> <-0.048, 0.660, 0.048> 
		<0.000, 0.655, 0.074> <-0.017, 0.655, 0.074> <-0.042, 0.656, 0.068> <-0.053, 0.655, 0.055> 
		<0.000, 0.649, 0.075> <-0.017, 0.649, 0.075> <-0.042, 0.651, 0.066> <-0.053, 0.650, 0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.664, 0.065> <0.000, 0.660, 0.068> <0.000, 0.655, 0.074> <0.000, 0.649, 0.075> 
		<0.015, 0.664, 0.065> <0.015, 0.660, 0.068> <0.017, 0.655, 0.074> <0.017, 0.649, 0.075> 
		<0.037, 0.665, 0.058> <0.039, 0.661, 0.060> <0.042, 0.656, 0.068> <0.042, 0.651, 0.066> 
		<0.046, 0.665, 0.046> <0.048, 0.660, 0.048> <0.053, 0.655, 0.055> <0.053, 0.650, 0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.046, 0.665, 0.046> <0.048, 0.660, 0.048> <0.053, 0.655, 0.055> <0.053, 0.650, 0.053> 
		<0.061, 0.663, 0.028> <0.063, 0.659, 0.030> <0.069, 0.653, 0.036> <0.069, 0.648, 0.034> 
		<0.074, 0.668, -0.004> <0.077, 0.663, -0.004> <0.085, 0.655, -0.003> <0.085, 0.649, -0.001> 
		<0.074, 0.658, -0.025> <0.077, 0.653, -0.025> <0.085, 0.647, -0.027> <0.085, 0.641, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.074, 0.658, -0.025> <0.077, 0.653, -0.025> <0.085, 0.647, -0.027> <0.085, 0.641, -0.025> 
		<0.074, 0.651, -0.041> <0.077, 0.646, -0.041> <0.085, 0.641, -0.045> <0.085, 0.635, -0.043> 
		<0.059, 0.621, -0.045> <0.062, 0.618, -0.049> <0.067, 0.616, -0.059> <0.067, 0.612, -0.056> 
		<0.046, 0.617, -0.056> <0.048, 0.615, -0.060> <0.052, 0.613, -0.071> <0.053, 0.609, -0.068> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.046, 0.617, -0.056> <0.048, 0.615, -0.060> <0.052, 0.613, -0.071> <0.053, 0.609, -0.068> 
		<0.033, 0.614, -0.067> <0.035, 0.611, -0.071> <0.038, 0.610, -0.082> <0.039, 0.606, -0.080> 
		<0.018, 0.640, -0.085> <0.018, 0.636, -0.088> <0.018, 0.630, -0.094> <0.018, 0.625, -0.095> 
		<0.000, 0.640, -0.085> <0.000, 0.636, -0.088> <0.000, 0.630, -0.094> <0.000, 0.625, -0.095> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.640, -0.085> <0.000, 0.636, -0.088> <0.000, 0.630, -0.094> <0.000, 0.625, -0.095> 
		<-0.018, 0.640, -0.085> <-0.018, 0.636, -0.088> <-0.018, 0.630, -0.094> <-0.018, 0.625, -0.095> 
		<-0.033, 0.614, -0.067> <-0.035, 0.611, -0.071> <-0.038, 0.610, -0.082> <-0.039, 0.606, -0.080> 
		<-0.046, 0.617, -0.056> <-0.048, 0.615, -0.060> <-0.052, 0.613, -0.071> <-0.053, 0.609, -0.068> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.046, 0.617, -0.056> <-0.048, 0.615, -0.060> <-0.052, 0.613, -0.071> <-0.053, 0.609, -0.068> 
		<-0.059, 0.621, -0.045> <-0.062, 0.618, -0.049> <-0.067, 0.616, -0.059> <-0.067, 0.612, -0.056> 
		<-0.074, 0.651, -0.041> <-0.077, 0.646, -0.041> <-0.085, 0.641, -0.045> <-0.085, 0.635, -0.043> 
		<-0.074, 0.658, -0.025> <-0.077, 0.653, -0.025> <-0.085, 0.647, -0.027> <-0.085, 0.641, -0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.074, 0.658, -0.025> <-0.077, 0.653, -0.025> <-0.085, 0.647, -0.027> <-0.085, 0.641, -0.025> 
		<-0.074, 0.668, -0.004> <-0.077, 0.663, -0.004> <-0.085, 0.655, -0.003> <-0.085, 0.649, -0.001> 
		<-0.061, 0.663, 0.028> <-0.063, 0.659, 0.030> <-0.069, 0.653, 0.036> <-0.069, 0.648, 0.034> 
		<-0.046, 0.665, 0.046> <-0.048, 0.660, 0.048> <-0.053, 0.655, 0.055> <-0.053, 0.650, 0.053> 
	}
	texture { T_Layer8 }
	scale MeshScale
}
#end    // if HumanMesh = on


// Logo
height_field {
    gif "by-gsr.gif"
    water_level .001
    no_shadow
    texture {
        pigment {
            bozo // gradient z+x
            color_map {
                [ 0 color rgb <.25, 1, 1> ]
                [ 1 color rgb <.1, .1, 1> ]
            }
            sine_wave
            scale .25
        }
        finish {
            ambient .2
            diffuse .4
        }
    }
    texture {
        pigment {
            crackle
            color_map {
                [ .05 Black ]
                [ .05 Clear ]
            }
            scale .2
            translate <.5, 0, .5> // To fix big black spots
        }
        finish {
            ambient .1
            diffuse .5
        }
    }
    translate <-.5, 0, -.5>
    rotate -90 * x
    rotate 180 * y
    rotate 5 * z
    scale <1, .4, 1> * .8 * MeshScale * 1.3
    translate <-.3, .9, -3> * MeshScale
    translate <-3, -.75, .1> * MeshScale
}
