// Persistence of Vision Ray Tracer Scene Description File
// File: krikkit.pov
// Vers: 3
// Desc: Night over Krikkit
// Date: 04/28/98
// Auth: Ulf Schreiber
//

#version 3

#ifndef (clock)
	#declare pclock=0
#else
	pclock=clock	
#end

#include "colors.inc"

// ----------------------------------------
//camera{  location  <pclock*10-5, .5, 0>  look_at   <0, 0.15,5>}
//camera{  location  <pclock*10-5, 5, -10>  look_at   <0, 0.15,5>}
camera{  location  <0,.5,0>  look_at   <0, 0.15,5>}


light_source
{
  0*x // light's position (translated below)
  color red 2  green 1  blue 1  // light's color
  translate <-.5, .5, 0>
}

// ----------------------------------------
//plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}

//sphere { 0.0, 1 texture {pigment {radial frequency 8} finish{specular 1}} }




height_field {
	tga
	"krickhil.tga"
	
//	pigment {color Green}
	pigment{dents
    turbulence 10
    color_map {
				[0, color rgb<.01,.4,.1>]   
				[.6,color rgb<.01,.6,.01>]
				[.9,color rgb<.5,.3,.1>]

    }
		scale .01
  }
	
	translate <-.5,.5,0>
	scale<10,.2,10>
//	water_level .94+ccl/20
//smooth
}

#declare H2G2=union{
text{ttf "c:\windows\fonts\gara.ttf",
	"The night sky over the planet Krikkit"
	,.001,0
	pigment{
		color Red}
//		finish{ambient .9}
	
	scale <.7,2,1>
	translate<-5,3.4,10>
}
text{ttf "c:\windows\fonts\gara.ttf",
	"is the least interesting sight in the entire Universe."
	,.001,0
	pigment{
		color Red}
//		finish{ambient .9}
	
	scale <.53,2,1>
	translate<-5,1,10>
}	
text{ttf "c:\windows\fonts\gara.ttf",
	"Important facts from Galactic history, number one:"
	,.001,0
	pigment{
		color Blue}
//		finish{ambient .9}
	
	scale <.6,.4,1>
	translate<-6,2.5,10>
}	

text{ttf "c:\windows\fonts\gara.ttf",
	"- Douglas N. Adams, \"Life,the Universe and Everything\""
	,.001,0
	pigment{
		color rgb<.5,0,.8>}
//		finish{ambient .9}
	
	scale <.3,.3,1>
	translate<0,.5,10>
}	
}

object{H2G2}
/*
Important facts from Galactic history, number one:

(Reproduced from the Siderial Daily Mentioner's Book  of  popular
Galactic History.)

The night sky over the planet Krikkit is  the  least  interesting
sight in the entire Universe.
*/
