// #include "consts.inc"

// #declare Rad_Quality = Radiosity_Debug
// #declare Rad_Quality = Radiosity_Fast
// #declare Rad_Quality = Radiosity_Normal
// #declare Rad_Quality = Radiosity_2Bounce
// #declare Rad_Quality = Radiosity_Final
// #include "rad_def.inc"

#declare VerEpais=0.05
#declare Trans=on
#declare Atmos=on
#declare VerreDeb=on
#declare VerreCouch=on
#declare Tache=on
#declare RoseRend=on
#declare DefaultCamereValue=on

// Rotation des Sparkles
#declare SparkRot1=0	// Verre debout Arriere
#declare SparkRot2=21	// Verre debout Avant
#declare SparkRot3=-45	// Rose


// LA CAMERA //
// Cutomize position of the camera
#declare cm_location=<0,10,-40>
#declare cm_look_at=<0,1.5,0>
#declare cm_angle=12
#declare cm_prop=<2,1,0>
#include "Camera.inc"

#if (Atmos)
atmosphere {
   type 1
   distance 40
   scattering 0.1
   color rgbf <0.5,0.2,0,0.1>
}
#end

#if (DefaultCamereValue)
#declare camera_location=<0,10,-40>
#declare camera_look_at=<0,1.5,0>
#declare camera_angle=12
#end

// LES SOURCES DE LUMIERES //

light_source {
   <-100, 20,-100>
   rgb <1,1,1>
   atmosphere off
}

light_source {
   <-5,30,-5>
   rgb <1,1,1>
   spotlight
   point_at <0,0,0>
   radius 5
   falloff 10
}

// TEXTURE DU VERRE //

#declare VerreText=texture {
   #if (Trans)
   pigment { rgbt <1,0.8,0.7, 0.95> }
   #else
   pigment { rgb <1,0.8,0.7> }
   #end
   
   normal { bumps 0.1 scale 0.2 }

   finish {
      #if (Trans)
      ambient 0.0
      #else
      ambient 0.2
      #end
      reflection 0.3
      refraction 0.9
      phong 1
      specular 0.2
      #if (Trans)
      diffuse 0.1
      #else
      diffuse 0.8
      #end
      ior 1.5
   }
}


// TEXTURE DU LIQUIDE //

#declare LiquideText=texture {
   #if (Trans)
   pigment { rgbt <1, 0.7, 0, 0.8> }
   #else
   pigment { rgb <1, 0.7, 0> }
   #end
   finish {
      ambient 0.0
      reflection 0.3
      refraction 0.9
      phong 1
      specular 0.2
      diffuse 0.3
      ior 1.33
      fade_distance 0.75
      fade_power 1.2
   }
}

// UN VERRE //
#declare Verre=difference {
   merge {
      cylinder {
	 <0,VerEpais,0>, <0,3,0>, 1
      }
      
      torus {
	 1-VerEpais, VerEpais
	    translate <0, VerEpais, 0>
      }
      
      cylinder {
	 <0,0,0>, <0, 2, 0>, 1-VerEpais
      }
	 
      torus {
	 1-VerEpais, VerEpais
	 translate <0,3,0>
      }
   }

   merge {
      cylinder {
	 <0,0.7,0>, <0, 5, 0>, 1-2*VerEpais
      }
      sphere {
	 <0,0,0>, 1-2*VerEpais
	 scale <1,0.1,1>
	 translate <0,0.7,0>
      }
   }
   texture { VerreText }
}

// EAU DANS LE VERRE //
#declare LiqVerre=  merge {
   cylinder {
      <0,0.5,0>, <0, 2, 0>, 1-2*VerEpais
   }
   sphere {
      <0,0,0>, 1-2*VerEpais
      scale <1,0.1,1>
      translate <0,0.5,0>
   }
   texture { LiquideText }
}



// LE VERRE DEBOUT //
#if (VerreDeb)
union {
   object { Verre }
   object { LiqVerre }
   translate <-3,0,0>
}
#end


// LE VERRE COUCHE //
#if (VerreCouch)
object {
   Verre
   rotate x*90
   translate -z*3
   translate y
   
   rotate y*(45+180)
   translate <1.2,0, 1.5>
}
#end


// LA TABLE //

plane {
   y, 0
   texture {
      pigment { 
	 
	 rgb <1,0.5, 0> 
      }
      finish { 
	 ambient 0
	 refraction 0
	 reflection 0.3
	 diffuse 0.8
	 ambient 0.0
      }
   }
}


// LA TACHE //
#if (Tache)
#declare WatLevel=0.1
height_field {
   tga "flaque.tga"
   smooth
   water_level WatLevel
   translate -y*WatLevel
   scale <5,0.05,5>
   translate <-3.3,0, -3.5>
   texture { LiquideText}
}
#end

#if (RoseRend)
#include "Rose.inc"
object { 
   Rose
   rotate -x*45
   translate y
   rotate z*5
   scale 0.5
   rotate y*50
   translate x
   translate -z
}
#end

#declare effect_always_on_top=off

#declare effect_scale=0.3

#declare glow_type=2
#declare rays_type=0
#declare streak_type=0
#declare spots_type=0

#if (VerreDeb)
#declare effect_location=vrotate(<0, 3+VerEpais/2,1-VerEpais*2>, y*SparkRot1) + <-3,0,0>
#include "LNSEFCTS.INC"
#declare effect_location=vrotate(<0, 3+VerEpais/2,-1>, y*SparkRot2) + <-3,0,0>
#include "LNSEFCTS.INC"
#end

/*
#if (RoseRend)
#declare effect_location=<1.5,2.2,0>
#declare effect_location=vrotate(effect_location, x*SparkRot3)
#declare effect_location=vrotate(effect_location, z*5)*0.5
#declare effect_location=vrotate(effect_location, y*50)+x-z
#include "LNSEFCTS.INC"
#end
*/
