/*
**  lsttm.cpp, generates some customized POV-RAY height fields
**  by GJV.  Included for reference purposes only.
*/

#include    <stdio.h>
#include   <stdlib.h>
#include   <string.h>
#include   <stdarg.h>
#include     <math.h>
#include    <float.h>
#include     <time.h>
#include    <ctype.h>
#include    "phead.hpp"
#include     "char.hpp"
#include    "point.hpp"
#include     "line.hpp"
#include   "circle.hpp"
#include "triangle.hpp"
#include  "extreme.hpp"
#include     "mesh.hpp"
#include  "complex.hpp"
#include    "patch.hpp"
#include    "2dsys.hpp"
#include     "hull.hpp"
#include       "uv.hpp"
#include     "bola.hpp"
#include    "sobjs.hpp"
#include    "chain.hpp"
#include      "bez.hpp"
#include    "swoop.hpp"
#include    "gdome.hpp"
#include   "pigmap.hpp"
#include    "targa.hpp"
cPOINT Origin;
#define DEFAULTSIZE  300
char flagbuf[ DEFAULTSIZE ][ DEFAULTSIZE ];

int sd( cTARGA_CREATE& tc, int tx, int ty, int bx, int by )
{   //subdivide pixel smoothing
    if( abs( tx - bx ) < 2 && abs( ty - by ) < 2 ) return( 0 );
    if( !between( tx, 0, DEFAULTSIZE - 1 ) ) return( 0 );
    if( !between( bx, 0, DEFAULTSIZE - 1 ) ) return( 0 );
    if( !between( ty, 0, DEFAULTSIZE - 1 ) ) return( 0 );
    if( !between( by, 0, DEFAULTSIZE - 1 ) ) return( 0 );
    int ix = ( tx + bx ) / 2;
    int iy = ( ty + by ) / 2;
    if( flagbuf[ ix ][ iy ] ) return( 0 );
    int tr = 0; int tg = 0; int tb = 0;
    tTARGABYTE r = 255;
    tTARGABYTE g = 255;
    tTARGABYTE b = 255;
    tTARGABYTE nr = 255;
    tTARGABYTE ng = 255;
    tTARGABYTE nb = 255;
    tc.getBuffer( tx, ty, &r, &g, &b ); tr += r; tg += g; tb += b;
    tc.getBuffer( bx, ty, &r, &g, &b ); tr += r; tg += g; tb += b;
    tc.getBuffer( tx, by, &r, &g, &b ); tr += r; tg += g; tb += b;
    tc.getBuffer( bx, by, &r, &g, &b ); tr += r; tg += g; tb += b;
    tc.getBuffer( ix, iy, &r, &g, &b ); tr += r; tg += g; tb += b;
    nr = (tTARGABYTE)( tr / 5 );   
    ng = (tTARGABYTE)( tg / 5 );
    nb = (tTARGABYTE)( tb / 5 );
    tc.putBuffer( ix, iy, nr, ng, nb );
    ++flagbuf[ ix ][ iy ];
    sd( tc, tx, ty, ix, iy );
    sd( tc, ix, ty, bx, iy );
    sd( tc, tx, iy, ix, by );
    sd( tc, ix, iy, bx, by );
    return( 1 );
}
void dn3( void )
{   // create targa height fields
    int ix;
    int iy;
    cPOINT po( DEFAULTSIZE / 2, DEFAULTSIZE / 2, 0.0 );
    cTARGA_CREATE tc( "gjv.tga", DEFAULTSIZE, DEFAULTSIZE );
    for( ix = 0; ix < DEFAULTSIZE * 17; ix += 1 ) {
         // initialize
         tc.putBufferRandom( rand() % DEFAULTSIZE, 
                             rand() % DEFAULTSIZE ); 
    }
    for( ix = 0; ix < DEFAULTSIZE; ix += 1 ) {
         // crater generation
         for( iy = 0; iy < DEFAULTSIZE; iy += 1 ) {
              cPOINT p( ix, iy, 0.0 );
              double dist = p.distance( po );
              if( fabs( dist - 25 ) < 4 ) {
                  tc.putBuffer( ix, iy, 64, 64, 64 );
              } else if( dist < 15 ) {
                  dist /= DEFAULTSIZE;
                  dist *= ( 92.0 * drand() * drand() );
                  tTARGABYTE t = (tTARGABYTE)dist;
                  tc.putBuffer( ix, iy, t, t, t );
              }
         }
    }
    memset( flagbuf, 0, DEFAULTSIZE * DEFAULTSIZE * sizeof( char ) );
    sd( tc, 0, 0, DEFAULTSIZE - 1, DEFAULTSIZE - 1 );
    for( ix = 0; ix < DEFAULTSIZE; ix += 1 ) {
         for( iy = 0; iy < DEFAULTSIZE; iy += 1 ) {
              if( ix == 0 ) continue;
              if( iy == 0 ) continue;
              if( ix == DEFAULTSIZE - 1 ) continue;
              if( iy == DEFAULTSIZE - 1 ) continue;
              if( !flagbuf[ ix ][ iy ] ) {
                  // cheat smooth because integer truncation
                  sd( tc, ix - 9, iy - 9, ix + 9, iy + 9 );
                  sd( tc, ix - 1, iy - 1, ix + 1, iy + 1 );
              }
         }
    }
    tc.putBuffer( DEFAULTSIZE / 2, DEFAULTSIZE / 2, 0, 0, 0 );
    for( ix = 0; ix < DEFAULTSIZE; ix += 1 ) {
         // clean the edges, but must be square
         tc.putBuffer( ix, 0, 0, 0, 0 );
         tc.putBuffer( ix, DEFAULTSIZE - 1, 0, 0, 0 );
         tc.putBuffer( 0, ix, 0, 0, 0 );
         tc.putBuffer( DEFAULTSIZE - 1, ix, 0, 0, 0 );
    }
    tc.dumpBuffer();
}
int main( int argc, char *argv[] ) 
{
    dn3();
    return( 0 );
}


