/*
**  lsttm2.cpp, generates the bezier pipelines and lsttm support
**  by GJV.  Included for reference purposes only.
*/
#include    <stdio.h>
#include   <stdlib.h>
#include   <string.h>
#include   <stdarg.h>
#include     <math.h>
#include    <float.h>
#include     <time.h>
#include    <ctype.h>
#include    "phead.hpp"
#include    "point.hpp"
#include     "line.hpp"
#include   "circle.hpp"
#include "triangle.hpp"
#include  "extreme.hpp"
#include     "mesh.hpp"
#include  "complex.hpp"
#include    "patch.hpp"
#include    "2dsys.hpp"
#include     "hull.hpp"
#include       "uv.hpp"
#include     "bola.hpp"
#include    "sobjs.hpp"
#include    "chain.hpp"
#include      "bez.hpp"
#include    "swoop.hpp"
#include    "gdome.hpp"
cPOINT Origin;

int main( int, char** )
{
    int j;
    cPOV pov( "lsttm.pov" ); // get a basic pov going
    pov.setRad( 0.25, 1 );   // set defaults
    cGENERAL::basicScene( pov ); // get some textures

    cCIRCLE C1( Origin, 20, 7 ); // set up some points
    cCIRCLE C2( cPOINT( 0.0, 0.0, -30.0 ), 2, C1.pt.npts );
    double zmid = ( 360.0 / (double)C1.pt.npts ) / -2.0;
    C2.pt.rotate( cPOINT( 0.0, 0.0, zmid ) );
    pov.put( "#declare bezPipe=union{\n" );
    for( int i = 0; i < C1.pt.npts; i++ ) {
         // connect points via bezier recursion
         if( !i ) j = C1.pt.npts - 1; else j = i - 1;
         cPOINT A( C1.pt.p[ j ] );
         cPOINT B( C2.pt.p[ i ] );
         cPOINT C( C1.pt.p[ i ] );
         bezConnect( pov, NULL, A, B, C, 20 );
    }
    pov.put( "}\n" );
    pov.putObj( "bezPipe rotate x*90", "GoldTexture" ); // put it in pov
    pov.show(); // render it
    return 0;
}
