
// Persistence of Vision Ray Tracer Scene Description File
// File: mg_ababa.pov
// Vers: 3
// Desc:
// Date: March 30, 1998
// Auth:Marjorie Graterol


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	
#include "textures.inc"	

camera
{
  location  <14 , 11, -30>
  look_at   <6 ,0.40 , 30>
  focal_point < 1, 1, -6>
}

light_source
{
    
    <-20,100,20>
    color MediumTurquoise
    fade_power 10
 }

light_source {
    <10,50,5>
    color Very_Light_Purple
    spotlight
    radius 10
    falloff 12
    tightness 10
    point_at <1,12,1>
  } 

  light_source {
    <15,50,10.2>
    color SummerSky
    spotlight
    radius 30
    falloff 10
    tightness 50
    point_at <15, 0, 10.2>
  } 


light_source {
    <-15, 50,8>
    color Light_Purple
    spotlight
    radius 30
    falloff 10
    tightness 50
    point_at <-10, 2,10>
  } 
  
light_source {
    <-15, 50,8>
    color Light_Purple
    spotlight
    radius 30
    falloff 10
    tightness 50
    point_at <50, 2.0, 70>
  } 

light_source {
    <15,50,10.2>
    color SummerSky
    spotlight
    radius 30
    falloff 10
    tightness 50
    point_at <22, 1.0, -1>
  } 


 height_field {
    gif "mg_ababa.gif"
    water_level 0.6
    smooth
    pigment { agate}

    translate 
    <-0.45, -0.5, -0.5>
    rotate 90*y
    scale <100, 9, -100>
  }


  plane { y, 1
   pigment { CornflowerBlue }
   normal {
      waves 0.06
      frequency 300.0
      scale 1000.0}
   finish {
      caustics .6
      ambient 0.1
      diffuse 0.1
      reflection 0.8
   }
}

plane { y, -1

   pigment {Gold}
   normal {
      bump_map
{
  gif "mg_ababa.gif"
  map_type 1
  interpolate 4
    once
  bump_size 3.0
}}
finish {
ambient .2
diffuse .6
phong 5
phong_size 120
   }
rotate -90*x
scale 1000.0

}
sor {
 17, //24,
<0.0, -0.5>,
<3.6, 0.0>,
<3.0, 0.4>,
<2.5, 0.6>,
<1.4, 0.9>,
<1.25, 1.0>,
<1.5, 1.35>,
<2.5, 1.95>,
<3.8, 3.4>,
<4.25, 5.2>,
<4.1, 6.5>,
<3.0, 8.25>,
<1.8, 9.5>,
<1.85, 10.0>,
<2.25, 10.2>,
<2.1, 10.4>,
<2.25, 10.55>

open
pigment {Orange}
   finish {
      ambient 0.2
      diffuse 0.7
      phong 1
      phong_size 80
      brilliance 2
   }

}


#declare envase =
sor {
24,
<0.0, -0.5>,
<3.6, 0.0>,
<3.0, 0.4>,
<2.5, 0.6>,
<1.4, 0.9>,
<1.25, 1.0>,
<1.5, 1.35>,
<2.5, 1.95>,
<3.8, 3.4>,
<4.25, 5.2>,
<4.1, 6.5>,
<3.0, 8.25>,
<1.8, 9.5>,
<1.85, 10.0>,
<2.25, 10.2>,
<2.1, 10.4>,
<2.25, 10.55>,
<2.1, 10.65>,
<1.85, 11.0>,
<1.2, 11.25>,
<0.5, 11.58>,
<0.75, 11.9>,
<0.5, 12.1>,
<0, 13.0>

}

#declare caida=
sor {
 17, //24,
<0.0, -0.5>,
<3.6, 0.0>,
<3.0, 0.4>,
<2.5, 0.6>,
<1.4, 0.9>,
<1.25, 1.0>,
<1.5, 1.35>,
<2.5, 1.95>,
<3.8, 3.4>,
<4.25, 5.2>,
<4.1, 6.5>,
<3.0, 8.25>,
<1.8, 9.5>,
<1.85, 10.0>,
<2.25, 10.2>,
<2.1, 10.4>,
<2.25, 10.55>


open
pigment {Orange}
   finish {
      ambient 0.2
      diffuse 0.7
      phong 1
      phong_size 80
      brilliance 2
   }

}


object{
      caida
      texture {Polished_Chrome}
      rotate <85,0,0>
      rotate <0,120,0>
      rotate <0,0,0>
      translate <-15, 2,8>
}

#declare envase2=
sor {
 24,
<0.0, -0.5>,
<3.6, 0.0>,
<3.0, 0.4>,
<2.5, 0.6>,
<1.4, 0.9>,
<1.25, 1.0>,
<1.5, 1.35>,
<2.5, 1.95>,
<3.8, 3.4>,
<4.25, 5.2>,
<4.1, 6.5>,
<3.0, 8.25>,
<1.8, 9.5>,
<1.85, 10.0>,
<2.25, 10.2>,
<2.1, 10.4>,
<2.25, 10.55>,
<2.1, 10.65>,
<1.85, 11.0>,
<1.2, 11.25>,
<0.5, 11.58>,
<0.75, 11.9>,
<0.5, 12.1>,
<0, 13.0>


}

#declare envase3=
sor {
 24,
<0.0, -0.5>,
<3.6, 0.0>,
<3.0, 0.4>,
<2.5, 0.6>,
<1.4, 0.9>,
<1.25, 1.0>,
<1.5, 1.35>,
<2.5, 1.95>,
<3.8, 3.4>,
<4.25, 5.2>,
<4.1, 6.5>,
<3.0, 8.25>,
<1.8, 9.5>,
<1.85, 10.0>,
<2.25, 10.2>,
<2.1, 10.4>,
<2.25, 10.55>,
<2.1, 10.65>,
<1.85, 11.0>,
<1.2, 11.25>,
<0.5, 11.58>,
<0.75, 11.9>,
<0.5, 12.1>,
<0, 13.0>

}
#declare tapa=
sor{
7,
<2.1, 10.65>,
<1.85, 11.0>,
<1.2, 11.25>,
<0.5, 11.58>,
<0.75, 11.9>,
<0.5, 12.1>,
<0.0, 13.0>
pigment {Orange}
   finish {
      ambient 0.2
      diffuse 0.7
      phong 1
      phong_size 80
      brilliance 2
   }
}

object {
  envase
  texture {New_Penny}
  translate <50, 2.0, 70>
}

object {
  envase2
  texture { Polished_Chrome}
    translate <15, 1.0, 15>
}

object {
  envase3
  texture { New_Penny}

  translate <20, 1.0, -0.5>
}

object {
  tapa
  rotate -65*x
  rotate 20*y
  translate <0.5, -1.4, 5.2>
}



