
// Persistence of Vision Ray Tracer Scene Description File
// File: nite1.pov
// Vers: 3
// Desc: night scene moons over ?
// Date:
// Auth: Terry Lyons


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


// ==== Additional Includes ====
#include "chars.inc"   // FIXME-add comments describing each of these
#include "stones.inc"
#include "skies.inc"
#include "stars.inc"

#declare col_0  = colour red 0.8 green 0.498039 blue 0.196078
#declare col_1  = colour red 0.5 green 0.5 blue 0.5
#declare col_2  = colour Brown // red 1
#declare col_3  = colour red 1.0 green 1.0
#declare col_4  = colour red 0.2 green 0.7 blue 0.1
#declare col_5  = colour blue 1.0 green 1.0
#declare col_6  = colour blue 1.0
#declare col_7  = colour red 1.0 blue 1.0
#declare col_8  = colour red 0.439216 green 0.858824 blue 0.576471
#declare col_9  = colour red 1.0 green 0.498039 blue 0.0
#declare col_10 = colour red 0.258824 green 0.258824 blue 0.435294
#declare col_11 = colour red 0.6 green 0.196078 blue 0.8
#declare col_12 = colour red 0.439216 green 0.576471 blue 0.858824
#declare col_13 = colour red 0.556863 green 0.137255 blue 0.137255
#declare col_14 = colour red 0.858824 green 0.858824 blue 0.439216
#declare col_15 = colour red 0.623529 green 0.623529 blue 0.372549
#declare col_16 = colour red 0.0001 green 0.003 blue 0.0001

#declare l_base = object { sphere { <0, 0.75, 0> 0.75 } }

#declare t_base = finish { reflection .00250  ambient 0.0023 diffuse 0.0087 phong .0041 }
#declare t_leaf =       finish { Shiny }
#declare Plant = union {
#include "output.inc"
}
camera
{
  location  <0.0 , .4 ,-5.0>
  look_at   <0.0 , 1.40 , 0.0>
}
// create a regular point light source
// light_source { 0*x color red 1.0  green  1.0  blue 1.0 translate <-40, -20000, 900> atmospheric_attenuation on }
// light_source { 0*x color red 1.0  green  1.0  blue 1.0 translate <-45000, -20200, 103> atmospheric_attenuation on }

// create a point "spotlight" (conical directed) light source

// Set the language version of POV-Ray.  Enables or
// disables syntax features that are version-dependent.
// e.g. #version 1.0, or #version 2.0, etc.
// (Note: This can toggle versions anywhere in the source)
#version 3
// create a sphere shape
/*
sphere
{
  <700, 300, 500000> // center of sphere <X Y Z>
  75000
texture {

// texture pigment/normal pattern
   crackle
   scale 140000.5
   turbulence 0.5

texture_map {
            [0.0   Water  scale 100 ]
            [0.03   Water  scale 100 ]
            [0.05   Lightening1 scale 100 ]
            [0.07   Water  scale 1000 ]
            [0.5   T_Stone24 scale 100  ]
            [0.52   Lightening2 scale 100  ]
            [0.55   T_Stone24 scale 100  ]
            [1.0   T_Stone15 scale 1000 ]
            }

}
no_shadow
} 
 
*/
// create a sphere shape
#declare Moon = sphere
{
 // <-90000, 30000, 145000> // center of sphere <X Y Z>
<0, 100, 44460> // center of sphere <X Y Z>
  20220       // radius of sphere

hollow
texture {
T_Stone15 scale 90000
finish {

phong 0.001
reflection .17
}
}

}


light_source { 0*x color red .98  green  .98  blue .98 translate <-9000, 30000, 14500> atmospheric_attenuation on looks_like { Moon } }
light_source { 0*x color red .98  green  .98  blue .98 translate <9000, 3000, 75000> atmospheric_attenuation on looks_like { Moon } }
 sphere { <0,-1500,0>,2000
 hollow
 texture {
 pigment { Clouds scale <1000,3090,521>  }
finish {  caustics 4.92 fade_power 3 fade_distance 1700 }
//}

//}
/* 
  #declare ISOTROPIC_SCATTERING         = 1
  #declare MIE_HAZY_SCATTERING          = 2
  #declare MIE_MURKY_SCATTERING         = 3
  #declare RAYLEIGH_SCATTERING          = 4
  #declare HENYEY_GREENSTEIN_SCATTERING = 5
*/

// Atmosphere with Mie scattering, murky atmosphere (dependent on incident light). 
halo
{
  glowing
 
dust_type 4           // Mie scattering

  samples 5        // Number of samples in first distance interval
  turbulence .30
frequency 4
 linear
  spherical_mapping
  color_map {
  [0 color rgbt <1,1,1,1> ]
  [.31 color rgbt <.1,.1,1,.998>  ]
  [.8 color rgbt <1,.1,1,.9995>  ]
  [1 color rgbt <1,.1,.1,.9996>  ]
  }
  aa_level 8        // Level of binary subdivision in case of aa
  aa_threshold 0.1  // Threshold for aa to push in
  jitter 0.2        // Amount of sample jittering
  scale <52,47,60>
translate <0,-3,180>
}

 }
 }


sphere { <0,-18000,0>,17088
       hollow
       texture {
              T_Grnt2 scale 800
               }
       finish { ambient 0
       		reflection 0
		}
       }

plane { y,-80  
	texture { Water scale 900 }
	hollow
}
/*
 union {
    plane { y, 150
        texture {
pigment { color Clear }
            //T_Cloud3
            scale <100,30,200>
        }
    }
    plane { y, 300
        texture {
            pigment { color Clear }
            //scale <90,10,600>
            scale 200
            translate x*300
            rotate -30*y
        }
    }
hollow
}
*/


object { Plant hollow translate <30,-38,149> scale 12.13 }
/*
object { Plant hollow translate <-30,-53,142> scale 10.7 }

object { Plant hollow translate <30,-38,124> scale 9.10 }
object { Plant hollow translate <-30,-40,134> scale 9.7 }
object { Plant hollow translate <30,-40,109> scale 14.12 }
object { Plant hollow translate <-30,-42,107> scale 9.565 }
object { Plant hollow translate <31,-46,89> scale 10.432 }
object { Plant hollow translate <-30,-47,78> scale 9.432 }


object { Plant hollow translate <30,-48,63> scale 9.257 }
object { Plant hollow translate <-39,-50,60> scale 10.108 }
object { Plant hollow translate <42,-50,43> scale 9.153 }
*/
object { Plant hollow translate <-11,-50,44> scale 9.434 }

