#declare Tanwood =
  texture {
    pigment {
      wood
      turbulence <0.095, 0.12, 1>
      octaves 3.4
      scale <0.15, .15, 1>
      translate -x*100
      color_map {
        [0.00 rgb <0.659, 0.600, 0.278>]
        [0.35 rgb <0.784, 0.745, 0.318>]
        [0.50 rgb <0.290, 0.231, 0.004>]
        [0.85 rgb <0.784, 0.745, 0.318>]
        [1.00 rgb <0.659, 0.600, 0.278>]
      }
    }
    normal {
      wood 0.25
      turbulence <0.05, 0.08, 1>
      octaves 4
      scale <0.15, .15, 1>
      translate -x*100
      sine_wave
    }
  }
  texture {
    pigment {
      wood
      turbulence <0.075, 0.035, 0>
      octaves 3.4
      omega 0.95
      scale <0.175, 0.175, 1>
      rotate x*20
      color_map {
        [0.00 rgbf <0.5569, 0.5098, 0.2353, 0.00>]
        [0.42 rgbf <0.1647, 0.1294, 0.0000, 0.44>]
        [0.56 rgbf <0.6510, 0.6196, 0.2627, 1.00>]
        [0.70 rgbf <0.1647, 0.1294, 0.0000, 1.00>]
        [0.88 rgbf <0.6510, 0.6196, 0.2627, 1.00>]
        [1.00 rgbf <0.5569, 0.5098, 0.2353, 0.00>]
      }
    }
    finish {
      brilliance 1.43
      specular 0.6
      roughness 0.04
    }
  }



#declare Blackwood =
  texture {
    pigment {
      wood
      turbulence 0.04
      octaves 4
      omega 1.25
      scale <0.15, .15, 1>
      color_map {
        [0.0 rgb <0.10, 0.08, 0.05>]
        [0.3 rgb <0.17, 0.13, 0.08>]
        [0.6 rgb <0.22, 0.12, 0.07>]
        [1.0 rgb <0.10, 0.08, 0.05>]
      }
    }
/*
    normal {
      wood 0.25
      turbulence 0.04
      octaves 4
      omega 1.25
      scale <0.15, .15, 1>
      sine_wave
    }
*/
  }
  texture {
    pigment {
      bozo
      turbulence <0.03, 0.03, 0.1>
      octaves 5
      lambda 3.25
      scale <0.025, .025, 1.0>
      color_map {
        [0.0 rgbf<0.22, 0.17, 0.18, 0.00>]
        [0.5 rgbf<0.17, 0.12, 0.11, 0.43>]
        [0.6 rgbf<0.19 0.22, 0.19, 0.20>]
        [0.8 rgbf<0.17, 0.12, 0.11, 0.43>]
        [1.0 rgbf<0.22, 0.17, 0.18, 0.00>]
      }
    }

    normal {
      bozo 0.1
      turbulence <0.03, 0.03, 0.1>
      octaves 5
      lambda 3.25
      scale <0.025, .025, 1.0>
      sine_wave
    }

    finish {
      brilliance 1.43
      specular 0.6
      roughness 0.04
    }
  }

#declare Rosewood =
  texture {
    pigment {
      wood
      turbulence <0.095, 0.12, 1>
      octaves 3.4
      scale <0.15, .15, 1>
      translate -x*100
      color_map {
        [0.00 rgb <0.25, 0.10, 0.10>]
        [0.30 rgb <0.15, 0.10, 0.10>]
        [0.75 rgb <0.60, 0.15, 0.10>]
        [1.00 rgb <0.25, 0.10, 0.10>]
      }
    }
/*
    normal {
      wood 0.25
      turbulence <0.05, 0.08, 1>
      octaves 4
      scale <0.15, .15, 1>
      translate -x*100
      sine_wave
    }
*/
  }
  texture {
    pigment {
      wood
      turbulence <0.075, 0.035, 0>
      octaves 3.4
      omega 0.95
      scale <0.175, 0.175, 1>
      rotate x*20
      color_map {
        [0.0 rgbf <0.15, 0.10, 0.10, 0.00>]
        [0.3 rgbf <0.25, 0.10, 0.10, 0.44>]
        [0.5 rgbf <0.63, 0.15, 0.10, 1.00>]
        [0.7 rgbf <0.63, 0.15, 0.10, 0.44>]
        [1.0 rgbf <0.15, 0.10, 0.10, 0.00>]
      }
    }

    normal {
      wood 0.1
      turbulence <0.075, 0.035, 0>
      octaves 3.4
      omega 0.95
      scale <0.175, 0.175, 1>
      rotate x*20
      sine_wave
    }

    finish {
      brilliance 1.43
      specular 0.6
      roughness 0.04
    }
  }

#declare WM1=
  texture {
    pigment {
      bozo
      turbulence <0.15, 0.6, 0.3>
      color_map {
        [0.0 rgb<0.75, 0.70, 0.60>]
        [0.3 rgb<0.91, 0.89, 0.85>]
        [1.0 rgb<0.82, 0.82, 0.43>]
      }
    }
    normal {
      bozo 0.25
      turbulence <0.15, 0.6, 0.3>
      sine_wave
    }
    scale <0.25, 0.125, 0.5>
  }
  texture {
    pigment {
      marble
      turbulence <0.715, 0.96, 0.43>
      color_map {
        [0.0 rgbf<0.75, 0.27, 0.16, 0.00>]
        [0.3 rgbf<0.91, 0.89, 0.85, 0.44>]
        [1.0 rgbf<0.82, 0.82, 0.43, 0.60>]
      }
    }

    normal {
      marble
      turbulence <0.715, 0.96, 0.43>
    }

    finish {
      specular 0.341
      roughness 0.2
    }
    scale <2.5, 1.25, 1.5>
  }


#declare Long_Block=
  box {<-6, 0.2, -1>, <6, 0, 1>}

#declare Short_Block=
  box {<-4, 0.2, -1>, <4, 0, 1>}



#declare R1=seed(71923)
#declare ZT=-98
#declare XT=-139

#declare Floor1=
  union {
    #while (ZT < 84)
      #while (XT < 98)
        //OUTER PIECE, SOUTH END
        object {
          Long_Block
          #if (rand(R1) < 0.1)
            rotate <(rand(R1)/8), (rand(R1)/8), (-rand(R1)/8)>
          #end
          translate <-1, 0, -6>
          texture {
            Rosewood
            rotate <(rand(R1)*20), (rand(R1)*30), (rand(R1)*40)>
            scale 4
          }
          translate <XT, -15, ZT>
        }
        //OUTER PIECE, NORTH END
        object {
          Long_Block
          #if (rand(R1) < 0.1)
            rotate <(rand(R1)/8), (rand(R1)/8), (-rand(R1)/8)>
          #end
          translate <1, 0, 6>
          texture {
            Rosewood
            rotate <(rand(R1)*20), (rand(R1)*30), (rand(R1)*40)>
            scale 4
          }
          translate <XT, -15, ZT>
        }
        //OUTER PIECE, WEST END
        object {
          Long_Block
          rotate <0, 90, 0>
          #if (rand(R1) < 0.1)
            rotate <(rand(R1)/8), (rand(R1)/8), (-rand(R1)/8)>
          #end
          translate <-6, 0, 1>
          texture {
            Rosewood
            rotate <(rand(R1)*20), (rand(R1)*30), (rand(R1)*40)>
            scale 4
          }
          translate <XT, -15, ZT>
        }
        //OUTER PIECE, EAST END
        object {
          Long_Block
          rotate <0, 90, 0>
          #if (rand(R1) < 0.1)
            rotate <(rand(R1)/8), (rand(R1)/8), (-rand(R1)/8)>
          #end
          translate <6, 0, -1>
          texture {
            Rosewood
            rotate <(rand(R1)*20), (rand(R1)*30), (rand(R1)*40)>
            scale 4
          }
          translate <XT, -15, ZT>
        }
/////////////////////////////////////////
        //INNER PIECE, SOUTH END
        object {
          Short_Block
          #if (rand(R1) < 0.1)
            rotate <(rand(R1)/8), (rand(R1)/8), (-rand(R1)/8)>
          #end
          translate <1, 0, -4>
          texture {
            Blackwood
            rotate <(rand(R1)*10), (rand(R1)*20), (rand(R1)*30)>
            scale 4
          }
          translate <XT, -15, ZT>
        }
        //INNER PIECE, NORTH END
        object {
          Short_Block
          #if (rand(R1) < 0.1)
            rotate <(rand(R1)/8), (rand(R1)/8), (-rand(R1)/8)>
          #end
          translate <-1, 0, 4>
          texture {
            Blackwood
            rotate <(rand(R1)*10), (rand(R1)*20), (rand(R1)*30)>
            scale 4
          }
          translate <XT, -15, ZT>
        }
        //INNER PIECE, WEST END
        object {
          Short_Block
          rotate <0, 90, 0>
          #if (rand(R1) < 0.1)
            rotate <(rand(R1)/8), (rand(R1)/8), (-rand(R1)/8)>
          #end
          translate <-4, 0, -1>
          texture {
            Blackwood
            rotate <(rand(R1)*10), (rand(R1)*20), (rand(R1)*30)>
            scale 4
          }
          translate <XT, -15, ZT>
        }
        //INNER PIECE, EAST END
        object {
          Short_Block
          rotate <0, 90, 0>
          #if (rand(R1) < 0.1)
            rotate <(rand(R1)/8), (rand(R1)/8), (-rand(R1)/8)>
          #end
          translate <4, 0, 1>
          texture {
            Blackwood
            rotate <(rand(R1)*10), (rand(R1)*20), (rand(R1)*30)>
            scale 4
          }
          translate <XT, -15, ZT>
        }
///////////////////////////////////////////////////
        superellipsoid { <0.1, 0.1>
          scale <3, 0.1, 3>
          translate <0, -0.1, 0>
          translate <XT, -15, ZT>
          texture {
            WM1
            rotate <(rand(R1)*65), (rand(R1)*-43), (rand(R1)*-93)>
          }
        }
////////////////////////////////////////////////
///////////////////////////////////////////////
        //OUTER PIECE, SOUTH END
        object {
          Long_Block
          #if (rand(R1) < 0.1)
            rotate <(rand(R1)/8), (rand(R1)/8), (-rand(R1)/8)>
          #end
          translate <-1, 0, -6>
          texture {
            Rosewood
            rotate <(rand(R1)*20), (rand(R1)*30), (rand(R1)*40)>
            scale 4
          }
          translate <(XT+7), -15, (ZT+14)>
        }
        //OUTER PIECE, NORTH END
        object {
          Long_Block
          #if (rand(R1) < 0.1)
            rotate <(rand(R1)/8), (rand(R1)/8), (-rand(R1)/8)>
          #end
          translate <1, 0, 6>
          texture {
            Rosewood
            rotate <(rand(R1)*20), (rand(R1)*30), (rand(R1)*40)>
            scale 4
          }
          translate <(XT+7), -15, (ZT+14)>
        }
        //OUTER PIECE, WEST END
        object {
          Long_Block
          rotate <0, 90, 0>
          #if (rand(R1) < 0.1)
            rotate <(rand(R1)/8), (rand(R1)/8), (-rand(R1)/8)>
          #end
          translate <-6, 0, 1>
          texture {
            Rosewood
            rotate <(rand(R1)*20), (rand(R1)*30), (rand(R1)*40)>
            scale 4
          }
          translate <(XT+7), -15, (ZT+14)>
        }
        //OUTER PIECE, EAST END
        object {
          Long_Block
          rotate <0, 90, 0>
          #if (rand(R1) < 0.1)
            rotate <(rand(R1)/8), (rand(R1)/8), (-rand(R1)/8)>
          #end
          translate <6, 0, -1>
          texture {
            Rosewood
            rotate <(rand(R1)*20), (rand(R1)*30), (rand(R1)*40)>
            scale 4
          }
          translate <(XT+7), -15, (ZT+14)>
        }
/////////////////////////////////////////
        //INNER PIECE, SOUTH END
        object {
          Short_Block
          #if (rand(R1) < 0.1)
            rotate <(rand(R1)/8), (rand(R1)/8), (-rand(R1)/8)>
          #end
          translate <1, 0, -4>
          texture {
            Blackwood
            rotate <(rand(R1)*10), (rand(R1)*20), (rand(R1)*30)>
            scale 4
          }
          translate <(XT+7), -15, (ZT+14)>
        }
        //INNER PIECE, NORTH END
        object {
          Short_Block
          #if (rand(R1) < 0.1)
            rotate <(rand(R1)/8), (rand(R1)/8), (-rand(R1)/8)>
          #end
          translate <-1, 0, 4>
          texture {
            Blackwood
            rotate <(rand(R1)*10), (rand(R1)*20), (rand(R1)*30)>
            scale 4
          }
          translate <(XT+7), -15, (ZT+14)>
        }
        //INNER PIECE, WEST END
        object {
          Short_Block
          rotate <0, 90, 0>
          #if (rand(R1) < 0.1)
            rotate <(rand(R1)/8), (rand(R1)/8), (-rand(R1)/8)>
          #end
          translate <-4, 0, -1>
          texture {
            Blackwood
            rotate <(rand(R1)*10), (rand(R1)*20), (rand(R1)*30)>
          }
          translate <(XT+7), -15, (ZT+14)>
        }
        //INNER PIECE, EAST END
        object {
          Short_Block
          rotate <0, 90, 0>
          #if (rand(R1) < 0.1)
            rotate <(rand(R1)/8), (rand(R1)/8), (-rand(R1)/8)>
          #end
          translate <4, 0, 1>
          texture {
            Blackwood
            rotate <(rand(R1)*10), (rand(R1)*20), (rand(R1)*30)>
            scale 4
          }
          translate <(XT+7), -15, (ZT+14)>
        }
///////////////////////////////////////////////////
        superellipsoid { <0.1, 0.1>
          scale <3, 0.1, 3>
          translate <0, -0.1, 0>
          translate <(XT+7), -15, (ZT+14)>
          texture {
            WM1
            rotate <(rand(R1)*65), (rand(R1)*-43), (rand(R1)*-93)>
          }
        }
        #declare XT=XT+14
      #end
      #declare ZT=ZT+28
      #declare XT=-139
  #end
/*
  clipped_by {
    box {<-87.0, -19.0, -60.0>, < 87.0, -10.0,  60.0>}
  }
*/
}

