#version 3.0
global_settings { assumed_gamma 2.1 }

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "Night_Molding1.inc"
#include "Night_Walls.inc"
#include "Night_Floor5.inc"

//~~~ TEXTURE FOR FRAME AND SUPPORT ROD OF NIGHT PLAQUE ~~~\\

#declare B_Brass=
  texture {
    pigment {color rgb<.96, .69, .35>}
    normal {bumps -0.25 scale <0.25, 1.0, 0.25> rotate <0, 0, -45>}
    finish {specular 0.0521342 roughness 0.05 brilliance 1.71}
  }
  texture {
    pigment {color rgbf<.86, .59, .37, 0.6>}
    normal {bumps -0.25 scale <0.25, 1.0, 0.25> rotate <10, -20, -25>}
    finish {specular 0.0521342 roughness 0.05 brilliance 1.71}
  }

//~~~ TEXTURE FOR BASE UNDER NIGHT ~~~\\

#declare BrownStone=
  texture {
    pigment {
      bozo
      turbulence 0.314
      color_map {
        [0.0, rgb<0.75, 0.71, 0.60>]
        [1.0, rgb<0.65, 0.60, 0.55>]
      }
    }
    normal {
      bozo 0.42
      turbulence 0.314
    }
    finish {
      specular 0.05
      roughness 0.3
      brilliance 1.72
    }
  }
  texture {
    pigment {
      agate
    turbulence 0.2025
      color_map {
        [0.00, rgbf<0.847, 0.749, 0.847, 0.25>]
        [0.00, rgbf<0.647, 0.549, 0.647, 0.25>]
        [0.50, rgbf<0.361, 0.183, 0.034, 0.25>]
        [0.50, rgbf<0.461, 0.283, 0.064, 0.25>]
        [0.50, rgbf<0.361, 0.183, 0.034, 0.25>]
        [1.00, rgbf<0.256, 0.142, 0.05, 0.25>]
        [1.00, rgbf<0.356, 0.242, 0.09, 0.25>]
      }
    }
    normal {
      agate 0.32
      turbulence 0.2025
    }
    finish {
      specular 0.10
      roughness 0.3
      brilliance 1.72
    }
    rotate <45, 20, 30>
    translate <10, -15, -30>
    scale 6.25
  }

//~~~ TEXTURE FOR SOTNE BASE UNDER CORAL SUN ~~~\\

#declare Blood_Crack=
  texture {
    pigment {
      marble
      turbulence 0.6314
      color_map {
        [0.0, rgb<0.35, 0.0, 0.0>]
        [0.025, rgb<0.75, 0.1371, 0.276>]
        [0.275, rgb<0.25, 0.35, 0.45>]
        [0.3, rgb<0.05, 0.15, 0.25>]
        [0.325, rgb<0.25, 0.35, 0.45>]
        [0.975, rgb<0.65, 0.60, 0.55>]
        [1.0, rgb<0.45, 0.40, 0.35>]
      }
    }
    normal {
      marble 0.5
      turbulence 0.6314
    }
    finish {
      specular 0.15
      roughness 0.3
    }
  }
  texture {
    pigment {
      agate
    turbulence 0.2025
      color_map {
        [0.0,   rgbf<0.35, 0.0,    0.0,   0.6>]
        [0.025, rgbf<0.75, 0.1371, 0.276, 0.6>]
        [0.275, rgbf<0.25, 0.35,   0.45,  0.6>]
        [0.3,   rgbf<0.05, 0.15,   0.25,  0.6>]
        [0.325, rgbf<0.25, 0.35,   0.45,  0.6>]
        [0.975, rgbf<0.65, 0.60,   0.55,  0.6>]
        [1.0,   rgbf<0.45, 0.40,   0.35,  0.6>]
      }
    }
    normal {
      agate 0.5
      turbulence 0.2025
    }
    finish {
      specular 0.15
      roughness 0.3
    }
    rotate <45, 20, 30>
    translate <10, -15, -30>
  }

//~~~ TEXTURE FOR ALL TEXT OBJECTS AND ROD HOLDING CORAL SUN ~~~\\

#declare Old_Steel1=
  texture {
    pigment {color rgb<.13, .13, .13>}
    finish {specular 0.342 roughness 0.05}
  }

//~~~ CAMERA ~~~\\

camera {
  right      <1.333, 0.0,  0.0>
  up         < 0.0,   1.0,  0.0>
  direction  < 0.0,   0.0,  1.0>
////  location   <  35.0,  15.0, -55.5>
////  look_at    < -45.0, -5.0,  47.5>
  location   <  12.0,  15.0, -40.5>
  look_at    < -21.0, -5.0,  47.5>
}

//~~~ LIGHTS IN NORTH HALL ~~~\\

light_source {<-62.5, 60.0,  79.0> color rgb<0.25, 0.25, 0.2>}
light_source {< 62.5, 60.0,  79.0> color rgb<0.25, 0.25, 0.2>}

//~~~ LIGHTS IN MAIN ROOM ~~~\\

light_source {<0, 55.0,  -2.5> color White}
light_source {<-43.5, 60.0, -30.0> color rgb<0.25, 0.25, 0.2>}
light_source {<-43.5, 60.0,  30.0> color rgb<0.25, 0.25, 0.2>}


//~~~ SPOTLIGHTS FOR NIGHT ~~~\\

light_source {
    <-10, 15, -42.5>
    color rgb<0.95, 0.95, 0.775>
    spotlight
    point_at <0, 0, -2.5>
    radius 15
    falloff 20
    tightness 1.5
}

light_source {
    <10, 15, -42.5>
    color rgb<0.95, 0.95, 0.775>
    spotlight
    point_at <0, 0, -2.5>
    radius 15
    falloff 20
    tightness 1.5
}

//~~~ SPOOTLIGHT FOR CORAL SUN ~~~\\

light_source {
    <-45, 60, 7.5>
    color rgb<0.95, 0.95, 0.775>
    spotlight
    point_at <-65, 5, 27.5>
    radius 15
    falloff 20
    tightness 1.5
}

//~~~ TEMPORARY FLOOR ~~~\\

//box {<-87.0, -15.0, -60.0>, < 87.0, -16.0,  60.0> pigment {color Brown}}

//~~~ THIS IS THE STONE BASE FOR THE NIGHT OBJECT ~~~\\

difference {
  box {<-21.0, -15.0,  -10.0>, < 21.0, -10.0,   5.0>}
  cylinder {<-20.0, -9.5, -9.0>, <20.0, -9.5, -9.0>, 1}
  cylinder {<-20.0, -9.5, 4.0>, <20.0, -9.5, 4.0>, 1}
  cylinder {<-20.0, -9.5, -9.0>, <-20.0, -9.5, 4.0>, 1}
  cylinder {<20.0, -9.5, -9.0>, <20.0, -9.5, 4.0>, 1}

  cylinder {<-21.0, -10.0, -10.0>, <21.0, -10.0, -10.0>, 1}
  cylinder {<-21.0, -10.0, 5.0>, <21.0, -10.0, 5.0>, 1}
  cylinder {<-21.0, -10.0, -10.0>, <-21.0, -10.0, 5.0>, 1}
  cylinder {<21.0, -10.0, -10.0>, <21.0, -10.0, 5.0>, 1}
  texture {BrownStone}
}

//~~~ THIS IS THE ROD FOR THE PLAQUE FOR THE NIGHT OBJECT ~~~\\

box {<-0.5, -15, -0.5>, <0.5, -5, 0.5>
  texture {B_Brass scale 0.25}
  translate <0, 0, -15>
}

//~~~ THIS DEFINES A SIDE OF THE FRAME HOLDING THE PLAQUE ~~~\\
//~~~ FOR THE NIGHT OBJECT ~~~\\

#declare SG1=
  difference {
    box {<-4, -0.5, -4>, <4, 0.5, 4>}
    box {<-3, -0.4, -3>, <3, 1.0, 3>}
    plane {z, 0 rotate <0, 45, 0>}
    plane {z, 0 rotate <0, -45, 0>}
    texture {B_Brass scale 0.25}
//    rotate <-45, 0, 0>
//    translate <0, -5, -15>
  }


object {SG1
  rotate <0, 0, 1>
  rotate <-22.5, 0, 0>
  translate <0, -5, -15>
}

object {SG1
  rotate <0, 90, 0>
  rotate <-22.5, 0, 0>
  translate <0, -5, -15>
}

object {SG1
  rotate <0, -90, 0>
  rotate <-22.5, 0, 0>
  translate <0, -5, -15>
}

object {SG1
  rotate <0, 0, -1>
  rotate <0, 180, 0>
  rotate <-22.5, 0, 0>
  translate <0, -5, -15>
}

//~~~ THIS BOX IS THE PLAQUE FOR THE NIGHT OBJECT ~~~\\

box {<-3, -0.4, -3>, <3, 0.4, 3>
  pigment {color White}
  rotate <-22.5, 0, 0>
  translate <0, -5, -15>
}

//~~~ THE FOLLOWING TEXT OBJECTS ARE ON THE PLAQUE FOR THE NIGHT OBJECT ~~~\\

text { ttf "../include/fonts/verdanab.ttf" "NIGHT" 1, 0
  texture {Old_Steel1}
  scale 1.5
  translate <-2.65, 1.5, -0.405>
  rotate <67.5, 0, 0>
  translate <0, -5, -15>
}

text { ttf "../include/fonts/verdana.ttf" "By" 1, 0
  texture {Old_Steel1}
  translate <-0.65, 0, -0.405>
  rotate <67.5, 0, 0>
  translate <0, -5, -15>
}

text { ttf "../include/fonts/verdana.ttf" "Witherin" 1, 0
  texture {Old_Steel1}
  translate <-2.1, -1.5, -0.405>
  rotate <67.5, 0, 0>
  translate <0, -5, -15>
}

text { ttf "../include/fonts/verdana.ttf" "(A study in ceramics)" 1, 0
  texture {Old_Steel1}
  scale 0.5
  translate <-2.65, -2.55, -0.405>
  rotate <67.5, 0, 0>
  translate <0, -5, -15>
}

//~~~ DEFINITION OF CORAL SUN OBJECT ~~~\\

#declare X2=
  blob {
    threshold 0.65
    #declare Count1=0
    #while (Count1 < 370)
    cylinder {<0, 0, 1>, <0, 0, 2>, 1, 1
      scale <1.75, 0.35, 1>
      rotate <(5+Count1), (10+Count1), (15+Count1)>
      texture {
        pigment {color rgb<(0.5+(Count1/180)), (0.5+(Count1/360)), (0.1+(Count1/720))>}
        normal {
          crackle -3.5
          turbulence 0.732
        }
        finish {
          specular 0.23
          roughness 0.15
          brilliance 1.52
        }
      }
    }
    cylinder {<0, 0, 1>, <0, 0, 2>, 1, 1
      scale <1.75, 0.35, 1>
      rotate <(-5-Count1), (-10-Count1), (-15-Count1)>
      texture {
        pigment {color rgb<(0.5+(Count1/180)), (0.5+(Count1/360)), (0.1+(Count1/720))>}
        normal {
          crackle -3.5
          turbulence 0.732
        }
        finish {
          specular 0.23
          roughness 0.15
          brilliance 1.52
        }
      }
    }
    cylinder {<1, 0, 0>, <2, 0, 0>, 1, 1
      scale <1.75, 0.35, 1>
      rotate <(5+Count1), (10+Count1), (15+Count1)>
      texture {
        pigment {color rgb<(0.5+(Count1/180)), (0.5+(Count1/360)), (0.1+(Count1/720))>}
        normal {
          crackle -3.5
          turbulence 0.732
        }
        finish {
          specular 0.23
          roughness 0.15
          brilliance 1.52
        }
      }
    }
    cylinder {<1, 0, 0>, <2, 0, 0>, 1, 1
      scale <1.75, 0.35, 1>
      rotate <(-5-Count1), (-10-Count1), (-15-Count1)>
      texture {
        pigment {color rgb<(0.5+(Count1/180)), (0.5+(Count1/360)), (0.1+(Count1/720))>}
        normal {
          crackle -3.5
          turbulence 0.732
        }
        finish {
          specular 0.23
          roughness 0.15
          brilliance 1.52
        }
      }
    }
    #declare Count1=Count1+15
    #end
  }

//~~~ PLACEMENT OF CORAL SUN ~~~\\

object {X2 scale 3 rotate <-10, -45, -10> translate <-65, 15, 26.5>}

//~~~ ROD HOLDING CORAL SUN OBJECT IN PLACE ON IT'S STAND ~~~\\

cylinder {<-65, 0, 27.5>, <-65, 15, 27.5>, 0.5
  texture {Old_Steel1}
}

//~~~ BLOOD_CRACK STONE STAND FOR THE CORAL SUN OBJECT ~~~\\

difference {
  box {<-70.0, -15.0,  22.5>, <-60.0,   5.0,  32.5>}
  box {<-61, 4.0, 23.5>, <-59, -4.0, 31.5>}
  texture {Blood_Crack scale <4, 5, 4> rotate <20, -30, -45>}
}

//~~~ PLAQUE ON THE STAND FOR THE CORAL SUN OBJECT ~~~\\

box {<-61, 4.0, 23.5>, <-60.2, -4.0, 31.5>
  pigment {color White}
}

//~~~ THE FOLLOWING TEXT OBJECTS CREATE THE WORDS FOR THE PLAQUE ~~~\\
//~~~ ON THE STAND FOR THE CORAL SUN OBJECT ~~~\\

text { ttf "../include/fonts/verdanab.ttf" "CORAL" 1, 0
  texture {Old_Steel1}
  scale 1.75
  translate <-3.25, 2, 0.195>
  rotate <0, -90, 0>
  translate <-60, 0, 27.5>
}

text { ttf "../include/fonts/verdanab.ttf" "SUN" 1, 0
  texture {Old_Steel1}
  scale 1.75
  translate <-2, 0, 0.195>
  rotate <0, -90, 0>
  translate <-60, 0, 27.5>
}

text { ttf "../include/fonts/verdana.ttf" "By Witherin" 1, 0
  texture {Old_Steel1}
  translate <-2.7, -2.5, 0.195>
  rotate <0, -90, 0>
  translate <-60, 0, 27.5>
}

text { ttf "../include/fonts/verdana.ttf" "(A study in ceramics)" 1, 0
  texture {Old_Steel1}
  scale 0.5
  translate <-2.6, -3.75, 0.195>
  rotate <0, -90, 0>
  translate <-60, 0, 27.5>
}

//////////////////////////////////////////////////
///////////////////////////////////////
//////////////////////////
/////////////
/////
//

//~~~ TEXTURE FOR THE MOONS ON THE NIGHT OBJECT ~~~\\

#declare Moon1=
  texture {
    pigment {
      bozo
      turbulence 0.1
      color_map {
        [0.0, rgb<0.7, 0.7, 0.7>]
        [1.0, rgb<0.35, 0.35, 0.35>]
      }
    }
    finish {
      specular 0.3
      roughness 0.03
    }
  }

//~~~ TEXTURE FOR THE NIGHT SKY IN THE NIGHT OBJECT ~~~\\

#declare Space1=
  texture {
    pigment {granite turbulence .125
      color_map {
        [0.0000, rgb<0.00, 0.00, 0.00>]
        [0.3185, rgb<0.00, 0.00, 0.00>]
        [0.3350, rgb<0.79, 0.79, 1.00>]
        [0.3515, rgb<0.00, 0.00, 0.00>]
        [0.5000, rgb<0.00, 0.00, 0.00>]
        [0.6485, rgb<0.00, 0.00, 0.00>]
        [0.6650, rgb<1.00, 0.79, 0.79>]
        [0.6815, rgb<0.00, 0.00, 0.00>]
        [1.0000, rgb<0.00, 0.00, 0.00>]
      }
    }
    finish {
      specular 0.3
      roughness 0.03
    }
    rotate <10, 20, 30>
    scale 1.5
  }

//~~~ BLACK SPECKS IN THE WATER ON THE NIGHT OBJECT ~~~\\

#declare BT1=
  texture {
    pigment {
      color rgb<0.01, 0.01, 0.01>
    }
    finish {
      specular 0.3
      roughness 0.03
    }
  }

//~~~ BLUE OF THE WATER IN THE NIGHT OBJECT ~~~\\

#declare BT2=
  texture {
    pigment {
      color rgb<0, 0, 0.5>
    }
    finish {
      specular 0.3
      roughness 0.03
    }
  }

//~~~ PART OF THE MOON'S REFLECTION IN THE WATER OF THE NIGHT OBJECT ~~~\\

#declare BT3=
  texture {
    pigment {
      color rgb<0.7, 0.7, 0.7>
    }
    finish {
      specular 0.3
      roughness 0.03
    }
  }

//~~~ PART OF THE MOON'S REFLECTION IN THE WATER OF THE NIGHT OBJECT ~~~\\

#declare BT4=
  texture {
    pigment {
      color rgb<1.27, 1.27, 1.27>
    }
    finish {
      specular 0.3
      roughness 0.03
    }
  }

//~~~ DARKER BLUE OF THE WATER IN THE NIGHT OBJECT ~~~\\

#declare BT5=
  texture {
    pigment {
      color rgb<0, 0, 0.15>
    }
    finish {
      specular 0.3
      roughness 0.03
    }
  }

#declare BT6=
  texture {
    pigment {
      color Yellow
    }
    finish {
      specular 0.3
      roughness 0.03
//      reflection 0.25
    }
  }

/////////////////////////////////////////
/////////////////////////////////
///////////////////
////////
//

//~~~ PANEL5 IS THE CENTRAL PIECE THAT CURVES AWAY FROM THE CAMERA ~~~\\

#declare Count1=-5       // X COORDINATE
#declare Count2=-1       // Z COORDINATE
#declare Count3=10       // Y COORDINATE
#declare Sun1=0          // ROTATIONAL ANGLE FOR MOON
#declare R1=seed(71023)  // RANDOM SEED FOR OCEAN TEXTURING

#declare Panel5=
  blob {
    threshold 0.65
      #while (Count3 > -10)
        #while (Count1 < 5)
          sphere {<0, 0, 0>, 1, 1
            scale <1, 0.5, 1>
            rotate <25, 0, 0>
            translate <Count1, Count3, (sin(Count2)*2)>
            // DETERMINING COLOR OF OBJECT.
            // BLACK ON TOP, WITH SMALL STARS OF WHITE.
            // BLUE ON BOTTOM.
            // DARK TONES WHERE RANDOMIZER HITS BETWEEN 0.5 AND 1.0
            #if (Count3 > 0)
              texture {Space1}  // NIGHT SKY
            #else
              #if (rand(R1) > 0.5)
                #switch (Count1)
                  #range (-3.25, 3.25)
                    texture {BT3}  // REFLECTION OF THE MOON
                  #break
                #else
                  texture {BT2}  // OCEAN AT NIGHT
                #end
              #end
            #end
          }
          #declare Count1=Count1+0.25
          #declare Count2=Count2+0.125
        #end
        #declare Count1=-5
        #declare Count2=-1
        #declare Count3=Count3-0.25
      #end
    // RIGHT-HAND SIDE OF MOON PORTION, ON -Z SIDE
    #while ( Sun1 < 85 )
      sphere {<0, 0, 0>, 1, 1
        scale <2.5, 0.5, 0.5>
        translate <2.5, 0, 0>
        rotate <0, 0, Sun1>
        translate <-2.5, 0, 0>
        rotate <0, 35, 0>
        translate <2, 0, 0>
        #declare Sun1=Sun1+2.5
        texture {Moon1}
      }
    #end
    #declare Sun1=0
    // LEFT-HAND SIDE OF MOON PORTION, ON -Z SIDE
    #while ( Sun1 < 85 )
      sphere {<0, 0, 0>, 1, 1
        scale <2.5, 0.5, 0.5>
        translate <-2.5, 0, 0>
        rotate <0, 0, -Sun1>
        translate <2.5, 0, 0>
        rotate <0, -35.5, 0>
        translate <-1.5, 0, 0>
        #declare Sun1=Sun1+2.5
        texture {Moon1}
      }
    #end
    // CENTRAL SEGMENT TO JOIN THE TWO PORTIONS OF THE MOON
    sphere {<0, 0, 0>, 2, 1 scale <0.5, 2, 0.25> translate <0, 2, 1> texture {Moon1}}
    #declare Sun1=0
    // RIGHT-HAND SIDE OF MOON PORTION, ON +Z SIDE
    #while ( Sun1 < 85 )
      sphere {<0, 0, 0>, 1, 1
        scale <2.5, 0.5, 0.5>
        translate <2.5, 0, 0>
        rotate <0, 0, Sun1>
        translate <-2.5, 0, 0>
        rotate <0, 35, 0>
        translate <2, 0, 2>
        #declare Sun1=Sun1+2.5
        texture {Moon1}
      }
    #end
    #declare Sun1=0
    // LEFT-HAND SIDE OF MOON PORTION, ON +Z SIDE
    #while ( Sun1 < 85 )
      sphere {<0, 0, 0>, 1, 1
        scale <2.5, 0.5, 0.5>
        translate <-2.5, 0, 0>
        rotate <0, 0, -Sun1>
        translate <2.5, 0, 0>
        rotate <0, -35.5, 0>
        translate <-1.5, 0, 2>
        #declare Sun1=Sun1+2.5
        texture {Moon1}
      }
    #end
    // CENTRAL SEGMENT TO JOIN THE TWO PORTIONS OF THE MOON
  }


//~~~ PANEL6 IS THE LEFT-HAND PIECE THAT CURVES TOWARDS THE CAMERA ~~~\\

#declare Count1=-13
#declare Count2=-4
#declare Count3=10

#declare Panel6=
  blob {
    threshold 0.65
      #while (Count3 > -10)
        #while (Count1 < -3)
          sphere {<0, 0, 0>, 1, 1 scale <1, 0.5, 1> rotate <25, 0, 0>
            translate <Count1, Count3, (sin(Count2)*2-4)>
            #if (Count3 > 0)
              texture {Space1}
            #else
              #if (rand(R1) > 0.5)
                texture {BT5}  // OCEAN AT NIGHT
              #else
                texture {BT2}  // OCEAN AT NIGHT
              #end
            #end
          }
          #declare Count1=Count1+0.25
          #declare Count2=Count2+0.125
        #end
        #declare Count1=-13
        #declare Count2=-4
        #declare Count3=Count3-0.25
      #end
  }

//~~~ PANEL7 IS THE RIGHT-HAND PIECE THAT CURVES TOWARDS THE CAMERA ~~~\\

#declare Sun1=0          // ROTATIONAL ANGLE FOR MOON
#declare Count1=13
#declare Count2=-4
#declare Count3=10

#declare Panel7=
  blob {
    threshold 0.65
      #while (Count3 > -10)
        #while (Count1 > 3)
          sphere {<0, 0, 0>, 1, 1 scale <1, 0.5, 1> rotate <25, 0, 0>
            translate <Count1, Count3, (sin(Count2)*2-4)>
            #if (Count3 > 0)
              texture {Space1}  // NIGHT SKY
            #else
              #if (rand(R1) > 0.5)
                #switch (Count1)
                  #range (7, 9)
                    texture {BT3}  // REFLECTION OF THE MOON
                  #break
                #else
                  texture {BT2}  // OCEAN AT NIGHT
                #end
              #end
            #end
          }
          #declare Count1=Count1-0.25
          #declare Count2=Count2+0.125
        #end
        #declare Count1=13
        #declare Count2=-4
        #declare Count3=Count3-0.25
      #end
      #declare Sun1=-77
    // RIGHT-HAND SIDE OF SUN PORTION, -Z SIDE
    #while ( Sun1 < 77 )
      sphere {<0, 0, 0>, 1, 1
        scale <1.5, 0.5, 0.5>
        translate <1.5, 0, 0>
        rotate <0, 0, Sun1>
        translate <-1.5, 0, 0>
        rotate <0, -35, 0>
        translate <8.75, 7, -6.25>
        #declare Sun1=Sun1+2.5
        texture {Moon1}
      }
    #end
    #declare Sun1=-77
    // LEFT-HAND SIDE OF SUN PORTION, -Z SIDE
    #while ( Sun1 < 77 )
      sphere {<0, 0, 0>, 1, 1
        scale <1.5, 0.5, 0.5>
        translate <-1.5, 0, 0>
        rotate <0, 0, -Sun1>
        translate <1.5, 0, 0>
        rotate <0, 35.5, 0>
        translate <6.75, 7, -6.25>
        #declare Sun1=Sun1+2.5
        texture {Moon1}
      }
    #end
    // CENTRAL SEGMENT TO JOIN THE TWO PORTIONS OF THE MOON
    sphere {<0, 0, 0>, 1, 1 translate <7.75, 7, -6.25> texture {Moon1}}
    #declare Sun1=-77
    // RIGHT-HAND SIDE OF SUN PORTION, -Z SIDE
    #while ( Sun1 < 77 )
      sphere {<0, 0, 0>, 1, 1
        scale <1.5, 0.5, 0.5>
        translate <1.5, 0, 0>
        rotate <0, 0, Sun1>
        translate <-1.5, 0, 0>
        rotate <0, -35, 0>
        translate <8.75, 7, -4.5>
        #declare Sun1=Sun1+2.5
        texture {Moon1}
      }
    #end
    #declare Sun1=-77
    // LEFT-HAND SIDE OF SUN PORTION, -Z SIDE
    #while ( Sun1 < 77 )
      sphere {<0, 0, 0>, 1, 1
        scale <1.5, 0.5, 0.5>
        translate <-1.5, 0, 0>
        rotate <0, 0, -Sun1>
        translate <1.5, 0, 0>
        rotate <0, 35.5, 0>
        translate <6.75, 7, -4.5>
        #declare Sun1=Sun1+2.5
        texture {Moon1}
      }
    #end
  }

object {Panel7 translate <4, 0, 0>}
object {Panel5}
object {Panel6 translate <-4, 0, 0>}
object {HW1}
object {NW3}
object {WW3}
object {Ceiling2}
object {FM3 translate <0, -15, 98>}
object {FM3 rotate <0, -90, 0> translate <-125, -15, 0>}
object {FM4 translate <-87, -15, 12.5>}
object {FM4 rotate <0, 180, 0> translate <-87, -15, -17.5>}
object {FM5 rotate <0, -90, 0> translate <-15, -15,  60>}
object {FM5 rotate <0,  90, 0> translate < 15, -15,  60>}
object {Floor1}




