// Persistence of Vision Ray Tracer Scene Description File
// File: n_fright.pov
// Vers: 3
// Desc: For the Internet Ray Tracing Competition... Subject: Night
// Date: 0//29/98
// Auth: Bob Franke
//

#version 3

#include "colors.inc"
#include "finish.inc"

#include "flare.inc"
#include "cobra.inc"
#include "man2.inc"
#include "popcan.inc"

global_settings
{
  assumed_gamma 2.6  //2.6
//  max_trace_level 20
 }

// ----------------------------------------

#declare camX=1.0
#declare camY=10.0
#declare camZ=-50.0

#declare lookX=-4.0
#declare lookY=8.0
#declare lookZ=0.0

camera{
  location  <camX, camY, camZ>
  direction 1.5*z
  right     4/3*x
  look_at   <lookX,lookY,lookZ>
}


light_source{
  <30,12+25,-100>
  color rgb <1.200, 1.000, 0.95>*.25*1.5
  atmospheric_attenuation on
  fade_distance 50
  fade_power 1
  shadowless
}


light_source{
  <82-50,65,299>
  color rgb <1.200, 1.000, 0.8>*.8
}

light_source{
  <14-50,61,299>
  color rgb <1.200, 1.000, 0.8>*.8
}

light_source{
  <-91-50,55,299>
  color rgb <1.200, 1.000, 0.8>*.8
  atmospheric_attenuation on
}

//================<<< start of lens flares >>>==============================

 #declare cam_loc = <camX, camY, camZ>   // use the x, y, and z of your camera                                         // you wish to flare
 #declare lookat = <lookX,lookY,lookZ>   // the look_at vector of your camera
 #declare sky_vect = y                   // the sky vector of your camera
 #declare light_loc = <82-50,65,299>     // use the x, y, and z of the light
 #declare flare_size = .19
 #declare flare_brightness = .6
 #declare show_flare_source = yes
 #include "105mmA.flr"                   // or whatever pre-defined flare you like
 #include "nkflare.inc"

 #declare cam_loc = <camX, camY, camZ>   // use the x, y, and z of your camera                                         // you wish to flare
 #declare lookat = <lookX,lookY,lookZ>   // the look_at vector of your camera
 #declare sky_vect = y                   // the sky vector of your camera
 #declare light_loc = <14-50,61,299>     // use the x, y, and z of the light
 #include "105mmA.flr"                   // or whatever pre-defined flare you like
 #include "nkflare.inc"

 #declare cam_loc = <camX, camY, camZ>   // use the x, y, and z of your camera                                         // you wish to flare
 #declare lookat = <lookX,lookY,lookZ>   // the look_at vector of your camera
 #declare sky_vect = y                   // the sky vector of your camera
 #declare light_loc = <-91-50,55,299>    // use the x, y, and z of the light
 #include "105mma.flr"                   // or whatever pre-defined flare you like
 #include "nkflare.inc"
//================<<< end of lens flares >>>==============================


// pigment for the flare trails
#declare innerColor = color rgb <1.200, 1.000, 0.820>*.4*3
#declare outerColor = color rgb <1.200, 1.000, 0.820>*.2*2
#declare centerColor =color rgb <1.200, 1.000, 0.820>*.5*3
#declare FlareSky = pigment {
	marble
    frequency 2
	turbulence 1.5
	color_map {
		[0.65, 0.85	 color Black       color outerColor]
		[0.85, 0.92	 color outerColor  color innerColor]
		[0.92, 0.99	 color innerColor  color centerColor]
		[0.99, 1.001 color centerColor color White*2.25]
	}
}




// add the flare trails
box{<-200,-200,300> , <200,200,300.5>
  pigment {FlareSky scale <400,900,400>*1.102 translate <8500,1335,0> rotate<0,0,0>}
  clipped_by{plane{y,60 inverse} rotate<0,0,3>   }
  translate<-50,0,0>
}


// add a black background
box{<-200,-200,300.25> , <200,200,300.5>
  pigment{Black}
}


#declare oneBag=
  superellipsoid { <0.5, .5>
    pigment{White*.9}
    finish { crand 0.1 }
    scale<1,.375,1>*.5
}


//=====================<<< start of small bottle >>>============
#declare smallBottle=
union{
  union{
    superellipsoid { <0.15, .25> scale <.5,1,.25>}
    cylinder{<0,1,0>,<0,1.125,0>,.125}
    texture {
      pigment { color White*1.12 }
      finish { Dull}
    }
  }

  cylinder{<0,1.045,0>,<0,1.3,0>,.15
    texture {
      pigment { color Black }
      finish { Dull}
    }
  }
}
//=====================<<< end of small bottle >>>============



#declare helmet1 =
union{
  object{
    sphere { <0,0,0>, 1 pigment {DarkOliveGreen} }
    clipped_by{plane{y,0 inverse}}
  }
  cylinder{<0,0,0>,<0,-.1,0>, 1 pigment {DarkOliveGreen} }
  object{
    cone { <0,-.1,0>, 1, <0,-.25,0> 1.2 pigment {DarkOliveGreen} }
  }
}


#declare band=
difference{
  cylinder{<0,0,0>,<0,.093,0>,1.0649}
  cylinder{<0,-1,0>,<0,1,0>,1.0641}
  pigment{DarkOliveGreen}
}

#declare helmet=
union{
  object{helmet1}
  object{smallBottle rotate<0,90,7> scale .3 translate<1.04,.2,0>}
  object{band rotate<0,90,7> translate<.07,0,0>}
}

//==============<<< start of M16 >>>==============
#declare M16=
union{
  difference{
    union{
      difference{
        box{<0,0,-.07>,<1.6,-.72,.07>}
        box{<-3,0,.5>,<3,-1,-.5> rotate<0,0,-15> translate<1.6,-.72,0> }
      }
      box{<-1,-.39,-.07  >,<0,0,.07> }
    }
    cylinder{<-.05,-.39,1>,<-.05,-.39,-.1>, .1}
    box{<0,0,-.07>,<.23,-.52,.07> rotate<0,0,20> translate<-.40,-.4,0>}
    pigment{White*.1}
    finish{Shiny}
  }
  box{<0,0,-.07>,<.23,-.52,.07>
    rotate<0,0,20>
    translate<-.40,-.4,0>
    pigment{White*.1}
    finish{Shiny}
  }

  union{
    cylinder{<-1.1,-.1,0>,<-1,-.1,0>, .1 }
    cylinder{<-3,-.1,0>,<-1.1,-.1,0>, .18 }
    pigment{White*.1}
    finish{Shiny}
  }

  union{
    cylinder{<-4.5,-.1,0>,<-3,-.1,0>, .055 }
    cylinder{<-4.5,-.1,0>,<-4.25,-.1,0>, .075}
    pigment{White*.1}
    finish{Shiny}
  }

//front_sight
  union{
    cylinder{<-3.25,.28,-.03>,<-3.25,.28,.05>, .03}
    box{<-3.30,.28,-.03>,<-3.27,-.15,.03> }
    box{<0,0,-.03>,<.03,-.5,.03> rotate<0,0,30> translate<-3.235,.28,0> }
    pigment{White*.1}
    finish{Shiny}
  }

//rear_sight
  difference{
    union{
      object{
        cylinder{<-.875,.20,-.05>,<-.875,.20,.05>, .125 }
        clipped_by{plane{y,.20 inverse}}
        clipped_by{plane{x,-.875 }}
      }
      box{<-1,0,-.05>,<.125,.2,.05> }

      object{
        cylinder{<0,.20,-.05>,<0,.20,.05>, .125 }
        clipped_by{plane{y,.20 inverse}}
        clipped_by{plane{x,0 inverse}}
      }
      box{<-.875,.2,-.05>,<0,.325,.05> }
    }
    cylinder{<-.855,.15,-.06>,<-.855,.15,.06>, .105}
    cylinder{<-.1 ,.17,-.06>,<-.1,.17,.06>, .05 }
    cylinder{<-.08 ,.095,-.06>,<-.08,.095,.06>, .05 }
    box{<-.855,.045,-.07>,<-.1,.15,.07> }
    box{<-.855,.045,-.07>,<-.1,.15,.07> rotate<0,0,-3> translate<0,.06,0>}
    pigment{White*.1}
    finish{Shiny}
  }
}
//==============<<< end of M16 >>>==============


//==============<<< start of starLiteScope >>>==============
#declare starliteScope=
union{
  difference{
    cylinder{<-.5,.75,0>,<1.2,.75,0> .155}
    cylinder{<-.75,.75,0>,<2.2,.75,0> .14 }
    pigment{White*.1}
  }

  light_source{
    <1.2,.75,0>             // light's position (translated below)
    color rgb <0,1.75,0>       // light's color
    spotlight               // this kind of light source
    point_at <3, .875, -.1875>      // direction of spotlight
    radius 20                // hotspot (inner, in degrees)
    tightness 30            // tightness of falloff (1...100) lower is softer, higher is tighter
    falloff 90               // intensity falloff radius (outer, in degrees)
  }

  difference{
    cylinder{<-.5,.75,0>,<1.2,.75,0> .139}
    cylinder{<-.75,.75,0>,<2.2,.75,0> .137 }
    pigment{Green*2.5}
  }

  difference{
    cylinder{<1.19,.75,0>,<1.2,.75,0> .142}
    cylinder{<1.0,.75,0>,<2.2,.75,0> .075 }
    pigment{Black}
  }

  union{
    cylinder{<-.55,.75,0>,<-.45,.75,0> .17}
    cylinder{<-.25,1,0>,<.8,1,0> .1 }
    pigment{White*.1}
  }
  rotate<0,0,2>
}
//==============<<< end of starLiteScope >>>==============


#declare M16PlusScope=
union{
  object{starliteScope}
  object{M16 translate<.5,.30,0>}
}


//===========<<< assemble scene >>>==========================

/*
  sphere {<0,0,0>, 10000
    pigment{Black}
    hollow
  }
*/


height_field
{
  tga
   "night3.tga"
//    smooth
    translate<-.5,0,-.5>
    rotate<0,-20,0>
    scale<100,10,200>*1.4
    translate<-15,0,80>
    pigment{Green*.65}
    normal{
      bumps 0.3
      scale<.1,.1,.1>
    }
}

// add some fog
fog {
  fog_type 1 // 1=constant, 2=ground_fog
  distance 350
  color rgb <1.200, 1.000, .8>*.15
}

// add some ground fog
fog {
  fog_type 2 // 1=constant, 2=ground_fog
  distance 150
  color rgb <1.200, 1.000, .8>*.3
  fog_alt 25
}

// add ground fire
#declare xRed=10
#declare groundFire=
union{
  #declare yy=-3
  #while (yy < 36)
    #declare yy=yy+3
    #declare xred=xRed-.75
    cylinder{<0,yy,0>,<0,yy+.75,0>,.1 pigment{Red*xRed} }
  #end
}


object{man2 scale 9 rotate<0,25,0>translate <0,6.875,-43.75> no_shadow}
object{helmet scale <.35,.4,.35>*.95  rotate<0,10,-5>translate<-.585,9.63,-44.43>}
object{cobra scale .05  rotate<-10,-30,-15>translate <30,20,130> no_shadow}
object{groundFire rotate<25,0,25>translate <42,0,110> no_shadow}
object{CanOfPop scale.06 translate<1.0,8.671875,-44>}
object{M16PlusScope scale .5 rotate<0,0,5> rotate<0,115,0>translate <0,9,-43.75> no_shadow}


object{oneBag translate <0,8.5,-44>}
object{oneBag translate <1,8.5,-44>}
object{oneBag translate <2,8.5,-44>}
object{oneBag translate <2,8.5,-45>}
object{oneBag translate <2,8.5,-46>}
object{oneBag translate <-1,8.5,-44>}
object{oneBag translate <-2,8.5,-44>}
object{oneBag translate <-3,8.5,-44>}

object{oneBag translate <-.5,8.25,-44>}
object{oneBag translate <.5,8.25,-44>}
object{oneBag translate <1.5,8.25,-44>}
object{oneBag translate <2,8.25,-45>}

object{oneBag translate <-1.5,8.5-.25,-44>}
object{oneBag translate <-2.5,8.5-.25,-44>}

object{oneBag translate <0,8.,-44>}
object{oneBag translate <1,8,-44>}
object{oneBag translate <2,8,-44>}
object{oneBag translate <-1,8,-44>}
object{oneBag translate <-2,8,-44>}

object{oneBag translate <-.5,7.75,-44>}
object{oneBag translate <.5,7.75,-44>}
object{oneBag translate <1.5,7.75,-44>}
object{oneBag translate <-1.5,7.75,-44>}
object{oneBag translate <-2.5,7.75,-44>}
