# night2.awk  gjpateman  3/6/98
# Creates a POV .INC file of objects arranged in a circle
# with the Z-position following 1 or more sine wave path
# Obj must be declared before including this INC in a POV file.
# All Objs are also rotated to "follow" each other.

BEGIN {
  radius = 250.0                # float: distance from center of circle
  objs  = 250                   # int:   number of objects around circle
  amplitude = 50.0             # float: size of Z-modulation curve
  cycles = 9                   # int:   circle ends wont meet if not an int

  pi = atan2( 0, -1 )          # float: value of pi for trig funcs
  circum = 2 * pi              # float: circumference of a circle in radians
  step = circum / objs         # float: angle between objects
  degsperrad = 360 / circum    # float: convert radians to degrees for rotate<>
  count = 1                    # int:   enumerates the objects

  printf "/*\n  OBJ06.INC for POV2.0  by gjpateman\n\n"
  printf "  Radius of circle  = %f\n", radius
  printf "  Number of objects around circle = %d\n", objs
  printf "  Amplitude of sine waves = %f\n", amplitude
  printf "  Number of sine waves around circle = %d\n*/\n\n", cycles
  for ( radians = 0; radians < circum; radians += step )
  {
    x = radius * sin( radians )
	z = radius * cos( radians )
	y = amplitude * sin( cycles * radians ) # match POV orientation

	# Enumerate objects for future reference
    printf "object{ Obj // %.0f\n", count++

	# rotate obj to "follow" neighboring objects on the sine curve
	printf "rotate<0,0,%f>\n", degsperrad * cos( cycles * -1 * radians )

	# move obj into position around the circle
	printf "rotate<0,%f,0>\n", radians * degsperrad

	printf "translate<%f,%f,%f>}\n\n", x, y, z
  }
  exit
}
