//  nschool.pov  gjpateman  03/05/98

#include "colors.inc"
#include "textures.inc"


//-----------------------------  The Moon  --------------------------------//

#declare Moon = light_source{ < 0, 0, 0 >  color 2
  looks_like{
    sphere{ <0,0,0>, 1
      texture{
        pigment{ image_map{ tga "lunatex.tga"  interpolate 2  map_type 0 } }
        finish{ Luminous }  translate< -.5, -.5, 0 >  scale 2
      }
      no_shadow
    }
  }
}
#declare MoonZ = 20000
#declare MoonPosition = < 0, 2000, MoonZ > // 2500
#declare MoonSize = 1000
object{ Moon  scale MoonSize  translate MoonPosition }
sphere{ MoonPosition, MoonSize + 1  pigment{ rgbf< 1, 1, 2, .9975 > } }


//-----------------------------  Moon Glow  --------------------------------//

#declare Glow = plane{  // A mostly-transparent bluish plane
  z, ( MoonZ + MoonSize + 1 )
  texture{
    pigment{ rgbf< 0.5, 0.5, 1.5, 0.7 > } // .7
    finish{ ambient .1  diffuse 1.3 }
  }
}
object{ Glow }


//-----------------------------  The Starfield  ----------------------------//

#declare StarBack = // generated in Fractint
plane{ z, 0
  texture{
    pigment{
      image_map{ gif "starback.gif"  interpolate 2  map_type 0 }
      translate< -.5, -5, 0 > // center it at 0,0,0
      scale< 4/3, 1, 1 >  // restore image's aspect ratio
    }
    finish { ambient 2  diffuse 0 }
  }
  scale< 60000, 60000, 1 >
  translate z * 100000
}
object{ StarBack }


//-----------------------------  The Fishes  --------------------------------//

#include "objdef.inc"          // defines the Obj used in night.inc
#declare FishCircle = union{
  #include "night.inc"         // created with:  awk -f night.awk > night.inc
}
#declare Theta = 10
#declare Fishes = union{
  object{ FishCircle  rotate y * Theta  }
  object{ FishCircle  rotate y * Theta  translate z * 10 }
  object{ FishCircle  rotate y * Theta  translate z * 20 }
  object{ FishCircle  rotate y * Theta  translate z * 30 }
  object{ FishCircle  rotate y * Theta  translate z * 40 }
  object{ FishCircle  rotate y * Theta  translate z * 50 }
  object{ FishCircle  rotate y * Theta  translate z * 60 }
  object{ FishCircle  rotate y * Theta  translate z * 70 }
  object{ FishCircle  rotate y * Theta  translate z * 80 }
}
object{ Fishes  translate y * -3 }


//-----------------------------  The Ocean  --------------------------------//

#declare Ocean = // Heavily modified from a POV 2.0 demo source
union {
  plane { y, 0
    pigment{ NewMidnightBlue  filter 0.3 } //.1
    normal{ waves 0.15 frequency 2000.0  }
    //normal{ waves 0.05 frequency 2000.0  }
    finish{ ambient .2 diffuse 1.0  reflection .6 }
  }
}
object{ Ocean  scale 45000  rotate y * 80 } //15000


//-----------------------------  The Camera  --------------------------------//

camera{
  location< 0, 15, -300 >
  direction< 0, 0, 2 > // 1
  up< 0, 1, 0 >
  right< 4/3, 0, 0 >
  look_at< 0, 65, 0 >   // 75
}
