 pdmddark.pov        Z  @@/        Z>>  Z@@@>TEXTPOV3          uձn*                         // POV-Ray file
// Standard pre-defined colors
#include "colors.inc"
#include "textures.inc"

/* Without radiosity, with anti-aliasing:
Time For Parse:    0 hours  0 minutes  11.0 seconds (11 seconds)
Time For Trace:    3 hours 23 minutes  14.0 seconds (12194 seconds)
    Total Time:    3 hours 23 minutes  25.0 seconds (12205 seconds)
*/

global_settings{
  assumed_gamma 1.0
  radiosity {
    brightness 0.5
    count 100
    distance_maximum 6
    error_bound 0.33
    gray_threshold 0.5
    low_error_factor 0.1
    minimum_reuse 0.1
    nearest_count 1
    recursion_limit 20
  }
}

// Units
#declare in  =  1
#declare ft  = 12

#declare ViewPoint = <-9*in,6*in,-1*ft-6*in>
#declare LookAt = <0,6*in,0>

#declare Detailed = 1
#declare THDetailL = 1
#declare THDetailH = 1

#declare D1=seed(212)
#declare D2=seed(917)
#declare D3=seed(1476)
#declare D4=seed(1837)

background{colour rgb<.5,.5,.8>}

camera {
  location  ViewPoint // position of camera <X Y Z>
  look_at   LookAt // point center of view at this point <X Y Z>
}

/*
light_source {
  ViewPoint
  colour rgb <1,1,1>
}

light_source {
  <10*ft,10*ft,-10*ft>
  colour rgb <2,2,2>
}
*/

plane {y,0
  texture {
    pigment{colour rgb <.35,.35,.35>}
    finish{ambient .3}
  }
  hollow
}
plane {z,8*ft
  texture {
    pigment{colour rgb <.18,.22,.28>}
    finish{ambient .3}
  }
  hollow
}


#declare GGhost=
#if (Detailed=1)
merge{
  sphere{//Left eye
    <.5,10.5,-1>,.25
    pigment{colour rgb <.1,.1,.1>}
  }
  sphere{//Right eye
    <-.5,10.5,-1>,.25
    pigment{colour rgb <.1,.1,.1>}
  }
  blob{//Upper "body"
    threshold 0.7
    sphere{< 0.00,11.75, 0.00>, 2, .25}

    sphere{<-1.25,11.00, 0.00>, 2, .25}
    sphere{<-0.50,11.00, 0.00>, 2, .50}
    sphere{< 0.50,11.00, 0.00>, 2, .50}
    sphere{< 1.25,11.00, 0.00>, 2, .25}

    sphere{<-1.00,10.00, 0.00>, 2, .50}
    sphere{< 0.00,10.00, 0.00>, 2, .50}
    sphere{< 1.00,10.00, 0.00>, 2, .50}

    sphere{<-1.50, 9.00, 0.00>, 2, .50}
    sphere{<-0.50, 9.00, 0.00>, 2, .50}
    sphere{< 0.50, 9.00, 0.00>, 2, .50}
    sphere{< 1.50, 9.00, 0.00>, 2, .50}

    sphere{<-1.00, 8.00, 0.00>, 2, .50}
    sphere{< 0.00, 8.00, 0.00>, 2, .50}
    sphere{< 1.00, 8.00, 0.00>, 2, .50}

    sphere{<-1.00, 7.00, 0.00>, 2, .50}
    sphere{< 0.00, 7.00, 0.00>, 2, .50}
    sphere{< 1.00, 7.00, 0.00>, 2, .50}

    sphere{<-1.25, 6.00, 0.00>, 2, .50}
    sphere{<-0.25, 6.00, 0.00>, 2, .50}
    sphere{< 0.75, 6.00, 0.00>, 2, .50}

    sphere{<-1.50, 5.00, 0.00>, 2, .50}
    sphere{<-0.50, 5.00, 0.00>, 2, .50}
    sphere{< 0.50, 5.00, 0.00>, 2, .50}

    sphere{<-1.50, 4.00, 0.00>, 2, .50}
    sphere{<-0.50, 4.00, 0.00>, 2, .50}
    sphere{< 0.50, 4.00, 0.00>, 2, .50}

    sphere{<-1.25, 3.00, 0.00>, 2, .50}
    sphere{<-0.25, 3.00, 0.00>, 2, .50}
    sphere{< 0.75, 3.00, 0.00>, 2, .50}
  }
  blob{//Lower "body"
    threshold 0.7
    sphere{<-1.50, 4.00, 0.00>, 2, .50}
    sphere{<-0.50, 4.00, 0.00>, 2, .50}
    sphere{< 0.50, 4.00, 0.00>, 2, .50}

    sphere{<-1.25, 3.00, 0.00>, 2, .50}
    sphere{<-0.25, 3.00, 0.00>, 2, .50}
    sphere{< 0.75, 3.00, 0.00>, 2, .50}

    sphere{<-1.00, 2.00, 0.00>, 1, .50}
    sphere{< 0.00, 2.00, 0.00>, 2, .50}
    sphere{< 1.00, 2.00, 0.00>, 2, .50}

    sphere{< 0.00, 1.25, 0.00>, 2, .25}
    sphere{< 0.50, 1.25, 0.00>, 2, .25}
    sphere{< 1.00, 1.25, 0.00>, 2, .25}

    sphere{< 0.50, 0.75, 0.00>, 2, .25}
    sphere{< 1.00, 0.75, 0.00>, 2, .25}

    sphere{< 0.00, 0.25, 0.00>, 2, .25}
  }
  blob{//Left arm
    threshold 0.7
    sphere{<-1.00, 0.00, 0.00>, 2, .50}
    sphere{<-0.50, 0.00, 0.00>, 2, .50}
    sphere{< 0.00, 0.00, 0.00>, 2, .50}
    sphere{< 1.00, 0.50, 0.00>, 2, .50}
    sphere{< 1.50, 1.50, 0.00>, 2, .50}
    sphere{< 2.00, 2.50,-0.00>, 2, .50}
    sphere{< 2.00, 3.50,-0.00>, 2, .50}
    sphere{< 1.50, 4.00,-0.00>, 2, .50}
    rotate <0,0,0>
    translate <1.5,7,0>
  }
  blob{//Right arm
    threshold 0.7
    sphere{< 1.00, 0.00, 0.00>, 2, .50}
    sphere{< 0.50, 0.00, 0.00>, 2, .50}
    sphere{<-0.00, 0.00, 0.00>, 2, .50}
    sphere{<-1.00, 0.50, 0.00>, 2, .50}
    sphere{<-1.50, 1.50, 0.00>, 2, .50}
    sphere{<-2.00, 2.50,-0.00>, 2, .50}
    sphere{<-2.00, 3.50,-0.00>, 2, .50}
    sphere{<-1.50, 4.00,-0.00>, 2, .50}
    rotate <-30,0,0>
    translate <-1.5,7,0>
  }
  texture{
    pigment{colour rgbf <.9,.95,.9,.9>}
    finish{ambient 1.2}
  }
}
#else
cylinder{
  <0,0,0>,<0,12,0>,.5
  scale <3,1,1>
  texture{
    pigment{colour rgbf <.9,.95,.9,.9>}
    finish{ambient 1.2}
  }
}
#end


#declare CandHt=6
#declare CandWd=1.5
#declare CandWickHt=1
#include "candle.inc"
#include "candleun.inc"

#declare Drip1=
cylinder{
  <0,-1,0>,<0,2,0>,.25
  rotate x*15
  translate <0,0,-1.4>
}

#declare Drip2=
cylinder{
  <0,-1,0>,<0,2,0>,.75
  rotate x*10
  translate <0,0,-.8>
}

#declare Rotn=0

#declare Candle2=
union{
  difference{
    union{
      cylinder{
        <0,0,0>,<0,1,0>,1.5
      }
      #while (Rotn<10)
        object{
          Drip1
          rotate x*(-5+10*rand(D1))
          rotate y*(18+36*Rotn)
        }
        object{
          Drip2
          rotate x*(-7.5+15*rand(D2))
          rotate y*36*Rotn
        }
        #declare Rotn=Rotn+1
      #end
    }
    box{
      <-2,-1,-2>,<2,0,2>
    }
    sphere{
      <0,5.5,0>,5
    }
  }
  cylinder{
    <0,.4,0>,<0,.7,.05>,.05
    texture {
      pigment{colour rgb<.05,.05,.05>}
    }
  }
  texture {
    pigment{colour rgbt<.95,.95,.95,.05>}
  }
}

#declare Rton=0

#declare Candle3=
union{
  difference{
    union{
      cylinder{
        <0,0,0>,<0,1,0>,1.5
      }
      #while (Rton<12)
        object{
          Drip1
          rotate x*(-5+10*rand(D3))
          rotate y*(15+30*Rton)
        }
        object{
          Drip2
          rotate x*(-7.5+15*rand(D4))
          rotate y*30*Rton
        }
        #declare Rton=Rton+1
      #end
    }
    box{
      <-2,-1,-2>,<2,0,2>
    }
    sphere{
      <.5,7,.5>,7
    }
  }
  cylinder{
    <0,.1,0>,<0,.7,.05>,.05
    texture {
      pigment{colour rgb<.05,.05,.05>}
    }
  }
  texture {
    pigment{colour rgbt<.95,.95,.95,.05>}
  }
}

#declare Matchbox=
union{
  difference{
    box{
      <-1,-.25,-.75>,<1,.25,.75>
    }
    box{
      <-1.5,-.23,-.73>,<1.5,.23,.73>
    }
    texture{pigment{colour rgb<.7,.7,.2>}}
  }
  difference{
    box{
      <-.9,-.225,-.725>,<.9,.225,.725>
    }
    box{
      <-.88,-.205,-.705>,<.88,.3,.705>
    }
    texture{pigment{colour rgb<.7,.7,.7>}}
  }
  box{
    <-.875,-.2,-.75>,<.875,.2,-.76>
    texture{
      pigment{checker colour rgb<.3,.3,0> colour rgb<.7,.7,.2>}
      scale 1/16
      rotate z*45
    }
  }
  translate<0,.25,0>
}

#declare Match=
union{
  box{
    <-.85,-.0625,-.0625>,<.85,.0625,.0625>
    texture{
      pigment{
        gradient x colour_map{
          [0.00 colour rgb<.9,.9,.9>]
          [0.75 colour rgb<.9,.9,.9>]
          [0.76 colour rgb<.05,.05,.05>]
          [1.00 colour rgb<.05,.05,.05>]
        }
        scale 1.7
        translate <-.85,0,0>
        rotate <35,0,30>
      }
    }
  }
  sphere{
    <-.85,0,0>,.0625
    texture{pigment{colour rgb <.05,.05,.05>}}
  }
  translate <-.85,.0625,0>
}

#include "BravoBr.inc"

object{
  BravoBear
  scale 3
  rotate <0,-90,0>
  translate<4,-3,0>
}

object{
  Candle
  rotate <0,0,0>
  translate <-1,0,0>
}

object{
  Match
  rotate <0,0,120>
  rotate <0,30,0>
  translate <1,5.5,-2.1>
}

object{
  Matchbox
  rotate <0,-10,0>
  translate <3,0,-4.5>
}

object{
  CandleUnlit
  rotate <0,0,-90>
  translate <1,CandWd,4>
}

object{
  CandleUnlit
  rotate <0,0,-90>
  translate <.75,CandWd,7>
}

object{
  CandleUnlit
  rotate <0,0,-90>
  translate <.8,CandWd,10>
}

object{
  CandleUnlit
  rotate <0,0,-90>
  translate <.6,CandWd,13>
}

object{
  Candle3
  scale <.5,1,.5>
  translate <-1.5,0,-3>
}

object{
  Candle2
  scale <.5,1,.5>
  translate <-2,0,3.5>
}

object{
  GGhost
  no_shadow
  rotate <0,-25,0>
  translate <-6*in,0,2*ft>
}                                          e  #Icallahans03.pictp  PICTttpdmddark.pov    TEXTPOV3    TEXTPOV3                    ձ    u                #Icallahans04.pictp  PICTttxt        #           
n                         F G
     G        <    (  |     X      X ttxt8BIM   	                          >                                ?  f$` 9  FhR     H 	Monaco ? Q > R>?     d = d =n*  .  .         d = d =                        e̦(!l    R MPSR  FPRF   *          Ρ,          POV-Ray File Prefs           