//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 0 lights, 15 textures and 69 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.0 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 04/30/1998    (30.04.1998)
//

/*
  Vigilant Sentry
  (c)1998 Robert Pierce, Newfoundland, Canada
  e-mail --> econoltd@thezone.net

  Not to be used for commercial purposes.
  If you make a picture using any part of this file, please email me a copy.
*/

global_settings {
  adc_bailout 0.003922
  ambient_light <0.498039,0.498039,0.498039>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

fog {
  fog_type 2    // Ground Fog
  distance     80.0
  color <0.498039,0.498039,0.498039,0.0,0.0>
  up           <0,0,1>
  fog_offset   0.0
  fog_alt      5.0
}

camera {  //  Camera SpotCam002
  location  <-29.658, -18.540, 4.217>
  direction <0.0,     0.0,  1.8665>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <19.750, 25.727, 0.874>
}


//  Moray V3.0 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//
// ********  TEXTURES  *******
//

#include "rpsentry.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

plane { // OceanFloor
  z,0
  texture {
    Water_Quick2
  }
  hollow
  scale 30.550619
  translate  0.2*z
}


plane { // OceanSurface
  z,0
  texture {
    Water_Quick1
  }
  hollow
  scale 30.550619
  translate  1.1*z
}


object {   // HgtFld001
  height_field {
    tga "plasma2.tga"
    water_level 0.6
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    GroundTex
  }
  hollow
  scale <30.0, 30.0, 5.0>
}


#declare front_keel = difference {
  cylinder { // fkeel
    <0,0,1>, <0,0,0>, 1 
    scale <20.0, 20.0, 2.0>
    rotate -90.0*y
    translate  <0.990662, -35.048516, 19.20062>
  }
  cylinder { // fkeel_dif1
    <0,0,1>, <0,0,0>, 1 
    scale <16.0, 16.0, 2.0>
    rotate -90.0*y
    translate  <0.990662, -34.907318, 19.219543>
  }
  box { // fkeel_dif2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 20.0, 10.0>
    translate  <0.0, -35.707973, 40.585249>
  }
  box { // fkeel_dif3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 10.0, 23.0>
    translate  <0.0, -24.727828, 20.342651>
  }
  bounded_by { // fk_bound
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <1.05, 10.5, 16.0>
      translate  <0.0, -44.840941, 14.806025>
    }
  }
  translate  <0.0, -9.99386, 0.370203>
}
#declare back_keel = difference {
  cylinder { // bkeel
    <0,0,1>, <0,0,0>, 1 
    scale <20.0, 20.0, 2.0>
    rotate -90.0*y
    translate  <0.990662, -35.048516, 19.20062>
  }
  cylinder { // bkeel_dif1
    <0,0,1>, <0,0,0>, 1 
    scale <16.0, 16.0, 2.0>
    rotate -90.0*y
    translate  <0.990662, -34.907318, 19.219543>
  }
  box { // bkeel_dif2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 20.0, 10.0>
    translate  <0.0, -35.707973, 40.585249>
  }
  box { // bkeel_dif3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 10.0, 23.0>
    translate  <0.0, -24.727828, 20.342651>
  }
  bounded_by { // bk_bound
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <1.05, 10.5, 16.0>
      translate  <0.0, -44.928862, 14.806>
    }
  }
  rotate -180.0*z
  translate  <0.0, 99.904303, 0.373945>
}
#declare whole_keel = union {
  box { // keel
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 45.0, 2.0>
    rotate -2.0*x
  }
  box { // keel1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 45.0, 2.0>
    rotate 2.0*x
    translate  89.909166*y
  }
  object { front_keel }
  object { back_keel }
}
#declare ship_sides = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.820940, -44.640738, -21.557106>, <2.904642, -58.080685, -18.908934>, <2.923714, -58.141485, -14.119992>, <2.958304, -61.427028, -8.583858>, 
      <2.935568, -14.762713, -22.975186>, <-5.722002, -14.762713, -18.908934>, <-14.725155, -14.762713, -16.307911>, <-14.752876, -14.762713, -13.040530>, 
      <3.166327, 12.385649, -24.393265>, <-5.722002, 12.385649, -19.617973>, <-14.725155, 12.385649, -17.016951>, <-14.752876, 12.385649, -15.167649>, 
      <3.166327, 34.699889, -24.393265>, <-5.722002, 34.699889, -19.617973>, <-14.725155, 34.699889, -17.016951>, <-14.752876, 34.699889, -15.167649>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.166327, 34.699889, -24.393265>, <-5.722002, 34.699889, -19.617973>, <-14.725155, 34.699889, -17.016951>, <-14.752876, 34.699889, -15.167649>, 
      <3.166327, 57.014129, -24.393265>, <-5.722002, 57.014129, -19.617973>, <-14.725155, 57.014129, -17.016951>, <-14.752876, 57.014129, -15.167649>, 
      <2.935568, 89.211873, -22.975186>, <-5.722002, 89.211873, -18.908934>, <-14.725155, 89.211873, -16.307911>, <-14.752876, 89.211873, -13.040530>, 
      <3.042911, 136.197301, -21.557106>, <3.015193, 149.583209, -18.908934>, <3.012155, 149.829220, -14.119992>, <3.009116, 151.358201, -8.183242>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.958304, -61.427028, -8.583858>, <2.992894, -64.712571, -3.047724>, <2.998438, -57.174999, 7.084042>, <3.000000, -57.174999, 7.084042>, 
      <-14.752876, -14.762713, -13.040530>, <-14.780597, -14.762713, -9.773149>, <-14.739804, -14.762713, -2.496746>, <-13.739804, -14.762713, -2.496746>, 
      <-14.752876, 12.385649, -15.167649>, <-14.780597, 12.385649, -13.318347>, <-14.739804, 12.385649, -6.041944>, <-13.739804, 12.385649, -6.041944>, 
      <-14.752876, 34.699889, -15.167649>, <-14.780597, 34.699889, -13.318347>, <-14.739804, 34.699889, -6.041944>, <-13.739804, 34.699889, -6.041944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-14.752876, 34.699889, -15.167649>, <-14.780597, 34.699889, -13.318347>, <-14.739804, 34.699889, -6.041944>, <-13.739804, 34.699889, -6.041944>, 
      <-14.752876, 57.014129, -15.167649>, <-14.780597, 57.014129, -13.318347>, <-14.739804, 57.014129, -6.041944>, <-13.739804, 57.014129, -6.041944>, 
      <-14.752876, 89.211873, -13.040530>, <-14.780597, 89.211873, -9.773149>, <-14.739804, 89.211873, -2.496746>, <-13.739804, 89.211873, -2.496746>, 
      <3.009116, 151.358201, -8.183242>, <3.006077, 152.887182, -2.246491>, <3.003039, 149.036429, 3.417841>, <3.000000, 149.036429, 3.417841>
    }
  }
  translate  <-3.0, 0.0, 24.429799>
}
#declare head = union {
  sphere { // head1
    <0,0,0>,1
    scale <1.4, 2.3, 1.5>
    translate  <0.0, -11.388683, 7.314216>
  }
  sphere { // head2
    <0,0,0>,1
    scale <1.3, 3.0, 1.0>
    translate  <0.0, -12.27159, 7.041799>
  }
}
#declare hd_diff = difference {
  object { head }
  box { // hddiff1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 1.8, 0.1>
    translate  <0.0, -13.917181, 6.835934>
  }
}
#declare hd = union {
  object { hd_diff }
  torus { // nostril
    1.5, 0.5  rotate -x*90
    scale 0.2
    rotate <0.0, 100.0, -20.0>
    translate  <0.487523, -14.114954, 7.59>
  }
  torus { // nostril1
    1.5, 0.5  rotate -x*90
    scale 0.2
    rotate <0.0, -100.0, 20.0>
    translate  <-0.488, -14.07, 7.59>
  }
  sphere { // eye
    <0,0,0>,1
    texture {
      EyeTexture
    }
    scale <0.35, 0.6, 0.35>
    translate  <-1.0, -12.0, 8.0>
  }
  sphere { // eye1
    <0,0,0>,1
    texture {
      EyeTexture
    }
    scale <0.35, 0.6, 0.35>
    translate  <1.0, -12.0, 8.0>
  }
  torus { // eye_ridge
    1.5, 0.5  rotate -x*90
    scale <0.3, 0.6, 0.45>
    rotate -120.0*y
    translate  <-0.786408, -12.0, 8.026554>
  }
  torus { // eye_ridge1
    1.5, 0.5  rotate -x*90
    scale <0.3, 0.6, 0.45>
    rotate 120.0*y
    translate  <0.786, -12.0, 8.026554>
  }
  texture {
    HullTexture
  }
  bounded_by { // hd_bound
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <1.441909, 3.148448, 1.574224>
      translate  <0.0, -12.152148, 7.305025>
    }
  }
  scale <1.8, 4.0, 4.0>
  translate  <0.0, -18.625555, 11.235033>
}
#declare ship_sides1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.820940, -44.640738, -21.557106>, <2.904642, -58.080685, -18.908934>, <2.923714, -58.141485, -14.119992>, <2.958304, -60.152401, -8.583858>, 
      <2.935568, -7.449029, -22.975186>, <-5.722002, -7.449029, -18.908934>, <-14.725155, -7.449029, -16.307911>, <-14.752876, -7.449029, -13.040530>, 
      <3.166327, 19.699333, -24.393265>, <-5.722002, 19.699333, -19.617973>, <-14.725155, 19.699333, -17.016951>, <-14.752876, 19.699333, -15.167649>, 
      <3.166327, 40.185152, -24.393265>, <-5.722002, 40.185152, -19.617973>, <-14.725155, 40.185152, -17.016951>, <-14.752876, 39.575679, -15.167649>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.166327, 40.185152, -24.393265>, <-5.722002, 40.185152, -19.617973>, <-14.725155, 40.185152, -17.016951>, <-14.752876, 39.575679, -15.167649>, 
      <3.166327, 60.670972, -24.393265>, <-5.722002, 60.670972, -19.617973>, <-14.725155, 60.670972, -17.016951>, <-14.752876, 60.670972, -15.167649>, 
      <2.935568, 92.868715, -22.975186>, <-5.722002, 92.868715, -18.908934>, <-14.725155, 92.868715, -16.307911>, <-14.752876, 92.868715, -13.040530>, 
      <3.042911, 136.197301, -21.557106>, <3.015193, 149.583209, -18.908934>, <3.012155, 149.829220, -14.119992>, <3.009116, 152.328233, -7.105429>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.958304, -60.152401, -8.583858>, <2.992894, -62.163317, -3.047724>, <2.998438, -57.638500, 3.376037>, <3.000000, -57.638500, 3.376037>, 
      <-14.752876, -7.449029, -13.040530>, <-14.780597, -7.449029, -9.773149>, <-14.739804, -7.449029, -2.496746>, <-13.739804, -7.449029, -2.496746>, 
      <-14.752876, 19.699333, -15.167649>, <-14.780597, 19.699333, -13.318347>, <-14.739804, 19.699333, -6.041944>, <-13.739804, 19.699333, -6.041944>, 
      <-14.752876, 39.575679, -15.167649>, <-14.780597, 40.185152, -13.318347>, <-14.739804, 40.185152, -6.041944>, <-13.739804, 40.185152, -6.041944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-14.752876, 39.575679, -15.167649>, <-14.780597, 40.185152, -13.318347>, <-14.739804, 40.185152, -6.041944>, <-13.739804, 40.185152, -6.041944>, 
      <-14.752876, 60.670972, -15.167649>, <-14.780597, 60.670972, -13.318347>, <-14.739804, 60.670972, -6.041944>, <-13.739804, 60.670972, -6.041944>, 
      <-14.752876, 92.868715, -13.040530>, <-14.780597, 92.868715, -9.773149>, <-14.739804, 92.868715, -2.496746>, <-13.739804, 92.868715, -2.496746>, 
      <3.009116, 152.328233, -7.105429>, <3.006077, 154.827246, -0.090865>, <3.003039, 148.174178, 6.435718>, <3.000000, 148.174178, 6.435718>
    }
  }
  rotate -180.0*z
  translate  <3.0, 90.830443, 24.429799>
}
#declare main_sail = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-48.307779, -2.000000, 0.000000>, <-22.942278, -25.295094, 9.036788>, <23.973971, -25.295094, 9.036788>, <48.137855, -2.000000, 0.000000>, 
      <-63.095251, -15.551937, 36.257619>, <-28.692962, -65.934349, 36.257619>, <28.903128, -65.934349, 36.257619>, <62.925326, -15.551937, 36.257619>, 
      <-55.701515, -14.990461, 70.702576>, <-22.942278, -26.908881, 70.702576>, <23.973971, -26.908881, 70.702576>, <55.531591, -14.990461, 70.702576>, 
      <-29.412677, -1.996826, 115.333923>, <-4.047176, -1.996826, 115.333923>, <7.543447, -1.996826, 115.333923>, <31.707331, -1.996826, 115.333923>
    }
  }
  texture {
    SailCanvas
  }
  translate  <0.0, 44.273158, 50.210407>
}
#declare nest = intersection {
  cone { // crownest
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <10.0, 10.0, 20.0>
    translate  <0.0, 46.069345, 173.016937>
  }
  box { // cn_inter
    <-1, -1, -1>, <1, 1, 1>
    scale <10.2, 10.2, 6.0>
    translate  <0.0, 45.924514, 188.665957>
  }
  texture {
    HullTexture
  }
}
// Include contains 'ship_floor'
#include "rpsentry.in1"

#declare ship_floor = object {
  ship_floor_Raw
  texture {
    DeckTexture
  }
  translate  <0.0, -3.729705, 9.490388>
}
// Include contains 'fore_bridge'
#include "rpsentry.in2"

#declare fore_bridge = object {
  fore_bridge_Raw
  texture {
    DeckTexture
  }
  scale <1.0, 1.0, 6.0>
  translate  <0.0, -3.729705, 9.490388>
}
// Include contains 'aft_bridge'
#include "rpsentry.in3"

#declare aft_bridge = object {
  aft_bridge_Raw
  texture {
    DeckTexture
  }
  scale <1.0, 1.0, 6.0>
  translate  <0.0, -3.729705, 9.490388>
}
#declare benches = union {
  box { // bench1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      ShieldTexture
    }
    scale <4.0, 2.5, 3.0>
    rotate 6.0*z
    translate  <-9.797986, 3.188967, 12.478567>
  }
  box { // bench2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      ShieldTexture
    }
    scale <4.0, 2.5, 3.0>
    rotate -6.0*z
    translate  <8.083338, 3.188967, 12.478567>
  }
  box { // bench3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      ShieldTexture
    }
    scale <4.0, 2.5, 3.0>
    rotate 3.0*z
    translate  <-11.512633, 19.845543, 12.478567>
  }
  box { // bench4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      ShieldTexture
    }
    scale <4.0, 2.5, 3.0>
    rotate -3.0*z
    translate  <10.0, 19.845543, 12.478567>
  }
  box { // bench5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      ShieldTexture
    }
    scale <4.0, 2.5, 3.0>
    rotate -1.0*z
    translate  <11.714647, 38.706665, 12.478567>
  }
  box { // bench6
    <-1, -1, -1>, <1, 1, 1>
    texture {
      ShieldTexture
    }
    scale <4.0, 2.5, 3.0>
    rotate 1.0*z
    translate  <-12.10354, 38.706665, 12.478567>
  }
  box { // bench7
    <-1, -1, -1>, <1, 1, 1>
    texture {
      ShieldTexture
    }
    scale <4.0, 2.5, 3.0>
    rotate -3.0*z
    translate  <-11.573237, 55.666262, 12.478567>
  }
  box { // bench8
    <-1, -1, -1>, <1, 1, 1>
    texture {
      ShieldTexture
    }
    scale <4.0, 2.5, 3.0>
    rotate 3.0*z
    translate  <12.058072, 55.666262, 12.478567>
  }
  box { // bench9
    <-1, -1, -1>, <1, 1, 1>
    texture {
      ShieldTexture
    }
    scale <4.0, 2.5, 3.0>
    rotate 3.0*z
    translate  <10.588374, 75.666262, 12.478567>
  }
  box { // bench10
    <-1, -1, -1>, <1, 1, 1>
    texture {
      ShieldTexture
    }
    scale <4.0, 2.5, 3.0>
    rotate -3.0*z
    translate  <-9.656576, 75.666262, 12.478567>
  }
  box { // bench11
    <-1, -1, -1>, <1, 1, 1>
    texture {
      ShieldTexture
    }
    scale <4.0, 2.5, 3.0>
    rotate -7.0*z
    translate  <-7.696978, 91.992018, 12.478567>
  }
  box { // bench12
    <-1, -1, -1>, <1, 1, 1>
    texture {
      ShieldTexture
    }
    scale <4.0, 2.5, 3.0>
    rotate 7.0*z
    translate  <8.671712, 91.992018, 12.478567>
  }
}
#declare shlds = union {
  sphere { // sheild
    <0,0,0>,1
    scale <0.5, 6.0, 8.0>
    rotate 7.0*z
    translate  <-15.981577, -4.662131, 22.37823>
  }
  sphere { // sheild1
    <0,0,0>,1
    scale <0.5, 6.0, 8.0>
    rotate 4.0*z
    translate  <-17.664336, 11.616713, 21.445803>
  }
  sphere { // sheild2
    <0,0,0>,1
    scale <0.5, 6.0, 8.0>
    rotate 1.0*z
    translate  <-18.169164, 29.094215, 21.445803>
  }
  sphere { // sheild3
    <0,0,0>,1
    scale <0.5, 6.0, 8.0>
    rotate -2.0*z
    translate  <-18.169164, 47.742739, 21.445803>
  }
  sphere { // sheild4
    <0,0,0>,1
    scale <0.5, 6.0, 8.0>
    rotate -4.0*z
    translate  <-17.159508, 66.391264, 21.445803>
  }
  sphere { // sheild5
    <0,0,0>,1
    scale <0.5, 6.0, 8.0>
    rotate -8.0*z
    translate  <-14.803645, 84.107362, 22.37823>
  }
  sphere { // sheild6
    <0,0,0>,1
    scale <0.5, 6.0, 8.0>
    rotate -10.0*z
    translate  <-12.027092, 101.776337, 22.37823>
  }
  sphere { // sheild7
    <0,0,0>,1
    scale <0.5, 6.0, 8.0>
    rotate 10.0*z
    translate  <13.817544, 101.776337, 22.37823>
  }
  sphere { // sheild8
    <0,0,0>,1
    scale <0.5, 6.0, 8.0>
    rotate 8.0*z
    translate  <16.500611, 84.107362, 22.37823>
  }
  sphere { // sheild9
    <0,0,0>,1
    scale <0.5, 6.0, 8.0>
    rotate 4.0*z
    translate  <18.11324, 66.391264, 21.445803>
  }
  sphere { // sheild10
    <0,0,0>,1
    scale <0.5, 6.0, 8.0>
    translate  <18.328332, 47.742739, 21.445803>
  }
  sphere { // sheild11
    <0,0,0>,1
    scale <0.5, 6.0, 8.0>
    rotate -2.0*z
    translate  <17.593484, 29.094215, 21.445803>
  }
  sphere { // sheild12
    <0,0,0>,1
    scale <0.5, 6.0, 8.0>
    rotate -6.0*z
    translate  <16.138714, 11.616713, 21.445803>
  }
  sphere { // sheild13
    <0,0,0>,1
    scale <0.5, 6.0, 8.0>
    rotate -7.0*z
    translate  <13.65733, -4.662131, 22.37823>
  }
  texture {
    ShieldTexture
  }
}
union { // whole_ship
  object { whole_keel }
  object { ship_sides }
  object { hd }
  box { // hd_neck
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.3, 5.0>
    translate  <0.0, -58.192195, 35.711745>
  }
  box { // hd_neck2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 3.0, 3.2>
    rotate 35.0*x
    translate  <0.0, -60.275583, 33.742699>
  }
  cone { // hd_fin
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.5, 0.8, 5.0>
    rotate 160.0*x
    translate  <0.0, -64.78261, 50.017454>
  }
  cone { // hd_fin1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.5, 0.8, 6.0>
    rotate 140.0*x
    translate  <0.0, -60.476007, 49.834851>
  }
  cone { // hd_fin2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.5, 0.8, 8.0>
    rotate 120.0*x
    translate  <0.0, -55.705405, 48.826566>
  }
  cone { // hd_fin3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.5, 0.8, 10.0>
    rotate 100.0*x
    translate  <0.0, -50.84218, 45.893455>
  }
  cone { // hd_fin4
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.5, 0.8, 12.0>
    rotate 80.0*x
    translate  <0.0, -47.89497, 41.398081>
  }
  cone { // hd_fin5
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.5, 0.8, 14.0>
    rotate 60.0*x
    translate  <0.0, -46.880517, 35.796511>
  }
  cone { // hd_fin6
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.5, 0.8, 16.0>
    rotate 40.0*x
    translate  <0.0, -50.119016, 31.512724>
  }
  object { ship_sides1 }
  cylinder { // mast
    <0,0,1>, <0,0,0>, 1 
    texture {
      HullTexture
    }
    scale <1.5, 1.5, 200.0>
    translate  <0.0, 45.470596, 2.845>
  }
  cylinder { // mast1
    <0,0,1>, <0,0,0>, 1 
    texture {
      HullTexture
    }
    scale <1.5, 1.5, 100.0>
    rotate -90.0*y
    translate  <50.0, 43.012024, 50.0>
  }
  cylinder { // mast2
    <0,0,1>, <0,0,0>, 1 
    texture {
      HullTexture
    }
    scale <1.5, 1.5, 65.0>
    rotate -90.0*y
    translate  <33.0, 43.146866, 164.992471>
  }
  object { main_sail }
  object { nest }
  object { ship_floor }
  object { fore_bridge }
  object { aft_bridge }
  box { // hatch
    <-1, -1, -1>, <1, 1, 1>
    texture {
      HatchTexture
    }
    scale <3.0, 3.0, 2.0>
    translate  <0.0, 64.697131, 9.446737>
  }
  object { benches }
  object { shlds }
  texture {
    HullTexture
  }
  scale 0.05
  rotate -346.0*z
  translate  <8.951945, 6.154462, 0.8024>
}


