#include "colors.inc"
#include "spacedog.inc"
#include "finger.inc"

global_settings
{ ambient_light .01
}

atmosphere
 { type 1
  distance 500
  scattering .0025
  samples 10
  aa_threshold .1 aa_level 10
  colour 1
}

camera
{ location <-1500*0,0,-1100>
  look_at 0
  angle 35
}

light_source
{ <-1000,0,0> color <.4,.8,1>*1.5 atmosphere off
  area_light z*100,y*100,10,10 adaptive 0
}

light_source
{ <0,2500,-1000> color .8 atmosphere off
  spotlight point_at <0,0,-1000> radius 1 falloff 1
}


// Lamp
union
{ union
  { sphere
    { 0,5
      pigment
      { gradient y
        color_map
        { [0 rgbt <0,0,0,1>]
          [.2 rgbt <0,0,0,1>]
          [.24 rgbt <0,0,0,0>]
          [.48 rgbt <0,0,0,0>]
          [.48 rgbt <0,0,0,1>]
          [1 rgbt <0,0,0,1>]
        }
        scale 10 translate -5
      }
      finish { ambient 100 }
    }
    sphere
    { 0,8 no_shadow pigment { rgb <1,1,.5> } finish { ambient 100 }
    }
    light_source
    { 0 color <1,1,.5>
      fade_distance 300
      fade_power 2
      area_light x*50,z*50,10,10 adaptive 0
    }

    translate <-40,300,300>
  }
  union
  { difference
    { sphere { 0,55 }
      sphere { 0,53 }
      box { <-56,-56,-56><56,35,56> }
      translate <-40,263,300>
    }
    difference
    { torus { 45,8 rotate z*90 }
      box { <-9,-54,-54><9,0,54> }
      translate <-40,260+49,345>
    }
    cylinder { <-40,260+49,345+45><-40,-235,345+45>,8 }
    difference
    { cone { 0,15,<0,-235+80,0>,25 }
      #declare Ang=0
      #while (Ang<360)
        cylinder { <0,0,-15><0,-235+80,-25>,5 scale 1.2 rotate y*Ang }
        #declare Ang=Ang+30
      #end

      translate <-40,-80,345+45>
    }

    pigment { rgb <.1,.3,.1> }
    finish { specular .2 roughness .05 }
  }

  translate -x*15
}

object
{ Dog
  rotate y*70
}

// Ground
plane
{ y,-235
  pigment
  { bozo
    color_map
    { [0 rgb .2]
      [.1 rgb .4]
      [.2 rgb .2]
      [1 rgb .2]
    }
    turbulence .5 scale 20
  }
  normal { bumps .5 scale 2 }
  finish { specular .3 roughness .08 }
}

// Walls
box
{ <200,-235,-100><500,500,-1500>
  pigment { brick rgb .4,rgb .6 scale 15 translate z*7 }
  normal { bumps .8 scale 3 }
  finish { ambient 15 }
}
box
{ <-200,-235,-100><-500,500,-1500>
  pigment { brick rgb .7,rgb 1 scale 15 translate z*7 }
  normal { bumps .8 scale 3 }
  finish { ambient 7 }
}
plane
{ -z,-650
  pigment { brick rgb <.15,.1,.06>,rgb <.23,.18,.1> scale 15 }
  normal { bumps .5 scale 3 }
}

// Trashcans
#declare Trashcan=
union
{ difference
  { cylinder { -y*70,y*70,50 }
    #declare Ang=0
    #while (Ang<360)
      union
      { cylinder { <0,-60,-52>,<0,60,-54>,5 }
        sphere { <0,-60,-54>,5 }
        sphere { <0,60,-54>,5 }
        rotate y*Ang
      }
      #declare Ang=Ang+10
    #end
  }
  cylinder { y*70,y*80,55 }
  difference
  { cylinder { -z*2,z*2,17 }
    cylinder { -z*2.1,z*2.1,15 }
    translate y*77
  }
  bounded_by { cylinder { -y*70,y*(77+17),55 } }

  pigment { rgb <.5,.7,1>*.9 }
  finish { specular .2 roughness .05 }
}

object
{ Trashcan
  translate <200,-235+70,560>
}
object
{ Trashcan rotate y*50
  translate <330,-235+70,520>
}

// Fingers
object
{ Finger scale 2 rotate <0,0,310> rotate <-20,-20,0> rotate -x*10
  translate <30,-15,-1000>
}
object
{ Finger scale 2 rotate <0,0,290> rotate <-20,-20,0>
  translate <28,-22,-1000>
}
object
{ Finger scale 2 rotate <0,0,260> rotate <-20,-20,0>
  translate <25,-30,-1000>
}

// Liquid
blob
{ threshold .9
  sphere { 0,60,1 }
  sphere { <30,0,0>,25,.2 }
  sphere { <-25,-25,0>,25,.4 }
  scale <1,1,.2>
  bounded_by { box { <-25,-25,-3><24,14,3> } }

  pigment
  { gradient y
    color_map
    { [0 rgb <0,1,0>*.5]
      [.2 rgb <.2,1,0>*.5]
      [.5 rgb <1,1,0>*.5]
      [.8 rgb <.2,1,0>*.5]
      [1 rgb <0,1,0>*.5]
    }
    turbulence 1
    scale 5
  }
  finish { specular .5 roughness .05 }

  scale 4
  rotate x*90
  translate <-200,-235,500>
}

