//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 1 lights, 4 textures and 564 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.0 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 04/11/1998    (11.04.1998)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <-240.000, -190.000, -26.500>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <-18.250, -4.500, -21.500>
}

//
// *******  L I G H T S *******
//

light_source {   // Light1
  <-179.000, -262.750, -6.250>
  color rgb <1.000, 1.000, 1.000>
}


//
// ********  TEXTURES  *******
//

#include "trans2.inc"


//
// ********  REFERENCED OBJECTS  *******
//


#declare galaxy_seed = 1275372306

#declare galaxy_colour1 = <0.75,1.25,1.116>
#declare galaxy_colour2 = <0.727,0.55,1.05>
#declare galaxy_pattern_scale = 0.686
#declare galaxy_pattern_origin = <5.547,17.263,5.555>
#declare galaxy_turb_origin = <-16.447,5.805,-24.564>
#declare galaxy_star_colouration = -0.101

#declare galaxy_bg_stars = 1
#declare galaxy_bg_nebula = 1
#declare galaxy_nebula_sphere = 3
#declare galaxy_nebula_ambient = <1.034,1.000,0.996>

#declare galaxy_object_name = ""
#declare galaxy_object_scale = 0.000001
#declare galaxy_object_flatten = 0.563
#declare galaxy_object_rotate = -44.8
#declare galaxy_cluster_name = ""
#declare galaxy_cluster_objects = 0
#declare galaxy_cluster_scale = 0.0000001
#declare galaxy_cluster_rotate = -44.8

#declare star_type = 2
#declare star_colour = <1,1,1>
#declare star_colour_turb = <0.8,0.8,0.8>
#include "GALAXY.INC"



//
// ********  OBJECTS  *******
//
#declare H=0
#declare A=0 #while(A>=-180)
  box { // Cube008
    <-1,-35.5,-60>, <1,-39.5,-35>
    rotate A*z
    translate H*z
    translate -29.75*x
    texture {
      NTex
    }
  }
#declare A=A-3 #declare H=H-0.5 #end

object {   // HgtFld001
  height_field {
    tga "C:\IMAGES\OUTPUT.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <100.0, 100.0, 50.0>
  translate  <-16.0, 0.0, -84.25>
  texture {
    SemTex
  }
}


#declare CSG22 = union {
  box { // Cube41
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, -1.5, 2.0>
  }
  box { // Cube42
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, 1.5, 2.0>
  }
  cylinder { // Cylndr388
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr389
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -1.5, 0.0>
  }
  cylinder { // Cylndr390
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr391
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 4.0>
  }
  cylinder { // Cylndr392
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 3.0>
  }
  cylinder { // Cylndr393
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 2.0>
  }
  cylinder { // Cylndr394
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -0.5, 0.0>
  }
  cylinder { // Cylndr395
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 1.0>
  }
  cylinder { // Cylndr396
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 1.0>
  }
  cylinder { // Cylndr397
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 3.0>
  }
  cylinder { // Cylndr398
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 2.0>
  }
  cylinder { // Cylndr399
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 1.5, 0.0>
  }
  cylinder { // Cylndr400
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.25, 0.5, 0.0>
  }
  cylinder { // Cylndr401
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 4.0>
  }
  cylinder { // Cylndr402
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 0.5, 0.0>
  }
  cylinder { // Cylndr403
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 2.5, 0.0>
  }
  rotate 180.0*z
  translate  <7.75, -15.0, -39.75>
}
#declare CSG21 = union {
  box { // Cube39
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, -1.5, 2.0>
  }
  box { // Cube40
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, 1.5, 2.0>
  }
  cylinder { // Cylndr372
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr373
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -1.5, 0.0>
  }
  cylinder { // Cylndr374
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr375
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 4.0>
  }
  cylinder { // Cylndr376
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 3.0>
  }
  cylinder { // Cylndr377
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 2.0>
  }
  cylinder { // Cylndr378
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -0.5, 0.0>
  }
  cylinder { // Cylndr379
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 1.0>
  }
  cylinder { // Cylndr380
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 1.0>
  }
  cylinder { // Cylndr381
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 3.0>
  }
  cylinder { // Cylndr382
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 2.0>
  }
  cylinder { // Cylndr383
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 1.5, 0.0>
  }
  cylinder { // Cylndr384
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.25, 0.5, 0.0>
  }
  cylinder { // Cylndr385
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 4.0>
  }
  cylinder { // Cylndr386
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 0.5, 0.0>
  }
  cylinder { // Cylndr387
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 2.5, 0.0>
  }
  rotate 180.0*z
  translate  <7.75, 13.25, -39.75>
}
#declare CSG20 = union {
  box { // Cube37
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, -1.5, 2.0>
  }
  box { // Cube38
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, 1.5, 2.0>
  }
  cylinder { // Cylndr356
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr357
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -1.5, 0.0>
  }
  cylinder { // Cylndr358
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr359
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 4.0>
  }
  cylinder { // Cylndr360
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 3.0>
  }
  cylinder { // Cylndr361
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 2.0>
  }
  cylinder { // Cylndr362
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -0.5, 0.0>
  }
  cylinder { // Cylndr363
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 1.0>
  }
  cylinder { // Cylndr364
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 1.0>
  }
  cylinder { // Cylndr365
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 3.0>
  }
  cylinder { // Cylndr366
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 2.0>
  }
  cylinder { // Cylndr367
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 1.5, 0.0>
  }
  cylinder { // Cylndr368
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.25, 0.5, 0.0>
  }
  cylinder { // Cylndr369
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 4.0>
  }
  cylinder { // Cylndr370
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 0.5, 0.0>
  }
  cylinder { // Cylndr371
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 2.5, 0.0>
  }
  rotate 180.0*z
  translate  <7.75, 13.25, -29.75>
}
#declare CSG19 = union {
  box { // Cube35
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, -1.5, 2.0>
  }
  box { // Cube36
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, 1.5, 2.0>
  }
  cylinder { // Cylndr340
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr341
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -1.5, 0.0>
  }
  cylinder { // Cylndr342
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr343
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 4.0>
  }
  cylinder { // Cylndr344
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 3.0>
  }
  cylinder { // Cylndr345
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 2.0>
  }
  cylinder { // Cylndr346
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -0.5, 0.0>
  }
  cylinder { // Cylndr347
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 1.0>
  }
  cylinder { // Cylndr348
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 1.0>
  }
  cylinder { // Cylndr349
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 3.0>
  }
  cylinder { // Cylndr350
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 2.0>
  }
  cylinder { // Cylndr351
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 1.5, 0.0>
  }
  cylinder { // Cylndr352
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.25, 0.5, 0.0>
  }
  cylinder { // Cylndr353
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 4.0>
  }
  cylinder { // Cylndr354
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 0.5, 0.0>
  }
  cylinder { // Cylndr355
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 2.5, 0.0>
  }
  rotate 180.0*z
  translate  <7.75, -15.0, -29.75>
}
#declare CSG18 = union {
  box { // Cube33
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, -1.5, 2.0>
  }
  box { // Cube34
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, 1.5, 2.0>
  }
  cylinder { // Cylndr324
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr325
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -1.5, 0.0>
  }
  cylinder { // Cylndr326
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr327
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 4.0>
  }
  cylinder { // Cylndr328
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 3.0>
  }
  cylinder { // Cylndr329
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 2.0>
  }
  cylinder { // Cylndr330
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -0.5, 0.0>
  }
  cylinder { // Cylndr331
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 1.0>
  }
  cylinder { // Cylndr332
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 1.0>
  }
  cylinder { // Cylndr333
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 3.0>
  }
  cylinder { // Cylndr334
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 2.0>
  }
  cylinder { // Cylndr335
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 1.5, 0.0>
  }
  cylinder { // Cylndr336
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.25, 0.5, 0.0>
  }
  cylinder { // Cylndr337
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 4.0>
  }
  cylinder { // Cylndr338
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 0.5, 0.0>
  }
  cylinder { // Cylndr339
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 2.5, 0.0>
  }
  rotate 180.0*z
  translate  <7.75, -15.0, -19.75>
}
#declare CSG17 = union {
  box { // Cube31
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, -1.5, 2.0>
  }
  box { // Cube32
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, 1.5, 2.0>
  }
  cylinder { // Cylndr308
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr309
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -1.5, 0.0>
  }
  cylinder { // Cylndr310
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr311
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 4.0>
  }
  cylinder { // Cylndr312
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 3.0>
  }
  cylinder { // Cylndr313
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 2.0>
  }
  cylinder { // Cylndr314
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -0.5, 0.0>
  }
  cylinder { // Cylndr315
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 1.0>
  }
  cylinder { // Cylndr316
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 1.0>
  }
  cylinder { // Cylndr317
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 3.0>
  }
  cylinder { // Cylndr318
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 2.0>
  }
  cylinder { // Cylndr319
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 1.5, 0.0>
  }
  cylinder { // Cylndr320
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.25, 0.5, 0.0>
  }
  cylinder { // Cylndr321
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 4.0>
  }
  cylinder { // Cylndr322
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 0.5, 0.0>
  }
  cylinder { // Cylndr323
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 2.5, 0.0>
  }
  rotate 180.0*z
  translate  <7.75, 13.25, -19.75>
}
#declare TapSwp002 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  7  // control points
  <-1.0, -0.5>,
  <-0.5, -1.0>,
  <0.5, -1.0>,
  <1.0, -0.5>,
  <1.0, 0.0>,
  <-1.0, 0.0>,
  <-1.0, -0.5>
  rotate <90,0,90>
  scale 10.0
  rotate 180.0*x
  translate  <-10.0, 0.0, -12.5>
  texture {
    Texture1
    // Transform to world space
    translate <9.000000, 12.750000, -8.250000>
  }
}
#declare CSG16 = union {
  box { // Cube29
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, -1.5, 2.0>
  }
  box { // Cube30
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, 1.5, 2.0>
  }
  cylinder { // Cylndr292
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr293
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -1.5, 0.0>
  }
  cylinder { // Cylndr294
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr295
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 4.0>
  }
  cylinder { // Cylndr296
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 3.0>
  }
  cylinder { // Cylndr297
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 2.0>
  }
  cylinder { // Cylndr298
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -0.5, 0.0>
  }
  cylinder { // Cylndr299
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 1.0>
  }
  cylinder { // Cylndr300
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 1.0>
  }
  cylinder { // Cylndr301
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 3.0>
  }
  cylinder { // Cylndr302
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 2.0>
  }
  cylinder { // Cylndr303
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 1.5, 0.0>
  }
  cylinder { // Cylndr304
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.25, 0.5, 0.0>
  }
  cylinder { // Cylndr305
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 4.0>
  }
  cylinder { // Cylndr306
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 0.5, 0.0>
  }
  cylinder { // Cylndr307
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 2.5, 0.0>
  }
  rotate 45.0*z
  translate  <-16.0, -5.75, -39.5>
}
#declare CSG15 = union {
  box { // Cube27
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, -1.5, 2.0>
  }
  box { // Cube28
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, 1.5, 2.0>
  }
  cylinder { // Cylndr276
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr277
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -1.5, 0.0>
  }
  cylinder { // Cylndr278
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr279
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 4.0>
  }
  cylinder { // Cylndr280
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 3.0>
  }
  cylinder { // Cylndr281
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 2.0>
  }
  cylinder { // Cylndr282
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -0.5, 0.0>
  }
  cylinder { // Cylndr283
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 1.0>
  }
  cylinder { // Cylndr284
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 1.0>
  }
  cylinder { // Cylndr285
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 3.0>
  }
  cylinder { // Cylndr286
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 2.0>
  }
  cylinder { // Cylndr287
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 1.5, 0.0>
  }
  cylinder { // Cylndr288
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.25, 0.5, 0.0>
  }
  cylinder { // Cylndr289
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 4.0>
  }
  cylinder { // Cylndr290
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 0.5, 0.0>
  }
  cylinder { // Cylndr291
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 2.5, 0.0>
  }
  rotate 45.0*z
  translate  <-16.0, -5.75, -29.75>
}
#declare CSG14 = union {
  box { // Cube25
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, -1.5, 2.0>
  }
  box { // Cube26
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, 1.5, 2.0>
  }
  cylinder { // Cylndr260
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr261
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -1.5, 0.0>
  }
  cylinder { // Cylndr262
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr263
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 4.0>
  }
  cylinder { // Cylndr264
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 3.0>
  }
  cylinder { // Cylndr265
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 2.0>
  }
  cylinder { // Cylndr266
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -0.5, 0.0>
  }
  cylinder { // Cylndr267
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 1.0>
  }
  cylinder { // Cylndr268
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 1.0>
  }
  cylinder { // Cylndr269
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 3.0>
  }
  cylinder { // Cylndr270
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 2.0>
  }
  cylinder { // Cylndr271
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 1.5, 0.0>
  }
  cylinder { // Cylndr272
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.25, 0.5, 0.0>
  }
  cylinder { // Cylndr273
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 4.0>
  }
  cylinder { // Cylndr274
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 0.5, 0.0>
  }
  cylinder { // Cylndr275
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 2.5, 0.0>
  }
  rotate -45.0*z
  translate  <-16.0, 5.75, -29.75>
}
#declare CSG13 = union {
  box { // Cube23
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, -1.5, 2.0>
  }
  box { // Cube24
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, 1.5, 2.0>
  }
  cylinder { // Cylndr244
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr245
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -1.5, 0.0>
  }
  cylinder { // Cylndr246
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr247
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 4.0>
  }
  cylinder { // Cylndr248
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 3.0>
  }
  cylinder { // Cylndr249
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 2.0>
  }
  cylinder { // Cylndr250
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -0.5, 0.0>
  }
  cylinder { // Cylndr251
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 1.0>
  }
  cylinder { // Cylndr252
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 1.0>
  }
  cylinder { // Cylndr253
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 3.0>
  }
  cylinder { // Cylndr254
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 2.0>
  }
  cylinder { // Cylndr255
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 1.5, 0.0>
  }
  cylinder { // Cylndr256
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.25, 0.5, 0.0>
  }
  cylinder { // Cylndr257
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 4.0>
  }
  cylinder { // Cylndr258
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 0.5, 0.0>
  }
  cylinder { // Cylndr259
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 2.5, 0.0>
  }
  rotate -45.0*z
  translate  <-16.0, 5.75, -39.5>
}
#declare CSG12 = union {
  box { // Cube21
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, -1.5, 2.0>
  }
  box { // Cube22
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, 1.5, 2.0>
  }
  cylinder { // Cylndr228
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr229
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -1.5, 0.0>
  }
  cylinder { // Cylndr230
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr231
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 4.0>
  }
  cylinder { // Cylndr232
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 3.0>
  }
  cylinder { // Cylndr233
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 2.0>
  }
  cylinder { // Cylndr234
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -0.5, 0.0>
  }
  cylinder { // Cylndr235
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 1.0>
  }
  cylinder { // Cylndr236
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 1.0>
  }
  cylinder { // Cylndr237
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 3.0>
  }
  cylinder { // Cylndr238
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 2.0>
  }
  cylinder { // Cylndr239
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 1.5, 0.0>
  }
  cylinder { // Cylndr240
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.25, 0.5, 0.0>
  }
  cylinder { // Cylndr241
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 4.0>
  }
  cylinder { // Cylndr242
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 0.5, 0.0>
  }
  cylinder { // Cylndr243
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 2.5, 0.0>
  }
  translate  <-17.75, 0.0, -39.5>
}
#declare CSG11 = union {
  box { // Cube19
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, -1.5, 2.0>
  }
  box { // Cube20
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, 1.5, 2.0>
  }
  cylinder { // Cylndr212
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr213
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -1.5, 0.0>
  }
  cylinder { // Cylndr214
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr215
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 4.0>
  }
  cylinder { // Cylndr216
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 3.0>
  }
  cylinder { // Cylndr217
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 2.0>
  }
  cylinder { // Cylndr218
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -0.5, 0.0>
  }
  cylinder { // Cylndr219
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 1.0>
  }
  cylinder { // Cylndr220
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 1.0>
  }
  cylinder { // Cylndr221
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 3.0>
  }
  cylinder { // Cylndr222
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 2.0>
  }
  cylinder { // Cylndr223
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 1.5, 0.0>
  }
  cylinder { // Cylndr224
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.25, 0.5, 0.0>
  }
  cylinder { // Cylndr225
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 4.0>
  }
  cylinder { // Cylndr226
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 0.5, 0.0>
  }
  cylinder { // Cylndr227
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 2.5, 0.0>
  }
  translate  <-17.75, 0.0, -29.75>
}
#declare TraSwp004 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-1.0, -0.5>,
  <-0.5, -1.0>,
  <0.0, -1.0>,
  <0.0, 1.0>,
  <-0.5, 1.0>,
  <-1.0, 0.5>,
  <-1.0, -0.5>
  rotate -x*90
  scale <10.0, 10.0, 20.0>
  translate  <-10.0, 0.0, -42.5>
  texture {
    Texture1
    // Transform to world space
    translate <9.000000, 12.750000, -8.250000>
  }
}
#declare CSG10 = union {
  box { // Cube17
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, -1.5, 2.0>
  }
  box { // Cube18
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, 1.5, 2.0>
  }
  cylinder { // Cylndr196
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr197
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -1.5, 0.0>
  }
  cylinder { // Cylndr198
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr199
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 4.0>
  }
  cylinder { // Cylndr200
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 3.0>
  }
  cylinder { // Cylndr201
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 2.0>
  }
  cylinder { // Cylndr202
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -0.5, 0.0>
  }
  cylinder { // Cylndr203
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 1.0>
  }
  cylinder { // Cylndr204
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 1.0>
  }
  cylinder { // Cylndr205
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 3.0>
  }
  cylinder { // Cylndr206
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 2.0>
  }
  cylinder { // Cylndr207
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 1.5, 0.0>
  }
  cylinder { // Cylndr208
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.25, 0.5, 0.0>
  }
  cylinder { // Cylndr209
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 4.0>
  }
  cylinder { // Cylndr210
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 0.5, 0.0>
  }
  cylinder { // Cylndr211
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 2.5, 0.0>
  }
  translate  <-7.75, -15.0, -39.75>
}
#declare CSG9 = union {
  box { // Cube15
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, -1.5, 2.0>
  }
  box { // Cube16
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, 1.5, 2.0>
  }
  cylinder { // Cylndr180
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr181
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -1.5, 0.0>
  }
  cylinder { // Cylndr182
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr183
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 4.0>
  }
  cylinder { // Cylndr184
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 3.0>
  }
  cylinder { // Cylndr185
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 2.0>
  }
  cylinder { // Cylndr186
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -0.5, 0.0>
  }
  cylinder { // Cylndr187
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 1.0>
  }
  cylinder { // Cylndr188
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 1.0>
  }
  cylinder { // Cylndr189
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 3.0>
  }
  cylinder { // Cylndr190
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 2.0>
  }
  cylinder { // Cylndr191
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 1.5, 0.0>
  }
  cylinder { // Cylndr192
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.25, 0.5, 0.0>
  }
  cylinder { // Cylndr193
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 4.0>
  }
  cylinder { // Cylndr194
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 0.5, 0.0>
  }
  cylinder { // Cylndr195
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 2.5, 0.0>
  }
  translate  <-7.75, -15.0, -29.75>
}
#declare CSG8 = union {
  box { // Cube13
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, -1.5, 2.0>
  }
  box { // Cube14
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, 1.5, 2.0>
  }
  cylinder { // Cylndr164
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr165
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -1.5, 0.0>
  }
  cylinder { // Cylndr166
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr167
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 4.0>
  }
  cylinder { // Cylndr168
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 3.0>
  }
  cylinder { // Cylndr169
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 2.0>
  }
  cylinder { // Cylndr170
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -0.5, 0.0>
  }
  cylinder { // Cylndr171
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 1.0>
  }
  cylinder { // Cylndr172
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 1.0>
  }
  cylinder { // Cylndr173
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 3.0>
  }
  cylinder { // Cylndr174
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 2.0>
  }
  cylinder { // Cylndr175
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 1.5, 0.0>
  }
  cylinder { // Cylndr176
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.25, 0.5, 0.0>
  }
  cylinder { // Cylndr177
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 4.0>
  }
  cylinder { // Cylndr178
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 0.5, 0.0>
  }
  cylinder { // Cylndr179
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 2.5, 0.0>
  }
  translate  <-7.75, -15.0, -19.75>
}
#declare CSG7 = union {
  box { // Cube11
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, -1.5, 2.0>
  }
  box { // Cube12
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, 1.5, 2.0>
  }
  cylinder { // Cylndr148
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr149
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -1.5, 0.0>
  }
  cylinder { // Cylndr150
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr151
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 4.0>
  }
  cylinder { // Cylndr152
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 3.0>
  }
  cylinder { // Cylndr153
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 2.0>
  }
  cylinder { // Cylndr154
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -0.5, 0.0>
  }
  cylinder { // Cylndr155
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 1.0>
  }
  cylinder { // Cylndr156
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 1.0>
  }
  cylinder { // Cylndr157
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 3.0>
  }
  cylinder { // Cylndr158
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 2.0>
  }
  cylinder { // Cylndr159
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 1.5, 0.0>
  }
  cylinder { // Cylndr160
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.25, 0.5, 0.0>
  }
  cylinder { // Cylndr161
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 4.0>
  }
  cylinder { // Cylndr162
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 0.5, 0.0>
  }
  cylinder { // Cylndr163
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 2.5, 0.0>
  }
  translate  <-7.75, 13.25, -39.75>
}
#declare CSG6 = union {
  box { // Cube9
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, -1.5, 2.0>
  }
  box { // Cube10
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, 1.5, 2.0>
  }
  cylinder { // Cylndr132
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr133
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -1.5, 0.0>
  }
  cylinder { // Cylndr134
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr135
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 4.0>
  }
  cylinder { // Cylndr136
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 3.0>
  }
  cylinder { // Cylndr137
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 2.0>
  }
  cylinder { // Cylndr138
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -0.5, 0.0>
  }
  cylinder { // Cylndr139
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 1.0>
  }
  cylinder { // Cylndr140
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 1.0>
  }
  cylinder { // Cylndr141
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 3.0>
  }
  cylinder { // Cylndr142
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 2.0>
  }
  cylinder { // Cylndr143
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 1.5, 0.0>
  }
  cylinder { // Cylndr144
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.25, 0.5, 0.0>
  }
  cylinder { // Cylndr145
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 4.0>
  }
  cylinder { // Cylndr146
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 0.5, 0.0>
  }
  cylinder { // Cylndr147
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 2.5, 0.0>
  }
  translate  <-7.75, 13.25, -29.75>
}
#declare CSG5 = union {
  box { // Cube7
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, -1.5, 2.0>
  }
  box { // Cube8
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, 1.5, 2.0>
  }
  cylinder { // Cylndr116
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr117
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -1.5, 0.0>
  }
  cylinder { // Cylndr118
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr119
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 4.0>
  }
  cylinder { // Cylndr120
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 3.0>
  }
  cylinder { // Cylndr121
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 2.0>
  }
  cylinder { // Cylndr122
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -0.5, 0.0>
  }
  cylinder { // Cylndr123
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 1.0>
  }
  cylinder { // Cylndr124
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 1.0>
  }
  cylinder { // Cylndr125
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 3.0>
  }
  cylinder { // Cylndr126
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 2.0>
  }
  cylinder { // Cylndr127
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 1.5, 0.0>
  }
  cylinder { // Cylndr128
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.25, 0.5, 0.0>
  }
  cylinder { // Cylndr129
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 4.0>
  }
  cylinder { // Cylndr130
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 0.5, 0.0>
  }
  cylinder { // Cylndr131
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 2.5, 0.0>
  }
  translate  <-7.75, 13.25, -19.75>
}
//
// Include file contains 'RotSwp6'
//
#include "trans2.in1"
#declare RotSwp6 = object {
  RotSwp6_Raw
  scale <1.5, 1.5, 3.0>
  rotate 90.0*z
  translate  <10.0, 20.0, -2.5>
  texture {
    Texture1
    // Transform to world space
    translate <9.000000, 12.750000, -8.250000>
  }
}
// Include contains 'TraSwp10'
#include "trans2.in2"

#declare TraSwp10 = object {
  TraSwp10_Raw
  rotate 90.0*x
  translate  <-1.5, -20.0, -40.0>
  texture {
    DMFLightOak
    // Transform to world space
    translate <9.000000, 12.750000, -8.250000>
  }
}
// Include contains 'TraSwp9'
#include "trans2.in3"

#declare TraSwp9 = object {
  TraSwp9_Raw
  rotate 90.0*x
  translate  <1.5, -20.0, -35.0>
  texture {
    DMFLightOak
    // Transform to world space
    translate <9.000000, 12.750000, -8.250000>
  }
}
// Include contains 'TraSwp8'
#include "trans2.in4"

#declare TraSwp8 = object {
  TraSwp8_Raw
  rotate 90.0*x
  translate  <1.5, -20.0, -37.5>
  texture {
    DMFLightOak
    // Transform to world space
    translate <9.000000, 12.750000, -8.250000>
  }
}
// Include contains 'TraSwp7'
#include "trans2.in5"

#declare TraSwp7 = object {
  TraSwp7_Raw
  rotate 90.0*x
  translate  <1.5, -20.0, -40.0>
  texture {
    DMFLightOak
    // Transform to world space
    translate <9.000000, 12.750000, -8.250000>
  }
}
// Include contains 'TraSwp6'
#include "trans2.in6"

#declare TraSwp6 = object {
  TraSwp6_Raw
  rotate 90.0*x
  translate  <-1.5, -20.0, -37.5>
  texture {
    DMFLightOak
    // Transform to world space
    translate <9.000000, 12.750000, -8.250000>
  }
}
// Include contains 'TraSwp003'
#include "trans2.in7"

#declare TraSwp003 = object {
  TraSwp003_Raw
  rotate 90.0*x
  translate  <-1.5, -20.0, -35.0>
  texture {
    DMFLightOak
    // Transform to world space
    translate <9.000000, 12.750000, -8.250000>
  }
}
//
// Include file contains 'RotSwp5'
//
#include "trans2.in8"
#declare RotSwp5 = object {
  RotSwp5_Raw
  texture {
    Texture2
  }
  translate  <4.5, -30.5, -41.5>
}
//
// Include file contains 'RotSwp002'
//
#include "trans2.in9"
#declare RotSwp002 = object {
  RotSwp002_Raw
  texture {
    Texture2
  }
  translate  <-4.5, -30.5, -41.5>
}
// Include contains 'TraSwp001'
#include "trans2.i10"

#declare TraSwp001 = object {
  TraSwp001_Raw
  scale <1.0, 1.0, 12.0>
  rotate 90.0*x
  translate  <0.0, -20.0, -32.0>
  texture {
    Texture1
    // Transform to world space
    translate <9.000000, 12.750000, -8.250000>
  }
}
#declare TapSwp001 = prism {
  conic_sweep
  linear_spline
  1.0,2.0
  5  // control points
  <-3.25, -2.25>,
  <3.25, -2.25>,
  <3.25, 2.25>,
  <-3.25, 2.25>,
  <-3.25, -2.25>
  rotate <90,0,90>
  scale <1.0, 1.0, 3.0>
  rotate 180.0*x
  translate  1.5*z
  texture {
    Texture1
    // Transform to world space
    translate <9.000000, 12.750000, -8.250000>
  }
}
#declare CSG4 = union {
  box { // Cube5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, -1.5, 2.0>
  }
  box { // Cube6
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, 1.5, 2.0>
  }
  cylinder { // Cylndr43
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr44
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -1.5, 0.0>
  }
  cylinder { // Cylndr45
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr46
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 4.0>
  }
  cylinder { // Cylndr47
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 3.0>
  }
  cylinder { // Cylndr48
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 2.0>
  }
  cylinder { // Cylndr49
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -0.5, 0.0>
  }
  cylinder { // Cylndr50
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 1.0>
  }
  cylinder { // Cylndr51
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 1.0>
  }
  cylinder { // Cylndr52
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 3.0>
  }
  cylinder { // Cylndr53
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 2.0>
  }
  cylinder { // Cylndr54
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 1.5, 0.0>
  }
  cylinder { // Cylndr55
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.25, 0.5, 0.0>
  }
  cylinder { // Cylndr56
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 4.0>
  }
  cylinder { // Cylndr57
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 0.5, 0.0>
  }
  cylinder { // Cylndr58
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 2.5, 0.0>
  }
  rotate 180.0*z
}
#declare CSG003 = union {
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, -1.5, 2.0>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture3
    }
    scale <0.25, 1.0, 2.0>
    translate  <-2.25, 1.5, 2.0>
  }
  cylinder { // Cylndr42
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr41
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -1.5, 0.0>
  }
  cylinder { // Cylndr40
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 0.0>
  }
  cylinder { // Cylndr39
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 4.0>
  }
  cylinder { // Cylndr38
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 3.0>
  }
  cylinder { // Cylndr37
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 2.0>
  }
  cylinder { // Cylndr36
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, -0.5, 0.0>
  }
  cylinder { // Cylndr35
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, -2.5, 1.0>
  }
  cylinder { // Cylndr34
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 1.0>
  }
  cylinder { // Cylndr33
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 3.0>
  }
  cylinder { // Cylndr32
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 2.0>
  }
  cylinder { // Cylndr31
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 1.5, 0.0>
  }
  cylinder { // Cylndr30
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.25, 0.5, 0.0>
  }
  cylinder { // Cylndr29
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <-2.5, 0.5, 4.0>
  }
  cylinder { // Cylndr28
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 0.5, 0.0>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.1, 0.1, 4.0>
    translate  <-2.5, 2.5, 0.0>
  }
}
#declare CSG002 = union {
  cylinder { // Cylndr27
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 4.0>
    rotate -90.0*x
    translate  <0.95, -2.0, 9.25>
  }
  cylinder { // Cylndr26
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 4.0>
    rotate -90.0*x
    translate  <-0.95, -2.0, 9.25>
  }
  cylinder { // Cylndr25
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 2.0>
    rotate -90.0*y
    translate  <1.0, -1.95, 9.25>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 2.0>
    rotate -90.0*y
    translate  <1.0, 1.95, 9.25>
  }
  cylinder { // Cylndr24
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    translate  <0.475, -1.95, 8.5>
  }
  cylinder { // Cylndr23
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    translate  <0.0, -1.95, 8.5>
  }
  cylinder { // Cylndr22
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    translate  <-0.475, -1.95, 8.5>
  }
  cylinder { // Cylndr21
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    translate  <0.95, -1.95, 8.5>
  }
  cylinder { // Cylndr20
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    translate  <0.95, -1.4625, 8.5>
  }
  cylinder { // Cylndr19
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    translate  <0.95, -0.975, 8.5>
  }
  cylinder { // Cylndr18
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    translate  <0.95, -0.4875, 8.5>
  }
  cylinder { // Cylndr17
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    translate  <0.95, -0.0, 8.5>
  }
  cylinder { // Cylndr16
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    translate  <0.95, 0.4875, 8.5>
  }
  cylinder { // Cylndr15
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    translate  <0.95, 0.975, 8.5>
  }
  cylinder { // Cylndr14
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    translate  <0.95, 1.4625, 8.5>
  }
  cylinder { // Cylndr13
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    translate  <-0.95, -1.95, 8.5>
  }
  cylinder { // Cylndr12
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    translate  <-0.95, -1.4625, 8.5>
  }
  cylinder { // Cylndr11
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    translate  <-0.95, -0.975, 8.5>
  }
  cylinder { // Cylndr10
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    translate  <-0.95, -0.4875, 8.5>
  }
  cylinder { // Cylndr9
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    translate  <-0.95, -0.0, 8.5>
  }
  cylinder { // Cylndr8
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    translate  <-0.95, 0.4875, 8.5>
  }
  cylinder { // Cylndr7
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    translate  <-0.95, 0.975, 8.5>
  }
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    translate  <-0.95, 1.4625, 8.5>
  }
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    translate  <0.95, 1.95, 8.5>
  }
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    translate  <0.475, 1.95, 8.5>
  }
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    translate  <0.0, 1.95, 8.5>
  }
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    translate  <-0.475, 1.95, 8.5>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    translate  <-0.95, 1.95, 8.5>
  }
  texture {
    Texture2
    // Transform to world space
    translate <9.000000, 12.750000, -8.250000>
  }
}
//
// Include file contains 'RotSwp4'
//
#include "trans2.i11"
#declare RotSwp4 = object {
  RotSwp4_Raw
  rotate 90.0*z
  translate  <1.0, 2.0, 4.5>
}
//
// Include file contains 'RotSwp3'
//
#include "trans2.i12"
#declare RotSwp3 = object {
  RotSwp3_Raw
  rotate 180.0*z
  translate  <-1.0, 2.0, 4.5>
}
//
// Include file contains 'RotSwp2'
//
#include "trans2.i13"
#declare RotSwp2 = object {
  RotSwp2_Raw
  rotate -90.0*z
  translate  <-1.0, -2.0, 4.5>
}
//
// Include file contains 'RotSwp001'
//
#include "trans2.i14"
#declare RotSwp001 = object {
  RotSwp001_Raw
  translate  <1.0, -2.0, 4.5>
}
// Include contains 'TraSwp5'
#include "trans2.i15"

#declare TraSwp5 = object {
  TraSwp5_Raw
  rotate <90.0, -0.0, 90.0>
  translate  <-1.0, -2.0, 4.5>
}
// Include contains 'TraSwp4'
#include "trans2.i16"

#declare TraSwp4 = object {
  TraSwp4_Raw
  rotate <90.0, -0.0, -90.0>
  translate  <1.0, 2.0, 4.5>
}
// Include contains 'TraSwp3'
#include "trans2.i17"

#declare TraSwp3 = object {
  TraSwp3_Raw
  rotate <90.0, -0.0, 180.0>
  translate  <1.0, -2.0, 4.5>
}
// Include contains 'TraSwp002'
#include "trans2.i18"

#declare TraSwp002 = object {
  TraSwp002_Raw
  rotate <90.0, -0.0, 0.0>
  translate  <-1.0, 2.0, 4.5>
}
#declare CSG001 = union {
  object { RotSwp4 }
  object { RotSwp3 }
  object { RotSwp2 }
  object { RotSwp001 }
  object { TraSwp5 }
  object { TraSwp4 }
  object { TraSwp3 }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 2.0>
    translate  6.5*z
  }
  object { TraSwp002 }
  texture {
    Texture1
  }
}
union { // The_House
  object { CSG22 }
  object { CSG21 }
  object { CSG20 }
  object { CSG19 }
  object { CSG18 }
  object { CSG17 }
  object { TapSwp002 }
  object { CSG16 }
  object { CSG15 }
  object { CSG14 }
  object { CSG13 }
  object { CSG12 }
  object { CSG11 }
  object { TraSwp004 }
  object { CSG10 }
  object { CSG9 }
  object { CSG8 }
  object { CSG7 }
  object { CSG6 }
  object { CSG5 }
  cylinder { // Cylndr85
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture3
    }
    scale <1.0, 1.0, 4.0>
    translate  <10.0, 23.0, -10.5>
  }
  cylinder { // Cylndr84
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture3
    }
    scale <1.0, 1.0, 4.0>
    translate  <10.0, 23.0, -20.5>
  }
  cylinder { // Cylndr81
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture3
    }
    scale <1.0, 1.0, 4.0>
    translate  <10.0, 23.0, -30.5>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture3
    }
    scale <1.0, 1.0, 4.0>
    translate  <10.0, 23.0, -40.5>
  }
  object { RotSwp6 }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1
    scale <3.0, 3.0, 40.0>
    translate  <10.0, 20.0, -42.5>
    texture {
      Texture1
      // Transform to world space
      translate <9.000000, 12.750000, -8.250000>
    }
  }
  cylinder { // Cylndr115
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture1
    }
    scale <0.1, 0.1, 2.0>
    translate  <0.0, -32.0, -26.25>
  }
  cylinder { // Cylndr114
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture1
    }
    scale <0.1, 0.1, 2.0>
    translate  <0.0, -30.0, -26.25>
  }
  cylinder { // Cylndr113
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture1
    }
    scale <0.1, 0.1, 2.0>
    translate  <0.0, -28.0, -26.25>
  }
  cylinder { // Cylndr112
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture1
    }
    scale <0.1, 0.1, 2.0>
    translate  <0.0, -26.0, -26.25>
  }
  cylinder { // Cylndr111
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture1
    }
    scale <0.1, 0.1, 2.0>
    translate  <0.0, -24.0, -26.25>
  }
  cylinder { // Cylndr110
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture1
    }
    scale <0.1, 0.1, 2.0>
    translate  <0.0, -22.0, -26.25>
  }
  cylinder { // Cylndr109
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture1
    }
    scale <0.1, 0.1, 2.0>
    translate  <0.0, -20.0, -26.25>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture1
    }
    scale <0.4, 0.4, 12.0>
    rotate 90.0*x
    translate  <0.0, -20.0, -26.25>
  }
  object { TraSwp10 }
  object { TraSwp9 }
  object { TraSwp8 }
  object { TraSwp7 }
  object { TraSwp6 }
  object { TraSwp003 }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.0, 4.0>
    translate  <0.0, -19.5, -37.5>
    texture {
      DMFLightOak
      // Transform to world space
      translate <9.000000, 12.750000, -8.250000>
    }
  }
  object { RotSwp5 }
  object { RotSwp002 }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 6.0, 0.5>
    translate  <0.0, -26.0, -42.0>
    texture {
      DMFLightOak
      // Transform to world space
      translate <9.000000, 12.750000, -8.250000>
    }
  }
  object { TraSwp001 }
  cone { // Cone24
    <0,0,0>, 0.5, <0,0,1>, 0.0
    texture {
      Texture2
    }
    scale <1.0, 1.0, 3.0>
    translate  <10.0, -15.0, -10.5>
  }
  cone { // Cone23
    <0,0,0>, 0.5, <0,0,1>, 0.0
    texture {
      Texture2
    }
    scale <1.0, 1.0, 3.0>
    translate  <10.0, -10.0, -10.5>
  }
  cone { // Cone22
    <0,0,0>, 0.5, <0,0,1>, 0.0
    texture {
      Texture2
    }
    scale <1.0, 1.0, 3.0>
    translate  <10.0, -5.0, -10.5>
  }
  cone { // Cone21
    <0,0,0>, 0.5, <0,0,1>, 0.0
    texture {
      Texture2
    }
    scale <1.0, 1.0, 3.0>
    translate  <10.0, 0.0, -10.5>
  }
  cone { // Cone20
    <0,0,0>, 0.5, <0,0,1>, 0.0
    texture {
      Texture2
    }
    scale <1.0, 1.0, 3.0>
    translate  <10.0, 5.0, -10.5>
  }
  cone { // Cone19
    <0,0,0>, 0.5, <0,0,1>, 0.0
    texture {
      Texture2
    }
    scale <1.0, 1.0, 3.0>
    translate  <10.0, 10.0, -10.5>
  }
  cylinder { // Cylndr108
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.5, 0.5, 2.0>
    translate  <10.0, -15.0, -12.5>
  }
  cylinder { // Cylndr107
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.5, 0.5, 2.0>
    translate  <10.0, -10.0, -12.5>
  }
  cylinder { // Cylndr106
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.5, 0.5, 2.0>
    translate  <10.0, -5.0, -12.5>
  }
  cylinder { // Cylndr105
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.5, 0.5, 2.0>
    translate  <10.0, 0.0, -12.5>
  }
  cylinder { // Cylndr104
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.5, 0.5, 2.0>
    translate  <10.0, 5.0, -12.5>
  }
  cylinder { // Cylndr103
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.5, 0.5, 2.0>
    translate  <10.0, 10.0, -12.5>
  }
  cylinder { // Cylndr102
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.25, 0.25, 2.0>
    rotate -90.0*x
    translate  <10.0, -20.0, -11.0>
  }
  cylinder { // Cylndr101
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.25, 0.25, 4.0>
    rotate -90.0*x
    translate  <10.0, -17.0, -11.0>
  }
  cylinder { // Cylndr100
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.25, 0.25, 4.0>
    rotate -90.0*x
    translate  <10.0, -12.0, -11.0>
  }
  cylinder { // Cylndr99
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.25, 0.25, 4.0>
    rotate -90.0*x
    translate  <10.0, -7.0, -11.0>
  }
  cylinder { // Cylndr98
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.25, 0.25, 4.0>
    rotate -90.0*x
    translate  <10.0, -2.0, -11.0>
  }
  cylinder { // Cylndr97
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.25, 0.25, 4.0>
    rotate -90.0*x
    translate  <10.0, 3.0, -11.0>
  }
  cylinder { // Cylndr96
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.25, 0.25, 4.0>
    rotate -90.0*x
    translate  <10.0, 8.0, -11.0>
  }
  cylinder { // Cylndr95
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.5, 0.5, 2.0>
    translate  <10.0, 15.0, -12.5>
  }
  cone { // Cone18
    <0,0,0>, 0.5, <0,0,1>, 0.0
    texture {
      Texture2
    }
    scale <1.0, 1.0, 3.0>
    translate  <10.0, 15.0, -10.5>
  }
  cylinder { // Cylndr94
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.25, 0.25, 4.0>
    rotate -90.0*x
    translate  <10.0, 13.0, -11.0>
  }
  cylinder { // Cylndr93
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.5, 0.5, 2.0>
    translate  <10.0, -20.0, -12.5>
  }
  cylinder { // Cylndr92
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.5, 0.5, 2.0>
    translate  <5.0, -20.0, -12.5>
  }
  cylinder { // Cylndr91
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.5, 0.5, 2.0>
    translate  <0.0, -20.0, -12.5>
  }
  cone { // Cone17
    <0,0,0>, 0.5, <0,0,1>, 0.0
    texture {
      Texture2
    }
    scale <1.0, 1.0, 3.0>
    translate  <10.0, -20.0, -10.5>
  }
  cone { // Cone16
    <0,0,0>, 0.5, <0,0,1>, 0.0
    texture {
      Texture2
    }
    scale <1.0, 1.0, 3.0>
    translate  <5.0, -20.0, -10.5>
  }
  cone { // Cone15
    <0,0,0>, 0.5, <0,0,1>, 0.0
    texture {
      Texture2
    }
    scale <1.0, 1.0, 3.0>
    translate  <0.0, -20.0, -10.5>
  }
  cylinder { // Cylndr90
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.25, 0.25, 2.0>
    rotate -90.0*y
    translate  <10.0, -20.0, -11.0>
  }
  cylinder { // Cylndr89
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.25, 0.25, 4.0>
    rotate -90.0*y
    translate  <7.0, -20.0, -11.0>
  }
  cylinder { // Cylndr88
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.25, 0.25, 4.0>
    rotate -90.0*y
    translate  <2.0, -20.0, -11.0>
  }
  cone { // Cone14
    <0,0,0>, 0.5, <0,0,1>, 0.0
    texture {
      Texture2
    }
    scale <1.0, 1.0, 3.0>
    translate  <-5.0, -20.0, -10.5>
  }
  cylinder { // Cylndr87
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.5, 0.5, 2.0>
    translate  <-5.0, -20.0, -12.5>
  }
  cylinder { // Cylndr86
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.25, 0.25, 4.0>
    rotate -90.0*y
    translate  <-3.0, -20.0, -11.0>
  }
  cone { // Cone12
    <0,0,0>, 0.5, <0,0,1>, 0.0
    texture {
      Texture2
    }
    scale <1.0, 1.0, 3.0>
    translate  <5.0, 20.0, -10.5>
  }
  cone { // Cone11
    <0,0,0>, 0.5, <0,0,1>, 0.0
    texture {
      Texture2
    }
    scale <1.0, 1.0, 3.0>
    translate  <0.0, 20.0, -10.5>
  }
  cylinder { // Cylndr83
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.25, 0.25, 4.0>
    rotate -90.0*y
    translate  <7.0, 20.0, -11.0>
  }
  cylinder { // Cylndr82
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.25, 0.25, 4.0>
    rotate -90.0*y
    translate  <2.0, 20.0, -11.0>
  }
  cylinder { // Cylndr80
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.5, 0.5, 2.0>
    translate  <5.0, 20.0, -12.5>
  }
  cylinder { // Cylndr79
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.5, 0.5, 2.0>
    translate  <0.0, 20.0, -12.5>
  }
  cylinder { // Cylndr78
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.5, 0.5, 2.0>
    translate  <-5.0, 20.0, -12.5>
  }
  cone { // Cone10
    <0,0,0>, 0.5, <0,0,1>, 0.0
    texture {
      Texture2
    }
    scale <1.0, 1.0, 3.0>
    translate  <-5.0, 20.0, -10.5>
  }
  cylinder { // Cylndr77
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.25, 0.25, 4.0>
    rotate -90.0*y
    translate  <-3.0, 20.0, -11.0>
  }
  cylinder { // Cylndr76
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.25, 0.25, 2.0>
    rotate -90.0*y
    translate  <-8.0, -20.0, -11.0>
  }
  cone { // Cone9
    <0,0,0>, 0.5, <0,0,1>, 0.0
    texture {
      Texture2
    }
    scale <1.0, 1.0, 3.0>
    translate  <-10.0, -20.0, -10.5>
  }
  cone { // Cone8
    <0,0,0>, 0.5, <0,0,1>, 0.0
    texture {
      Texture2
    }
    scale <1.0, 1.0, 3.0>
    translate  <-10.0, -15.0, -10.5>
  }
  cone { // Cone7
    <0,0,0>, 0.5, <0,0,1>, 0.0
    texture {
      Texture2
    }
    scale <1.0, 1.0, 3.0>
    translate  <-10.0, -10.0, -10.5>
  }
  cone { // Cone6
    <0,0,0>, 0.5, <0,0,1>, 0.0
    texture {
      Texture2
    }
    scale <1.0, 1.0, 3.0>
    translate  <-10.0, -5.0, -10.5>
  }
  cone { // Cone5
    <0,0,0>, 0.5, <0,0,1>, 0.0
    texture {
      Texture2
    }
    scale <1.0, 1.0, 3.0>
    translate  <-10.0, 0.0, -10.5>
  }
  cone { // Cone4
    <0,0,0>, 0.5, <0,0,1>, 0.0
    texture {
      Texture2
    }
    scale <1.0, 1.0, 3.0>
    translate  <-10.0, 5.0, -10.5>
  }
  cone { // Cone3
    <0,0,0>, 0.5, <0,0,1>, 0.0
    texture {
      Texture2
    }
    scale <1.0, 1.0, 3.0>
    translate  <-10.0, 10.0, -10.5>
  }
  cylinder { // Cylndr75
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.25, 0.25, 2.0>
    rotate -90.0*x
    translate  <-10.0, -20.0, -11.0>
  }
  cylinder { // Cylndr74
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.25, 0.25, 4.0>
    rotate -90.0*x
    translate  <-10.0, -17.0, -11.0>
  }
  cylinder { // Cylndr73
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.25, 0.25, 4.0>
    rotate -90.0*x
    translate  <-10.0, -12.0, -11.0>
  }
  cylinder { // Cylndr72
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.25, 0.25, 4.0>
    rotate -90.0*x
    translate  <-10.0, -7.0, -11.0>
  }
  cylinder { // Cylndr71
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.25, 0.25, 4.0>
    rotate -90.0*x
    translate  <-10.0, -2.0, -11.0>
  }
  cylinder { // Cylndr70
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.25, 0.25, 4.0>
    rotate -90.0*x
    translate  <-10.0, 3.0, -11.0>
  }
  cylinder { // Cylndr69
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.25, 0.25, 4.0>
    rotate -90.0*x
    translate  <-10.0, 8.0, -11.0>
  }
  cylinder { // Cylndr68
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.5, 0.5, 2.0>
    translate  <-10.0, -20.0, -12.5>
  }
  cylinder { // Cylndr67
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.5, 0.5, 2.0>
    translate  <-10.0, -15.0, -12.5>
  }
  cylinder { // Cylndr66
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.5, 0.5, 2.0>
    translate  <-10.0, -10.0, -12.5>
  }
  cylinder { // Cylndr65
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.5, 0.5, 2.0>
    translate  <-10.0, -5.0, -12.5>
  }
  cylinder { // Cylndr64
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.5, 0.5, 2.0>
    translate  <-10.0, 0.0, -12.5>
  }
  cylinder { // Cylndr63
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.5, 0.5, 2.0>
    translate  <-10.0, 5.0, -12.5>
  }
  cylinder { // Cylndr62
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.5, 0.5, 2.0>
    translate  <-10.0, 10.0, -12.5>
  }
  cylinder { // Cylndr61
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.25, 0.25, 4.0>
    rotate -90.0*x
    translate  <-10.0, 13.0, -11.0>
  }
  cone { // Cone2
    <0,0,0>, 0.5, <0,0,1>, 0.0
    texture {
      Texture2
    }
    scale <1.0, 1.0, 3.0>
    translate  <-10.0, 15.0, -10.5>
  }
  cylinder { // Cylndr60
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.5, 0.5, 2.0>
    translate  <-10.0, 15.0, -12.5>
  }
  cylinder { // Cylndr59
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.25, 0.25, 2.0>
    rotate -90.0*y
    translate  <-8.0, 20.0, -11.0>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.25, 0.25, 2.0>
    rotate -90.0*x
    translate  <-10.0, 18.0, -11.0>
  }
  cone { // Cone001
    <0,0,0>, 0.5, <0,0,1>, 0.0
    texture {
      Texture2
    }
    scale <1.0, 1.0, 3.0>
    translate  <-10.0, 20.0, -10.5>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture2
    }
    scale <0.5, 0.5, 2.0>
    translate  <-10.0, 20.0, -12.5>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 20.0, 15.0>
    translate  -27.5*z
    texture {
      Texture1
      // Transform to world space
      translate <9.000000, 12.750000, -8.250000>
    }
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <4.5, 6.5, 4.0>
    translate  -8.5*z
    texture {
      Texture1
      // Transform to world space
      translate <9.000000, 12.750000, -8.250000>
    }
  }
  object { TapSwp001 }
  object { CSG4 }
  object { CSG003 }
  object { CSG002 }
  object { CSG001 }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <2.25, 3.25, 3.0>
    translate  1.5*z
    texture {
      Texture1
      // Transform to world space
      translate <9.000000, 12.750000, -8.250000>
    }
  }
  translate  <-8.0, 0.75, 6.25>
}
