
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc:
// Date:
// Auth: Nathan O'Brien
// Mail: no13@no13.net
// Webp: http://www.no13.net



plane {y, 0
	pigment{color rgb <.1,.1,.2>}
	normal {agate 0.1 scale .5}
	finish {phong 1 reflection 0.5}
}

fog {
    distance 3
    color rgbt<0.3, 0.3, 0.35,0.1>
    fog_type 2
    fog_offset 0.2
    fog_alt 0.3
    turbulence 2
    turb_depth 2
}

#declare Cloud1 =
pigment {
    bozo
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0 rgb <0.88,0.66,0.56>]
        [0.1 rgb <0.26,0.28,0.40>]
		[0.2 rgb <1.00,0.90,0.50>]
		[0.3 rgb <0.79,0.43,0.26>]
		[0.4 rgb <0.26,0.28,0.40>]
        [1.0 rgbf <1,1,1,1>]
    }
    scale <3,0.75,3> rotate <0,-90,0>
}

#declare Cloud2 =
pigment {
    wrinkles
    turbulence 0.5
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0 rgb <0.88,0.66,0.56>]
        [0.1 rgb <0.26,0.28,0.40>]
		[0.25 rgb <0.54,0.36,0.45>]
		[0.3 rgb <0.61,0.46,0.57>]
		[0.35 rgb <0.71,0.56,0.67>]
		[0.4 rgb <0.26,0.28,0.40>]
		[0.5 rgbf <1,1,1,1>]
        [1.0 rgbf <1,1,1,1>]
    }
    scale <3,1,3>
}

#declare Cloud3 =
pigment {
	granite
	turbulence 1
	color_map {
		[0.0 rgbf <1,1,1,1>]
		[0.025 rgb <2,2,4>]
		[0.075 rgbf <1,1,1,.5>]
		[0.15 rgbf <1,1,1,1>]
		[1.0 rgbf <1,1,1,1>]
	}
}

sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.0 rgb <0.88,0.66,0.56> ] // horizon
            [0.1 Cloud1 scale 0.25 rotate z*5]
            [0.60 Cloud2 scale <0.25, 0.15, 0.25> rotate z*10]
			[0.8 Cloud3 scale .2]
        }
		rotate <0,30,0>
    }
}



#declare Landform = height_field {tga "hfield.tga"
	pigment{image_map { gif "hfield.gif"} rotate x*90}
	translate <-0.5,0,-0.5>
	normal {wrinkles .5 scale <.05,.2,.05> rotate <0,0,-45>}
	finish {phong 0.25}
}

object {Landform scale <25,7,15> rotate <0,45,0> translate <5,-1.5,5>}


light_source {<7,6,4> color rgb <.5,.1,.1>
             fade_distance 3
             fade_power 1
}

#declare T_Logo =
	texture {
	pigment{color rgb <.4,.4,.8>}
	finish {phong 1 reflection 0.2}
}

#include "logo.inc"

object {Logo13 scale .2 rotate <90,15,0> translate <2.5,0.01,0.25> texture{T_Logo}}
