
//  Bird.inc    05/30/98  (C) Neil Alexander

/*camera {
  location  <500, 50, 300>
  look_at   <80, 25, -80>
  angle 45
  }

light_source {
  <18000000, 6000000, 0>
  color rgb <1,0.95,0.8>
  }
background { color rgb <0,0,1>}
*/

// ---------------- Wings ------------------------

#declare Outline = difference {
  cylinder { <0,0,0>,<0,7,0>,1
    scale <4,1,12>
    }
  plane {x,0}
  }  // end Outline

#declare Wings = intersection {
  union {
    difference { // right wing
      cylinder { <-2,0,0>,<6,0,0>,1
        scale <1,3,12>
        translate <0,0,-12.5>
        }
      cylinder { <-2,0,0>,<6,0,0>,1
        scale <1,3,11.5>
        translate <0,0,-12.5>
        }
      }
    difference { // left wing
      cylinder { <-2,0,0>,<6,0,0>,1
        scale <1,3,12>
        translate <0,0,12.5>
        }
      cylinder { <-2,0,0>,<6,0,0>,1
        scale <1,3,11.5>
        translate <0,0,12.5>
        }
      }
    } // end union
  object { Outline }
  }  // end Wings

#declare Bird = union {
  object { Wings }
  sphere {<6.5,0.55,-0.35>,0.25 // right eye
    texture {
      pigment { color rgb <0,0,0>}
      finish { phong 1 phong_size 100 }
      }
    }
  sphere {<6.5,0.55,0.35>,0.25 // left eye
    texture {
      pigment { color rgb <0,0,0>}
      finish { phong 1 phong_size 100 }
      }
    }
  blob {
    threshold 0.56
    sphere {<0,0,0>,1,1 // body
      scale <8,2,2.5>
      }
    sphere {<0,0,0>,1,1 // tail
      scale <1.5,0.25,2.5>
      rotate <0,0,15>
      translate <-4.5,0,0>
      }
    sphere {<0,0,0>,1,1 // head
      scale <2,1,1>
      rotate <0,0,-15>
      translate <4.5,0.5,0>
      }
    cylinder {<0,0,0>,<2,0,0>,1,1 // beak
      scale <1,0.375,0.25>
      rotate <0,0,-15>
      translate <4.5,0.5,0>
      }
    translate <1.5,0,0>
    }
  texture {
    pigment { onion
      color_map {
        [0.75  rgb <1,1,1>]
        [0.8  rgb <0.3,0.3,0.3>]
        }
      //rotate <0,0,90>
      scale 16
      translate <-5,0,0>
      }
    finish { ambient 0.5}
    normal { bumps 0.3 scale <1,0.25,0.25>}
    }

  }  // end Bird

/*object { Bird
  rotate <0,0,-30>
  rotate <0,-20,0>
  translate <280,100,80>
   }

object { Bird
  rotate <0,-90,20>
  //rotate <0,-20,0>
  translate <280,70,-80>
   }*/
